% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gmt.r
\name{GMT}
\alias{GMT}
\alias{gmt}
\alias{read.GMT}
\alias{write.GMT}
\alias{[.GMT}
\alias{[[.GMT}
\alias{$.GMT}
\alias{is.GMT}
\title{Read and Write GMT files}
\format{A GMT object is a named list of terms, where each term is a list with the items:
\describe{
    \item{id}{The term id}
    \item{name}{The full name of the term}
    \item{genes}{A character vector of genes annotated to this term}
  }}
\usage{
read.GMT(filename)

write.GMT(gmt, filename, path = ".")

\method{[}{GMT}(x, i)

\method{[[}{GMT}(x, i)

\method{$}{GMT}(x, i)

is.GMT(x)
}
\arguments{
\item{filename}{name of the GMT file}

\item{gmt}{a GMT object}

\item{path}{location of the GMT file}

\item{x}{object to test}

\item{i}{index of GMT object}
}
\value{
\code{read.GMT} returns a GMT object. \cr
\code{write.GMT} returns NULL. \cr
\code{is.GMT} returns TRUE if \code{x} is a GMT object, else FALSE
}
\description{
Functions to read and Write Gene Matrix Transposed (GMT) files and to test if
an object inherits from GMT
}
\details{
A GMT file describes gene sets, such as pathways. GMT files are tab delimeted
and each row contains a term id, a term name, and all genes annotated to the
term.
}
\examples{
gmt <- read.GMT(system.file('extdata', 'hsapiens_REAC_subset.gmt', package='ActivePathways'))
is.GMT(gmt)
gmt[1:10]
gmt[[1]]
gmt[1]$id
gmt[1]$genes
gmt[1]$name
gmt$`REAC:3108214`
\donttest{
  write.GMT(gmt, 'filename.gmt', path = tempdir())
}
}
