% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deprecated_functions.R
\name{integrate_tcr}
\alias{integrate_tcr}
\title{DEPRECATED: Integrate a single TCR library into Seurat object metadata}
\usage{
integrate_tcr(seurat_obj, tcr_file, verbose = TRUE)
}
\arguments{
\item{seurat_obj}{Seurat object}

\item{tcr_file}{\code{data.frame} of the T cell library generated by Cell Ranger.
It is very important that the row with cell barcodes is strictly named
\code{"barcode"}, which is the default name of barcodes in 10X's
\code{all_contig_annotations.csv} file.}

\item{verbose}{if \code{TRUE}, will display a progress bar to the R console.}
}
\value{
Returns a new Seurat object with new elements in the metadata
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

\emph{\strong{ALL v0.1.x functions are deprecated}}, and the workflow has been completely revamped - now depending on the scRepertoire v2 package - which allows for the processing of multi-sampled single cell data. Please read the vignettes with \code{browseVignettes("APackOfTheClones")}or visit https://qile0317.github.io/APackOfTheClones/

Modifies a \code{Seurat} object's metadata by taking all the columns
of the \code{all_contig_annotations.csv}, and adding new elements to
\code{seurat_obj@meta.data}, corresponding to each cells' barcodes and handling
duplicates (since the sequencing of TRA and TRB genes creates multiple data
points for the same cell).
}
\details{
Columns from cells (barcodes) that had duplicates in another row are
concatenated into strings, separated by \verb{__} in the metadata element.
Barcodes from the TCR library that had no matches to barcodes in the
\code{seurat_obj} will add \code{NA}s for all elements of the same index.
}
\examples{
library(Seurat)
library(APackOfTheClones)
data("mini_clonotype_data","mini_seurat_obj")

# integrate the TCR data into new seurat object
integrated_seurat_object <- integrate_tcr(
    mini_seurat_obj, mini_clonotype_data, verbose = FALSE
)

integrated_seurat_object

}
\references{
atakanekiz (2019) Tutorial:Integrating VDJ sequencing data with Seurat.
\verb{https://www.biostars.org/p/384640/}
}
\keyword{internal}
