% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_species_state_origin_matrix.R
\name{create_species_state_origin_matrix}
\alias{create_species_state_origin_matrix}
\title{Process geographic data and return state level species origin and diversity counts}
\usage{
create_species_state_origin_matrix(resources = load_taxonomic_resources())
}
\arguments{
\item{resources}{the taxonomic resources required to make the summary statistics.  Loading this can be slow, so call load_taxonomic_resources separately to greatly speed this function up and pass the resources in.}
}
\value{
A tibble with columns representing each state and rows representing each species. The values in each cell represent the origin of the species in that state.
}
\description{
This function processes the geographic data available in the current or any version of the Australian Plant Census and returns state level diversity for native, introduced and more complicated species origins.
}
\examples{
\donttest{create_species_state_origin_matrix()}



}
\seealso{
\code{\link{load_taxonomic_resources}}

Other diversity methods: 
\code{\link{native_anywhere_in_australia}()},
\code{\link{state_diversity_counts}()}
}
\concept{diversity methods}
