% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{apci.plot}
\alias{apci.plot}
\title{Plotting age and period raw scores and APC-I model results}
\usage{
apci.plot(
  model,
  age,
  period,
  outcome_var,
  type = "model",
  quantile = NULL,
  ...
)
}
\arguments{
\item{model}{A list recording the results from function \code{apci}.}

\item{age}{An object of class character representing the age group index
taking on a small number of distinct values in the data. Usually, the vector
should be converted to a factor (or the terms of "category" and "enumerated
type").}

\item{period}{An object of class character, similar to the argument of age,
representing the time period index in the data.}

\item{outcome_var}{An object of class character indicating
the name of the outcome variable used in the model. The
outcome variable can be a continuous, binary, categorical, or count variable.}

\item{type}{Character, "explore" or "model". If type is "explore",
plots for age and period raw scores will be generated. If type is
"model", model results will be plotted. The default setting is "model".}

\item{quantile}{A number valued between 0 and 1, representing the
desirable percentiles to be used in visualizing the data or model.
If \code{NULL}, the original scale of the outcome variable will be used.}

\item{\dots}{Additional arguments to be passed to the function.}
}
\value{
A plot with three panels showing the raw scores or APC-I
model results.
}
\description{
Arranging data exploration and model results representation
in a harmonized way.
}
\examples{
# load package
library("APCI")
# load data
test_data <- APCI::women9017
test_data$acc <- as.factor(test_data$acc)
test_data$pcc <- as.factor(test_data$pcc)
test_data$educc <- as.factor(test_data$educc)
test_data$educr <- as.factor(test_data$educr)

# fit APC-I model
APC_I <- APCI::apci(outcome = "inlfc",
                    age = "acc",
                    period = "pcc",
                    cohort = "ccc",
                    weight = "wt",
                    data = test_data,dev.test=FALSE,
                    print = TRUE,
                    family = "gaussian")
summary(APC_I)

## plot the raw pattern
apci.plot(data = test_data, outcome_var = "inlfc", age = "acc",model=APC_I,
          period = "pcc", type = "explore")
## plot the model results
apci.plot(data = test_data, outcome_var = "inlfc", age = "acc",model=APC_I,
          period = "pcc", type = "model")
}
