% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/join_microorganisms.R
\name{join}
\alias{join}
\alias{inner_join_microorganisms}
\alias{inner_join}
\alias{left_join_microorganisms}
\alias{right_join_microorganisms}
\alias{full_join_microorganisms}
\alias{semi_join_microorganisms}
\alias{anti_join_microorganisms}
\title{Join a table with \link{microorganisms}}
\usage{
inner_join_microorganisms(x, by = NULL, suffix = c("2", ""), ...)

left_join_microorganisms(x, by = NULL, suffix = c("2", ""), ...)

right_join_microorganisms(x, by = NULL, suffix = c("2", ""), ...)

full_join_microorganisms(x, by = NULL, suffix = c("2", ""), ...)

semi_join_microorganisms(x, by = NULL, ...)

anti_join_microorganisms(x, by = NULL, ...)
}
\arguments{
\item{x}{existing table to join, or character vector}

\item{by}{a variable to join by - if left empty will search for a column with class \code{\link{mo}} (created with \code{\link[=as.mo]{as.mo()}}) or will be \code{"mo"} if that column name exists in \code{x}, could otherwise be a column name of \code{x} with values that exist in \code{microorganisms$mo} (like \code{by = "bacteria_id"}), or another column in \link{microorganisms} (but then it should be named, like \code{by = c("my_genus_species" = "fullname")})}

\item{suffix}{if there are non-joined duplicate variables in \code{x} and \code{y}, these suffixes will be added to the output to disambiguate them. Should be a character vector of length 2.}

\item{...}{other parameters to pass on to \code{\link[dplyr:join]{dplyr::join()}}}
}
\description{
Join the data set \link{microorganisms} easily to an existing table or character vector.
}
\details{
\strong{Note:} As opposed to the \code{\link[dplyr:join]{dplyr::join()}} functions of \code{dplyr}, \code{\link{character}} vectors are supported and at default existing columns will get a suffix \code{"2"} and the newly joined columns will not get a suffix. See \code{\link[dplyr:join]{dplyr::join()}} for more information.
}
\section{Read more on our website!}{

On our website \url{https://msberends.gitlab.io/AMR} you can find \href{https://msberends.gitlab.io/AMR/articles/AMR.html}{a tutorial} about how to conduct AMR analysis, the \href{https://msberends.gitlab.io/AMR/reference}{complete documentation of all functions} (which reads a lot easier than here in R) and \href{https://msberends.gitlab.io/AMR/articles/WHONET.html}{an example analysis using WHONET data}.
}

\examples{
left_join_microorganisms(as.mo("K. pneumoniae"))
left_join_microorganisms("B_KLBSL_PNE")

library(dplyr)
example_isolates \%>\% left_join_microorganisms()

df <- data.frame(date = seq(from = as.Date("2018-01-01"),
                            to = as.Date("2018-01-07"),
                            by = 1),
                 bacteria = as.mo(c("S. aureus", "MRSA", "MSSA", "STAAUR",
                                    "E. coli", "E. coli", "E. coli")),
                 stringsAsFactors = FALSE)
colnames(df)
df_joined <- left_join_microorganisms(df, "bacteria")
colnames(df_joined)
}
