% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mo_property.R
\name{mo_property}
\alias{mo_property}
\alias{mo_name}
\alias{mo_fullname}
\alias{mo_shortname}
\alias{mo_subspecies}
\alias{mo_species}
\alias{mo_genus}
\alias{mo_family}
\alias{mo_order}
\alias{mo_class}
\alias{mo_phylum}
\alias{mo_kingdom}
\alias{mo_type}
\alias{mo_gramstain}
\alias{mo_ref}
\alias{mo_authors}
\alias{mo_year}
\alias{mo_rank}
\alias{mo_taxonomy}
\alias{mo_synonyms}
\alias{mo_info}
\alias{mo_url}
\title{Property of a microorganism}
\usage{
mo_name(x, language = get_locale(), ...)

mo_fullname(x, language = get_locale(), ...)

mo_shortname(x, language = get_locale(), ...)

mo_subspecies(x, language = get_locale(), ...)

mo_species(x, language = get_locale(), ...)

mo_genus(x, language = get_locale(), ...)

mo_family(x, language = get_locale(), ...)

mo_order(x, language = get_locale(), ...)

mo_class(x, language = get_locale(), ...)

mo_phylum(x, language = get_locale(), ...)

mo_kingdom(x, language = get_locale(), ...)

mo_type(x, language = get_locale(), ...)

mo_gramstain(x, language = get_locale(), ...)

mo_ref(x, ...)

mo_authors(x, ...)

mo_year(x, ...)

mo_rank(x, ...)

mo_taxonomy(x, language = get_locale(), ...)

mo_synonyms(x, ...)

mo_info(x, language = get_locale(), ...)

mo_url(x, open = FALSE, ...)

mo_property(x, property = "fullname", language = get_locale(), ...)
}
\arguments{
\item{x}{any (vector of) text that can be coerced to a valid microorganism code with \code{\link{as.mo}}}

\item{language}{language of the returned text, defaults to system language (see \code{\link{get_locale}}) and can also be set with \code{\link{getOption}("AMR_locale")}. Use \code{language = NULL} or \code{language = ""} to prevent translation.}

\item{...}{other parameters passed on to \code{\link{as.mo}}}

\item{open}{browse the URL using \code{\link[utils]{browseURL}()}}

\item{property}{one of the column names of the \code{\link{microorganisms}} data set or \code{"shortname"}}
}
\value{
\itemize{
  \item{An \code{integer} in case of \code{mo_year}}
  \item{A \code{list} in case of \code{mo_taxonomy}}
  \item{A named \code{character} in case of \code{mo_url}}
  \item{A \code{character} in all other cases}
}
}
\description{
Use these functions to return a specific property of a microorganism from the \code{\link{microorganisms}} data set. All input values will be evaluated internally with \code{\link{as.mo}}.
}
\details{
All functions will return the most recently known taxonomic property according to the Catalogue of Life, except for \code{mo_ref}, \code{mo_authors} and \code{mo_year}. This leads to the following results:
\itemize{
  \item{\code{mo_name("Chlamydia psittaci")} will return \code{"Chlamydophila psittaci"} (with a warning about the renaming)}
  \item{\code{mo_ref("Chlamydia psittaci")} will return \code{"Page, 1968"} (with a warning about the renaming)}
  \item{\code{mo_ref("Chlamydophila psittaci")} will return \code{"Everett et al., 1999"} (without a warning)}
}

The Gram stain - \code{mo_gramstain()} - will be determined on the taxonomic kingdom and phylum. According to Cavalier-Smith (2002) who defined subkingdoms Negibacteria and Posibacteria, only these phyla are Posibacteria: Actinobacteria, Chloroflexi, Firmicutes and Tenericutes. These bacteria are considered Gram positive - all other bacteria are considered Gram negative. Species outside the kingdom of Bacteria will return a value \code{NA}.

All output will be \link{translate}d where possible.

The function \code{mo_url()} will return the direct URL to the online database entry, which also shows the scientific reference of the concerned species.
}
\section{Catalogue of Life}{

\if{html}{\figure{logo_col.png}{options: height=40px style=margin-bottom:5px} \cr}
This package contains the complete taxonomic tree of almost all microorganisms (~65,000 species) from the authoritative and comprehensive Catalogue of Life (\url{http://www.catalogueoflife.org}). The Catalogue of Life is the most comprehensive and authoritative global index of species currently available.

\link[=catalogue_of_life]{Click here} for more information about the included taxa. The Catalogue of Life releases updates annually; check which version was included in this package with \code{\link{catalogue_of_life_version}()}.
}

\section{Source}{

[1] Becker K \emph{et al.} \strong{Coagulase-Negative Staphylococci}. 2014. Clin Microbiol Rev. 27(4): 870–926. \url{https://dx.doi.org/10.1128/CMR.00109-13}

[2] Becker K \emph{et al.} \strong{Implications of identifying the recently defined members of the \emph{S. aureus} complex, \emph{S. argenteus} and \emph{S. schweitzeri}: A position paper of members of the ESCMID Study Group for staphylococci and Staphylococcal Diseases (ESGS).} 2019. Clin Microbiol Infect. \url{https://doi.org/10.1016/j.cmi.2019.02.028}

[3] Lancefield RC \strong{A serological differentiation of human and other groups of hemolytic streptococci}. 1933. J Exp Med. 57(4): 571–95. \url{https://dx.doi.org/10.1084/jem.57.4.571}

[4] Catalogue of Life: Annual Checklist (public online taxonomic database), \url{http://www.catalogueoflife.org} (check included annual version with \code{\link{catalogue_of_life_version}()}).
}

\section{Read more on our website!}{

On our website \url{https://msberends.gitlab.io/AMR} you can find \href{https://msberends.gitlab.io/AMR/articles/AMR.html}{a tutorial} about how to conduct AMR analysis, the \href{https://msberends.gitlab.io/AMR/reference}{complete documentation of all functions} (which reads a lot easier than here in R) and \href{https://msberends.gitlab.io/AMR/articles/WHONET.html}{an example analysis using WHONET data}.
}

\examples{
## taxonomic tree
mo_kingdom("E. coli")         # "Bacteria"
mo_phylum("E. coli")          # "Proteobacteria"
mo_class("E. coli")           # "Gammaproteobacteria"
mo_order("E. coli")           # "Enterobacteriales"
mo_family("E. coli")          # "Enterobacteriaceae"
mo_genus("E. coli")           # "Escherichia"
mo_species("E. coli")         # "coli"
mo_subspecies("E. coli")      # ""

## colloquial properties
mo_name("E. coli")            # "Escherichia coli"
mo_fullname("E. coli")        # "Escherichia coli", same as mo_name()
mo_shortname("E. coli")       # "E. coli"

## other properties
mo_gramstain("E. coli")       # "Gram-negative"
mo_type("E. coli")            # "Bacteria" (equal to kingdom, but may be translated)
mo_rank("E. coli")            # "species"
mo_url("E. coli")             # get the direct url to the online database entry
mo_synonyms("E. coli")        # get previously accepted taxonomic names

## scientific reference
mo_ref("E. coli")             # "Castellani et al., 1919"
mo_authors("E. coli")         # "Castellani et al."
mo_year("E. coli")            # 1919


# Abbreviations known in the field
mo_genus("MRSA")              # "Staphylococcus"
mo_species("MRSA")            # "aureus"
mo_shortname("MRSA")          # "S. aureus"
mo_gramstain("MRSA")          # "Gram-positive"

mo_genus("VISA")              # "Staphylococcus"
mo_species("VISA")            # "aureus"


# Known subspecies
mo_name("doylei")             # "Campylobacter jejuni doylei"
mo_genus("doylei")            # "Campylobacter"
mo_species("doylei")          # "jejuni"
mo_subspecies("doylei")       # "doylei"

mo_fullname("K. pneu rh")     # "Klebsiella pneumoniae rhinoscleromatis"
mo_shortname("K. pneu rh")    # "K. pneumoniae"


# Becker classification, see ?as.mo
mo_fullname("S. epi")                     # "Staphylococcus epidermidis"
mo_fullname("S. epi", Becker = TRUE)      # "Coagulase-negative Staphylococcus (CoNS)"
mo_shortname("S. epi")                    # "S. epidermidis"
mo_shortname("S. epi", Becker = TRUE)     # "CoNS"

# Lancefield classification, see ?as.mo
mo_fullname("S. pyo")                     # "Streptococcus pyogenes"
mo_fullname("S. pyo", Lancefield = TRUE)  # "Streptococcus group A"
mo_shortname("S. pyo")                    # "S. pyogenes"
mo_shortname("S. pyo", Lancefield = TRUE) # "GAS" ('Group A streptococci')


# language support for German, Dutch, Spanish, Portuguese, Italian and French
mo_gramstain("E. coli", language = "de")  # "Gramnegativ"
mo_gramstain("E. coli", language = "nl")  # "Gram-negatief"
mo_gramstain("E. coli", language = "es")  # "Gram negativo"

# mo_type is equal to mo_kingdom, but mo_kingdom will remain official
mo_kingdom("E. coli")                     # "Bacteria" on a German system
mo_type("E. coli")                        # "Bakterien" on a German system
mo_type("E. coli")                        # "Bacteria" on an English system

mo_fullname("S. pyogenes",
            Lancefield = TRUE,
            language = "de")              # "Streptococcus Gruppe A"
mo_fullname("S. pyogenes",
            Lancefield = TRUE,
            language = "nl")              # "Streptococcus groep A"


# get a list with the complete taxonomy (from kingdom to subspecies)
mo_taxonomy("E. coli")
# get a list with the taxonomy, the authors and the URL to the online database
mo_info("E. coli")
}
\seealso{
\code{\link{microorganisms}}
}
