% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Generics.R, R/Utils-voxel.R
\docType{methods}
\name{clear}
\alias{clear}
\alias{clear,VoxelSpace,data.table-method}
\alias{clear,VoxelSpace,vector-method}
\alias{clear,VoxelSpace,matrix-method}
\title{Clear voxel}
\usage{
clear(vxsp, vx)

\S4method{clear}{VoxelSpace,data.table}(vxsp, vx)

\S4method{clear}{VoxelSpace,vector}(vxsp, vx)

\S4method{clear}{VoxelSpace,matrix}(vxsp, vx)
}
\arguments{
\item{vxsp}{a \code{\link{VoxelSpace-class}} object.}

\item{vx}{(i, j, k) voxel coordinates as a \link[data.table:data.table]{data.table::data.table} with
i, j, k columns, a vector (i, j, k) or a matrix with i, j, k columns.}
}
\description{
Clear a set of voxels. Clearing means that the state variables
of the selected voxels are altered as if they were \emph{clear} of any vegetation.
Namely:
\itemize{
\item{number of echo set to zero}
\item{intercepted beam surface set to zero (if variable is outputed)}
\item{plant area density set to zero (if variable is outputed)}
\item{transmittance set to one (if variable is outputed)}
\item{any attenuation variable set to zero}
}
Other state variables such as sampling intensity, mean angle, entering beam
surface, etc. are unaltered. A cleared voxel is not the same as an unsampled
voxel (not "crossed" by any beam).
}
\examples{
# load a voxel file
vxsp <- readVoxelSpace(system.file("extdata", "tls_sample.vox", package = "AMAPVox"))
# clear 1st voxel
clear(vxsp, c(0, 0, 0)) # clear 1st voxel
# clear butterflies
clear(vxsp, butterfly(vxsp))
# clear voxels with less than two hits
clear(vxsp, vxsp@data[nbEchos < 2])

}
