% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AFMPSDAnalyser.R
\docType{methods}
\name{getNyquistSpatialFrequency}
\alias{getNyquistSpatialFrequency}
\alias{getNyquistSpatialFrequency,AFMImage-method}
\title{Get the Nyquist spatial frequency}
\usage{
getNyquistSpatialFrequency(AFMImage)

\S4method{getNyquistSpatialFrequency}{AFMImage}(AFMImage)
}
\arguments{
\item{AFMImage}{an \code{\link{AFMImage}} from Atomic Force Microscopy}
}
\value{
the Nyquist spatial frequency of the \code{\link{AFMImage}}
}
\description{
Get the Nyquist spatial frequency of an \code{\link{AFMImage}} calculated as following:\cr
0.5 multiplied by the minimum between the horizontal scansize divided by the number of samples per line and the vertical scansize divided by the number of lines
}
\details{
\code{getNyquistSpatialFrequency} returns the Nyquist spatial frequency as a numeric
}
\examples{
library(AFM)

data(AFMImageOfNormallyDistributedHeights)
NyquistSpatialFrequency<-getNyquistSpatialFrequency(AFMImageOfNormallyDistributedHeights)
print(NyquistSpatialFrequency)

}
\author{
M.Beauvais
}
