% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AFcs.R
\name{AF.cs}
\alias{AF.cs}
\title{Attributable fraction for cross-sectional sampling designs. NOTE! Deprecated function. Use \code{\link[AF]{AFglm}}.}
\usage{
AF.cs(formula, data, exposure, clusterid)
}
\arguments{
\item{formula}{an object of class "\code{\link{formula}}" (or one that can be coerced to that class): a symbolic description of the model used for adjusting for confounders. The exposure and confounders should be specified as independent (right-hand side) variables. The outcome should be specified as dependent (left-hand side) variable. The formula is used to object a logistic regression by \code{\link[stats]{glm}}.}

\item{data}{an optional data frame, list or environment (or object coercible by \code{as.data.frame} to a data frame) containing the variables in the model. If not found in data, the variables are taken from environment (\code{formula}), typically the environment from which the function is called.}

\item{exposure}{the name of the exposure variable as a string. The exposure must be binary (0/1) where unexposed is coded as 0.}

\item{clusterid}{the name of the cluster identifier variable as a string, if data are clustered.}
}
\value{
\item{AF.est}{estimated attributable fraction.}

\item{AF.var}{estimated variance of \code{AF.est}. The variance is obtained by combining the delta method with the sandwich formula.}

\item{P.est}{estimated factual proportion of cases; \eqn{Pr(Y=1)}.}

\item{P.var}{estimated variance of \code{P.est}. The variance is obtained by the sandwich formula.}

\item{P0.est}{estimated counterfactual proportion of cases if exposure would be eliminated; \eqn{Pr(Y_0=1)}{Pr(Y0=1)}.}

\item{P0.var}{estimated variance of \code{P0.est}. The variance is obtained by the sandwich formula.}

\item{object}{the fitted model. Fitted using logistic regression, \code{\link{glm}}.}
}
\description{
\code{AF.cs} estimates the model-based adjusted attributable fraction for data from cross-sectional sampling designs.
}
\details{
\code{Af.cs} estimates the attributable fraction for a binary outcome \code{Y}
under the hypothetical scenario where a binary exposure \code{X} is eliminated from the population.
The estimate is adjusted for confounders \code{Z} by logistic regression (\code{\link{glm}}).
Let the AF be defined as
\deqn{AF=1-\frac{Pr(Y_0=1)}{Pr(Y=1)}}{AF = 1 - Pr(Y0 = 1) / Pr(Y = 1)}
where \eqn{Pr(Y_0=1)}{Pr(Y0 = 1)} denotes the counterfactual probability of the outcome if
the exposure would have been eliminated from the population and \eqn{Pr(Y = 1)} denotes the factual probability of the outcome.
If \code{Z} is sufficient for confounding control, then \eqn{Pr(Y_0=1)}{Pr(Y0 = 1)} can be expressed as
 \eqn{E_Z\{Pr(Y=1\mid{X=0,Z})\}.}{E_z{Pr(Y = 1  |X = 0,Z)}.}
The function uses logistic regression to estimate \eqn{Pr(Y=1\mid{X=0,Z})}{Pr(Y=1|X=0,Z)}, and the marginal sample distribution of \code{Z}
to approximate the outer expectation (\enc{Sjölander}{Sjolander} and Vansteelandt, 2012).
If \code{clusterid} is supplied, then a clustered sandwich formula is used in all variance calculations.
}
\examples{
# Simulate a cross-sectional sample
expit <- function(x) 1 / (1 + exp( - x))
n <- 1000
Z <- rnorm(n = n)
X <- rbinom(n = n, size = 1, prob = expit(Z))
Y <- rbinom(n = n, size = 1, prob = expit(Z + X))

# Example 1: non clustered data from a cross-sectional sampling design
data <- data.frame(Y, X, Z)

# Estimation of the attributable fraction
AF.cs_est <- AF.cs(formula = Y ~ X + Z + X * Z, data = data, exposure = "X")
summary(AF.cs_est)

# Example 2: clustered data from a cross-sectional sampling design
# Duplicate observations in order to create clustered data
id <- rep(1:n, 2)
data <- data.frame(id = id, Y = c(Y, Y), X = c(X, X), Z = c(Z, Z))

# Estimation of the attributable fraction
AF.cs_clust <- AF.cs(formula = Y ~ X + Z + X * Z, data = data,
                         exposure = "X", clusterid = "id")
summary(AF.cs_clust)
}
\references{
Greenland, S. and Drescher, K. (1993). Maximum Likelihood Estimation of the Attributable Fraction from logistic Models. \emph{Biometrics} \bold{49}, 865-872.

\enc{Sjölander}{Sjolander}, A. and Vansteelandt, S. (2011). Doubly robust estimation of attributable fractions. \emph{Biostatistics} \bold{12}, 112-121.
}
\seealso{
The new and more general version of the function: \code{\link[AF]{AFglm}}.
}
\author{
Elisabeth Dahlqwist, Arvid \enc{Sjölander}{Sjolander}
}
