% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.RevBayes.R
\name{read.RevBayes}
\alias{read.RevBayes}
\title{read RevBayes log file}
\usage{
read.RevBayes(x, n_times, max_t = 100, n_samples = 20, summary_type = "none", 
extinction_prefix = "extinction_rate.", speciation_prefix = "speciation_rate.")
}
\arguments{
\item{x}{path to log, or data frame}

\item{n_times}{number of time knots}

\item{max_t}{tree height}

\item{n_samples}{first n posterior samples}

\item{summary_type}{either "none" for all the posterior samples, or "mean" or "median" for the posterior mean/median}

\item{extinction_prefix}{the prefix string for the extinction rate column names. Must be unique}

\item{speciation_prefix}{the prefix string for the speciation rate column names. Must be unique}
}
\value{
a set of ACDC models, each being a sample in the posterior
}
\description{
read RevBayes log file
}
\examples{
data(primates_ebd_log)
posterior <- read.RevBayes(primates_ebd_log, n_times = 500, max_t = 65, n_samples = 20)
}
