% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{drug_deaths}
\alias{drug_deaths}
\title{Drug deaths of white men in the United States}
\format{
A dataframe containing
\describe{
\item{period}{Calendar year}
\item{age}{Age group.}
\item{deaths}{Number of observed unintentional drug overdose deaths in the
respective age group and calendar year.}
\item{population}{Number of white men in the respective age group and
calendar year in the U.S. population.}
\item{mortality_rate}{Drug overdose mortality rate for the respective age
group and calendar year, reported as the number of deaths per 100,000
people. Calculated as \code{100000 * deaths / population}.}
}
}
\usage{
data(drug_deaths)
}
\description{
Dataset on the number of unintentional drug overdose deaths in the United
States for each age group between 1999 and 2019, retrieved from the CDC
WONDER Online Database. The data only cover white men.
}
\details{
The data were exported from the CDC WONDER Online Database (see link in
references down below), based on the following settings:
\itemize{
\item Group by \emph{Year} and by \emph{Single-Year Ages}
\item Demographics: Gender \emph{Male}; Ethnicity \emph{White}
\item Cause of death: \emph{Drug / Alcohol Induced Causes}. Then select the more
specific category \emph{Drug poisonings (overdose) Unintentional (X40-X44)}.
}
}
\references{
Jalal, H., & Burke, D. S. (2020). Hexamaps for Age-Period-Cohort Data
Visualization and Implementation in R. \emph{Epidemiology (Cambridge, Mass.)},
31(6), e47.
\doi{10.1097/EDE.0000000000001236}.

Centers for Disease Control and Prevention, National Center for Health
Statistics. Underlying Cause of Death 1999-2019 on CDC WONDER Online Database,
released in 2020. Data are from the Multiple Cause of Death Files, 1999-2019,
as compiled from data provided by the 57 vital statistics jurisdictions
through the Vital Statistics Cooperative Program. Accessed at
\href{https://wonder.cdc.gov/ucd-icd10.html}{wonder.cdc.gov/ucd-icd10.html}
on 18 June 2025.
}
\keyword{datasets}
