







#[cfg(feature = "std")]
use num_traits::Float;
use num_traits::{One, Zero};

#[cfg(feature = "std")]
use std::fmt;
use std::ops::{Add, Div, Mul, Sub};
#[cfg(feature = "std")]
use std::ops::{AddAssign, DivAssign, MulAssign, RemAssign, SubAssign};

#[cfg(feature = "std")]
use crate::ScalarOperand;





pub trait LinalgScalar:
    'static
    + Copy
    + Zero
    + One
    + Add<Output = Self>
    + Sub<Output = Self>
    + Mul<Output = Self>
    + Div<Output = Self>
{
}

impl<T> LinalgScalar for T where
    T: 'static
        + Copy
        + Zero
        + One
        + Add<Output = T>
        + Sub<Output = T>
        + Mul<Output = T>
        + Div<Output = T>
{
}









#[cfg(feature = "std")]
pub trait NdFloat:
    Float
    + AddAssign
    + SubAssign
    + MulAssign
    + DivAssign
    + RemAssign
    + fmt::Display
    + fmt::Debug
    + fmt::LowerExp
    + fmt::UpperExp
    + ScalarOperand
    + LinalgScalar
    + Send
    + Sync
{
}

#[cfg(feature = "std")]
impl NdFloat for f32 {}
#[cfg(feature = "std")]
impl NdFloat for f64 {}

