% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/screen.R
\name{create_payload}
\alias{create_payload}
\title{Create a Payload for the Yahoo Finance API}
\usage{
create_payload(sec_type = "equity", query = NULL, size = 25,
  offset = 0, sort_field = NULL, sort_type = NULL,
  top_operator = "and")
}
\arguments{
\item{sec_type}{string. Type of security to search
(i.e., "equity", "mutualfund", "etf", "index", "future").}

\item{query}{list. Structured query to filter results created by
the \code{\link{create_query}} function.}

\item{size}{integer. Number of results to return.}

\item{offset}{integer. Starting position of the results.}

\item{sort_field}{string. Field to sort the results.}

\item{sort_type}{string. Type of sort to apply (i.e., "asc", "desc").}

\item{top_operator}{string. Logical operator for the top-level of the query
(i.e., "and", "or")}
}
\value{
A list representing the payload to be sent to the Yahoo Finance API
with the specified parameters.
}
\description{
A function to create a payload to query the Yahoo Finance API with customizable parameters.
}
\examples{
filters <- list(
  list("eq", list("region", "us")),
  list("btwn", list("intradaymarketcap", 2000000000, 10000000000)),
  list("btwn", list("intradaymarketcap", 10000000000, 100000000000)),
  list("gt", list("intradaymarketcap", 100000000000)),
  list("gt", list("dayvolume", 5000000))
)

query <- create_query(filters)

payload <- create_payload("equity", query)
}
