% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check-metric.R
\name{check_metric}
\alias{check_metric}
\alias{check_numeric_metric}
\alias{check_class_metric}
\alias{check_prob_metric}
\alias{check_dynamic_survival_metric}
\alias{check_static_survival_metric}
\title{Developer function for checking inputs in new metrics}
\usage{
check_numeric_metric(truth, estimate, case_weights, call = caller_env())

check_class_metric(
  truth,
  estimate,
  case_weights,
  estimator,
  call = caller_env()
)

check_prob_metric(
  truth,
  estimate,
  case_weights,
  estimator,
  call = caller_env()
)

check_dynamic_survival_metric(
  truth,
  estimate,
  case_weights,
  call = caller_env()
)

check_static_survival_metric(
  truth,
  estimate,
  case_weights,
  call = caller_env()
)
}
\arguments{
\item{truth}{The realized vector of \code{truth}.
\itemize{
\item For \code{check_numeric_metric()}, a numeric vector.
\item For \code{check_class_metric()}, a factor.
\item For \code{check_prob_metric()}, a factor.
\item For \code{check_dynamic_survival_metric()}, a Surv object.
\item For \code{check_static_survival_metric()}, a Surv object.
}}

\item{estimate}{The realized \code{estimate} result.
\itemize{
\item For \code{check_numeric_metric()}, a numeric vector.
\item For \code{check_class_metric()}, a factor.
\item For \code{check_prob_metric()}, a numeric vector for binary \code{truth},
a numeric matrix for multic-class \code{truth}.
\item For \code{check_dynamic_survival_metric()}, list-column of data.frames.
\item For \code{check_static_survival_metric()}, a numeric vector.
}}

\item{case_weights}{The realized case weights, as a numeric vector. This must
be the same length as \code{truth}.}

\item{call}{The execution environment of a currently
running function, e.g. \code{caller_env()}. The function will be
mentioned in error messages as the source of the error. See the
\code{call} argument of \code{\link[rlang:abort]{abort()}} for more information.}

\item{estimator}{This can either be \code{NULL} for the default auto-selection of
averaging (\code{"binary"} or \code{"macro"}), or a single character to pass along to
the metric implementation describing the kind of averaging to use.}
}
\description{
\code{check_numeric_metric()}, \code{check_class_metric()}, and \code{check_prob_metric()}
are useful alongside \link{metric-summarizers} for implementing new custom
metrics. \link{metric-summarizers} call the metric function inside
\code{dplyr::summarise()}. These functions perform checks on the inputs in
accordance with the type of metric that is used.
}
\seealso{
\link{metric-summarizers}
}
