% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convMatr2df.R
\name{convMatr2df}
\alias{convMatr2df}
\title{Convert matrix (eg with redundant) row-names to data.frame}
\usage{
convMatr2df(
  mat,
  addIniNa = TRUE,
  duplTxtSep = "_",
  silent = FALSE,
  callFrom = NULL
)
}
\arguments{
\item{mat}{matrix (or data.frame) to be converted}

\item{addIniNa}{(logical) if \code{TRUE} an additional column ('ID') with rownames will be added at beginning}

\item{duplTxtSep}{(character) separator for enumerating replicated names}

\item{silent}{(logical) suppres messages}

\item{callFrom}{(character) allow easier tracking of message(s) produced}
}
\value{
This functions returns a data.frame equivalent to the input matrix, an additional column named 'ID' will be added for initial rownames
}
\description{
This function provides flexible converting of matrix to data.frame. 
For example repeated/redundant rownames are not allowed in data.frame(), thus the corresponding column-names have to be renamed using a counter-suffix.
In case of non-redundant rownames, a new column 'addIniNa' will be introduced at beginning to document the initial (redundant) rownames, 
non-redundant rownames will be created.
Finally, this functions converts the corrected matrix to data.frame and checks/converts columns for transforming character to numeric if possible. 
If the input is a data.frame containing factors, they will be converted to character before potential conversion.
Note: for simpler version (only text to numeric) see from this package \code{.convertMatrToNum} .
}
\examples{
dat1 <- matrix(1:10, ncol=2)
rownames(dat1) <- letters[c(1:3,2,5)]
## as.data.frame(dat1)  ...  would result in an error
convMatr2df(dat1)

df1 <- data.frame(a=as.character((1:3)/2), b=LETTERS[1:3], c=1:3)
str(convMatr2df(df1))

df2 <- df1; df2$b <- as.factor(df2$b)
str(convMatr2df(df2))
}
\seealso{
\code{\link[base]{numeric}}, for simpler version (only text to numeric) see from this package \code{.convertMatrToNum}
}
