% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VolcanoPlotW.R
\name{VolcanoPlotW}
\alias{VolcanoPlotW}
\title{Volcano-Plot (Statistical Test Outcome versus Relative Change)}
\usage{
VolcanoPlotW(
  Mvalue,
  pValue = NULL,
  useComp = 1,
  filtFin = NULL,
  ProjNa = NULL,
  FCthrs = NULL,
  FdrList = NULL,
  FdrThrs = NULL,
  FdrType = NULL,
  subTxt = NULL,
  grayIncrem = TRUE,
  col = NULL,
  pch = 16,
  compNa = NULL,
  batchFig = FALSE,
  cexMa = 1.8,
  cexLa = 1.1,
  limM = NULL,
  limp = NULL,
  annotColumn = c("SpecType", "GeneName", "EntryName", "Accession", "Species", "Contam"),
  annColor = NULL,
  expFCarrow = FALSE,
  cexPt = NULL,
  cexSub = NULL,
  cexTxLab = 0.7,
  namesNBest = NULL,
  NbestCol = 1,
  sortLeg = "descend",
  NaSpecTypeAsContam = TRUE,
  useMar = c(6.2, 4, 4, 2),
  returnData = FALSE,
  callFrom = NULL,
  silent = FALSE,
  debug = FALSE
)
}
\arguments{
\item{Mvalue}{(MArrayLM-object, numeric or matrix) data to plot; M-values are typically calculated as difference of log2-abundance values and 'pValue' the mean of log2-abundance values;
 M-values and p-values may be given as 2 columsn of a matrix, in this case the argument \code{pValue} should remain NULL.
One may also furnish MArrayLM-objects created bpackage wrProteo or limma.}

\item{pValue}{(numeric, list or data.frame) if \code{NULL} it is assumed that 2nd column of 'Mvalue' contains the p-values to be used}

\item{useComp}{(integer, length=1) choice of which of multiple comparisons to present in \code{Mvalue} (if generated using \code{moderTestXgrp()})}

\item{filtFin}{(matrix or logical) The data may get filtered before plotting: If \code{FALSE} no filtering will get applied; if matrix of \code{TRUE}/\code{FALSE} it will be used as optional custom filter, otherwise (if \code{Mvalue} if an \code{MArrayLM}-object eg from limma) a default filtering based on the \code{filtFin} element will be applied}

\item{ProjNa}{(character) custom title}

\item{FCthrs}{(numeric) Fold-Change threshold (display as line) give as Fold-change and NOT log2(FC), default at 1.5, set to \code{NA} for omitting}

\item{FdrList}{(numeric) FDR data or name of list-element}

\item{FdrThrs}{(numeric) FDR threshold (display as line), default at 0.05, set to \code{NA} for omitting}

\item{FdrType}{(character) FDR-type to extract if \code{Mvalue} is 'MArrayLM'-object (eg produced by from \code{moderTest2grp} etc);
if \code{NULL} it will search for suitable fields/values in this order : 'FDR','BH','lfdr' and 'BY'}

\item{subTxt}{(character) custom sub-title}

\item{grayIncrem}{(logical) if \code{TRUE}, display overlay of points  (not exceeding thresholds) as increased shades of gray}

\item{col}{(character) custom color(s) for points of plot (see also \code{\link[graphics]{par}})}

\item{pch}{(integer) type of symbol(s) to plot (default=16) (see also \code{\link[graphics]{par}})}

\item{compNa}{(character) names of groups compared}

\item{batchFig}{(logical) if \code{TRUE} figure title and axes legends will be kept shorter for display on fewer splace}

\item{cexMa}{(numeric) font-size of title, as expansion factor (see also \code{cex} in \code{\link[graphics]{par}})}

\item{cexLa}{(numeric) size of axis-labels, as expansion factor (see also \code{cex} in \code{\link[graphics]{par}})}

\item{limM}{(numeric, length=2) range of axis M-values}

\item{limp}{(numeric, length=2) range of axis FDR / p-values}

\item{annotColumn}{(character) column names of annotation to be extracted (only if \code{Mvalue} is \code{MArrayLM}-object containing matrix $annot).
The first entry (typically 'SpecType') is used for different symbols in figure, the second (typically 'GeneName') is used as prefered text for annotating the best points (if \code{namesNBest} allows to do so.)}

\item{annColor}{(character or integer) colors for specific groups of annotation (only if \code{Mvalue} is \code{MArrayLM}-object containing matrix $annot)}

\item{expFCarrow}{(logical or numeric) optional adding arrow for expected fold-change; if \code{TRUE} the expected ratio will be extracted from numeric concentration-indications from sample-names
if \code{numeric} an arrow will be drawn at this M-value (1st position in vector) with the color of 2nd position of vector}

\item{cexPt}{(numeric) size of points, as expansion factor (see also \code{cex} in \code{\link[graphics]{par}})}

\item{cexSub}{(numeric) size of subtitle, as expansion factor (see also \code{cex} in \code{\link[graphics]{par}})}

\item{cexTxLab}{(numeric) size of text-labels for points, as expansion factor (see also \code{cex} in \code{\link[graphics]{par}})}

\item{namesNBest}{(integer or character) for display of labels to points in figure: if 'pass','passThr' or 'signif' all points passing thresholds; if numeric (length=1) this number of best points will get labels
if the initial object \code{Mvalue} contains a list-element called 'annot' the second of the column specified in argument \code{annotColumn} will be used as text}

\item{NbestCol}{(character or integer) colors for text-labels of best points}

\item{sortLeg}{(character) sorting of 'SpecType' annotation either ascending ('ascend') or descending ('descend'), no sorting if \code{NULL}}

\item{NaSpecTypeAsContam}{(logical) consider lines/proteins with \code{NA} in Mvalue$annot[,"SpecType"] as contaminants (if a 'SpecType' for contaminants already exits)}

\item{useMar}{(numeric,length=4) custom margings (see also \code{\link[graphics]{par}})}

\item{returnData}{(logical) optional returning data.frame with (ID, Mvalue, pValue, FDRvalue, passFilt)}

\item{callFrom}{(character) allow easier tracking of messages produced}

\item{silent}{(logical) suppress messages}

\item{debug}{(logical) additional messages for debugging}
}
\value{
This function simply plots an MA-plot (to the current graphical device), if \code{returnData=TRUE} an optional data.frame with (ID, Mvalue, pValue, FDRvalue, passFilt) can be returned
}
\description{
This type of plot is very common in high-throughput biology, see \href{https://en.wikipedia.org/wiki/Volcano_plot_(statistics)}{Volcano-plot}.
Basically, this plot allows comparing the outcome of a statistical test to the relative change (ie log fold-change, M-value).
}
\details{
In high-throughput biology data are typically already transformed to log2 and thus, the 'M'-values (obtained by subtrating two group means) represent a relative change.
Output from statistical testing by \code{\link[wrMisc]{moderTest2grp}} or \code{\link[wrMisc]{moderTestXgrp}} can be directly read to produce Volcano plots for diagnostic reasons.
Please note, that plotting a very high number of points (eg >10000) in transparency may take several seconds.
}
\examples{
library(wrMisc)
set.seed(2005); mat <- matrix(round(runif(900),2), ncol=9)
rownames(mat) <- paste0(rep(letters[1:25], each=4), rep(letters[2:26],4))
mat[1:50,4:6] <- mat[1:50,4:6] + rep(c(-1,1)*0.1,25)
mat[3:7,4:9] <- mat[3:7,4:9] + 0.7
mat[11:15,1:6] <- mat[11:15,1:6] - 0.7
## assume 2 groups with 3 samples each
gr3 <- gl(3, 3, labels=c("C","A","B"))
tRes2 <- moderTest2grp(mat[,1:6], gl(2,3), addResults = c("FDR","means"))
# Note: due to the small number of lines only FDR chosen to calculate
VolcanoPlotW(tRes2)
## Add names of points passing custom filters
VolcanoPlotW(tRes2, FCth=1.3, FdrThrs=0.2, namesNBest="passThr")

## assume 3 groups with 3 samples each
tRes <- moderTestXgrp(mat, gr3, addResults = c("FDR","means"))
# Note: due to the small number of lines only FDR chosen to calculate
VolcanoPlotW(tRes)
VolcanoPlotW(tRes, FCth=1.3, FdrThrs=0.2)
VolcanoPlotW(tRes, FCth=1.3, FdrThrs=0.2, useComp=2)

}
\seealso{
(for PCA) \code{\link{plotPCAw}})
}
