% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wiki_utils.R
\name{w_SearchByInstanceof}
\alias{w_SearchByInstanceof}
\title{Get entities which are instance of a Wikidata entity}
\usage{
w_SearchByInstanceof(instanceof, langsorder = "", nlimit = 2500, debug = FALSE)
}
\arguments{
\item{instanceof}{Wikidata entity of which the entities searched for are an
example or member of it (class). For example, if instanceof="Q229390" return
Wikidata entities of class Q229390 (3D films). More than one entities can be
included in the \code{instanceof} parameter, with '|' or '&' separator:
\itemize{
\item if '|' (instanceof='Q229390|Q202866') then the OR operator is used.
\item if '&' (instanceof='Q229390|Q202866') then the AND operator is used.
Note that '|' and '&' cannot be present at the same time.
}}

\item{langsorder}{Order of languages in which the information will be
returned, separated with '|'. If no information is given in the first
language, next is used. If langsorder=='', then labels or descriptions are
not returned.}

\item{nlimit}{If the number of entities in the database or authorities'
catalog exceeds this number, then query are made in chunks. The value can
increase if langorder=''. Please, reduce the default value if error is raised.}

\item{debug}{For debugging purposes (default FALSE). If debug='info'
information about chunked queries is shown. If debug='query' also the query
launched is shown. If debug='count' the function only returns the number of
entities.}
}
\value{
A data-frame. Index of the data-frame is also set to the list of entities found.
}
\description{
Get all Wikidata entities which are instance of one o more Wikidata entities
like films, cities, etc. If parameter \code{langsorder}='', then no labels or
descriptions of the entities are returned, otherwise the function returns
them in the language order indicated in \code{langsorder}.
}
\examples{
\dontrun{
w <- w_SearchByInstanceof('Q229390|Q25110269', langsorder = 'es|en')
w <- w_SearchByInstanceof('Q229390&Q25110269', langsorder = 'es|en')
}
}
\author{
Angel Zazo, Department of Computer Science and Automatics, University of Salamanca
}
