% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/server_filters.R
\name{keep_only_relevant_values}
\alias{keep_only_relevant_values}
\title{Keep only relevant values}
\usage{
keep_only_relevant_values(lFilters, sVariable, dfFilters)
}
\arguments{
\item{lFilters}{List of filters to be applied on the data.}

\item{sVariable}{The variable for which relevant values are to be retrieved.}

\item{dfFilters}{Dataframe with the possible filters and values for this dataset}
}
\value{
A list of relevant values for the specified variable.
}
\description{
Filters out only relevant values based on the provided filters
}
\details{
This function removes null elements from the filter list, transforms filter list into elements
suitable for filtering, and retrieves relevant values from the data.
}
\examples{
dfFilters <- dplyr::tibble(
  var1 = sample(c("A", "B", "C"), 100, replace = TRUE),
  var2 = sample(c("D", "E", "F"), 100, replace = TRUE),
  var3 = sample(c("G", "H", "I"), 100, replace = TRUE)
)
filters <- list("D;var2")
relevant_values <- keep_only_relevant_values(filters, "var1", dfFilters)

# Check if the relevant values are only from the rows where var2 is "D" or "E"
expected_values <- dfFilters$var1[dfFilters$var2 \%in\% c("D")] \%>\%
  purrr::set_names(.) \%>\%
  purrr::map(~paste0(.x, ";var1"))
}
