% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layers.R
\name{v_circlepacking}
\alias{v_circlepacking}
\title{Create a Circle Packing Chart}
\usage{
v_circlepacking(
  vc,
  mapping = NULL,
  data = NULL,
  name = NULL,
  drill = TRUE,
  use_root = FALSE,
  fill_opacity = JS("d => d.isLeaf ? 0.75 : 0.25;"),
  label_visible = JS("d => d.depth === 1;"),
  ...,
  serie_id = NULL,
  data_id = NULL
)
}
\arguments{
\item{vc}{A chart initialized with \code{\link[=vchart]{vchart()}}.}

\item{mapping}{Default list of aesthetic mappings to use for chart.}

\item{data}{Default dataset to use for chart. If not already
a \code{data.frame}, it will be coerced to with \code{as.data.frame}.}

\item{name}{Name for the serie, only used for single serie (no \code{color}/\code{fill} aesthetic supplied).}

\item{drill}{Drill-down function switch.}

\item{use_root}{Add a root level in the hierarchy, can be \code{TRUE}
(in this case root level will be named \code{root}) or a \code{character} (use as the name for the root level).}

\item{fill_opacity}{Fill opacity, a JS function determining the opacity of the elements.}

\item{label_visible}{A JS function to control visibility of labels.}

\item{...}{Additional parameters for the serie.}

\item{data_id, serie_id}{ID for the data/serie, can be used to further customize the chart with \code{\link[=v_specs]{v_specs()}}.}
}
\value{
A \code{\link[=vchart]{vchart()}} \code{htmlwidget} object.
}
\description{
Create a Circle Packing Chart
}
\examples{

library(vchartr)

vchart(countries_gdp) \%>\%
  v_circlepacking(
    aes(lvl1 = REGION_UN, lvl2 = SUBREGION, lvl3 = ADMIN, value = GDP_MD)
  )


# With root level
vchart(countries_gdp) \%>\%
  v_circlepacking(
    aes(lvl1 = REGION_UN, lvl2 = SUBREGION, lvl3 = ADMIN, value = GDP_MD),
    use_root = "World"
  )


# Custom colors
vchart(countries_gdp) \%>\%
  v_circlepacking(
    aes(lvl1 = REGION_UN, lvl2 = SUBREGION, lvl3 = ADMIN, value = GDP_MD)
  ) \%>\%
  v_scale_color_manual(c(
    Oceania = "#E6AB02",
    Africa = "#1B9E77",
    Americas = "#D95F02",
    Asia = "#E7298A",
    Europe = "#66A61E",
    Antarctica = "#7570B3"
  ))

# Bubble Chart
vchart(countries_gdp) \%>\%
  v_circlepacking(
    aes(ADMIN, GDP_MD),
    label_visible = JS("d => d.value > 261921;"), # 261921 = 3rd Qu.
  )
}
