% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R
\name{confint.univariateML}
\alias{confint.univariateML}
\title{Confidence Intervals for Maximum Likelihood Estimates}
\usage{
\method{confint}{univariateML}(object, parm = NULL, level = 0.95, Nreps = 1000, ...)
}
\arguments{
\item{object}{An object of class \code{univariateML}.}

\item{parm}{Vector of strings; the parameters to calculate a confidence
interval for. Each parameter must be a member of \code{names(object)}.}

\item{level}{The confidence level.}

\item{Nreps}{Number of bootstrap iterations. Passed to
\code{\link[=bootstrapml]{bootstrapml()}}.}

\item{...}{Additional arguments passed to \code{\link[=bootstrapml]{bootstrapml()}}.}
}
\value{
A matrix or vector with columns giving lower and upper confidence
limits for each parameter in \code{parm}.
}
\description{
Computes a confidence interval for one or more parameters in a
\code{unvariateML} object.
}
\details{
\code{confint.univariateML} is a wrapper for  \code{\link[=bootstrapml]{bootstrapml()}} that
computes confidence intervals for the main parameters of \code{object}.
The main parameters of \code{object} are the members of
\code{names(object)}. For instance, the main parameters of an object
obtained from  \code{mlnorm} are  \code{mean} and  \code{sd}. The
confidence intervals are parametric bootstrap percentile intervals
with limits \code{(1-level)/2} and \code{1 - (1-level)}.
}
\examples{
object <- mlinvgauss(airquality$Wind)
confint(object) # 95\% confidence interval for mean and shape
confint(object, "mean") # 95\% confidence interval for the mean parameter
# confint(object, "variance") # Fails since 'variance isn't a main parameter.
}
\seealso{
\code{\link[stats:confint]{stats::confint()}} for the generic function and
\code{\link[=bootstrapml]{bootstrapml()}} for the function used to calculate the
confidence intervals.
}
