% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/umxMRDoC.R
\name{umxSummaryMRDoC}
\alias{umxSummaryMRDoC}
\alias{umxSummary.MxModelMRDoC}
\title{Present the results of a Mendelian Randomization Direction of Causation Model in a table}
\usage{
umxSummaryMRDoC(
  model,
  digits = 2,
  std = TRUE,
  CIs = FALSE,
  comparison = NULL,
  RMSEA_CI = FALSE,
  report = c("markdown", "html"),
  file = getOption("umx_auto_plot"),
  ...
)
}
\arguments{
\item{model}{A fitted \code{\link[=umxDoC]{umxDoC()}} model to summarize}

\item{digits}{Round to how many digits (default = 2)}

\item{std}{Whether to show the standardized model (TRUE) (ignored: used extended = TRUE to get unstandardized)}

\item{CIs}{Confidence intervals (default FALSE)}

\item{comparison}{Run mxCompare on a comparison model (default NULL)}

\item{RMSEA_CI}{Optionally compute CI on RMSEA.}

\item{report}{Print tables to the console (as 'markdown'), or open in browser ('html')}

\item{file}{The name of the dot file to write: NA = none; "name" = use the name of the model}

\item{...}{Optional additional parameters}
}
\value{
\itemize{
\item nothing
}
}
\description{
Summarizes a MR Direction of Causation model, as returned by \code{\link[=umxMRDoC]{umxMRDoC()}}
}
\seealso{
\itemize{
\item \code{\link{umxDoC}()}, \code{\link[=plot]{plot()}}, \code{\link[=umxSummary]{umxSummary()}} work for DoC models.
}

Other Summary functions: 
\code{\link{umxSummary.MxModel}()},
\code{\link{umxSummaryACEcov}()},
\code{\link{umxSummaryCP}()},
\code{\link{umxSummaryGxE}()},
\code{\link{umxSummaryIP}()}
}
\concept{Summary functions}
