% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/language.R
\name{language_next_state}
\alias{language_next_state}
\title{Language state advancement}
\usage{
language_next_state(x, state, symbol)
}
\arguments{
\item{x}{\verb{[tree_sitter_language]}

A tree-sitter language object.}

\item{state, symbol}{\verb{[integer]}

Vectors of equal length containing the current state and symbol
information.}
}
\value{
A single integer representing the next state.
}
\description{
Get the next state in the grammar.
}
\examples{
\dontshow{if (rlang::is_installed("treesitter.r")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
language <- treesitter.r::language()
parser <- parser(language)

text <- "fn <- function() { 1 + 1 }"
tree <- parser_parse(parser, text)
node <- tree_root_node(tree)

# Navigate to function definition
node <- node_child(node, 1)
node <- node_child(node, 3)
node

state <- node_parse_state(node)
symbol <- node_grammar_symbol(node)

# Function definition symbol
language_symbol_name(language, 85)

# Next state (this is all grammar dependent)
language_next_state(language, state, symbol)
\dontshow{\}) # examplesIf}
}
