#include "tree_sitter/parser.h"

#if defined(__GNUC__) || defined(__clang__)
# pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 14
#define STATE_COUNT 2199
#define LARGE_STATE_COUNT 1004
#define SYMBOL_COUNT 135
#define ALIAS_COUNT 1
#define TOKEN_COUNT 80
#define EXTERNAL_TOKEN_COUNT 13
#define FIELD_COUNT 20
#define MAX_ALIAS_SEQUENCE_LENGTH 9
#define PRODUCTION_ID_COUNT 49

enum ts_symbol_identifiers {
  sym_identifier = 1,
  anon_sym_BSLASH = 2,
  anon_sym_function = 3,
  anon_sym_EQ = 4,
  anon_sym_if = 5,
  anon_sym_for = 6,
  anon_sym_in = 7,
  anon_sym_while = 8,
  anon_sym_repeat = 9,
  anon_sym_QMARK = 10,
  anon_sym_TILDE = 11,
  anon_sym_BANG = 12,
  anon_sym_PLUS = 13,
  anon_sym_DASH = 14,
  anon_sym_LT_DASH = 15,
  anon_sym_LT_LT_DASH = 16,
  anon_sym_COLON_EQ = 17,
  anon_sym_DASH_GT = 18,
  anon_sym_DASH_GT_GT = 19,
  anon_sym_PIPE = 20,
  anon_sym_AMP = 21,
  anon_sym_PIPE_PIPE = 22,
  anon_sym_AMP_AMP = 23,
  anon_sym_LT = 24,
  anon_sym_LT_EQ = 25,
  anon_sym_GT = 26,
  anon_sym_GT_EQ = 27,
  anon_sym_EQ_EQ = 28,
  anon_sym_BANG_EQ = 29,
  anon_sym_STAR = 30,
  anon_sym_SLASH = 31,
  anon_sym_STAR_STAR = 32,
  anon_sym_CARET = 33,
  aux_sym_binary_operator_token1 = 34,
  anon_sym_PIPE_GT = 35,
  anon_sym_COLON = 36,
  anon_sym_DOLLAR = 37,
  anon_sym_AT = 38,
  anon_sym_COLON_COLON = 39,
  anon_sym_COLON_COLON_COLON = 40,
  anon_sym_L = 41,
  anon_sym_i = 42,
  aux_sym__hex_literal_token1 = 43,
  sym__number_literal = 44,
  anon_sym_SQUOTE = 45,
  anon_sym_DQUOTE = 46,
  aux_sym__single_quoted_string_content_token1 = 47,
  aux_sym__double_quoted_string_content_token1 = 48,
  sym_escape_sequence = 49,
  sym_return = 50,
  sym_next = 51,
  sym_break = 52,
  sym_true = 53,
  sym_false = 54,
  sym_null = 55,
  sym_inf = 56,
  sym_nan = 57,
  anon_sym_NA = 58,
  anon_sym_NA_integer_ = 59,
  anon_sym_NA_real_ = 60,
  anon_sym_NA_complex_ = 61,
  anon_sym_NA_character_ = 62,
  sym_dots = 63,
  sym_dot_dot_i = 64,
  sym_comment = 65,
  sym_comma = 66,
  sym__newline = 67,
  sym__semicolon = 68,
  sym__raw_string_literal = 69,
  sym__external_else = 70,
  sym__external_open_parenthesis = 71,
  sym__external_close_parenthesis = 72,
  sym__external_open_brace = 73,
  sym__external_close_brace = 74,
  sym__external_open_bracket = 75,
  sym__external_close_bracket = 76,
  sym__external_open_bracket2 = 77,
  sym__external_close_bracket2 = 78,
  sym__error_sentinel = 79,
  sym_program = 80,
  sym_function_definition = 81,
  sym_parameters = 82,
  sym_parameter = 83,
  sym__parameter_with_default = 84,
  sym__parameter_without_default = 85,
  sym_if_statement = 86,
  sym_for_statement = 87,
  sym_while_statement = 88,
  sym_repeat_statement = 89,
  sym_braced_expression = 90,
  sym_parenthesized_expression = 91,
  sym_call = 92,
  sym_subset = 93,
  sym_subset2 = 94,
  sym_call_arguments = 95,
  sym_subset_arguments = 96,
  sym_subset2_arguments = 97,
  sym__argument = 98,
  sym_argument = 99,
  sym__argument_named = 100,
  sym__argument_unnamed = 101,
  sym__argument_value = 102,
  sym_unary_operator = 103,
  sym_binary_operator = 104,
  sym_extract_operator = 105,
  sym_namespace_operator = 106,
  sym_integer = 107,
  sym_complex = 108,
  sym_float = 109,
  sym__hex_literal = 110,
  sym__float_literal = 111,
  sym_string = 112,
  sym__single_quoted_string = 113,
  sym__double_quoted_string = 114,
  aux_sym__single_quoted_string_content = 115,
  aux_sym__double_quoted_string_content = 116,
  sym_na = 117,
  sym__expression = 118,
  sym__string_or_identifier = 119,
  sym__else = 120,
  sym__open_parenthesis = 121,
  sym__close_parenthesis = 122,
  sym__open_brace = 123,
  sym__close_brace = 124,
  sym__open_bracket = 125,
  sym__close_bracket = 126,
  sym__open_bracket2 = 127,
  sym__close_bracket2 = 128,
  aux_sym_program_repeat1 = 129,
  aux_sym_function_definition_repeat1 = 130,
  aux_sym_parameters_repeat1 = 131,
  aux_sym_braced_expression_repeat1 = 132,
  aux_sym_parenthesized_expression_repeat1 = 133,
  aux_sym_call_arguments_repeat1 = 134,
  alias_sym_string_content = 135,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_identifier] = "identifier",
  [anon_sym_BSLASH] = "\\",
  [anon_sym_function] = "function",
  [anon_sym_EQ] = "=",
  [anon_sym_if] = "if",
  [anon_sym_for] = "for",
  [anon_sym_in] = "in",
  [anon_sym_while] = "while",
  [anon_sym_repeat] = "repeat",
  [anon_sym_QMARK] = "\?",
  [anon_sym_TILDE] = "~",
  [anon_sym_BANG] = "!",
  [anon_sym_PLUS] = "+",
  [anon_sym_DASH] = "-",
  [anon_sym_LT_DASH] = "<-",
  [anon_sym_LT_LT_DASH] = "<<-",
  [anon_sym_COLON_EQ] = ":=",
  [anon_sym_DASH_GT] = "->",
  [anon_sym_DASH_GT_GT] = "->>",
  [anon_sym_PIPE] = "|",
  [anon_sym_AMP] = "&",
  [anon_sym_PIPE_PIPE] = "||",
  [anon_sym_AMP_AMP] = "&&",
  [anon_sym_LT] = "<",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_GT] = ">",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_BANG_EQ] = "!=",
  [anon_sym_STAR] = "*",
  [anon_sym_SLASH] = "/",
  [anon_sym_STAR_STAR] = "**",
  [anon_sym_CARET] = "^",
  [aux_sym_binary_operator_token1] = "special",
  [anon_sym_PIPE_GT] = "|>",
  [anon_sym_COLON] = ":",
  [anon_sym_DOLLAR] = "$",
  [anon_sym_AT] = "@",
  [anon_sym_COLON_COLON] = "::",
  [anon_sym_COLON_COLON_COLON] = ":::",
  [anon_sym_L] = "L",
  [anon_sym_i] = "i",
  [aux_sym__hex_literal_token1] = "_hex_literal_token1",
  [sym__number_literal] = "_number_literal",
  [anon_sym_SQUOTE] = "'",
  [anon_sym_DQUOTE] = "\"",
  [aux_sym__single_quoted_string_content_token1] = "_single_quoted_string_content_token1",
  [aux_sym__double_quoted_string_content_token1] = "_double_quoted_string_content_token1",
  [sym_escape_sequence] = "escape_sequence",
  [sym_return] = "return",
  [sym_next] = "next",
  [sym_break] = "break",
  [sym_true] = "true",
  [sym_false] = "false",
  [sym_null] = "null",
  [sym_inf] = "inf",
  [sym_nan] = "nan",
  [anon_sym_NA] = "NA",
  [anon_sym_NA_integer_] = "NA_integer_",
  [anon_sym_NA_real_] = "NA_real_",
  [anon_sym_NA_complex_] = "NA_complex_",
  [anon_sym_NA_character_] = "NA_character_",
  [sym_dots] = "dots",
  [sym_dot_dot_i] = "dot_dot_i",
  [sym_comment] = "comment",
  [sym_comma] = "comma",
  [sym__newline] = "_newline",
  [sym__semicolon] = "_semicolon",
  [sym__raw_string_literal] = "_raw_string_literal",
  [sym__external_else] = "else",
  [sym__external_open_parenthesis] = "(",
  [sym__external_close_parenthesis] = ")",
  [sym__external_open_brace] = "{",
  [sym__external_close_brace] = "}",
  [sym__external_open_bracket] = "[",
  [sym__external_close_bracket] = "]",
  [sym__external_open_bracket2] = "[[",
  [sym__external_close_bracket2] = "]]",
  [sym__error_sentinel] = "_error_sentinel",
  [sym_program] = "program",
  [sym_function_definition] = "function_definition",
  [sym_parameters] = "parameters",
  [sym_parameter] = "parameter",
  [sym__parameter_with_default] = "_parameter_with_default",
  [sym__parameter_without_default] = "_parameter_without_default",
  [sym_if_statement] = "if_statement",
  [sym_for_statement] = "for_statement",
  [sym_while_statement] = "while_statement",
  [sym_repeat_statement] = "repeat_statement",
  [sym_braced_expression] = "braced_expression",
  [sym_parenthesized_expression] = "parenthesized_expression",
  [sym_call] = "call",
  [sym_subset] = "subset",
  [sym_subset2] = "subset2",
  [sym_call_arguments] = "arguments",
  [sym_subset_arguments] = "arguments",
  [sym_subset2_arguments] = "arguments",
  [sym__argument] = "_argument",
  [sym_argument] = "argument",
  [sym__argument_named] = "_argument_named",
  [sym__argument_unnamed] = "_argument_unnamed",
  [sym__argument_value] = "_argument_value",
  [sym_unary_operator] = "unary_operator",
  [sym_binary_operator] = "binary_operator",
  [sym_extract_operator] = "extract_operator",
  [sym_namespace_operator] = "namespace_operator",
  [sym_integer] = "integer",
  [sym_complex] = "complex",
  [sym_float] = "float",
  [sym__hex_literal] = "_hex_literal",
  [sym__float_literal] = "_float_literal",
  [sym_string] = "string",
  [sym__single_quoted_string] = "_single_quoted_string",
  [sym__double_quoted_string] = "_double_quoted_string",
  [aux_sym__single_quoted_string_content] = "_single_quoted_string_content",
  [aux_sym__double_quoted_string_content] = "_double_quoted_string_content",
  [sym_na] = "na",
  [sym__expression] = "_expression",
  [sym__string_or_identifier] = "_string_or_identifier",
  [sym__else] = "_else",
  [sym__open_parenthesis] = "_open_parenthesis",
  [sym__close_parenthesis] = "_close_parenthesis",
  [sym__open_brace] = "_open_brace",
  [sym__close_brace] = "_close_brace",
  [sym__open_bracket] = "_open_bracket",
  [sym__close_bracket] = "_close_bracket",
  [sym__open_bracket2] = "_open_bracket2",
  [sym__close_bracket2] = "_close_bracket2",
  [aux_sym_program_repeat1] = "program_repeat1",
  [aux_sym_function_definition_repeat1] = "function_definition_repeat1",
  [aux_sym_parameters_repeat1] = "parameters_repeat1",
  [aux_sym_braced_expression_repeat1] = "braced_expression_repeat1",
  [aux_sym_parenthesized_expression_repeat1] = "parenthesized_expression_repeat1",
  [aux_sym_call_arguments_repeat1] = "call_arguments_repeat1",
  [alias_sym_string_content] = "string_content",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_identifier] = sym_identifier,
  [anon_sym_BSLASH] = anon_sym_BSLASH,
  [anon_sym_function] = anon_sym_function,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_for] = anon_sym_for,
  [anon_sym_in] = anon_sym_in,
  [anon_sym_while] = anon_sym_while,
  [anon_sym_repeat] = anon_sym_repeat,
  [anon_sym_QMARK] = anon_sym_QMARK,
  [anon_sym_TILDE] = anon_sym_TILDE,
  [anon_sym_BANG] = anon_sym_BANG,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_LT_DASH] = anon_sym_LT_DASH,
  [anon_sym_LT_LT_DASH] = anon_sym_LT_LT_DASH,
  [anon_sym_COLON_EQ] = anon_sym_COLON_EQ,
  [anon_sym_DASH_GT] = anon_sym_DASH_GT,
  [anon_sym_DASH_GT_GT] = anon_sym_DASH_GT_GT,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_AMP] = anon_sym_AMP,
  [anon_sym_PIPE_PIPE] = anon_sym_PIPE_PIPE,
  [anon_sym_AMP_AMP] = anon_sym_AMP_AMP,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_BANG_EQ] = anon_sym_BANG_EQ,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_STAR_STAR] = anon_sym_STAR_STAR,
  [anon_sym_CARET] = anon_sym_CARET,
  [aux_sym_binary_operator_token1] = aux_sym_binary_operator_token1,
  [anon_sym_PIPE_GT] = anon_sym_PIPE_GT,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_DOLLAR] = anon_sym_DOLLAR,
  [anon_sym_AT] = anon_sym_AT,
  [anon_sym_COLON_COLON] = anon_sym_COLON_COLON,
  [anon_sym_COLON_COLON_COLON] = anon_sym_COLON_COLON_COLON,
  [anon_sym_L] = anon_sym_L,
  [anon_sym_i] = anon_sym_i,
  [aux_sym__hex_literal_token1] = aux_sym__hex_literal_token1,
  [sym__number_literal] = sym__number_literal,
  [anon_sym_SQUOTE] = anon_sym_SQUOTE,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [aux_sym__single_quoted_string_content_token1] = aux_sym__single_quoted_string_content_token1,
  [aux_sym__double_quoted_string_content_token1] = aux_sym__double_quoted_string_content_token1,
  [sym_escape_sequence] = sym_escape_sequence,
  [sym_return] = sym_return,
  [sym_next] = sym_next,
  [sym_break] = sym_break,
  [sym_true] = sym_true,
  [sym_false] = sym_false,
  [sym_null] = sym_null,
  [sym_inf] = sym_inf,
  [sym_nan] = sym_nan,
  [anon_sym_NA] = anon_sym_NA,
  [anon_sym_NA_integer_] = anon_sym_NA_integer_,
  [anon_sym_NA_real_] = anon_sym_NA_real_,
  [anon_sym_NA_complex_] = anon_sym_NA_complex_,
  [anon_sym_NA_character_] = anon_sym_NA_character_,
  [sym_dots] = sym_dots,
  [sym_dot_dot_i] = sym_dot_dot_i,
  [sym_comment] = sym_comment,
  [sym_comma] = sym_comma,
  [sym__newline] = sym__newline,
  [sym__semicolon] = sym__semicolon,
  [sym__raw_string_literal] = sym__raw_string_literal,
  [sym__external_else] = sym__external_else,
  [sym__external_open_parenthesis] = sym__external_open_parenthesis,
  [sym__external_close_parenthesis] = sym__external_close_parenthesis,
  [sym__external_open_brace] = sym__external_open_brace,
  [sym__external_close_brace] = sym__external_close_brace,
  [sym__external_open_bracket] = sym__external_open_bracket,
  [sym__external_close_bracket] = sym__external_close_bracket,
  [sym__external_open_bracket2] = sym__external_open_bracket2,
  [sym__external_close_bracket2] = sym__external_close_bracket2,
  [sym__error_sentinel] = sym__error_sentinel,
  [sym_program] = sym_program,
  [sym_function_definition] = sym_function_definition,
  [sym_parameters] = sym_parameters,
  [sym_parameter] = sym_parameter,
  [sym__parameter_with_default] = sym__parameter_with_default,
  [sym__parameter_without_default] = sym__parameter_without_default,
  [sym_if_statement] = sym_if_statement,
  [sym_for_statement] = sym_for_statement,
  [sym_while_statement] = sym_while_statement,
  [sym_repeat_statement] = sym_repeat_statement,
  [sym_braced_expression] = sym_braced_expression,
  [sym_parenthesized_expression] = sym_parenthesized_expression,
  [sym_call] = sym_call,
  [sym_subset] = sym_subset,
  [sym_subset2] = sym_subset2,
  [sym_call_arguments] = sym_call_arguments,
  [sym_subset_arguments] = sym_call_arguments,
  [sym_subset2_arguments] = sym_call_arguments,
  [sym__argument] = sym__argument,
  [sym_argument] = sym_argument,
  [sym__argument_named] = sym__argument_named,
  [sym__argument_unnamed] = sym__argument_unnamed,
  [sym__argument_value] = sym__argument_value,
  [sym_unary_operator] = sym_unary_operator,
  [sym_binary_operator] = sym_binary_operator,
  [sym_extract_operator] = sym_extract_operator,
  [sym_namespace_operator] = sym_namespace_operator,
  [sym_integer] = sym_integer,
  [sym_complex] = sym_complex,
  [sym_float] = sym_float,
  [sym__hex_literal] = sym__hex_literal,
  [sym__float_literal] = sym__float_literal,
  [sym_string] = sym_string,
  [sym__single_quoted_string] = sym__single_quoted_string,
  [sym__double_quoted_string] = sym__double_quoted_string,
  [aux_sym__single_quoted_string_content] = aux_sym__single_quoted_string_content,
  [aux_sym__double_quoted_string_content] = aux_sym__double_quoted_string_content,
  [sym_na] = sym_na,
  [sym__expression] = sym__expression,
  [sym__string_or_identifier] = sym__string_or_identifier,
  [sym__else] = sym__else,
  [sym__open_parenthesis] = sym__open_parenthesis,
  [sym__close_parenthesis] = sym__close_parenthesis,
  [sym__open_brace] = sym__open_brace,
  [sym__close_brace] = sym__close_brace,
  [sym__open_bracket] = sym__open_bracket,
  [sym__close_bracket] = sym__close_bracket,
  [sym__open_bracket2] = sym__open_bracket2,
  [sym__close_bracket2] = sym__close_bracket2,
  [aux_sym_program_repeat1] = aux_sym_program_repeat1,
  [aux_sym_function_definition_repeat1] = aux_sym_function_definition_repeat1,
  [aux_sym_parameters_repeat1] = aux_sym_parameters_repeat1,
  [aux_sym_braced_expression_repeat1] = aux_sym_braced_expression_repeat1,
  [aux_sym_parenthesized_expression_repeat1] = aux_sym_parenthesized_expression_repeat1,
  [aux_sym_call_arguments_repeat1] = aux_sym_call_arguments_repeat1,
  [alias_sym_string_content] = alias_sym_string_content,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_BSLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_function] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_for] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_in] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_while] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_repeat] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TILDE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_binary_operator_token1] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOLLAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_COLON_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_L] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_i] = {
    .visible = true,
    .named = false,
  },
  [aux_sym__hex_literal_token1] = {
    .visible = false,
    .named = false,
  },
  [sym__number_literal] = {
    .visible = false,
    .named = true,
  },
  [anon_sym_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym__single_quoted_string_content_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__double_quoted_string_content_token1] = {
    .visible = false,
    .named = false,
  },
  [sym_escape_sequence] = {
    .visible = true,
    .named = true,
  },
  [sym_return] = {
    .visible = true,
    .named = true,
  },
  [sym_next] = {
    .visible = true,
    .named = true,
  },
  [sym_break] = {
    .visible = true,
    .named = true,
  },
  [sym_true] = {
    .visible = true,
    .named = true,
  },
  [sym_false] = {
    .visible = true,
    .named = true,
  },
  [sym_null] = {
    .visible = true,
    .named = true,
  },
  [sym_inf] = {
    .visible = true,
    .named = true,
  },
  [sym_nan] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_NA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_NA_integer_] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_NA_real_] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_NA_complex_] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_NA_character_] = {
    .visible = true,
    .named = false,
  },
  [sym_dots] = {
    .visible = true,
    .named = true,
  },
  [sym_dot_dot_i] = {
    .visible = true,
    .named = true,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_comma] = {
    .visible = true,
    .named = true,
  },
  [sym__newline] = {
    .visible = false,
    .named = true,
  },
  [sym__semicolon] = {
    .visible = false,
    .named = true,
  },
  [sym__raw_string_literal] = {
    .visible = false,
    .named = true,
  },
  [sym__external_else] = {
    .visible = true,
    .named = false,
  },
  [sym__external_open_parenthesis] = {
    .visible = true,
    .named = false,
  },
  [sym__external_close_parenthesis] = {
    .visible = true,
    .named = false,
  },
  [sym__external_open_brace] = {
    .visible = true,
    .named = false,
  },
  [sym__external_close_brace] = {
    .visible = true,
    .named = false,
  },
  [sym__external_open_bracket] = {
    .visible = true,
    .named = false,
  },
  [sym__external_close_bracket] = {
    .visible = true,
    .named = false,
  },
  [sym__external_open_bracket2] = {
    .visible = true,
    .named = false,
  },
  [sym__external_close_bracket2] = {
    .visible = true,
    .named = false,
  },
  [sym__error_sentinel] = {
    .visible = false,
    .named = true,
  },
  [sym_program] = {
    .visible = true,
    .named = true,
  },
  [sym_function_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym__parameter_with_default] = {
    .visible = false,
    .named = true,
  },
  [sym__parameter_without_default] = {
    .visible = false,
    .named = true,
  },
  [sym_if_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_for_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_while_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_repeat_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_braced_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_parenthesized_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_call] = {
    .visible = true,
    .named = true,
  },
  [sym_subset] = {
    .visible = true,
    .named = true,
  },
  [sym_subset2] = {
    .visible = true,
    .named = true,
  },
  [sym_call_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_subset_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_subset2_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym__argument] = {
    .visible = false,
    .named = true,
  },
  [sym_argument] = {
    .visible = true,
    .named = true,
  },
  [sym__argument_named] = {
    .visible = false,
    .named = true,
  },
  [sym__argument_unnamed] = {
    .visible = false,
    .named = true,
  },
  [sym__argument_value] = {
    .visible = false,
    .named = true,
  },
  [sym_unary_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_binary_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_extract_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_namespace_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_integer] = {
    .visible = true,
    .named = true,
  },
  [sym_complex] = {
    .visible = true,
    .named = true,
  },
  [sym_float] = {
    .visible = true,
    .named = true,
  },
  [sym__hex_literal] = {
    .visible = false,
    .named = true,
  },
  [sym__float_literal] = {
    .visible = false,
    .named = true,
  },
  [sym_string] = {
    .visible = true,
    .named = true,
  },
  [sym__single_quoted_string] = {
    .visible = false,
    .named = true,
  },
  [sym__double_quoted_string] = {
    .visible = false,
    .named = true,
  },
  [aux_sym__single_quoted_string_content] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__double_quoted_string_content] = {
    .visible = false,
    .named = false,
  },
  [sym_na] = {
    .visible = true,
    .named = true,
  },
  [sym__expression] = {
    .visible = false,
    .named = true,
  },
  [sym__string_or_identifier] = {
    .visible = false,
    .named = true,
  },
  [sym__else] = {
    .visible = false,
    .named = true,
  },
  [sym__open_parenthesis] = {
    .visible = false,
    .named = true,
  },
  [sym__close_parenthesis] = {
    .visible = false,
    .named = true,
  },
  [sym__open_brace] = {
    .visible = false,
    .named = true,
  },
  [sym__close_brace] = {
    .visible = false,
    .named = true,
  },
  [sym__open_bracket] = {
    .visible = false,
    .named = true,
  },
  [sym__close_bracket] = {
    .visible = false,
    .named = true,
  },
  [sym__open_bracket2] = {
    .visible = false,
    .named = true,
  },
  [sym__close_bracket2] = {
    .visible = false,
    .named = true,
  },
  [aux_sym_program_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_function_definition_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_braced_expression_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_parenthesized_expression_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_call_arguments_repeat1] = {
    .visible = false,
    .named = false,
  },
  [alias_sym_string_content] = {
    .visible = true,
    .named = true,
  },
};

enum ts_field_identifiers {
  field_alternative = 1,
  field_argument = 2,
  field_arguments = 3,
  field_body = 4,
  field_close = 5,
  field_condition = 6,
  field_consequence = 7,
  field_content = 8,
  field_default = 9,
  field_function = 10,
  field_lhs = 11,
  field_name = 12,
  field_open = 13,
  field_operator = 14,
  field_parameter = 15,
  field_parameters = 16,
  field_rhs = 17,
  field_sequence = 18,
  field_value = 19,
  field_variable = 20,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_alternative] = "alternative",
  [field_argument] = "argument",
  [field_arguments] = "arguments",
  [field_body] = "body",
  [field_close] = "close",
  [field_condition] = "condition",
  [field_consequence] = "consequence",
  [field_content] = "content",
  [field_default] = "default",
  [field_function] = "function",
  [field_lhs] = "lhs",
  [field_name] = "name",
  [field_open] = "open",
  [field_operator] = "operator",
  [field_parameter] = "parameter",
  [field_parameters] = "parameters",
  [field_rhs] = "rhs",
  [field_sequence] = "sequence",
  [field_value] = "value",
  [field_variable] = "variable",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [1] = {.index = 0, .length = 1},
  [2] = {.index = 1, .length = 1},
  [3] = {.index = 2, .length = 2},
  [4] = {.index = 4, .length = 2},
  [5] = {.index = 6, .length = 2},
  [6] = {.index = 8, .length = 1},
  [7] = {.index = 9, .length = 2},
  [8] = {.index = 11, .length = 3},
  [9] = {.index = 14, .length = 1},
  [10] = {.index = 15, .length = 2},
  [11] = {.index = 17, .length = 1},
  [12] = {.index = 18, .length = 1},
  [13] = {.index = 19, .length = 2},
  [14] = {.index = 21, .length = 1},
  [15] = {.index = 22, .length = 3},
  [16] = {.index = 25, .length = 1},
  [17] = {.index = 26, .length = 1},
  [18] = {.index = 27, .length = 1},
  [19] = {.index = 28, .length = 2},
  [20] = {.index = 30, .length = 1},
  [21] = {.index = 31, .length = 3},
  [22] = {.index = 34, .length = 2},
  [23] = {.index = 36, .length = 3},
  [24] = {.index = 39, .length = 3},
  [25] = {.index = 42, .length = 3},
  [26] = {.index = 45, .length = 3},
  [27] = {.index = 48, .length = 2},
  [28] = {.index = 50, .length = 2},
  [29] = {.index = 52, .length = 1},
  [30] = {.index = 53, .length = 4},
  [31] = {.index = 57, .length = 2},
  [32] = {.index = 59, .length = 4},
  [33] = {.index = 63, .length = 4},
  [34] = {.index = 67, .length = 2},
  [35] = {.index = 69, .length = 4},
  [36] = {.index = 73, .length = 4},
  [37] = {.index = 77, .length = 4},
  [38] = {.index = 81, .length = 4},
  [39] = {.index = 85, .length = 5},
  [40] = {.index = 90, .length = 4},
  [41] = {.index = 94, .length = 5},
  [42] = {.index = 99, .length = 4},
  [43] = {.index = 103, .length = 5},
  [44] = {.index = 108, .length = 5},
  [45] = {.index = 113, .length = 5},
  [46] = {.index = 118, .length = 5},
  [47] = {.index = 123, .length = 5},
  [48] = {.index = 128, .length = 5},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_content, 0, .inherited = true},
  [1] =
    {field_body, 1},
  [2] =
    {field_operator, 0},
    {field_rhs, 1},
  [4] =
    {field_lhs, 0},
    {field_operator, 1},
  [6] =
    {field_arguments, 1},
    {field_function, 0},
  [8] =
    {field_body, 0},
  [9] =
    {field_close, 1},
    {field_open, 0},
  [11] =
    {field_body, 2},
    {field_name, 0},
    {field_parameters, 1},
  [14] =
    {field_name, 0},
  [15] =
    {field_default, 0, .inherited = true},
    {field_name, 0, .inherited = true},
  [17] =
    {field_name, 0, .inherited = true},
  [18] =
    {field_body, 2},
  [19] =
    {field_operator, 0},
    {field_rhs, 2},
  [21] =
    {field_content, 1},
  [22] =
    {field_lhs, 0},
    {field_operator, 1},
    {field_rhs, 2},
  [25] =
    {field_value, 0},
  [26] =
    {field_argument, 0, .inherited = true},
  [27] =
    {field_argument, 0},
  [28] =
    {field_name, 0, .inherited = true},
    {field_value, 0, .inherited = true},
  [30] =
    {field_value, 0, .inherited = true},
  [31] =
    {field_body, 1, .inherited = true},
    {field_close, 2},
    {field_open, 0},
  [34] =
    {field_body, 0, .inherited = true},
    {field_body, 1, .inherited = true},
  [36] =
    {field_body, 3},
    {field_name, 0},
    {field_parameters, 1},
  [39] =
    {field_close, 2},
    {field_open, 0},
    {field_parameter, 1},
  [42] =
    {field_lhs, 0},
    {field_operator, 1},
    {field_rhs, 3},
  [45] =
    {field_argument, 1, .inherited = true},
    {field_close, 2},
    {field_open, 0},
  [48] =
    {field_argument, 0, .inherited = true},
    {field_argument, 1, .inherited = true},
  [50] =
    {field_default, 2},
    {field_name, 0},
  [52] =
    {field_parameter, 1},
  [53] =
    {field_close, 3},
    {field_open, 0},
    {field_parameter, 1},
    {field_parameter, 2, .inherited = true},
  [57] =
    {field_parameter, 0, .inherited = true},
    {field_parameter, 1, .inherited = true},
  [59] =
    {field_close, 3},
    {field_condition, 2},
    {field_consequence, 4},
    {field_open, 1},
  [63] =
    {field_body, 4},
    {field_close, 3},
    {field_condition, 2},
    {field_open, 1},
  [67] =
    {field_name, 0},
    {field_value, 2, .inherited = true},
  [69] =
    {field_close, 3},
    {field_condition, 2},
    {field_consequence, 5},
    {field_open, 1},
  [73] =
    {field_close, 4},
    {field_condition, 3},
    {field_consequence, 5},
    {field_open, 2},
  [77] =
    {field_body, 5},
    {field_close, 3},
    {field_condition, 2},
    {field_open, 1},
  [81] =
    {field_body, 5},
    {field_close, 4},
    {field_condition, 3},
    {field_open, 2},
  [85] =
    {field_alternative, 6},
    {field_close, 3},
    {field_condition, 2},
    {field_consequence, 4},
    {field_open, 1},
  [90] =
    {field_close, 4},
    {field_condition, 3},
    {field_consequence, 6},
    {field_open, 2},
  [94] =
    {field_body, 6},
    {field_close, 5},
    {field_open, 1},
    {field_sequence, 4},
    {field_variable, 2},
  [99] =
    {field_body, 6},
    {field_close, 4},
    {field_condition, 3},
    {field_open, 2},
  [103] =
    {field_alternative, 7},
    {field_close, 3},
    {field_condition, 2},
    {field_consequence, 5},
    {field_open, 1},
  [108] =
    {field_alternative, 7},
    {field_close, 4},
    {field_condition, 3},
    {field_consequence, 5},
    {field_open, 2},
  [113] =
    {field_body, 7},
    {field_close, 5},
    {field_open, 1},
    {field_sequence, 4},
    {field_variable, 2},
  [118] =
    {field_body, 7},
    {field_close, 6},
    {field_open, 2},
    {field_sequence, 5},
    {field_variable, 3},
  [123] =
    {field_alternative, 8},
    {field_close, 4},
    {field_condition, 3},
    {field_consequence, 6},
    {field_open, 2},
  [128] =
    {field_body, 8},
    {field_close, 6},
    {field_open, 2},
    {field_sequence, 5},
    {field_variable, 3},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [14] = {
    [1] = alias_sym_string_content,
  },
};

static const uint16_t ts_non_terminal_alias_map[] = {
  aux_sym__single_quoted_string_content, 2,
    aux_sym__single_quoted_string_content,
    alias_sym_string_content,
  aux_sym__double_quoted_string_content, 2,
    aux_sym__double_quoted_string_content,
    alias_sym_string_content,
  0,
};

static const TSStateId ts_primary_state_ids[STATE_COUNT] = {
  [0] = 0,
  [1] = 1,
  [2] = 2,
  [3] = 3,
  [4] = 2,
  [5] = 5,
  [6] = 2,
  [7] = 7,
  [8] = 3,
  [9] = 5,
  [10] = 2,
  [11] = 7,
  [12] = 3,
  [13] = 5,
  [14] = 2,
  [15] = 7,
  [16] = 3,
  [17] = 5,
  [18] = 5,
  [19] = 7,
  [20] = 3,
  [21] = 5,
  [22] = 2,
  [23] = 7,
  [24] = 3,
  [25] = 5,
  [26] = 2,
  [27] = 7,
  [28] = 3,
  [29] = 5,
  [30] = 2,
  [31] = 7,
  [32] = 3,
  [33] = 5,
  [34] = 7,
  [35] = 7,
  [36] = 3,
  [37] = 5,
  [38] = 2,
  [39] = 7,
  [40] = 3,
  [41] = 2,
  [42] = 42,
  [43] = 43,
  [44] = 44,
  [45] = 45,
  [46] = 46,
  [47] = 47,
  [48] = 48,
  [49] = 49,
  [50] = 50,
  [51] = 51,
  [52] = 52,
  [53] = 53,
  [54] = 54,
  [55] = 55,
  [56] = 56,
  [57] = 57,
  [58] = 58,
  [59] = 59,
  [60] = 60,
  [61] = 61,
  [62] = 62,
  [63] = 63,
  [64] = 64,
  [65] = 65,
  [66] = 66,
  [67] = 67,
  [68] = 68,
  [69] = 69,
  [70] = 70,
  [71] = 71,
  [72] = 72,
  [73] = 73,
  [74] = 74,
  [75] = 75,
  [76] = 76,
  [77] = 77,
  [78] = 78,
  [79] = 79,
  [80] = 80,
  [81] = 81,
  [82] = 82,
  [83] = 83,
  [84] = 84,
  [85] = 85,
  [86] = 86,
  [87] = 87,
  [88] = 88,
  [89] = 89,
  [90] = 90,
  [91] = 91,
  [92] = 92,
  [93] = 42,
  [94] = 94,
  [95] = 43,
  [96] = 44,
  [97] = 45,
  [98] = 46,
  [99] = 47,
  [100] = 48,
  [101] = 49,
  [102] = 50,
  [103] = 51,
  [104] = 52,
  [105] = 53,
  [106] = 54,
  [107] = 55,
  [108] = 56,
  [109] = 57,
  [110] = 58,
  [111] = 59,
  [112] = 60,
  [113] = 61,
  [114] = 62,
  [115] = 63,
  [116] = 64,
  [117] = 65,
  [118] = 66,
  [119] = 67,
  [120] = 68,
  [121] = 69,
  [122] = 70,
  [123] = 71,
  [124] = 72,
  [125] = 73,
  [126] = 74,
  [127] = 75,
  [128] = 76,
  [129] = 77,
  [130] = 78,
  [131] = 79,
  [132] = 80,
  [133] = 81,
  [134] = 82,
  [135] = 83,
  [136] = 84,
  [137] = 85,
  [138] = 86,
  [139] = 87,
  [140] = 88,
  [141] = 89,
  [142] = 90,
  [143] = 91,
  [144] = 92,
  [145] = 42,
  [146] = 94,
  [147] = 43,
  [148] = 44,
  [149] = 45,
  [150] = 46,
  [151] = 47,
  [152] = 48,
  [153] = 49,
  [154] = 50,
  [155] = 51,
  [156] = 52,
  [157] = 53,
  [158] = 54,
  [159] = 55,
  [160] = 56,
  [161] = 57,
  [162] = 58,
  [163] = 59,
  [164] = 60,
  [165] = 61,
  [166] = 62,
  [167] = 63,
  [168] = 64,
  [169] = 65,
  [170] = 66,
  [171] = 67,
  [172] = 68,
  [173] = 69,
  [174] = 70,
  [175] = 71,
  [176] = 72,
  [177] = 73,
  [178] = 74,
  [179] = 75,
  [180] = 76,
  [181] = 77,
  [182] = 78,
  [183] = 79,
  [184] = 80,
  [185] = 81,
  [186] = 82,
  [187] = 83,
  [188] = 84,
  [189] = 85,
  [190] = 86,
  [191] = 87,
  [192] = 88,
  [193] = 89,
  [194] = 90,
  [195] = 63,
  [196] = 64,
  [197] = 91,
  [198] = 92,
  [199] = 199,
  [200] = 94,
  [201] = 43,
  [202] = 44,
  [203] = 45,
  [204] = 46,
  [205] = 47,
  [206] = 48,
  [207] = 49,
  [208] = 50,
  [209] = 51,
  [210] = 52,
  [211] = 53,
  [212] = 54,
  [213] = 55,
  [214] = 56,
  [215] = 57,
  [216] = 58,
  [217] = 59,
  [218] = 60,
  [219] = 61,
  [220] = 62,
  [221] = 63,
  [222] = 94,
  [223] = 65,
  [224] = 66,
  [225] = 67,
  [226] = 68,
  [227] = 69,
  [228] = 70,
  [229] = 71,
  [230] = 72,
  [231] = 73,
  [232] = 74,
  [233] = 75,
  [234] = 76,
  [235] = 77,
  [236] = 78,
  [237] = 79,
  [238] = 80,
  [239] = 81,
  [240] = 82,
  [241] = 83,
  [242] = 84,
  [243] = 85,
  [244] = 86,
  [245] = 87,
  [246] = 88,
  [247] = 89,
  [248] = 90,
  [249] = 91,
  [250] = 92,
  [251] = 42,
  [252] = 94,
  [253] = 43,
  [254] = 44,
  [255] = 45,
  [256] = 46,
  [257] = 47,
  [258] = 48,
  [259] = 49,
  [260] = 50,
  [261] = 51,
  [262] = 52,
  [263] = 53,
  [264] = 54,
  [265] = 55,
  [266] = 56,
  [267] = 57,
  [268] = 58,
  [269] = 59,
  [270] = 60,
  [271] = 61,
  [272] = 62,
  [273] = 63,
  [274] = 64,
  [275] = 65,
  [276] = 66,
  [277] = 67,
  [278] = 68,
  [279] = 69,
  [280] = 70,
  [281] = 71,
  [282] = 72,
  [283] = 73,
  [284] = 74,
  [285] = 75,
  [286] = 76,
  [287] = 77,
  [288] = 78,
  [289] = 79,
  [290] = 80,
  [291] = 81,
  [292] = 82,
  [293] = 83,
  [294] = 84,
  [295] = 85,
  [296] = 86,
  [297] = 87,
  [298] = 88,
  [299] = 89,
  [300] = 90,
  [301] = 301,
  [302] = 302,
  [303] = 199,
  [304] = 63,
  [305] = 305,
  [306] = 63,
  [307] = 63,
  [308] = 305,
  [309] = 64,
  [310] = 63,
  [311] = 64,
  [312] = 64,
  [313] = 64,
  [314] = 301,
  [315] = 302,
  [316] = 63,
  [317] = 64,
  [318] = 199,
  [319] = 63,
  [320] = 64,
  [321] = 305,
  [322] = 91,
  [323] = 92,
  [324] = 42,
  [325] = 301,
  [326] = 302,
  [327] = 199,
  [328] = 305,
  [329] = 301,
  [330] = 302,
  [331] = 199,
  [332] = 305,
  [333] = 301,
  [334] = 302,
  [335] = 199,
  [336] = 305,
  [337] = 301,
  [338] = 302,
  [339] = 199,
  [340] = 305,
  [341] = 301,
  [342] = 302,
  [343] = 199,
  [344] = 305,
  [345] = 301,
  [346] = 302,
  [347] = 199,
  [348] = 305,
  [349] = 301,
  [350] = 302,
  [351] = 199,
  [352] = 305,
  [353] = 301,
  [354] = 302,
  [355] = 199,
  [356] = 305,
  [357] = 301,
  [358] = 302,
  [359] = 199,
  [360] = 305,
  [361] = 301,
  [362] = 302,
  [363] = 64,
  [364] = 364,
  [365] = 75,
  [366] = 76,
  [367] = 77,
  [368] = 78,
  [369] = 369,
  [370] = 79,
  [371] = 80,
  [372] = 81,
  [373] = 82,
  [374] = 83,
  [375] = 84,
  [376] = 85,
  [377] = 86,
  [378] = 87,
  [379] = 88,
  [380] = 89,
  [381] = 90,
  [382] = 91,
  [383] = 92,
  [384] = 42,
  [385] = 94,
  [386] = 43,
  [387] = 44,
  [388] = 45,
  [389] = 46,
  [390] = 47,
  [391] = 48,
  [392] = 49,
  [393] = 50,
  [394] = 51,
  [395] = 52,
  [396] = 53,
  [397] = 54,
  [398] = 55,
  [399] = 56,
  [400] = 57,
  [401] = 58,
  [402] = 59,
  [403] = 60,
  [404] = 61,
  [405] = 62,
  [406] = 44,
  [407] = 45,
  [408] = 65,
  [409] = 66,
  [410] = 67,
  [411] = 68,
  [412] = 69,
  [413] = 70,
  [414] = 71,
  [415] = 72,
  [416] = 73,
  [417] = 74,
  [418] = 75,
  [419] = 76,
  [420] = 77,
  [421] = 78,
  [422] = 46,
  [423] = 79,
  [424] = 47,
  [425] = 48,
  [426] = 80,
  [427] = 81,
  [428] = 82,
  [429] = 49,
  [430] = 83,
  [431] = 84,
  [432] = 85,
  [433] = 86,
  [434] = 87,
  [435] = 88,
  [436] = 89,
  [437] = 90,
  [438] = 50,
  [439] = 51,
  [440] = 52,
  [441] = 441,
  [442] = 53,
  [443] = 54,
  [444] = 55,
  [445] = 56,
  [446] = 57,
  [447] = 58,
  [448] = 59,
  [449] = 60,
  [450] = 61,
  [451] = 62,
  [452] = 452,
  [453] = 453,
  [454] = 65,
  [455] = 66,
  [456] = 67,
  [457] = 68,
  [458] = 69,
  [459] = 70,
  [460] = 71,
  [461] = 72,
  [462] = 73,
  [463] = 74,
  [464] = 75,
  [465] = 76,
  [466] = 77,
  [467] = 78,
  [468] = 468,
  [469] = 79,
  [470] = 91,
  [471] = 80,
  [472] = 81,
  [473] = 441,
  [474] = 82,
  [475] = 92,
  [476] = 83,
  [477] = 84,
  [478] = 85,
  [479] = 86,
  [480] = 87,
  [481] = 88,
  [482] = 89,
  [483] = 90,
  [484] = 91,
  [485] = 92,
  [486] = 42,
  [487] = 453,
  [488] = 94,
  [489] = 43,
  [490] = 42,
  [491] = 44,
  [492] = 45,
  [493] = 46,
  [494] = 47,
  [495] = 48,
  [496] = 49,
  [497] = 50,
  [498] = 51,
  [499] = 52,
  [500] = 53,
  [501] = 54,
  [502] = 55,
  [503] = 56,
  [504] = 57,
  [505] = 58,
  [506] = 441,
  [507] = 59,
  [508] = 60,
  [509] = 61,
  [510] = 62,
  [511] = 74,
  [512] = 94,
  [513] = 43,
  [514] = 65,
  [515] = 453,
  [516] = 66,
  [517] = 67,
  [518] = 68,
  [519] = 69,
  [520] = 70,
  [521] = 71,
  [522] = 72,
  [523] = 73,
  [524] = 74,
  [525] = 75,
  [526] = 76,
  [527] = 77,
  [528] = 78,
  [529] = 468,
  [530] = 79,
  [531] = 80,
  [532] = 81,
  [533] = 82,
  [534] = 83,
  [535] = 84,
  [536] = 85,
  [537] = 86,
  [538] = 87,
  [539] = 88,
  [540] = 89,
  [541] = 90,
  [542] = 441,
  [543] = 91,
  [544] = 92,
  [545] = 42,
  [546] = 94,
  [547] = 43,
  [548] = 453,
  [549] = 44,
  [550] = 45,
  [551] = 46,
  [552] = 47,
  [553] = 48,
  [554] = 49,
  [555] = 50,
  [556] = 51,
  [557] = 52,
  [558] = 53,
  [559] = 54,
  [560] = 55,
  [561] = 56,
  [562] = 57,
  [563] = 58,
  [564] = 59,
  [565] = 60,
  [566] = 61,
  [567] = 62,
  [568] = 452,
  [569] = 441,
  [570] = 65,
  [571] = 66,
  [572] = 67,
  [573] = 68,
  [574] = 69,
  [575] = 70,
  [576] = 71,
  [577] = 72,
  [578] = 73,
  [579] = 74,
  [580] = 75,
  [581] = 76,
  [582] = 77,
  [583] = 453,
  [584] = 78,
  [585] = 468,
  [586] = 79,
  [587] = 80,
  [588] = 81,
  [589] = 82,
  [590] = 83,
  [591] = 84,
  [592] = 85,
  [593] = 86,
  [594] = 87,
  [595] = 88,
  [596] = 89,
  [597] = 90,
  [598] = 91,
  [599] = 92,
  [600] = 42,
  [601] = 94,
  [602] = 43,
  [603] = 44,
  [604] = 45,
  [605] = 46,
  [606] = 47,
  [607] = 48,
  [608] = 49,
  [609] = 50,
  [610] = 51,
  [611] = 52,
  [612] = 53,
  [613] = 54,
  [614] = 55,
  [615] = 56,
  [616] = 57,
  [617] = 58,
  [618] = 59,
  [619] = 60,
  [620] = 61,
  [621] = 62,
  [622] = 65,
  [623] = 66,
  [624] = 67,
  [625] = 68,
  [626] = 69,
  [627] = 70,
  [628] = 71,
  [629] = 72,
  [630] = 73,
  [631] = 452,
  [632] = 441,
  [633] = 633,
  [634] = 633,
  [635] = 633,
  [636] = 453,
  [637] = 441,
  [638] = 638,
  [639] = 453,
  [640] = 441,
  [641] = 441,
  [642] = 633,
  [643] = 441,
  [644] = 453,
  [645] = 453,
  [646] = 453,
  [647] = 633,
  [648] = 633,
  [649] = 633,
  [650] = 633,
  [651] = 633,
  [652] = 633,
  [653] = 653,
  [654] = 654,
  [655] = 655,
  [656] = 656,
  [657] = 657,
  [658] = 658,
  [659] = 659,
  [660] = 660,
  [661] = 658,
  [662] = 660,
  [663] = 658,
  [664] = 653,
  [665] = 665,
  [666] = 659,
  [667] = 656,
  [668] = 654,
  [669] = 653,
  [670] = 655,
  [671] = 665,
  [672] = 655,
  [673] = 660,
  [674] = 656,
  [675] = 657,
  [676] = 653,
  [677] = 665,
  [678] = 654,
  [679] = 654,
  [680] = 657,
  [681] = 659,
  [682] = 660,
  [683] = 657,
  [684] = 654,
  [685] = 657,
  [686] = 659,
  [687] = 655,
  [688] = 660,
  [689] = 658,
  [690] = 658,
  [691] = 653,
  [692] = 665,
  [693] = 656,
  [694] = 659,
  [695] = 655,
  [696] = 656,
  [697] = 665,
  [698] = 654,
  [699] = 657,
  [700] = 700,
  [701] = 655,
  [702] = 656,
  [703] = 659,
  [704] = 665,
  [705] = 660,
  [706] = 658,
  [707] = 655,
  [708] = 708,
  [709] = 709,
  [710] = 656,
  [711] = 708,
  [712] = 708,
  [713] = 654,
  [714] = 709,
  [715] = 657,
  [716] = 659,
  [717] = 660,
  [718] = 658,
  [719] = 708,
  [720] = 708,
  [721] = 653,
  [722] = 665,
  [723] = 654,
  [724] = 708,
  [725] = 657,
  [726] = 659,
  [727] = 660,
  [728] = 658,
  [729] = 655,
  [730] = 656,
  [731] = 653,
  [732] = 665,
  [733] = 653,
  [734] = 665,
  [735] = 735,
  [736] = 735,
  [737] = 708,
  [738] = 708,
  [739] = 658,
  [740] = 657,
  [741] = 655,
  [742] = 656,
  [743] = 654,
  [744] = 659,
  [745] = 660,
  [746] = 708,
  [747] = 654,
  [748] = 709,
  [749] = 709,
  [750] = 700,
  [751] = 657,
  [752] = 659,
  [753] = 660,
  [754] = 658,
  [755] = 653,
  [756] = 665,
  [757] = 708,
  [758] = 700,
  [759] = 708,
  [760] = 709,
  [761] = 700,
  [762] = 655,
  [763] = 656,
  [764] = 700,
  [765] = 700,
  [766] = 735,
  [767] = 700,
  [768] = 700,
  [769] = 653,
  [770] = 700,
  [771] = 700,
  [772] = 700,
  [773] = 700,
  [774] = 708,
  [775] = 775,
  [776] = 776,
  [777] = 777,
  [778] = 778,
  [779] = 779,
  [780] = 780,
  [781] = 781,
  [782] = 782,
  [783] = 783,
  [784] = 784,
  [785] = 775,
  [786] = 786,
  [787] = 787,
  [788] = 780,
  [789] = 789,
  [790] = 790,
  [791] = 709,
  [792] = 792,
  [793] = 792,
  [794] = 794,
  [795] = 795,
  [796] = 796,
  [797] = 797,
  [798] = 798,
  [799] = 799,
  [800] = 787,
  [801] = 794,
  [802] = 799,
  [803] = 777,
  [804] = 778,
  [805] = 779,
  [806] = 780,
  [807] = 795,
  [808] = 796,
  [809] = 776,
  [810] = 797,
  [811] = 787,
  [812] = 776,
  [813] = 781,
  [814] = 781,
  [815] = 782,
  [816] = 782,
  [817] = 783,
  [818] = 784,
  [819] = 799,
  [820] = 786,
  [821] = 821,
  [822] = 783,
  [823] = 783,
  [824] = 787,
  [825] = 825,
  [826] = 789,
  [827] = 784,
  [828] = 786,
  [829] = 775,
  [830] = 777,
  [831] = 778,
  [832] = 779,
  [833] = 780,
  [834] = 786,
  [835] = 835,
  [836] = 821,
  [837] = 709,
  [838] = 792,
  [839] = 775,
  [840] = 789,
  [841] = 841,
  [842] = 825,
  [843] = 821,
  [844] = 792,
  [845] = 794,
  [846] = 777,
  [847] = 784,
  [848] = 794,
  [849] = 798,
  [850] = 795,
  [851] = 796,
  [852] = 797,
  [853] = 778,
  [854] = 779,
  [855] = 799,
  [856] = 776,
  [857] = 787,
  [858] = 709,
  [859] = 825,
  [860] = 781,
  [861] = 782,
  [862] = 795,
  [863] = 798,
  [864] = 825,
  [865] = 783,
  [866] = 784,
  [867] = 775,
  [868] = 798,
  [869] = 825,
  [870] = 786,
  [871] = 777,
  [872] = 798,
  [873] = 778,
  [874] = 825,
  [875] = 792,
  [876] = 794,
  [877] = 779,
  [878] = 798,
  [879] = 825,
  [880] = 709,
  [881] = 780,
  [882] = 798,
  [883] = 825,
  [884] = 789,
  [885] = 796,
  [886] = 798,
  [887] = 825,
  [888] = 795,
  [889] = 798,
  [890] = 798,
  [891] = 825,
  [892] = 796,
  [893] = 798,
  [894] = 825,
  [895] = 797,
  [896] = 776,
  [897] = 798,
  [898] = 789,
  [899] = 825,
  [900] = 797,
  [901] = 781,
  [902] = 782,
  [903] = 799,
  [904] = 709,
  [905] = 783,
  [906] = 777,
  [907] = 780,
  [908] = 777,
  [909] = 780,
  [910] = 795,
  [911] = 789,
  [912] = 783,
  [913] = 796,
  [914] = 784,
  [915] = 775,
  [916] = 778,
  [917] = 786,
  [918] = 787,
  [919] = 778,
  [920] = 792,
  [921] = 794,
  [922] = 778,
  [923] = 792,
  [924] = 794,
  [925] = 781,
  [926] = 795,
  [927] = 796,
  [928] = 797,
  [929] = 795,
  [930] = 799,
  [931] = 787,
  [932] = 795,
  [933] = 781,
  [934] = 796,
  [935] = 782,
  [936] = 797,
  [937] = 792,
  [938] = 782,
  [939] = 778,
  [940] = 779,
  [941] = 799,
  [942] = 796,
  [943] = 794,
  [944] = 783,
  [945] = 787,
  [946] = 776,
  [947] = 792,
  [948] = 787,
  [949] = 794,
  [950] = 789,
  [951] = 776,
  [952] = 784,
  [953] = 777,
  [954] = 799,
  [955] = 776,
  [956] = 777,
  [957] = 780,
  [958] = 778,
  [959] = 959,
  [960] = 794,
  [961] = 779,
  [962] = 781,
  [963] = 780,
  [964] = 797,
  [965] = 779,
  [966] = 782,
  [967] = 775,
  [968] = 789,
  [969] = 783,
  [970] = 780,
  [971] = 787,
  [972] = 776,
  [973] = 795,
  [974] = 781,
  [975] = 789,
  [976] = 782,
  [977] = 959,
  [978] = 796,
  [979] = 799,
  [980] = 783,
  [981] = 781,
  [982] = 782,
  [983] = 784,
  [984] = 797,
  [985] = 959,
  [986] = 775,
  [987] = 786,
  [988] = 784,
  [989] = 777,
  [990] = 775,
  [991] = 784,
  [992] = 775,
  [993] = 786,
  [994] = 786,
  [995] = 995,
  [996] = 786,
  [997] = 779,
  [998] = 797,
  [999] = 799,
  [1000] = 789,
  [1001] = 776,
  [1002] = 779,
  [1003] = 792,
  [1004] = 1004,
  [1005] = 1005,
  [1006] = 1006,
  [1007] = 1007,
  [1008] = 1008,
  [1009] = 1005,
  [1010] = 1008,
  [1011] = 1011,
  [1012] = 1011,
  [1013] = 1013,
  [1014] = 1014,
  [1015] = 1015,
  [1016] = 1016,
  [1017] = 1013,
  [1018] = 1018,
  [1019] = 1019,
  [1020] = 1020,
  [1021] = 1021,
  [1022] = 1022,
  [1023] = 1023,
  [1024] = 1024,
  [1025] = 1025,
  [1026] = 1026,
  [1027] = 1027,
  [1028] = 1028,
  [1029] = 1029,
  [1030] = 1030,
  [1031] = 1031,
  [1032] = 1032,
  [1033] = 1033,
  [1034] = 1034,
  [1035] = 1035,
  [1036] = 1036,
  [1037] = 1037,
  [1038] = 1038,
  [1039] = 1039,
  [1040] = 1040,
  [1041] = 1041,
  [1042] = 1042,
  [1043] = 1043,
  [1044] = 1004,
  [1045] = 1045,
  [1046] = 1046,
  [1047] = 1047,
  [1048] = 1048,
  [1049] = 1014,
  [1050] = 1050,
  [1051] = 1051,
  [1052] = 1020,
  [1053] = 1021,
  [1054] = 1022,
  [1055] = 1023,
  [1056] = 1025,
  [1057] = 1026,
  [1058] = 1027,
  [1059] = 1059,
  [1060] = 1028,
  [1061] = 1015,
  [1062] = 1029,
  [1063] = 1030,
  [1064] = 1031,
  [1065] = 1033,
  [1066] = 1037,
  [1067] = 1038,
  [1068] = 1040,
  [1069] = 1041,
  [1070] = 1004,
  [1071] = 1045,
  [1072] = 1046,
  [1073] = 1047,
  [1074] = 1048,
  [1075] = 1050,
  [1076] = 1076,
  [1077] = 1077,
  [1078] = 1078,
  [1079] = 1059,
  [1080] = 1051,
  [1081] = 1006,
  [1082] = 1007,
  [1083] = 1005,
  [1084] = 1008,
  [1085] = 1076,
  [1086] = 1077,
  [1087] = 1011,
  [1088] = 1078,
  [1089] = 1051,
  [1090] = 1013,
  [1091] = 1006,
  [1092] = 1007,
  [1093] = 1015,
  [1094] = 1005,
  [1095] = 1008,
  [1096] = 1016,
  [1097] = 1011,
  [1098] = 1013,
  [1099] = 1018,
  [1100] = 1015,
  [1101] = 1016,
  [1102] = 1018,
  [1103] = 1016,
  [1104] = 1024,
  [1105] = 1024,
  [1106] = 1034,
  [1107] = 1035,
  [1108] = 1036,
  [1109] = 1034,
  [1110] = 1035,
  [1111] = 1039,
  [1112] = 1042,
  [1113] = 1043,
  [1114] = 1036,
  [1115] = 1039,
  [1116] = 1014,
  [1117] = 1019,
  [1118] = 1020,
  [1119] = 1021,
  [1120] = 1022,
  [1121] = 1023,
  [1122] = 1042,
  [1123] = 1043,
  [1124] = 1025,
  [1125] = 1026,
  [1126] = 1027,
  [1127] = 1028,
  [1128] = 1029,
  [1129] = 1030,
  [1130] = 1014,
  [1131] = 1131,
  [1132] = 1031,
  [1133] = 1033,
  [1134] = 1037,
  [1135] = 1038,
  [1136] = 1040,
  [1137] = 1041,
  [1138] = 1004,
  [1139] = 1045,
  [1140] = 1046,
  [1141] = 1047,
  [1142] = 1048,
  [1143] = 1050,
  [1144] = 1019,
  [1145] = 1020,
  [1146] = 1021,
  [1147] = 1022,
  [1148] = 1023,
  [1149] = 1018,
  [1150] = 1059,
  [1151] = 1025,
  [1152] = 1152,
  [1153] = 1026,
  [1154] = 1027,
  [1155] = 1028,
  [1156] = 1076,
  [1157] = 1029,
  [1158] = 1077,
  [1159] = 1078,
  [1160] = 1030,
  [1161] = 1051,
  [1162] = 1006,
  [1163] = 1007,
  [1164] = 1005,
  [1165] = 1008,
  [1166] = 1031,
  [1167] = 1011,
  [1168] = 1032,
  [1169] = 1013,
  [1170] = 1033,
  [1171] = 1015,
  [1172] = 1037,
  [1173] = 1016,
  [1174] = 1038,
  [1175] = 1018,
  [1176] = 1040,
  [1177] = 1041,
  [1178] = 1004,
  [1179] = 1045,
  [1180] = 1046,
  [1181] = 1047,
  [1182] = 1048,
  [1183] = 1050,
  [1184] = 1024,
  [1185] = 1024,
  [1186] = 1026,
  [1187] = 1024,
  [1188] = 1059,
  [1189] = 1027,
  [1190] = 1059,
  [1191] = 1076,
  [1192] = 1034,
  [1193] = 1035,
  [1194] = 1036,
  [1195] = 1077,
  [1196] = 1039,
  [1197] = 1078,
  [1198] = 1042,
  [1199] = 1043,
  [1200] = 1051,
  [1201] = 1006,
  [1202] = 1007,
  [1203] = 1014,
  [1204] = 1005,
  [1205] = 1019,
  [1206] = 1020,
  [1207] = 1021,
  [1208] = 1022,
  [1209] = 1023,
  [1210] = 1025,
  [1211] = 1026,
  [1212] = 1027,
  [1213] = 1028,
  [1214] = 1029,
  [1215] = 1030,
  [1216] = 1031,
  [1217] = 1033,
  [1218] = 1037,
  [1219] = 1038,
  [1220] = 1040,
  [1221] = 1041,
  [1222] = 1004,
  [1223] = 1045,
  [1224] = 1046,
  [1225] = 1047,
  [1226] = 1048,
  [1227] = 1050,
  [1228] = 1059,
  [1229] = 1008,
  [1230] = 1076,
  [1231] = 1077,
  [1232] = 1078,
  [1233] = 1051,
  [1234] = 1006,
  [1235] = 1007,
  [1236] = 1005,
  [1237] = 1008,
  [1238] = 1011,
  [1239] = 1013,
  [1240] = 1015,
  [1241] = 1016,
  [1242] = 1018,
  [1243] = 1011,
  [1244] = 1024,
  [1245] = 1034,
  [1246] = 1035,
  [1247] = 1036,
  [1248] = 1039,
  [1249] = 1042,
  [1250] = 1043,
  [1251] = 1014,
  [1252] = 1019,
  [1253] = 1020,
  [1254] = 1021,
  [1255] = 1022,
  [1256] = 1023,
  [1257] = 1013,
  [1258] = 1258,
  [1259] = 1015,
  [1260] = 1260,
  [1261] = 1016,
  [1262] = 1025,
  [1263] = 1026,
  [1264] = 1018,
  [1265] = 1027,
  [1266] = 1034,
  [1267] = 1028,
  [1268] = 1035,
  [1269] = 1029,
  [1270] = 1030,
  [1271] = 1036,
  [1272] = 1031,
  [1273] = 1033,
  [1274] = 1037,
  [1275] = 1038,
  [1276] = 1040,
  [1277] = 1041,
  [1278] = 1004,
  [1279] = 1045,
  [1280] = 1046,
  [1281] = 1047,
  [1282] = 1048,
  [1283] = 1050,
  [1284] = 1034,
  [1285] = 1035,
  [1286] = 1039,
  [1287] = 1024,
  [1288] = 1059,
  [1289] = 1042,
  [1290] = 1043,
  [1291] = 1291,
  [1292] = 1036,
  [1293] = 1028,
  [1294] = 1014,
  [1295] = 1076,
  [1296] = 1077,
  [1297] = 1039,
  [1298] = 1078,
  [1299] = 1029,
  [1300] = 1051,
  [1301] = 1019,
  [1302] = 1006,
  [1303] = 1020,
  [1304] = 1007,
  [1305] = 1021,
  [1306] = 1005,
  [1307] = 1034,
  [1308] = 1008,
  [1309] = 1035,
  [1310] = 1011,
  [1311] = 1013,
  [1312] = 1022,
  [1313] = 1015,
  [1314] = 1023,
  [1315] = 1016,
  [1316] = 1036,
  [1317] = 1018,
  [1318] = 1039,
  [1319] = 1030,
  [1320] = 1042,
  [1321] = 1042,
  [1322] = 1043,
  [1323] = 1025,
  [1324] = 1024,
  [1325] = 1043,
  [1326] = 1026,
  [1327] = 1027,
  [1328] = 1014,
  [1329] = 1028,
  [1330] = 1019,
  [1331] = 1020,
  [1332] = 1021,
  [1333] = 1022,
  [1334] = 1023,
  [1335] = 1029,
  [1336] = 1030,
  [1337] = 1034,
  [1338] = 1035,
  [1339] = 1036,
  [1340] = 1076,
  [1341] = 1025,
  [1342] = 1039,
  [1343] = 1014,
  [1344] = 1026,
  [1345] = 1042,
  [1346] = 1043,
  [1347] = 1027,
  [1348] = 1031,
  [1349] = 1028,
  [1350] = 1032,
  [1351] = 1014,
  [1352] = 1029,
  [1353] = 1033,
  [1354] = 1030,
  [1355] = 1019,
  [1356] = 1020,
  [1357] = 1021,
  [1358] = 1022,
  [1359] = 1023,
  [1360] = 1037,
  [1361] = 1038,
  [1362] = 1040,
  [1363] = 1041,
  [1364] = 1031,
  [1365] = 1025,
  [1366] = 1032,
  [1367] = 1026,
  [1368] = 1033,
  [1369] = 1027,
  [1370] = 1037,
  [1371] = 1028,
  [1372] = 1038,
  [1373] = 1029,
  [1374] = 1040,
  [1375] = 1030,
  [1376] = 1041,
  [1377] = 1004,
  [1378] = 1045,
  [1379] = 1046,
  [1380] = 1031,
  [1381] = 1033,
  [1382] = 1037,
  [1383] = 1038,
  [1384] = 1040,
  [1385] = 1041,
  [1386] = 1004,
  [1387] = 1045,
  [1388] = 1046,
  [1389] = 1047,
  [1390] = 1048,
  [1391] = 1050,
  [1392] = 1047,
  [1393] = 1048,
  [1394] = 1050,
  [1395] = 1004,
  [1396] = 1045,
  [1397] = 1046,
  [1398] = 1047,
  [1399] = 1048,
  [1400] = 1050,
  [1401] = 1059,
  [1402] = 1077,
  [1403] = 1019,
  [1404] = 1059,
  [1405] = 1020,
  [1406] = 1021,
  [1407] = 1022,
  [1408] = 1076,
  [1409] = 1023,
  [1410] = 1077,
  [1411] = 1078,
  [1412] = 1078,
  [1413] = 1051,
  [1414] = 1059,
  [1415] = 1006,
  [1416] = 1051,
  [1417] = 1007,
  [1418] = 1076,
  [1419] = 1005,
  [1420] = 1008,
  [1421] = 1077,
  [1422] = 1011,
  [1423] = 1006,
  [1424] = 1013,
  [1425] = 1078,
  [1426] = 1015,
  [1427] = 1025,
  [1428] = 1016,
  [1429] = 1051,
  [1430] = 1018,
  [1431] = 1019,
  [1432] = 1006,
  [1433] = 1026,
  [1434] = 1007,
  [1435] = 1007,
  [1436] = 1005,
  [1437] = 1027,
  [1438] = 1008,
  [1439] = 1020,
  [1440] = 1011,
  [1441] = 1076,
  [1442] = 1024,
  [1443] = 1013,
  [1444] = 1028,
  [1445] = 1015,
  [1446] = 1077,
  [1447] = 1016,
  [1448] = 1005,
  [1449] = 1018,
  [1450] = 1078,
  [1451] = 1029,
  [1452] = 1051,
  [1453] = 1031,
  [1454] = 1006,
  [1455] = 1030,
  [1456] = 1007,
  [1457] = 1008,
  [1458] = 1005,
  [1459] = 1032,
  [1460] = 1008,
  [1461] = 1034,
  [1462] = 1035,
  [1463] = 1036,
  [1464] = 1024,
  [1465] = 1011,
  [1466] = 1039,
  [1467] = 1011,
  [1468] = 1033,
  [1469] = 1042,
  [1470] = 1043,
  [1471] = 1013,
  [1472] = 1031,
  [1473] = 1015,
  [1474] = 1032,
  [1475] = 1016,
  [1476] = 1014,
  [1477] = 1033,
  [1478] = 1018,
  [1479] = 1037,
  [1480] = 1038,
  [1481] = 1040,
  [1482] = 1041,
  [1483] = 1152,
  [1484] = 1258,
  [1485] = 1260,
  [1486] = 1034,
  [1487] = 1291,
  [1488] = 1035,
  [1489] = 1013,
  [1490] = 1036,
  [1491] = 1045,
  [1492] = 1046,
  [1493] = 1039,
  [1494] = 1047,
  [1495] = 1048,
  [1496] = 1050,
  [1497] = 1042,
  [1498] = 1043,
  [1499] = 1037,
  [1500] = 1015,
  [1501] = 1038,
  [1502] = 1016,
  [1503] = 1024,
  [1504] = 1014,
  [1505] = 1040,
  [1506] = 1018,
  [1507] = 1152,
  [1508] = 1258,
  [1509] = 1260,
  [1510] = 1291,
  [1511] = 1041,
  [1512] = 1019,
  [1513] = 1020,
  [1514] = 1021,
  [1515] = 1022,
  [1516] = 1023,
  [1517] = 1004,
  [1518] = 1152,
  [1519] = 1258,
  [1520] = 1260,
  [1521] = 1291,
  [1522] = 1045,
  [1523] = 1059,
  [1524] = 1025,
  [1525] = 1046,
  [1526] = 1026,
  [1527] = 1152,
  [1528] = 1258,
  [1529] = 1260,
  [1530] = 1291,
  [1531] = 1027,
  [1532] = 1028,
  [1533] = 1029,
  [1534] = 1152,
  [1535] = 1258,
  [1536] = 1260,
  [1537] = 1291,
  [1538] = 1030,
  [1539] = 1047,
  [1540] = 1048,
  [1541] = 1076,
  [1542] = 1031,
  [1543] = 1033,
  [1544] = 1152,
  [1545] = 1258,
  [1546] = 1260,
  [1547] = 1291,
  [1548] = 1037,
  [1549] = 1038,
  [1550] = 1040,
  [1551] = 1041,
  [1552] = 1004,
  [1553] = 1045,
  [1554] = 1046,
  [1555] = 1152,
  [1556] = 1258,
  [1557] = 1260,
  [1558] = 1291,
  [1559] = 1047,
  [1560] = 1048,
  [1561] = 1050,
  [1562] = 1050,
  [1563] = 1077,
  [1564] = 1078,
  [1565] = 1152,
  [1566] = 1258,
  [1567] = 1260,
  [1568] = 1291,
  [1569] = 1034,
  [1570] = 1035,
  [1571] = 1021,
  [1572] = 1059,
  [1573] = 1051,
  [1574] = 1152,
  [1575] = 1258,
  [1576] = 1260,
  [1577] = 1291,
  [1578] = 1036,
  [1579] = 1022,
  [1580] = 1006,
  [1581] = 1039,
  [1582] = 1023,
  [1583] = 1152,
  [1584] = 1258,
  [1585] = 1260,
  [1586] = 1291,
  [1587] = 1007,
  [1588] = 1076,
  [1589] = 1025,
  [1590] = 1077,
  [1591] = 1042,
  [1592] = 1078,
  [1593] = 1043,
  [1594] = 1152,
  [1595] = 1258,
  [1596] = 1260,
  [1597] = 1291,
  [1598] = 1019,
  [1599] = 1599,
  [1600] = 1599,
  [1601] = 1601,
  [1602] = 1602,
  [1603] = 1603,
  [1604] = 1599,
  [1605] = 1601,
  [1606] = 1601,
  [1607] = 1607,
  [1608] = 1603,
  [1609] = 1599,
  [1610] = 1603,
  [1611] = 1607,
  [1612] = 1599,
  [1613] = 1607,
  [1614] = 1599,
  [1615] = 1601,
  [1616] = 1601,
  [1617] = 1603,
  [1618] = 1607,
  [1619] = 1599,
  [1620] = 1603,
  [1621] = 1621,
  [1622] = 1601,
  [1623] = 1623,
  [1624] = 1607,
  [1625] = 1599,
  [1626] = 1603,
  [1627] = 1627,
  [1628] = 1601,
  [1629] = 1607,
  [1630] = 1601,
  [1631] = 1603,
  [1632] = 1603,
  [1633] = 1607,
  [1634] = 1599,
  [1635] = 1607,
  [1636] = 1636,
  [1637] = 1603,
  [1638] = 1603,
  [1639] = 1603,
  [1640] = 1607,
  [1641] = 1636,
  [1642] = 1601,
  [1643] = 1599,
  [1644] = 1607,
  [1645] = 1599,
  [1646] = 1607,
  [1647] = 1599,
  [1648] = 1601,
  [1649] = 1601,
  [1650] = 1603,
  [1651] = 1601,
  [1652] = 1652,
  [1653] = 1627,
  [1654] = 1623,
  [1655] = 1621,
  [1656] = 1607,
  [1657] = 1652,
  [1658] = 1627,
  [1659] = 1623,
  [1660] = 1621,
  [1661] = 1652,
  [1662] = 1627,
  [1663] = 1623,
  [1664] = 1621,
  [1665] = 1652,
  [1666] = 1627,
  [1667] = 1623,
  [1668] = 1621,
  [1669] = 1652,
  [1670] = 1627,
  [1671] = 1623,
  [1672] = 1621,
  [1673] = 1652,
  [1674] = 1627,
  [1675] = 1623,
  [1676] = 1621,
  [1677] = 1652,
  [1678] = 1627,
  [1679] = 1623,
  [1680] = 1621,
  [1681] = 1652,
  [1682] = 1627,
  [1683] = 1623,
  [1684] = 1621,
  [1685] = 1652,
  [1686] = 1627,
  [1687] = 1623,
  [1688] = 1621,
  [1689] = 1652,
  [1690] = 1627,
  [1691] = 1623,
  [1692] = 1621,
  [1693] = 1652,
  [1694] = 1627,
  [1695] = 1623,
  [1696] = 1621,
  [1697] = 1602,
  [1698] = 1636,
  [1699] = 1602,
  [1700] = 1636,
  [1701] = 1602,
  [1702] = 1636,
  [1703] = 1602,
  [1704] = 1636,
  [1705] = 1602,
  [1706] = 1636,
  [1707] = 1602,
  [1708] = 1636,
  [1709] = 1602,
  [1710] = 1636,
  [1711] = 1602,
  [1712] = 1636,
  [1713] = 1602,
  [1714] = 1636,
  [1715] = 1602,
  [1716] = 1636,
  [1717] = 1602,
  [1718] = 1652,
  [1719] = 441,
  [1720] = 453,
  [1721] = 441,
  [1722] = 453,
  [1723] = 633,
  [1724] = 3,
  [1725] = 7,
  [1726] = 5,
  [1727] = 3,
  [1728] = 5,
  [1729] = 633,
  [1730] = 2,
  [1731] = 2,
  [1732] = 7,
  [1733] = 56,
  [1734] = 88,
  [1735] = 46,
  [1736] = 89,
  [1737] = 90,
  [1738] = 47,
  [1739] = 82,
  [1740] = 48,
  [1741] = 49,
  [1742] = 42,
  [1743] = 94,
  [1744] = 80,
  [1745] = 83,
  [1746] = 50,
  [1747] = 81,
  [1748] = 51,
  [1749] = 709,
  [1750] = 52,
  [1751] = 53,
  [1752] = 54,
  [1753] = 55,
  [1754] = 91,
  [1755] = 44,
  [1756] = 57,
  [1757] = 92,
  [1758] = 59,
  [1759] = 43,
  [1760] = 60,
  [1761] = 61,
  [1762] = 62,
  [1763] = 84,
  [1764] = 85,
  [1765] = 65,
  [1766] = 66,
  [1767] = 67,
  [1768] = 68,
  [1769] = 69,
  [1770] = 70,
  [1771] = 71,
  [1772] = 86,
  [1773] = 72,
  [1774] = 73,
  [1775] = 74,
  [1776] = 75,
  [1777] = 45,
  [1778] = 76,
  [1779] = 77,
  [1780] = 78,
  [1781] = 79,
  [1782] = 87,
  [1783] = 58,
  [1784] = 55,
  [1785] = 59,
  [1786] = 1786,
  [1787] = 44,
  [1788] = 43,
  [1789] = 1789,
  [1790] = 1786,
  [1791] = 1791,
  [1792] = 1792,
  [1793] = 1793,
  [1794] = 65,
  [1795] = 66,
  [1796] = 67,
  [1797] = 68,
  [1798] = 69,
  [1799] = 1786,
  [1800] = 1791,
  [1801] = 70,
  [1802] = 92,
  [1803] = 1792,
  [1804] = 1793,
  [1805] = 87,
  [1806] = 71,
  [1807] = 72,
  [1808] = 73,
  [1809] = 1786,
  [1810] = 1791,
  [1811] = 74,
  [1812] = 75,
  [1813] = 1792,
  [1814] = 1793,
  [1815] = 1793,
  [1816] = 76,
  [1817] = 77,
  [1818] = 1786,
  [1819] = 78,
  [1820] = 1791,
  [1821] = 1792,
  [1822] = 1793,
  [1823] = 1791,
  [1824] = 1786,
  [1825] = 1791,
  [1826] = 1792,
  [1827] = 79,
  [1828] = 1793,
  [1829] = 1786,
  [1830] = 1791,
  [1831] = 1792,
  [1832] = 1793,
  [1833] = 60,
  [1834] = 1786,
  [1835] = 1791,
  [1836] = 1836,
  [1837] = 1792,
  [1838] = 1793,
  [1839] = 82,
  [1840] = 52,
  [1841] = 1786,
  [1842] = 1791,
  [1843] = 56,
  [1844] = 88,
  [1845] = 1792,
  [1846] = 1793,
  [1847] = 1786,
  [1848] = 50,
  [1849] = 1792,
  [1850] = 1793,
  [1851] = 1851,
  [1852] = 53,
  [1853] = 80,
  [1854] = 42,
  [1855] = 1786,
  [1856] = 1791,
  [1857] = 1792,
  [1858] = 1793,
  [1859] = 1836,
  [1860] = 1789,
  [1861] = 81,
  [1862] = 61,
  [1863] = 1836,
  [1864] = 1789,
  [1865] = 57,
  [1866] = 1836,
  [1867] = 1789,
  [1868] = 45,
  [1869] = 89,
  [1870] = 1836,
  [1871] = 709,
  [1872] = 1789,
  [1873] = 83,
  [1874] = 90,
  [1875] = 1836,
  [1876] = 1789,
  [1877] = 84,
  [1878] = 1836,
  [1879] = 46,
  [1880] = 1789,
  [1881] = 58,
  [1882] = 1836,
  [1883] = 62,
  [1884] = 1789,
  [1885] = 1836,
  [1886] = 1789,
  [1887] = 1836,
  [1888] = 1789,
  [1889] = 47,
  [1890] = 1836,
  [1891] = 1789,
  [1892] = 1786,
  [1893] = 1791,
  [1894] = 48,
  [1895] = 49,
  [1896] = 1836,
  [1897] = 1792,
  [1898] = 1789,
  [1899] = 1793,
  [1900] = 94,
  [1901] = 54,
  [1902] = 1792,
  [1903] = 91,
  [1904] = 85,
  [1905] = 86,
  [1906] = 51,
  [1907] = 1791,
  [1908] = 1908,
  [1909] = 1908,
  [1910] = 655,
  [1911] = 656,
  [1912] = 1912,
  [1913] = 654,
  [1914] = 659,
  [1915] = 653,
  [1916] = 1916,
  [1917] = 665,
  [1918] = 1918,
  [1919] = 1908,
  [1920] = 1920,
  [1921] = 1921,
  [1922] = 660,
  [1923] = 658,
  [1924] = 1924,
  [1925] = 1918,
  [1926] = 1918,
  [1927] = 1920,
  [1928] = 1912,
  [1929] = 657,
  [1930] = 1916,
  [1931] = 1924,
  [1932] = 1921,
  [1933] = 1921,
  [1934] = 1912,
  [1935] = 1935,
  [1936] = 1920,
  [1937] = 1916,
  [1938] = 1924,
  [1939] = 665,
  [1940] = 709,
  [1941] = 658,
  [1942] = 654,
  [1943] = 655,
  [1944] = 653,
  [1945] = 659,
  [1946] = 656,
  [1947] = 660,
  [1948] = 657,
  [1949] = 1949,
  [1950] = 795,
  [1951] = 782,
  [1952] = 1952,
  [1953] = 786,
  [1954] = 1954,
  [1955] = 794,
  [1956] = 776,
  [1957] = 784,
  [1958] = 777,
  [1959] = 789,
  [1960] = 797,
  [1961] = 783,
  [1962] = 778,
  [1963] = 779,
  [1964] = 792,
  [1965] = 799,
  [1966] = 780,
  [1967] = 781,
  [1968] = 787,
  [1969] = 775,
  [1970] = 796,
  [1971] = 1971,
  [1972] = 783,
  [1973] = 778,
  [1974] = 776,
  [1975] = 792,
  [1976] = 784,
  [1977] = 780,
  [1978] = 794,
  [1979] = 795,
  [1980] = 779,
  [1981] = 789,
  [1982] = 799,
  [1983] = 787,
  [1984] = 781,
  [1985] = 775,
  [1986] = 777,
  [1987] = 796,
  [1988] = 797,
  [1989] = 782,
  [1990] = 786,
  [1991] = 1991,
  [1992] = 1992,
  [1993] = 1993,
  [1994] = 1994,
  [1995] = 1995,
  [1996] = 1996,
  [1997] = 1997,
  [1998] = 1998,
  [1999] = 1997,
  [2000] = 1996,
  [2001] = 1998,
  [2002] = 1996,
  [2003] = 2003,
  [2004] = 2004,
  [2005] = 1994,
  [2006] = 1997,
  [2007] = 1994,
  [2008] = 1997,
  [2009] = 1994,
  [2010] = 1997,
  [2011] = 1998,
  [2012] = 1998,
  [2013] = 1996,
  [2014] = 1996,
  [2015] = 2015,
  [2016] = 1994,
  [2017] = 2017,
  [2018] = 1998,
  [2019] = 1996,
  [2020] = 1997,
  [2021] = 2021,
  [2022] = 1994,
  [2023] = 2023,
  [2024] = 1997,
  [2025] = 1998,
  [2026] = 2026,
  [2027] = 1998,
  [2028] = 1996,
  [2029] = 1997,
  [2030] = 1994,
  [2031] = 1993,
  [2032] = 2032,
  [2033] = 1998,
  [2034] = 1996,
  [2035] = 1998,
  [2036] = 2004,
  [2037] = 2021,
  [2038] = 1997,
  [2039] = 1994,
  [2040] = 2004,
  [2041] = 2021,
  [2042] = 1997,
  [2043] = 2004,
  [2044] = 2021,
  [2045] = 1994,
  [2046] = 2004,
  [2047] = 2021,
  [2048] = 1994,
  [2049] = 2004,
  [2050] = 2021,
  [2051] = 2004,
  [2052] = 2021,
  [2053] = 1997,
  [2054] = 2004,
  [2055] = 1994,
  [2056] = 2021,
  [2057] = 2004,
  [2058] = 1998,
  [2059] = 2021,
  [2060] = 1996,
  [2061] = 2004,
  [2062] = 1998,
  [2063] = 2021,
  [2064] = 1996,
  [2065] = 2004,
  [2066] = 1997,
  [2067] = 2021,
  [2068] = 1998,
  [2069] = 2004,
  [2070] = 2021,
  [2071] = 2003,
  [2072] = 1996,
  [2073] = 1993,
  [2074] = 2003,
  [2075] = 1993,
  [2076] = 2003,
  [2077] = 1993,
  [2078] = 2003,
  [2079] = 1993,
  [2080] = 2003,
  [2081] = 1993,
  [2082] = 2003,
  [2083] = 1993,
  [2084] = 2003,
  [2085] = 1993,
  [2086] = 2003,
  [2087] = 1993,
  [2088] = 2003,
  [2089] = 1996,
  [2090] = 2003,
  [2091] = 1993,
  [2092] = 2003,
  [2093] = 2023,
  [2094] = 1993,
  [2095] = 2015,
  [2096] = 2023,
  [2097] = 2015,
  [2098] = 2023,
  [2099] = 2015,
  [2100] = 2023,
  [2101] = 2015,
  [2102] = 2023,
  [2103] = 2015,
  [2104] = 2023,
  [2105] = 2015,
  [2106] = 2023,
  [2107] = 2015,
  [2108] = 2023,
  [2109] = 2015,
  [2110] = 2023,
  [2111] = 2015,
  [2112] = 2023,
  [2113] = 2015,
  [2114] = 2023,
  [2115] = 2015,
  [2116] = 1994,
  [2117] = 2117,
  [2118] = 2118,
  [2119] = 2119,
  [2120] = 2118,
  [2121] = 2121,
  [2122] = 2118,
  [2123] = 2118,
  [2124] = 2118,
  [2125] = 2118,
  [2126] = 2118,
  [2127] = 2118,
  [2128] = 2118,
  [2129] = 2129,
  [2130] = 2118,
  [2131] = 2118,
  [2132] = 2118,
  [2133] = 709,
  [2134] = 2134,
  [2135] = 2135,
  [2136] = 2134,
  [2137] = 2134,
  [2138] = 2138,
  [2139] = 2134,
  [2140] = 2134,
  [2141] = 2134,
  [2142] = 2134,
  [2143] = 2134,
  [2144] = 2134,
  [2145] = 2134,
  [2146] = 2146,
  [2147] = 2134,
  [2148] = 2134,
  [2149] = 2149,
  [2150] = 2150,
  [2151] = 2151,
  [2152] = 2152,
  [2153] = 2153,
  [2154] = 2150,
  [2155] = 2151,
  [2156] = 2150,
  [2157] = 2151,
  [2158] = 2150,
  [2159] = 2151,
  [2160] = 2152,
  [2161] = 2153,
  [2162] = 2150,
  [2163] = 2151,
  [2164] = 2152,
  [2165] = 2153,
  [2166] = 2150,
  [2167] = 2151,
  [2168] = 2152,
  [2169] = 2150,
  [2170] = 2151,
  [2171] = 2151,
  [2172] = 2150,
  [2173] = 2151,
  [2174] = 2151,
  [2175] = 2153,
  [2176] = 2152,
  [2177] = 2153,
  [2178] = 2178,
  [2179] = 2153,
  [2180] = 2151,
  [2181] = 2152,
  [2182] = 2152,
  [2183] = 2153,
  [2184] = 2152,
  [2185] = 2150,
  [2186] = 2152,
  [2187] = 2151,
  [2188] = 2152,
  [2189] = 2153,
  [2190] = 2153,
  [2191] = 2150,
  [2192] = 2150,
  [2193] = 2153,
  [2194] = 2152,
  [2195] = 2153,
  [2196] = 2150,
  [2197] = 2153,
  [2198] = 2152,
};

static TSCharacterRange sym_identifier_character_set_1[] = {
  {'.', '.'}, {'A', 'Z'}, {'_', 'z'}, {0xaa, 0xaa}, {0xb5, 0xb5}, {0xba, 0xba}, {0xc0, 0xd6}, {0xd8, 0xf6},
  {0xf8, 0x2c1}, {0x2c6, 0x2d1}, {0x2e0, 0x2e4}, {0x2ec, 0x2ec}, {0x2ee, 0x2ee}, {0x370, 0x374}, {0x376, 0x377}, {0x37b, 0x37d},
  {0x37f, 0x37f}, {0x386, 0x386}, {0x388, 0x38a}, {0x38c, 0x38c}, {0x38e, 0x3a1}, {0x3a3, 0x3f5}, {0x3f7, 0x481}, {0x48a, 0x52f},
  {0x531, 0x556}, {0x559, 0x559}, {0x560, 0x588}, {0x5d0, 0x5ea}, {0x5ef, 0x5f2}, {0x620, 0x64a}, {0x66e, 0x66f}, {0x671, 0x6d3},
  {0x6d5, 0x6d5}, {0x6e5, 0x6e6}, {0x6ee, 0x6ef}, {0x6fa, 0x6fc}, {0x6ff, 0x6ff}, {0x710, 0x710}, {0x712, 0x72f}, {0x74d, 0x7a5},
  {0x7b1, 0x7b1}, {0x7ca, 0x7ea}, {0x7f4, 0x7f5}, {0x7fa, 0x7fa}, {0x800, 0x815}, {0x81a, 0x81a}, {0x824, 0x824}, {0x828, 0x828},
  {0x840, 0x858}, {0x860, 0x86a}, {0x870, 0x887}, {0x889, 0x88e}, {0x8a0, 0x8c9}, {0x904, 0x939}, {0x93d, 0x93d}, {0x950, 0x950},
  {0x958, 0x961}, {0x971, 0x980}, {0x985, 0x98c}, {0x98f, 0x990}, {0x993, 0x9a8}, {0x9aa, 0x9b0}, {0x9b2, 0x9b2}, {0x9b6, 0x9b9},
  {0x9bd, 0x9bd}, {0x9ce, 0x9ce}, {0x9dc, 0x9dd}, {0x9df, 0x9e1}, {0x9f0, 0x9f1}, {0x9fc, 0x9fc}, {0xa05, 0xa0a}, {0xa0f, 0xa10},
  {0xa13, 0xa28}, {0xa2a, 0xa30}, {0xa32, 0xa33}, {0xa35, 0xa36}, {0xa38, 0xa39}, {0xa59, 0xa5c}, {0xa5e, 0xa5e}, {0xa72, 0xa74},
  {0xa85, 0xa8d}, {0xa8f, 0xa91}, {0xa93, 0xaa8}, {0xaaa, 0xab0}, {0xab2, 0xab3}, {0xab5, 0xab9}, {0xabd, 0xabd}, {0xad0, 0xad0},
  {0xae0, 0xae1}, {0xaf9, 0xaf9}, {0xb05, 0xb0c}, {0xb0f, 0xb10}, {0xb13, 0xb28}, {0xb2a, 0xb30}, {0xb32, 0xb33}, {0xb35, 0xb39},
  {0xb3d, 0xb3d}, {0xb5c, 0xb5d}, {0xb5f, 0xb61}, {0xb71, 0xb71}, {0xb83, 0xb83}, {0xb85, 0xb8a}, {0xb8e, 0xb90}, {0xb92, 0xb95},
  {0xb99, 0xb9a}, {0xb9c, 0xb9c}, {0xb9e, 0xb9f}, {0xba3, 0xba4}, {0xba8, 0xbaa}, {0xbae, 0xbb9}, {0xbd0, 0xbd0}, {0xc05, 0xc0c},
  {0xc0e, 0xc10}, {0xc12, 0xc28}, {0xc2a, 0xc39}, {0xc3d, 0xc3d}, {0xc58, 0xc5a}, {0xc5d, 0xc5d}, {0xc60, 0xc61}, {0xc80, 0xc80},
  {0xc85, 0xc8c}, {0xc8e, 0xc90}, {0xc92, 0xca8}, {0xcaa, 0xcb3}, {0xcb5, 0xcb9}, {0xcbd, 0xcbd}, {0xcdd, 0xcde}, {0xce0, 0xce1},
  {0xcf1, 0xcf2}, {0xd04, 0xd0c}, {0xd0e, 0xd10}, {0xd12, 0xd3a}, {0xd3d, 0xd3d}, {0xd4e, 0xd4e}, {0xd54, 0xd56}, {0xd5f, 0xd61},
  {0xd7a, 0xd7f}, {0xd85, 0xd96}, {0xd9a, 0xdb1}, {0xdb3, 0xdbb}, {0xdbd, 0xdbd}, {0xdc0, 0xdc6}, {0xe01, 0xe30}, {0xe32, 0xe32},
  {0xe40, 0xe46}, {0xe81, 0xe82}, {0xe84, 0xe84}, {0xe86, 0xe8a}, {0xe8c, 0xea3}, {0xea5, 0xea5}, {0xea7, 0xeb0}, {0xeb2, 0xeb2},
  {0xebd, 0xebd}, {0xec0, 0xec4}, {0xec6, 0xec6}, {0xedc, 0xedf}, {0xf00, 0xf00}, {0xf40, 0xf47}, {0xf49, 0xf6c}, {0xf88, 0xf8c},
  {0x1000, 0x102a}, {0x103f, 0x103f}, {0x1050, 0x1055}, {0x105a, 0x105d}, {0x1061, 0x1061}, {0x1065, 0x1066}, {0x106e, 0x1070}, {0x1075, 0x1081},
  {0x108e, 0x108e}, {0x10a0, 0x10c5}, {0x10c7, 0x10c7}, {0x10cd, 0x10cd}, {0x10d0, 0x10fa}, {0x10fc, 0x1248}, {0x124a, 0x124d}, {0x1250, 0x1256},
  {0x1258, 0x1258}, {0x125a, 0x125d}, {0x1260, 0x1288}, {0x128a, 0x128d}, {0x1290, 0x12b0}, {0x12b2, 0x12b5}, {0x12b8, 0x12be}, {0x12c0, 0x12c0},
  {0x12c2, 0x12c5}, {0x12c8, 0x12d6}, {0x12d8, 0x1310}, {0x1312, 0x1315}, {0x1318, 0x135a}, {0x1380, 0x138f}, {0x13a0, 0x13f5}, {0x13f8, 0x13fd},
  {0x1401, 0x166c}, {0x166f, 0x167f}, {0x1681, 0x169a}, {0x16a0, 0x16ea}, {0x16ee, 0x16f8}, {0x1700, 0x1711}, {0x171f, 0x1731}, {0x1740, 0x1751},
  {0x1760, 0x176c}, {0x176e, 0x1770}, {0x1780, 0x17b3}, {0x17d7, 0x17d7}, {0x17dc, 0x17dc}, {0x1820, 0x1878}, {0x1880, 0x18a8}, {0x18aa, 0x18aa},
  {0x18b0, 0x18f5}, {0x1900, 0x191e}, {0x1950, 0x196d}, {0x1970, 0x1974}, {0x1980, 0x19ab}, {0x19b0, 0x19c9}, {0x1a00, 0x1a16}, {0x1a20, 0x1a54},
  {0x1aa7, 0x1aa7}, {0x1b05, 0x1b33}, {0x1b45, 0x1b4c}, {0x1b83, 0x1ba0}, {0x1bae, 0x1baf}, {0x1bba, 0x1be5}, {0x1c00, 0x1c23}, {0x1c4d, 0x1c4f},
  {0x1c5a, 0x1c7d}, {0x1c80, 0x1c88}, {0x1c90, 0x1cba}, {0x1cbd, 0x1cbf}, {0x1ce9, 0x1cec}, {0x1cee, 0x1cf3}, {0x1cf5, 0x1cf6}, {0x1cfa, 0x1cfa},
  {0x1d00, 0x1dbf}, {0x1e00, 0x1f15}, {0x1f18, 0x1f1d}, {0x1f20, 0x1f45}, {0x1f48, 0x1f4d}, {0x1f50, 0x1f57}, {0x1f59, 0x1f59}, {0x1f5b, 0x1f5b},
  {0x1f5d, 0x1f5d}, {0x1f5f, 0x1f7d}, {0x1f80, 0x1fb4}, {0x1fb6, 0x1fbc}, {0x1fbe, 0x1fbe}, {0x1fc2, 0x1fc4}, {0x1fc6, 0x1fcc}, {0x1fd0, 0x1fd3},
  {0x1fd6, 0x1fdb}, {0x1fe0, 0x1fec}, {0x1ff2, 0x1ff4}, {0x1ff6, 0x1ffc}, {0x2071, 0x2071}, {0x207f, 0x207f}, {0x2090, 0x209c}, {0x2102, 0x2102},
  {0x2107, 0x2107}, {0x210a, 0x2113}, {0x2115, 0x2115}, {0x2118, 0x211d}, {0x2124, 0x2124}, {0x2126, 0x2126}, {0x2128, 0x2128}, {0x212a, 0x2139},
  {0x213c, 0x213f}, {0x2145, 0x2149}, {0x214e, 0x214e}, {0x2160, 0x2188}, {0x2c00, 0x2ce4}, {0x2ceb, 0x2cee}, {0x2cf2, 0x2cf3}, {0x2d00, 0x2d25},
  {0x2d27, 0x2d27}, {0x2d2d, 0x2d2d}, {0x2d30, 0x2d67}, {0x2d6f, 0x2d6f}, {0x2d80, 0x2d96}, {0x2da0, 0x2da6}, {0x2da8, 0x2dae}, {0x2db0, 0x2db6},
  {0x2db8, 0x2dbe}, {0x2dc0, 0x2dc6}, {0x2dc8, 0x2dce}, {0x2dd0, 0x2dd6}, {0x2dd8, 0x2dde}, {0x3005, 0x3007}, {0x3021, 0x3029}, {0x3031, 0x3035},
  {0x3038, 0x303c}, {0x3041, 0x3096}, {0x309d, 0x309f}, {0x30a1, 0x30fa}, {0x30fc, 0x30ff}, {0x3105, 0x312f}, {0x3131, 0x318e}, {0x31a0, 0x31bf},
  {0x31f0, 0x31ff}, {0x3400, 0x4dbf}, {0x4e00, 0xa48c}, {0xa4d0, 0xa4fd}, {0xa500, 0xa60c}, {0xa610, 0xa61f}, {0xa62a, 0xa62b}, {0xa640, 0xa66e},
  {0xa67f, 0xa69d}, {0xa6a0, 0xa6ef}, {0xa717, 0xa71f}, {0xa722, 0xa788}, {0xa78b, 0xa7ca}, {0xa7d0, 0xa7d1}, {0xa7d3, 0xa7d3}, {0xa7d5, 0xa7d9},
  {0xa7f2, 0xa801}, {0xa803, 0xa805}, {0xa807, 0xa80a}, {0xa80c, 0xa822}, {0xa840, 0xa873}, {0xa882, 0xa8b3}, {0xa8f2, 0xa8f7}, {0xa8fb, 0xa8fb},
  {0xa8fd, 0xa8fe}, {0xa90a, 0xa925}, {0xa930, 0xa946}, {0xa960, 0xa97c}, {0xa984, 0xa9b2}, {0xa9cf, 0xa9cf}, {0xa9e0, 0xa9e4}, {0xa9e6, 0xa9ef},
  {0xa9fa, 0xa9fe}, {0xaa00, 0xaa28}, {0xaa40, 0xaa42}, {0xaa44, 0xaa4b}, {0xaa60, 0xaa76}, {0xaa7a, 0xaa7a}, {0xaa7e, 0xaaaf}, {0xaab1, 0xaab1},
  {0xaab5, 0xaab6}, {0xaab9, 0xaabd}, {0xaac0, 0xaac0}, {0xaac2, 0xaac2}, {0xaadb, 0xaadd}, {0xaae0, 0xaaea}, {0xaaf2, 0xaaf4}, {0xab01, 0xab06},
  {0xab09, 0xab0e}, {0xab11, 0xab16}, {0xab20, 0xab26}, {0xab28, 0xab2e}, {0xab30, 0xab5a}, {0xab5c, 0xab69}, {0xab70, 0xabe2}, {0xac00, 0xd7a3},
  {0xd7b0, 0xd7c6}, {0xd7cb, 0xd7fb}, {0xf900, 0xfa6d}, {0xfa70, 0xfad9}, {0xfb00, 0xfb06}, {0xfb13, 0xfb17}, {0xfb1d, 0xfb1d}, {0xfb1f, 0xfb28},
  {0xfb2a, 0xfb36}, {0xfb38, 0xfb3c}, {0xfb3e, 0xfb3e}, {0xfb40, 0xfb41}, {0xfb43, 0xfb44}, {0xfb46, 0xfbb1}, {0xfbd3, 0xfc5d}, {0xfc64, 0xfd3d},
  {0xfd50, 0xfd8f}, {0xfd92, 0xfdc7}, {0xfdf0, 0xfdf9}, {0xfe71, 0xfe71}, {0xfe73, 0xfe73}, {0xfe77, 0xfe77}, {0xfe79, 0xfe79}, {0xfe7b, 0xfe7b},
  {0xfe7d, 0xfe7d}, {0xfe7f, 0xfefc}, {0xff21, 0xff3a}, {0xff41, 0xff5a}, {0xff66, 0xff9d}, {0xffa0, 0xffbe}, {0xffc2, 0xffc7}, {0xffca, 0xffcf},
  {0xffd2, 0xffd7}, {0xffda, 0xffdc}, {0x10000, 0x1000b}, {0x1000d, 0x10026}, {0x10028, 0x1003a}, {0x1003c, 0x1003d}, {0x1003f, 0x1004d}, {0x10050, 0x1005d},
  {0x10080, 0x100fa}, {0x10140, 0x10174}, {0x10280, 0x1029c}, {0x102a0, 0x102d0}, {0x10300, 0x1031f}, {0x1032d, 0x1034a}, {0x10350, 0x10375}, {0x10380, 0x1039d},
  {0x103a0, 0x103c3}, {0x103c8, 0x103cf}, {0x103d1, 0x103d5}, {0x10400, 0x1049d}, {0x104b0, 0x104d3}, {0x104d8, 0x104fb}, {0x10500, 0x10527}, {0x10530, 0x10563},
  {0x10570, 0x1057a}, {0x1057c, 0x1058a}, {0x1058c, 0x10592}, {0x10594, 0x10595}, {0x10597, 0x105a1}, {0x105a3, 0x105b1}, {0x105b3, 0x105b9}, {0x105bb, 0x105bc},
  {0x10600, 0x10736}, {0x10740, 0x10755}, {0x10760, 0x10767}, {0x10780, 0x10785}, {0x10787, 0x107b0}, {0x107b2, 0x107ba}, {0x10800, 0x10805}, {0x10808, 0x10808},
  {0x1080a, 0x10835}, {0x10837, 0x10838}, {0x1083c, 0x1083c}, {0x1083f, 0x10855}, {0x10860, 0x10876}, {0x10880, 0x1089e}, {0x108e0, 0x108f2}, {0x108f4, 0x108f5},
  {0x10900, 0x10915}, {0x10920, 0x10939}, {0x10980, 0x109b7}, {0x109be, 0x109bf}, {0x10a00, 0x10a00}, {0x10a10, 0x10a13}, {0x10a15, 0x10a17}, {0x10a19, 0x10a35},
  {0x10a60, 0x10a7c}, {0x10a80, 0x10a9c}, {0x10ac0, 0x10ac7}, {0x10ac9, 0x10ae4}, {0x10b00, 0x10b35}, {0x10b40, 0x10b55}, {0x10b60, 0x10b72}, {0x10b80, 0x10b91},
  {0x10c00, 0x10c48}, {0x10c80, 0x10cb2}, {0x10cc0, 0x10cf2}, {0x10d00, 0x10d23}, {0x10e80, 0x10ea9}, {0x10eb0, 0x10eb1}, {0x10f00, 0x10f1c}, {0x10f27, 0x10f27},
  {0x10f30, 0x10f45}, {0x10f70, 0x10f81}, {0x10fb0, 0x10fc4}, {0x10fe0, 0x10ff6}, {0x11003, 0x11037}, {0x11071, 0x11072}, {0x11075, 0x11075}, {0x11083, 0x110af},
  {0x110d0, 0x110e8}, {0x11103, 0x11126}, {0x11144, 0x11144}, {0x11147, 0x11147}, {0x11150, 0x11172}, {0x11176, 0x11176}, {0x11183, 0x111b2}, {0x111c1, 0x111c4},
  {0x111da, 0x111da}, {0x111dc, 0x111dc}, {0x11200, 0x11211}, {0x11213, 0x1122b}, {0x1123f, 0x11240}, {0x11280, 0x11286}, {0x11288, 0x11288}, {0x1128a, 0x1128d},
  {0x1128f, 0x1129d}, {0x1129f, 0x112a8}, {0x112b0, 0x112de}, {0x11305, 0x1130c}, {0x1130f, 0x11310}, {0x11313, 0x11328}, {0x1132a, 0x11330}, {0x11332, 0x11333},
  {0x11335, 0x11339}, {0x1133d, 0x1133d}, {0x11350, 0x11350}, {0x1135d, 0x11361}, {0x11400, 0x11434}, {0x11447, 0x1144a}, {0x1145f, 0x11461}, {0x11480, 0x114af},
  {0x114c4, 0x114c5}, {0x114c7, 0x114c7}, {0x11580, 0x115ae}, {0x115d8, 0x115db}, {0x11600, 0x1162f}, {0x11644, 0x11644}, {0x11680, 0x116aa}, {0x116b8, 0x116b8},
  {0x11700, 0x1171a}, {0x11740, 0x11746}, {0x11800, 0x1182b}, {0x118a0, 0x118df}, {0x118ff, 0x11906}, {0x11909, 0x11909}, {0x1190c, 0x11913}, {0x11915, 0x11916},
  {0x11918, 0x1192f}, {0x1193f, 0x1193f}, {0x11941, 0x11941}, {0x119a0, 0x119a7}, {0x119aa, 0x119d0}, {0x119e1, 0x119e1}, {0x119e3, 0x119e3}, {0x11a00, 0x11a00},
  {0x11a0b, 0x11a32}, {0x11a3a, 0x11a3a}, {0x11a50, 0x11a50}, {0x11a5c, 0x11a89}, {0x11a9d, 0x11a9d}, {0x11ab0, 0x11af8}, {0x11c00, 0x11c08}, {0x11c0a, 0x11c2e},
  {0x11c40, 0x11c40}, {0x11c72, 0x11c8f}, {0x11d00, 0x11d06}, {0x11d08, 0x11d09}, {0x11d0b, 0x11d30}, {0x11d46, 0x11d46}, {0x11d60, 0x11d65}, {0x11d67, 0x11d68},
  {0x11d6a, 0x11d89}, {0x11d98, 0x11d98}, {0x11ee0, 0x11ef2}, {0x11f02, 0x11f02}, {0x11f04, 0x11f10}, {0x11f12, 0x11f33}, {0x11fb0, 0x11fb0}, {0x12000, 0x12399},
  {0x12400, 0x1246e}, {0x12480, 0x12543}, {0x12f90, 0x12ff0}, {0x13000, 0x1342f}, {0x13441, 0x13446}, {0x14400, 0x14646}, {0x16800, 0x16a38}, {0x16a40, 0x16a5e},
  {0x16a70, 0x16abe}, {0x16ad0, 0x16aed}, {0x16b00, 0x16b2f}, {0x16b40, 0x16b43}, {0x16b63, 0x16b77}, {0x16b7d, 0x16b8f}, {0x16e40, 0x16e7f}, {0x16f00, 0x16f4a},
  {0x16f50, 0x16f50}, {0x16f93, 0x16f9f}, {0x16fe0, 0x16fe1}, {0x16fe3, 0x16fe3}, {0x17000, 0x187f7}, {0x18800, 0x18cd5}, {0x18d00, 0x18d08}, {0x1aff0, 0x1aff3},
  {0x1aff5, 0x1affb}, {0x1affd, 0x1affe}, {0x1b000, 0x1b122}, {0x1b132, 0x1b132}, {0x1b150, 0x1b152}, {0x1b155, 0x1b155}, {0x1b164, 0x1b167}, {0x1b170, 0x1b2fb},
  {0x1bc00, 0x1bc6a}, {0x1bc70, 0x1bc7c}, {0x1bc80, 0x1bc88}, {0x1bc90, 0x1bc99}, {0x1d400, 0x1d454}, {0x1d456, 0x1d49c}, {0x1d49e, 0x1d49f}, {0x1d4a2, 0x1d4a2},
  {0x1d4a5, 0x1d4a6}, {0x1d4a9, 0x1d4ac}, {0x1d4ae, 0x1d4b9}, {0x1d4bb, 0x1d4bb}, {0x1d4bd, 0x1d4c3}, {0x1d4c5, 0x1d505}, {0x1d507, 0x1d50a}, {0x1d50d, 0x1d514},
  {0x1d516, 0x1d51c}, {0x1d51e, 0x1d539}, {0x1d53b, 0x1d53e}, {0x1d540, 0x1d544}, {0x1d546, 0x1d546}, {0x1d54a, 0x1d550}, {0x1d552, 0x1d6a5}, {0x1d6a8, 0x1d6c0},
  {0x1d6c2, 0x1d6da}, {0x1d6dc, 0x1d6fa}, {0x1d6fc, 0x1d714}, {0x1d716, 0x1d734}, {0x1d736, 0x1d74e}, {0x1d750, 0x1d76e}, {0x1d770, 0x1d788}, {0x1d78a, 0x1d7a8},
  {0x1d7aa, 0x1d7c2}, {0x1d7c4, 0x1d7cb}, {0x1df00, 0x1df1e}, {0x1df25, 0x1df2a}, {0x1e030, 0x1e06d}, {0x1e100, 0x1e12c}, {0x1e137, 0x1e13d}, {0x1e14e, 0x1e14e},
  {0x1e290, 0x1e2ad}, {0x1e2c0, 0x1e2eb}, {0x1e4d0, 0x1e4eb}, {0x1e7e0, 0x1e7e6}, {0x1e7e8, 0x1e7eb}, {0x1e7ed, 0x1e7ee}, {0x1e7f0, 0x1e7fe}, {0x1e800, 0x1e8c4},
  {0x1e900, 0x1e943}, {0x1e94b, 0x1e94b}, {0x1ee00, 0x1ee03}, {0x1ee05, 0x1ee1f}, {0x1ee21, 0x1ee22}, {0x1ee24, 0x1ee24}, {0x1ee27, 0x1ee27}, {0x1ee29, 0x1ee32},
  {0x1ee34, 0x1ee37}, {0x1ee39, 0x1ee39}, {0x1ee3b, 0x1ee3b}, {0x1ee42, 0x1ee42}, {0x1ee47, 0x1ee47}, {0x1ee49, 0x1ee49}, {0x1ee4b, 0x1ee4b}, {0x1ee4d, 0x1ee4f},
  {0x1ee51, 0x1ee52}, {0x1ee54, 0x1ee54}, {0x1ee57, 0x1ee57}, {0x1ee59, 0x1ee59}, {0x1ee5b, 0x1ee5b}, {0x1ee5d, 0x1ee5d}, {0x1ee5f, 0x1ee5f}, {0x1ee61, 0x1ee62},
  {0x1ee64, 0x1ee64}, {0x1ee67, 0x1ee6a}, {0x1ee6c, 0x1ee72}, {0x1ee74, 0x1ee77}, {0x1ee79, 0x1ee7c}, {0x1ee7e, 0x1ee7e}, {0x1ee80, 0x1ee89}, {0x1ee8b, 0x1ee9b},
  {0x1eea1, 0x1eea3}, {0x1eea5, 0x1eea9}, {0x1eeab, 0x1eebb}, {0x20000, 0x2a6df}, {0x2a700, 0x2b739}, {0x2b740, 0x2b81d}, {0x2b820, 0x2cea1}, {0x2ceb0, 0x2ebe0},
  {0x2ebf0, 0x2ee5d}, {0x2f800, 0x2fa1d}, {0x30000, 0x3134a}, {0x31350, 0x323af},
};

static TSCharacterRange sym_identifier_character_set_2[] = {
  {'.', '.'}, {'0', '9'}, {'A', 'Z'}, {'_', '_'}, {'a', 'z'}, {0xaa, 0xaa}, {0xb5, 0xb5}, {0xb7, 0xb7},
  {0xba, 0xba}, {0xc0, 0xd6}, {0xd8, 0xf6}, {0xf8, 0x2c1}, {0x2c6, 0x2d1}, {0x2e0, 0x2e4}, {0x2ec, 0x2ec}, {0x2ee, 0x2ee},
  {0x300, 0x374}, {0x376, 0x377}, {0x37b, 0x37d}, {0x37f, 0x37f}, {0x386, 0x38a}, {0x38c, 0x38c}, {0x38e, 0x3a1}, {0x3a3, 0x3f5},
  {0x3f7, 0x481}, {0x483, 0x487}, {0x48a, 0x52f}, {0x531, 0x556}, {0x559, 0x559}, {0x560, 0x588}, {0x591, 0x5bd}, {0x5bf, 0x5bf},
  {0x5c1, 0x5c2}, {0x5c4, 0x5c5}, {0x5c7, 0x5c7}, {0x5d0, 0x5ea}, {0x5ef, 0x5f2}, {0x610, 0x61a}, {0x620, 0x669}, {0x66e, 0x6d3},
  {0x6d5, 0x6dc}, {0x6df, 0x6e8}, {0x6ea, 0x6fc}, {0x6ff, 0x6ff}, {0x710, 0x74a}, {0x74d, 0x7b1}, {0x7c0, 0x7f5}, {0x7fa, 0x7fa},
  {0x7fd, 0x7fd}, {0x800, 0x82d}, {0x840, 0x85b}, {0x860, 0x86a}, {0x870, 0x887}, {0x889, 0x88e}, {0x898, 0x8e1}, {0x8e3, 0x963},
  {0x966, 0x96f}, {0x971, 0x983}, {0x985, 0x98c}, {0x98f, 0x990}, {0x993, 0x9a8}, {0x9aa, 0x9b0}, {0x9b2, 0x9b2}, {0x9b6, 0x9b9},
  {0x9bc, 0x9c4}, {0x9c7, 0x9c8}, {0x9cb, 0x9ce}, {0x9d7, 0x9d7}, {0x9dc, 0x9dd}, {0x9df, 0x9e3}, {0x9e6, 0x9f1}, {0x9fc, 0x9fc},
  {0x9fe, 0x9fe}, {0xa01, 0xa03}, {0xa05, 0xa0a}, {0xa0f, 0xa10}, {0xa13, 0xa28}, {0xa2a, 0xa30}, {0xa32, 0xa33}, {0xa35, 0xa36},
  {0xa38, 0xa39}, {0xa3c, 0xa3c}, {0xa3e, 0xa42}, {0xa47, 0xa48}, {0xa4b, 0xa4d}, {0xa51, 0xa51}, {0xa59, 0xa5c}, {0xa5e, 0xa5e},
  {0xa66, 0xa75}, {0xa81, 0xa83}, {0xa85, 0xa8d}, {0xa8f, 0xa91}, {0xa93, 0xaa8}, {0xaaa, 0xab0}, {0xab2, 0xab3}, {0xab5, 0xab9},
  {0xabc, 0xac5}, {0xac7, 0xac9}, {0xacb, 0xacd}, {0xad0, 0xad0}, {0xae0, 0xae3}, {0xae6, 0xaef}, {0xaf9, 0xaff}, {0xb01, 0xb03},
  {0xb05, 0xb0c}, {0xb0f, 0xb10}, {0xb13, 0xb28}, {0xb2a, 0xb30}, {0xb32, 0xb33}, {0xb35, 0xb39}, {0xb3c, 0xb44}, {0xb47, 0xb48},
  {0xb4b, 0xb4d}, {0xb55, 0xb57}, {0xb5c, 0xb5d}, {0xb5f, 0xb63}, {0xb66, 0xb6f}, {0xb71, 0xb71}, {0xb82, 0xb83}, {0xb85, 0xb8a},
  {0xb8e, 0xb90}, {0xb92, 0xb95}, {0xb99, 0xb9a}, {0xb9c, 0xb9c}, {0xb9e, 0xb9f}, {0xba3, 0xba4}, {0xba8, 0xbaa}, {0xbae, 0xbb9},
  {0xbbe, 0xbc2}, {0xbc6, 0xbc8}, {0xbca, 0xbcd}, {0xbd0, 0xbd0}, {0xbd7, 0xbd7}, {0xbe6, 0xbef}, {0xc00, 0xc0c}, {0xc0e, 0xc10},
  {0xc12, 0xc28}, {0xc2a, 0xc39}, {0xc3c, 0xc44}, {0xc46, 0xc48}, {0xc4a, 0xc4d}, {0xc55, 0xc56}, {0xc58, 0xc5a}, {0xc5d, 0xc5d},
  {0xc60, 0xc63}, {0xc66, 0xc6f}, {0xc80, 0xc83}, {0xc85, 0xc8c}, {0xc8e, 0xc90}, {0xc92, 0xca8}, {0xcaa, 0xcb3}, {0xcb5, 0xcb9},
  {0xcbc, 0xcc4}, {0xcc6, 0xcc8}, {0xcca, 0xccd}, {0xcd5, 0xcd6}, {0xcdd, 0xcde}, {0xce0, 0xce3}, {0xce6, 0xcef}, {0xcf1, 0xcf3},
  {0xd00, 0xd0c}, {0xd0e, 0xd10}, {0xd12, 0xd44}, {0xd46, 0xd48}, {0xd4a, 0xd4e}, {0xd54, 0xd57}, {0xd5f, 0xd63}, {0xd66, 0xd6f},
  {0xd7a, 0xd7f}, {0xd81, 0xd83}, {0xd85, 0xd96}, {0xd9a, 0xdb1}, {0xdb3, 0xdbb}, {0xdbd, 0xdbd}, {0xdc0, 0xdc6}, {0xdca, 0xdca},
  {0xdcf, 0xdd4}, {0xdd6, 0xdd6}, {0xdd8, 0xddf}, {0xde6, 0xdef}, {0xdf2, 0xdf3}, {0xe01, 0xe3a}, {0xe40, 0xe4e}, {0xe50, 0xe59},
  {0xe81, 0xe82}, {0xe84, 0xe84}, {0xe86, 0xe8a}, {0xe8c, 0xea3}, {0xea5, 0xea5}, {0xea7, 0xebd}, {0xec0, 0xec4}, {0xec6, 0xec6},
  {0xec8, 0xece}, {0xed0, 0xed9}, {0xedc, 0xedf}, {0xf00, 0xf00}, {0xf18, 0xf19}, {0xf20, 0xf29}, {0xf35, 0xf35}, {0xf37, 0xf37},
  {0xf39, 0xf39}, {0xf3e, 0xf47}, {0xf49, 0xf6c}, {0xf71, 0xf84}, {0xf86, 0xf97}, {0xf99, 0xfbc}, {0xfc6, 0xfc6}, {0x1000, 0x1049},
  {0x1050, 0x109d}, {0x10a0, 0x10c5}, {0x10c7, 0x10c7}, {0x10cd, 0x10cd}, {0x10d0, 0x10fa}, {0x10fc, 0x1248}, {0x124a, 0x124d}, {0x1250, 0x1256},
  {0x1258, 0x1258}, {0x125a, 0x125d}, {0x1260, 0x1288}, {0x128a, 0x128d}, {0x1290, 0x12b0}, {0x12b2, 0x12b5}, {0x12b8, 0x12be}, {0x12c0, 0x12c0},
  {0x12c2, 0x12c5}, {0x12c8, 0x12d6}, {0x12d8, 0x1310}, {0x1312, 0x1315}, {0x1318, 0x135a}, {0x135d, 0x135f}, {0x1369, 0x1371}, {0x1380, 0x138f},
  {0x13a0, 0x13f5}, {0x13f8, 0x13fd}, {0x1401, 0x166c}, {0x166f, 0x167f}, {0x1681, 0x169a}, {0x16a0, 0x16ea}, {0x16ee, 0x16f8}, {0x1700, 0x1715},
  {0x171f, 0x1734}, {0x1740, 0x1753}, {0x1760, 0x176c}, {0x176e, 0x1770}, {0x1772, 0x1773}, {0x1780, 0x17d3}, {0x17d7, 0x17d7}, {0x17dc, 0x17dd},
  {0x17e0, 0x17e9}, {0x180b, 0x180d}, {0x180f, 0x1819}, {0x1820, 0x1878}, {0x1880, 0x18aa}, {0x18b0, 0x18f5}, {0x1900, 0x191e}, {0x1920, 0x192b},
  {0x1930, 0x193b}, {0x1946, 0x196d}, {0x1970, 0x1974}, {0x1980, 0x19ab}, {0x19b0, 0x19c9}, {0x19d0, 0x19da}, {0x1a00, 0x1a1b}, {0x1a20, 0x1a5e},
  {0x1a60, 0x1a7c}, {0x1a7f, 0x1a89}, {0x1a90, 0x1a99}, {0x1aa7, 0x1aa7}, {0x1ab0, 0x1abd}, {0x1abf, 0x1ace}, {0x1b00, 0x1b4c}, {0x1b50, 0x1b59},
  {0x1b6b, 0x1b73}, {0x1b80, 0x1bf3}, {0x1c00, 0x1c37}, {0x1c40, 0x1c49}, {0x1c4d, 0x1c7d}, {0x1c80, 0x1c88}, {0x1c90, 0x1cba}, {0x1cbd, 0x1cbf},
  {0x1cd0, 0x1cd2}, {0x1cd4, 0x1cfa}, {0x1d00, 0x1f15}, {0x1f18, 0x1f1d}, {0x1f20, 0x1f45}, {0x1f48, 0x1f4d}, {0x1f50, 0x1f57}, {0x1f59, 0x1f59},
  {0x1f5b, 0x1f5b}, {0x1f5d, 0x1f5d}, {0x1f5f, 0x1f7d}, {0x1f80, 0x1fb4}, {0x1fb6, 0x1fbc}, {0x1fbe, 0x1fbe}, {0x1fc2, 0x1fc4}, {0x1fc6, 0x1fcc},
  {0x1fd0, 0x1fd3}, {0x1fd6, 0x1fdb}, {0x1fe0, 0x1fec}, {0x1ff2, 0x1ff4}, {0x1ff6, 0x1ffc}, {0x200c, 0x200d}, {0x203f, 0x2040}, {0x2054, 0x2054},
  {0x2071, 0x2071}, {0x207f, 0x207f}, {0x2090, 0x209c}, {0x20d0, 0x20dc}, {0x20e1, 0x20e1}, {0x20e5, 0x20f0}, {0x2102, 0x2102}, {0x2107, 0x2107},
  {0x210a, 0x2113}, {0x2115, 0x2115}, {0x2118, 0x211d}, {0x2124, 0x2124}, {0x2126, 0x2126}, {0x2128, 0x2128}, {0x212a, 0x2139}, {0x213c, 0x213f},
  {0x2145, 0x2149}, {0x214e, 0x214e}, {0x2160, 0x2188}, {0x2c00, 0x2ce4}, {0x2ceb, 0x2cf3}, {0x2d00, 0x2d25}, {0x2d27, 0x2d27}, {0x2d2d, 0x2d2d},
  {0x2d30, 0x2d67}, {0x2d6f, 0x2d6f}, {0x2d7f, 0x2d96}, {0x2da0, 0x2da6}, {0x2da8, 0x2dae}, {0x2db0, 0x2db6}, {0x2db8, 0x2dbe}, {0x2dc0, 0x2dc6},
  {0x2dc8, 0x2dce}, {0x2dd0, 0x2dd6}, {0x2dd8, 0x2dde}, {0x2de0, 0x2dff}, {0x3005, 0x3007}, {0x3021, 0x302f}, {0x3031, 0x3035}, {0x3038, 0x303c},
  {0x3041, 0x3096}, {0x3099, 0x309a}, {0x309d, 0x309f}, {0x30a1, 0x30ff}, {0x3105, 0x312f}, {0x3131, 0x318e}, {0x31a0, 0x31bf}, {0x31f0, 0x31ff},
  {0x3400, 0x4dbf}, {0x4e00, 0xa48c}, {0xa4d0, 0xa4fd}, {0xa500, 0xa60c}, {0xa610, 0xa62b}, {0xa640, 0xa66f}, {0xa674, 0xa67d}, {0xa67f, 0xa6f1},
  {0xa717, 0xa71f}, {0xa722, 0xa788}, {0xa78b, 0xa7ca}, {0xa7d0, 0xa7d1}, {0xa7d3, 0xa7d3}, {0xa7d5, 0xa7d9}, {0xa7f2, 0xa827}, {0xa82c, 0xa82c},
  {0xa840, 0xa873}, {0xa880, 0xa8c5}, {0xa8d0, 0xa8d9}, {0xa8e0, 0xa8f7}, {0xa8fb, 0xa8fb}, {0xa8fd, 0xa92d}, {0xa930, 0xa953}, {0xa960, 0xa97c},
  {0xa980, 0xa9c0}, {0xa9cf, 0xa9d9}, {0xa9e0, 0xa9fe}, {0xaa00, 0xaa36}, {0xaa40, 0xaa4d}, {0xaa50, 0xaa59}, {0xaa60, 0xaa76}, {0xaa7a, 0xaac2},
  {0xaadb, 0xaadd}, {0xaae0, 0xaaef}, {0xaaf2, 0xaaf6}, {0xab01, 0xab06}, {0xab09, 0xab0e}, {0xab11, 0xab16}, {0xab20, 0xab26}, {0xab28, 0xab2e},
  {0xab30, 0xab5a}, {0xab5c, 0xab69}, {0xab70, 0xabea}, {0xabec, 0xabed}, {0xabf0, 0xabf9}, {0xac00, 0xd7a3}, {0xd7b0, 0xd7c6}, {0xd7cb, 0xd7fb},
  {0xf900, 0xfa6d}, {0xfa70, 0xfad9}, {0xfb00, 0xfb06}, {0xfb13, 0xfb17}, {0xfb1d, 0xfb28}, {0xfb2a, 0xfb36}, {0xfb38, 0xfb3c}, {0xfb3e, 0xfb3e},
  {0xfb40, 0xfb41}, {0xfb43, 0xfb44}, {0xfb46, 0xfbb1}, {0xfbd3, 0xfc5d}, {0xfc64, 0xfd3d}, {0xfd50, 0xfd8f}, {0xfd92, 0xfdc7}, {0xfdf0, 0xfdf9},
  {0xfe00, 0xfe0f}, {0xfe20, 0xfe2f}, {0xfe33, 0xfe34}, {0xfe4d, 0xfe4f}, {0xfe71, 0xfe71}, {0xfe73, 0xfe73}, {0xfe77, 0xfe77}, {0xfe79, 0xfe79},
  {0xfe7b, 0xfe7b}, {0xfe7d, 0xfe7d}, {0xfe7f, 0xfefc}, {0xff10, 0xff19}, {0xff21, 0xff3a}, {0xff3f, 0xff3f}, {0xff41, 0xff5a}, {0xff65, 0xffbe},
  {0xffc2, 0xffc7}, {0xffca, 0xffcf}, {0xffd2, 0xffd7}, {0xffda, 0xffdc}, {0x10000, 0x1000b}, {0x1000d, 0x10026}, {0x10028, 0x1003a}, {0x1003c, 0x1003d},
  {0x1003f, 0x1004d}, {0x10050, 0x1005d}, {0x10080, 0x100fa}, {0x10140, 0x10174}, {0x101fd, 0x101fd}, {0x10280, 0x1029c}, {0x102a0, 0x102d0}, {0x102e0, 0x102e0},
  {0x10300, 0x1031f}, {0x1032d, 0x1034a}, {0x10350, 0x1037a}, {0x10380, 0x1039d}, {0x103a0, 0x103c3}, {0x103c8, 0x103cf}, {0x103d1, 0x103d5}, {0x10400, 0x1049d},
  {0x104a0, 0x104a9}, {0x104b0, 0x104d3}, {0x104d8, 0x104fb}, {0x10500, 0x10527}, {0x10530, 0x10563}, {0x10570, 0x1057a}, {0x1057c, 0x1058a}, {0x1058c, 0x10592},
  {0x10594, 0x10595}, {0x10597, 0x105a1}, {0x105a3, 0x105b1}, {0x105b3, 0x105b9}, {0x105bb, 0x105bc}, {0x10600, 0x10736}, {0x10740, 0x10755}, {0x10760, 0x10767},
  {0x10780, 0x10785}, {0x10787, 0x107b0}, {0x107b2, 0x107ba}, {0x10800, 0x10805}, {0x10808, 0x10808}, {0x1080a, 0x10835}, {0x10837, 0x10838}, {0x1083c, 0x1083c},
  {0x1083f, 0x10855}, {0x10860, 0x10876}, {0x10880, 0x1089e}, {0x108e0, 0x108f2}, {0x108f4, 0x108f5}, {0x10900, 0x10915}, {0x10920, 0x10939}, {0x10980, 0x109b7},
  {0x109be, 0x109bf}, {0x10a00, 0x10a03}, {0x10a05, 0x10a06}, {0x10a0c, 0x10a13}, {0x10a15, 0x10a17}, {0x10a19, 0x10a35}, {0x10a38, 0x10a3a}, {0x10a3f, 0x10a3f},
  {0x10a60, 0x10a7c}, {0x10a80, 0x10a9c}, {0x10ac0, 0x10ac7}, {0x10ac9, 0x10ae6}, {0x10b00, 0x10b35}, {0x10b40, 0x10b55}, {0x10b60, 0x10b72}, {0x10b80, 0x10b91},
  {0x10c00, 0x10c48}, {0x10c80, 0x10cb2}, {0x10cc0, 0x10cf2}, {0x10d00, 0x10d27}, {0x10d30, 0x10d39}, {0x10e80, 0x10ea9}, {0x10eab, 0x10eac}, {0x10eb0, 0x10eb1},
  {0x10efd, 0x10f1c}, {0x10f27, 0x10f27}, {0x10f30, 0x10f50}, {0x10f70, 0x10f85}, {0x10fb0, 0x10fc4}, {0x10fe0, 0x10ff6}, {0x11000, 0x11046}, {0x11066, 0x11075},
  {0x1107f, 0x110ba}, {0x110c2, 0x110c2}, {0x110d0, 0x110e8}, {0x110f0, 0x110f9}, {0x11100, 0x11134}, {0x11136, 0x1113f}, {0x11144, 0x11147}, {0x11150, 0x11173},
  {0x11176, 0x11176}, {0x11180, 0x111c4}, {0x111c9, 0x111cc}, {0x111ce, 0x111da}, {0x111dc, 0x111dc}, {0x11200, 0x11211}, {0x11213, 0x11237}, {0x1123e, 0x11241},
  {0x11280, 0x11286}, {0x11288, 0x11288}, {0x1128a, 0x1128d}, {0x1128f, 0x1129d}, {0x1129f, 0x112a8}, {0x112b0, 0x112ea}, {0x112f0, 0x112f9}, {0x11300, 0x11303},
  {0x11305, 0x1130c}, {0x1130f, 0x11310}, {0x11313, 0x11328}, {0x1132a, 0x11330}, {0x11332, 0x11333}, {0x11335, 0x11339}, {0x1133b, 0x11344}, {0x11347, 0x11348},
  {0x1134b, 0x1134d}, {0x11350, 0x11350}, {0x11357, 0x11357}, {0x1135d, 0x11363}, {0x11366, 0x1136c}, {0x11370, 0x11374}, {0x11400, 0x1144a}, {0x11450, 0x11459},
  {0x1145e, 0x11461}, {0x11480, 0x114c5}, {0x114c7, 0x114c7}, {0x114d0, 0x114d9}, {0x11580, 0x115b5}, {0x115b8, 0x115c0}, {0x115d8, 0x115dd}, {0x11600, 0x11640},
  {0x11644, 0x11644}, {0x11650, 0x11659}, {0x11680, 0x116b8}, {0x116c0, 0x116c9}, {0x11700, 0x1171a}, {0x1171d, 0x1172b}, {0x11730, 0x11739}, {0x11740, 0x11746},
  {0x11800, 0x1183a}, {0x118a0, 0x118e9}, {0x118ff, 0x11906}, {0x11909, 0x11909}, {0x1190c, 0x11913}, {0x11915, 0x11916}, {0x11918, 0x11935}, {0x11937, 0x11938},
  {0x1193b, 0x11943}, {0x11950, 0x11959}, {0x119a0, 0x119a7}, {0x119aa, 0x119d7}, {0x119da, 0x119e1}, {0x119e3, 0x119e4}, {0x11a00, 0x11a3e}, {0x11a47, 0x11a47},
  {0x11a50, 0x11a99}, {0x11a9d, 0x11a9d}, {0x11ab0, 0x11af8}, {0x11c00, 0x11c08}, {0x11c0a, 0x11c36}, {0x11c38, 0x11c40}, {0x11c50, 0x11c59}, {0x11c72, 0x11c8f},
  {0x11c92, 0x11ca7}, {0x11ca9, 0x11cb6}, {0x11d00, 0x11d06}, {0x11d08, 0x11d09}, {0x11d0b, 0x11d36}, {0x11d3a, 0x11d3a}, {0x11d3c, 0x11d3d}, {0x11d3f, 0x11d47},
  {0x11d50, 0x11d59}, {0x11d60, 0x11d65}, {0x11d67, 0x11d68}, {0x11d6a, 0x11d8e}, {0x11d90, 0x11d91}, {0x11d93, 0x11d98}, {0x11da0, 0x11da9}, {0x11ee0, 0x11ef6},
  {0x11f00, 0x11f10}, {0x11f12, 0x11f3a}, {0x11f3e, 0x11f42}, {0x11f50, 0x11f59}, {0x11fb0, 0x11fb0}, {0x12000, 0x12399}, {0x12400, 0x1246e}, {0x12480, 0x12543},
  {0x12f90, 0x12ff0}, {0x13000, 0x1342f}, {0x13440, 0x13455}, {0x14400, 0x14646}, {0x16800, 0x16a38}, {0x16a40, 0x16a5e}, {0x16a60, 0x16a69}, {0x16a70, 0x16abe},
  {0x16ac0, 0x16ac9}, {0x16ad0, 0x16aed}, {0x16af0, 0x16af4}, {0x16b00, 0x16b36}, {0x16b40, 0x16b43}, {0x16b50, 0x16b59}, {0x16b63, 0x16b77}, {0x16b7d, 0x16b8f},
  {0x16e40, 0x16e7f}, {0x16f00, 0x16f4a}, {0x16f4f, 0x16f87}, {0x16f8f, 0x16f9f}, {0x16fe0, 0x16fe1}, {0x16fe3, 0x16fe4}, {0x16ff0, 0x16ff1}, {0x17000, 0x187f7},
  {0x18800, 0x18cd5}, {0x18d00, 0x18d08}, {0x1aff0, 0x1aff3}, {0x1aff5, 0x1affb}, {0x1affd, 0x1affe}, {0x1b000, 0x1b122}, {0x1b132, 0x1b132}, {0x1b150, 0x1b152},
  {0x1b155, 0x1b155}, {0x1b164, 0x1b167}, {0x1b170, 0x1b2fb}, {0x1bc00, 0x1bc6a}, {0x1bc70, 0x1bc7c}, {0x1bc80, 0x1bc88}, {0x1bc90, 0x1bc99}, {0x1bc9d, 0x1bc9e},
  {0x1cf00, 0x1cf2d}, {0x1cf30, 0x1cf46}, {0x1d165, 0x1d169}, {0x1d16d, 0x1d172}, {0x1d17b, 0x1d182}, {0x1d185, 0x1d18b}, {0x1d1aa, 0x1d1ad}, {0x1d242, 0x1d244},
  {0x1d400, 0x1d454}, {0x1d456, 0x1d49c}, {0x1d49e, 0x1d49f}, {0x1d4a2, 0x1d4a2}, {0x1d4a5, 0x1d4a6}, {0x1d4a9, 0x1d4ac}, {0x1d4ae, 0x1d4b9}, {0x1d4bb, 0x1d4bb},
  {0x1d4bd, 0x1d4c3}, {0x1d4c5, 0x1d505}, {0x1d507, 0x1d50a}, {0x1d50d, 0x1d514}, {0x1d516, 0x1d51c}, {0x1d51e, 0x1d539}, {0x1d53b, 0x1d53e}, {0x1d540, 0x1d544},
  {0x1d546, 0x1d546}, {0x1d54a, 0x1d550}, {0x1d552, 0x1d6a5}, {0x1d6a8, 0x1d6c0}, {0x1d6c2, 0x1d6da}, {0x1d6dc, 0x1d6fa}, {0x1d6fc, 0x1d714}, {0x1d716, 0x1d734},
  {0x1d736, 0x1d74e}, {0x1d750, 0x1d76e}, {0x1d770, 0x1d788}, {0x1d78a, 0x1d7a8}, {0x1d7aa, 0x1d7c2}, {0x1d7c4, 0x1d7cb}, {0x1d7ce, 0x1d7ff}, {0x1da00, 0x1da36},
  {0x1da3b, 0x1da6c}, {0x1da75, 0x1da75}, {0x1da84, 0x1da84}, {0x1da9b, 0x1da9f}, {0x1daa1, 0x1daaf}, {0x1df00, 0x1df1e}, {0x1df25, 0x1df2a}, {0x1e000, 0x1e006},
  {0x1e008, 0x1e018}, {0x1e01b, 0x1e021}, {0x1e023, 0x1e024}, {0x1e026, 0x1e02a}, {0x1e030, 0x1e06d}, {0x1e08f, 0x1e08f}, {0x1e100, 0x1e12c}, {0x1e130, 0x1e13d},
  {0x1e140, 0x1e149}, {0x1e14e, 0x1e14e}, {0x1e290, 0x1e2ae}, {0x1e2c0, 0x1e2f9}, {0x1e4d0, 0x1e4f9}, {0x1e7e0, 0x1e7e6}, {0x1e7e8, 0x1e7eb}, {0x1e7ed, 0x1e7ee},
  {0x1e7f0, 0x1e7fe}, {0x1e800, 0x1e8c4}, {0x1e8d0, 0x1e8d6}, {0x1e900, 0x1e94b}, {0x1e950, 0x1e959}, {0x1ee00, 0x1ee03}, {0x1ee05, 0x1ee1f}, {0x1ee21, 0x1ee22},
  {0x1ee24, 0x1ee24}, {0x1ee27, 0x1ee27}, {0x1ee29, 0x1ee32}, {0x1ee34, 0x1ee37}, {0x1ee39, 0x1ee39}, {0x1ee3b, 0x1ee3b}, {0x1ee42, 0x1ee42}, {0x1ee47, 0x1ee47},
  {0x1ee49, 0x1ee49}, {0x1ee4b, 0x1ee4b}, {0x1ee4d, 0x1ee4f}, {0x1ee51, 0x1ee52}, {0x1ee54, 0x1ee54}, {0x1ee57, 0x1ee57}, {0x1ee59, 0x1ee59}, {0x1ee5b, 0x1ee5b},
  {0x1ee5d, 0x1ee5d}, {0x1ee5f, 0x1ee5f}, {0x1ee61, 0x1ee62}, {0x1ee64, 0x1ee64}, {0x1ee67, 0x1ee6a}, {0x1ee6c, 0x1ee72}, {0x1ee74, 0x1ee77}, {0x1ee79, 0x1ee7c},
  {0x1ee7e, 0x1ee7e}, {0x1ee80, 0x1ee89}, {0x1ee8b, 0x1ee9b}, {0x1eea1, 0x1eea3}, {0x1eea5, 0x1eea9}, {0x1eeab, 0x1eebb}, {0x1fbf0, 0x1fbf9}, {0x20000, 0x2a6df},
  {0x2a700, 0x2b739}, {0x2b740, 0x2b81d}, {0x2b820, 0x2cea1}, {0x2ceb0, 0x2ebe0}, {0x2ebf0, 0x2ee5d}, {0x2f800, 0x2fa1d}, {0x30000, 0x3134a}, {0x31350, 0x323af},
  {0xe0100, 0xe01ef},
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(25);
      ADVANCE_MAP(
        '!', 30,
        '"', 70,
        '#', 95,
        '$', 56,
        '%', 5,
        '&', 39,
        '\'', 69,
        '*', 48,
        '+', 31,
        ',', 96,
        '-', 32,
        '.', 90,
        '/', 49,
        '0', 61,
        ':', 54,
        '<', 42,
        '=', 27,
        '>', 44,
        '?', 28,
        '@', 57,
        '\\', 26,
        '^', 51,
        '`', 9,
        '|', 38,
        '~', 29,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(0);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(62);
      if (set_contains(sym_identifier_character_set_1, 668, lookahead)) ADVANCE(92);
      END_STATE();
    case 1:
      ADVANCE_MAP(
        '!', 7,
        '"', 70,
        '#', 95,
        '$', 56,
        '%', 5,
        '&', 39,
        '\'', 69,
        '*', 48,
        '+', 31,
        ',', 96,
        '-', 32,
        '/', 49,
        ':', 55,
        '<', 42,
        '=', 27,
        '>', 44,
        '?', 28,
        '@', 57,
        '^', 51,
        '`', 9,
        '|', 38,
        '~', 29,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(1);
      if (set_contains(sym_identifier_character_set_1, 668, lookahead)) ADVANCE(92);
      END_STATE();
    case 2:
      if (lookahead == '"') ADVANCE(70);
      if (lookahead == '#') ADVANCE(74);
      if (lookahead == '\\') ADVANCE(8);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(75);
      if (lookahead != 0) ADVANCE(76);
      END_STATE();
    case 3:
      if (lookahead == '#') ADVANCE(95);
      if (lookahead == '.') ADVANCE(91);
      if (lookahead == '`') ADVANCE(9);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(3);
      if (set_contains(sym_identifier_character_set_1, 668, lookahead)) ADVANCE(92);
      END_STATE();
    case 4:
      if (lookahead == '#') ADVANCE(71);
      if (lookahead == '\'') ADVANCE(69);
      if (lookahead == '\\') ADVANCE(8);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(72);
      if (lookahead != 0) ADVANCE(73);
      END_STATE();
    case 5:
      if (lookahead == '%') ADVANCE(52);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\\') ADVANCE(5);
      END_STATE();
    case 6:
      if (lookahead == '-') ADVANCE(34);
      END_STATE();
    case 7:
      if (lookahead == '=') ADVANCE(47);
      END_STATE();
    case 8:
      if (lookahead == 'U') ADVANCE(10);
      if (lookahead == 'u') ADVANCE(11);
      if (lookahead == 'x') ADVANCE(22);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(79);
      if (lookahead != 0 &&
          (lookahead < '0' || '9' < lookahead)) ADVANCE(77);
      END_STATE();
    case 9:
      if (lookahead == '\\') ADVANCE(24);
      if (lookahead == '`') ADVANCE(87);
      if (lookahead != 0) ADVANCE(9);
      END_STATE();
    case 10:
      if (lookahead == '{') ADVANCE(21);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(86);
      END_STATE();
    case 11:
      if (lookahead == '{') ADVANCE(23);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(82);
      END_STATE();
    case 12:
      if (lookahead == '}') ADVANCE(77);
      END_STATE();
    case 13:
      if (lookahead == '}') ADVANCE(77);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(12);
      END_STATE();
    case 14:
      if (lookahead == '}') ADVANCE(77);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(13);
      END_STATE();
    case 15:
      if (lookahead == '}') ADVANCE(77);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(14);
      END_STATE();
    case 16:
      if (lookahead == '}') ADVANCE(77);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(15);
      END_STATE();
    case 17:
      if (lookahead == '}') ADVANCE(77);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(16);
      END_STATE();
    case 18:
      if (lookahead == '}') ADVANCE(77);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(17);
      END_STATE();
    case 19:
      if (lookahead == '}') ADVANCE(77);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(18);
      END_STATE();
    case 20:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(60);
      END_STATE();
    case 21:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(19);
      END_STATE();
    case 22:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(80);
      END_STATE();
    case 23:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(15);
      END_STATE();
    case 24:
      if (lookahead != 0) ADVANCE(9);
      END_STATE();
    case 25:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 26:
      ACCEPT_TOKEN(anon_sym_BSLASH);
      END_STATE();
    case 27:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(46);
      END_STATE();
    case 28:
      ACCEPT_TOKEN(anon_sym_QMARK);
      END_STATE();
    case 29:
      ACCEPT_TOKEN(anon_sym_TILDE);
      END_STATE();
    case 30:
      ACCEPT_TOKEN(anon_sym_BANG);
      if (lookahead == '=') ADVANCE(47);
      END_STATE();
    case 31:
      ACCEPT_TOKEN(anon_sym_PLUS);
      END_STATE();
    case 32:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '>') ADVANCE(36);
      END_STATE();
    case 33:
      ACCEPT_TOKEN(anon_sym_LT_DASH);
      END_STATE();
    case 34:
      ACCEPT_TOKEN(anon_sym_LT_LT_DASH);
      END_STATE();
    case 35:
      ACCEPT_TOKEN(anon_sym_COLON_EQ);
      END_STATE();
    case 36:
      ACCEPT_TOKEN(anon_sym_DASH_GT);
      if (lookahead == '>') ADVANCE(37);
      END_STATE();
    case 37:
      ACCEPT_TOKEN(anon_sym_DASH_GT_GT);
      END_STATE();
    case 38:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '>') ADVANCE(53);
      if (lookahead == '|') ADVANCE(40);
      END_STATE();
    case 39:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&') ADVANCE(41);
      END_STATE();
    case 40:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      END_STATE();
    case 41:
      ACCEPT_TOKEN(anon_sym_AMP_AMP);
      END_STATE();
    case 42:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '-') ADVANCE(33);
      if (lookahead == '<') ADVANCE(6);
      if (lookahead == '=') ADVANCE(43);
      END_STATE();
    case 43:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      END_STATE();
    case 44:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(45);
      END_STATE();
    case 45:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 46:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      END_STATE();
    case 47:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      END_STATE();
    case 48:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '*') ADVANCE(50);
      END_STATE();
    case 49:
      ACCEPT_TOKEN(anon_sym_SLASH);
      END_STATE();
    case 50:
      ACCEPT_TOKEN(anon_sym_STAR_STAR);
      END_STATE();
    case 51:
      ACCEPT_TOKEN(anon_sym_CARET);
      END_STATE();
    case 52:
      ACCEPT_TOKEN(aux_sym_binary_operator_token1);
      END_STATE();
    case 53:
      ACCEPT_TOKEN(anon_sym_PIPE_GT);
      END_STATE();
    case 54:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (lookahead == ':') ADVANCE(58);
      if (lookahead == '=') ADVANCE(35);
      END_STATE();
    case 55:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (lookahead == '=') ADVANCE(35);
      END_STATE();
    case 56:
      ACCEPT_TOKEN(anon_sym_DOLLAR);
      END_STATE();
    case 57:
      ACCEPT_TOKEN(anon_sym_AT);
      END_STATE();
    case 58:
      ACCEPT_TOKEN(anon_sym_COLON_COLON);
      if (lookahead == ':') ADVANCE(59);
      END_STATE();
    case 59:
      ACCEPT_TOKEN(anon_sym_COLON_COLON_COLON);
      END_STATE();
    case 60:
      ACCEPT_TOKEN(aux_sym__hex_literal_token1);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(60);
      END_STATE();
    case 61:
      ACCEPT_TOKEN(sym__number_literal);
      if (lookahead == '.') ADVANCE(65);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(63);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(20);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(62);
      END_STATE();
    case 62:
      ACCEPT_TOKEN(sym__number_literal);
      if (lookahead == '.') ADVANCE(65);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(63);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(62);
      END_STATE();
    case 63:
      ACCEPT_TOKEN(sym__number_literal);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(67);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(67);
      END_STATE();
    case 64:
      ACCEPT_TOKEN(sym__number_literal);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(67);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(68);
      if (set_contains(sym_identifier_character_set_2, 777, lookahead)) ADVANCE(92);
      END_STATE();
    case 65:
      ACCEPT_TOKEN(sym__number_literal);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(63);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(65);
      END_STATE();
    case 66:
      ACCEPT_TOKEN(sym__number_literal);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(64);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(66);
      if (set_contains(sym_identifier_character_set_2, 777, lookahead)) ADVANCE(92);
      END_STATE();
    case 67:
      ACCEPT_TOKEN(sym__number_literal);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(67);
      END_STATE();
    case 68:
      ACCEPT_TOKEN(sym__number_literal);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(68);
      if (set_contains(sym_identifier_character_set_2, 777, lookahead)) ADVANCE(92);
      END_STATE();
    case 69:
      ACCEPT_TOKEN(anon_sym_SQUOTE);
      END_STATE();
    case 70:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 71:
      ACCEPT_TOKEN(aux_sym__single_quoted_string_content_token1);
      if (lookahead == '\n') ADVANCE(73);
      if (lookahead != 0 &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(71);
      END_STATE();
    case 72:
      ACCEPT_TOKEN(aux_sym__single_quoted_string_content_token1);
      if (lookahead == '#') ADVANCE(71);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(72);
      if (lookahead != 0 &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(73);
      END_STATE();
    case 73:
      ACCEPT_TOKEN(aux_sym__single_quoted_string_content_token1);
      if (lookahead != 0 &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(73);
      END_STATE();
    case 74:
      ACCEPT_TOKEN(aux_sym__double_quoted_string_content_token1);
      if (lookahead == '\n') ADVANCE(76);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(74);
      END_STATE();
    case 75:
      ACCEPT_TOKEN(aux_sym__double_quoted_string_content_token1);
      if (lookahead == '#') ADVANCE(74);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(75);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '#' &&
          lookahead != '\\') ADVANCE(76);
      END_STATE();
    case 76:
      ACCEPT_TOKEN(aux_sym__double_quoted_string_content_token1);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(76);
      END_STATE();
    case 77:
      ACCEPT_TOKEN(sym_escape_sequence);
      END_STATE();
    case 78:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(77);
      END_STATE();
    case 79:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(78);
      END_STATE();
    case 80:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(77);
      END_STATE();
    case 81:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(80);
      END_STATE();
    case 82:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(81);
      END_STATE();
    case 83:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(82);
      END_STATE();
    case 84:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(83);
      END_STATE();
    case 85:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(84);
      END_STATE();
    case 86:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(85);
      END_STATE();
    case 87:
      ACCEPT_TOKEN(sym_identifier);
      END_STATE();
    case 88:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(93);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(94);
      if (set_contains(sym_identifier_character_set_2, 777, lookahead)) ADVANCE(92);
      END_STATE();
    case 89:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(93);
      if (set_contains(sym_identifier_character_set_2, 777, lookahead)) ADVANCE(92);
      END_STATE();
    case 90:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(88);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(66);
      if (set_contains(sym_identifier_character_set_2, 777, lookahead)) ADVANCE(92);
      END_STATE();
    case 91:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(89);
      if (set_contains(sym_identifier_character_set_2, 777, lookahead)) ADVANCE(92);
      END_STATE();
    case 92:
      ACCEPT_TOKEN(sym_identifier);
      if (set_contains(sym_identifier_character_set_2, 777, lookahead)) ADVANCE(92);
      END_STATE();
    case 93:
      ACCEPT_TOKEN(sym_dots);
      if (set_contains(sym_identifier_character_set_2, 777, lookahead)) ADVANCE(92);
      END_STATE();
    case 94:
      ACCEPT_TOKEN(sym_dot_dot_i);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(94);
      END_STATE();
    case 95:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(95);
      END_STATE();
    case 96:
      ACCEPT_TOKEN(sym_comma);
      END_STATE();
    default:
      return false;
  }
}

static bool ts_lex_keywords(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      ADVANCE_MAP(
        'F', 1,
        'I', 2,
        'L', 3,
        'N', 4,
        'T', 5,
        'b', 6,
        'f', 7,
        'i', 8,
        'n', 9,
        'r', 10,
        'w', 11,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(0);
      END_STATE();
    case 1:
      if (lookahead == 'A') ADVANCE(12);
      END_STATE();
    case 2:
      if (lookahead == 'n') ADVANCE(13);
      END_STATE();
    case 3:
      ACCEPT_TOKEN(anon_sym_L);
      END_STATE();
    case 4:
      if (lookahead == 'A') ADVANCE(14);
      if (lookahead == 'U') ADVANCE(15);
      if (lookahead == 'a') ADVANCE(16);
      END_STATE();
    case 5:
      if (lookahead == 'R') ADVANCE(17);
      END_STATE();
    case 6:
      if (lookahead == 'r') ADVANCE(18);
      END_STATE();
    case 7:
      if (lookahead == 'o') ADVANCE(19);
      if (lookahead == 'u') ADVANCE(20);
      END_STATE();
    case 8:
      ACCEPT_TOKEN(anon_sym_i);
      if (lookahead == 'f') ADVANCE(21);
      if (lookahead == 'n') ADVANCE(22);
      END_STATE();
    case 9:
      if (lookahead == 'e') ADVANCE(23);
      END_STATE();
    case 10:
      if (lookahead == 'e') ADVANCE(24);
      END_STATE();
    case 11:
      if (lookahead == 'h') ADVANCE(25);
      END_STATE();
    case 12:
      if (lookahead == 'L') ADVANCE(26);
      END_STATE();
    case 13:
      if (lookahead == 'f') ADVANCE(27);
      END_STATE();
    case 14:
      ACCEPT_TOKEN(anon_sym_NA);
      if (lookahead == '_') ADVANCE(28);
      END_STATE();
    case 15:
      if (lookahead == 'L') ADVANCE(29);
      END_STATE();
    case 16:
      if (lookahead == 'N') ADVANCE(30);
      END_STATE();
    case 17:
      if (lookahead == 'U') ADVANCE(31);
      END_STATE();
    case 18:
      if (lookahead == 'e') ADVANCE(32);
      END_STATE();
    case 19:
      if (lookahead == 'r') ADVANCE(33);
      END_STATE();
    case 20:
      if (lookahead == 'n') ADVANCE(34);
      END_STATE();
    case 21:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 22:
      ACCEPT_TOKEN(anon_sym_in);
      END_STATE();
    case 23:
      if (lookahead == 'x') ADVANCE(35);
      END_STATE();
    case 24:
      if (lookahead == 'p') ADVANCE(36);
      if (lookahead == 't') ADVANCE(37);
      END_STATE();
    case 25:
      if (lookahead == 'i') ADVANCE(38);
      END_STATE();
    case 26:
      if (lookahead == 'S') ADVANCE(39);
      END_STATE();
    case 27:
      ACCEPT_TOKEN(sym_inf);
      END_STATE();
    case 28:
      if (lookahead == 'c') ADVANCE(40);
      if (lookahead == 'i') ADVANCE(41);
      if (lookahead == 'r') ADVANCE(42);
      END_STATE();
    case 29:
      if (lookahead == 'L') ADVANCE(43);
      END_STATE();
    case 30:
      ACCEPT_TOKEN(sym_nan);
      END_STATE();
    case 31:
      if (lookahead == 'E') ADVANCE(44);
      END_STATE();
    case 32:
      if (lookahead == 'a') ADVANCE(45);
      END_STATE();
    case 33:
      ACCEPT_TOKEN(anon_sym_for);
      END_STATE();
    case 34:
      if (lookahead == 'c') ADVANCE(46);
      END_STATE();
    case 35:
      if (lookahead == 't') ADVANCE(47);
      END_STATE();
    case 36:
      if (lookahead == 'e') ADVANCE(48);
      END_STATE();
    case 37:
      if (lookahead == 'u') ADVANCE(49);
      END_STATE();
    case 38:
      if (lookahead == 'l') ADVANCE(50);
      END_STATE();
    case 39:
      if (lookahead == 'E') ADVANCE(51);
      END_STATE();
    case 40:
      if (lookahead == 'h') ADVANCE(52);
      if (lookahead == 'o') ADVANCE(53);
      END_STATE();
    case 41:
      if (lookahead == 'n') ADVANCE(54);
      END_STATE();
    case 42:
      if (lookahead == 'e') ADVANCE(55);
      END_STATE();
    case 43:
      ACCEPT_TOKEN(sym_null);
      END_STATE();
    case 44:
      ACCEPT_TOKEN(sym_true);
      END_STATE();
    case 45:
      if (lookahead == 'k') ADVANCE(56);
      END_STATE();
    case 46:
      if (lookahead == 't') ADVANCE(57);
      END_STATE();
    case 47:
      ACCEPT_TOKEN(sym_next);
      END_STATE();
    case 48:
      if (lookahead == 'a') ADVANCE(58);
      END_STATE();
    case 49:
      if (lookahead == 'r') ADVANCE(59);
      END_STATE();
    case 50:
      if (lookahead == 'e') ADVANCE(60);
      END_STATE();
    case 51:
      ACCEPT_TOKEN(sym_false);
      END_STATE();
    case 52:
      if (lookahead == 'a') ADVANCE(61);
      END_STATE();
    case 53:
      if (lookahead == 'm') ADVANCE(62);
      END_STATE();
    case 54:
      if (lookahead == 't') ADVANCE(63);
      END_STATE();
    case 55:
      if (lookahead == 'a') ADVANCE(64);
      END_STATE();
    case 56:
      ACCEPT_TOKEN(sym_break);
      END_STATE();
    case 57:
      if (lookahead == 'i') ADVANCE(65);
      END_STATE();
    case 58:
      if (lookahead == 't') ADVANCE(66);
      END_STATE();
    case 59:
      if (lookahead == 'n') ADVANCE(67);
      END_STATE();
    case 60:
      ACCEPT_TOKEN(anon_sym_while);
      END_STATE();
    case 61:
      if (lookahead == 'r') ADVANCE(68);
      END_STATE();
    case 62:
      if (lookahead == 'p') ADVANCE(69);
      END_STATE();
    case 63:
      if (lookahead == 'e') ADVANCE(70);
      END_STATE();
    case 64:
      if (lookahead == 'l') ADVANCE(71);
      END_STATE();
    case 65:
      if (lookahead == 'o') ADVANCE(72);
      END_STATE();
    case 66:
      ACCEPT_TOKEN(anon_sym_repeat);
      END_STATE();
    case 67:
      ACCEPT_TOKEN(sym_return);
      END_STATE();
    case 68:
      if (lookahead == 'a') ADVANCE(73);
      END_STATE();
    case 69:
      if (lookahead == 'l') ADVANCE(74);
      END_STATE();
    case 70:
      if (lookahead == 'g') ADVANCE(75);
      END_STATE();
    case 71:
      if (lookahead == '_') ADVANCE(76);
      END_STATE();
    case 72:
      if (lookahead == 'n') ADVANCE(77);
      END_STATE();
    case 73:
      if (lookahead == 'c') ADVANCE(78);
      END_STATE();
    case 74:
      if (lookahead == 'e') ADVANCE(79);
      END_STATE();
    case 75:
      if (lookahead == 'e') ADVANCE(80);
      END_STATE();
    case 76:
      ACCEPT_TOKEN(anon_sym_NA_real_);
      END_STATE();
    case 77:
      ACCEPT_TOKEN(anon_sym_function);
      END_STATE();
    case 78:
      if (lookahead == 't') ADVANCE(81);
      END_STATE();
    case 79:
      if (lookahead == 'x') ADVANCE(82);
      END_STATE();
    case 80:
      if (lookahead == 'r') ADVANCE(83);
      END_STATE();
    case 81:
      if (lookahead == 'e') ADVANCE(84);
      END_STATE();
    case 82:
      if (lookahead == '_') ADVANCE(85);
      END_STATE();
    case 83:
      if (lookahead == '_') ADVANCE(86);
      END_STATE();
    case 84:
      if (lookahead == 'r') ADVANCE(87);
      END_STATE();
    case 85:
      ACCEPT_TOKEN(anon_sym_NA_complex_);
      END_STATE();
    case 86:
      ACCEPT_TOKEN(anon_sym_NA_integer_);
      END_STATE();
    case 87:
      if (lookahead == '_') ADVANCE(88);
      END_STATE();
    case 88:
      ACCEPT_TOKEN(anon_sym_NA_character_);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0, .external_lex_state = 1},
  [1] = {.lex_state = 0, .external_lex_state = 2},
  [2] = {.lex_state = 0, .external_lex_state = 3},
  [3] = {.lex_state = 0, .external_lex_state = 4},
  [4] = {.lex_state = 0, .external_lex_state = 4},
  [5] = {.lex_state = 0, .external_lex_state = 5},
  [6] = {.lex_state = 0, .external_lex_state = 5},
  [7] = {.lex_state = 0, .external_lex_state = 5},
  [8] = {.lex_state = 0, .external_lex_state = 5},
  [9] = {.lex_state = 0, .external_lex_state = 6},
  [10] = {.lex_state = 0, .external_lex_state = 6},
  [11] = {.lex_state = 0, .external_lex_state = 6},
  [12] = {.lex_state = 0, .external_lex_state = 6},
  [13] = {.lex_state = 0, .external_lex_state = 3},
  [14] = {.lex_state = 0, .external_lex_state = 3},
  [15] = {.lex_state = 0, .external_lex_state = 3},
  [16] = {.lex_state = 0, .external_lex_state = 3},
  [17] = {.lex_state = 0, .external_lex_state = 7},
  [18] = {.lex_state = 0, .external_lex_state = 4},
  [19] = {.lex_state = 0, .external_lex_state = 7},
  [20] = {.lex_state = 0, .external_lex_state = 7},
  [21] = {.lex_state = 0, .external_lex_state = 4},
  [22] = {.lex_state = 0, .external_lex_state = 4},
  [23] = {.lex_state = 0, .external_lex_state = 4},
  [24] = {.lex_state = 0, .external_lex_state = 4},
  [25] = {.lex_state = 0, .external_lex_state = 5},
  [26] = {.lex_state = 0, .external_lex_state = 5},
  [27] = {.lex_state = 0, .external_lex_state = 5},
  [28] = {.lex_state = 0, .external_lex_state = 5},
  [29] = {.lex_state = 0, .external_lex_state = 6},
  [30] = {.lex_state = 0, .external_lex_state = 6},
  [31] = {.lex_state = 0, .external_lex_state = 6},
  [32] = {.lex_state = 0, .external_lex_state = 6},
  [33] = {.lex_state = 0, .external_lex_state = 3},
  [34] = {.lex_state = 0, .external_lex_state = 4},
  [35] = {.lex_state = 0, .external_lex_state = 3},
  [36] = {.lex_state = 0, .external_lex_state = 3},
  [37] = {.lex_state = 0, .external_lex_state = 7},
  [38] = {.lex_state = 0, .external_lex_state = 7},
  [39] = {.lex_state = 0, .external_lex_state = 7},
  [40] = {.lex_state = 0, .external_lex_state = 7},
  [41] = {.lex_state = 0, .external_lex_state = 7},
  [42] = {.lex_state = 0, .external_lex_state = 3},
  [43] = {.lex_state = 0, .external_lex_state = 4},
  [44] = {.lex_state = 0, .external_lex_state = 4},
  [45] = {.lex_state = 0, .external_lex_state = 4},
  [46] = {.lex_state = 0, .external_lex_state = 4},
  [47] = {.lex_state = 0, .external_lex_state = 4},
  [48] = {.lex_state = 0, .external_lex_state = 4},
  [49] = {.lex_state = 0, .external_lex_state = 4},
  [50] = {.lex_state = 0, .external_lex_state = 4},
  [51] = {.lex_state = 0, .external_lex_state = 4},
  [52] = {.lex_state = 0, .external_lex_state = 4},
  [53] = {.lex_state = 0, .external_lex_state = 4},
  [54] = {.lex_state = 0, .external_lex_state = 4},
  [55] = {.lex_state = 0, .external_lex_state = 4},
  [56] = {.lex_state = 0, .external_lex_state = 4},
  [57] = {.lex_state = 0, .external_lex_state = 4},
  [58] = {.lex_state = 0, .external_lex_state = 4},
  [59] = {.lex_state = 0, .external_lex_state = 4},
  [60] = {.lex_state = 0, .external_lex_state = 4},
  [61] = {.lex_state = 0, .external_lex_state = 4},
  [62] = {.lex_state = 0, .external_lex_state = 4},
  [63] = {.lex_state = 0, .external_lex_state = 8},
  [64] = {.lex_state = 0, .external_lex_state = 9},
  [65] = {.lex_state = 0, .external_lex_state = 4},
  [66] = {.lex_state = 0, .external_lex_state = 4},
  [67] = {.lex_state = 0, .external_lex_state = 4},
  [68] = {.lex_state = 0, .external_lex_state = 4},
  [69] = {.lex_state = 0, .external_lex_state = 4},
  [70] = {.lex_state = 0, .external_lex_state = 4},
  [71] = {.lex_state = 0, .external_lex_state = 4},
  [72] = {.lex_state = 0, .external_lex_state = 4},
  [73] = {.lex_state = 0, .external_lex_state = 4},
  [74] = {.lex_state = 0, .external_lex_state = 4},
  [75] = {.lex_state = 0, .external_lex_state = 4},
  [76] = {.lex_state = 0, .external_lex_state = 4},
  [77] = {.lex_state = 0, .external_lex_state = 4},
  [78] = {.lex_state = 0, .external_lex_state = 4},
  [79] = {.lex_state = 0, .external_lex_state = 4},
  [80] = {.lex_state = 0, .external_lex_state = 4},
  [81] = {.lex_state = 0, .external_lex_state = 4},
  [82] = {.lex_state = 0, .external_lex_state = 4},
  [83] = {.lex_state = 0, .external_lex_state = 4},
  [84] = {.lex_state = 0, .external_lex_state = 4},
  [85] = {.lex_state = 0, .external_lex_state = 4},
  [86] = {.lex_state = 0, .external_lex_state = 4},
  [87] = {.lex_state = 0, .external_lex_state = 4},
  [88] = {.lex_state = 0, .external_lex_state = 4},
  [89] = {.lex_state = 0, .external_lex_state = 4},
  [90] = {.lex_state = 0, .external_lex_state = 4},
  [91] = {.lex_state = 0, .external_lex_state = 5},
  [92] = {.lex_state = 0, .external_lex_state = 5},
  [93] = {.lex_state = 0, .external_lex_state = 5},
  [94] = {.lex_state = 0, .external_lex_state = 5},
  [95] = {.lex_state = 0, .external_lex_state = 5},
  [96] = {.lex_state = 0, .external_lex_state = 5},
  [97] = {.lex_state = 0, .external_lex_state = 5},
  [98] = {.lex_state = 0, .external_lex_state = 5},
  [99] = {.lex_state = 0, .external_lex_state = 5},
  [100] = {.lex_state = 0, .external_lex_state = 5},
  [101] = {.lex_state = 0, .external_lex_state = 5},
  [102] = {.lex_state = 0, .external_lex_state = 5},
  [103] = {.lex_state = 0, .external_lex_state = 5},
  [104] = {.lex_state = 0, .external_lex_state = 5},
  [105] = {.lex_state = 0, .external_lex_state = 5},
  [106] = {.lex_state = 0, .external_lex_state = 5},
  [107] = {.lex_state = 0, .external_lex_state = 5},
  [108] = {.lex_state = 0, .external_lex_state = 5},
  [109] = {.lex_state = 0, .external_lex_state = 5},
  [110] = {.lex_state = 0, .external_lex_state = 5},
  [111] = {.lex_state = 0, .external_lex_state = 5},
  [112] = {.lex_state = 0, .external_lex_state = 5},
  [113] = {.lex_state = 0, .external_lex_state = 5},
  [114] = {.lex_state = 0, .external_lex_state = 5},
  [115] = {.lex_state = 0, .external_lex_state = 8},
  [116] = {.lex_state = 0, .external_lex_state = 9},
  [117] = {.lex_state = 0, .external_lex_state = 5},
  [118] = {.lex_state = 0, .external_lex_state = 5},
  [119] = {.lex_state = 0, .external_lex_state = 5},
  [120] = {.lex_state = 0, .external_lex_state = 5},
  [121] = {.lex_state = 0, .external_lex_state = 5},
  [122] = {.lex_state = 0, .external_lex_state = 5},
  [123] = {.lex_state = 0, .external_lex_state = 5},
  [124] = {.lex_state = 0, .external_lex_state = 5},
  [125] = {.lex_state = 0, .external_lex_state = 5},
  [126] = {.lex_state = 0, .external_lex_state = 5},
  [127] = {.lex_state = 0, .external_lex_state = 5},
  [128] = {.lex_state = 0, .external_lex_state = 5},
  [129] = {.lex_state = 0, .external_lex_state = 5},
  [130] = {.lex_state = 0, .external_lex_state = 5},
  [131] = {.lex_state = 0, .external_lex_state = 5},
  [132] = {.lex_state = 0, .external_lex_state = 5},
  [133] = {.lex_state = 0, .external_lex_state = 5},
  [134] = {.lex_state = 0, .external_lex_state = 5},
  [135] = {.lex_state = 0, .external_lex_state = 5},
  [136] = {.lex_state = 0, .external_lex_state = 5},
  [137] = {.lex_state = 0, .external_lex_state = 5},
  [138] = {.lex_state = 0, .external_lex_state = 5},
  [139] = {.lex_state = 0, .external_lex_state = 5},
  [140] = {.lex_state = 0, .external_lex_state = 5},
  [141] = {.lex_state = 0, .external_lex_state = 5},
  [142] = {.lex_state = 0, .external_lex_state = 5},
  [143] = {.lex_state = 0, .external_lex_state = 6},
  [144] = {.lex_state = 0, .external_lex_state = 6},
  [145] = {.lex_state = 0, .external_lex_state = 6},
  [146] = {.lex_state = 0, .external_lex_state = 6},
  [147] = {.lex_state = 0, .external_lex_state = 6},
  [148] = {.lex_state = 0, .external_lex_state = 6},
  [149] = {.lex_state = 0, .external_lex_state = 6},
  [150] = {.lex_state = 0, .external_lex_state = 6},
  [151] = {.lex_state = 0, .external_lex_state = 6},
  [152] = {.lex_state = 0, .external_lex_state = 6},
  [153] = {.lex_state = 0, .external_lex_state = 6},
  [154] = {.lex_state = 0, .external_lex_state = 6},
  [155] = {.lex_state = 0, .external_lex_state = 6},
  [156] = {.lex_state = 0, .external_lex_state = 6},
  [157] = {.lex_state = 0, .external_lex_state = 6},
  [158] = {.lex_state = 0, .external_lex_state = 6},
  [159] = {.lex_state = 0, .external_lex_state = 6},
  [160] = {.lex_state = 0, .external_lex_state = 6},
  [161] = {.lex_state = 0, .external_lex_state = 6},
  [162] = {.lex_state = 0, .external_lex_state = 6},
  [163] = {.lex_state = 0, .external_lex_state = 6},
  [164] = {.lex_state = 0, .external_lex_state = 6},
  [165] = {.lex_state = 0, .external_lex_state = 6},
  [166] = {.lex_state = 0, .external_lex_state = 6},
  [167] = {.lex_state = 0, .external_lex_state = 8},
  [168] = {.lex_state = 0, .external_lex_state = 9},
  [169] = {.lex_state = 0, .external_lex_state = 6},
  [170] = {.lex_state = 0, .external_lex_state = 6},
  [171] = {.lex_state = 0, .external_lex_state = 6},
  [172] = {.lex_state = 0, .external_lex_state = 6},
  [173] = {.lex_state = 0, .external_lex_state = 6},
  [174] = {.lex_state = 0, .external_lex_state = 6},
  [175] = {.lex_state = 0, .external_lex_state = 6},
  [176] = {.lex_state = 0, .external_lex_state = 6},
  [177] = {.lex_state = 0, .external_lex_state = 6},
  [178] = {.lex_state = 0, .external_lex_state = 6},
  [179] = {.lex_state = 0, .external_lex_state = 6},
  [180] = {.lex_state = 0, .external_lex_state = 6},
  [181] = {.lex_state = 0, .external_lex_state = 6},
  [182] = {.lex_state = 0, .external_lex_state = 6},
  [183] = {.lex_state = 0, .external_lex_state = 6},
  [184] = {.lex_state = 0, .external_lex_state = 6},
  [185] = {.lex_state = 0, .external_lex_state = 6},
  [186] = {.lex_state = 0, .external_lex_state = 6},
  [187] = {.lex_state = 0, .external_lex_state = 6},
  [188] = {.lex_state = 0, .external_lex_state = 6},
  [189] = {.lex_state = 0, .external_lex_state = 6},
  [190] = {.lex_state = 0, .external_lex_state = 6},
  [191] = {.lex_state = 0, .external_lex_state = 6},
  [192] = {.lex_state = 0, .external_lex_state = 6},
  [193] = {.lex_state = 0, .external_lex_state = 6},
  [194] = {.lex_state = 0, .external_lex_state = 6},
  [195] = {.lex_state = 0, .external_lex_state = 8},
  [196] = {.lex_state = 0, .external_lex_state = 9},
  [197] = {.lex_state = 0, .external_lex_state = 3},
  [198] = {.lex_state = 0, .external_lex_state = 3},
  [199] = {.lex_state = 0, .external_lex_state = 9},
  [200] = {.lex_state = 0, .external_lex_state = 3},
  [201] = {.lex_state = 0, .external_lex_state = 3},
  [202] = {.lex_state = 0, .external_lex_state = 3},
  [203] = {.lex_state = 0, .external_lex_state = 3},
  [204] = {.lex_state = 0, .external_lex_state = 3},
  [205] = {.lex_state = 0, .external_lex_state = 3},
  [206] = {.lex_state = 0, .external_lex_state = 3},
  [207] = {.lex_state = 0, .external_lex_state = 3},
  [208] = {.lex_state = 0, .external_lex_state = 3},
  [209] = {.lex_state = 0, .external_lex_state = 3},
  [210] = {.lex_state = 0, .external_lex_state = 3},
  [211] = {.lex_state = 0, .external_lex_state = 3},
  [212] = {.lex_state = 0, .external_lex_state = 3},
  [213] = {.lex_state = 0, .external_lex_state = 3},
  [214] = {.lex_state = 0, .external_lex_state = 3},
  [215] = {.lex_state = 0, .external_lex_state = 3},
  [216] = {.lex_state = 0, .external_lex_state = 3},
  [217] = {.lex_state = 0, .external_lex_state = 3},
  [218] = {.lex_state = 0, .external_lex_state = 3},
  [219] = {.lex_state = 0, .external_lex_state = 3},
  [220] = {.lex_state = 0, .external_lex_state = 3},
  [221] = {.lex_state = 0, .external_lex_state = 8},
  [222] = {.lex_state = 0, .external_lex_state = 4},
  [223] = {.lex_state = 0, .external_lex_state = 3},
  [224] = {.lex_state = 0, .external_lex_state = 3},
  [225] = {.lex_state = 0, .external_lex_state = 3},
  [226] = {.lex_state = 0, .external_lex_state = 3},
  [227] = {.lex_state = 0, .external_lex_state = 3},
  [228] = {.lex_state = 0, .external_lex_state = 3},
  [229] = {.lex_state = 0, .external_lex_state = 3},
  [230] = {.lex_state = 0, .external_lex_state = 3},
  [231] = {.lex_state = 0, .external_lex_state = 3},
  [232] = {.lex_state = 0, .external_lex_state = 3},
  [233] = {.lex_state = 0, .external_lex_state = 3},
  [234] = {.lex_state = 0, .external_lex_state = 3},
  [235] = {.lex_state = 0, .external_lex_state = 3},
  [236] = {.lex_state = 0, .external_lex_state = 3},
  [237] = {.lex_state = 0, .external_lex_state = 3},
  [238] = {.lex_state = 0, .external_lex_state = 3},
  [239] = {.lex_state = 0, .external_lex_state = 3},
  [240] = {.lex_state = 0, .external_lex_state = 3},
  [241] = {.lex_state = 0, .external_lex_state = 3},
  [242] = {.lex_state = 0, .external_lex_state = 3},
  [243] = {.lex_state = 0, .external_lex_state = 3},
  [244] = {.lex_state = 0, .external_lex_state = 3},
  [245] = {.lex_state = 0, .external_lex_state = 3},
  [246] = {.lex_state = 0, .external_lex_state = 3},
  [247] = {.lex_state = 0, .external_lex_state = 3},
  [248] = {.lex_state = 0, .external_lex_state = 3},
  [249] = {.lex_state = 0, .external_lex_state = 7},
  [250] = {.lex_state = 0, .external_lex_state = 7},
  [251] = {.lex_state = 0, .external_lex_state = 7},
  [252] = {.lex_state = 0, .external_lex_state = 7},
  [253] = {.lex_state = 0, .external_lex_state = 7},
  [254] = {.lex_state = 0, .external_lex_state = 7},
  [255] = {.lex_state = 0, .external_lex_state = 7},
  [256] = {.lex_state = 0, .external_lex_state = 7},
  [257] = {.lex_state = 0, .external_lex_state = 7},
  [258] = {.lex_state = 0, .external_lex_state = 7},
  [259] = {.lex_state = 0, .external_lex_state = 7},
  [260] = {.lex_state = 0, .external_lex_state = 7},
  [261] = {.lex_state = 0, .external_lex_state = 7},
  [262] = {.lex_state = 0, .external_lex_state = 7},
  [263] = {.lex_state = 0, .external_lex_state = 7},
  [264] = {.lex_state = 0, .external_lex_state = 7},
  [265] = {.lex_state = 0, .external_lex_state = 7},
  [266] = {.lex_state = 0, .external_lex_state = 7},
  [267] = {.lex_state = 0, .external_lex_state = 7},
  [268] = {.lex_state = 0, .external_lex_state = 7},
  [269] = {.lex_state = 0, .external_lex_state = 7},
  [270] = {.lex_state = 0, .external_lex_state = 7},
  [271] = {.lex_state = 0, .external_lex_state = 7},
  [272] = {.lex_state = 0, .external_lex_state = 7},
  [273] = {.lex_state = 0, .external_lex_state = 8},
  [274] = {.lex_state = 0, .external_lex_state = 9},
  [275] = {.lex_state = 0, .external_lex_state = 7},
  [276] = {.lex_state = 0, .external_lex_state = 7},
  [277] = {.lex_state = 0, .external_lex_state = 7},
  [278] = {.lex_state = 0, .external_lex_state = 7},
  [279] = {.lex_state = 0, .external_lex_state = 7},
  [280] = {.lex_state = 0, .external_lex_state = 7},
  [281] = {.lex_state = 0, .external_lex_state = 7},
  [282] = {.lex_state = 0, .external_lex_state = 7},
  [283] = {.lex_state = 0, .external_lex_state = 7},
  [284] = {.lex_state = 0, .external_lex_state = 7},
  [285] = {.lex_state = 0, .external_lex_state = 7},
  [286] = {.lex_state = 0, .external_lex_state = 7},
  [287] = {.lex_state = 0, .external_lex_state = 7},
  [288] = {.lex_state = 0, .external_lex_state = 7},
  [289] = {.lex_state = 0, .external_lex_state = 7},
  [290] = {.lex_state = 0, .external_lex_state = 7},
  [291] = {.lex_state = 0, .external_lex_state = 7},
  [292] = {.lex_state = 0, .external_lex_state = 7},
  [293] = {.lex_state = 0, .external_lex_state = 7},
  [294] = {.lex_state = 0, .external_lex_state = 7},
  [295] = {.lex_state = 0, .external_lex_state = 7},
  [296] = {.lex_state = 0, .external_lex_state = 7},
  [297] = {.lex_state = 0, .external_lex_state = 7},
  [298] = {.lex_state = 0, .external_lex_state = 7},
  [299] = {.lex_state = 0, .external_lex_state = 7},
  [300] = {.lex_state = 0, .external_lex_state = 7},
  [301] = {.lex_state = 0, .external_lex_state = 10},
  [302] = {.lex_state = 0, .external_lex_state = 8},
  [303] = {.lex_state = 0, .external_lex_state = 9},
  [304] = {.lex_state = 0, .external_lex_state = 8},
  [305] = {.lex_state = 0, .external_lex_state = 10},
  [306] = {.lex_state = 0, .external_lex_state = 8},
  [307] = {.lex_state = 0, .external_lex_state = 8},
  [308] = {.lex_state = 0, .external_lex_state = 10},
  [309] = {.lex_state = 0, .external_lex_state = 9},
  [310] = {.lex_state = 0, .external_lex_state = 8},
  [311] = {.lex_state = 0, .external_lex_state = 9},
  [312] = {.lex_state = 0, .external_lex_state = 9},
  [313] = {.lex_state = 0, .external_lex_state = 9},
  [314] = {.lex_state = 0, .external_lex_state = 10},
  [315] = {.lex_state = 0, .external_lex_state = 8},
  [316] = {.lex_state = 0, .external_lex_state = 8},
  [317] = {.lex_state = 0, .external_lex_state = 9},
  [318] = {.lex_state = 0, .external_lex_state = 9},
  [319] = {.lex_state = 0, .external_lex_state = 8},
  [320] = {.lex_state = 0, .external_lex_state = 9},
  [321] = {.lex_state = 0, .external_lex_state = 10},
  [322] = {.lex_state = 0, .external_lex_state = 4},
  [323] = {.lex_state = 0, .external_lex_state = 4},
  [324] = {.lex_state = 0, .external_lex_state = 4},
  [325] = {.lex_state = 0, .external_lex_state = 10},
  [326] = {.lex_state = 0, .external_lex_state = 8},
  [327] = {.lex_state = 0, .external_lex_state = 9},
  [328] = {.lex_state = 0, .external_lex_state = 10},
  [329] = {.lex_state = 0, .external_lex_state = 10},
  [330] = {.lex_state = 0, .external_lex_state = 8},
  [331] = {.lex_state = 0, .external_lex_state = 9},
  [332] = {.lex_state = 0, .external_lex_state = 10},
  [333] = {.lex_state = 0, .external_lex_state = 10},
  [334] = {.lex_state = 0, .external_lex_state = 8},
  [335] = {.lex_state = 0, .external_lex_state = 9},
  [336] = {.lex_state = 0, .external_lex_state = 10},
  [337] = {.lex_state = 0, .external_lex_state = 10},
  [338] = {.lex_state = 0, .external_lex_state = 8},
  [339] = {.lex_state = 0, .external_lex_state = 9},
  [340] = {.lex_state = 0, .external_lex_state = 10},
  [341] = {.lex_state = 0, .external_lex_state = 10},
  [342] = {.lex_state = 0, .external_lex_state = 8},
  [343] = {.lex_state = 0, .external_lex_state = 9},
  [344] = {.lex_state = 0, .external_lex_state = 10},
  [345] = {.lex_state = 0, .external_lex_state = 10},
  [346] = {.lex_state = 0, .external_lex_state = 8},
  [347] = {.lex_state = 0, .external_lex_state = 9},
  [348] = {.lex_state = 0, .external_lex_state = 10},
  [349] = {.lex_state = 0, .external_lex_state = 10},
  [350] = {.lex_state = 0, .external_lex_state = 8},
  [351] = {.lex_state = 0, .external_lex_state = 9},
  [352] = {.lex_state = 0, .external_lex_state = 10},
  [353] = {.lex_state = 0, .external_lex_state = 10},
  [354] = {.lex_state = 0, .external_lex_state = 8},
  [355] = {.lex_state = 0, .external_lex_state = 9},
  [356] = {.lex_state = 0, .external_lex_state = 10},
  [357] = {.lex_state = 0, .external_lex_state = 10},
  [358] = {.lex_state = 0, .external_lex_state = 8},
  [359] = {.lex_state = 0, .external_lex_state = 9},
  [360] = {.lex_state = 0, .external_lex_state = 10},
  [361] = {.lex_state = 0, .external_lex_state = 10},
  [362] = {.lex_state = 0, .external_lex_state = 8},
  [363] = {.lex_state = 0, .external_lex_state = 9},
  [364] = {.lex_state = 0, .external_lex_state = 11},
  [365] = {.lex_state = 0, .external_lex_state = 12},
  [366] = {.lex_state = 0, .external_lex_state = 12},
  [367] = {.lex_state = 0, .external_lex_state = 12},
  [368] = {.lex_state = 0, .external_lex_state = 12},
  [369] = {.lex_state = 0, .external_lex_state = 13},
  [370] = {.lex_state = 0, .external_lex_state = 12},
  [371] = {.lex_state = 0, .external_lex_state = 12},
  [372] = {.lex_state = 0, .external_lex_state = 12},
  [373] = {.lex_state = 0, .external_lex_state = 12},
  [374] = {.lex_state = 0, .external_lex_state = 12},
  [375] = {.lex_state = 0, .external_lex_state = 12},
  [376] = {.lex_state = 0, .external_lex_state = 12},
  [377] = {.lex_state = 0, .external_lex_state = 12},
  [378] = {.lex_state = 0, .external_lex_state = 12},
  [379] = {.lex_state = 0, .external_lex_state = 12},
  [380] = {.lex_state = 0, .external_lex_state = 12},
  [381] = {.lex_state = 0, .external_lex_state = 12},
  [382] = {.lex_state = 0, .external_lex_state = 14},
  [383] = {.lex_state = 0, .external_lex_state = 14},
  [384] = {.lex_state = 0, .external_lex_state = 14},
  [385] = {.lex_state = 0, .external_lex_state = 14},
  [386] = {.lex_state = 0, .external_lex_state = 14},
  [387] = {.lex_state = 0, .external_lex_state = 14},
  [388] = {.lex_state = 0, .external_lex_state = 14},
  [389] = {.lex_state = 0, .external_lex_state = 14},
  [390] = {.lex_state = 0, .external_lex_state = 14},
  [391] = {.lex_state = 0, .external_lex_state = 14},
  [392] = {.lex_state = 0, .external_lex_state = 14},
  [393] = {.lex_state = 0, .external_lex_state = 14},
  [394] = {.lex_state = 0, .external_lex_state = 14},
  [395] = {.lex_state = 0, .external_lex_state = 14},
  [396] = {.lex_state = 0, .external_lex_state = 14},
  [397] = {.lex_state = 0, .external_lex_state = 14},
  [398] = {.lex_state = 0, .external_lex_state = 14},
  [399] = {.lex_state = 0, .external_lex_state = 14},
  [400] = {.lex_state = 0, .external_lex_state = 14},
  [401] = {.lex_state = 0, .external_lex_state = 14},
  [402] = {.lex_state = 0, .external_lex_state = 14},
  [403] = {.lex_state = 0, .external_lex_state = 14},
  [404] = {.lex_state = 0, .external_lex_state = 14},
  [405] = {.lex_state = 0, .external_lex_state = 14},
  [406] = {.lex_state = 0, .external_lex_state = 11},
  [407] = {.lex_state = 0, .external_lex_state = 11},
  [408] = {.lex_state = 0, .external_lex_state = 14},
  [409] = {.lex_state = 0, .external_lex_state = 14},
  [410] = {.lex_state = 0, .external_lex_state = 14},
  [411] = {.lex_state = 0, .external_lex_state = 14},
  [412] = {.lex_state = 0, .external_lex_state = 14},
  [413] = {.lex_state = 0, .external_lex_state = 14},
  [414] = {.lex_state = 0, .external_lex_state = 14},
  [415] = {.lex_state = 0, .external_lex_state = 14},
  [416] = {.lex_state = 0, .external_lex_state = 14},
  [417] = {.lex_state = 0, .external_lex_state = 14},
  [418] = {.lex_state = 0, .external_lex_state = 14},
  [419] = {.lex_state = 0, .external_lex_state = 14},
  [420] = {.lex_state = 0, .external_lex_state = 14},
  [421] = {.lex_state = 0, .external_lex_state = 14},
  [422] = {.lex_state = 0, .external_lex_state = 11},
  [423] = {.lex_state = 0, .external_lex_state = 14},
  [424] = {.lex_state = 0, .external_lex_state = 11},
  [425] = {.lex_state = 0, .external_lex_state = 11},
  [426] = {.lex_state = 0, .external_lex_state = 14},
  [427] = {.lex_state = 0, .external_lex_state = 14},
  [428] = {.lex_state = 0, .external_lex_state = 14},
  [429] = {.lex_state = 0, .external_lex_state = 11},
  [430] = {.lex_state = 0, .external_lex_state = 14},
  [431] = {.lex_state = 0, .external_lex_state = 14},
  [432] = {.lex_state = 0, .external_lex_state = 14},
  [433] = {.lex_state = 0, .external_lex_state = 14},
  [434] = {.lex_state = 0, .external_lex_state = 14},
  [435] = {.lex_state = 0, .external_lex_state = 14},
  [436] = {.lex_state = 0, .external_lex_state = 14},
  [437] = {.lex_state = 0, .external_lex_state = 14},
  [438] = {.lex_state = 0, .external_lex_state = 11},
  [439] = {.lex_state = 0, .external_lex_state = 11},
  [440] = {.lex_state = 0, .external_lex_state = 11},
  [441] = {.lex_state = 0, .external_lex_state = 4},
  [442] = {.lex_state = 0, .external_lex_state = 11},
  [443] = {.lex_state = 0, .external_lex_state = 11},
  [444] = {.lex_state = 0, .external_lex_state = 11},
  [445] = {.lex_state = 0, .external_lex_state = 11},
  [446] = {.lex_state = 0, .external_lex_state = 11},
  [447] = {.lex_state = 0, .external_lex_state = 11},
  [448] = {.lex_state = 0, .external_lex_state = 11},
  [449] = {.lex_state = 0, .external_lex_state = 11},
  [450] = {.lex_state = 0, .external_lex_state = 11},
  [451] = {.lex_state = 0, .external_lex_state = 11},
  [452] = {.lex_state = 0, .external_lex_state = 15},
  [453] = {.lex_state = 0, .external_lex_state = 4},
  [454] = {.lex_state = 0, .external_lex_state = 11},
  [455] = {.lex_state = 0, .external_lex_state = 11},
  [456] = {.lex_state = 0, .external_lex_state = 11},
  [457] = {.lex_state = 0, .external_lex_state = 11},
  [458] = {.lex_state = 0, .external_lex_state = 11},
  [459] = {.lex_state = 0, .external_lex_state = 11},
  [460] = {.lex_state = 0, .external_lex_state = 11},
  [461] = {.lex_state = 0, .external_lex_state = 11},
  [462] = {.lex_state = 0, .external_lex_state = 11},
  [463] = {.lex_state = 0, .external_lex_state = 11},
  [464] = {.lex_state = 0, .external_lex_state = 11},
  [465] = {.lex_state = 0, .external_lex_state = 11},
  [466] = {.lex_state = 0, .external_lex_state = 11},
  [467] = {.lex_state = 0, .external_lex_state = 11},
  [468] = {.lex_state = 0, .external_lex_state = 10},
  [469] = {.lex_state = 0, .external_lex_state = 11},
  [470] = {.lex_state = 0, .external_lex_state = 11},
  [471] = {.lex_state = 0, .external_lex_state = 11},
  [472] = {.lex_state = 0, .external_lex_state = 11},
  [473] = {.lex_state = 0, .external_lex_state = 5},
  [474] = {.lex_state = 0, .external_lex_state = 11},
  [475] = {.lex_state = 0, .external_lex_state = 11},
  [476] = {.lex_state = 0, .external_lex_state = 11},
  [477] = {.lex_state = 0, .external_lex_state = 11},
  [478] = {.lex_state = 0, .external_lex_state = 11},
  [479] = {.lex_state = 0, .external_lex_state = 11},
  [480] = {.lex_state = 0, .external_lex_state = 11},
  [481] = {.lex_state = 0, .external_lex_state = 11},
  [482] = {.lex_state = 0, .external_lex_state = 11},
  [483] = {.lex_state = 0, .external_lex_state = 11},
  [484] = {.lex_state = 0, .external_lex_state = 15},
  [485] = {.lex_state = 0, .external_lex_state = 15},
  [486] = {.lex_state = 0, .external_lex_state = 15},
  [487] = {.lex_state = 0, .external_lex_state = 5},
  [488] = {.lex_state = 0, .external_lex_state = 15},
  [489] = {.lex_state = 0, .external_lex_state = 15},
  [490] = {.lex_state = 0, .external_lex_state = 11},
  [491] = {.lex_state = 0, .external_lex_state = 15},
  [492] = {.lex_state = 0, .external_lex_state = 15},
  [493] = {.lex_state = 0, .external_lex_state = 15},
  [494] = {.lex_state = 0, .external_lex_state = 15},
  [495] = {.lex_state = 0, .external_lex_state = 15},
  [496] = {.lex_state = 0, .external_lex_state = 15},
  [497] = {.lex_state = 0, .external_lex_state = 15},
  [498] = {.lex_state = 0, .external_lex_state = 15},
  [499] = {.lex_state = 0, .external_lex_state = 15},
  [500] = {.lex_state = 0, .external_lex_state = 15},
  [501] = {.lex_state = 0, .external_lex_state = 15},
  [502] = {.lex_state = 0, .external_lex_state = 15},
  [503] = {.lex_state = 0, .external_lex_state = 15},
  [504] = {.lex_state = 0, .external_lex_state = 15},
  [505] = {.lex_state = 0, .external_lex_state = 15},
  [506] = {.lex_state = 0, .external_lex_state = 6},
  [507] = {.lex_state = 0, .external_lex_state = 15},
  [508] = {.lex_state = 0, .external_lex_state = 15},
  [509] = {.lex_state = 0, .external_lex_state = 15},
  [510] = {.lex_state = 0, .external_lex_state = 15},
  [511] = {.lex_state = 0, .external_lex_state = 12},
  [512] = {.lex_state = 0, .external_lex_state = 11},
  [513] = {.lex_state = 0, .external_lex_state = 11},
  [514] = {.lex_state = 0, .external_lex_state = 15},
  [515] = {.lex_state = 0, .external_lex_state = 6},
  [516] = {.lex_state = 0, .external_lex_state = 15},
  [517] = {.lex_state = 0, .external_lex_state = 15},
  [518] = {.lex_state = 0, .external_lex_state = 15},
  [519] = {.lex_state = 0, .external_lex_state = 15},
  [520] = {.lex_state = 0, .external_lex_state = 15},
  [521] = {.lex_state = 0, .external_lex_state = 15},
  [522] = {.lex_state = 0, .external_lex_state = 15},
  [523] = {.lex_state = 0, .external_lex_state = 15},
  [524] = {.lex_state = 0, .external_lex_state = 15},
  [525] = {.lex_state = 0, .external_lex_state = 15},
  [526] = {.lex_state = 0, .external_lex_state = 15},
  [527] = {.lex_state = 0, .external_lex_state = 15},
  [528] = {.lex_state = 0, .external_lex_state = 15},
  [529] = {.lex_state = 0, .external_lex_state = 8},
  [530] = {.lex_state = 0, .external_lex_state = 15},
  [531] = {.lex_state = 0, .external_lex_state = 15},
  [532] = {.lex_state = 0, .external_lex_state = 15},
  [533] = {.lex_state = 0, .external_lex_state = 15},
  [534] = {.lex_state = 0, .external_lex_state = 15},
  [535] = {.lex_state = 0, .external_lex_state = 15},
  [536] = {.lex_state = 0, .external_lex_state = 15},
  [537] = {.lex_state = 0, .external_lex_state = 15},
  [538] = {.lex_state = 0, .external_lex_state = 15},
  [539] = {.lex_state = 0, .external_lex_state = 15},
  [540] = {.lex_state = 0, .external_lex_state = 15},
  [541] = {.lex_state = 0, .external_lex_state = 15},
  [542] = {.lex_state = 0, .external_lex_state = 3},
  [543] = {.lex_state = 0, .external_lex_state = 13},
  [544] = {.lex_state = 0, .external_lex_state = 13},
  [545] = {.lex_state = 0, .external_lex_state = 13},
  [546] = {.lex_state = 0, .external_lex_state = 13},
  [547] = {.lex_state = 0, .external_lex_state = 13},
  [548] = {.lex_state = 0, .external_lex_state = 3},
  [549] = {.lex_state = 0, .external_lex_state = 13},
  [550] = {.lex_state = 0, .external_lex_state = 13},
  [551] = {.lex_state = 0, .external_lex_state = 13},
  [552] = {.lex_state = 0, .external_lex_state = 13},
  [553] = {.lex_state = 0, .external_lex_state = 13},
  [554] = {.lex_state = 0, .external_lex_state = 13},
  [555] = {.lex_state = 0, .external_lex_state = 13},
  [556] = {.lex_state = 0, .external_lex_state = 13},
  [557] = {.lex_state = 0, .external_lex_state = 13},
  [558] = {.lex_state = 0, .external_lex_state = 13},
  [559] = {.lex_state = 0, .external_lex_state = 13},
  [560] = {.lex_state = 0, .external_lex_state = 13},
  [561] = {.lex_state = 0, .external_lex_state = 13},
  [562] = {.lex_state = 0, .external_lex_state = 13},
  [563] = {.lex_state = 0, .external_lex_state = 13},
  [564] = {.lex_state = 0, .external_lex_state = 13},
  [565] = {.lex_state = 0, .external_lex_state = 13},
  [566] = {.lex_state = 0, .external_lex_state = 13},
  [567] = {.lex_state = 0, .external_lex_state = 13},
  [568] = {.lex_state = 0, .external_lex_state = 14},
  [569] = {.lex_state = 0, .external_lex_state = 7},
  [570] = {.lex_state = 0, .external_lex_state = 13},
  [571] = {.lex_state = 0, .external_lex_state = 13},
  [572] = {.lex_state = 0, .external_lex_state = 13},
  [573] = {.lex_state = 0, .external_lex_state = 13},
  [574] = {.lex_state = 0, .external_lex_state = 13},
  [575] = {.lex_state = 0, .external_lex_state = 13},
  [576] = {.lex_state = 0, .external_lex_state = 13},
  [577] = {.lex_state = 0, .external_lex_state = 13},
  [578] = {.lex_state = 0, .external_lex_state = 13},
  [579] = {.lex_state = 0, .external_lex_state = 13},
  [580] = {.lex_state = 0, .external_lex_state = 13},
  [581] = {.lex_state = 0, .external_lex_state = 13},
  [582] = {.lex_state = 0, .external_lex_state = 13},
  [583] = {.lex_state = 0, .external_lex_state = 7},
  [584] = {.lex_state = 0, .external_lex_state = 13},
  [585] = {.lex_state = 0, .external_lex_state = 9},
  [586] = {.lex_state = 0, .external_lex_state = 13},
  [587] = {.lex_state = 0, .external_lex_state = 13},
  [588] = {.lex_state = 0, .external_lex_state = 13},
  [589] = {.lex_state = 0, .external_lex_state = 13},
  [590] = {.lex_state = 0, .external_lex_state = 13},
  [591] = {.lex_state = 0, .external_lex_state = 13},
  [592] = {.lex_state = 0, .external_lex_state = 13},
  [593] = {.lex_state = 0, .external_lex_state = 13},
  [594] = {.lex_state = 0, .external_lex_state = 13},
  [595] = {.lex_state = 0, .external_lex_state = 13},
  [596] = {.lex_state = 0, .external_lex_state = 13},
  [597] = {.lex_state = 0, .external_lex_state = 13},
  [598] = {.lex_state = 0, .external_lex_state = 12},
  [599] = {.lex_state = 0, .external_lex_state = 12},
  [600] = {.lex_state = 0, .external_lex_state = 12},
  [601] = {.lex_state = 0, .external_lex_state = 12},
  [602] = {.lex_state = 0, .external_lex_state = 12},
  [603] = {.lex_state = 0, .external_lex_state = 12},
  [604] = {.lex_state = 0, .external_lex_state = 12},
  [605] = {.lex_state = 0, .external_lex_state = 12},
  [606] = {.lex_state = 0, .external_lex_state = 12},
  [607] = {.lex_state = 0, .external_lex_state = 12},
  [608] = {.lex_state = 0, .external_lex_state = 12},
  [609] = {.lex_state = 0, .external_lex_state = 12},
  [610] = {.lex_state = 0, .external_lex_state = 12},
  [611] = {.lex_state = 0, .external_lex_state = 12},
  [612] = {.lex_state = 0, .external_lex_state = 12},
  [613] = {.lex_state = 0, .external_lex_state = 12},
  [614] = {.lex_state = 0, .external_lex_state = 12},
  [615] = {.lex_state = 0, .external_lex_state = 12},
  [616] = {.lex_state = 0, .external_lex_state = 12},
  [617] = {.lex_state = 0, .external_lex_state = 12},
  [618] = {.lex_state = 0, .external_lex_state = 12},
  [619] = {.lex_state = 0, .external_lex_state = 12},
  [620] = {.lex_state = 0, .external_lex_state = 12},
  [621] = {.lex_state = 0, .external_lex_state = 12},
  [622] = {.lex_state = 0, .external_lex_state = 12},
  [623] = {.lex_state = 0, .external_lex_state = 12},
  [624] = {.lex_state = 0, .external_lex_state = 12},
  [625] = {.lex_state = 0, .external_lex_state = 12},
  [626] = {.lex_state = 0, .external_lex_state = 12},
  [627] = {.lex_state = 0, .external_lex_state = 12},
  [628] = {.lex_state = 0, .external_lex_state = 12},
  [629] = {.lex_state = 0, .external_lex_state = 12},
  [630] = {.lex_state = 0, .external_lex_state = 12},
  [631] = {.lex_state = 0, .external_lex_state = 12},
  [632] = {.lex_state = 0, .external_lex_state = 11},
  [633] = {.lex_state = 0, .external_lex_state = 4},
  [634] = {.lex_state = 0, .external_lex_state = 6},
  [635] = {.lex_state = 0, .external_lex_state = 3},
  [636] = {.lex_state = 0, .external_lex_state = 15},
  [637] = {.lex_state = 0, .external_lex_state = 13},
  [638] = {.lex_state = 0, .external_lex_state = 15},
  [639] = {.lex_state = 0, .external_lex_state = 14},
  [640] = {.lex_state = 0, .external_lex_state = 15},
  [641] = {.lex_state = 0, .external_lex_state = 12},
  [642] = {.lex_state = 0, .external_lex_state = 5},
  [643] = {.lex_state = 0, .external_lex_state = 14},
  [644] = {.lex_state = 0, .external_lex_state = 12},
  [645] = {.lex_state = 0, .external_lex_state = 13},
  [646] = {.lex_state = 0, .external_lex_state = 11},
  [647] = {.lex_state = 0, .external_lex_state = 7},
  [648] = {.lex_state = 0, .external_lex_state = 11},
  [649] = {.lex_state = 0, .external_lex_state = 13},
  [650] = {.lex_state = 0, .external_lex_state = 15},
  [651] = {.lex_state = 0, .external_lex_state = 12},
  [652] = {.lex_state = 0, .external_lex_state = 14},
  [653] = {.lex_state = 0, .external_lex_state = 5},
  [654] = {.lex_state = 0, .external_lex_state = 3},
  [655] = {.lex_state = 0, .external_lex_state = 6},
  [656] = {.lex_state = 0, .external_lex_state = 6},
  [657] = {.lex_state = 0, .external_lex_state = 3},
  [658] = {.lex_state = 0, .external_lex_state = 5},
  [659] = {.lex_state = 0, .external_lex_state = 3},
  [660] = {.lex_state = 0, .external_lex_state = 3},
  [661] = {.lex_state = 0, .external_lex_state = 3},
  [662] = {.lex_state = 0, .external_lex_state = 4},
  [663] = {.lex_state = 0, .external_lex_state = 4},
  [664] = {.lex_state = 0, .external_lex_state = 6},
  [665] = {.lex_state = 0, .external_lex_state = 6},
  [666] = {.lex_state = 0, .external_lex_state = 4},
  [667] = {.lex_state = 0, .external_lex_state = 5},
  [668] = {.lex_state = 0, .external_lex_state = 5},
  [669] = {.lex_state = 0, .external_lex_state = 3},
  [670] = {.lex_state = 0, .external_lex_state = 5},
  [671] = {.lex_state = 0, .external_lex_state = 5},
  [672] = {.lex_state = 0, .external_lex_state = 4},
  [673] = {.lex_state = 0, .external_lex_state = 5},
  [674] = {.lex_state = 0, .external_lex_state = 4},
  [675] = {.lex_state = 0, .external_lex_state = 5},
  [676] = {.lex_state = 0, .external_lex_state = 4},
  [677] = {.lex_state = 0, .external_lex_state = 4},
  [678] = {.lex_state = 0, .external_lex_state = 4},
  [679] = {.lex_state = 0, .external_lex_state = 6},
  [680] = {.lex_state = 0, .external_lex_state = 6},
  [681] = {.lex_state = 0, .external_lex_state = 6},
  [682] = {.lex_state = 0, .external_lex_state = 6},
  [683] = {.lex_state = 0, .external_lex_state = 4},
  [684] = {.lex_state = 0, .external_lex_state = 7},
  [685] = {.lex_state = 0, .external_lex_state = 7},
  [686] = {.lex_state = 0, .external_lex_state = 7},
  [687] = {.lex_state = 0, .external_lex_state = 3},
  [688] = {.lex_state = 0, .external_lex_state = 7},
  [689] = {.lex_state = 0, .external_lex_state = 7},
  [690] = {.lex_state = 0, .external_lex_state = 6},
  [691] = {.lex_state = 0, .external_lex_state = 7},
  [692] = {.lex_state = 0, .external_lex_state = 7},
  [693] = {.lex_state = 0, .external_lex_state = 3},
  [694] = {.lex_state = 0, .external_lex_state = 5},
  [695] = {.lex_state = 0, .external_lex_state = 7},
  [696] = {.lex_state = 0, .external_lex_state = 7},
  [697] = {.lex_state = 0, .external_lex_state = 3},
  [698] = {.lex_state = 0, .external_lex_state = 11},
  [699] = {.lex_state = 0, .external_lex_state = 14},
  [700] = {.lex_state = 0, .external_lex_state = 16},
  [701] = {.lex_state = 0, .external_lex_state = 11},
  [702] = {.lex_state = 0, .external_lex_state = 11},
  [703] = {.lex_state = 0, .external_lex_state = 14},
  [704] = {.lex_state = 0, .external_lex_state = 11},
  [705] = {.lex_state = 0, .external_lex_state = 14},
  [706] = {.lex_state = 0, .external_lex_state = 14},
  [707] = {.lex_state = 0, .external_lex_state = 14},
  [708] = {.lex_state = 0, .external_lex_state = 16},
  [709] = {.lex_state = 0, .external_lex_state = 5},
  [710] = {.lex_state = 0, .external_lex_state = 14},
  [711] = {.lex_state = 0, .external_lex_state = 16},
  [712] = {.lex_state = 0, .external_lex_state = 16},
  [713] = {.lex_state = 0, .external_lex_state = 13},
  [714] = {.lex_state = 0, .external_lex_state = 6},
  [715] = {.lex_state = 0, .external_lex_state = 13},
  [716] = {.lex_state = 0, .external_lex_state = 13},
  [717] = {.lex_state = 0, .external_lex_state = 13},
  [718] = {.lex_state = 0, .external_lex_state = 13},
  [719] = {.lex_state = 0, .external_lex_state = 16},
  [720] = {.lex_state = 0, .external_lex_state = 16},
  [721] = {.lex_state = 0, .external_lex_state = 13},
  [722] = {.lex_state = 0, .external_lex_state = 13},
  [723] = {.lex_state = 0, .external_lex_state = 15},
  [724] = {.lex_state = 0, .external_lex_state = 16},
  [725] = {.lex_state = 0, .external_lex_state = 15},
  [726] = {.lex_state = 0, .external_lex_state = 15},
  [727] = {.lex_state = 0, .external_lex_state = 15},
  [728] = {.lex_state = 0, .external_lex_state = 15},
  [729] = {.lex_state = 0, .external_lex_state = 13},
  [730] = {.lex_state = 0, .external_lex_state = 13},
  [731] = {.lex_state = 0, .external_lex_state = 14},
  [732] = {.lex_state = 0, .external_lex_state = 14},
  [733] = {.lex_state = 0, .external_lex_state = 15},
  [734] = {.lex_state = 0, .external_lex_state = 15},
  [735] = {.lex_state = 0, .external_lex_state = 15},
  [736] = {.lex_state = 0, .external_lex_state = 14},
  [737] = {.lex_state = 0, .external_lex_state = 16},
  [738] = {.lex_state = 0, .external_lex_state = 16},
  [739] = {.lex_state = 0, .external_lex_state = 11},
  [740] = {.lex_state = 0, .external_lex_state = 11},
  [741] = {.lex_state = 0, .external_lex_state = 15},
  [742] = {.lex_state = 0, .external_lex_state = 15},
  [743] = {.lex_state = 0, .external_lex_state = 14},
  [744] = {.lex_state = 0, .external_lex_state = 11},
  [745] = {.lex_state = 0, .external_lex_state = 11},
  [746] = {.lex_state = 0, .external_lex_state = 16},
  [747] = {.lex_state = 0, .external_lex_state = 12},
  [748] = {.lex_state = 0, .external_lex_state = 3},
  [749] = {.lex_state = 0, .external_lex_state = 7},
  [750] = {.lex_state = 0, .external_lex_state = 16},
  [751] = {.lex_state = 0, .external_lex_state = 12},
  [752] = {.lex_state = 0, .external_lex_state = 12},
  [753] = {.lex_state = 0, .external_lex_state = 12},
  [754] = {.lex_state = 0, .external_lex_state = 12},
  [755] = {.lex_state = 0, .external_lex_state = 12},
  [756] = {.lex_state = 0, .external_lex_state = 12},
  [757] = {.lex_state = 0, .external_lex_state = 16},
  [758] = {.lex_state = 0, .external_lex_state = 16},
  [759] = {.lex_state = 0, .external_lex_state = 16},
  [760] = {.lex_state = 0, .external_lex_state = 4},
  [761] = {.lex_state = 0, .external_lex_state = 16},
  [762] = {.lex_state = 0, .external_lex_state = 12},
  [763] = {.lex_state = 0, .external_lex_state = 12},
  [764] = {.lex_state = 0, .external_lex_state = 16},
  [765] = {.lex_state = 0, .external_lex_state = 16},
  [766] = {.lex_state = 0, .external_lex_state = 12},
  [767] = {.lex_state = 0, .external_lex_state = 16},
  [768] = {.lex_state = 0, .external_lex_state = 16},
  [769] = {.lex_state = 0, .external_lex_state = 11},
  [770] = {.lex_state = 0, .external_lex_state = 16},
  [771] = {.lex_state = 0, .external_lex_state = 16},
  [772] = {.lex_state = 0, .external_lex_state = 16},
  [773] = {.lex_state = 0, .external_lex_state = 16},
  [774] = {.lex_state = 0, .external_lex_state = 16},
  [775] = {.lex_state = 0, .external_lex_state = 7},
  [776] = {.lex_state = 0, .external_lex_state = 5},
  [777] = {.lex_state = 0, .external_lex_state = 3},
  [778] = {.lex_state = 0, .external_lex_state = 3},
  [779] = {.lex_state = 0, .external_lex_state = 3},
  [780] = {.lex_state = 0, .external_lex_state = 3},
  [781] = {.lex_state = 0, .external_lex_state = 5},
  [782] = {.lex_state = 0, .external_lex_state = 5},
  [783] = {.lex_state = 0, .external_lex_state = 5},
  [784] = {.lex_state = 0, .external_lex_state = 5},
  [785] = {.lex_state = 0, .external_lex_state = 5},
  [786] = {.lex_state = 0, .external_lex_state = 5},
  [787] = {.lex_state = 0, .external_lex_state = 5},
  [788] = {.lex_state = 0, .external_lex_state = 6},
  [789] = {.lex_state = 0, .external_lex_state = 7},
  [790] = {.lex_state = 0, .external_lex_state = 2},
  [791] = {.lex_state = 0, .external_lex_state = 14},
  [792] = {.lex_state = 0, .external_lex_state = 3},
  [793] = {.lex_state = 0, .external_lex_state = 7},
  [794] = {.lex_state = 0, .external_lex_state = 7},
  [795] = {.lex_state = 0, .external_lex_state = 7},
  [796] = {.lex_state = 0, .external_lex_state = 7},
  [797] = {.lex_state = 0, .external_lex_state = 7},
  [798] = {.lex_state = 0, .external_lex_state = 10},
  [799] = {.lex_state = 0, .external_lex_state = 7},
  [800] = {.lex_state = 0, .external_lex_state = 7},
  [801] = {.lex_state = 0, .external_lex_state = 3},
  [802] = {.lex_state = 0, .external_lex_state = 4},
  [803] = {.lex_state = 0, .external_lex_state = 5},
  [804] = {.lex_state = 0, .external_lex_state = 5},
  [805] = {.lex_state = 0, .external_lex_state = 5},
  [806] = {.lex_state = 0, .external_lex_state = 5},
  [807] = {.lex_state = 0, .external_lex_state = 3},
  [808] = {.lex_state = 0, .external_lex_state = 3},
  [809] = {.lex_state = 0, .external_lex_state = 4},
  [810] = {.lex_state = 0, .external_lex_state = 3},
  [811] = {.lex_state = 0, .external_lex_state = 4},
  [812] = {.lex_state = 0, .external_lex_state = 7},
  [813] = {.lex_state = 0, .external_lex_state = 4},
  [814] = {.lex_state = 0, .external_lex_state = 7},
  [815] = {.lex_state = 0, .external_lex_state = 7},
  [816] = {.lex_state = 0, .external_lex_state = 4},
  [817] = {.lex_state = 0, .external_lex_state = 7},
  [818] = {.lex_state = 0, .external_lex_state = 7},
  [819] = {.lex_state = 0, .external_lex_state = 3},
  [820] = {.lex_state = 0, .external_lex_state = 7},
  [821] = {.lex_state = 0, .external_lex_state = 9},
  [822] = {.lex_state = 0, .external_lex_state = 6},
  [823] = {.lex_state = 0, .external_lex_state = 4},
  [824] = {.lex_state = 0, .external_lex_state = 3},
  [825] = {.lex_state = 0, .external_lex_state = 10},
  [826] = {.lex_state = 0, .external_lex_state = 6},
  [827] = {.lex_state = 0, .external_lex_state = 4},
  [828] = {.lex_state = 0, .external_lex_state = 6},
  [829] = {.lex_state = 0, .external_lex_state = 4},
  [830] = {.lex_state = 0, .external_lex_state = 7},
  [831] = {.lex_state = 0, .external_lex_state = 7},
  [832] = {.lex_state = 0, .external_lex_state = 7},
  [833] = {.lex_state = 0, .external_lex_state = 7},
  [834] = {.lex_state = 0, .external_lex_state = 4},
  [835] = {.lex_state = 0, .external_lex_state = 16},
  [836] = {.lex_state = 0, .external_lex_state = 10},
  [837] = {.lex_state = 0, .external_lex_state = 15},
  [838] = {.lex_state = 0, .external_lex_state = 6},
  [839] = {.lex_state = 0, .external_lex_state = 6},
  [840] = {.lex_state = 0, .external_lex_state = 5},
  [841] = {.lex_state = 0, .external_lex_state = 2},
  [842] = {.lex_state = 0, .external_lex_state = 10},
  [843] = {.lex_state = 0, .external_lex_state = 8},
  [844] = {.lex_state = 0, .external_lex_state = 4},
  [845] = {.lex_state = 0, .external_lex_state = 4},
  [846] = {.lex_state = 0, .external_lex_state = 6},
  [847] = {.lex_state = 0, .external_lex_state = 6},
  [848] = {.lex_state = 0, .external_lex_state = 6},
  [849] = {.lex_state = 0, .external_lex_state = 10},
  [850] = {.lex_state = 0, .external_lex_state = 6},
  [851] = {.lex_state = 0, .external_lex_state = 6},
  [852] = {.lex_state = 0, .external_lex_state = 6},
  [853] = {.lex_state = 0, .external_lex_state = 6},
  [854] = {.lex_state = 0, .external_lex_state = 6},
  [855] = {.lex_state = 0, .external_lex_state = 6},
  [856] = {.lex_state = 0, .external_lex_state = 3},
  [857] = {.lex_state = 0, .external_lex_state = 6},
  [858] = {.lex_state = 0, .external_lex_state = 13},
  [859] = {.lex_state = 0, .external_lex_state = 10},
  [860] = {.lex_state = 0, .external_lex_state = 3},
  [861] = {.lex_state = 0, .external_lex_state = 3},
  [862] = {.lex_state = 0, .external_lex_state = 4},
  [863] = {.lex_state = 0, .external_lex_state = 10},
  [864] = {.lex_state = 0, .external_lex_state = 10},
  [865] = {.lex_state = 0, .external_lex_state = 3},
  [866] = {.lex_state = 0, .external_lex_state = 3},
  [867] = {.lex_state = 0, .external_lex_state = 3},
  [868] = {.lex_state = 0, .external_lex_state = 10},
  [869] = {.lex_state = 0, .external_lex_state = 10},
  [870] = {.lex_state = 0, .external_lex_state = 3},
  [871] = {.lex_state = 0, .external_lex_state = 4},
  [872] = {.lex_state = 0, .external_lex_state = 10},
  [873] = {.lex_state = 0, .external_lex_state = 4},
  [874] = {.lex_state = 0, .external_lex_state = 10},
  [875] = {.lex_state = 0, .external_lex_state = 5},
  [876] = {.lex_state = 0, .external_lex_state = 5},
  [877] = {.lex_state = 0, .external_lex_state = 4},
  [878] = {.lex_state = 0, .external_lex_state = 10},
  [879] = {.lex_state = 0, .external_lex_state = 10},
  [880] = {.lex_state = 0, .external_lex_state = 11},
  [881] = {.lex_state = 0, .external_lex_state = 4},
  [882] = {.lex_state = 0, .external_lex_state = 10},
  [883] = {.lex_state = 0, .external_lex_state = 10},
  [884] = {.lex_state = 0, .external_lex_state = 3},
  [885] = {.lex_state = 0, .external_lex_state = 4},
  [886] = {.lex_state = 0, .external_lex_state = 10},
  [887] = {.lex_state = 0, .external_lex_state = 10},
  [888] = {.lex_state = 0, .external_lex_state = 5},
  [889] = {.lex_state = 0, .external_lex_state = 10},
  [890] = {.lex_state = 0, .external_lex_state = 10},
  [891] = {.lex_state = 0, .external_lex_state = 10},
  [892] = {.lex_state = 0, .external_lex_state = 5},
  [893] = {.lex_state = 0, .external_lex_state = 10},
  [894] = {.lex_state = 0, .external_lex_state = 10},
  [895] = {.lex_state = 0, .external_lex_state = 5},
  [896] = {.lex_state = 0, .external_lex_state = 6},
  [897] = {.lex_state = 0, .external_lex_state = 10},
  [898] = {.lex_state = 0, .external_lex_state = 4},
  [899] = {.lex_state = 0, .external_lex_state = 10},
  [900] = {.lex_state = 0, .external_lex_state = 4},
  [901] = {.lex_state = 0, .external_lex_state = 6},
  [902] = {.lex_state = 0, .external_lex_state = 6},
  [903] = {.lex_state = 0, .external_lex_state = 5},
  [904] = {.lex_state = 0, .external_lex_state = 12},
  [905] = {.lex_state = 0, .external_lex_state = 11},
  [906] = {.lex_state = 0, .external_lex_state = 12},
  [907] = {.lex_state = 0, .external_lex_state = 14},
  [908] = {.lex_state = 0, .external_lex_state = 14},
  [909] = {.lex_state = 0, .external_lex_state = 15},
  [910] = {.lex_state = 0, .external_lex_state = 11},
  [911] = {.lex_state = 0, .external_lex_state = 12},
  [912] = {.lex_state = 0, .external_lex_state = 13},
  [913] = {.lex_state = 0, .external_lex_state = 11},
  [914] = {.lex_state = 0, .external_lex_state = 13},
  [915] = {.lex_state = 0, .external_lex_state = 13},
  [916] = {.lex_state = 0, .external_lex_state = 12},
  [917] = {.lex_state = 0, .external_lex_state = 13},
  [918] = {.lex_state = 0, .external_lex_state = 15},
  [919] = {.lex_state = 0, .external_lex_state = 11},
  [920] = {.lex_state = 0, .external_lex_state = 13},
  [921] = {.lex_state = 0, .external_lex_state = 13},
  [922] = {.lex_state = 0, .external_lex_state = 14},
  [923] = {.lex_state = 0, .external_lex_state = 12},
  [924] = {.lex_state = 0, .external_lex_state = 12},
  [925] = {.lex_state = 0, .external_lex_state = 14},
  [926] = {.lex_state = 0, .external_lex_state = 12},
  [927] = {.lex_state = 0, .external_lex_state = 12},
  [928] = {.lex_state = 0, .external_lex_state = 12},
  [929] = {.lex_state = 0, .external_lex_state = 13},
  [930] = {.lex_state = 0, .external_lex_state = 12},
  [931] = {.lex_state = 0, .external_lex_state = 12},
  [932] = {.lex_state = 0, .external_lex_state = 14},
  [933] = {.lex_state = 0, .external_lex_state = 11},
  [934] = {.lex_state = 0, .external_lex_state = 13},
  [935] = {.lex_state = 0, .external_lex_state = 11},
  [936] = {.lex_state = 0, .external_lex_state = 13},
  [937] = {.lex_state = 0, .external_lex_state = 14},
  [938] = {.lex_state = 0, .external_lex_state = 14},
  [939] = {.lex_state = 0, .external_lex_state = 15},
  [940] = {.lex_state = 0, .external_lex_state = 14},
  [941] = {.lex_state = 0, .external_lex_state = 14},
  [942] = {.lex_state = 0, .external_lex_state = 14},
  [943] = {.lex_state = 0, .external_lex_state = 14},
  [944] = {.lex_state = 0, .external_lex_state = 14},
  [945] = {.lex_state = 0, .external_lex_state = 11},
  [946] = {.lex_state = 0, .external_lex_state = 11},
  [947] = {.lex_state = 0, .external_lex_state = 11},
  [948] = {.lex_state = 0, .external_lex_state = 14},
  [949] = {.lex_state = 0, .external_lex_state = 11},
  [950] = {.lex_state = 0, .external_lex_state = 13},
  [951] = {.lex_state = 0, .external_lex_state = 15},
  [952] = {.lex_state = 0, .external_lex_state = 14},
  [953] = {.lex_state = 0, .external_lex_state = 13},
  [954] = {.lex_state = 0, .external_lex_state = 13},
  [955] = {.lex_state = 0, .external_lex_state = 13},
  [956] = {.lex_state = 0, .external_lex_state = 11},
  [957] = {.lex_state = 0, .external_lex_state = 12},
  [958] = {.lex_state = 0, .external_lex_state = 13},
  [959] = {.lex_state = 0, .external_lex_state = 12},
  [960] = {.lex_state = 0, .external_lex_state = 15},
  [961] = {.lex_state = 0, .external_lex_state = 13},
  [962] = {.lex_state = 0, .external_lex_state = 15},
  [963] = {.lex_state = 0, .external_lex_state = 13},
  [964] = {.lex_state = 0, .external_lex_state = 11},
  [965] = {.lex_state = 0, .external_lex_state = 11},
  [966] = {.lex_state = 0, .external_lex_state = 15},
  [967] = {.lex_state = 0, .external_lex_state = 14},
  [968] = {.lex_state = 0, .external_lex_state = 11},
  [969] = {.lex_state = 0, .external_lex_state = 15},
  [970] = {.lex_state = 0, .external_lex_state = 11},
  [971] = {.lex_state = 0, .external_lex_state = 13},
  [972] = {.lex_state = 0, .external_lex_state = 12},
  [973] = {.lex_state = 0, .external_lex_state = 15},
  [974] = {.lex_state = 0, .external_lex_state = 12},
  [975] = {.lex_state = 0, .external_lex_state = 14},
  [976] = {.lex_state = 0, .external_lex_state = 12},
  [977] = {.lex_state = 0, .external_lex_state = 14},
  [978] = {.lex_state = 0, .external_lex_state = 15},
  [979] = {.lex_state = 0, .external_lex_state = 11},
  [980] = {.lex_state = 0, .external_lex_state = 12},
  [981] = {.lex_state = 0, .external_lex_state = 13},
  [982] = {.lex_state = 0, .external_lex_state = 13},
  [983] = {.lex_state = 0, .external_lex_state = 12},
  [984] = {.lex_state = 0, .external_lex_state = 15},
  [985] = {.lex_state = 0, .external_lex_state = 15},
  [986] = {.lex_state = 0, .external_lex_state = 12},
  [987] = {.lex_state = 0, .external_lex_state = 12},
  [988] = {.lex_state = 0, .external_lex_state = 15},
  [989] = {.lex_state = 0, .external_lex_state = 15},
  [990] = {.lex_state = 0, .external_lex_state = 15},
  [991] = {.lex_state = 0, .external_lex_state = 11},
  [992] = {.lex_state = 0, .external_lex_state = 11},
  [993] = {.lex_state = 0, .external_lex_state = 15},
  [994] = {.lex_state = 0, .external_lex_state = 14},
  [995] = {.lex_state = 0, .external_lex_state = 10},
  [996] = {.lex_state = 0, .external_lex_state = 11},
  [997] = {.lex_state = 0, .external_lex_state = 15},
  [998] = {.lex_state = 0, .external_lex_state = 14},
  [999] = {.lex_state = 0, .external_lex_state = 15},
  [1000] = {.lex_state = 0, .external_lex_state = 15},
  [1001] = {.lex_state = 0, .external_lex_state = 14},
  [1002] = {.lex_state = 0, .external_lex_state = 12},
  [1003] = {.lex_state = 0, .external_lex_state = 15},
  [1004] = {.lex_state = 0, .external_lex_state = 17},
  [1005] = {.lex_state = 0, .external_lex_state = 17},
  [1006] = {.lex_state = 0, .external_lex_state = 17},
  [1007] = {.lex_state = 0, .external_lex_state = 17},
  [1008] = {.lex_state = 0, .external_lex_state = 17},
  [1009] = {.lex_state = 0, .external_lex_state = 17},
  [1010] = {.lex_state = 0, .external_lex_state = 17},
  [1011] = {.lex_state = 0, .external_lex_state = 17},
  [1012] = {.lex_state = 0, .external_lex_state = 17},
  [1013] = {.lex_state = 0, .external_lex_state = 17},
  [1014] = {.lex_state = 0, .external_lex_state = 17},
  [1015] = {.lex_state = 0, .external_lex_state = 17},
  [1016] = {.lex_state = 0, .external_lex_state = 17},
  [1017] = {.lex_state = 0, .external_lex_state = 17},
  [1018] = {.lex_state = 0, .external_lex_state = 17},
  [1019] = {.lex_state = 0, .external_lex_state = 17},
  [1020] = {.lex_state = 0, .external_lex_state = 17},
  [1021] = {.lex_state = 0, .external_lex_state = 17},
  [1022] = {.lex_state = 0, .external_lex_state = 17},
  [1023] = {.lex_state = 0, .external_lex_state = 17},
  [1024] = {.lex_state = 0, .external_lex_state = 17},
  [1025] = {.lex_state = 0, .external_lex_state = 17},
  [1026] = {.lex_state = 0, .external_lex_state = 17},
  [1027] = {.lex_state = 0, .external_lex_state = 17},
  [1028] = {.lex_state = 0, .external_lex_state = 17},
  [1029] = {.lex_state = 0, .external_lex_state = 17},
  [1030] = {.lex_state = 0, .external_lex_state = 17},
  [1031] = {.lex_state = 0, .external_lex_state = 17},
  [1032] = {.lex_state = 0, .external_lex_state = 17},
  [1033] = {.lex_state = 0, .external_lex_state = 17},
  [1034] = {.lex_state = 0, .external_lex_state = 17},
  [1035] = {.lex_state = 0, .external_lex_state = 17},
  [1036] = {.lex_state = 0, .external_lex_state = 17},
  [1037] = {.lex_state = 0, .external_lex_state = 17},
  [1038] = {.lex_state = 0, .external_lex_state = 17},
  [1039] = {.lex_state = 0, .external_lex_state = 17},
  [1040] = {.lex_state = 0, .external_lex_state = 17},
  [1041] = {.lex_state = 0, .external_lex_state = 17},
  [1042] = {.lex_state = 0, .external_lex_state = 17},
  [1043] = {.lex_state = 0, .external_lex_state = 17},
  [1044] = {.lex_state = 0, .external_lex_state = 17},
  [1045] = {.lex_state = 0, .external_lex_state = 17},
  [1046] = {.lex_state = 0, .external_lex_state = 17},
  [1047] = {.lex_state = 0, .external_lex_state = 17},
  [1048] = {.lex_state = 0, .external_lex_state = 17},
  [1049] = {.lex_state = 0, .external_lex_state = 17},
  [1050] = {.lex_state = 0, .external_lex_state = 17},
  [1051] = {.lex_state = 0, .external_lex_state = 17},
  [1052] = {.lex_state = 0, .external_lex_state = 17},
  [1053] = {.lex_state = 0, .external_lex_state = 17},
  [1054] = {.lex_state = 0, .external_lex_state = 17},
  [1055] = {.lex_state = 0, .external_lex_state = 17},
  [1056] = {.lex_state = 0, .external_lex_state = 17},
  [1057] = {.lex_state = 0, .external_lex_state = 17},
  [1058] = {.lex_state = 0, .external_lex_state = 17},
  [1059] = {.lex_state = 0, .external_lex_state = 17},
  [1060] = {.lex_state = 0, .external_lex_state = 17},
  [1061] = {.lex_state = 0, .external_lex_state = 17},
  [1062] = {.lex_state = 0, .external_lex_state = 17},
  [1063] = {.lex_state = 0, .external_lex_state = 17},
  [1064] = {.lex_state = 0, .external_lex_state = 17},
  [1065] = {.lex_state = 0, .external_lex_state = 17},
  [1066] = {.lex_state = 0, .external_lex_state = 17},
  [1067] = {.lex_state = 0, .external_lex_state = 17},
  [1068] = {.lex_state = 0, .external_lex_state = 17},
  [1069] = {.lex_state = 0, .external_lex_state = 17},
  [1070] = {.lex_state = 0, .external_lex_state = 17},
  [1071] = {.lex_state = 0, .external_lex_state = 17},
  [1072] = {.lex_state = 0, .external_lex_state = 17},
  [1073] = {.lex_state = 0, .external_lex_state = 17},
  [1074] = {.lex_state = 0, .external_lex_state = 17},
  [1075] = {.lex_state = 0, .external_lex_state = 17},
  [1076] = {.lex_state = 0, .external_lex_state = 17},
  [1077] = {.lex_state = 0, .external_lex_state = 17},
  [1078] = {.lex_state = 0, .external_lex_state = 17},
  [1079] = {.lex_state = 0, .external_lex_state = 17},
  [1080] = {.lex_state = 0, .external_lex_state = 17},
  [1081] = {.lex_state = 0, .external_lex_state = 17},
  [1082] = {.lex_state = 0, .external_lex_state = 17},
  [1083] = {.lex_state = 0, .external_lex_state = 17},
  [1084] = {.lex_state = 0, .external_lex_state = 17},
  [1085] = {.lex_state = 0, .external_lex_state = 17},
  [1086] = {.lex_state = 0, .external_lex_state = 17},
  [1087] = {.lex_state = 0, .external_lex_state = 17},
  [1088] = {.lex_state = 0, .external_lex_state = 17},
  [1089] = {.lex_state = 0, .external_lex_state = 17},
  [1090] = {.lex_state = 0, .external_lex_state = 17},
  [1091] = {.lex_state = 0, .external_lex_state = 17},
  [1092] = {.lex_state = 0, .external_lex_state = 17},
  [1093] = {.lex_state = 0, .external_lex_state = 17},
  [1094] = {.lex_state = 0, .external_lex_state = 17},
  [1095] = {.lex_state = 0, .external_lex_state = 17},
  [1096] = {.lex_state = 0, .external_lex_state = 17},
  [1097] = {.lex_state = 0, .external_lex_state = 17},
  [1098] = {.lex_state = 0, .external_lex_state = 17},
  [1099] = {.lex_state = 0, .external_lex_state = 17},
  [1100] = {.lex_state = 0, .external_lex_state = 17},
  [1101] = {.lex_state = 0, .external_lex_state = 17},
  [1102] = {.lex_state = 0, .external_lex_state = 17},
  [1103] = {.lex_state = 0, .external_lex_state = 17},
  [1104] = {.lex_state = 0, .external_lex_state = 17},
  [1105] = {.lex_state = 0, .external_lex_state = 17},
  [1106] = {.lex_state = 0, .external_lex_state = 17},
  [1107] = {.lex_state = 0, .external_lex_state = 17},
  [1108] = {.lex_state = 0, .external_lex_state = 17},
  [1109] = {.lex_state = 0, .external_lex_state = 17},
  [1110] = {.lex_state = 0, .external_lex_state = 17},
  [1111] = {.lex_state = 0, .external_lex_state = 17},
  [1112] = {.lex_state = 0, .external_lex_state = 17},
  [1113] = {.lex_state = 0, .external_lex_state = 17},
  [1114] = {.lex_state = 0, .external_lex_state = 17},
  [1115] = {.lex_state = 0, .external_lex_state = 17},
  [1116] = {.lex_state = 0, .external_lex_state = 17},
  [1117] = {.lex_state = 0, .external_lex_state = 17},
  [1118] = {.lex_state = 0, .external_lex_state = 17},
  [1119] = {.lex_state = 0, .external_lex_state = 17},
  [1120] = {.lex_state = 0, .external_lex_state = 17},
  [1121] = {.lex_state = 0, .external_lex_state = 17},
  [1122] = {.lex_state = 0, .external_lex_state = 17},
  [1123] = {.lex_state = 0, .external_lex_state = 17},
  [1124] = {.lex_state = 0, .external_lex_state = 17},
  [1125] = {.lex_state = 0, .external_lex_state = 17},
  [1126] = {.lex_state = 0, .external_lex_state = 17},
  [1127] = {.lex_state = 0, .external_lex_state = 17},
  [1128] = {.lex_state = 0, .external_lex_state = 17},
  [1129] = {.lex_state = 0, .external_lex_state = 17},
  [1130] = {.lex_state = 0, .external_lex_state = 17},
  [1131] = {.lex_state = 0, .external_lex_state = 18},
  [1132] = {.lex_state = 0, .external_lex_state = 17},
  [1133] = {.lex_state = 0, .external_lex_state = 17},
  [1134] = {.lex_state = 0, .external_lex_state = 17},
  [1135] = {.lex_state = 0, .external_lex_state = 17},
  [1136] = {.lex_state = 0, .external_lex_state = 17},
  [1137] = {.lex_state = 0, .external_lex_state = 17},
  [1138] = {.lex_state = 0, .external_lex_state = 17},
  [1139] = {.lex_state = 0, .external_lex_state = 17},
  [1140] = {.lex_state = 0, .external_lex_state = 17},
  [1141] = {.lex_state = 0, .external_lex_state = 17},
  [1142] = {.lex_state = 0, .external_lex_state = 17},
  [1143] = {.lex_state = 0, .external_lex_state = 17},
  [1144] = {.lex_state = 0, .external_lex_state = 17},
  [1145] = {.lex_state = 0, .external_lex_state = 17},
  [1146] = {.lex_state = 0, .external_lex_state = 17},
  [1147] = {.lex_state = 0, .external_lex_state = 17},
  [1148] = {.lex_state = 0, .external_lex_state = 17},
  [1149] = {.lex_state = 0, .external_lex_state = 17},
  [1150] = {.lex_state = 0, .external_lex_state = 17},
  [1151] = {.lex_state = 0, .external_lex_state = 17},
  [1152] = {.lex_state = 0, .external_lex_state = 17},
  [1153] = {.lex_state = 0, .external_lex_state = 17},
  [1154] = {.lex_state = 0, .external_lex_state = 17},
  [1155] = {.lex_state = 0, .external_lex_state = 17},
  [1156] = {.lex_state = 0, .external_lex_state = 17},
  [1157] = {.lex_state = 0, .external_lex_state = 17},
  [1158] = {.lex_state = 0, .external_lex_state = 17},
  [1159] = {.lex_state = 0, .external_lex_state = 17},
  [1160] = {.lex_state = 0, .external_lex_state = 17},
  [1161] = {.lex_state = 0, .external_lex_state = 17},
  [1162] = {.lex_state = 0, .external_lex_state = 17},
  [1163] = {.lex_state = 0, .external_lex_state = 17},
  [1164] = {.lex_state = 0, .external_lex_state = 17},
  [1165] = {.lex_state = 0, .external_lex_state = 17},
  [1166] = {.lex_state = 0, .external_lex_state = 17},
  [1167] = {.lex_state = 0, .external_lex_state = 17},
  [1168] = {.lex_state = 0, .external_lex_state = 17},
  [1169] = {.lex_state = 0, .external_lex_state = 17},
  [1170] = {.lex_state = 0, .external_lex_state = 17},
  [1171] = {.lex_state = 0, .external_lex_state = 17},
  [1172] = {.lex_state = 0, .external_lex_state = 17},
  [1173] = {.lex_state = 0, .external_lex_state = 17},
  [1174] = {.lex_state = 0, .external_lex_state = 17},
  [1175] = {.lex_state = 0, .external_lex_state = 17},
  [1176] = {.lex_state = 0, .external_lex_state = 17},
  [1177] = {.lex_state = 0, .external_lex_state = 17},
  [1178] = {.lex_state = 0, .external_lex_state = 17},
  [1179] = {.lex_state = 0, .external_lex_state = 17},
  [1180] = {.lex_state = 0, .external_lex_state = 17},
  [1181] = {.lex_state = 0, .external_lex_state = 17},
  [1182] = {.lex_state = 0, .external_lex_state = 17},
  [1183] = {.lex_state = 0, .external_lex_state = 17},
  [1184] = {.lex_state = 0, .external_lex_state = 17},
  [1185] = {.lex_state = 0, .external_lex_state = 17},
  [1186] = {.lex_state = 0, .external_lex_state = 17},
  [1187] = {.lex_state = 0, .external_lex_state = 17},
  [1188] = {.lex_state = 0, .external_lex_state = 17},
  [1189] = {.lex_state = 0, .external_lex_state = 17},
  [1190] = {.lex_state = 0, .external_lex_state = 17},
  [1191] = {.lex_state = 0, .external_lex_state = 17},
  [1192] = {.lex_state = 0, .external_lex_state = 17},
  [1193] = {.lex_state = 0, .external_lex_state = 17},
  [1194] = {.lex_state = 0, .external_lex_state = 17},
  [1195] = {.lex_state = 0, .external_lex_state = 17},
  [1196] = {.lex_state = 0, .external_lex_state = 17},
  [1197] = {.lex_state = 0, .external_lex_state = 17},
  [1198] = {.lex_state = 0, .external_lex_state = 17},
  [1199] = {.lex_state = 0, .external_lex_state = 17},
  [1200] = {.lex_state = 0, .external_lex_state = 17},
  [1201] = {.lex_state = 0, .external_lex_state = 17},
  [1202] = {.lex_state = 0, .external_lex_state = 17},
  [1203] = {.lex_state = 0, .external_lex_state = 17},
  [1204] = {.lex_state = 0, .external_lex_state = 17},
  [1205] = {.lex_state = 0, .external_lex_state = 17},
  [1206] = {.lex_state = 0, .external_lex_state = 17},
  [1207] = {.lex_state = 0, .external_lex_state = 17},
  [1208] = {.lex_state = 0, .external_lex_state = 17},
  [1209] = {.lex_state = 0, .external_lex_state = 17},
  [1210] = {.lex_state = 0, .external_lex_state = 17},
  [1211] = {.lex_state = 0, .external_lex_state = 17},
  [1212] = {.lex_state = 0, .external_lex_state = 17},
  [1213] = {.lex_state = 0, .external_lex_state = 17},
  [1214] = {.lex_state = 0, .external_lex_state = 17},
  [1215] = {.lex_state = 0, .external_lex_state = 17},
  [1216] = {.lex_state = 0, .external_lex_state = 17},
  [1217] = {.lex_state = 0, .external_lex_state = 17},
  [1218] = {.lex_state = 0, .external_lex_state = 17},
  [1219] = {.lex_state = 0, .external_lex_state = 17},
  [1220] = {.lex_state = 0, .external_lex_state = 17},
  [1221] = {.lex_state = 0, .external_lex_state = 17},
  [1222] = {.lex_state = 0, .external_lex_state = 17},
  [1223] = {.lex_state = 0, .external_lex_state = 17},
  [1224] = {.lex_state = 0, .external_lex_state = 17},
  [1225] = {.lex_state = 0, .external_lex_state = 17},
  [1226] = {.lex_state = 0, .external_lex_state = 17},
  [1227] = {.lex_state = 0, .external_lex_state = 17},
  [1228] = {.lex_state = 0, .external_lex_state = 17},
  [1229] = {.lex_state = 0, .external_lex_state = 17},
  [1230] = {.lex_state = 0, .external_lex_state = 17},
  [1231] = {.lex_state = 0, .external_lex_state = 17},
  [1232] = {.lex_state = 0, .external_lex_state = 17},
  [1233] = {.lex_state = 0, .external_lex_state = 17},
  [1234] = {.lex_state = 0, .external_lex_state = 17},
  [1235] = {.lex_state = 0, .external_lex_state = 17},
  [1236] = {.lex_state = 0, .external_lex_state = 17},
  [1237] = {.lex_state = 0, .external_lex_state = 17},
  [1238] = {.lex_state = 0, .external_lex_state = 17},
  [1239] = {.lex_state = 0, .external_lex_state = 17},
  [1240] = {.lex_state = 0, .external_lex_state = 17},
  [1241] = {.lex_state = 0, .external_lex_state = 17},
  [1242] = {.lex_state = 0, .external_lex_state = 17},
  [1243] = {.lex_state = 0, .external_lex_state = 17},
  [1244] = {.lex_state = 0, .external_lex_state = 17},
  [1245] = {.lex_state = 0, .external_lex_state = 17},
  [1246] = {.lex_state = 0, .external_lex_state = 17},
  [1247] = {.lex_state = 0, .external_lex_state = 17},
  [1248] = {.lex_state = 0, .external_lex_state = 17},
  [1249] = {.lex_state = 0, .external_lex_state = 17},
  [1250] = {.lex_state = 0, .external_lex_state = 17},
  [1251] = {.lex_state = 0, .external_lex_state = 17},
  [1252] = {.lex_state = 0, .external_lex_state = 17},
  [1253] = {.lex_state = 0, .external_lex_state = 17},
  [1254] = {.lex_state = 0, .external_lex_state = 17},
  [1255] = {.lex_state = 0, .external_lex_state = 17},
  [1256] = {.lex_state = 0, .external_lex_state = 17},
  [1257] = {.lex_state = 0, .external_lex_state = 17},
  [1258] = {.lex_state = 0, .external_lex_state = 17},
  [1259] = {.lex_state = 0, .external_lex_state = 17},
  [1260] = {.lex_state = 0, .external_lex_state = 17},
  [1261] = {.lex_state = 0, .external_lex_state = 17},
  [1262] = {.lex_state = 0, .external_lex_state = 17},
  [1263] = {.lex_state = 0, .external_lex_state = 17},
  [1264] = {.lex_state = 0, .external_lex_state = 17},
  [1265] = {.lex_state = 0, .external_lex_state = 17},
  [1266] = {.lex_state = 0, .external_lex_state = 17},
  [1267] = {.lex_state = 0, .external_lex_state = 17},
  [1268] = {.lex_state = 0, .external_lex_state = 17},
  [1269] = {.lex_state = 0, .external_lex_state = 17},
  [1270] = {.lex_state = 0, .external_lex_state = 17},
  [1271] = {.lex_state = 0, .external_lex_state = 17},
  [1272] = {.lex_state = 0, .external_lex_state = 17},
  [1273] = {.lex_state = 0, .external_lex_state = 17},
  [1274] = {.lex_state = 0, .external_lex_state = 17},
  [1275] = {.lex_state = 0, .external_lex_state = 17},
  [1276] = {.lex_state = 0, .external_lex_state = 17},
  [1277] = {.lex_state = 0, .external_lex_state = 17},
  [1278] = {.lex_state = 0, .external_lex_state = 17},
  [1279] = {.lex_state = 0, .external_lex_state = 17},
  [1280] = {.lex_state = 0, .external_lex_state = 17},
  [1281] = {.lex_state = 0, .external_lex_state = 17},
  [1282] = {.lex_state = 0, .external_lex_state = 17},
  [1283] = {.lex_state = 0, .external_lex_state = 17},
  [1284] = {.lex_state = 0, .external_lex_state = 17},
  [1285] = {.lex_state = 0, .external_lex_state = 17},
  [1286] = {.lex_state = 0, .external_lex_state = 17},
  [1287] = {.lex_state = 0, .external_lex_state = 17},
  [1288] = {.lex_state = 0, .external_lex_state = 17},
  [1289] = {.lex_state = 0, .external_lex_state = 17},
  [1290] = {.lex_state = 0, .external_lex_state = 17},
  [1291] = {.lex_state = 0, .external_lex_state = 17},
  [1292] = {.lex_state = 0, .external_lex_state = 17},
  [1293] = {.lex_state = 0, .external_lex_state = 17},
  [1294] = {.lex_state = 0, .external_lex_state = 17},
  [1295] = {.lex_state = 0, .external_lex_state = 17},
  [1296] = {.lex_state = 0, .external_lex_state = 17},
  [1297] = {.lex_state = 0, .external_lex_state = 17},
  [1298] = {.lex_state = 0, .external_lex_state = 17},
  [1299] = {.lex_state = 0, .external_lex_state = 17},
  [1300] = {.lex_state = 0, .external_lex_state = 17},
  [1301] = {.lex_state = 0, .external_lex_state = 17},
  [1302] = {.lex_state = 0, .external_lex_state = 17},
  [1303] = {.lex_state = 0, .external_lex_state = 17},
  [1304] = {.lex_state = 0, .external_lex_state = 17},
  [1305] = {.lex_state = 0, .external_lex_state = 17},
  [1306] = {.lex_state = 0, .external_lex_state = 17},
  [1307] = {.lex_state = 0, .external_lex_state = 17},
  [1308] = {.lex_state = 0, .external_lex_state = 17},
  [1309] = {.lex_state = 0, .external_lex_state = 17},
  [1310] = {.lex_state = 0, .external_lex_state = 17},
  [1311] = {.lex_state = 0, .external_lex_state = 17},
  [1312] = {.lex_state = 0, .external_lex_state = 17},
  [1313] = {.lex_state = 0, .external_lex_state = 17},
  [1314] = {.lex_state = 0, .external_lex_state = 17},
  [1315] = {.lex_state = 0, .external_lex_state = 17},
  [1316] = {.lex_state = 0, .external_lex_state = 17},
  [1317] = {.lex_state = 0, .external_lex_state = 17},
  [1318] = {.lex_state = 0, .external_lex_state = 17},
  [1319] = {.lex_state = 0, .external_lex_state = 17},
  [1320] = {.lex_state = 0, .external_lex_state = 17},
  [1321] = {.lex_state = 0, .external_lex_state = 17},
  [1322] = {.lex_state = 0, .external_lex_state = 17},
  [1323] = {.lex_state = 0, .external_lex_state = 17},
  [1324] = {.lex_state = 0, .external_lex_state = 17},
  [1325] = {.lex_state = 0, .external_lex_state = 17},
  [1326] = {.lex_state = 0, .external_lex_state = 17},
  [1327] = {.lex_state = 0, .external_lex_state = 17},
  [1328] = {.lex_state = 0, .external_lex_state = 17},
  [1329] = {.lex_state = 0, .external_lex_state = 17},
  [1330] = {.lex_state = 0, .external_lex_state = 17},
  [1331] = {.lex_state = 0, .external_lex_state = 17},
  [1332] = {.lex_state = 0, .external_lex_state = 17},
  [1333] = {.lex_state = 0, .external_lex_state = 17},
  [1334] = {.lex_state = 0, .external_lex_state = 17},
  [1335] = {.lex_state = 0, .external_lex_state = 17},
  [1336] = {.lex_state = 0, .external_lex_state = 17},
  [1337] = {.lex_state = 0, .external_lex_state = 17},
  [1338] = {.lex_state = 0, .external_lex_state = 17},
  [1339] = {.lex_state = 0, .external_lex_state = 17},
  [1340] = {.lex_state = 0, .external_lex_state = 17},
  [1341] = {.lex_state = 0, .external_lex_state = 17},
  [1342] = {.lex_state = 0, .external_lex_state = 17},
  [1343] = {.lex_state = 0, .external_lex_state = 17},
  [1344] = {.lex_state = 0, .external_lex_state = 17},
  [1345] = {.lex_state = 0, .external_lex_state = 17},
  [1346] = {.lex_state = 0, .external_lex_state = 17},
  [1347] = {.lex_state = 0, .external_lex_state = 17},
  [1348] = {.lex_state = 0, .external_lex_state = 17},
  [1349] = {.lex_state = 0, .external_lex_state = 17},
  [1350] = {.lex_state = 0, .external_lex_state = 17},
  [1351] = {.lex_state = 0, .external_lex_state = 17},
  [1352] = {.lex_state = 0, .external_lex_state = 17},
  [1353] = {.lex_state = 0, .external_lex_state = 17},
  [1354] = {.lex_state = 0, .external_lex_state = 17},
  [1355] = {.lex_state = 0, .external_lex_state = 17},
  [1356] = {.lex_state = 0, .external_lex_state = 17},
  [1357] = {.lex_state = 0, .external_lex_state = 17},
  [1358] = {.lex_state = 0, .external_lex_state = 17},
  [1359] = {.lex_state = 0, .external_lex_state = 17},
  [1360] = {.lex_state = 0, .external_lex_state = 17},
  [1361] = {.lex_state = 0, .external_lex_state = 17},
  [1362] = {.lex_state = 0, .external_lex_state = 17},
  [1363] = {.lex_state = 0, .external_lex_state = 17},
  [1364] = {.lex_state = 0, .external_lex_state = 17},
  [1365] = {.lex_state = 0, .external_lex_state = 17},
  [1366] = {.lex_state = 0, .external_lex_state = 17},
  [1367] = {.lex_state = 0, .external_lex_state = 17},
  [1368] = {.lex_state = 0, .external_lex_state = 17},
  [1369] = {.lex_state = 0, .external_lex_state = 17},
  [1370] = {.lex_state = 0, .external_lex_state = 17},
  [1371] = {.lex_state = 0, .external_lex_state = 17},
  [1372] = {.lex_state = 0, .external_lex_state = 17},
  [1373] = {.lex_state = 0, .external_lex_state = 17},
  [1374] = {.lex_state = 0, .external_lex_state = 17},
  [1375] = {.lex_state = 0, .external_lex_state = 17},
  [1376] = {.lex_state = 0, .external_lex_state = 17},
  [1377] = {.lex_state = 0, .external_lex_state = 17},
  [1378] = {.lex_state = 0, .external_lex_state = 17},
  [1379] = {.lex_state = 0, .external_lex_state = 17},
  [1380] = {.lex_state = 0, .external_lex_state = 17},
  [1381] = {.lex_state = 0, .external_lex_state = 17},
  [1382] = {.lex_state = 0, .external_lex_state = 17},
  [1383] = {.lex_state = 0, .external_lex_state = 17},
  [1384] = {.lex_state = 0, .external_lex_state = 17},
  [1385] = {.lex_state = 0, .external_lex_state = 17},
  [1386] = {.lex_state = 0, .external_lex_state = 17},
  [1387] = {.lex_state = 0, .external_lex_state = 17},
  [1388] = {.lex_state = 0, .external_lex_state = 17},
  [1389] = {.lex_state = 0, .external_lex_state = 17},
  [1390] = {.lex_state = 0, .external_lex_state = 17},
  [1391] = {.lex_state = 0, .external_lex_state = 17},
  [1392] = {.lex_state = 0, .external_lex_state = 17},
  [1393] = {.lex_state = 0, .external_lex_state = 17},
  [1394] = {.lex_state = 0, .external_lex_state = 17},
  [1395] = {.lex_state = 0, .external_lex_state = 17},
  [1396] = {.lex_state = 0, .external_lex_state = 17},
  [1397] = {.lex_state = 0, .external_lex_state = 17},
  [1398] = {.lex_state = 0, .external_lex_state = 17},
  [1399] = {.lex_state = 0, .external_lex_state = 17},
  [1400] = {.lex_state = 0, .external_lex_state = 17},
  [1401] = {.lex_state = 0, .external_lex_state = 17},
  [1402] = {.lex_state = 0, .external_lex_state = 17},
  [1403] = {.lex_state = 0, .external_lex_state = 17},
  [1404] = {.lex_state = 0, .external_lex_state = 17},
  [1405] = {.lex_state = 0, .external_lex_state = 17},
  [1406] = {.lex_state = 0, .external_lex_state = 17},
  [1407] = {.lex_state = 0, .external_lex_state = 17},
  [1408] = {.lex_state = 0, .external_lex_state = 17},
  [1409] = {.lex_state = 0, .external_lex_state = 17},
  [1410] = {.lex_state = 0, .external_lex_state = 17},
  [1411] = {.lex_state = 0, .external_lex_state = 17},
  [1412] = {.lex_state = 0, .external_lex_state = 17},
  [1413] = {.lex_state = 0, .external_lex_state = 17},
  [1414] = {.lex_state = 0, .external_lex_state = 17},
  [1415] = {.lex_state = 0, .external_lex_state = 17},
  [1416] = {.lex_state = 0, .external_lex_state = 17},
  [1417] = {.lex_state = 0, .external_lex_state = 17},
  [1418] = {.lex_state = 0, .external_lex_state = 17},
  [1419] = {.lex_state = 0, .external_lex_state = 17},
  [1420] = {.lex_state = 0, .external_lex_state = 17},
  [1421] = {.lex_state = 0, .external_lex_state = 17},
  [1422] = {.lex_state = 0, .external_lex_state = 17},
  [1423] = {.lex_state = 0, .external_lex_state = 17},
  [1424] = {.lex_state = 0, .external_lex_state = 17},
  [1425] = {.lex_state = 0, .external_lex_state = 17},
  [1426] = {.lex_state = 0, .external_lex_state = 17},
  [1427] = {.lex_state = 0, .external_lex_state = 17},
  [1428] = {.lex_state = 0, .external_lex_state = 17},
  [1429] = {.lex_state = 0, .external_lex_state = 17},
  [1430] = {.lex_state = 0, .external_lex_state = 17},
  [1431] = {.lex_state = 0, .external_lex_state = 17},
  [1432] = {.lex_state = 0, .external_lex_state = 17},
  [1433] = {.lex_state = 0, .external_lex_state = 17},
  [1434] = {.lex_state = 0, .external_lex_state = 17},
  [1435] = {.lex_state = 0, .external_lex_state = 17},
  [1436] = {.lex_state = 0, .external_lex_state = 17},
  [1437] = {.lex_state = 0, .external_lex_state = 17},
  [1438] = {.lex_state = 0, .external_lex_state = 17},
  [1439] = {.lex_state = 0, .external_lex_state = 17},
  [1440] = {.lex_state = 0, .external_lex_state = 17},
  [1441] = {.lex_state = 0, .external_lex_state = 17},
  [1442] = {.lex_state = 0, .external_lex_state = 17},
  [1443] = {.lex_state = 0, .external_lex_state = 17},
  [1444] = {.lex_state = 0, .external_lex_state = 17},
  [1445] = {.lex_state = 0, .external_lex_state = 17},
  [1446] = {.lex_state = 0, .external_lex_state = 17},
  [1447] = {.lex_state = 0, .external_lex_state = 17},
  [1448] = {.lex_state = 0, .external_lex_state = 17},
  [1449] = {.lex_state = 0, .external_lex_state = 17},
  [1450] = {.lex_state = 0, .external_lex_state = 17},
  [1451] = {.lex_state = 0, .external_lex_state = 17},
  [1452] = {.lex_state = 0, .external_lex_state = 17},
  [1453] = {.lex_state = 0, .external_lex_state = 17},
  [1454] = {.lex_state = 0, .external_lex_state = 17},
  [1455] = {.lex_state = 0, .external_lex_state = 17},
  [1456] = {.lex_state = 0, .external_lex_state = 17},
  [1457] = {.lex_state = 0, .external_lex_state = 17},
  [1458] = {.lex_state = 0, .external_lex_state = 17},
  [1459] = {.lex_state = 0, .external_lex_state = 17},
  [1460] = {.lex_state = 0, .external_lex_state = 17},
  [1461] = {.lex_state = 0, .external_lex_state = 17},
  [1462] = {.lex_state = 0, .external_lex_state = 17},
  [1463] = {.lex_state = 0, .external_lex_state = 17},
  [1464] = {.lex_state = 0, .external_lex_state = 17},
  [1465] = {.lex_state = 0, .external_lex_state = 17},
  [1466] = {.lex_state = 0, .external_lex_state = 17},
  [1467] = {.lex_state = 0, .external_lex_state = 17},
  [1468] = {.lex_state = 0, .external_lex_state = 17},
  [1469] = {.lex_state = 0, .external_lex_state = 17},
  [1470] = {.lex_state = 0, .external_lex_state = 17},
  [1471] = {.lex_state = 0, .external_lex_state = 17},
  [1472] = {.lex_state = 0, .external_lex_state = 17},
  [1473] = {.lex_state = 0, .external_lex_state = 17},
  [1474] = {.lex_state = 0, .external_lex_state = 17},
  [1475] = {.lex_state = 0, .external_lex_state = 17},
  [1476] = {.lex_state = 0, .external_lex_state = 17},
  [1477] = {.lex_state = 0, .external_lex_state = 17},
  [1478] = {.lex_state = 0, .external_lex_state = 17},
  [1479] = {.lex_state = 0, .external_lex_state = 17},
  [1480] = {.lex_state = 0, .external_lex_state = 17},
  [1481] = {.lex_state = 0, .external_lex_state = 17},
  [1482] = {.lex_state = 0, .external_lex_state = 17},
  [1483] = {.lex_state = 0, .external_lex_state = 17},
  [1484] = {.lex_state = 0, .external_lex_state = 17},
  [1485] = {.lex_state = 0, .external_lex_state = 17},
  [1486] = {.lex_state = 0, .external_lex_state = 17},
  [1487] = {.lex_state = 0, .external_lex_state = 17},
  [1488] = {.lex_state = 0, .external_lex_state = 17},
  [1489] = {.lex_state = 0, .external_lex_state = 17},
  [1490] = {.lex_state = 0, .external_lex_state = 17},
  [1491] = {.lex_state = 0, .external_lex_state = 17},
  [1492] = {.lex_state = 0, .external_lex_state = 17},
  [1493] = {.lex_state = 0, .external_lex_state = 17},
  [1494] = {.lex_state = 0, .external_lex_state = 17},
  [1495] = {.lex_state = 0, .external_lex_state = 17},
  [1496] = {.lex_state = 0, .external_lex_state = 17},
  [1497] = {.lex_state = 0, .external_lex_state = 17},
  [1498] = {.lex_state = 0, .external_lex_state = 17},
  [1499] = {.lex_state = 0, .external_lex_state = 17},
  [1500] = {.lex_state = 0, .external_lex_state = 17},
  [1501] = {.lex_state = 0, .external_lex_state = 17},
  [1502] = {.lex_state = 0, .external_lex_state = 17},
  [1503] = {.lex_state = 0, .external_lex_state = 17},
  [1504] = {.lex_state = 0, .external_lex_state = 17},
  [1505] = {.lex_state = 0, .external_lex_state = 17},
  [1506] = {.lex_state = 0, .external_lex_state = 17},
  [1507] = {.lex_state = 0, .external_lex_state = 17},
  [1508] = {.lex_state = 0, .external_lex_state = 17},
  [1509] = {.lex_state = 0, .external_lex_state = 17},
  [1510] = {.lex_state = 0, .external_lex_state = 17},
  [1511] = {.lex_state = 0, .external_lex_state = 17},
  [1512] = {.lex_state = 0, .external_lex_state = 17},
  [1513] = {.lex_state = 0, .external_lex_state = 17},
  [1514] = {.lex_state = 0, .external_lex_state = 17},
  [1515] = {.lex_state = 0, .external_lex_state = 17},
  [1516] = {.lex_state = 0, .external_lex_state = 17},
  [1517] = {.lex_state = 0, .external_lex_state = 17},
  [1518] = {.lex_state = 0, .external_lex_state = 17},
  [1519] = {.lex_state = 0, .external_lex_state = 17},
  [1520] = {.lex_state = 0, .external_lex_state = 17},
  [1521] = {.lex_state = 0, .external_lex_state = 17},
  [1522] = {.lex_state = 0, .external_lex_state = 17},
  [1523] = {.lex_state = 0, .external_lex_state = 17},
  [1524] = {.lex_state = 0, .external_lex_state = 17},
  [1525] = {.lex_state = 0, .external_lex_state = 17},
  [1526] = {.lex_state = 0, .external_lex_state = 17},
  [1527] = {.lex_state = 0, .external_lex_state = 17},
  [1528] = {.lex_state = 0, .external_lex_state = 17},
  [1529] = {.lex_state = 0, .external_lex_state = 17},
  [1530] = {.lex_state = 0, .external_lex_state = 17},
  [1531] = {.lex_state = 0, .external_lex_state = 17},
  [1532] = {.lex_state = 0, .external_lex_state = 17},
  [1533] = {.lex_state = 0, .external_lex_state = 17},
  [1534] = {.lex_state = 0, .external_lex_state = 17},
  [1535] = {.lex_state = 0, .external_lex_state = 17},
  [1536] = {.lex_state = 0, .external_lex_state = 17},
  [1537] = {.lex_state = 0, .external_lex_state = 17},
  [1538] = {.lex_state = 0, .external_lex_state = 17},
  [1539] = {.lex_state = 0, .external_lex_state = 17},
  [1540] = {.lex_state = 0, .external_lex_state = 17},
  [1541] = {.lex_state = 0, .external_lex_state = 17},
  [1542] = {.lex_state = 0, .external_lex_state = 17},
  [1543] = {.lex_state = 0, .external_lex_state = 17},
  [1544] = {.lex_state = 0, .external_lex_state = 17},
  [1545] = {.lex_state = 0, .external_lex_state = 17},
  [1546] = {.lex_state = 0, .external_lex_state = 17},
  [1547] = {.lex_state = 0, .external_lex_state = 17},
  [1548] = {.lex_state = 0, .external_lex_state = 17},
  [1549] = {.lex_state = 0, .external_lex_state = 17},
  [1550] = {.lex_state = 0, .external_lex_state = 17},
  [1551] = {.lex_state = 0, .external_lex_state = 17},
  [1552] = {.lex_state = 0, .external_lex_state = 17},
  [1553] = {.lex_state = 0, .external_lex_state = 17},
  [1554] = {.lex_state = 0, .external_lex_state = 17},
  [1555] = {.lex_state = 0, .external_lex_state = 17},
  [1556] = {.lex_state = 0, .external_lex_state = 17},
  [1557] = {.lex_state = 0, .external_lex_state = 17},
  [1558] = {.lex_state = 0, .external_lex_state = 17},
  [1559] = {.lex_state = 0, .external_lex_state = 17},
  [1560] = {.lex_state = 0, .external_lex_state = 17},
  [1561] = {.lex_state = 0, .external_lex_state = 17},
  [1562] = {.lex_state = 0, .external_lex_state = 17},
  [1563] = {.lex_state = 0, .external_lex_state = 17},
  [1564] = {.lex_state = 0, .external_lex_state = 17},
  [1565] = {.lex_state = 0, .external_lex_state = 17},
  [1566] = {.lex_state = 0, .external_lex_state = 17},
  [1567] = {.lex_state = 0, .external_lex_state = 17},
  [1568] = {.lex_state = 0, .external_lex_state = 17},
  [1569] = {.lex_state = 0, .external_lex_state = 17},
  [1570] = {.lex_state = 0, .external_lex_state = 17},
  [1571] = {.lex_state = 0, .external_lex_state = 17},
  [1572] = {.lex_state = 0, .external_lex_state = 17},
  [1573] = {.lex_state = 0, .external_lex_state = 17},
  [1574] = {.lex_state = 0, .external_lex_state = 17},
  [1575] = {.lex_state = 0, .external_lex_state = 17},
  [1576] = {.lex_state = 0, .external_lex_state = 17},
  [1577] = {.lex_state = 0, .external_lex_state = 17},
  [1578] = {.lex_state = 0, .external_lex_state = 17},
  [1579] = {.lex_state = 0, .external_lex_state = 17},
  [1580] = {.lex_state = 0, .external_lex_state = 17},
  [1581] = {.lex_state = 0, .external_lex_state = 17},
  [1582] = {.lex_state = 0, .external_lex_state = 17},
  [1583] = {.lex_state = 0, .external_lex_state = 17},
  [1584] = {.lex_state = 0, .external_lex_state = 17},
  [1585] = {.lex_state = 0, .external_lex_state = 17},
  [1586] = {.lex_state = 0, .external_lex_state = 17},
  [1587] = {.lex_state = 0, .external_lex_state = 17},
  [1588] = {.lex_state = 0, .external_lex_state = 17},
  [1589] = {.lex_state = 0, .external_lex_state = 17},
  [1590] = {.lex_state = 0, .external_lex_state = 17},
  [1591] = {.lex_state = 0, .external_lex_state = 17},
  [1592] = {.lex_state = 0, .external_lex_state = 17},
  [1593] = {.lex_state = 0, .external_lex_state = 17},
  [1594] = {.lex_state = 0, .external_lex_state = 17},
  [1595] = {.lex_state = 0, .external_lex_state = 17},
  [1596] = {.lex_state = 0, .external_lex_state = 17},
  [1597] = {.lex_state = 0, .external_lex_state = 17},
  [1598] = {.lex_state = 0, .external_lex_state = 17},
  [1599] = {.lex_state = 0, .external_lex_state = 19},
  [1600] = {.lex_state = 0, .external_lex_state = 19},
  [1601] = {.lex_state = 0, .external_lex_state = 19},
  [1602] = {.lex_state = 0, .external_lex_state = 19},
  [1603] = {.lex_state = 0, .external_lex_state = 19},
  [1604] = {.lex_state = 0, .external_lex_state = 19},
  [1605] = {.lex_state = 0, .external_lex_state = 19},
  [1606] = {.lex_state = 0, .external_lex_state = 19},
  [1607] = {.lex_state = 0, .external_lex_state = 19},
  [1608] = {.lex_state = 0, .external_lex_state = 19},
  [1609] = {.lex_state = 0, .external_lex_state = 19},
  [1610] = {.lex_state = 0, .external_lex_state = 19},
  [1611] = {.lex_state = 0, .external_lex_state = 19},
  [1612] = {.lex_state = 0, .external_lex_state = 19},
  [1613] = {.lex_state = 0, .external_lex_state = 19},
  [1614] = {.lex_state = 0, .external_lex_state = 19},
  [1615] = {.lex_state = 0, .external_lex_state = 19},
  [1616] = {.lex_state = 0, .external_lex_state = 19},
  [1617] = {.lex_state = 0, .external_lex_state = 19},
  [1618] = {.lex_state = 0, .external_lex_state = 19},
  [1619] = {.lex_state = 0, .external_lex_state = 19},
  [1620] = {.lex_state = 0, .external_lex_state = 19},
  [1621] = {.lex_state = 0, .external_lex_state = 19},
  [1622] = {.lex_state = 0, .external_lex_state = 19},
  [1623] = {.lex_state = 0, .external_lex_state = 19},
  [1624] = {.lex_state = 0, .external_lex_state = 19},
  [1625] = {.lex_state = 0, .external_lex_state = 19},
  [1626] = {.lex_state = 0, .external_lex_state = 19},
  [1627] = {.lex_state = 0, .external_lex_state = 19},
  [1628] = {.lex_state = 0, .external_lex_state = 19},
  [1629] = {.lex_state = 0, .external_lex_state = 19},
  [1630] = {.lex_state = 0, .external_lex_state = 19},
  [1631] = {.lex_state = 0, .external_lex_state = 19},
  [1632] = {.lex_state = 0, .external_lex_state = 19},
  [1633] = {.lex_state = 0, .external_lex_state = 19},
  [1634] = {.lex_state = 0, .external_lex_state = 19},
  [1635] = {.lex_state = 0, .external_lex_state = 19},
  [1636] = {.lex_state = 0, .external_lex_state = 19},
  [1637] = {.lex_state = 0, .external_lex_state = 19},
  [1638] = {.lex_state = 0, .external_lex_state = 19},
  [1639] = {.lex_state = 0, .external_lex_state = 19},
  [1640] = {.lex_state = 0, .external_lex_state = 19},
  [1641] = {.lex_state = 0, .external_lex_state = 19},
  [1642] = {.lex_state = 0, .external_lex_state = 19},
  [1643] = {.lex_state = 0, .external_lex_state = 19},
  [1644] = {.lex_state = 0, .external_lex_state = 19},
  [1645] = {.lex_state = 0, .external_lex_state = 19},
  [1646] = {.lex_state = 0, .external_lex_state = 19},
  [1647] = {.lex_state = 0, .external_lex_state = 19},
  [1648] = {.lex_state = 0, .external_lex_state = 19},
  [1649] = {.lex_state = 0, .external_lex_state = 19},
  [1650] = {.lex_state = 0, .external_lex_state = 19},
  [1651] = {.lex_state = 0, .external_lex_state = 19},
  [1652] = {.lex_state = 0, .external_lex_state = 19},
  [1653] = {.lex_state = 0, .external_lex_state = 19},
  [1654] = {.lex_state = 0, .external_lex_state = 19},
  [1655] = {.lex_state = 0, .external_lex_state = 19},
  [1656] = {.lex_state = 0, .external_lex_state = 19},
  [1657] = {.lex_state = 0, .external_lex_state = 19},
  [1658] = {.lex_state = 0, .external_lex_state = 19},
  [1659] = {.lex_state = 0, .external_lex_state = 19},
  [1660] = {.lex_state = 0, .external_lex_state = 19},
  [1661] = {.lex_state = 0, .external_lex_state = 19},
  [1662] = {.lex_state = 0, .external_lex_state = 19},
  [1663] = {.lex_state = 0, .external_lex_state = 19},
  [1664] = {.lex_state = 0, .external_lex_state = 19},
  [1665] = {.lex_state = 0, .external_lex_state = 19},
  [1666] = {.lex_state = 0, .external_lex_state = 19},
  [1667] = {.lex_state = 0, .external_lex_state = 19},
  [1668] = {.lex_state = 0, .external_lex_state = 19},
  [1669] = {.lex_state = 0, .external_lex_state = 19},
  [1670] = {.lex_state = 0, .external_lex_state = 19},
  [1671] = {.lex_state = 0, .external_lex_state = 19},
  [1672] = {.lex_state = 0, .external_lex_state = 19},
  [1673] = {.lex_state = 0, .external_lex_state = 19},
  [1674] = {.lex_state = 0, .external_lex_state = 19},
  [1675] = {.lex_state = 0, .external_lex_state = 19},
  [1676] = {.lex_state = 0, .external_lex_state = 19},
  [1677] = {.lex_state = 0, .external_lex_state = 19},
  [1678] = {.lex_state = 0, .external_lex_state = 19},
  [1679] = {.lex_state = 0, .external_lex_state = 19},
  [1680] = {.lex_state = 0, .external_lex_state = 19},
  [1681] = {.lex_state = 0, .external_lex_state = 19},
  [1682] = {.lex_state = 0, .external_lex_state = 19},
  [1683] = {.lex_state = 0, .external_lex_state = 19},
  [1684] = {.lex_state = 0, .external_lex_state = 19},
  [1685] = {.lex_state = 0, .external_lex_state = 19},
  [1686] = {.lex_state = 0, .external_lex_state = 19},
  [1687] = {.lex_state = 0, .external_lex_state = 19},
  [1688] = {.lex_state = 0, .external_lex_state = 19},
  [1689] = {.lex_state = 0, .external_lex_state = 19},
  [1690] = {.lex_state = 0, .external_lex_state = 19},
  [1691] = {.lex_state = 0, .external_lex_state = 19},
  [1692] = {.lex_state = 0, .external_lex_state = 19},
  [1693] = {.lex_state = 0, .external_lex_state = 19},
  [1694] = {.lex_state = 0, .external_lex_state = 19},
  [1695] = {.lex_state = 0, .external_lex_state = 19},
  [1696] = {.lex_state = 0, .external_lex_state = 19},
  [1697] = {.lex_state = 0, .external_lex_state = 19},
  [1698] = {.lex_state = 0, .external_lex_state = 19},
  [1699] = {.lex_state = 0, .external_lex_state = 19},
  [1700] = {.lex_state = 0, .external_lex_state = 19},
  [1701] = {.lex_state = 0, .external_lex_state = 19},
  [1702] = {.lex_state = 0, .external_lex_state = 19},
  [1703] = {.lex_state = 0, .external_lex_state = 19},
  [1704] = {.lex_state = 0, .external_lex_state = 19},
  [1705] = {.lex_state = 0, .external_lex_state = 19},
  [1706] = {.lex_state = 0, .external_lex_state = 19},
  [1707] = {.lex_state = 0, .external_lex_state = 19},
  [1708] = {.lex_state = 0, .external_lex_state = 19},
  [1709] = {.lex_state = 0, .external_lex_state = 19},
  [1710] = {.lex_state = 0, .external_lex_state = 19},
  [1711] = {.lex_state = 0, .external_lex_state = 19},
  [1712] = {.lex_state = 0, .external_lex_state = 19},
  [1713] = {.lex_state = 0, .external_lex_state = 19},
  [1714] = {.lex_state = 0, .external_lex_state = 19},
  [1715] = {.lex_state = 0, .external_lex_state = 19},
  [1716] = {.lex_state = 0, .external_lex_state = 19},
  [1717] = {.lex_state = 0, .external_lex_state = 19},
  [1718] = {.lex_state = 0, .external_lex_state = 19},
  [1719] = {.lex_state = 1, .external_lex_state = 20},
  [1720] = {.lex_state = 1, .external_lex_state = 20},
  [1721] = {.lex_state = 1, .external_lex_state = 21},
  [1722] = {.lex_state = 1, .external_lex_state = 21},
  [1723] = {.lex_state = 1, .external_lex_state = 22},
  [1724] = {.lex_state = 0, .external_lex_state = 23},
  [1725] = {.lex_state = 0, .external_lex_state = 23},
  [1726] = {.lex_state = 0, .external_lex_state = 23},
  [1727] = {.lex_state = 0, .external_lex_state = 23},
  [1728] = {.lex_state = 0, .external_lex_state = 23},
  [1729] = {.lex_state = 1, .external_lex_state = 24},
  [1730] = {.lex_state = 0, .external_lex_state = 23},
  [1731] = {.lex_state = 0, .external_lex_state = 23},
  [1732] = {.lex_state = 0, .external_lex_state = 23},
  [1733] = {.lex_state = 0, .external_lex_state = 23},
  [1734] = {.lex_state = 0, .external_lex_state = 23},
  [1735] = {.lex_state = 0, .external_lex_state = 23},
  [1736] = {.lex_state = 0, .external_lex_state = 23},
  [1737] = {.lex_state = 0, .external_lex_state = 23},
  [1738] = {.lex_state = 0, .external_lex_state = 23},
  [1739] = {.lex_state = 0, .external_lex_state = 23},
  [1740] = {.lex_state = 0, .external_lex_state = 23},
  [1741] = {.lex_state = 0, .external_lex_state = 23},
  [1742] = {.lex_state = 0, .external_lex_state = 23},
  [1743] = {.lex_state = 0, .external_lex_state = 23},
  [1744] = {.lex_state = 0, .external_lex_state = 23},
  [1745] = {.lex_state = 0, .external_lex_state = 23},
  [1746] = {.lex_state = 0, .external_lex_state = 23},
  [1747] = {.lex_state = 0, .external_lex_state = 23},
  [1748] = {.lex_state = 0, .external_lex_state = 23},
  [1749] = {.lex_state = 1, .external_lex_state = 20},
  [1750] = {.lex_state = 0, .external_lex_state = 23},
  [1751] = {.lex_state = 0, .external_lex_state = 23},
  [1752] = {.lex_state = 0, .external_lex_state = 23},
  [1753] = {.lex_state = 0, .external_lex_state = 23},
  [1754] = {.lex_state = 0, .external_lex_state = 23},
  [1755] = {.lex_state = 0, .external_lex_state = 23},
  [1756] = {.lex_state = 0, .external_lex_state = 23},
  [1757] = {.lex_state = 0, .external_lex_state = 23},
  [1758] = {.lex_state = 0, .external_lex_state = 23},
  [1759] = {.lex_state = 0, .external_lex_state = 23},
  [1760] = {.lex_state = 0, .external_lex_state = 23},
  [1761] = {.lex_state = 0, .external_lex_state = 23},
  [1762] = {.lex_state = 0, .external_lex_state = 23},
  [1763] = {.lex_state = 0, .external_lex_state = 23},
  [1764] = {.lex_state = 0, .external_lex_state = 23},
  [1765] = {.lex_state = 0, .external_lex_state = 23},
  [1766] = {.lex_state = 0, .external_lex_state = 23},
  [1767] = {.lex_state = 0, .external_lex_state = 23},
  [1768] = {.lex_state = 0, .external_lex_state = 23},
  [1769] = {.lex_state = 0, .external_lex_state = 23},
  [1770] = {.lex_state = 0, .external_lex_state = 23},
  [1771] = {.lex_state = 0, .external_lex_state = 23},
  [1772] = {.lex_state = 0, .external_lex_state = 23},
  [1773] = {.lex_state = 0, .external_lex_state = 23},
  [1774] = {.lex_state = 0, .external_lex_state = 23},
  [1775] = {.lex_state = 0, .external_lex_state = 23},
  [1776] = {.lex_state = 0, .external_lex_state = 23},
  [1777] = {.lex_state = 0, .external_lex_state = 23},
  [1778] = {.lex_state = 0, .external_lex_state = 23},
  [1779] = {.lex_state = 0, .external_lex_state = 23},
  [1780] = {.lex_state = 0, .external_lex_state = 23},
  [1781] = {.lex_state = 0, .external_lex_state = 23},
  [1782] = {.lex_state = 0, .external_lex_state = 23},
  [1783] = {.lex_state = 0, .external_lex_state = 23},
  [1784] = {.lex_state = 0, .external_lex_state = 25},
  [1785] = {.lex_state = 0, .external_lex_state = 25},
  [1786] = {.lex_state = 0, .external_lex_state = 25},
  [1787] = {.lex_state = 0, .external_lex_state = 25},
  [1788] = {.lex_state = 0, .external_lex_state = 25},
  [1789] = {.lex_state = 0, .external_lex_state = 25},
  [1790] = {.lex_state = 0, .external_lex_state = 25},
  [1791] = {.lex_state = 0, .external_lex_state = 25},
  [1792] = {.lex_state = 0, .external_lex_state = 25},
  [1793] = {.lex_state = 0, .external_lex_state = 25},
  [1794] = {.lex_state = 0, .external_lex_state = 25},
  [1795] = {.lex_state = 0, .external_lex_state = 25},
  [1796] = {.lex_state = 0, .external_lex_state = 25},
  [1797] = {.lex_state = 0, .external_lex_state = 25},
  [1798] = {.lex_state = 0, .external_lex_state = 25},
  [1799] = {.lex_state = 0, .external_lex_state = 25},
  [1800] = {.lex_state = 0, .external_lex_state = 25},
  [1801] = {.lex_state = 0, .external_lex_state = 25},
  [1802] = {.lex_state = 0, .external_lex_state = 25},
  [1803] = {.lex_state = 0, .external_lex_state = 25},
  [1804] = {.lex_state = 0, .external_lex_state = 25},
  [1805] = {.lex_state = 0, .external_lex_state = 25},
  [1806] = {.lex_state = 0, .external_lex_state = 25},
  [1807] = {.lex_state = 0, .external_lex_state = 25},
  [1808] = {.lex_state = 0, .external_lex_state = 25},
  [1809] = {.lex_state = 0, .external_lex_state = 25},
  [1810] = {.lex_state = 0, .external_lex_state = 25},
  [1811] = {.lex_state = 0, .external_lex_state = 25},
  [1812] = {.lex_state = 0, .external_lex_state = 25},
  [1813] = {.lex_state = 0, .external_lex_state = 25},
  [1814] = {.lex_state = 0, .external_lex_state = 25},
  [1815] = {.lex_state = 0, .external_lex_state = 25},
  [1816] = {.lex_state = 0, .external_lex_state = 25},
  [1817] = {.lex_state = 0, .external_lex_state = 25},
  [1818] = {.lex_state = 0, .external_lex_state = 25},
  [1819] = {.lex_state = 0, .external_lex_state = 25},
  [1820] = {.lex_state = 0, .external_lex_state = 25},
  [1821] = {.lex_state = 0, .external_lex_state = 25},
  [1822] = {.lex_state = 0, .external_lex_state = 25},
  [1823] = {.lex_state = 0, .external_lex_state = 25},
  [1824] = {.lex_state = 0, .external_lex_state = 25},
  [1825] = {.lex_state = 0, .external_lex_state = 25},
  [1826] = {.lex_state = 0, .external_lex_state = 25},
  [1827] = {.lex_state = 0, .external_lex_state = 25},
  [1828] = {.lex_state = 0, .external_lex_state = 25},
  [1829] = {.lex_state = 0, .external_lex_state = 25},
  [1830] = {.lex_state = 0, .external_lex_state = 25},
  [1831] = {.lex_state = 0, .external_lex_state = 25},
  [1832] = {.lex_state = 0, .external_lex_state = 25},
  [1833] = {.lex_state = 0, .external_lex_state = 25},
  [1834] = {.lex_state = 0, .external_lex_state = 25},
  [1835] = {.lex_state = 0, .external_lex_state = 25},
  [1836] = {.lex_state = 0, .external_lex_state = 25},
  [1837] = {.lex_state = 0, .external_lex_state = 25},
  [1838] = {.lex_state = 0, .external_lex_state = 25},
  [1839] = {.lex_state = 0, .external_lex_state = 25},
  [1840] = {.lex_state = 0, .external_lex_state = 25},
  [1841] = {.lex_state = 0, .external_lex_state = 25},
  [1842] = {.lex_state = 0, .external_lex_state = 25},
  [1843] = {.lex_state = 0, .external_lex_state = 25},
  [1844] = {.lex_state = 0, .external_lex_state = 25},
  [1845] = {.lex_state = 0, .external_lex_state = 25},
  [1846] = {.lex_state = 0, .external_lex_state = 25},
  [1847] = {.lex_state = 0, .external_lex_state = 25},
  [1848] = {.lex_state = 0, .external_lex_state = 25},
  [1849] = {.lex_state = 0, .external_lex_state = 25},
  [1850] = {.lex_state = 0, .external_lex_state = 25},
  [1851] = {.lex_state = 0, .external_lex_state = 25},
  [1852] = {.lex_state = 0, .external_lex_state = 25},
  [1853] = {.lex_state = 0, .external_lex_state = 25},
  [1854] = {.lex_state = 0, .external_lex_state = 25},
  [1855] = {.lex_state = 0, .external_lex_state = 25},
  [1856] = {.lex_state = 0, .external_lex_state = 25},
  [1857] = {.lex_state = 0, .external_lex_state = 25},
  [1858] = {.lex_state = 0, .external_lex_state = 25},
  [1859] = {.lex_state = 0, .external_lex_state = 25},
  [1860] = {.lex_state = 0, .external_lex_state = 25},
  [1861] = {.lex_state = 0, .external_lex_state = 25},
  [1862] = {.lex_state = 0, .external_lex_state = 25},
  [1863] = {.lex_state = 0, .external_lex_state = 25},
  [1864] = {.lex_state = 0, .external_lex_state = 25},
  [1865] = {.lex_state = 0, .external_lex_state = 25},
  [1866] = {.lex_state = 0, .external_lex_state = 25},
  [1867] = {.lex_state = 0, .external_lex_state = 25},
  [1868] = {.lex_state = 0, .external_lex_state = 25},
  [1869] = {.lex_state = 0, .external_lex_state = 25},
  [1870] = {.lex_state = 0, .external_lex_state = 25},
  [1871] = {.lex_state = 1, .external_lex_state = 21},
  [1872] = {.lex_state = 0, .external_lex_state = 25},
  [1873] = {.lex_state = 0, .external_lex_state = 25},
  [1874] = {.lex_state = 0, .external_lex_state = 25},
  [1875] = {.lex_state = 0, .external_lex_state = 25},
  [1876] = {.lex_state = 0, .external_lex_state = 25},
  [1877] = {.lex_state = 0, .external_lex_state = 25},
  [1878] = {.lex_state = 0, .external_lex_state = 25},
  [1879] = {.lex_state = 0, .external_lex_state = 25},
  [1880] = {.lex_state = 0, .external_lex_state = 25},
  [1881] = {.lex_state = 0, .external_lex_state = 25},
  [1882] = {.lex_state = 0, .external_lex_state = 25},
  [1883] = {.lex_state = 0, .external_lex_state = 25},
  [1884] = {.lex_state = 0, .external_lex_state = 25},
  [1885] = {.lex_state = 0, .external_lex_state = 25},
  [1886] = {.lex_state = 0, .external_lex_state = 25},
  [1887] = {.lex_state = 0, .external_lex_state = 25},
  [1888] = {.lex_state = 0, .external_lex_state = 25},
  [1889] = {.lex_state = 0, .external_lex_state = 25},
  [1890] = {.lex_state = 0, .external_lex_state = 25},
  [1891] = {.lex_state = 0, .external_lex_state = 25},
  [1892] = {.lex_state = 0, .external_lex_state = 25},
  [1893] = {.lex_state = 0, .external_lex_state = 25},
  [1894] = {.lex_state = 0, .external_lex_state = 25},
  [1895] = {.lex_state = 0, .external_lex_state = 25},
  [1896] = {.lex_state = 0, .external_lex_state = 25},
  [1897] = {.lex_state = 0, .external_lex_state = 25},
  [1898] = {.lex_state = 0, .external_lex_state = 25},
  [1899] = {.lex_state = 0, .external_lex_state = 25},
  [1900] = {.lex_state = 0, .external_lex_state = 25},
  [1901] = {.lex_state = 0, .external_lex_state = 25},
  [1902] = {.lex_state = 0, .external_lex_state = 25},
  [1903] = {.lex_state = 0, .external_lex_state = 25},
  [1904] = {.lex_state = 0, .external_lex_state = 25},
  [1905] = {.lex_state = 0, .external_lex_state = 25},
  [1906] = {.lex_state = 0, .external_lex_state = 25},
  [1907] = {.lex_state = 0, .external_lex_state = 25},
  [1908] = {.lex_state = 0, .external_lex_state = 9},
  [1909] = {.lex_state = 0, .external_lex_state = 8},
  [1910] = {.lex_state = 0, .external_lex_state = 23},
  [1911] = {.lex_state = 0, .external_lex_state = 23},
  [1912] = {.lex_state = 0, .external_lex_state = 10},
  [1913] = {.lex_state = 0, .external_lex_state = 23},
  [1914] = {.lex_state = 1, .external_lex_state = 23},
  [1915] = {.lex_state = 0, .external_lex_state = 23},
  [1916] = {.lex_state = 0, .external_lex_state = 10},
  [1917] = {.lex_state = 0, .external_lex_state = 23},
  [1918] = {.lex_state = 0, .external_lex_state = 10},
  [1919] = {.lex_state = 0, .external_lex_state = 10},
  [1920] = {.lex_state = 0, .external_lex_state = 8},
  [1921] = {.lex_state = 0, .external_lex_state = 10},
  [1922] = {.lex_state = 0, .external_lex_state = 23},
  [1923] = {.lex_state = 0, .external_lex_state = 23},
  [1924] = {.lex_state = 0, .external_lex_state = 9},
  [1925] = {.lex_state = 0, .external_lex_state = 9},
  [1926] = {.lex_state = 0, .external_lex_state = 8},
  [1927] = {.lex_state = 0, .external_lex_state = 10},
  [1928] = {.lex_state = 0, .external_lex_state = 9},
  [1929] = {.lex_state = 0, .external_lex_state = 23},
  [1930] = {.lex_state = 0, .external_lex_state = 9},
  [1931] = {.lex_state = 0, .external_lex_state = 10},
  [1932] = {.lex_state = 0, .external_lex_state = 8},
  [1933] = {.lex_state = 0, .external_lex_state = 9},
  [1934] = {.lex_state = 0, .external_lex_state = 8},
  [1935] = {.lex_state = 0, .external_lex_state = 16},
  [1936] = {.lex_state = 0, .external_lex_state = 9},
  [1937] = {.lex_state = 0, .external_lex_state = 8},
  [1938] = {.lex_state = 0, .external_lex_state = 8},
  [1939] = {.lex_state = 0, .external_lex_state = 25},
  [1940] = {.lex_state = 0, .external_lex_state = 17},
  [1941] = {.lex_state = 0, .external_lex_state = 25},
  [1942] = {.lex_state = 0, .external_lex_state = 25},
  [1943] = {.lex_state = 0, .external_lex_state = 25},
  [1944] = {.lex_state = 0, .external_lex_state = 25},
  [1945] = {.lex_state = 1, .external_lex_state = 25},
  [1946] = {.lex_state = 0, .external_lex_state = 25},
  [1947] = {.lex_state = 0, .external_lex_state = 25},
  [1948] = {.lex_state = 0, .external_lex_state = 25},
  [1949] = {.lex_state = 0, .external_lex_state = 10},
  [1950] = {.lex_state = 0, .external_lex_state = 23},
  [1951] = {.lex_state = 0, .external_lex_state = 23},
  [1952] = {.lex_state = 0, .external_lex_state = 17},
  [1953] = {.lex_state = 0, .external_lex_state = 23},
  [1954] = {.lex_state = 0, .external_lex_state = 17},
  [1955] = {.lex_state = 0, .external_lex_state = 23},
  [1956] = {.lex_state = 0, .external_lex_state = 23},
  [1957] = {.lex_state = 0, .external_lex_state = 23},
  [1958] = {.lex_state = 0, .external_lex_state = 23},
  [1959] = {.lex_state = 0, .external_lex_state = 23},
  [1960] = {.lex_state = 0, .external_lex_state = 23},
  [1961] = {.lex_state = 0, .external_lex_state = 23},
  [1962] = {.lex_state = 0, .external_lex_state = 23},
  [1963] = {.lex_state = 0, .external_lex_state = 23},
  [1964] = {.lex_state = 0, .external_lex_state = 23},
  [1965] = {.lex_state = 0, .external_lex_state = 23},
  [1966] = {.lex_state = 0, .external_lex_state = 23},
  [1967] = {.lex_state = 0, .external_lex_state = 23},
  [1968] = {.lex_state = 0, .external_lex_state = 23},
  [1969] = {.lex_state = 0, .external_lex_state = 23},
  [1970] = {.lex_state = 0, .external_lex_state = 23},
  [1971] = {.lex_state = 0, .external_lex_state = 17},
  [1972] = {.lex_state = 0, .external_lex_state = 25},
  [1973] = {.lex_state = 0, .external_lex_state = 25},
  [1974] = {.lex_state = 0, .external_lex_state = 25},
  [1975] = {.lex_state = 0, .external_lex_state = 25},
  [1976] = {.lex_state = 0, .external_lex_state = 25},
  [1977] = {.lex_state = 0, .external_lex_state = 25},
  [1978] = {.lex_state = 0, .external_lex_state = 25},
  [1979] = {.lex_state = 0, .external_lex_state = 25},
  [1980] = {.lex_state = 0, .external_lex_state = 25},
  [1981] = {.lex_state = 0, .external_lex_state = 25},
  [1982] = {.lex_state = 0, .external_lex_state = 25},
  [1983] = {.lex_state = 0, .external_lex_state = 25},
  [1984] = {.lex_state = 0, .external_lex_state = 25},
  [1985] = {.lex_state = 0, .external_lex_state = 25},
  [1986] = {.lex_state = 0, .external_lex_state = 25},
  [1987] = {.lex_state = 0, .external_lex_state = 25},
  [1988] = {.lex_state = 0, .external_lex_state = 25},
  [1989] = {.lex_state = 0, .external_lex_state = 25},
  [1990] = {.lex_state = 0, .external_lex_state = 25},
  [1991] = {.lex_state = 3, .external_lex_state = 26},
  [1992] = {.lex_state = 3},
  [1993] = {.lex_state = 0, .external_lex_state = 27},
  [1994] = {.lex_state = 2},
  [1995] = {.lex_state = 0, .external_lex_state = 26},
  [1996] = {.lex_state = 2},
  [1997] = {.lex_state = 4},
  [1998] = {.lex_state = 4},
  [1999] = {.lex_state = 4},
  [2000] = {.lex_state = 2},
  [2001] = {.lex_state = 4},
  [2002] = {.lex_state = 2},
  [2003] = {.lex_state = 0, .external_lex_state = 27},
  [2004] = {.lex_state = 0, .external_lex_state = 27},
  [2005] = {.lex_state = 2},
  [2006] = {.lex_state = 4},
  [2007] = {.lex_state = 2},
  [2008] = {.lex_state = 4},
  [2009] = {.lex_state = 2},
  [2010] = {.lex_state = 4},
  [2011] = {.lex_state = 4},
  [2012] = {.lex_state = 4},
  [2013] = {.lex_state = 2},
  [2014] = {.lex_state = 2},
  [2015] = {.lex_state = 0, .external_lex_state = 27},
  [2016] = {.lex_state = 2},
  [2017] = {.lex_state = 4},
  [2018] = {.lex_state = 4},
  [2019] = {.lex_state = 2},
  [2020] = {.lex_state = 4},
  [2021] = {.lex_state = 0, .external_lex_state = 27},
  [2022] = {.lex_state = 2},
  [2023] = {.lex_state = 0, .external_lex_state = 27},
  [2024] = {.lex_state = 4},
  [2025] = {.lex_state = 4},
  [2026] = {.lex_state = 2},
  [2027] = {.lex_state = 4},
  [2028] = {.lex_state = 2},
  [2029] = {.lex_state = 4},
  [2030] = {.lex_state = 2},
  [2031] = {.lex_state = 0, .external_lex_state = 27},
  [2032] = {.lex_state = 0, .external_lex_state = 26},
  [2033] = {.lex_state = 4},
  [2034] = {.lex_state = 2},
  [2035] = {.lex_state = 4},
  [2036] = {.lex_state = 0, .external_lex_state = 27},
  [2037] = {.lex_state = 0, .external_lex_state = 27},
  [2038] = {.lex_state = 4},
  [2039] = {.lex_state = 2},
  [2040] = {.lex_state = 0, .external_lex_state = 27},
  [2041] = {.lex_state = 0, .external_lex_state = 27},
  [2042] = {.lex_state = 4},
  [2043] = {.lex_state = 0, .external_lex_state = 27},
  [2044] = {.lex_state = 0, .external_lex_state = 27},
  [2045] = {.lex_state = 2},
  [2046] = {.lex_state = 0, .external_lex_state = 27},
  [2047] = {.lex_state = 0, .external_lex_state = 27},
  [2048] = {.lex_state = 2},
  [2049] = {.lex_state = 0, .external_lex_state = 27},
  [2050] = {.lex_state = 0, .external_lex_state = 27},
  [2051] = {.lex_state = 0, .external_lex_state = 27},
  [2052] = {.lex_state = 0, .external_lex_state = 27},
  [2053] = {.lex_state = 4},
  [2054] = {.lex_state = 0, .external_lex_state = 27},
  [2055] = {.lex_state = 2},
  [2056] = {.lex_state = 0, .external_lex_state = 27},
  [2057] = {.lex_state = 0, .external_lex_state = 27},
  [2058] = {.lex_state = 4},
  [2059] = {.lex_state = 0, .external_lex_state = 27},
  [2060] = {.lex_state = 2},
  [2061] = {.lex_state = 0, .external_lex_state = 27},
  [2062] = {.lex_state = 4},
  [2063] = {.lex_state = 0, .external_lex_state = 27},
  [2064] = {.lex_state = 2},
  [2065] = {.lex_state = 0, .external_lex_state = 27},
  [2066] = {.lex_state = 4},
  [2067] = {.lex_state = 0, .external_lex_state = 27},
  [2068] = {.lex_state = 4},
  [2069] = {.lex_state = 0, .external_lex_state = 27},
  [2070] = {.lex_state = 0, .external_lex_state = 27},
  [2071] = {.lex_state = 0, .external_lex_state = 27},
  [2072] = {.lex_state = 2},
  [2073] = {.lex_state = 0, .external_lex_state = 27},
  [2074] = {.lex_state = 0, .external_lex_state = 27},
  [2075] = {.lex_state = 0, .external_lex_state = 27},
  [2076] = {.lex_state = 0, .external_lex_state = 27},
  [2077] = {.lex_state = 0, .external_lex_state = 27},
  [2078] = {.lex_state = 0, .external_lex_state = 27},
  [2079] = {.lex_state = 0, .external_lex_state = 27},
  [2080] = {.lex_state = 0, .external_lex_state = 27},
  [2081] = {.lex_state = 0, .external_lex_state = 27},
  [2082] = {.lex_state = 0, .external_lex_state = 27},
  [2083] = {.lex_state = 0, .external_lex_state = 27},
  [2084] = {.lex_state = 0, .external_lex_state = 27},
  [2085] = {.lex_state = 0, .external_lex_state = 27},
  [2086] = {.lex_state = 0, .external_lex_state = 27},
  [2087] = {.lex_state = 0, .external_lex_state = 27},
  [2088] = {.lex_state = 0, .external_lex_state = 27},
  [2089] = {.lex_state = 2},
  [2090] = {.lex_state = 0, .external_lex_state = 27},
  [2091] = {.lex_state = 0, .external_lex_state = 27},
  [2092] = {.lex_state = 0, .external_lex_state = 27},
  [2093] = {.lex_state = 0, .external_lex_state = 27},
  [2094] = {.lex_state = 0, .external_lex_state = 27},
  [2095] = {.lex_state = 0, .external_lex_state = 27},
  [2096] = {.lex_state = 0, .external_lex_state = 27},
  [2097] = {.lex_state = 0, .external_lex_state = 27},
  [2098] = {.lex_state = 0, .external_lex_state = 27},
  [2099] = {.lex_state = 0, .external_lex_state = 27},
  [2100] = {.lex_state = 0, .external_lex_state = 27},
  [2101] = {.lex_state = 0, .external_lex_state = 27},
  [2102] = {.lex_state = 0, .external_lex_state = 27},
  [2103] = {.lex_state = 0, .external_lex_state = 27},
  [2104] = {.lex_state = 0, .external_lex_state = 27},
  [2105] = {.lex_state = 0, .external_lex_state = 27},
  [2106] = {.lex_state = 0, .external_lex_state = 27},
  [2107] = {.lex_state = 0, .external_lex_state = 27},
  [2108] = {.lex_state = 0, .external_lex_state = 27},
  [2109] = {.lex_state = 0, .external_lex_state = 27},
  [2110] = {.lex_state = 0, .external_lex_state = 27},
  [2111] = {.lex_state = 0, .external_lex_state = 27},
  [2112] = {.lex_state = 0, .external_lex_state = 27},
  [2113] = {.lex_state = 0, .external_lex_state = 27},
  [2114] = {.lex_state = 0, .external_lex_state = 27},
  [2115] = {.lex_state = 0, .external_lex_state = 27},
  [2116] = {.lex_state = 2},
  [2117] = {.lex_state = 2},
  [2118] = {.lex_state = 0, .external_lex_state = 28},
  [2119] = {.lex_state = 0, .external_lex_state = 26},
  [2120] = {.lex_state = 0, .external_lex_state = 28},
  [2121] = {.lex_state = 0, .external_lex_state = 26},
  [2122] = {.lex_state = 0, .external_lex_state = 28},
  [2123] = {.lex_state = 0, .external_lex_state = 28},
  [2124] = {.lex_state = 0, .external_lex_state = 28},
  [2125] = {.lex_state = 0, .external_lex_state = 28},
  [2126] = {.lex_state = 0, .external_lex_state = 28},
  [2127] = {.lex_state = 0, .external_lex_state = 28},
  [2128] = {.lex_state = 0, .external_lex_state = 28},
  [2129] = {.lex_state = 4},
  [2130] = {.lex_state = 0, .external_lex_state = 28},
  [2131] = {.lex_state = 0, .external_lex_state = 28},
  [2132] = {.lex_state = 0, .external_lex_state = 28},
  [2133] = {.lex_state = 0, .external_lex_state = 27},
  [2134] = {.lex_state = 0},
  [2135] = {.lex_state = 0, .external_lex_state = 26},
  [2136] = {.lex_state = 0},
  [2137] = {.lex_state = 0},
  [2138] = {.lex_state = 0, .external_lex_state = 26},
  [2139] = {.lex_state = 0},
  [2140] = {.lex_state = 0},
  [2141] = {.lex_state = 0},
  [2142] = {.lex_state = 0},
  [2143] = {.lex_state = 0},
  [2144] = {.lex_state = 0},
  [2145] = {.lex_state = 0},
  [2146] = {.lex_state = 0, .external_lex_state = 26},
  [2147] = {.lex_state = 0},
  [2148] = {.lex_state = 0},
  [2149] = {.lex_state = 0, .external_lex_state = 26},
  [2150] = {.lex_state = 1},
  [2151] = {.lex_state = 1},
  [2152] = {.lex_state = 1},
  [2153] = {.lex_state = 1},
  [2154] = {.lex_state = 1},
  [2155] = {.lex_state = 1},
  [2156] = {.lex_state = 1},
  [2157] = {.lex_state = 1},
  [2158] = {.lex_state = 1},
  [2159] = {.lex_state = 1},
  [2160] = {.lex_state = 1},
  [2161] = {.lex_state = 1},
  [2162] = {.lex_state = 1},
  [2163] = {.lex_state = 1},
  [2164] = {.lex_state = 1},
  [2165] = {.lex_state = 1},
  [2166] = {.lex_state = 1},
  [2167] = {.lex_state = 1},
  [2168] = {.lex_state = 1},
  [2169] = {.lex_state = 1},
  [2170] = {.lex_state = 1},
  [2171] = {.lex_state = 1},
  [2172] = {.lex_state = 1},
  [2173] = {.lex_state = 1},
  [2174] = {.lex_state = 1},
  [2175] = {.lex_state = 1},
  [2176] = {.lex_state = 1},
  [2177] = {.lex_state = 1},
  [2178] = {.lex_state = 0},
  [2179] = {.lex_state = 1},
  [2180] = {.lex_state = 1},
  [2181] = {.lex_state = 1},
  [2182] = {.lex_state = 1},
  [2183] = {.lex_state = 1},
  [2184] = {.lex_state = 1},
  [2185] = {.lex_state = 1},
  [2186] = {.lex_state = 1},
  [2187] = {.lex_state = 1},
  [2188] = {.lex_state = 1},
  [2189] = {.lex_state = 1},
  [2190] = {.lex_state = 1},
  [2191] = {.lex_state = 1},
  [2192] = {.lex_state = 1},
  [2193] = {.lex_state = 1},
  [2194] = {.lex_state = 1},
  [2195] = {.lex_state = 1},
  [2196] = {.lex_state = 1},
  [2197] = {.lex_state = 1},
  [2198] = {.lex_state = 1},
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_identifier] = ACTIONS(1),
    [anon_sym_BSLASH] = ACTIONS(1),
    [anon_sym_function] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_for] = ACTIONS(1),
    [anon_sym_in] = ACTIONS(1),
    [anon_sym_while] = ACTIONS(1),
    [anon_sym_repeat] = ACTIONS(1),
    [anon_sym_QMARK] = ACTIONS(1),
    [anon_sym_TILDE] = ACTIONS(1),
    [anon_sym_BANG] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_LT_DASH] = ACTIONS(1),
    [anon_sym_LT_LT_DASH] = ACTIONS(1),
    [anon_sym_COLON_EQ] = ACTIONS(1),
    [anon_sym_DASH_GT] = ACTIONS(1),
    [anon_sym_DASH_GT_GT] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_AMP] = ACTIONS(1),
    [anon_sym_PIPE_PIPE] = ACTIONS(1),
    [anon_sym_AMP_AMP] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_BANG_EQ] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_STAR_STAR] = ACTIONS(1),
    [anon_sym_CARET] = ACTIONS(1),
    [aux_sym_binary_operator_token1] = ACTIONS(1),
    [anon_sym_PIPE_GT] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_DOLLAR] = ACTIONS(1),
    [anon_sym_AT] = ACTIONS(1),
    [anon_sym_COLON_COLON] = ACTIONS(1),
    [anon_sym_COLON_COLON_COLON] = ACTIONS(1),
    [anon_sym_L] = ACTIONS(1),
    [anon_sym_i] = ACTIONS(1),
    [aux_sym__hex_literal_token1] = ACTIONS(1),
    [sym__number_literal] = ACTIONS(1),
    [anon_sym_SQUOTE] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [sym_return] = ACTIONS(1),
    [sym_next] = ACTIONS(1),
    [sym_break] = ACTIONS(1),
    [sym_true] = ACTIONS(1),
    [sym_false] = ACTIONS(1),
    [sym_null] = ACTIONS(1),
    [sym_inf] = ACTIONS(1),
    [sym_nan] = ACTIONS(1),
    [anon_sym_NA] = ACTIONS(1),
    [anon_sym_NA_integer_] = ACTIONS(1),
    [anon_sym_NA_real_] = ACTIONS(1),
    [anon_sym_NA_complex_] = ACTIONS(1),
    [anon_sym_NA_character_] = ACTIONS(1),
    [sym_dots] = ACTIONS(1),
    [sym_dot_dot_i] = ACTIONS(1),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(1),
    [sym__newline] = ACTIONS(1),
    [sym__semicolon] = ACTIONS(1),
    [sym__raw_string_literal] = ACTIONS(1),
    [sym__external_else] = ACTIONS(1),
    [sym__external_open_parenthesis] = ACTIONS(1),
    [sym__external_close_parenthesis] = ACTIONS(1),
    [sym__external_open_brace] = ACTIONS(1),
    [sym__external_close_brace] = ACTIONS(1),
    [sym__external_open_bracket] = ACTIONS(1),
    [sym__external_close_bracket] = ACTIONS(1),
    [sym__external_open_bracket2] = ACTIONS(1),
    [sym__external_close_bracket2] = ACTIONS(1),
    [sym__error_sentinel] = ACTIONS(1),
  },
  [1] = {
    [sym_program] = STATE(2178),
    [sym_function_definition] = STATE(364),
    [sym_if_statement] = STATE(364),
    [sym_for_statement] = STATE(364),
    [sym_while_statement] = STATE(364),
    [sym_repeat_statement] = STATE(364),
    [sym_braced_expression] = STATE(364),
    [sym_parenthesized_expression] = STATE(364),
    [sym_call] = STATE(364),
    [sym_subset] = STATE(364),
    [sym_subset2] = STATE(364),
    [sym_unary_operator] = STATE(364),
    [sym_binary_operator] = STATE(364),
    [sym_extract_operator] = STATE(364),
    [sym_namespace_operator] = STATE(364),
    [sym_integer] = STATE(364),
    [sym_complex] = STATE(364),
    [sym_float] = STATE(364),
    [sym__hex_literal] = STATE(744),
    [sym__float_literal] = STATE(744),
    [sym_string] = STATE(740),
    [sym__single_quoted_string] = STATE(745),
    [sym__double_quoted_string] = STATE(739),
    [sym_na] = STATE(364),
    [sym__expression] = STATE(364),
    [sym__string_or_identifier] = STATE(2134),
    [sym__open_parenthesis] = STATE(825),
    [sym__open_brace] = STATE(700),
    [aux_sym_program_repeat1] = STATE(841),
    [ts_builtin_sym_end] = ACTIONS(5),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_BSLASH] = ACTIONS(9),
    [anon_sym_function] = ACTIONS(11),
    [anon_sym_if] = ACTIONS(13),
    [anon_sym_for] = ACTIONS(15),
    [anon_sym_while] = ACTIONS(17),
    [anon_sym_repeat] = ACTIONS(19),
    [anon_sym_QMARK] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_BANG] = ACTIONS(25),
    [anon_sym_PLUS] = ACTIONS(27),
    [anon_sym_DASH] = ACTIONS(27),
    [aux_sym__hex_literal_token1] = ACTIONS(29),
    [sym__number_literal] = ACTIONS(31),
    [anon_sym_SQUOTE] = ACTIONS(33),
    [anon_sym_DQUOTE] = ACTIONS(35),
    [sym_return] = ACTIONS(37),
    [sym_next] = ACTIONS(37),
    [sym_break] = ACTIONS(37),
    [sym_true] = ACTIONS(37),
    [sym_false] = ACTIONS(37),
    [sym_null] = ACTIONS(37),
    [sym_inf] = ACTIONS(37),
    [sym_nan] = ACTIONS(37),
    [anon_sym_NA] = ACTIONS(39),
    [anon_sym_NA_integer_] = ACTIONS(39),
    [anon_sym_NA_real_] = ACTIONS(39),
    [anon_sym_NA_complex_] = ACTIONS(39),
    [anon_sym_NA_character_] = ACTIONS(39),
    [sym_dots] = ACTIONS(37),
    [sym_dot_dot_i] = ACTIONS(41),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(43),
    [sym__semicolon] = ACTIONS(43),
    [sym__raw_string_literal] = ACTIONS(45),
    [sym__external_open_parenthesis] = ACTIONS(47),
    [sym__external_open_brace] = ACTIONS(49),
  },
  [2] = {
    [sym_call_arguments] = STATE(807),
    [sym_subset_arguments] = STATE(808),
    [sym_subset2_arguments] = STATE(810),
    [sym__else] = STATE(1656),
    [sym__open_parenthesis] = STATE(357),
    [sym__open_bracket] = STATE(358),
    [sym__open_bracket2] = STATE(359),
    [sym_identifier] = ACTIONS(51),
    [anon_sym_BSLASH] = ACTIONS(53),
    [anon_sym_function] = ACTIONS(51),
    [anon_sym_EQ] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(51),
    [anon_sym_for] = ACTIONS(51),
    [anon_sym_while] = ACTIONS(51),
    [anon_sym_repeat] = ACTIONS(51),
    [anon_sym_QMARK] = ACTIONS(53),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_BANG] = ACTIONS(51),
    [anon_sym_PLUS] = ACTIONS(59),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_LT_DASH] = ACTIONS(63),
    [anon_sym_LT_LT_DASH] = ACTIONS(63),
    [anon_sym_COLON_EQ] = ACTIONS(63),
    [anon_sym_DASH_GT] = ACTIONS(65),
    [anon_sym_DASH_GT_GT] = ACTIONS(67),
    [anon_sym_PIPE] = ACTIONS(69),
    [anon_sym_AMP] = ACTIONS(71),
    [anon_sym_PIPE_PIPE] = ACTIONS(73),
    [anon_sym_AMP_AMP] = ACTIONS(75),
    [anon_sym_LT] = ACTIONS(77),
    [anon_sym_LT_EQ] = ACTIONS(79),
    [anon_sym_GT] = ACTIONS(77),
    [anon_sym_GT_EQ] = ACTIONS(79),
    [anon_sym_EQ_EQ] = ACTIONS(79),
    [anon_sym_BANG_EQ] = ACTIONS(79),
    [anon_sym_STAR] = ACTIONS(81),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_STAR_STAR] = ACTIONS(85),
    [anon_sym_CARET] = ACTIONS(85),
    [aux_sym_binary_operator_token1] = ACTIONS(87),
    [anon_sym_PIPE_GT] = ACTIONS(87),
    [anon_sym_COLON] = ACTIONS(89),
    [anon_sym_DOLLAR] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(91),
    [aux_sym__hex_literal_token1] = ACTIONS(53),
    [sym__number_literal] = ACTIONS(51),
    [anon_sym_SQUOTE] = ACTIONS(53),
    [anon_sym_DQUOTE] = ACTIONS(53),
    [sym_return] = ACTIONS(51),
    [sym_next] = ACTIONS(51),
    [sym_break] = ACTIONS(51),
    [sym_true] = ACTIONS(51),
    [sym_false] = ACTIONS(51),
    [sym_null] = ACTIONS(51),
    [sym_inf] = ACTIONS(51),
    [sym_nan] = ACTIONS(51),
    [anon_sym_NA] = ACTIONS(51),
    [anon_sym_NA_integer_] = ACTIONS(51),
    [anon_sym_NA_real_] = ACTIONS(51),
    [anon_sym_NA_complex_] = ACTIONS(51),
    [anon_sym_NA_character_] = ACTIONS(51),
    [sym_dots] = ACTIONS(51),
    [sym_dot_dot_i] = ACTIONS(53),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(53),
    [sym__newline] = ACTIONS(53),
    [sym__raw_string_literal] = ACTIONS(53),
    [sym__external_else] = ACTIONS(93),
    [sym__external_open_parenthesis] = ACTIONS(95),
    [sym__external_open_brace] = ACTIONS(53),
    [sym__external_open_bracket] = ACTIONS(97),
    [sym__external_close_bracket] = ACTIONS(53),
    [sym__external_open_bracket2] = ACTIONS(99),
  },
  [3] = {
    [sym_call_arguments] = STATE(862),
    [sym_subset_arguments] = STATE(885),
    [sym_subset2_arguments] = STATE(900),
    [sym__else] = STATE(1648),
    [sym__open_parenthesis] = STATE(341),
    [sym__open_bracket] = STATE(342),
    [sym__open_bracket2] = STATE(343),
    [ts_builtin_sym_end] = ACTIONS(101),
    [sym_identifier] = ACTIONS(103),
    [anon_sym_BSLASH] = ACTIONS(101),
    [anon_sym_function] = ACTIONS(103),
    [anon_sym_EQ] = ACTIONS(105),
    [anon_sym_if] = ACTIONS(103),
    [anon_sym_for] = ACTIONS(103),
    [anon_sym_while] = ACTIONS(103),
    [anon_sym_repeat] = ACTIONS(103),
    [anon_sym_QMARK] = ACTIONS(101),
    [anon_sym_TILDE] = ACTIONS(107),
    [anon_sym_BANG] = ACTIONS(103),
    [anon_sym_PLUS] = ACTIONS(109),
    [anon_sym_DASH] = ACTIONS(111),
    [anon_sym_LT_DASH] = ACTIONS(113),
    [anon_sym_LT_LT_DASH] = ACTIONS(113),
    [anon_sym_COLON_EQ] = ACTIONS(113),
    [anon_sym_DASH_GT] = ACTIONS(115),
    [anon_sym_DASH_GT_GT] = ACTIONS(117),
    [anon_sym_PIPE] = ACTIONS(119),
    [anon_sym_AMP] = ACTIONS(121),
    [anon_sym_PIPE_PIPE] = ACTIONS(123),
    [anon_sym_AMP_AMP] = ACTIONS(125),
    [anon_sym_LT] = ACTIONS(127),
    [anon_sym_LT_EQ] = ACTIONS(129),
    [anon_sym_GT] = ACTIONS(127),
    [anon_sym_GT_EQ] = ACTIONS(129),
    [anon_sym_EQ_EQ] = ACTIONS(129),
    [anon_sym_BANG_EQ] = ACTIONS(129),
    [anon_sym_STAR] = ACTIONS(131),
    [anon_sym_SLASH] = ACTIONS(133),
    [anon_sym_STAR_STAR] = ACTIONS(135),
    [anon_sym_CARET] = ACTIONS(135),
    [aux_sym_binary_operator_token1] = ACTIONS(137),
    [anon_sym_PIPE_GT] = ACTIONS(137),
    [anon_sym_COLON] = ACTIONS(139),
    [anon_sym_DOLLAR] = ACTIONS(141),
    [anon_sym_AT] = ACTIONS(141),
    [aux_sym__hex_literal_token1] = ACTIONS(101),
    [sym__number_literal] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_DQUOTE] = ACTIONS(101),
    [sym_return] = ACTIONS(103),
    [sym_next] = ACTIONS(103),
    [sym_break] = ACTIONS(103),
    [sym_true] = ACTIONS(103),
    [sym_false] = ACTIONS(103),
    [sym_null] = ACTIONS(103),
    [sym_inf] = ACTIONS(103),
    [sym_nan] = ACTIONS(103),
    [anon_sym_NA] = ACTIONS(103),
    [anon_sym_NA_integer_] = ACTIONS(103),
    [anon_sym_NA_real_] = ACTIONS(103),
    [anon_sym_NA_complex_] = ACTIONS(103),
    [anon_sym_NA_character_] = ACTIONS(103),
    [sym_dots] = ACTIONS(103),
    [sym_dot_dot_i] = ACTIONS(101),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(101),
    [sym__semicolon] = ACTIONS(101),
    [sym__raw_string_literal] = ACTIONS(101),
    [sym__external_else] = ACTIONS(143),
    [sym__external_open_parenthesis] = ACTIONS(145),
    [sym__external_open_brace] = ACTIONS(101),
    [sym__external_open_bracket] = ACTIONS(147),
    [sym__external_open_bracket2] = ACTIONS(149),
  },
  [4] = {
    [sym_call_arguments] = STATE(862),
    [sym_subset_arguments] = STATE(885),
    [sym_subset2_arguments] = STATE(900),
    [sym__else] = STATE(1633),
    [sym__open_parenthesis] = STATE(341),
    [sym__open_bracket] = STATE(342),
    [sym__open_bracket2] = STATE(343),
    [ts_builtin_sym_end] = ACTIONS(53),
    [sym_identifier] = ACTIONS(51),
    [anon_sym_BSLASH] = ACTIONS(53),
    [anon_sym_function] = ACTIONS(51),
    [anon_sym_EQ] = ACTIONS(105),
    [anon_sym_if] = ACTIONS(51),
    [anon_sym_for] = ACTIONS(51),
    [anon_sym_while] = ACTIONS(51),
    [anon_sym_repeat] = ACTIONS(51),
    [anon_sym_QMARK] = ACTIONS(53),
    [anon_sym_TILDE] = ACTIONS(107),
    [anon_sym_BANG] = ACTIONS(51),
    [anon_sym_PLUS] = ACTIONS(109),
    [anon_sym_DASH] = ACTIONS(111),
    [anon_sym_LT_DASH] = ACTIONS(113),
    [anon_sym_LT_LT_DASH] = ACTIONS(113),
    [anon_sym_COLON_EQ] = ACTIONS(113),
    [anon_sym_DASH_GT] = ACTIONS(115),
    [anon_sym_DASH_GT_GT] = ACTIONS(117),
    [anon_sym_PIPE] = ACTIONS(119),
    [anon_sym_AMP] = ACTIONS(121),
    [anon_sym_PIPE_PIPE] = ACTIONS(123),
    [anon_sym_AMP_AMP] = ACTIONS(125),
    [anon_sym_LT] = ACTIONS(127),
    [anon_sym_LT_EQ] = ACTIONS(129),
    [anon_sym_GT] = ACTIONS(127),
    [anon_sym_GT_EQ] = ACTIONS(129),
    [anon_sym_EQ_EQ] = ACTIONS(129),
    [anon_sym_BANG_EQ] = ACTIONS(129),
    [anon_sym_STAR] = ACTIONS(131),
    [anon_sym_SLASH] = ACTIONS(133),
    [anon_sym_STAR_STAR] = ACTIONS(135),
    [anon_sym_CARET] = ACTIONS(135),
    [aux_sym_binary_operator_token1] = ACTIONS(137),
    [anon_sym_PIPE_GT] = ACTIONS(137),
    [anon_sym_COLON] = ACTIONS(139),
    [anon_sym_DOLLAR] = ACTIONS(141),
    [anon_sym_AT] = ACTIONS(141),
    [aux_sym__hex_literal_token1] = ACTIONS(53),
    [sym__number_literal] = ACTIONS(51),
    [anon_sym_SQUOTE] = ACTIONS(53),
    [anon_sym_DQUOTE] = ACTIONS(53),
    [sym_return] = ACTIONS(51),
    [sym_next] = ACTIONS(51),
    [sym_break] = ACTIONS(51),
    [sym_true] = ACTIONS(51),
    [sym_false] = ACTIONS(51),
    [sym_null] = ACTIONS(51),
    [sym_inf] = ACTIONS(51),
    [sym_nan] = ACTIONS(51),
    [anon_sym_NA] = ACTIONS(51),
    [anon_sym_NA_integer_] = ACTIONS(51),
    [anon_sym_NA_real_] = ACTIONS(51),
    [anon_sym_NA_complex_] = ACTIONS(51),
    [anon_sym_NA_character_] = ACTIONS(51),
    [sym_dots] = ACTIONS(51),
    [sym_dot_dot_i] = ACTIONS(53),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(53),
    [sym__semicolon] = ACTIONS(53),
    [sym__raw_string_literal] = ACTIONS(53),
    [sym__external_else] = ACTIONS(151),
    [sym__external_open_parenthesis] = ACTIONS(145),
    [sym__external_open_brace] = ACTIONS(53),
    [sym__external_open_bracket] = ACTIONS(147),
    [sym__external_open_bracket2] = ACTIONS(149),
  },
  [5] = {
    [sym_call_arguments] = STATE(888),
    [sym_subset_arguments] = STATE(892),
    [sym_subset2_arguments] = STATE(895),
    [sym__else] = STATE(1620),
    [sym__open_parenthesis] = STATE(345),
    [sym__open_bracket] = STATE(346),
    [sym__open_bracket2] = STATE(347),
    [sym_identifier] = ACTIONS(153),
    [anon_sym_BSLASH] = ACTIONS(155),
    [anon_sym_function] = ACTIONS(153),
    [anon_sym_EQ] = ACTIONS(157),
    [anon_sym_if] = ACTIONS(153),
    [anon_sym_for] = ACTIONS(153),
    [anon_sym_while] = ACTIONS(153),
    [anon_sym_repeat] = ACTIONS(153),
    [anon_sym_QMARK] = ACTIONS(155),
    [anon_sym_TILDE] = ACTIONS(159),
    [anon_sym_BANG] = ACTIONS(153),
    [anon_sym_PLUS] = ACTIONS(161),
    [anon_sym_DASH] = ACTIONS(163),
    [anon_sym_LT_DASH] = ACTIONS(165),
    [anon_sym_LT_LT_DASH] = ACTIONS(165),
    [anon_sym_COLON_EQ] = ACTIONS(165),
    [anon_sym_DASH_GT] = ACTIONS(167),
    [anon_sym_DASH_GT_GT] = ACTIONS(169),
    [anon_sym_PIPE] = ACTIONS(171),
    [anon_sym_AMP] = ACTIONS(173),
    [anon_sym_PIPE_PIPE] = ACTIONS(175),
    [anon_sym_AMP_AMP] = ACTIONS(177),
    [anon_sym_LT] = ACTIONS(179),
    [anon_sym_LT_EQ] = ACTIONS(181),
    [anon_sym_GT] = ACTIONS(179),
    [anon_sym_GT_EQ] = ACTIONS(181),
    [anon_sym_EQ_EQ] = ACTIONS(181),
    [anon_sym_BANG_EQ] = ACTIONS(181),
    [anon_sym_STAR] = ACTIONS(183),
    [anon_sym_SLASH] = ACTIONS(185),
    [anon_sym_STAR_STAR] = ACTIONS(187),
    [anon_sym_CARET] = ACTIONS(187),
    [aux_sym_binary_operator_token1] = ACTIONS(189),
    [anon_sym_PIPE_GT] = ACTIONS(189),
    [anon_sym_COLON] = ACTIONS(191),
    [anon_sym_DOLLAR] = ACTIONS(193),
    [anon_sym_AT] = ACTIONS(193),
    [aux_sym__hex_literal_token1] = ACTIONS(155),
    [sym__number_literal] = ACTIONS(153),
    [anon_sym_SQUOTE] = ACTIONS(155),
    [anon_sym_DQUOTE] = ACTIONS(155),
    [sym_return] = ACTIONS(153),
    [sym_next] = ACTIONS(153),
    [sym_break] = ACTIONS(153),
    [sym_true] = ACTIONS(153),
    [sym_false] = ACTIONS(153),
    [sym_null] = ACTIONS(153),
    [sym_inf] = ACTIONS(153),
    [sym_nan] = ACTIONS(153),
    [anon_sym_NA] = ACTIONS(153),
    [anon_sym_NA_integer_] = ACTIONS(153),
    [anon_sym_NA_real_] = ACTIONS(153),
    [anon_sym_NA_complex_] = ACTIONS(153),
    [anon_sym_NA_character_] = ACTIONS(153),
    [sym_dots] = ACTIONS(153),
    [sym_dot_dot_i] = ACTIONS(155),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(155),
    [sym__newline] = ACTIONS(155),
    [sym__raw_string_literal] = ACTIONS(155),
    [sym__external_else] = ACTIONS(195),
    [sym__external_open_parenthesis] = ACTIONS(197),
    [sym__external_close_parenthesis] = ACTIONS(155),
    [sym__external_open_brace] = ACTIONS(155),
    [sym__external_open_bracket] = ACTIONS(199),
    [sym__external_open_bracket2] = ACTIONS(201),
  },
  [6] = {
    [sym_call_arguments] = STATE(888),
    [sym_subset_arguments] = STATE(892),
    [sym_subset2_arguments] = STATE(895),
    [sym__else] = STATE(1624),
    [sym__open_parenthesis] = STATE(345),
    [sym__open_bracket] = STATE(346),
    [sym__open_bracket2] = STATE(347),
    [sym_identifier] = ACTIONS(51),
    [anon_sym_BSLASH] = ACTIONS(53),
    [anon_sym_function] = ACTIONS(51),
    [anon_sym_EQ] = ACTIONS(157),
    [anon_sym_if] = ACTIONS(51),
    [anon_sym_for] = ACTIONS(51),
    [anon_sym_while] = ACTIONS(51),
    [anon_sym_repeat] = ACTIONS(51),
    [anon_sym_QMARK] = ACTIONS(53),
    [anon_sym_TILDE] = ACTIONS(159),
    [anon_sym_BANG] = ACTIONS(51),
    [anon_sym_PLUS] = ACTIONS(161),
    [anon_sym_DASH] = ACTIONS(163),
    [anon_sym_LT_DASH] = ACTIONS(165),
    [anon_sym_LT_LT_DASH] = ACTIONS(165),
    [anon_sym_COLON_EQ] = ACTIONS(165),
    [anon_sym_DASH_GT] = ACTIONS(167),
    [anon_sym_DASH_GT_GT] = ACTIONS(169),
    [anon_sym_PIPE] = ACTIONS(171),
    [anon_sym_AMP] = ACTIONS(173),
    [anon_sym_PIPE_PIPE] = ACTIONS(175),
    [anon_sym_AMP_AMP] = ACTIONS(177),
    [anon_sym_LT] = ACTIONS(179),
    [anon_sym_LT_EQ] = ACTIONS(181),
    [anon_sym_GT] = ACTIONS(179),
    [anon_sym_GT_EQ] = ACTIONS(181),
    [anon_sym_EQ_EQ] = ACTIONS(181),
    [anon_sym_BANG_EQ] = ACTIONS(181),
    [anon_sym_STAR] = ACTIONS(183),
    [anon_sym_SLASH] = ACTIONS(185),
    [anon_sym_STAR_STAR] = ACTIONS(187),
    [anon_sym_CARET] = ACTIONS(187),
    [aux_sym_binary_operator_token1] = ACTIONS(189),
    [anon_sym_PIPE_GT] = ACTIONS(189),
    [anon_sym_COLON] = ACTIONS(191),
    [anon_sym_DOLLAR] = ACTIONS(193),
    [anon_sym_AT] = ACTIONS(193),
    [aux_sym__hex_literal_token1] = ACTIONS(53),
    [sym__number_literal] = ACTIONS(51),
    [anon_sym_SQUOTE] = ACTIONS(53),
    [anon_sym_DQUOTE] = ACTIONS(53),
    [sym_return] = ACTIONS(51),
    [sym_next] = ACTIONS(51),
    [sym_break] = ACTIONS(51),
    [sym_true] = ACTIONS(51),
    [sym_false] = ACTIONS(51),
    [sym_null] = ACTIONS(51),
    [sym_inf] = ACTIONS(51),
    [sym_nan] = ACTIONS(51),
    [anon_sym_NA] = ACTIONS(51),
    [anon_sym_NA_integer_] = ACTIONS(51),
    [anon_sym_NA_real_] = ACTIONS(51),
    [anon_sym_NA_complex_] = ACTIONS(51),
    [anon_sym_NA_character_] = ACTIONS(51),
    [sym_dots] = ACTIONS(51),
    [sym_dot_dot_i] = ACTIONS(53),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(53),
    [sym__newline] = ACTIONS(53),
    [sym__raw_string_literal] = ACTIONS(53),
    [sym__external_else] = ACTIONS(203),
    [sym__external_open_parenthesis] = ACTIONS(197),
    [sym__external_close_parenthesis] = ACTIONS(53),
    [sym__external_open_brace] = ACTIONS(53),
    [sym__external_open_bracket] = ACTIONS(199),
    [sym__external_open_bracket2] = ACTIONS(201),
  },
  [7] = {
    [sym_call_arguments] = STATE(888),
    [sym_subset_arguments] = STATE(892),
    [sym_subset2_arguments] = STATE(895),
    [sym__else] = STATE(1625),
    [sym__open_parenthesis] = STATE(345),
    [sym__open_bracket] = STATE(346),
    [sym__open_bracket2] = STATE(347),
    [sym_identifier] = ACTIONS(205),
    [anon_sym_BSLASH] = ACTIONS(207),
    [anon_sym_function] = ACTIONS(205),
    [anon_sym_EQ] = ACTIONS(157),
    [anon_sym_if] = ACTIONS(205),
    [anon_sym_for] = ACTIONS(205),
    [anon_sym_while] = ACTIONS(205),
    [anon_sym_repeat] = ACTIONS(205),
    [anon_sym_QMARK] = ACTIONS(207),
    [anon_sym_TILDE] = ACTIONS(159),
    [anon_sym_BANG] = ACTIONS(205),
    [anon_sym_PLUS] = ACTIONS(161),
    [anon_sym_DASH] = ACTIONS(163),
    [anon_sym_LT_DASH] = ACTIONS(165),
    [anon_sym_LT_LT_DASH] = ACTIONS(165),
    [anon_sym_COLON_EQ] = ACTIONS(165),
    [anon_sym_DASH_GT] = ACTIONS(167),
    [anon_sym_DASH_GT_GT] = ACTIONS(169),
    [anon_sym_PIPE] = ACTIONS(171),
    [anon_sym_AMP] = ACTIONS(173),
    [anon_sym_PIPE_PIPE] = ACTIONS(175),
    [anon_sym_AMP_AMP] = ACTIONS(177),
    [anon_sym_LT] = ACTIONS(179),
    [anon_sym_LT_EQ] = ACTIONS(181),
    [anon_sym_GT] = ACTIONS(179),
    [anon_sym_GT_EQ] = ACTIONS(181),
    [anon_sym_EQ_EQ] = ACTIONS(181),
    [anon_sym_BANG_EQ] = ACTIONS(181),
    [anon_sym_STAR] = ACTIONS(183),
    [anon_sym_SLASH] = ACTIONS(185),
    [anon_sym_STAR_STAR] = ACTIONS(187),
    [anon_sym_CARET] = ACTIONS(187),
    [aux_sym_binary_operator_token1] = ACTIONS(189),
    [anon_sym_PIPE_GT] = ACTIONS(189),
    [anon_sym_COLON] = ACTIONS(191),
    [anon_sym_DOLLAR] = ACTIONS(193),
    [anon_sym_AT] = ACTIONS(193),
    [aux_sym__hex_literal_token1] = ACTIONS(207),
    [sym__number_literal] = ACTIONS(205),
    [anon_sym_SQUOTE] = ACTIONS(207),
    [anon_sym_DQUOTE] = ACTIONS(207),
    [sym_return] = ACTIONS(205),
    [sym_next] = ACTIONS(205),
    [sym_break] = ACTIONS(205),
    [sym_true] = ACTIONS(205),
    [sym_false] = ACTIONS(205),
    [sym_null] = ACTIONS(205),
    [sym_inf] = ACTIONS(205),
    [sym_nan] = ACTIONS(205),
    [anon_sym_NA] = ACTIONS(205),
    [anon_sym_NA_integer_] = ACTIONS(205),
    [anon_sym_NA_real_] = ACTIONS(205),
    [anon_sym_NA_complex_] = ACTIONS(205),
    [anon_sym_NA_character_] = ACTIONS(205),
    [sym_dots] = ACTIONS(205),
    [sym_dot_dot_i] = ACTIONS(207),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(207),
    [sym__newline] = ACTIONS(207),
    [sym__raw_string_literal] = ACTIONS(207),
    [sym__external_else] = ACTIONS(209),
    [sym__external_open_parenthesis] = ACTIONS(197),
    [sym__external_close_parenthesis] = ACTIONS(207),
    [sym__external_open_brace] = ACTIONS(207),
    [sym__external_open_bracket] = ACTIONS(199),
    [sym__external_open_bracket2] = ACTIONS(201),
  },
  [8] = {
    [sym_call_arguments] = STATE(888),
    [sym_subset_arguments] = STATE(892),
    [sym_subset2_arguments] = STATE(895),
    [sym__else] = STATE(1628),
    [sym__open_parenthesis] = STATE(345),
    [sym__open_bracket] = STATE(346),
    [sym__open_bracket2] = STATE(347),
    [sym_identifier] = ACTIONS(103),
    [anon_sym_BSLASH] = ACTIONS(101),
    [anon_sym_function] = ACTIONS(103),
    [anon_sym_EQ] = ACTIONS(157),
    [anon_sym_if] = ACTIONS(103),
    [anon_sym_for] = ACTIONS(103),
    [anon_sym_while] = ACTIONS(103),
    [anon_sym_repeat] = ACTIONS(103),
    [anon_sym_QMARK] = ACTIONS(101),
    [anon_sym_TILDE] = ACTIONS(159),
    [anon_sym_BANG] = ACTIONS(103),
    [anon_sym_PLUS] = ACTIONS(161),
    [anon_sym_DASH] = ACTIONS(163),
    [anon_sym_LT_DASH] = ACTIONS(165),
    [anon_sym_LT_LT_DASH] = ACTIONS(165),
    [anon_sym_COLON_EQ] = ACTIONS(165),
    [anon_sym_DASH_GT] = ACTIONS(167),
    [anon_sym_DASH_GT_GT] = ACTIONS(169),
    [anon_sym_PIPE] = ACTIONS(171),
    [anon_sym_AMP] = ACTIONS(173),
    [anon_sym_PIPE_PIPE] = ACTIONS(175),
    [anon_sym_AMP_AMP] = ACTIONS(177),
    [anon_sym_LT] = ACTIONS(179),
    [anon_sym_LT_EQ] = ACTIONS(181),
    [anon_sym_GT] = ACTIONS(179),
    [anon_sym_GT_EQ] = ACTIONS(181),
    [anon_sym_EQ_EQ] = ACTIONS(181),
    [anon_sym_BANG_EQ] = ACTIONS(181),
    [anon_sym_STAR] = ACTIONS(183),
    [anon_sym_SLASH] = ACTIONS(185),
    [anon_sym_STAR_STAR] = ACTIONS(187),
    [anon_sym_CARET] = ACTIONS(187),
    [aux_sym_binary_operator_token1] = ACTIONS(189),
    [anon_sym_PIPE_GT] = ACTIONS(189),
    [anon_sym_COLON] = ACTIONS(191),
    [anon_sym_DOLLAR] = ACTIONS(193),
    [anon_sym_AT] = ACTIONS(193),
    [aux_sym__hex_literal_token1] = ACTIONS(101),
    [sym__number_literal] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_DQUOTE] = ACTIONS(101),
    [sym_return] = ACTIONS(103),
    [sym_next] = ACTIONS(103),
    [sym_break] = ACTIONS(103),
    [sym_true] = ACTIONS(103),
    [sym_false] = ACTIONS(103),
    [sym_null] = ACTIONS(103),
    [sym_inf] = ACTIONS(103),
    [sym_nan] = ACTIONS(103),
    [anon_sym_NA] = ACTIONS(103),
    [anon_sym_NA_integer_] = ACTIONS(103),
    [anon_sym_NA_real_] = ACTIONS(103),
    [anon_sym_NA_complex_] = ACTIONS(103),
    [anon_sym_NA_character_] = ACTIONS(103),
    [sym_dots] = ACTIONS(103),
    [sym_dot_dot_i] = ACTIONS(101),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(101),
    [sym__newline] = ACTIONS(101),
    [sym__raw_string_literal] = ACTIONS(101),
    [sym__external_else] = ACTIONS(211),
    [sym__external_open_parenthesis] = ACTIONS(197),
    [sym__external_close_parenthesis] = ACTIONS(101),
    [sym__external_open_brace] = ACTIONS(101),
    [sym__external_open_bracket] = ACTIONS(199),
    [sym__external_open_bracket2] = ACTIONS(201),
  },
  [9] = {
    [sym_call_arguments] = STATE(850),
    [sym_subset_arguments] = STATE(851),
    [sym_subset2_arguments] = STATE(852),
    [sym__else] = STATE(1639),
    [sym__open_parenthesis] = STATE(349),
    [sym__open_bracket] = STATE(350),
    [sym__open_bracket2] = STATE(351),
    [sym_identifier] = ACTIONS(153),
    [anon_sym_BSLASH] = ACTIONS(155),
    [anon_sym_function] = ACTIONS(153),
    [anon_sym_EQ] = ACTIONS(213),
    [anon_sym_if] = ACTIONS(153),
    [anon_sym_for] = ACTIONS(153),
    [anon_sym_while] = ACTIONS(153),
    [anon_sym_repeat] = ACTIONS(153),
    [anon_sym_QMARK] = ACTIONS(155),
    [anon_sym_TILDE] = ACTIONS(215),
    [anon_sym_BANG] = ACTIONS(153),
    [anon_sym_PLUS] = ACTIONS(217),
    [anon_sym_DASH] = ACTIONS(219),
    [anon_sym_LT_DASH] = ACTIONS(221),
    [anon_sym_LT_LT_DASH] = ACTIONS(221),
    [anon_sym_COLON_EQ] = ACTIONS(221),
    [anon_sym_DASH_GT] = ACTIONS(223),
    [anon_sym_DASH_GT_GT] = ACTIONS(225),
    [anon_sym_PIPE] = ACTIONS(227),
    [anon_sym_AMP] = ACTIONS(229),
    [anon_sym_PIPE_PIPE] = ACTIONS(231),
    [anon_sym_AMP_AMP] = ACTIONS(233),
    [anon_sym_LT] = ACTIONS(235),
    [anon_sym_LT_EQ] = ACTIONS(237),
    [anon_sym_GT] = ACTIONS(235),
    [anon_sym_GT_EQ] = ACTIONS(237),
    [anon_sym_EQ_EQ] = ACTIONS(237),
    [anon_sym_BANG_EQ] = ACTIONS(237),
    [anon_sym_STAR] = ACTIONS(239),
    [anon_sym_SLASH] = ACTIONS(241),
    [anon_sym_STAR_STAR] = ACTIONS(243),
    [anon_sym_CARET] = ACTIONS(243),
    [aux_sym_binary_operator_token1] = ACTIONS(245),
    [anon_sym_PIPE_GT] = ACTIONS(245),
    [anon_sym_COLON] = ACTIONS(247),
    [anon_sym_DOLLAR] = ACTIONS(249),
    [anon_sym_AT] = ACTIONS(249),
    [aux_sym__hex_literal_token1] = ACTIONS(155),
    [sym__number_literal] = ACTIONS(153),
    [anon_sym_SQUOTE] = ACTIONS(155),
    [anon_sym_DQUOTE] = ACTIONS(155),
    [sym_return] = ACTIONS(153),
    [sym_next] = ACTIONS(153),
    [sym_break] = ACTIONS(153),
    [sym_true] = ACTIONS(153),
    [sym_false] = ACTIONS(153),
    [sym_null] = ACTIONS(153),
    [sym_inf] = ACTIONS(153),
    [sym_nan] = ACTIONS(153),
    [anon_sym_NA] = ACTIONS(153),
    [anon_sym_NA_integer_] = ACTIONS(153),
    [anon_sym_NA_real_] = ACTIONS(153),
    [anon_sym_NA_complex_] = ACTIONS(153),
    [anon_sym_NA_character_] = ACTIONS(153),
    [sym_dots] = ACTIONS(153),
    [sym_dot_dot_i] = ACTIONS(155),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(155),
    [sym__semicolon] = ACTIONS(155),
    [sym__raw_string_literal] = ACTIONS(155),
    [sym__external_else] = ACTIONS(251),
    [sym__external_open_parenthesis] = ACTIONS(253),
    [sym__external_open_brace] = ACTIONS(155),
    [sym__external_close_brace] = ACTIONS(155),
    [sym__external_open_bracket] = ACTIONS(255),
    [sym__external_open_bracket2] = ACTIONS(257),
  },
  [10] = {
    [sym_call_arguments] = STATE(850),
    [sym_subset_arguments] = STATE(851),
    [sym_subset2_arguments] = STATE(852),
    [sym__else] = STATE(1646),
    [sym__open_parenthesis] = STATE(349),
    [sym__open_bracket] = STATE(350),
    [sym__open_bracket2] = STATE(351),
    [sym_identifier] = ACTIONS(51),
    [anon_sym_BSLASH] = ACTIONS(53),
    [anon_sym_function] = ACTIONS(51),
    [anon_sym_EQ] = ACTIONS(213),
    [anon_sym_if] = ACTIONS(51),
    [anon_sym_for] = ACTIONS(51),
    [anon_sym_while] = ACTIONS(51),
    [anon_sym_repeat] = ACTIONS(51),
    [anon_sym_QMARK] = ACTIONS(53),
    [anon_sym_TILDE] = ACTIONS(215),
    [anon_sym_BANG] = ACTIONS(51),
    [anon_sym_PLUS] = ACTIONS(217),
    [anon_sym_DASH] = ACTIONS(219),
    [anon_sym_LT_DASH] = ACTIONS(221),
    [anon_sym_LT_LT_DASH] = ACTIONS(221),
    [anon_sym_COLON_EQ] = ACTIONS(221),
    [anon_sym_DASH_GT] = ACTIONS(223),
    [anon_sym_DASH_GT_GT] = ACTIONS(225),
    [anon_sym_PIPE] = ACTIONS(227),
    [anon_sym_AMP] = ACTIONS(229),
    [anon_sym_PIPE_PIPE] = ACTIONS(231),
    [anon_sym_AMP_AMP] = ACTIONS(233),
    [anon_sym_LT] = ACTIONS(235),
    [anon_sym_LT_EQ] = ACTIONS(237),
    [anon_sym_GT] = ACTIONS(235),
    [anon_sym_GT_EQ] = ACTIONS(237),
    [anon_sym_EQ_EQ] = ACTIONS(237),
    [anon_sym_BANG_EQ] = ACTIONS(237),
    [anon_sym_STAR] = ACTIONS(239),
    [anon_sym_SLASH] = ACTIONS(241),
    [anon_sym_STAR_STAR] = ACTIONS(243),
    [anon_sym_CARET] = ACTIONS(243),
    [aux_sym_binary_operator_token1] = ACTIONS(245),
    [anon_sym_PIPE_GT] = ACTIONS(245),
    [anon_sym_COLON] = ACTIONS(247),
    [anon_sym_DOLLAR] = ACTIONS(249),
    [anon_sym_AT] = ACTIONS(249),
    [aux_sym__hex_literal_token1] = ACTIONS(53),
    [sym__number_literal] = ACTIONS(51),
    [anon_sym_SQUOTE] = ACTIONS(53),
    [anon_sym_DQUOTE] = ACTIONS(53),
    [sym_return] = ACTIONS(51),
    [sym_next] = ACTIONS(51),
    [sym_break] = ACTIONS(51),
    [sym_true] = ACTIONS(51),
    [sym_false] = ACTIONS(51),
    [sym_null] = ACTIONS(51),
    [sym_inf] = ACTIONS(51),
    [sym_nan] = ACTIONS(51),
    [anon_sym_NA] = ACTIONS(51),
    [anon_sym_NA_integer_] = ACTIONS(51),
    [anon_sym_NA_real_] = ACTIONS(51),
    [anon_sym_NA_complex_] = ACTIONS(51),
    [anon_sym_NA_character_] = ACTIONS(51),
    [sym_dots] = ACTIONS(51),
    [sym_dot_dot_i] = ACTIONS(53),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(53),
    [sym__semicolon] = ACTIONS(53),
    [sym__raw_string_literal] = ACTIONS(53),
    [sym__external_else] = ACTIONS(259),
    [sym__external_open_parenthesis] = ACTIONS(253),
    [sym__external_open_brace] = ACTIONS(53),
    [sym__external_close_brace] = ACTIONS(53),
    [sym__external_open_bracket] = ACTIONS(255),
    [sym__external_open_bracket2] = ACTIONS(257),
  },
  [11] = {
    [sym_call_arguments] = STATE(850),
    [sym_subset_arguments] = STATE(851),
    [sym_subset2_arguments] = STATE(852),
    [sym__else] = STATE(1647),
    [sym__open_parenthesis] = STATE(349),
    [sym__open_bracket] = STATE(350),
    [sym__open_bracket2] = STATE(351),
    [sym_identifier] = ACTIONS(205),
    [anon_sym_BSLASH] = ACTIONS(207),
    [anon_sym_function] = ACTIONS(205),
    [anon_sym_EQ] = ACTIONS(213),
    [anon_sym_if] = ACTIONS(205),
    [anon_sym_for] = ACTIONS(205),
    [anon_sym_while] = ACTIONS(205),
    [anon_sym_repeat] = ACTIONS(205),
    [anon_sym_QMARK] = ACTIONS(207),
    [anon_sym_TILDE] = ACTIONS(215),
    [anon_sym_BANG] = ACTIONS(205),
    [anon_sym_PLUS] = ACTIONS(217),
    [anon_sym_DASH] = ACTIONS(219),
    [anon_sym_LT_DASH] = ACTIONS(221),
    [anon_sym_LT_LT_DASH] = ACTIONS(221),
    [anon_sym_COLON_EQ] = ACTIONS(221),
    [anon_sym_DASH_GT] = ACTIONS(223),
    [anon_sym_DASH_GT_GT] = ACTIONS(225),
    [anon_sym_PIPE] = ACTIONS(227),
    [anon_sym_AMP] = ACTIONS(229),
    [anon_sym_PIPE_PIPE] = ACTIONS(231),
    [anon_sym_AMP_AMP] = ACTIONS(233),
    [anon_sym_LT] = ACTIONS(235),
    [anon_sym_LT_EQ] = ACTIONS(237),
    [anon_sym_GT] = ACTIONS(235),
    [anon_sym_GT_EQ] = ACTIONS(237),
    [anon_sym_EQ_EQ] = ACTIONS(237),
    [anon_sym_BANG_EQ] = ACTIONS(237),
    [anon_sym_STAR] = ACTIONS(239),
    [anon_sym_SLASH] = ACTIONS(241),
    [anon_sym_STAR_STAR] = ACTIONS(243),
    [anon_sym_CARET] = ACTIONS(243),
    [aux_sym_binary_operator_token1] = ACTIONS(245),
    [anon_sym_PIPE_GT] = ACTIONS(245),
    [anon_sym_COLON] = ACTIONS(247),
    [anon_sym_DOLLAR] = ACTIONS(249),
    [anon_sym_AT] = ACTIONS(249),
    [aux_sym__hex_literal_token1] = ACTIONS(207),
    [sym__number_literal] = ACTIONS(205),
    [anon_sym_SQUOTE] = ACTIONS(207),
    [anon_sym_DQUOTE] = ACTIONS(207),
    [sym_return] = ACTIONS(205),
    [sym_next] = ACTIONS(205),
    [sym_break] = ACTIONS(205),
    [sym_true] = ACTIONS(205),
    [sym_false] = ACTIONS(205),
    [sym_null] = ACTIONS(205),
    [sym_inf] = ACTIONS(205),
    [sym_nan] = ACTIONS(205),
    [anon_sym_NA] = ACTIONS(205),
    [anon_sym_NA_integer_] = ACTIONS(205),
    [anon_sym_NA_real_] = ACTIONS(205),
    [anon_sym_NA_complex_] = ACTIONS(205),
    [anon_sym_NA_character_] = ACTIONS(205),
    [sym_dots] = ACTIONS(205),
    [sym_dot_dot_i] = ACTIONS(207),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(207),
    [sym__semicolon] = ACTIONS(207),
    [sym__raw_string_literal] = ACTIONS(207),
    [sym__external_else] = ACTIONS(261),
    [sym__external_open_parenthesis] = ACTIONS(253),
    [sym__external_open_brace] = ACTIONS(207),
    [sym__external_close_brace] = ACTIONS(207),
    [sym__external_open_bracket] = ACTIONS(255),
    [sym__external_open_bracket2] = ACTIONS(257),
  },
  [12] = {
    [sym_call_arguments] = STATE(850),
    [sym_subset_arguments] = STATE(851),
    [sym_subset2_arguments] = STATE(852),
    [sym__else] = STATE(1606),
    [sym__open_parenthesis] = STATE(349),
    [sym__open_bracket] = STATE(350),
    [sym__open_bracket2] = STATE(351),
    [sym_identifier] = ACTIONS(103),
    [anon_sym_BSLASH] = ACTIONS(101),
    [anon_sym_function] = ACTIONS(103),
    [anon_sym_EQ] = ACTIONS(213),
    [anon_sym_if] = ACTIONS(103),
    [anon_sym_for] = ACTIONS(103),
    [anon_sym_while] = ACTIONS(103),
    [anon_sym_repeat] = ACTIONS(103),
    [anon_sym_QMARK] = ACTIONS(101),
    [anon_sym_TILDE] = ACTIONS(215),
    [anon_sym_BANG] = ACTIONS(103),
    [anon_sym_PLUS] = ACTIONS(217),
    [anon_sym_DASH] = ACTIONS(219),
    [anon_sym_LT_DASH] = ACTIONS(221),
    [anon_sym_LT_LT_DASH] = ACTIONS(221),
    [anon_sym_COLON_EQ] = ACTIONS(221),
    [anon_sym_DASH_GT] = ACTIONS(223),
    [anon_sym_DASH_GT_GT] = ACTIONS(225),
    [anon_sym_PIPE] = ACTIONS(227),
    [anon_sym_AMP] = ACTIONS(229),
    [anon_sym_PIPE_PIPE] = ACTIONS(231),
    [anon_sym_AMP_AMP] = ACTIONS(233),
    [anon_sym_LT] = ACTIONS(235),
    [anon_sym_LT_EQ] = ACTIONS(237),
    [anon_sym_GT] = ACTIONS(235),
    [anon_sym_GT_EQ] = ACTIONS(237),
    [anon_sym_EQ_EQ] = ACTIONS(237),
    [anon_sym_BANG_EQ] = ACTIONS(237),
    [anon_sym_STAR] = ACTIONS(239),
    [anon_sym_SLASH] = ACTIONS(241),
    [anon_sym_STAR_STAR] = ACTIONS(243),
    [anon_sym_CARET] = ACTIONS(243),
    [aux_sym_binary_operator_token1] = ACTIONS(245),
    [anon_sym_PIPE_GT] = ACTIONS(245),
    [anon_sym_COLON] = ACTIONS(247),
    [anon_sym_DOLLAR] = ACTIONS(249),
    [anon_sym_AT] = ACTIONS(249),
    [aux_sym__hex_literal_token1] = ACTIONS(101),
    [sym__number_literal] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_DQUOTE] = ACTIONS(101),
    [sym_return] = ACTIONS(103),
    [sym_next] = ACTIONS(103),
    [sym_break] = ACTIONS(103),
    [sym_true] = ACTIONS(103),
    [sym_false] = ACTIONS(103),
    [sym_null] = ACTIONS(103),
    [sym_inf] = ACTIONS(103),
    [sym_nan] = ACTIONS(103),
    [anon_sym_NA] = ACTIONS(103),
    [anon_sym_NA_integer_] = ACTIONS(103),
    [anon_sym_NA_real_] = ACTIONS(103),
    [anon_sym_NA_complex_] = ACTIONS(103),
    [anon_sym_NA_character_] = ACTIONS(103),
    [sym_dots] = ACTIONS(103),
    [sym_dot_dot_i] = ACTIONS(101),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(101),
    [sym__semicolon] = ACTIONS(101),
    [sym__raw_string_literal] = ACTIONS(101),
    [sym__external_else] = ACTIONS(263),
    [sym__external_open_parenthesis] = ACTIONS(253),
    [sym__external_open_brace] = ACTIONS(101),
    [sym__external_close_brace] = ACTIONS(101),
    [sym__external_open_bracket] = ACTIONS(255),
    [sym__external_open_bracket2] = ACTIONS(257),
  },
  [13] = {
    [sym_call_arguments] = STATE(807),
    [sym_subset_arguments] = STATE(808),
    [sym_subset2_arguments] = STATE(810),
    [sym__else] = STATE(1631),
    [sym__open_parenthesis] = STATE(357),
    [sym__open_bracket] = STATE(358),
    [sym__open_bracket2] = STATE(359),
    [sym_identifier] = ACTIONS(153),
    [anon_sym_BSLASH] = ACTIONS(155),
    [anon_sym_function] = ACTIONS(153),
    [anon_sym_EQ] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(153),
    [anon_sym_for] = ACTIONS(153),
    [anon_sym_while] = ACTIONS(153),
    [anon_sym_repeat] = ACTIONS(153),
    [anon_sym_QMARK] = ACTIONS(155),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_BANG] = ACTIONS(153),
    [anon_sym_PLUS] = ACTIONS(59),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_LT_DASH] = ACTIONS(63),
    [anon_sym_LT_LT_DASH] = ACTIONS(63),
    [anon_sym_COLON_EQ] = ACTIONS(63),
    [anon_sym_DASH_GT] = ACTIONS(65),
    [anon_sym_DASH_GT_GT] = ACTIONS(67),
    [anon_sym_PIPE] = ACTIONS(69),
    [anon_sym_AMP] = ACTIONS(71),
    [anon_sym_PIPE_PIPE] = ACTIONS(73),
    [anon_sym_AMP_AMP] = ACTIONS(75),
    [anon_sym_LT] = ACTIONS(77),
    [anon_sym_LT_EQ] = ACTIONS(79),
    [anon_sym_GT] = ACTIONS(77),
    [anon_sym_GT_EQ] = ACTIONS(79),
    [anon_sym_EQ_EQ] = ACTIONS(79),
    [anon_sym_BANG_EQ] = ACTIONS(79),
    [anon_sym_STAR] = ACTIONS(81),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_STAR_STAR] = ACTIONS(85),
    [anon_sym_CARET] = ACTIONS(85),
    [aux_sym_binary_operator_token1] = ACTIONS(87),
    [anon_sym_PIPE_GT] = ACTIONS(87),
    [anon_sym_COLON] = ACTIONS(89),
    [anon_sym_DOLLAR] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(91),
    [aux_sym__hex_literal_token1] = ACTIONS(155),
    [sym__number_literal] = ACTIONS(153),
    [anon_sym_SQUOTE] = ACTIONS(155),
    [anon_sym_DQUOTE] = ACTIONS(155),
    [sym_return] = ACTIONS(153),
    [sym_next] = ACTIONS(153),
    [sym_break] = ACTIONS(153),
    [sym_true] = ACTIONS(153),
    [sym_false] = ACTIONS(153),
    [sym_null] = ACTIONS(153),
    [sym_inf] = ACTIONS(153),
    [sym_nan] = ACTIONS(153),
    [anon_sym_NA] = ACTIONS(153),
    [anon_sym_NA_integer_] = ACTIONS(153),
    [anon_sym_NA_real_] = ACTIONS(153),
    [anon_sym_NA_complex_] = ACTIONS(153),
    [anon_sym_NA_character_] = ACTIONS(153),
    [sym_dots] = ACTIONS(153),
    [sym_dot_dot_i] = ACTIONS(155),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(155),
    [sym__newline] = ACTIONS(155),
    [sym__raw_string_literal] = ACTIONS(155),
    [sym__external_else] = ACTIONS(265),
    [sym__external_open_parenthesis] = ACTIONS(95),
    [sym__external_open_brace] = ACTIONS(155),
    [sym__external_open_bracket] = ACTIONS(97),
    [sym__external_close_bracket] = ACTIONS(155),
    [sym__external_open_bracket2] = ACTIONS(99),
  },
  [14] = {
    [sym_call_arguments] = STATE(807),
    [sym_subset_arguments] = STATE(808),
    [sym_subset2_arguments] = STATE(810),
    [sym__else] = STATE(1635),
    [sym__open_parenthesis] = STATE(357),
    [sym__open_bracket] = STATE(358),
    [sym__open_bracket2] = STATE(359),
    [sym_identifier] = ACTIONS(51),
    [anon_sym_BSLASH] = ACTIONS(53),
    [anon_sym_function] = ACTIONS(51),
    [anon_sym_EQ] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(51),
    [anon_sym_for] = ACTIONS(51),
    [anon_sym_while] = ACTIONS(51),
    [anon_sym_repeat] = ACTIONS(51),
    [anon_sym_QMARK] = ACTIONS(53),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_BANG] = ACTIONS(51),
    [anon_sym_PLUS] = ACTIONS(59),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_LT_DASH] = ACTIONS(63),
    [anon_sym_LT_LT_DASH] = ACTIONS(63),
    [anon_sym_COLON_EQ] = ACTIONS(63),
    [anon_sym_DASH_GT] = ACTIONS(65),
    [anon_sym_DASH_GT_GT] = ACTIONS(67),
    [anon_sym_PIPE] = ACTIONS(69),
    [anon_sym_AMP] = ACTIONS(71),
    [anon_sym_PIPE_PIPE] = ACTIONS(73),
    [anon_sym_AMP_AMP] = ACTIONS(75),
    [anon_sym_LT] = ACTIONS(77),
    [anon_sym_LT_EQ] = ACTIONS(79),
    [anon_sym_GT] = ACTIONS(77),
    [anon_sym_GT_EQ] = ACTIONS(79),
    [anon_sym_EQ_EQ] = ACTIONS(79),
    [anon_sym_BANG_EQ] = ACTIONS(79),
    [anon_sym_STAR] = ACTIONS(81),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_STAR_STAR] = ACTIONS(85),
    [anon_sym_CARET] = ACTIONS(85),
    [aux_sym_binary_operator_token1] = ACTIONS(87),
    [anon_sym_PIPE_GT] = ACTIONS(87),
    [anon_sym_COLON] = ACTIONS(89),
    [anon_sym_DOLLAR] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(91),
    [aux_sym__hex_literal_token1] = ACTIONS(53),
    [sym__number_literal] = ACTIONS(51),
    [anon_sym_SQUOTE] = ACTIONS(53),
    [anon_sym_DQUOTE] = ACTIONS(53),
    [sym_return] = ACTIONS(51),
    [sym_next] = ACTIONS(51),
    [sym_break] = ACTIONS(51),
    [sym_true] = ACTIONS(51),
    [sym_false] = ACTIONS(51),
    [sym_null] = ACTIONS(51),
    [sym_inf] = ACTIONS(51),
    [sym_nan] = ACTIONS(51),
    [anon_sym_NA] = ACTIONS(51),
    [anon_sym_NA_integer_] = ACTIONS(51),
    [anon_sym_NA_real_] = ACTIONS(51),
    [anon_sym_NA_complex_] = ACTIONS(51),
    [anon_sym_NA_character_] = ACTIONS(51),
    [sym_dots] = ACTIONS(51),
    [sym_dot_dot_i] = ACTIONS(53),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(53),
    [sym__newline] = ACTIONS(53),
    [sym__raw_string_literal] = ACTIONS(53),
    [sym__external_else] = ACTIONS(267),
    [sym__external_open_parenthesis] = ACTIONS(95),
    [sym__external_open_brace] = ACTIONS(53),
    [sym__external_open_bracket] = ACTIONS(97),
    [sym__external_close_bracket] = ACTIONS(53),
    [sym__external_open_bracket2] = ACTIONS(99),
  },
  [15] = {
    [sym_call_arguments] = STATE(807),
    [sym_subset_arguments] = STATE(808),
    [sym_subset2_arguments] = STATE(810),
    [sym__else] = STATE(1599),
    [sym__open_parenthesis] = STATE(357),
    [sym__open_bracket] = STATE(358),
    [sym__open_bracket2] = STATE(359),
    [sym_identifier] = ACTIONS(205),
    [anon_sym_BSLASH] = ACTIONS(207),
    [anon_sym_function] = ACTIONS(205),
    [anon_sym_EQ] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(205),
    [anon_sym_for] = ACTIONS(205),
    [anon_sym_while] = ACTIONS(205),
    [anon_sym_repeat] = ACTIONS(205),
    [anon_sym_QMARK] = ACTIONS(207),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_BANG] = ACTIONS(205),
    [anon_sym_PLUS] = ACTIONS(59),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_LT_DASH] = ACTIONS(63),
    [anon_sym_LT_LT_DASH] = ACTIONS(63),
    [anon_sym_COLON_EQ] = ACTIONS(63),
    [anon_sym_DASH_GT] = ACTIONS(65),
    [anon_sym_DASH_GT_GT] = ACTIONS(67),
    [anon_sym_PIPE] = ACTIONS(69),
    [anon_sym_AMP] = ACTIONS(71),
    [anon_sym_PIPE_PIPE] = ACTIONS(73),
    [anon_sym_AMP_AMP] = ACTIONS(75),
    [anon_sym_LT] = ACTIONS(77),
    [anon_sym_LT_EQ] = ACTIONS(79),
    [anon_sym_GT] = ACTIONS(77),
    [anon_sym_GT_EQ] = ACTIONS(79),
    [anon_sym_EQ_EQ] = ACTIONS(79),
    [anon_sym_BANG_EQ] = ACTIONS(79),
    [anon_sym_STAR] = ACTIONS(81),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_STAR_STAR] = ACTIONS(85),
    [anon_sym_CARET] = ACTIONS(85),
    [aux_sym_binary_operator_token1] = ACTIONS(87),
    [anon_sym_PIPE_GT] = ACTIONS(87),
    [anon_sym_COLON] = ACTIONS(89),
    [anon_sym_DOLLAR] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(91),
    [aux_sym__hex_literal_token1] = ACTIONS(207),
    [sym__number_literal] = ACTIONS(205),
    [anon_sym_SQUOTE] = ACTIONS(207),
    [anon_sym_DQUOTE] = ACTIONS(207),
    [sym_return] = ACTIONS(205),
    [sym_next] = ACTIONS(205),
    [sym_break] = ACTIONS(205),
    [sym_true] = ACTIONS(205),
    [sym_false] = ACTIONS(205),
    [sym_null] = ACTIONS(205),
    [sym_inf] = ACTIONS(205),
    [sym_nan] = ACTIONS(205),
    [anon_sym_NA] = ACTIONS(205),
    [anon_sym_NA_integer_] = ACTIONS(205),
    [anon_sym_NA_real_] = ACTIONS(205),
    [anon_sym_NA_complex_] = ACTIONS(205),
    [anon_sym_NA_character_] = ACTIONS(205),
    [sym_dots] = ACTIONS(205),
    [sym_dot_dot_i] = ACTIONS(207),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(207),
    [sym__newline] = ACTIONS(207),
    [sym__raw_string_literal] = ACTIONS(207),
    [sym__external_else] = ACTIONS(269),
    [sym__external_open_parenthesis] = ACTIONS(95),
    [sym__external_open_brace] = ACTIONS(207),
    [sym__external_open_bracket] = ACTIONS(97),
    [sym__external_close_bracket] = ACTIONS(207),
    [sym__external_open_bracket2] = ACTIONS(99),
  },
  [16] = {
    [sym_call_arguments] = STATE(807),
    [sym_subset_arguments] = STATE(808),
    [sym_subset2_arguments] = STATE(810),
    [sym__else] = STATE(1642),
    [sym__open_parenthesis] = STATE(357),
    [sym__open_bracket] = STATE(358),
    [sym__open_bracket2] = STATE(359),
    [sym_identifier] = ACTIONS(103),
    [anon_sym_BSLASH] = ACTIONS(101),
    [anon_sym_function] = ACTIONS(103),
    [anon_sym_EQ] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(103),
    [anon_sym_for] = ACTIONS(103),
    [anon_sym_while] = ACTIONS(103),
    [anon_sym_repeat] = ACTIONS(103),
    [anon_sym_QMARK] = ACTIONS(101),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_BANG] = ACTIONS(103),
    [anon_sym_PLUS] = ACTIONS(59),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_LT_DASH] = ACTIONS(63),
    [anon_sym_LT_LT_DASH] = ACTIONS(63),
    [anon_sym_COLON_EQ] = ACTIONS(63),
    [anon_sym_DASH_GT] = ACTIONS(65),
    [anon_sym_DASH_GT_GT] = ACTIONS(67),
    [anon_sym_PIPE] = ACTIONS(69),
    [anon_sym_AMP] = ACTIONS(71),
    [anon_sym_PIPE_PIPE] = ACTIONS(73),
    [anon_sym_AMP_AMP] = ACTIONS(75),
    [anon_sym_LT] = ACTIONS(77),
    [anon_sym_LT_EQ] = ACTIONS(79),
    [anon_sym_GT] = ACTIONS(77),
    [anon_sym_GT_EQ] = ACTIONS(79),
    [anon_sym_EQ_EQ] = ACTIONS(79),
    [anon_sym_BANG_EQ] = ACTIONS(79),
    [anon_sym_STAR] = ACTIONS(81),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_STAR_STAR] = ACTIONS(85),
    [anon_sym_CARET] = ACTIONS(85),
    [aux_sym_binary_operator_token1] = ACTIONS(87),
    [anon_sym_PIPE_GT] = ACTIONS(87),
    [anon_sym_COLON] = ACTIONS(89),
    [anon_sym_DOLLAR] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(91),
    [aux_sym__hex_literal_token1] = ACTIONS(101),
    [sym__number_literal] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_DQUOTE] = ACTIONS(101),
    [sym_return] = ACTIONS(103),
    [sym_next] = ACTIONS(103),
    [sym_break] = ACTIONS(103),
    [sym_true] = ACTIONS(103),
    [sym_false] = ACTIONS(103),
    [sym_null] = ACTIONS(103),
    [sym_inf] = ACTIONS(103),
    [sym_nan] = ACTIONS(103),
    [anon_sym_NA] = ACTIONS(103),
    [anon_sym_NA_integer_] = ACTIONS(103),
    [anon_sym_NA_real_] = ACTIONS(103),
    [anon_sym_NA_complex_] = ACTIONS(103),
    [anon_sym_NA_character_] = ACTIONS(103),
    [sym_dots] = ACTIONS(103),
    [sym_dot_dot_i] = ACTIONS(101),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(101),
    [sym__newline] = ACTIONS(101),
    [sym__raw_string_literal] = ACTIONS(101),
    [sym__external_else] = ACTIONS(271),
    [sym__external_open_parenthesis] = ACTIONS(95),
    [sym__external_open_brace] = ACTIONS(101),
    [sym__external_open_bracket] = ACTIONS(97),
    [sym__external_close_bracket] = ACTIONS(101),
    [sym__external_open_bracket2] = ACTIONS(99),
  },
  [17] = {
    [sym_call_arguments] = STATE(795),
    [sym_subset_arguments] = STATE(796),
    [sym_subset2_arguments] = STATE(797),
    [sym__else] = STATE(1617),
    [sym__open_parenthesis] = STATE(361),
    [sym__open_bracket] = STATE(362),
    [sym__open_bracket2] = STATE(199),
    [sym_identifier] = ACTIONS(153),
    [anon_sym_BSLASH] = ACTIONS(155),
    [anon_sym_function] = ACTIONS(153),
    [anon_sym_EQ] = ACTIONS(273),
    [anon_sym_if] = ACTIONS(153),
    [anon_sym_for] = ACTIONS(153),
    [anon_sym_while] = ACTIONS(153),
    [anon_sym_repeat] = ACTIONS(153),
    [anon_sym_QMARK] = ACTIONS(155),
    [anon_sym_TILDE] = ACTIONS(275),
    [anon_sym_BANG] = ACTIONS(153),
    [anon_sym_PLUS] = ACTIONS(277),
    [anon_sym_DASH] = ACTIONS(279),
    [anon_sym_LT_DASH] = ACTIONS(281),
    [anon_sym_LT_LT_DASH] = ACTIONS(281),
    [anon_sym_COLON_EQ] = ACTIONS(281),
    [anon_sym_DASH_GT] = ACTIONS(283),
    [anon_sym_DASH_GT_GT] = ACTIONS(285),
    [anon_sym_PIPE] = ACTIONS(287),
    [anon_sym_AMP] = ACTIONS(289),
    [anon_sym_PIPE_PIPE] = ACTIONS(291),
    [anon_sym_AMP_AMP] = ACTIONS(293),
    [anon_sym_LT] = ACTIONS(295),
    [anon_sym_LT_EQ] = ACTIONS(297),
    [anon_sym_GT] = ACTIONS(295),
    [anon_sym_GT_EQ] = ACTIONS(297),
    [anon_sym_EQ_EQ] = ACTIONS(297),
    [anon_sym_BANG_EQ] = ACTIONS(297),
    [anon_sym_STAR] = ACTIONS(299),
    [anon_sym_SLASH] = ACTIONS(301),
    [anon_sym_STAR_STAR] = ACTIONS(303),
    [anon_sym_CARET] = ACTIONS(303),
    [aux_sym_binary_operator_token1] = ACTIONS(305),
    [anon_sym_PIPE_GT] = ACTIONS(305),
    [anon_sym_COLON] = ACTIONS(307),
    [anon_sym_DOLLAR] = ACTIONS(309),
    [anon_sym_AT] = ACTIONS(309),
    [aux_sym__hex_literal_token1] = ACTIONS(155),
    [sym__number_literal] = ACTIONS(153),
    [anon_sym_SQUOTE] = ACTIONS(155),
    [anon_sym_DQUOTE] = ACTIONS(155),
    [sym_return] = ACTIONS(153),
    [sym_next] = ACTIONS(153),
    [sym_break] = ACTIONS(153),
    [sym_true] = ACTIONS(153),
    [sym_false] = ACTIONS(153),
    [sym_null] = ACTIONS(153),
    [sym_inf] = ACTIONS(153),
    [sym_nan] = ACTIONS(153),
    [anon_sym_NA] = ACTIONS(153),
    [anon_sym_NA_integer_] = ACTIONS(153),
    [anon_sym_NA_real_] = ACTIONS(153),
    [anon_sym_NA_complex_] = ACTIONS(153),
    [anon_sym_NA_character_] = ACTIONS(153),
    [sym_dots] = ACTIONS(153),
    [sym_dot_dot_i] = ACTIONS(155),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(155),
    [sym__newline] = ACTIONS(155),
    [sym__raw_string_literal] = ACTIONS(155),
    [sym__external_else] = ACTIONS(311),
    [sym__external_open_parenthesis] = ACTIONS(313),
    [sym__external_open_brace] = ACTIONS(155),
    [sym__external_open_bracket] = ACTIONS(315),
    [sym__external_open_bracket2] = ACTIONS(317),
    [sym__external_close_bracket2] = ACTIONS(155),
  },
  [18] = {
    [sym_call_arguments] = STATE(862),
    [sym_subset_arguments] = STATE(885),
    [sym_subset2_arguments] = STATE(900),
    [sym__else] = STATE(1626),
    [sym__open_parenthesis] = STATE(341),
    [sym__open_bracket] = STATE(342),
    [sym__open_bracket2] = STATE(343),
    [ts_builtin_sym_end] = ACTIONS(155),
    [sym_identifier] = ACTIONS(153),
    [anon_sym_BSLASH] = ACTIONS(155),
    [anon_sym_function] = ACTIONS(153),
    [anon_sym_EQ] = ACTIONS(105),
    [anon_sym_if] = ACTIONS(153),
    [anon_sym_for] = ACTIONS(153),
    [anon_sym_while] = ACTIONS(153),
    [anon_sym_repeat] = ACTIONS(153),
    [anon_sym_QMARK] = ACTIONS(155),
    [anon_sym_TILDE] = ACTIONS(107),
    [anon_sym_BANG] = ACTIONS(153),
    [anon_sym_PLUS] = ACTIONS(109),
    [anon_sym_DASH] = ACTIONS(111),
    [anon_sym_LT_DASH] = ACTIONS(113),
    [anon_sym_LT_LT_DASH] = ACTIONS(113),
    [anon_sym_COLON_EQ] = ACTIONS(113),
    [anon_sym_DASH_GT] = ACTIONS(115),
    [anon_sym_DASH_GT_GT] = ACTIONS(117),
    [anon_sym_PIPE] = ACTIONS(119),
    [anon_sym_AMP] = ACTIONS(121),
    [anon_sym_PIPE_PIPE] = ACTIONS(123),
    [anon_sym_AMP_AMP] = ACTIONS(125),
    [anon_sym_LT] = ACTIONS(127),
    [anon_sym_LT_EQ] = ACTIONS(129),
    [anon_sym_GT] = ACTIONS(127),
    [anon_sym_GT_EQ] = ACTIONS(129),
    [anon_sym_EQ_EQ] = ACTIONS(129),
    [anon_sym_BANG_EQ] = ACTIONS(129),
    [anon_sym_STAR] = ACTIONS(131),
    [anon_sym_SLASH] = ACTIONS(133),
    [anon_sym_STAR_STAR] = ACTIONS(135),
    [anon_sym_CARET] = ACTIONS(135),
    [aux_sym_binary_operator_token1] = ACTIONS(137),
    [anon_sym_PIPE_GT] = ACTIONS(137),
    [anon_sym_COLON] = ACTIONS(139),
    [anon_sym_DOLLAR] = ACTIONS(141),
    [anon_sym_AT] = ACTIONS(141),
    [aux_sym__hex_literal_token1] = ACTIONS(155),
    [sym__number_literal] = ACTIONS(153),
    [anon_sym_SQUOTE] = ACTIONS(155),
    [anon_sym_DQUOTE] = ACTIONS(155),
    [sym_return] = ACTIONS(153),
    [sym_next] = ACTIONS(153),
    [sym_break] = ACTIONS(153),
    [sym_true] = ACTIONS(153),
    [sym_false] = ACTIONS(153),
    [sym_null] = ACTIONS(153),
    [sym_inf] = ACTIONS(153),
    [sym_nan] = ACTIONS(153),
    [anon_sym_NA] = ACTIONS(153),
    [anon_sym_NA_integer_] = ACTIONS(153),
    [anon_sym_NA_real_] = ACTIONS(153),
    [anon_sym_NA_complex_] = ACTIONS(153),
    [anon_sym_NA_character_] = ACTIONS(153),
    [sym_dots] = ACTIONS(153),
    [sym_dot_dot_i] = ACTIONS(155),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(155),
    [sym__semicolon] = ACTIONS(155),
    [sym__raw_string_literal] = ACTIONS(155),
    [sym__external_else] = ACTIONS(319),
    [sym__external_open_parenthesis] = ACTIONS(145),
    [sym__external_open_brace] = ACTIONS(155),
    [sym__external_open_bracket] = ACTIONS(147),
    [sym__external_open_bracket2] = ACTIONS(149),
  },
  [19] = {
    [sym_call_arguments] = STATE(795),
    [sym_subset_arguments] = STATE(796),
    [sym_subset2_arguments] = STATE(797),
    [sym__else] = STATE(1619),
    [sym__open_parenthesis] = STATE(361),
    [sym__open_bracket] = STATE(362),
    [sym__open_bracket2] = STATE(199),
    [sym_identifier] = ACTIONS(205),
    [anon_sym_BSLASH] = ACTIONS(207),
    [anon_sym_function] = ACTIONS(205),
    [anon_sym_EQ] = ACTIONS(273),
    [anon_sym_if] = ACTIONS(205),
    [anon_sym_for] = ACTIONS(205),
    [anon_sym_while] = ACTIONS(205),
    [anon_sym_repeat] = ACTIONS(205),
    [anon_sym_QMARK] = ACTIONS(207),
    [anon_sym_TILDE] = ACTIONS(275),
    [anon_sym_BANG] = ACTIONS(205),
    [anon_sym_PLUS] = ACTIONS(277),
    [anon_sym_DASH] = ACTIONS(279),
    [anon_sym_LT_DASH] = ACTIONS(281),
    [anon_sym_LT_LT_DASH] = ACTIONS(281),
    [anon_sym_COLON_EQ] = ACTIONS(281),
    [anon_sym_DASH_GT] = ACTIONS(283),
    [anon_sym_DASH_GT_GT] = ACTIONS(285),
    [anon_sym_PIPE] = ACTIONS(287),
    [anon_sym_AMP] = ACTIONS(289),
    [anon_sym_PIPE_PIPE] = ACTIONS(291),
    [anon_sym_AMP_AMP] = ACTIONS(293),
    [anon_sym_LT] = ACTIONS(295),
    [anon_sym_LT_EQ] = ACTIONS(297),
    [anon_sym_GT] = ACTIONS(295),
    [anon_sym_GT_EQ] = ACTIONS(297),
    [anon_sym_EQ_EQ] = ACTIONS(297),
    [anon_sym_BANG_EQ] = ACTIONS(297),
    [anon_sym_STAR] = ACTIONS(299),
    [anon_sym_SLASH] = ACTIONS(301),
    [anon_sym_STAR_STAR] = ACTIONS(303),
    [anon_sym_CARET] = ACTIONS(303),
    [aux_sym_binary_operator_token1] = ACTIONS(305),
    [anon_sym_PIPE_GT] = ACTIONS(305),
    [anon_sym_COLON] = ACTIONS(307),
    [anon_sym_DOLLAR] = ACTIONS(309),
    [anon_sym_AT] = ACTIONS(309),
    [aux_sym__hex_literal_token1] = ACTIONS(207),
    [sym__number_literal] = ACTIONS(205),
    [anon_sym_SQUOTE] = ACTIONS(207),
    [anon_sym_DQUOTE] = ACTIONS(207),
    [sym_return] = ACTIONS(205),
    [sym_next] = ACTIONS(205),
    [sym_break] = ACTIONS(205),
    [sym_true] = ACTIONS(205),
    [sym_false] = ACTIONS(205),
    [sym_null] = ACTIONS(205),
    [sym_inf] = ACTIONS(205),
    [sym_nan] = ACTIONS(205),
    [anon_sym_NA] = ACTIONS(205),
    [anon_sym_NA_integer_] = ACTIONS(205),
    [anon_sym_NA_real_] = ACTIONS(205),
    [anon_sym_NA_complex_] = ACTIONS(205),
    [anon_sym_NA_character_] = ACTIONS(205),
    [sym_dots] = ACTIONS(205),
    [sym_dot_dot_i] = ACTIONS(207),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(207),
    [sym__newline] = ACTIONS(207),
    [sym__raw_string_literal] = ACTIONS(207),
    [sym__external_else] = ACTIONS(321),
    [sym__external_open_parenthesis] = ACTIONS(313),
    [sym__external_open_brace] = ACTIONS(207),
    [sym__external_open_bracket] = ACTIONS(315),
    [sym__external_open_bracket2] = ACTIONS(317),
    [sym__external_close_bracket2] = ACTIONS(207),
  },
  [20] = {
    [sym_call_arguments] = STATE(795),
    [sym_subset_arguments] = STATE(796),
    [sym_subset2_arguments] = STATE(797),
    [sym__else] = STATE(1622),
    [sym__open_parenthesis] = STATE(361),
    [sym__open_bracket] = STATE(362),
    [sym__open_bracket2] = STATE(199),
    [sym_identifier] = ACTIONS(103),
    [anon_sym_BSLASH] = ACTIONS(101),
    [anon_sym_function] = ACTIONS(103),
    [anon_sym_EQ] = ACTIONS(273),
    [anon_sym_if] = ACTIONS(103),
    [anon_sym_for] = ACTIONS(103),
    [anon_sym_while] = ACTIONS(103),
    [anon_sym_repeat] = ACTIONS(103),
    [anon_sym_QMARK] = ACTIONS(101),
    [anon_sym_TILDE] = ACTIONS(275),
    [anon_sym_BANG] = ACTIONS(103),
    [anon_sym_PLUS] = ACTIONS(277),
    [anon_sym_DASH] = ACTIONS(279),
    [anon_sym_LT_DASH] = ACTIONS(281),
    [anon_sym_LT_LT_DASH] = ACTIONS(281),
    [anon_sym_COLON_EQ] = ACTIONS(281),
    [anon_sym_DASH_GT] = ACTIONS(283),
    [anon_sym_DASH_GT_GT] = ACTIONS(285),
    [anon_sym_PIPE] = ACTIONS(287),
    [anon_sym_AMP] = ACTIONS(289),
    [anon_sym_PIPE_PIPE] = ACTIONS(291),
    [anon_sym_AMP_AMP] = ACTIONS(293),
    [anon_sym_LT] = ACTIONS(295),
    [anon_sym_LT_EQ] = ACTIONS(297),
    [anon_sym_GT] = ACTIONS(295),
    [anon_sym_GT_EQ] = ACTIONS(297),
    [anon_sym_EQ_EQ] = ACTIONS(297),
    [anon_sym_BANG_EQ] = ACTIONS(297),
    [anon_sym_STAR] = ACTIONS(299),
    [anon_sym_SLASH] = ACTIONS(301),
    [anon_sym_STAR_STAR] = ACTIONS(303),
    [anon_sym_CARET] = ACTIONS(303),
    [aux_sym_binary_operator_token1] = ACTIONS(305),
    [anon_sym_PIPE_GT] = ACTIONS(305),
    [anon_sym_COLON] = ACTIONS(307),
    [anon_sym_DOLLAR] = ACTIONS(309),
    [anon_sym_AT] = ACTIONS(309),
    [aux_sym__hex_literal_token1] = ACTIONS(101),
    [sym__number_literal] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_DQUOTE] = ACTIONS(101),
    [sym_return] = ACTIONS(103),
    [sym_next] = ACTIONS(103),
    [sym_break] = ACTIONS(103),
    [sym_true] = ACTIONS(103),
    [sym_false] = ACTIONS(103),
    [sym_null] = ACTIONS(103),
    [sym_inf] = ACTIONS(103),
    [sym_nan] = ACTIONS(103),
    [anon_sym_NA] = ACTIONS(103),
    [anon_sym_NA_integer_] = ACTIONS(103),
    [anon_sym_NA_real_] = ACTIONS(103),
    [anon_sym_NA_complex_] = ACTIONS(103),
    [anon_sym_NA_character_] = ACTIONS(103),
    [sym_dots] = ACTIONS(103),
    [sym_dot_dot_i] = ACTIONS(101),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(101),
    [sym__newline] = ACTIONS(101),
    [sym__raw_string_literal] = ACTIONS(101),
    [sym__external_else] = ACTIONS(323),
    [sym__external_open_parenthesis] = ACTIONS(313),
    [sym__external_open_brace] = ACTIONS(101),
    [sym__external_open_bracket] = ACTIONS(315),
    [sym__external_open_bracket2] = ACTIONS(317),
    [sym__external_close_bracket2] = ACTIONS(101),
  },
  [21] = {
    [sym_call_arguments] = STATE(862),
    [sym_subset_arguments] = STATE(885),
    [sym_subset2_arguments] = STATE(900),
    [sym__else] = STATE(1603),
    [sym__open_parenthesis] = STATE(341),
    [sym__open_bracket] = STATE(342),
    [sym__open_bracket2] = STATE(343),
    [ts_builtin_sym_end] = ACTIONS(155),
    [sym_identifier] = ACTIONS(153),
    [anon_sym_BSLASH] = ACTIONS(155),
    [anon_sym_function] = ACTIONS(153),
    [anon_sym_EQ] = ACTIONS(105),
    [anon_sym_if] = ACTIONS(153),
    [anon_sym_for] = ACTIONS(153),
    [anon_sym_while] = ACTIONS(153),
    [anon_sym_repeat] = ACTIONS(153),
    [anon_sym_QMARK] = ACTIONS(155),
    [anon_sym_TILDE] = ACTIONS(107),
    [anon_sym_BANG] = ACTIONS(153),
    [anon_sym_PLUS] = ACTIONS(109),
    [anon_sym_DASH] = ACTIONS(111),
    [anon_sym_LT_DASH] = ACTIONS(113),
    [anon_sym_LT_LT_DASH] = ACTIONS(113),
    [anon_sym_COLON_EQ] = ACTIONS(113),
    [anon_sym_DASH_GT] = ACTIONS(115),
    [anon_sym_DASH_GT_GT] = ACTIONS(117),
    [anon_sym_PIPE] = ACTIONS(119),
    [anon_sym_AMP] = ACTIONS(121),
    [anon_sym_PIPE_PIPE] = ACTIONS(123),
    [anon_sym_AMP_AMP] = ACTIONS(125),
    [anon_sym_LT] = ACTIONS(127),
    [anon_sym_LT_EQ] = ACTIONS(129),
    [anon_sym_GT] = ACTIONS(127),
    [anon_sym_GT_EQ] = ACTIONS(129),
    [anon_sym_EQ_EQ] = ACTIONS(129),
    [anon_sym_BANG_EQ] = ACTIONS(129),
    [anon_sym_STAR] = ACTIONS(131),
    [anon_sym_SLASH] = ACTIONS(133),
    [anon_sym_STAR_STAR] = ACTIONS(135),
    [anon_sym_CARET] = ACTIONS(135),
    [aux_sym_binary_operator_token1] = ACTIONS(137),
    [anon_sym_PIPE_GT] = ACTIONS(137),
    [anon_sym_COLON] = ACTIONS(139),
    [anon_sym_DOLLAR] = ACTIONS(141),
    [anon_sym_AT] = ACTIONS(141),
    [aux_sym__hex_literal_token1] = ACTIONS(155),
    [sym__number_literal] = ACTIONS(153),
    [anon_sym_SQUOTE] = ACTIONS(155),
    [anon_sym_DQUOTE] = ACTIONS(155),
    [sym_return] = ACTIONS(153),
    [sym_next] = ACTIONS(153),
    [sym_break] = ACTIONS(153),
    [sym_true] = ACTIONS(153),
    [sym_false] = ACTIONS(153),
    [sym_null] = ACTIONS(153),
    [sym_inf] = ACTIONS(153),
    [sym_nan] = ACTIONS(153),
    [anon_sym_NA] = ACTIONS(153),
    [anon_sym_NA_integer_] = ACTIONS(153),
    [anon_sym_NA_real_] = ACTIONS(153),
    [anon_sym_NA_complex_] = ACTIONS(153),
    [anon_sym_NA_character_] = ACTIONS(153),
    [sym_dots] = ACTIONS(153),
    [sym_dot_dot_i] = ACTIONS(155),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(155),
    [sym__semicolon] = ACTIONS(155),
    [sym__raw_string_literal] = ACTIONS(155),
    [sym__external_else] = ACTIONS(325),
    [sym__external_open_parenthesis] = ACTIONS(145),
    [sym__external_open_brace] = ACTIONS(155),
    [sym__external_open_bracket] = ACTIONS(147),
    [sym__external_open_bracket2] = ACTIONS(149),
  },
  [22] = {
    [sym_call_arguments] = STATE(862),
    [sym_subset_arguments] = STATE(885),
    [sym_subset2_arguments] = STATE(900),
    [sym__else] = STATE(1607),
    [sym__open_parenthesis] = STATE(341),
    [sym__open_bracket] = STATE(342),
    [sym__open_bracket2] = STATE(343),
    [ts_builtin_sym_end] = ACTIONS(53),
    [sym_identifier] = ACTIONS(51),
    [anon_sym_BSLASH] = ACTIONS(53),
    [anon_sym_function] = ACTIONS(51),
    [anon_sym_EQ] = ACTIONS(105),
    [anon_sym_if] = ACTIONS(51),
    [anon_sym_for] = ACTIONS(51),
    [anon_sym_while] = ACTIONS(51),
    [anon_sym_repeat] = ACTIONS(51),
    [anon_sym_QMARK] = ACTIONS(53),
    [anon_sym_TILDE] = ACTIONS(107),
    [anon_sym_BANG] = ACTIONS(51),
    [anon_sym_PLUS] = ACTIONS(109),
    [anon_sym_DASH] = ACTIONS(111),
    [anon_sym_LT_DASH] = ACTIONS(113),
    [anon_sym_LT_LT_DASH] = ACTIONS(113),
    [anon_sym_COLON_EQ] = ACTIONS(113),
    [anon_sym_DASH_GT] = ACTIONS(115),
    [anon_sym_DASH_GT_GT] = ACTIONS(117),
    [anon_sym_PIPE] = ACTIONS(119),
    [anon_sym_AMP] = ACTIONS(121),
    [anon_sym_PIPE_PIPE] = ACTIONS(123),
    [anon_sym_AMP_AMP] = ACTIONS(125),
    [anon_sym_LT] = ACTIONS(127),
    [anon_sym_LT_EQ] = ACTIONS(129),
    [anon_sym_GT] = ACTIONS(127),
    [anon_sym_GT_EQ] = ACTIONS(129),
    [anon_sym_EQ_EQ] = ACTIONS(129),
    [anon_sym_BANG_EQ] = ACTIONS(129),
    [anon_sym_STAR] = ACTIONS(131),
    [anon_sym_SLASH] = ACTIONS(133),
    [anon_sym_STAR_STAR] = ACTIONS(135),
    [anon_sym_CARET] = ACTIONS(135),
    [aux_sym_binary_operator_token1] = ACTIONS(137),
    [anon_sym_PIPE_GT] = ACTIONS(137),
    [anon_sym_COLON] = ACTIONS(139),
    [anon_sym_DOLLAR] = ACTIONS(141),
    [anon_sym_AT] = ACTIONS(141),
    [aux_sym__hex_literal_token1] = ACTIONS(53),
    [sym__number_literal] = ACTIONS(51),
    [anon_sym_SQUOTE] = ACTIONS(53),
    [anon_sym_DQUOTE] = ACTIONS(53),
    [sym_return] = ACTIONS(51),
    [sym_next] = ACTIONS(51),
    [sym_break] = ACTIONS(51),
    [sym_true] = ACTIONS(51),
    [sym_false] = ACTIONS(51),
    [sym_null] = ACTIONS(51),
    [sym_inf] = ACTIONS(51),
    [sym_nan] = ACTIONS(51),
    [anon_sym_NA] = ACTIONS(51),
    [anon_sym_NA_integer_] = ACTIONS(51),
    [anon_sym_NA_real_] = ACTIONS(51),
    [anon_sym_NA_complex_] = ACTIONS(51),
    [anon_sym_NA_character_] = ACTIONS(51),
    [sym_dots] = ACTIONS(51),
    [sym_dot_dot_i] = ACTIONS(53),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(53),
    [sym__semicolon] = ACTIONS(53),
    [sym__raw_string_literal] = ACTIONS(53),
    [sym__external_else] = ACTIONS(327),
    [sym__external_open_parenthesis] = ACTIONS(145),
    [sym__external_open_brace] = ACTIONS(53),
    [sym__external_open_bracket] = ACTIONS(147),
    [sym__external_open_bracket2] = ACTIONS(149),
  },
  [23] = {
    [sym_call_arguments] = STATE(862),
    [sym_subset_arguments] = STATE(885),
    [sym_subset2_arguments] = STATE(900),
    [sym__else] = STATE(1609),
    [sym__open_parenthesis] = STATE(341),
    [sym__open_bracket] = STATE(342),
    [sym__open_bracket2] = STATE(343),
    [ts_builtin_sym_end] = ACTIONS(207),
    [sym_identifier] = ACTIONS(205),
    [anon_sym_BSLASH] = ACTIONS(207),
    [anon_sym_function] = ACTIONS(205),
    [anon_sym_EQ] = ACTIONS(105),
    [anon_sym_if] = ACTIONS(205),
    [anon_sym_for] = ACTIONS(205),
    [anon_sym_while] = ACTIONS(205),
    [anon_sym_repeat] = ACTIONS(205),
    [anon_sym_QMARK] = ACTIONS(207),
    [anon_sym_TILDE] = ACTIONS(107),
    [anon_sym_BANG] = ACTIONS(205),
    [anon_sym_PLUS] = ACTIONS(109),
    [anon_sym_DASH] = ACTIONS(111),
    [anon_sym_LT_DASH] = ACTIONS(113),
    [anon_sym_LT_LT_DASH] = ACTIONS(113),
    [anon_sym_COLON_EQ] = ACTIONS(113),
    [anon_sym_DASH_GT] = ACTIONS(115),
    [anon_sym_DASH_GT_GT] = ACTIONS(117),
    [anon_sym_PIPE] = ACTIONS(119),
    [anon_sym_AMP] = ACTIONS(121),
    [anon_sym_PIPE_PIPE] = ACTIONS(123),
    [anon_sym_AMP_AMP] = ACTIONS(125),
    [anon_sym_LT] = ACTIONS(127),
    [anon_sym_LT_EQ] = ACTIONS(129),
    [anon_sym_GT] = ACTIONS(127),
    [anon_sym_GT_EQ] = ACTIONS(129),
    [anon_sym_EQ_EQ] = ACTIONS(129),
    [anon_sym_BANG_EQ] = ACTIONS(129),
    [anon_sym_STAR] = ACTIONS(131),
    [anon_sym_SLASH] = ACTIONS(133),
    [anon_sym_STAR_STAR] = ACTIONS(135),
    [anon_sym_CARET] = ACTIONS(135),
    [aux_sym_binary_operator_token1] = ACTIONS(137),
    [anon_sym_PIPE_GT] = ACTIONS(137),
    [anon_sym_COLON] = ACTIONS(139),
    [anon_sym_DOLLAR] = ACTIONS(141),
    [anon_sym_AT] = ACTIONS(141),
    [aux_sym__hex_literal_token1] = ACTIONS(207),
    [sym__number_literal] = ACTIONS(205),
    [anon_sym_SQUOTE] = ACTIONS(207),
    [anon_sym_DQUOTE] = ACTIONS(207),
    [sym_return] = ACTIONS(205),
    [sym_next] = ACTIONS(205),
    [sym_break] = ACTIONS(205),
    [sym_true] = ACTIONS(205),
    [sym_false] = ACTIONS(205),
    [sym_null] = ACTIONS(205),
    [sym_inf] = ACTIONS(205),
    [sym_nan] = ACTIONS(205),
    [anon_sym_NA] = ACTIONS(205),
    [anon_sym_NA_integer_] = ACTIONS(205),
    [anon_sym_NA_real_] = ACTIONS(205),
    [anon_sym_NA_complex_] = ACTIONS(205),
    [anon_sym_NA_character_] = ACTIONS(205),
    [sym_dots] = ACTIONS(205),
    [sym_dot_dot_i] = ACTIONS(207),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(207),
    [sym__semicolon] = ACTIONS(207),
    [sym__raw_string_literal] = ACTIONS(207),
    [sym__external_else] = ACTIONS(329),
    [sym__external_open_parenthesis] = ACTIONS(145),
    [sym__external_open_brace] = ACTIONS(207),
    [sym__external_open_bracket] = ACTIONS(147),
    [sym__external_open_bracket2] = ACTIONS(149),
  },
  [24] = {
    [sym_call_arguments] = STATE(862),
    [sym_subset_arguments] = STATE(885),
    [sym_subset2_arguments] = STATE(900),
    [sym__else] = STATE(1630),
    [sym__open_parenthesis] = STATE(341),
    [sym__open_bracket] = STATE(342),
    [sym__open_bracket2] = STATE(343),
    [ts_builtin_sym_end] = ACTIONS(101),
    [sym_identifier] = ACTIONS(103),
    [anon_sym_BSLASH] = ACTIONS(101),
    [anon_sym_function] = ACTIONS(103),
    [anon_sym_EQ] = ACTIONS(105),
    [anon_sym_if] = ACTIONS(103),
    [anon_sym_for] = ACTIONS(103),
    [anon_sym_while] = ACTIONS(103),
    [anon_sym_repeat] = ACTIONS(103),
    [anon_sym_QMARK] = ACTIONS(101),
    [anon_sym_TILDE] = ACTIONS(107),
    [anon_sym_BANG] = ACTIONS(103),
    [anon_sym_PLUS] = ACTIONS(109),
    [anon_sym_DASH] = ACTIONS(111),
    [anon_sym_LT_DASH] = ACTIONS(113),
    [anon_sym_LT_LT_DASH] = ACTIONS(113),
    [anon_sym_COLON_EQ] = ACTIONS(113),
    [anon_sym_DASH_GT] = ACTIONS(115),
    [anon_sym_DASH_GT_GT] = ACTIONS(117),
    [anon_sym_PIPE] = ACTIONS(119),
    [anon_sym_AMP] = ACTIONS(121),
    [anon_sym_PIPE_PIPE] = ACTIONS(123),
    [anon_sym_AMP_AMP] = ACTIONS(125),
    [anon_sym_LT] = ACTIONS(127),
    [anon_sym_LT_EQ] = ACTIONS(129),
    [anon_sym_GT] = ACTIONS(127),
    [anon_sym_GT_EQ] = ACTIONS(129),
    [anon_sym_EQ_EQ] = ACTIONS(129),
    [anon_sym_BANG_EQ] = ACTIONS(129),
    [anon_sym_STAR] = ACTIONS(131),
    [anon_sym_SLASH] = ACTIONS(133),
    [anon_sym_STAR_STAR] = ACTIONS(135),
    [anon_sym_CARET] = ACTIONS(135),
    [aux_sym_binary_operator_token1] = ACTIONS(137),
    [anon_sym_PIPE_GT] = ACTIONS(137),
    [anon_sym_COLON] = ACTIONS(139),
    [anon_sym_DOLLAR] = ACTIONS(141),
    [anon_sym_AT] = ACTIONS(141),
    [aux_sym__hex_literal_token1] = ACTIONS(101),
    [sym__number_literal] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_DQUOTE] = ACTIONS(101),
    [sym_return] = ACTIONS(103),
    [sym_next] = ACTIONS(103),
    [sym_break] = ACTIONS(103),
    [sym_true] = ACTIONS(103),
    [sym_false] = ACTIONS(103),
    [sym_null] = ACTIONS(103),
    [sym_inf] = ACTIONS(103),
    [sym_nan] = ACTIONS(103),
    [anon_sym_NA] = ACTIONS(103),
    [anon_sym_NA_integer_] = ACTIONS(103),
    [anon_sym_NA_real_] = ACTIONS(103),
    [anon_sym_NA_complex_] = ACTIONS(103),
    [anon_sym_NA_character_] = ACTIONS(103),
    [sym_dots] = ACTIONS(103),
    [sym_dot_dot_i] = ACTIONS(101),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(101),
    [sym__semicolon] = ACTIONS(101),
    [sym__raw_string_literal] = ACTIONS(101),
    [sym__external_else] = ACTIONS(331),
    [sym__external_open_parenthesis] = ACTIONS(145),
    [sym__external_open_brace] = ACTIONS(101),
    [sym__external_open_bracket] = ACTIONS(147),
    [sym__external_open_bracket2] = ACTIONS(149),
  },
  [25] = {
    [sym_call_arguments] = STATE(888),
    [sym_subset_arguments] = STATE(892),
    [sym_subset2_arguments] = STATE(895),
    [sym__else] = STATE(1632),
    [sym__open_parenthesis] = STATE(345),
    [sym__open_bracket] = STATE(346),
    [sym__open_bracket2] = STATE(347),
    [sym_identifier] = ACTIONS(153),
    [anon_sym_BSLASH] = ACTIONS(155),
    [anon_sym_function] = ACTIONS(153),
    [anon_sym_EQ] = ACTIONS(157),
    [anon_sym_if] = ACTIONS(153),
    [anon_sym_for] = ACTIONS(153),
    [anon_sym_while] = ACTIONS(153),
    [anon_sym_repeat] = ACTIONS(153),
    [anon_sym_QMARK] = ACTIONS(155),
    [anon_sym_TILDE] = ACTIONS(159),
    [anon_sym_BANG] = ACTIONS(153),
    [anon_sym_PLUS] = ACTIONS(161),
    [anon_sym_DASH] = ACTIONS(163),
    [anon_sym_LT_DASH] = ACTIONS(165),
    [anon_sym_LT_LT_DASH] = ACTIONS(165),
    [anon_sym_COLON_EQ] = ACTIONS(165),
    [anon_sym_DASH_GT] = ACTIONS(167),
    [anon_sym_DASH_GT_GT] = ACTIONS(169),
    [anon_sym_PIPE] = ACTIONS(171),
    [anon_sym_AMP] = ACTIONS(173),
    [anon_sym_PIPE_PIPE] = ACTIONS(175),
    [anon_sym_AMP_AMP] = ACTIONS(177),
    [anon_sym_LT] = ACTIONS(179),
    [anon_sym_LT_EQ] = ACTIONS(181),
    [anon_sym_GT] = ACTIONS(179),
    [anon_sym_GT_EQ] = ACTIONS(181),
    [anon_sym_EQ_EQ] = ACTIONS(181),
    [anon_sym_BANG_EQ] = ACTIONS(181),
    [anon_sym_STAR] = ACTIONS(183),
    [anon_sym_SLASH] = ACTIONS(185),
    [anon_sym_STAR_STAR] = ACTIONS(187),
    [anon_sym_CARET] = ACTIONS(187),
    [aux_sym_binary_operator_token1] = ACTIONS(189),
    [anon_sym_PIPE_GT] = ACTIONS(189),
    [anon_sym_COLON] = ACTIONS(191),
    [anon_sym_DOLLAR] = ACTIONS(193),
    [anon_sym_AT] = ACTIONS(193),
    [aux_sym__hex_literal_token1] = ACTIONS(155),
    [sym__number_literal] = ACTIONS(153),
    [anon_sym_SQUOTE] = ACTIONS(155),
    [anon_sym_DQUOTE] = ACTIONS(155),
    [sym_return] = ACTIONS(153),
    [sym_next] = ACTIONS(153),
    [sym_break] = ACTIONS(153),
    [sym_true] = ACTIONS(153),
    [sym_false] = ACTIONS(153),
    [sym_null] = ACTIONS(153),
    [sym_inf] = ACTIONS(153),
    [sym_nan] = ACTIONS(153),
    [anon_sym_NA] = ACTIONS(153),
    [anon_sym_NA_integer_] = ACTIONS(153),
    [anon_sym_NA_real_] = ACTIONS(153),
    [anon_sym_NA_complex_] = ACTIONS(153),
    [anon_sym_NA_character_] = ACTIONS(153),
    [sym_dots] = ACTIONS(153),
    [sym_dot_dot_i] = ACTIONS(155),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(155),
    [sym__newline] = ACTIONS(155),
    [sym__raw_string_literal] = ACTIONS(155),
    [sym__external_else] = ACTIONS(333),
    [sym__external_open_parenthesis] = ACTIONS(197),
    [sym__external_close_parenthesis] = ACTIONS(155),
    [sym__external_open_brace] = ACTIONS(155),
    [sym__external_open_bracket] = ACTIONS(199),
    [sym__external_open_bracket2] = ACTIONS(201),
  },
  [26] = {
    [sym_call_arguments] = STATE(888),
    [sym_subset_arguments] = STATE(892),
    [sym_subset2_arguments] = STATE(895),
    [sym__else] = STATE(1640),
    [sym__open_parenthesis] = STATE(345),
    [sym__open_bracket] = STATE(346),
    [sym__open_bracket2] = STATE(347),
    [sym_identifier] = ACTIONS(51),
    [anon_sym_BSLASH] = ACTIONS(53),
    [anon_sym_function] = ACTIONS(51),
    [anon_sym_EQ] = ACTIONS(157),
    [anon_sym_if] = ACTIONS(51),
    [anon_sym_for] = ACTIONS(51),
    [anon_sym_while] = ACTIONS(51),
    [anon_sym_repeat] = ACTIONS(51),
    [anon_sym_QMARK] = ACTIONS(53),
    [anon_sym_TILDE] = ACTIONS(159),
    [anon_sym_BANG] = ACTIONS(51),
    [anon_sym_PLUS] = ACTIONS(161),
    [anon_sym_DASH] = ACTIONS(163),
    [anon_sym_LT_DASH] = ACTIONS(165),
    [anon_sym_LT_LT_DASH] = ACTIONS(165),
    [anon_sym_COLON_EQ] = ACTIONS(165),
    [anon_sym_DASH_GT] = ACTIONS(167),
    [anon_sym_DASH_GT_GT] = ACTIONS(169),
    [anon_sym_PIPE] = ACTIONS(171),
    [anon_sym_AMP] = ACTIONS(173),
    [anon_sym_PIPE_PIPE] = ACTIONS(175),
    [anon_sym_AMP_AMP] = ACTIONS(177),
    [anon_sym_LT] = ACTIONS(179),
    [anon_sym_LT_EQ] = ACTIONS(181),
    [anon_sym_GT] = ACTIONS(179),
    [anon_sym_GT_EQ] = ACTIONS(181),
    [anon_sym_EQ_EQ] = ACTIONS(181),
    [anon_sym_BANG_EQ] = ACTIONS(181),
    [anon_sym_STAR] = ACTIONS(183),
    [anon_sym_SLASH] = ACTIONS(185),
    [anon_sym_STAR_STAR] = ACTIONS(187),
    [anon_sym_CARET] = ACTIONS(187),
    [aux_sym_binary_operator_token1] = ACTIONS(189),
    [anon_sym_PIPE_GT] = ACTIONS(189),
    [anon_sym_COLON] = ACTIONS(191),
    [anon_sym_DOLLAR] = ACTIONS(193),
    [anon_sym_AT] = ACTIONS(193),
    [aux_sym__hex_literal_token1] = ACTIONS(53),
    [sym__number_literal] = ACTIONS(51),
    [anon_sym_SQUOTE] = ACTIONS(53),
    [anon_sym_DQUOTE] = ACTIONS(53),
    [sym_return] = ACTIONS(51),
    [sym_next] = ACTIONS(51),
    [sym_break] = ACTIONS(51),
    [sym_true] = ACTIONS(51),
    [sym_false] = ACTIONS(51),
    [sym_null] = ACTIONS(51),
    [sym_inf] = ACTIONS(51),
    [sym_nan] = ACTIONS(51),
    [anon_sym_NA] = ACTIONS(51),
    [anon_sym_NA_integer_] = ACTIONS(51),
    [anon_sym_NA_real_] = ACTIONS(51),
    [anon_sym_NA_complex_] = ACTIONS(51),
    [anon_sym_NA_character_] = ACTIONS(51),
    [sym_dots] = ACTIONS(51),
    [sym_dot_dot_i] = ACTIONS(53),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(53),
    [sym__newline] = ACTIONS(53),
    [sym__raw_string_literal] = ACTIONS(53),
    [sym__external_else] = ACTIONS(335),
    [sym__external_open_parenthesis] = ACTIONS(197),
    [sym__external_close_parenthesis] = ACTIONS(53),
    [sym__external_open_brace] = ACTIONS(53),
    [sym__external_open_bracket] = ACTIONS(199),
    [sym__external_open_bracket2] = ACTIONS(201),
  },
  [27] = {
    [sym_call_arguments] = STATE(888),
    [sym_subset_arguments] = STATE(892),
    [sym_subset2_arguments] = STATE(895),
    [sym__else] = STATE(1643),
    [sym__open_parenthesis] = STATE(345),
    [sym__open_bracket] = STATE(346),
    [sym__open_bracket2] = STATE(347),
    [sym_identifier] = ACTIONS(205),
    [anon_sym_BSLASH] = ACTIONS(207),
    [anon_sym_function] = ACTIONS(205),
    [anon_sym_EQ] = ACTIONS(157),
    [anon_sym_if] = ACTIONS(205),
    [anon_sym_for] = ACTIONS(205),
    [anon_sym_while] = ACTIONS(205),
    [anon_sym_repeat] = ACTIONS(205),
    [anon_sym_QMARK] = ACTIONS(207),
    [anon_sym_TILDE] = ACTIONS(159),
    [anon_sym_BANG] = ACTIONS(205),
    [anon_sym_PLUS] = ACTIONS(161),
    [anon_sym_DASH] = ACTIONS(163),
    [anon_sym_LT_DASH] = ACTIONS(165),
    [anon_sym_LT_LT_DASH] = ACTIONS(165),
    [anon_sym_COLON_EQ] = ACTIONS(165),
    [anon_sym_DASH_GT] = ACTIONS(167),
    [anon_sym_DASH_GT_GT] = ACTIONS(169),
    [anon_sym_PIPE] = ACTIONS(171),
    [anon_sym_AMP] = ACTIONS(173),
    [anon_sym_PIPE_PIPE] = ACTIONS(175),
    [anon_sym_AMP_AMP] = ACTIONS(177),
    [anon_sym_LT] = ACTIONS(179),
    [anon_sym_LT_EQ] = ACTIONS(181),
    [anon_sym_GT] = ACTIONS(179),
    [anon_sym_GT_EQ] = ACTIONS(181),
    [anon_sym_EQ_EQ] = ACTIONS(181),
    [anon_sym_BANG_EQ] = ACTIONS(181),
    [anon_sym_STAR] = ACTIONS(183),
    [anon_sym_SLASH] = ACTIONS(185),
    [anon_sym_STAR_STAR] = ACTIONS(187),
    [anon_sym_CARET] = ACTIONS(187),
    [aux_sym_binary_operator_token1] = ACTIONS(189),
    [anon_sym_PIPE_GT] = ACTIONS(189),
    [anon_sym_COLON] = ACTIONS(191),
    [anon_sym_DOLLAR] = ACTIONS(193),
    [anon_sym_AT] = ACTIONS(193),
    [aux_sym__hex_literal_token1] = ACTIONS(207),
    [sym__number_literal] = ACTIONS(205),
    [anon_sym_SQUOTE] = ACTIONS(207),
    [anon_sym_DQUOTE] = ACTIONS(207),
    [sym_return] = ACTIONS(205),
    [sym_next] = ACTIONS(205),
    [sym_break] = ACTIONS(205),
    [sym_true] = ACTIONS(205),
    [sym_false] = ACTIONS(205),
    [sym_null] = ACTIONS(205),
    [sym_inf] = ACTIONS(205),
    [sym_nan] = ACTIONS(205),
    [anon_sym_NA] = ACTIONS(205),
    [anon_sym_NA_integer_] = ACTIONS(205),
    [anon_sym_NA_real_] = ACTIONS(205),
    [anon_sym_NA_complex_] = ACTIONS(205),
    [anon_sym_NA_character_] = ACTIONS(205),
    [sym_dots] = ACTIONS(205),
    [sym_dot_dot_i] = ACTIONS(207),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(207),
    [sym__newline] = ACTIONS(207),
    [sym__raw_string_literal] = ACTIONS(207),
    [sym__external_else] = ACTIONS(337),
    [sym__external_open_parenthesis] = ACTIONS(197),
    [sym__external_close_parenthesis] = ACTIONS(207),
    [sym__external_open_brace] = ACTIONS(207),
    [sym__external_open_bracket] = ACTIONS(199),
    [sym__external_open_bracket2] = ACTIONS(201),
  },
  [28] = {
    [sym_call_arguments] = STATE(888),
    [sym_subset_arguments] = STATE(892),
    [sym_subset2_arguments] = STATE(895),
    [sym__else] = STATE(1651),
    [sym__open_parenthesis] = STATE(345),
    [sym__open_bracket] = STATE(346),
    [sym__open_bracket2] = STATE(347),
    [sym_identifier] = ACTIONS(103),
    [anon_sym_BSLASH] = ACTIONS(101),
    [anon_sym_function] = ACTIONS(103),
    [anon_sym_EQ] = ACTIONS(157),
    [anon_sym_if] = ACTIONS(103),
    [anon_sym_for] = ACTIONS(103),
    [anon_sym_while] = ACTIONS(103),
    [anon_sym_repeat] = ACTIONS(103),
    [anon_sym_QMARK] = ACTIONS(101),
    [anon_sym_TILDE] = ACTIONS(159),
    [anon_sym_BANG] = ACTIONS(103),
    [anon_sym_PLUS] = ACTIONS(161),
    [anon_sym_DASH] = ACTIONS(163),
    [anon_sym_LT_DASH] = ACTIONS(165),
    [anon_sym_LT_LT_DASH] = ACTIONS(165),
    [anon_sym_COLON_EQ] = ACTIONS(165),
    [anon_sym_DASH_GT] = ACTIONS(167),
    [anon_sym_DASH_GT_GT] = ACTIONS(169),
    [anon_sym_PIPE] = ACTIONS(171),
    [anon_sym_AMP] = ACTIONS(173),
    [anon_sym_PIPE_PIPE] = ACTIONS(175),
    [anon_sym_AMP_AMP] = ACTIONS(177),
    [anon_sym_LT] = ACTIONS(179),
    [anon_sym_LT_EQ] = ACTIONS(181),
    [anon_sym_GT] = ACTIONS(179),
    [anon_sym_GT_EQ] = ACTIONS(181),
    [anon_sym_EQ_EQ] = ACTIONS(181),
    [anon_sym_BANG_EQ] = ACTIONS(181),
    [anon_sym_STAR] = ACTIONS(183),
    [anon_sym_SLASH] = ACTIONS(185),
    [anon_sym_STAR_STAR] = ACTIONS(187),
    [anon_sym_CARET] = ACTIONS(187),
    [aux_sym_binary_operator_token1] = ACTIONS(189),
    [anon_sym_PIPE_GT] = ACTIONS(189),
    [anon_sym_COLON] = ACTIONS(191),
    [anon_sym_DOLLAR] = ACTIONS(193),
    [anon_sym_AT] = ACTIONS(193),
    [aux_sym__hex_literal_token1] = ACTIONS(101),
    [sym__number_literal] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_DQUOTE] = ACTIONS(101),
    [sym_return] = ACTIONS(103),
    [sym_next] = ACTIONS(103),
    [sym_break] = ACTIONS(103),
    [sym_true] = ACTIONS(103),
    [sym_false] = ACTIONS(103),
    [sym_null] = ACTIONS(103),
    [sym_inf] = ACTIONS(103),
    [sym_nan] = ACTIONS(103),
    [anon_sym_NA] = ACTIONS(103),
    [anon_sym_NA_integer_] = ACTIONS(103),
    [anon_sym_NA_real_] = ACTIONS(103),
    [anon_sym_NA_complex_] = ACTIONS(103),
    [anon_sym_NA_character_] = ACTIONS(103),
    [sym_dots] = ACTIONS(103),
    [sym_dot_dot_i] = ACTIONS(101),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(101),
    [sym__newline] = ACTIONS(101),
    [sym__raw_string_literal] = ACTIONS(101),
    [sym__external_else] = ACTIONS(339),
    [sym__external_open_parenthesis] = ACTIONS(197),
    [sym__external_close_parenthesis] = ACTIONS(101),
    [sym__external_open_brace] = ACTIONS(101),
    [sym__external_open_bracket] = ACTIONS(199),
    [sym__external_open_bracket2] = ACTIONS(201),
  },
  [29] = {
    [sym_call_arguments] = STATE(850),
    [sym_subset_arguments] = STATE(851),
    [sym_subset2_arguments] = STATE(852),
    [sym__else] = STATE(1637),
    [sym__open_parenthesis] = STATE(349),
    [sym__open_bracket] = STATE(350),
    [sym__open_bracket2] = STATE(351),
    [sym_identifier] = ACTIONS(153),
    [anon_sym_BSLASH] = ACTIONS(155),
    [anon_sym_function] = ACTIONS(153),
    [anon_sym_EQ] = ACTIONS(213),
    [anon_sym_if] = ACTIONS(153),
    [anon_sym_for] = ACTIONS(153),
    [anon_sym_while] = ACTIONS(153),
    [anon_sym_repeat] = ACTIONS(153),
    [anon_sym_QMARK] = ACTIONS(155),
    [anon_sym_TILDE] = ACTIONS(215),
    [anon_sym_BANG] = ACTIONS(153),
    [anon_sym_PLUS] = ACTIONS(217),
    [anon_sym_DASH] = ACTIONS(219),
    [anon_sym_LT_DASH] = ACTIONS(221),
    [anon_sym_LT_LT_DASH] = ACTIONS(221),
    [anon_sym_COLON_EQ] = ACTIONS(221),
    [anon_sym_DASH_GT] = ACTIONS(223),
    [anon_sym_DASH_GT_GT] = ACTIONS(225),
    [anon_sym_PIPE] = ACTIONS(227),
    [anon_sym_AMP] = ACTIONS(229),
    [anon_sym_PIPE_PIPE] = ACTIONS(231),
    [anon_sym_AMP_AMP] = ACTIONS(233),
    [anon_sym_LT] = ACTIONS(235),
    [anon_sym_LT_EQ] = ACTIONS(237),
    [anon_sym_GT] = ACTIONS(235),
    [anon_sym_GT_EQ] = ACTIONS(237),
    [anon_sym_EQ_EQ] = ACTIONS(237),
    [anon_sym_BANG_EQ] = ACTIONS(237),
    [anon_sym_STAR] = ACTIONS(239),
    [anon_sym_SLASH] = ACTIONS(241),
    [anon_sym_STAR_STAR] = ACTIONS(243),
    [anon_sym_CARET] = ACTIONS(243),
    [aux_sym_binary_operator_token1] = ACTIONS(245),
    [anon_sym_PIPE_GT] = ACTIONS(245),
    [anon_sym_COLON] = ACTIONS(247),
    [anon_sym_DOLLAR] = ACTIONS(249),
    [anon_sym_AT] = ACTIONS(249),
    [aux_sym__hex_literal_token1] = ACTIONS(155),
    [sym__number_literal] = ACTIONS(153),
    [anon_sym_SQUOTE] = ACTIONS(155),
    [anon_sym_DQUOTE] = ACTIONS(155),
    [sym_return] = ACTIONS(153),
    [sym_next] = ACTIONS(153),
    [sym_break] = ACTIONS(153),
    [sym_true] = ACTIONS(153),
    [sym_false] = ACTIONS(153),
    [sym_null] = ACTIONS(153),
    [sym_inf] = ACTIONS(153),
    [sym_nan] = ACTIONS(153),
    [anon_sym_NA] = ACTIONS(153),
    [anon_sym_NA_integer_] = ACTIONS(153),
    [anon_sym_NA_real_] = ACTIONS(153),
    [anon_sym_NA_complex_] = ACTIONS(153),
    [anon_sym_NA_character_] = ACTIONS(153),
    [sym_dots] = ACTIONS(153),
    [sym_dot_dot_i] = ACTIONS(155),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(155),
    [sym__semicolon] = ACTIONS(155),
    [sym__raw_string_literal] = ACTIONS(155),
    [sym__external_else] = ACTIONS(341),
    [sym__external_open_parenthesis] = ACTIONS(253),
    [sym__external_open_brace] = ACTIONS(155),
    [sym__external_close_brace] = ACTIONS(155),
    [sym__external_open_bracket] = ACTIONS(255),
    [sym__external_open_bracket2] = ACTIONS(257),
  },
  [30] = {
    [sym_call_arguments] = STATE(850),
    [sym_subset_arguments] = STATE(851),
    [sym_subset2_arguments] = STATE(852),
    [sym__else] = STATE(1644),
    [sym__open_parenthesis] = STATE(349),
    [sym__open_bracket] = STATE(350),
    [sym__open_bracket2] = STATE(351),
    [sym_identifier] = ACTIONS(51),
    [anon_sym_BSLASH] = ACTIONS(53),
    [anon_sym_function] = ACTIONS(51),
    [anon_sym_EQ] = ACTIONS(213),
    [anon_sym_if] = ACTIONS(51),
    [anon_sym_for] = ACTIONS(51),
    [anon_sym_while] = ACTIONS(51),
    [anon_sym_repeat] = ACTIONS(51),
    [anon_sym_QMARK] = ACTIONS(53),
    [anon_sym_TILDE] = ACTIONS(215),
    [anon_sym_BANG] = ACTIONS(51),
    [anon_sym_PLUS] = ACTIONS(217),
    [anon_sym_DASH] = ACTIONS(219),
    [anon_sym_LT_DASH] = ACTIONS(221),
    [anon_sym_LT_LT_DASH] = ACTIONS(221),
    [anon_sym_COLON_EQ] = ACTIONS(221),
    [anon_sym_DASH_GT] = ACTIONS(223),
    [anon_sym_DASH_GT_GT] = ACTIONS(225),
    [anon_sym_PIPE] = ACTIONS(227),
    [anon_sym_AMP] = ACTIONS(229),
    [anon_sym_PIPE_PIPE] = ACTIONS(231),
    [anon_sym_AMP_AMP] = ACTIONS(233),
    [anon_sym_LT] = ACTIONS(235),
    [anon_sym_LT_EQ] = ACTIONS(237),
    [anon_sym_GT] = ACTIONS(235),
    [anon_sym_GT_EQ] = ACTIONS(237),
    [anon_sym_EQ_EQ] = ACTIONS(237),
    [anon_sym_BANG_EQ] = ACTIONS(237),
    [anon_sym_STAR] = ACTIONS(239),
    [anon_sym_SLASH] = ACTIONS(241),
    [anon_sym_STAR_STAR] = ACTIONS(243),
    [anon_sym_CARET] = ACTIONS(243),
    [aux_sym_binary_operator_token1] = ACTIONS(245),
    [anon_sym_PIPE_GT] = ACTIONS(245),
    [anon_sym_COLON] = ACTIONS(247),
    [anon_sym_DOLLAR] = ACTIONS(249),
    [anon_sym_AT] = ACTIONS(249),
    [aux_sym__hex_literal_token1] = ACTIONS(53),
    [sym__number_literal] = ACTIONS(51),
    [anon_sym_SQUOTE] = ACTIONS(53),
    [anon_sym_DQUOTE] = ACTIONS(53),
    [sym_return] = ACTIONS(51),
    [sym_next] = ACTIONS(51),
    [sym_break] = ACTIONS(51),
    [sym_true] = ACTIONS(51),
    [sym_false] = ACTIONS(51),
    [sym_null] = ACTIONS(51),
    [sym_inf] = ACTIONS(51),
    [sym_nan] = ACTIONS(51),
    [anon_sym_NA] = ACTIONS(51),
    [anon_sym_NA_integer_] = ACTIONS(51),
    [anon_sym_NA_real_] = ACTIONS(51),
    [anon_sym_NA_complex_] = ACTIONS(51),
    [anon_sym_NA_character_] = ACTIONS(51),
    [sym_dots] = ACTIONS(51),
    [sym_dot_dot_i] = ACTIONS(53),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(53),
    [sym__semicolon] = ACTIONS(53),
    [sym__raw_string_literal] = ACTIONS(53),
    [sym__external_else] = ACTIONS(343),
    [sym__external_open_parenthesis] = ACTIONS(253),
    [sym__external_open_brace] = ACTIONS(53),
    [sym__external_close_brace] = ACTIONS(53),
    [sym__external_open_bracket] = ACTIONS(255),
    [sym__external_open_bracket2] = ACTIONS(257),
  },
  [31] = {
    [sym_call_arguments] = STATE(850),
    [sym_subset_arguments] = STATE(851),
    [sym_subset2_arguments] = STATE(852),
    [sym__else] = STATE(1645),
    [sym__open_parenthesis] = STATE(349),
    [sym__open_bracket] = STATE(350),
    [sym__open_bracket2] = STATE(351),
    [sym_identifier] = ACTIONS(205),
    [anon_sym_BSLASH] = ACTIONS(207),
    [anon_sym_function] = ACTIONS(205),
    [anon_sym_EQ] = ACTIONS(213),
    [anon_sym_if] = ACTIONS(205),
    [anon_sym_for] = ACTIONS(205),
    [anon_sym_while] = ACTIONS(205),
    [anon_sym_repeat] = ACTIONS(205),
    [anon_sym_QMARK] = ACTIONS(207),
    [anon_sym_TILDE] = ACTIONS(215),
    [anon_sym_BANG] = ACTIONS(205),
    [anon_sym_PLUS] = ACTIONS(217),
    [anon_sym_DASH] = ACTIONS(219),
    [anon_sym_LT_DASH] = ACTIONS(221),
    [anon_sym_LT_LT_DASH] = ACTIONS(221),
    [anon_sym_COLON_EQ] = ACTIONS(221),
    [anon_sym_DASH_GT] = ACTIONS(223),
    [anon_sym_DASH_GT_GT] = ACTIONS(225),
    [anon_sym_PIPE] = ACTIONS(227),
    [anon_sym_AMP] = ACTIONS(229),
    [anon_sym_PIPE_PIPE] = ACTIONS(231),
    [anon_sym_AMP_AMP] = ACTIONS(233),
    [anon_sym_LT] = ACTIONS(235),
    [anon_sym_LT_EQ] = ACTIONS(237),
    [anon_sym_GT] = ACTIONS(235),
    [anon_sym_GT_EQ] = ACTIONS(237),
    [anon_sym_EQ_EQ] = ACTIONS(237),
    [anon_sym_BANG_EQ] = ACTIONS(237),
    [anon_sym_STAR] = ACTIONS(239),
    [anon_sym_SLASH] = ACTIONS(241),
    [anon_sym_STAR_STAR] = ACTIONS(243),
    [anon_sym_CARET] = ACTIONS(243),
    [aux_sym_binary_operator_token1] = ACTIONS(245),
    [anon_sym_PIPE_GT] = ACTIONS(245),
    [anon_sym_COLON] = ACTIONS(247),
    [anon_sym_DOLLAR] = ACTIONS(249),
    [anon_sym_AT] = ACTIONS(249),
    [aux_sym__hex_literal_token1] = ACTIONS(207),
    [sym__number_literal] = ACTIONS(205),
    [anon_sym_SQUOTE] = ACTIONS(207),
    [anon_sym_DQUOTE] = ACTIONS(207),
    [sym_return] = ACTIONS(205),
    [sym_next] = ACTIONS(205),
    [sym_break] = ACTIONS(205),
    [sym_true] = ACTIONS(205),
    [sym_false] = ACTIONS(205),
    [sym_null] = ACTIONS(205),
    [sym_inf] = ACTIONS(205),
    [sym_nan] = ACTIONS(205),
    [anon_sym_NA] = ACTIONS(205),
    [anon_sym_NA_integer_] = ACTIONS(205),
    [anon_sym_NA_real_] = ACTIONS(205),
    [anon_sym_NA_complex_] = ACTIONS(205),
    [anon_sym_NA_character_] = ACTIONS(205),
    [sym_dots] = ACTIONS(205),
    [sym_dot_dot_i] = ACTIONS(207),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(207),
    [sym__semicolon] = ACTIONS(207),
    [sym__raw_string_literal] = ACTIONS(207),
    [sym__external_else] = ACTIONS(345),
    [sym__external_open_parenthesis] = ACTIONS(253),
    [sym__external_open_brace] = ACTIONS(207),
    [sym__external_close_brace] = ACTIONS(207),
    [sym__external_open_bracket] = ACTIONS(255),
    [sym__external_open_bracket2] = ACTIONS(257),
  },
  [32] = {
    [sym_call_arguments] = STATE(850),
    [sym_subset_arguments] = STATE(851),
    [sym_subset2_arguments] = STATE(852),
    [sym__else] = STATE(1649),
    [sym__open_parenthesis] = STATE(349),
    [sym__open_bracket] = STATE(350),
    [sym__open_bracket2] = STATE(351),
    [sym_identifier] = ACTIONS(103),
    [anon_sym_BSLASH] = ACTIONS(101),
    [anon_sym_function] = ACTIONS(103),
    [anon_sym_EQ] = ACTIONS(213),
    [anon_sym_if] = ACTIONS(103),
    [anon_sym_for] = ACTIONS(103),
    [anon_sym_while] = ACTIONS(103),
    [anon_sym_repeat] = ACTIONS(103),
    [anon_sym_QMARK] = ACTIONS(101),
    [anon_sym_TILDE] = ACTIONS(215),
    [anon_sym_BANG] = ACTIONS(103),
    [anon_sym_PLUS] = ACTIONS(217),
    [anon_sym_DASH] = ACTIONS(219),
    [anon_sym_LT_DASH] = ACTIONS(221),
    [anon_sym_LT_LT_DASH] = ACTIONS(221),
    [anon_sym_COLON_EQ] = ACTIONS(221),
    [anon_sym_DASH_GT] = ACTIONS(223),
    [anon_sym_DASH_GT_GT] = ACTIONS(225),
    [anon_sym_PIPE] = ACTIONS(227),
    [anon_sym_AMP] = ACTIONS(229),
    [anon_sym_PIPE_PIPE] = ACTIONS(231),
    [anon_sym_AMP_AMP] = ACTIONS(233),
    [anon_sym_LT] = ACTIONS(235),
    [anon_sym_LT_EQ] = ACTIONS(237),
    [anon_sym_GT] = ACTIONS(235),
    [anon_sym_GT_EQ] = ACTIONS(237),
    [anon_sym_EQ_EQ] = ACTIONS(237),
    [anon_sym_BANG_EQ] = ACTIONS(237),
    [anon_sym_STAR] = ACTIONS(239),
    [anon_sym_SLASH] = ACTIONS(241),
    [anon_sym_STAR_STAR] = ACTIONS(243),
    [anon_sym_CARET] = ACTIONS(243),
    [aux_sym_binary_operator_token1] = ACTIONS(245),
    [anon_sym_PIPE_GT] = ACTIONS(245),
    [anon_sym_COLON] = ACTIONS(247),
    [anon_sym_DOLLAR] = ACTIONS(249),
    [anon_sym_AT] = ACTIONS(249),
    [aux_sym__hex_literal_token1] = ACTIONS(101),
    [sym__number_literal] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_DQUOTE] = ACTIONS(101),
    [sym_return] = ACTIONS(103),
    [sym_next] = ACTIONS(103),
    [sym_break] = ACTIONS(103),
    [sym_true] = ACTIONS(103),
    [sym_false] = ACTIONS(103),
    [sym_null] = ACTIONS(103),
    [sym_inf] = ACTIONS(103),
    [sym_nan] = ACTIONS(103),
    [anon_sym_NA] = ACTIONS(103),
    [anon_sym_NA_integer_] = ACTIONS(103),
    [anon_sym_NA_real_] = ACTIONS(103),
    [anon_sym_NA_complex_] = ACTIONS(103),
    [anon_sym_NA_character_] = ACTIONS(103),
    [sym_dots] = ACTIONS(103),
    [sym_dot_dot_i] = ACTIONS(101),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(101),
    [sym__semicolon] = ACTIONS(101),
    [sym__raw_string_literal] = ACTIONS(101),
    [sym__external_else] = ACTIONS(347),
    [sym__external_open_parenthesis] = ACTIONS(253),
    [sym__external_open_brace] = ACTIONS(101),
    [sym__external_close_brace] = ACTIONS(101),
    [sym__external_open_bracket] = ACTIONS(255),
    [sym__external_open_bracket2] = ACTIONS(257),
  },
  [33] = {
    [sym_call_arguments] = STATE(807),
    [sym_subset_arguments] = STATE(808),
    [sym_subset2_arguments] = STATE(810),
    [sym__else] = STATE(1650),
    [sym__open_parenthesis] = STATE(357),
    [sym__open_bracket] = STATE(358),
    [sym__open_bracket2] = STATE(359),
    [sym_identifier] = ACTIONS(153),
    [anon_sym_BSLASH] = ACTIONS(155),
    [anon_sym_function] = ACTIONS(153),
    [anon_sym_EQ] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(153),
    [anon_sym_for] = ACTIONS(153),
    [anon_sym_while] = ACTIONS(153),
    [anon_sym_repeat] = ACTIONS(153),
    [anon_sym_QMARK] = ACTIONS(155),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_BANG] = ACTIONS(153),
    [anon_sym_PLUS] = ACTIONS(59),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_LT_DASH] = ACTIONS(63),
    [anon_sym_LT_LT_DASH] = ACTIONS(63),
    [anon_sym_COLON_EQ] = ACTIONS(63),
    [anon_sym_DASH_GT] = ACTIONS(65),
    [anon_sym_DASH_GT_GT] = ACTIONS(67),
    [anon_sym_PIPE] = ACTIONS(69),
    [anon_sym_AMP] = ACTIONS(71),
    [anon_sym_PIPE_PIPE] = ACTIONS(73),
    [anon_sym_AMP_AMP] = ACTIONS(75),
    [anon_sym_LT] = ACTIONS(77),
    [anon_sym_LT_EQ] = ACTIONS(79),
    [anon_sym_GT] = ACTIONS(77),
    [anon_sym_GT_EQ] = ACTIONS(79),
    [anon_sym_EQ_EQ] = ACTIONS(79),
    [anon_sym_BANG_EQ] = ACTIONS(79),
    [anon_sym_STAR] = ACTIONS(81),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_STAR_STAR] = ACTIONS(85),
    [anon_sym_CARET] = ACTIONS(85),
    [aux_sym_binary_operator_token1] = ACTIONS(87),
    [anon_sym_PIPE_GT] = ACTIONS(87),
    [anon_sym_COLON] = ACTIONS(89),
    [anon_sym_DOLLAR] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(91),
    [aux_sym__hex_literal_token1] = ACTIONS(155),
    [sym__number_literal] = ACTIONS(153),
    [anon_sym_SQUOTE] = ACTIONS(155),
    [anon_sym_DQUOTE] = ACTIONS(155),
    [sym_return] = ACTIONS(153),
    [sym_next] = ACTIONS(153),
    [sym_break] = ACTIONS(153),
    [sym_true] = ACTIONS(153),
    [sym_false] = ACTIONS(153),
    [sym_null] = ACTIONS(153),
    [sym_inf] = ACTIONS(153),
    [sym_nan] = ACTIONS(153),
    [anon_sym_NA] = ACTIONS(153),
    [anon_sym_NA_integer_] = ACTIONS(153),
    [anon_sym_NA_real_] = ACTIONS(153),
    [anon_sym_NA_complex_] = ACTIONS(153),
    [anon_sym_NA_character_] = ACTIONS(153),
    [sym_dots] = ACTIONS(153),
    [sym_dot_dot_i] = ACTIONS(155),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(155),
    [sym__newline] = ACTIONS(155),
    [sym__raw_string_literal] = ACTIONS(155),
    [sym__external_else] = ACTIONS(349),
    [sym__external_open_parenthesis] = ACTIONS(95),
    [sym__external_open_brace] = ACTIONS(155),
    [sym__external_open_bracket] = ACTIONS(97),
    [sym__external_close_bracket] = ACTIONS(155),
    [sym__external_open_bracket2] = ACTIONS(99),
  },
  [34] = {
    [sym_call_arguments] = STATE(862),
    [sym_subset_arguments] = STATE(885),
    [sym_subset2_arguments] = STATE(900),
    [sym__else] = STATE(1634),
    [sym__open_parenthesis] = STATE(341),
    [sym__open_bracket] = STATE(342),
    [sym__open_bracket2] = STATE(343),
    [ts_builtin_sym_end] = ACTIONS(207),
    [sym_identifier] = ACTIONS(205),
    [anon_sym_BSLASH] = ACTIONS(207),
    [anon_sym_function] = ACTIONS(205),
    [anon_sym_EQ] = ACTIONS(105),
    [anon_sym_if] = ACTIONS(205),
    [anon_sym_for] = ACTIONS(205),
    [anon_sym_while] = ACTIONS(205),
    [anon_sym_repeat] = ACTIONS(205),
    [anon_sym_QMARK] = ACTIONS(207),
    [anon_sym_TILDE] = ACTIONS(107),
    [anon_sym_BANG] = ACTIONS(205),
    [anon_sym_PLUS] = ACTIONS(109),
    [anon_sym_DASH] = ACTIONS(111),
    [anon_sym_LT_DASH] = ACTIONS(113),
    [anon_sym_LT_LT_DASH] = ACTIONS(113),
    [anon_sym_COLON_EQ] = ACTIONS(113),
    [anon_sym_DASH_GT] = ACTIONS(115),
    [anon_sym_DASH_GT_GT] = ACTIONS(117),
    [anon_sym_PIPE] = ACTIONS(119),
    [anon_sym_AMP] = ACTIONS(121),
    [anon_sym_PIPE_PIPE] = ACTIONS(123),
    [anon_sym_AMP_AMP] = ACTIONS(125),
    [anon_sym_LT] = ACTIONS(127),
    [anon_sym_LT_EQ] = ACTIONS(129),
    [anon_sym_GT] = ACTIONS(127),
    [anon_sym_GT_EQ] = ACTIONS(129),
    [anon_sym_EQ_EQ] = ACTIONS(129),
    [anon_sym_BANG_EQ] = ACTIONS(129),
    [anon_sym_STAR] = ACTIONS(131),
    [anon_sym_SLASH] = ACTIONS(133),
    [anon_sym_STAR_STAR] = ACTIONS(135),
    [anon_sym_CARET] = ACTIONS(135),
    [aux_sym_binary_operator_token1] = ACTIONS(137),
    [anon_sym_PIPE_GT] = ACTIONS(137),
    [anon_sym_COLON] = ACTIONS(139),
    [anon_sym_DOLLAR] = ACTIONS(141),
    [anon_sym_AT] = ACTIONS(141),
    [aux_sym__hex_literal_token1] = ACTIONS(207),
    [sym__number_literal] = ACTIONS(205),
    [anon_sym_SQUOTE] = ACTIONS(207),
    [anon_sym_DQUOTE] = ACTIONS(207),
    [sym_return] = ACTIONS(205),
    [sym_next] = ACTIONS(205),
    [sym_break] = ACTIONS(205),
    [sym_true] = ACTIONS(205),
    [sym_false] = ACTIONS(205),
    [sym_null] = ACTIONS(205),
    [sym_inf] = ACTIONS(205),
    [sym_nan] = ACTIONS(205),
    [anon_sym_NA] = ACTIONS(205),
    [anon_sym_NA_integer_] = ACTIONS(205),
    [anon_sym_NA_real_] = ACTIONS(205),
    [anon_sym_NA_complex_] = ACTIONS(205),
    [anon_sym_NA_character_] = ACTIONS(205),
    [sym_dots] = ACTIONS(205),
    [sym_dot_dot_i] = ACTIONS(207),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(207),
    [sym__semicolon] = ACTIONS(207),
    [sym__raw_string_literal] = ACTIONS(207),
    [sym__external_else] = ACTIONS(351),
    [sym__external_open_parenthesis] = ACTIONS(145),
    [sym__external_open_brace] = ACTIONS(207),
    [sym__external_open_bracket] = ACTIONS(147),
    [sym__external_open_bracket2] = ACTIONS(149),
  },
  [35] = {
    [sym_call_arguments] = STATE(807),
    [sym_subset_arguments] = STATE(808),
    [sym_subset2_arguments] = STATE(810),
    [sym__else] = STATE(1604),
    [sym__open_parenthesis] = STATE(357),
    [sym__open_bracket] = STATE(358),
    [sym__open_bracket2] = STATE(359),
    [sym_identifier] = ACTIONS(205),
    [anon_sym_BSLASH] = ACTIONS(207),
    [anon_sym_function] = ACTIONS(205),
    [anon_sym_EQ] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(205),
    [anon_sym_for] = ACTIONS(205),
    [anon_sym_while] = ACTIONS(205),
    [anon_sym_repeat] = ACTIONS(205),
    [anon_sym_QMARK] = ACTIONS(207),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_BANG] = ACTIONS(205),
    [anon_sym_PLUS] = ACTIONS(59),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_LT_DASH] = ACTIONS(63),
    [anon_sym_LT_LT_DASH] = ACTIONS(63),
    [anon_sym_COLON_EQ] = ACTIONS(63),
    [anon_sym_DASH_GT] = ACTIONS(65),
    [anon_sym_DASH_GT_GT] = ACTIONS(67),
    [anon_sym_PIPE] = ACTIONS(69),
    [anon_sym_AMP] = ACTIONS(71),
    [anon_sym_PIPE_PIPE] = ACTIONS(73),
    [anon_sym_AMP_AMP] = ACTIONS(75),
    [anon_sym_LT] = ACTIONS(77),
    [anon_sym_LT_EQ] = ACTIONS(79),
    [anon_sym_GT] = ACTIONS(77),
    [anon_sym_GT_EQ] = ACTIONS(79),
    [anon_sym_EQ_EQ] = ACTIONS(79),
    [anon_sym_BANG_EQ] = ACTIONS(79),
    [anon_sym_STAR] = ACTIONS(81),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_STAR_STAR] = ACTIONS(85),
    [anon_sym_CARET] = ACTIONS(85),
    [aux_sym_binary_operator_token1] = ACTIONS(87),
    [anon_sym_PIPE_GT] = ACTIONS(87),
    [anon_sym_COLON] = ACTIONS(89),
    [anon_sym_DOLLAR] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(91),
    [aux_sym__hex_literal_token1] = ACTIONS(207),
    [sym__number_literal] = ACTIONS(205),
    [anon_sym_SQUOTE] = ACTIONS(207),
    [anon_sym_DQUOTE] = ACTIONS(207),
    [sym_return] = ACTIONS(205),
    [sym_next] = ACTIONS(205),
    [sym_break] = ACTIONS(205),
    [sym_true] = ACTIONS(205),
    [sym_false] = ACTIONS(205),
    [sym_null] = ACTIONS(205),
    [sym_inf] = ACTIONS(205),
    [sym_nan] = ACTIONS(205),
    [anon_sym_NA] = ACTIONS(205),
    [anon_sym_NA_integer_] = ACTIONS(205),
    [anon_sym_NA_real_] = ACTIONS(205),
    [anon_sym_NA_complex_] = ACTIONS(205),
    [anon_sym_NA_character_] = ACTIONS(205),
    [sym_dots] = ACTIONS(205),
    [sym_dot_dot_i] = ACTIONS(207),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(207),
    [sym__newline] = ACTIONS(207),
    [sym__raw_string_literal] = ACTIONS(207),
    [sym__external_else] = ACTIONS(353),
    [sym__external_open_parenthesis] = ACTIONS(95),
    [sym__external_open_brace] = ACTIONS(207),
    [sym__external_open_bracket] = ACTIONS(97),
    [sym__external_close_bracket] = ACTIONS(207),
    [sym__external_open_bracket2] = ACTIONS(99),
  },
  [36] = {
    [sym_call_arguments] = STATE(807),
    [sym_subset_arguments] = STATE(808),
    [sym_subset2_arguments] = STATE(810),
    [sym__else] = STATE(1601),
    [sym__open_parenthesis] = STATE(357),
    [sym__open_bracket] = STATE(358),
    [sym__open_bracket2] = STATE(359),
    [sym_identifier] = ACTIONS(103),
    [anon_sym_BSLASH] = ACTIONS(101),
    [anon_sym_function] = ACTIONS(103),
    [anon_sym_EQ] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(103),
    [anon_sym_for] = ACTIONS(103),
    [anon_sym_while] = ACTIONS(103),
    [anon_sym_repeat] = ACTIONS(103),
    [anon_sym_QMARK] = ACTIONS(101),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_BANG] = ACTIONS(103),
    [anon_sym_PLUS] = ACTIONS(59),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_LT_DASH] = ACTIONS(63),
    [anon_sym_LT_LT_DASH] = ACTIONS(63),
    [anon_sym_COLON_EQ] = ACTIONS(63),
    [anon_sym_DASH_GT] = ACTIONS(65),
    [anon_sym_DASH_GT_GT] = ACTIONS(67),
    [anon_sym_PIPE] = ACTIONS(69),
    [anon_sym_AMP] = ACTIONS(71),
    [anon_sym_PIPE_PIPE] = ACTIONS(73),
    [anon_sym_AMP_AMP] = ACTIONS(75),
    [anon_sym_LT] = ACTIONS(77),
    [anon_sym_LT_EQ] = ACTIONS(79),
    [anon_sym_GT] = ACTIONS(77),
    [anon_sym_GT_EQ] = ACTIONS(79),
    [anon_sym_EQ_EQ] = ACTIONS(79),
    [anon_sym_BANG_EQ] = ACTIONS(79),
    [anon_sym_STAR] = ACTIONS(81),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_STAR_STAR] = ACTIONS(85),
    [anon_sym_CARET] = ACTIONS(85),
    [aux_sym_binary_operator_token1] = ACTIONS(87),
    [anon_sym_PIPE_GT] = ACTIONS(87),
    [anon_sym_COLON] = ACTIONS(89),
    [anon_sym_DOLLAR] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(91),
    [aux_sym__hex_literal_token1] = ACTIONS(101),
    [sym__number_literal] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_DQUOTE] = ACTIONS(101),
    [sym_return] = ACTIONS(103),
    [sym_next] = ACTIONS(103),
    [sym_break] = ACTIONS(103),
    [sym_true] = ACTIONS(103),
    [sym_false] = ACTIONS(103),
    [sym_null] = ACTIONS(103),
    [sym_inf] = ACTIONS(103),
    [sym_nan] = ACTIONS(103),
    [anon_sym_NA] = ACTIONS(103),
    [anon_sym_NA_integer_] = ACTIONS(103),
    [anon_sym_NA_real_] = ACTIONS(103),
    [anon_sym_NA_complex_] = ACTIONS(103),
    [anon_sym_NA_character_] = ACTIONS(103),
    [sym_dots] = ACTIONS(103),
    [sym_dot_dot_i] = ACTIONS(101),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(101),
    [sym__newline] = ACTIONS(101),
    [sym__raw_string_literal] = ACTIONS(101),
    [sym__external_else] = ACTIONS(355),
    [sym__external_open_parenthesis] = ACTIONS(95),
    [sym__external_open_brace] = ACTIONS(101),
    [sym__external_open_bracket] = ACTIONS(97),
    [sym__external_close_bracket] = ACTIONS(101),
    [sym__external_open_bracket2] = ACTIONS(99),
  },
  [37] = {
    [sym_call_arguments] = STATE(795),
    [sym_subset_arguments] = STATE(796),
    [sym_subset2_arguments] = STATE(797),
    [sym__else] = STATE(1610),
    [sym__open_parenthesis] = STATE(361),
    [sym__open_bracket] = STATE(362),
    [sym__open_bracket2] = STATE(199),
    [sym_identifier] = ACTIONS(153),
    [anon_sym_BSLASH] = ACTIONS(155),
    [anon_sym_function] = ACTIONS(153),
    [anon_sym_EQ] = ACTIONS(273),
    [anon_sym_if] = ACTIONS(153),
    [anon_sym_for] = ACTIONS(153),
    [anon_sym_while] = ACTIONS(153),
    [anon_sym_repeat] = ACTIONS(153),
    [anon_sym_QMARK] = ACTIONS(155),
    [anon_sym_TILDE] = ACTIONS(275),
    [anon_sym_BANG] = ACTIONS(153),
    [anon_sym_PLUS] = ACTIONS(277),
    [anon_sym_DASH] = ACTIONS(279),
    [anon_sym_LT_DASH] = ACTIONS(281),
    [anon_sym_LT_LT_DASH] = ACTIONS(281),
    [anon_sym_COLON_EQ] = ACTIONS(281),
    [anon_sym_DASH_GT] = ACTIONS(283),
    [anon_sym_DASH_GT_GT] = ACTIONS(285),
    [anon_sym_PIPE] = ACTIONS(287),
    [anon_sym_AMP] = ACTIONS(289),
    [anon_sym_PIPE_PIPE] = ACTIONS(291),
    [anon_sym_AMP_AMP] = ACTIONS(293),
    [anon_sym_LT] = ACTIONS(295),
    [anon_sym_LT_EQ] = ACTIONS(297),
    [anon_sym_GT] = ACTIONS(295),
    [anon_sym_GT_EQ] = ACTIONS(297),
    [anon_sym_EQ_EQ] = ACTIONS(297),
    [anon_sym_BANG_EQ] = ACTIONS(297),
    [anon_sym_STAR] = ACTIONS(299),
    [anon_sym_SLASH] = ACTIONS(301),
    [anon_sym_STAR_STAR] = ACTIONS(303),
    [anon_sym_CARET] = ACTIONS(303),
    [aux_sym_binary_operator_token1] = ACTIONS(305),
    [anon_sym_PIPE_GT] = ACTIONS(305),
    [anon_sym_COLON] = ACTIONS(307),
    [anon_sym_DOLLAR] = ACTIONS(309),
    [anon_sym_AT] = ACTIONS(309),
    [aux_sym__hex_literal_token1] = ACTIONS(155),
    [sym__number_literal] = ACTIONS(153),
    [anon_sym_SQUOTE] = ACTIONS(155),
    [anon_sym_DQUOTE] = ACTIONS(155),
    [sym_return] = ACTIONS(153),
    [sym_next] = ACTIONS(153),
    [sym_break] = ACTIONS(153),
    [sym_true] = ACTIONS(153),
    [sym_false] = ACTIONS(153),
    [sym_null] = ACTIONS(153),
    [sym_inf] = ACTIONS(153),
    [sym_nan] = ACTIONS(153),
    [anon_sym_NA] = ACTIONS(153),
    [anon_sym_NA_integer_] = ACTIONS(153),
    [anon_sym_NA_real_] = ACTIONS(153),
    [anon_sym_NA_complex_] = ACTIONS(153),
    [anon_sym_NA_character_] = ACTIONS(153),
    [sym_dots] = ACTIONS(153),
    [sym_dot_dot_i] = ACTIONS(155),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(155),
    [sym__newline] = ACTIONS(155),
    [sym__raw_string_literal] = ACTIONS(155),
    [sym__external_else] = ACTIONS(357),
    [sym__external_open_parenthesis] = ACTIONS(313),
    [sym__external_open_brace] = ACTIONS(155),
    [sym__external_open_bracket] = ACTIONS(315),
    [sym__external_open_bracket2] = ACTIONS(317),
    [sym__external_close_bracket2] = ACTIONS(155),
  },
  [38] = {
    [sym_call_arguments] = STATE(795),
    [sym_subset_arguments] = STATE(796),
    [sym_subset2_arguments] = STATE(797),
    [sym__else] = STATE(1613),
    [sym__open_parenthesis] = STATE(361),
    [sym__open_bracket] = STATE(362),
    [sym__open_bracket2] = STATE(199),
    [sym_identifier] = ACTIONS(51),
    [anon_sym_BSLASH] = ACTIONS(53),
    [anon_sym_function] = ACTIONS(51),
    [anon_sym_EQ] = ACTIONS(273),
    [anon_sym_if] = ACTIONS(51),
    [anon_sym_for] = ACTIONS(51),
    [anon_sym_while] = ACTIONS(51),
    [anon_sym_repeat] = ACTIONS(51),
    [anon_sym_QMARK] = ACTIONS(53),
    [anon_sym_TILDE] = ACTIONS(275),
    [anon_sym_BANG] = ACTIONS(51),
    [anon_sym_PLUS] = ACTIONS(277),
    [anon_sym_DASH] = ACTIONS(279),
    [anon_sym_LT_DASH] = ACTIONS(281),
    [anon_sym_LT_LT_DASH] = ACTIONS(281),
    [anon_sym_COLON_EQ] = ACTIONS(281),
    [anon_sym_DASH_GT] = ACTIONS(283),
    [anon_sym_DASH_GT_GT] = ACTIONS(285),
    [anon_sym_PIPE] = ACTIONS(287),
    [anon_sym_AMP] = ACTIONS(289),
    [anon_sym_PIPE_PIPE] = ACTIONS(291),
    [anon_sym_AMP_AMP] = ACTIONS(293),
    [anon_sym_LT] = ACTIONS(295),
    [anon_sym_LT_EQ] = ACTIONS(297),
    [anon_sym_GT] = ACTIONS(295),
    [anon_sym_GT_EQ] = ACTIONS(297),
    [anon_sym_EQ_EQ] = ACTIONS(297),
    [anon_sym_BANG_EQ] = ACTIONS(297),
    [anon_sym_STAR] = ACTIONS(299),
    [anon_sym_SLASH] = ACTIONS(301),
    [anon_sym_STAR_STAR] = ACTIONS(303),
    [anon_sym_CARET] = ACTIONS(303),
    [aux_sym_binary_operator_token1] = ACTIONS(305),
    [anon_sym_PIPE_GT] = ACTIONS(305),
    [anon_sym_COLON] = ACTIONS(307),
    [anon_sym_DOLLAR] = ACTIONS(309),
    [anon_sym_AT] = ACTIONS(309),
    [aux_sym__hex_literal_token1] = ACTIONS(53),
    [sym__number_literal] = ACTIONS(51),
    [anon_sym_SQUOTE] = ACTIONS(53),
    [anon_sym_DQUOTE] = ACTIONS(53),
    [sym_return] = ACTIONS(51),
    [sym_next] = ACTIONS(51),
    [sym_break] = ACTIONS(51),
    [sym_true] = ACTIONS(51),
    [sym_false] = ACTIONS(51),
    [sym_null] = ACTIONS(51),
    [sym_inf] = ACTIONS(51),
    [sym_nan] = ACTIONS(51),
    [anon_sym_NA] = ACTIONS(51),
    [anon_sym_NA_integer_] = ACTIONS(51),
    [anon_sym_NA_real_] = ACTIONS(51),
    [anon_sym_NA_complex_] = ACTIONS(51),
    [anon_sym_NA_character_] = ACTIONS(51),
    [sym_dots] = ACTIONS(51),
    [sym_dot_dot_i] = ACTIONS(53),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(53),
    [sym__newline] = ACTIONS(53),
    [sym__raw_string_literal] = ACTIONS(53),
    [sym__external_else] = ACTIONS(359),
    [sym__external_open_parenthesis] = ACTIONS(313),
    [sym__external_open_brace] = ACTIONS(53),
    [sym__external_open_bracket] = ACTIONS(315),
    [sym__external_open_bracket2] = ACTIONS(317),
    [sym__external_close_bracket2] = ACTIONS(53),
  },
  [39] = {
    [sym_call_arguments] = STATE(795),
    [sym_subset_arguments] = STATE(796),
    [sym_subset2_arguments] = STATE(797),
    [sym__else] = STATE(1614),
    [sym__open_parenthesis] = STATE(361),
    [sym__open_bracket] = STATE(362),
    [sym__open_bracket2] = STATE(199),
    [sym_identifier] = ACTIONS(205),
    [anon_sym_BSLASH] = ACTIONS(207),
    [anon_sym_function] = ACTIONS(205),
    [anon_sym_EQ] = ACTIONS(273),
    [anon_sym_if] = ACTIONS(205),
    [anon_sym_for] = ACTIONS(205),
    [anon_sym_while] = ACTIONS(205),
    [anon_sym_repeat] = ACTIONS(205),
    [anon_sym_QMARK] = ACTIONS(207),
    [anon_sym_TILDE] = ACTIONS(275),
    [anon_sym_BANG] = ACTIONS(205),
    [anon_sym_PLUS] = ACTIONS(277),
    [anon_sym_DASH] = ACTIONS(279),
    [anon_sym_LT_DASH] = ACTIONS(281),
    [anon_sym_LT_LT_DASH] = ACTIONS(281),
    [anon_sym_COLON_EQ] = ACTIONS(281),
    [anon_sym_DASH_GT] = ACTIONS(283),
    [anon_sym_DASH_GT_GT] = ACTIONS(285),
    [anon_sym_PIPE] = ACTIONS(287),
    [anon_sym_AMP] = ACTIONS(289),
    [anon_sym_PIPE_PIPE] = ACTIONS(291),
    [anon_sym_AMP_AMP] = ACTIONS(293),
    [anon_sym_LT] = ACTIONS(295),
    [anon_sym_LT_EQ] = ACTIONS(297),
    [anon_sym_GT] = ACTIONS(295),
    [anon_sym_GT_EQ] = ACTIONS(297),
    [anon_sym_EQ_EQ] = ACTIONS(297),
    [anon_sym_BANG_EQ] = ACTIONS(297),
    [anon_sym_STAR] = ACTIONS(299),
    [anon_sym_SLASH] = ACTIONS(301),
    [anon_sym_STAR_STAR] = ACTIONS(303),
    [anon_sym_CARET] = ACTIONS(303),
    [aux_sym_binary_operator_token1] = ACTIONS(305),
    [anon_sym_PIPE_GT] = ACTIONS(305),
    [anon_sym_COLON] = ACTIONS(307),
    [anon_sym_DOLLAR] = ACTIONS(309),
    [anon_sym_AT] = ACTIONS(309),
    [aux_sym__hex_literal_token1] = ACTIONS(207),
    [sym__number_literal] = ACTIONS(205),
    [anon_sym_SQUOTE] = ACTIONS(207),
    [anon_sym_DQUOTE] = ACTIONS(207),
    [sym_return] = ACTIONS(205),
    [sym_next] = ACTIONS(205),
    [sym_break] = ACTIONS(205),
    [sym_true] = ACTIONS(205),
    [sym_false] = ACTIONS(205),
    [sym_null] = ACTIONS(205),
    [sym_inf] = ACTIONS(205),
    [sym_nan] = ACTIONS(205),
    [anon_sym_NA] = ACTIONS(205),
    [anon_sym_NA_integer_] = ACTIONS(205),
    [anon_sym_NA_real_] = ACTIONS(205),
    [anon_sym_NA_complex_] = ACTIONS(205),
    [anon_sym_NA_character_] = ACTIONS(205),
    [sym_dots] = ACTIONS(205),
    [sym_dot_dot_i] = ACTIONS(207),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(207),
    [sym__newline] = ACTIONS(207),
    [sym__raw_string_literal] = ACTIONS(207),
    [sym__external_else] = ACTIONS(361),
    [sym__external_open_parenthesis] = ACTIONS(313),
    [sym__external_open_brace] = ACTIONS(207),
    [sym__external_open_bracket] = ACTIONS(315),
    [sym__external_open_bracket2] = ACTIONS(317),
    [sym__external_close_bracket2] = ACTIONS(207),
  },
  [40] = {
    [sym_call_arguments] = STATE(795),
    [sym_subset_arguments] = STATE(796),
    [sym_subset2_arguments] = STATE(797),
    [sym__else] = STATE(1616),
    [sym__open_parenthesis] = STATE(361),
    [sym__open_bracket] = STATE(362),
    [sym__open_bracket2] = STATE(199),
    [sym_identifier] = ACTIONS(103),
    [anon_sym_BSLASH] = ACTIONS(101),
    [anon_sym_function] = ACTIONS(103),
    [anon_sym_EQ] = ACTIONS(273),
    [anon_sym_if] = ACTIONS(103),
    [anon_sym_for] = ACTIONS(103),
    [anon_sym_while] = ACTIONS(103),
    [anon_sym_repeat] = ACTIONS(103),
    [anon_sym_QMARK] = ACTIONS(101),
    [anon_sym_TILDE] = ACTIONS(275),
    [anon_sym_BANG] = ACTIONS(103),
    [anon_sym_PLUS] = ACTIONS(277),
    [anon_sym_DASH] = ACTIONS(279),
    [anon_sym_LT_DASH] = ACTIONS(281),
    [anon_sym_LT_LT_DASH] = ACTIONS(281),
    [anon_sym_COLON_EQ] = ACTIONS(281),
    [anon_sym_DASH_GT] = ACTIONS(283),
    [anon_sym_DASH_GT_GT] = ACTIONS(285),
    [anon_sym_PIPE] = ACTIONS(287),
    [anon_sym_AMP] = ACTIONS(289),
    [anon_sym_PIPE_PIPE] = ACTIONS(291),
    [anon_sym_AMP_AMP] = ACTIONS(293),
    [anon_sym_LT] = ACTIONS(295),
    [anon_sym_LT_EQ] = ACTIONS(297),
    [anon_sym_GT] = ACTIONS(295),
    [anon_sym_GT_EQ] = ACTIONS(297),
    [anon_sym_EQ_EQ] = ACTIONS(297),
    [anon_sym_BANG_EQ] = ACTIONS(297),
    [anon_sym_STAR] = ACTIONS(299),
    [anon_sym_SLASH] = ACTIONS(301),
    [anon_sym_STAR_STAR] = ACTIONS(303),
    [anon_sym_CARET] = ACTIONS(303),
    [aux_sym_binary_operator_token1] = ACTIONS(305),
    [anon_sym_PIPE_GT] = ACTIONS(305),
    [anon_sym_COLON] = ACTIONS(307),
    [anon_sym_DOLLAR] = ACTIONS(309),
    [anon_sym_AT] = ACTIONS(309),
    [aux_sym__hex_literal_token1] = ACTIONS(101),
    [sym__number_literal] = ACTIONS(103),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_DQUOTE] = ACTIONS(101),
    [sym_return] = ACTIONS(103),
    [sym_next] = ACTIONS(103),
    [sym_break] = ACTIONS(103),
    [sym_true] = ACTIONS(103),
    [sym_false] = ACTIONS(103),
    [sym_null] = ACTIONS(103),
    [sym_inf] = ACTIONS(103),
    [sym_nan] = ACTIONS(103),
    [anon_sym_NA] = ACTIONS(103),
    [anon_sym_NA_integer_] = ACTIONS(103),
    [anon_sym_NA_real_] = ACTIONS(103),
    [anon_sym_NA_complex_] = ACTIONS(103),
    [anon_sym_NA_character_] = ACTIONS(103),
    [sym_dots] = ACTIONS(103),
    [sym_dot_dot_i] = ACTIONS(101),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(101),
    [sym__newline] = ACTIONS(101),
    [sym__raw_string_literal] = ACTIONS(101),
    [sym__external_else] = ACTIONS(363),
    [sym__external_open_parenthesis] = ACTIONS(313),
    [sym__external_open_brace] = ACTIONS(101),
    [sym__external_open_bracket] = ACTIONS(315),
    [sym__external_open_bracket2] = ACTIONS(317),
    [sym__external_close_bracket2] = ACTIONS(101),
  },
  [41] = {
    [sym_call_arguments] = STATE(795),
    [sym_subset_arguments] = STATE(796),
    [sym_subset2_arguments] = STATE(797),
    [sym__else] = STATE(1618),
    [sym__open_parenthesis] = STATE(361),
    [sym__open_bracket] = STATE(362),
    [sym__open_bracket2] = STATE(199),
    [sym_identifier] = ACTIONS(51),
    [anon_sym_BSLASH] = ACTIONS(53),
    [anon_sym_function] = ACTIONS(51),
    [anon_sym_EQ] = ACTIONS(273),
    [anon_sym_if] = ACTIONS(51),
    [anon_sym_for] = ACTIONS(51),
    [anon_sym_while] = ACTIONS(51),
    [anon_sym_repeat] = ACTIONS(51),
    [anon_sym_QMARK] = ACTIONS(53),
    [anon_sym_TILDE] = ACTIONS(275),
    [anon_sym_BANG] = ACTIONS(51),
    [anon_sym_PLUS] = ACTIONS(277),
    [anon_sym_DASH] = ACTIONS(279),
    [anon_sym_LT_DASH] = ACTIONS(281),
    [anon_sym_LT_LT_DASH] = ACTIONS(281),
    [anon_sym_COLON_EQ] = ACTIONS(281),
    [anon_sym_DASH_GT] = ACTIONS(283),
    [anon_sym_DASH_GT_GT] = ACTIONS(285),
    [anon_sym_PIPE] = ACTIONS(287),
    [anon_sym_AMP] = ACTIONS(289),
    [anon_sym_PIPE_PIPE] = ACTIONS(291),
    [anon_sym_AMP_AMP] = ACTIONS(293),
    [anon_sym_LT] = ACTIONS(295),
    [anon_sym_LT_EQ] = ACTIONS(297),
    [anon_sym_GT] = ACTIONS(295),
    [anon_sym_GT_EQ] = ACTIONS(297),
    [anon_sym_EQ_EQ] = ACTIONS(297),
    [anon_sym_BANG_EQ] = ACTIONS(297),
    [anon_sym_STAR] = ACTIONS(299),
    [anon_sym_SLASH] = ACTIONS(301),
    [anon_sym_STAR_STAR] = ACTIONS(303),
    [anon_sym_CARET] = ACTIONS(303),
    [aux_sym_binary_operator_token1] = ACTIONS(305),
    [anon_sym_PIPE_GT] = ACTIONS(305),
    [anon_sym_COLON] = ACTIONS(307),
    [anon_sym_DOLLAR] = ACTIONS(309),
    [anon_sym_AT] = ACTIONS(309),
    [aux_sym__hex_literal_token1] = ACTIONS(53),
    [sym__number_literal] = ACTIONS(51),
    [anon_sym_SQUOTE] = ACTIONS(53),
    [anon_sym_DQUOTE] = ACTIONS(53),
    [sym_return] = ACTIONS(51),
    [sym_next] = ACTIONS(51),
    [sym_break] = ACTIONS(51),
    [sym_true] = ACTIONS(51),
    [sym_false] = ACTIONS(51),
    [sym_null] = ACTIONS(51),
    [sym_inf] = ACTIONS(51),
    [sym_nan] = ACTIONS(51),
    [anon_sym_NA] = ACTIONS(51),
    [anon_sym_NA_integer_] = ACTIONS(51),
    [anon_sym_NA_real_] = ACTIONS(51),
    [anon_sym_NA_complex_] = ACTIONS(51),
    [anon_sym_NA_character_] = ACTIONS(51),
    [sym_dots] = ACTIONS(51),
    [sym_dot_dot_i] = ACTIONS(53),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(53),
    [sym__newline] = ACTIONS(53),
    [sym__raw_string_literal] = ACTIONS(53),
    [sym__external_else] = ACTIONS(365),
    [sym__external_open_parenthesis] = ACTIONS(313),
    [sym__external_open_brace] = ACTIONS(53),
    [sym__external_open_bracket] = ACTIONS(315),
    [sym__external_open_bracket2] = ACTIONS(317),
    [sym__external_close_bracket2] = ACTIONS(53),
  },
  [42] = {
    [sym_call_arguments] = STATE(807),
    [sym_subset_arguments] = STATE(808),
    [sym_subset2_arguments] = STATE(810),
    [sym__open_parenthesis] = STATE(357),
    [sym__open_bracket] = STATE(358),
    [sym__open_bracket2] = STATE(359),
    [sym_identifier] = ACTIONS(367),
    [anon_sym_BSLASH] = ACTIONS(369),
    [anon_sym_function] = ACTIONS(367),
    [anon_sym_EQ] = ACTIONS(367),
    [anon_sym_if] = ACTIONS(367),
    [anon_sym_for] = ACTIONS(367),
    [anon_sym_while] = ACTIONS(367),
    [anon_sym_repeat] = ACTIONS(367),
    [anon_sym_QMARK] = ACTIONS(369),
    [anon_sym_TILDE] = ACTIONS(369),
    [anon_sym_BANG] = ACTIONS(367),
    [anon_sym_PLUS] = ACTIONS(59),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_LT_DASH] = ACTIONS(369),
    [anon_sym_LT_LT_DASH] = ACTIONS(369),
    [anon_sym_COLON_EQ] = ACTIONS(369),
    [anon_sym_DASH_GT] = ACTIONS(367),
    [anon_sym_DASH_GT_GT] = ACTIONS(369),
    [anon_sym_PIPE] = ACTIONS(69),
    [anon_sym_AMP] = ACTIONS(71),
    [anon_sym_PIPE_PIPE] = ACTIONS(73),
    [anon_sym_AMP_AMP] = ACTIONS(75),
    [anon_sym_LT] = ACTIONS(77),
    [anon_sym_LT_EQ] = ACTIONS(79),
    [anon_sym_GT] = ACTIONS(77),
    [anon_sym_GT_EQ] = ACTIONS(79),
    [anon_sym_EQ_EQ] = ACTIONS(79),
    [anon_sym_BANG_EQ] = ACTIONS(79),
    [anon_sym_STAR] = ACTIONS(81),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_STAR_STAR] = ACTIONS(85),
    [anon_sym_CARET] = ACTIONS(85),
    [aux_sym_binary_operator_token1] = ACTIONS(87),
    [anon_sym_PIPE_GT] = ACTIONS(87),
    [anon_sym_COLON] = ACTIONS(89),
    [anon_sym_DOLLAR] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(91),
    [aux_sym__hex_literal_token1] = ACTIONS(369),
    [sym__number_literal] = ACTIONS(367),
    [anon_sym_SQUOTE] = ACTIONS(369),
    [anon_sym_DQUOTE] = ACTIONS(369),
    [sym_return] = ACTIONS(367),
    [sym_next] = ACTIONS(367),
    [sym_break] = ACTIONS(367),
    [sym_true] = ACTIONS(367),
    [sym_false] = ACTIONS(367),
    [sym_null] = ACTIONS(367),
    [sym_inf] = ACTIONS(367),
    [sym_nan] = ACTIONS(367),
    [anon_sym_NA] = ACTIONS(367),
    [anon_sym_NA_integer_] = ACTIONS(367),
    [anon_sym_NA_real_] = ACTIONS(367),
    [anon_sym_NA_complex_] = ACTIONS(367),
    [anon_sym_NA_character_] = ACTIONS(367),
    [sym_dots] = ACTIONS(367),
    [sym_dot_dot_i] = ACTIONS(369),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(369),
    [sym__newline] = ACTIONS(369),
    [sym__raw_string_literal] = ACTIONS(369),
    [sym__external_else] = ACTIONS(369),
    [sym__external_open_parenthesis] = ACTIONS(95),
    [sym__external_open_brace] = ACTIONS(369),
    [sym__external_open_bracket] = ACTIONS(97),
    [sym__external_close_bracket] = ACTIONS(369),
    [sym__external_open_bracket2] = ACTIONS(99),
  },
  [43] = {
    [sym_call_arguments] = STATE(862),
    [sym_subset_arguments] = STATE(885),
    [sym_subset2_arguments] = STATE(900),
    [sym__open_parenthesis] = STATE(341),
    [sym__open_bracket] = STATE(342),
    [sym__open_bracket2] = STATE(343),
    [ts_builtin_sym_end] = ACTIONS(369),
    [sym_identifier] = ACTIONS(367),
    [anon_sym_BSLASH] = ACTIONS(369),
    [anon_sym_function] = ACTIONS(367),
    [anon_sym_EQ] = ACTIONS(367),
    [anon_sym_if] = ACTIONS(367),
    [anon_sym_for] = ACTIONS(367),
    [anon_sym_while] = ACTIONS(367),
    [anon_sym_repeat] = ACTIONS(367),
    [anon_sym_QMARK] = ACTIONS(369),
    [anon_sym_TILDE] = ACTIONS(369),
    [anon_sym_BANG] = ACTIONS(367),
    [anon_sym_PLUS] = ACTIONS(369),
    [anon_sym_DASH] = ACTIONS(367),
    [anon_sym_LT_DASH] = ACTIONS(369),
    [anon_sym_LT_LT_DASH] = ACTIONS(369),
    [anon_sym_COLON_EQ] = ACTIONS(369),
    [anon_sym_DASH_GT] = ACTIONS(367),
    [anon_sym_DASH_GT_GT] = ACTIONS(369),
    [anon_sym_PIPE] = ACTIONS(367),
    [anon_sym_AMP] = ACTIONS(367),
    [anon_sym_PIPE_PIPE] = ACTIONS(369),
    [anon_sym_AMP_AMP] = ACTIONS(369),
    [anon_sym_LT] = ACTIONS(367),
    [anon_sym_LT_EQ] = ACTIONS(369),
    [anon_sym_GT] = ACTIONS(367),
    [anon_sym_GT_EQ] = ACTIONS(369),
    [anon_sym_EQ_EQ] = ACTIONS(369),
    [anon_sym_BANG_EQ] = ACTIONS(369),
    [anon_sym_STAR] = ACTIONS(367),
    [anon_sym_SLASH] = ACTIONS(369),
    [anon_sym_STAR_STAR] = ACTIONS(135),
    [anon_sym_CARET] = ACTIONS(135),
    [aux_sym_binary_operator_token1] = ACTIONS(369),
    [anon_sym_PIPE_GT] = ACTIONS(369),
    [anon_sym_COLON] = ACTIONS(367),
    [anon_sym_DOLLAR] = ACTIONS(141),
    [anon_sym_AT] = ACTIONS(141),
    [aux_sym__hex_literal_token1] = ACTIONS(369),
    [sym__number_literal] = ACTIONS(367),
    [anon_sym_SQUOTE] = ACTIONS(369),
    [anon_sym_DQUOTE] = ACTIONS(369),
    [sym_return] = ACTIONS(367),
    [sym_next] = ACTIONS(367),
    [sym_break] = ACTIONS(367),
    [sym_true] = ACTIONS(367),
    [sym_false] = ACTIONS(367),
    [sym_null] = ACTIONS(367),
    [sym_inf] = ACTIONS(367),
    [sym_nan] = ACTIONS(367),
    [anon_sym_NA] = ACTIONS(367),
    [anon_sym_NA_integer_] = ACTIONS(367),
    [anon_sym_NA_real_] = ACTIONS(367),
    [anon_sym_NA_complex_] = ACTIONS(367),
    [anon_sym_NA_character_] = ACTIONS(367),
    [sym_dots] = ACTIONS(367),
    [sym_dot_dot_i] = ACTIONS(369),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(369),
    [sym__semicolon] = ACTIONS(369),
    [sym__raw_string_literal] = ACTIONS(369),
    [sym__external_else] = ACTIONS(369),
    [sym__external_open_parenthesis] = ACTIONS(145),
    [sym__external_open_brace] = ACTIONS(369),
    [sym__external_open_bracket] = ACTIONS(147),
    [sym__external_open_bracket2] = ACTIONS(149),
  },
  [44] = {
    [sym_call_arguments] = STATE(862),
    [sym_subset_arguments] = STATE(885),
    [sym_subset2_arguments] = STATE(900),
    [sym__open_parenthesis] = STATE(341),
    [sym__open_bracket] = STATE(342),
    [sym__open_bracket2] = STATE(343),
    [ts_builtin_sym_end] = ACTIONS(371),
    [sym_identifier] = ACTIONS(373),
    [anon_sym_BSLASH] = ACTIONS(371),
    [anon_sym_function] = ACTIONS(373),
    [anon_sym_EQ] = ACTIONS(105),
    [anon_sym_if] = ACTIONS(373),
    [anon_sym_for] = ACTIONS(373),
    [anon_sym_while] = ACTIONS(373),
    [anon_sym_repeat] = ACTIONS(373),
    [anon_sym_QMARK] = ACTIONS(371),
    [anon_sym_TILDE] = ACTIONS(107),
    [anon_sym_BANG] = ACTIONS(373),
    [anon_sym_PLUS] = ACTIONS(109),
    [anon_sym_DASH] = ACTIONS(111),
    [anon_sym_LT_DASH] = ACTIONS(113),
    [anon_sym_LT_LT_DASH] = ACTIONS(113),
    [anon_sym_COLON_EQ] = ACTIONS(113),
    [anon_sym_DASH_GT] = ACTIONS(115),
    [anon_sym_DASH_GT_GT] = ACTIONS(117),
    [anon_sym_PIPE] = ACTIONS(119),
    [anon_sym_AMP] = ACTIONS(121),
    [anon_sym_PIPE_PIPE] = ACTIONS(123),
    [anon_sym_AMP_AMP] = ACTIONS(125),
    [anon_sym_LT] = ACTIONS(127),
    [anon_sym_LT_EQ] = ACTIONS(129),
    [anon_sym_GT] = ACTIONS(127),
    [anon_sym_GT_EQ] = ACTIONS(129),
    [anon_sym_EQ_EQ] = ACTIONS(129),
    [anon_sym_BANG_EQ] = ACTIONS(129),
    [anon_sym_STAR] = ACTIONS(131),
    [anon_sym_SLASH] = ACTIONS(133),
    [anon_sym_STAR_STAR] = ACTIONS(135),
    [anon_sym_CARET] = ACTIONS(135),
    [aux_sym_binary_operator_token1] = ACTIONS(137),
    [anon_sym_PIPE_GT] = ACTIONS(137),
    [anon_sym_COLON] = ACTIONS(139),
    [anon_sym_DOLLAR] = ACTIONS(141),
    [anon_sym_AT] = ACTIONS(141),
    [aux_sym__hex_literal_token1] = ACTIONS(371),
    [sym__number_literal] = ACTIONS(373),
    [anon_sym_SQUOTE] = ACTIONS(371),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [sym_return] = ACTIONS(373),
    [sym_next] = ACTIONS(373),
    [sym_break] = ACTIONS(373),
    [sym_true] = ACTIONS(373),
    [sym_false] = ACTIONS(373),
    [sym_null] = ACTIONS(373),
    [sym_inf] = ACTIONS(373),
    [sym_nan] = ACTIONS(373),
    [anon_sym_NA] = ACTIONS(373),
    [anon_sym_NA_integer_] = ACTIONS(373),
    [anon_sym_NA_real_] = ACTIONS(373),
    [anon_sym_NA_complex_] = ACTIONS(373),
    [anon_sym_NA_character_] = ACTIONS(373),
    [sym_dots] = ACTIONS(373),
    [sym_dot_dot_i] = ACTIONS(371),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(371),
    [sym__semicolon] = ACTIONS(371),
    [sym__raw_string_literal] = ACTIONS(371),
    [sym__external_else] = ACTIONS(371),
    [sym__external_open_parenthesis] = ACTIONS(145),
    [sym__external_open_brace] = ACTIONS(371),
    [sym__external_open_bracket] = ACTIONS(147),
    [sym__external_open_bracket2] = ACTIONS(149),
  },
  [45] = {
    [sym_call_arguments] = STATE(862),
    [sym_subset_arguments] = STATE(885),
    [sym_subset2_arguments] = STATE(900),
    [sym__open_parenthesis] = STATE(341),
    [sym__open_bracket] = STATE(342),
    [sym__open_bracket2] = STATE(343),
    [ts_builtin_sym_end] = ACTIONS(375),
    [sym_identifier] = ACTIONS(377),
    [anon_sym_BSLASH] = ACTIONS(375),
    [anon_sym_function] = ACTIONS(377),
    [anon_sym_EQ] = ACTIONS(105),
    [anon_sym_if] = ACTIONS(377),
    [anon_sym_for] = ACTIONS(377),
    [anon_sym_while] = ACTIONS(377),
    [anon_sym_repeat] = ACTIONS(377),
    [anon_sym_QMARK] = ACTIONS(375),
    [anon_sym_TILDE] = ACTIONS(107),
    [anon_sym_BANG] = ACTIONS(377),
    [anon_sym_PLUS] = ACTIONS(109),
    [anon_sym_DASH] = ACTIONS(111),
    [anon_sym_LT_DASH] = ACTIONS(113),
    [anon_sym_LT_LT_DASH] = ACTIONS(113),
    [anon_sym_COLON_EQ] = ACTIONS(113),
    [anon_sym_DASH_GT] = ACTIONS(115),
    [anon_sym_DASH_GT_GT] = ACTIONS(117),
    [anon_sym_PIPE] = ACTIONS(119),
    [anon_sym_AMP] = ACTIONS(121),
    [anon_sym_PIPE_PIPE] = ACTIONS(123),
    [anon_sym_AMP_AMP] = ACTIONS(125),
    [anon_sym_LT] = ACTIONS(127),
    [anon_sym_LT_EQ] = ACTIONS(129),
    [anon_sym_GT] = ACTIONS(127),
    [anon_sym_GT_EQ] = ACTIONS(129),
    [anon_sym_EQ_EQ] = ACTIONS(129),
    [anon_sym_BANG_EQ] = ACTIONS(129),
    [anon_sym_STAR] = ACTIONS(131),
    [anon_sym_SLASH] = ACTIONS(133),
    [anon_sym_STAR_STAR] = ACTIONS(135),
    [anon_sym_CARET] = ACTIONS(135),
    [aux_sym_binary_operator_token1] = ACTIONS(137),
    [anon_sym_PIPE_GT] = ACTIONS(137),
    [anon_sym_COLON] = ACTIONS(139),
    [anon_sym_DOLLAR] = ACTIONS(141),
    [anon_sym_AT] = ACTIONS(141),
    [aux_sym__hex_literal_token1] = ACTIONS(375),
    [sym__number_literal] = ACTIONS(377),
    [anon_sym_SQUOTE] = ACTIONS(375),
    [anon_sym_DQUOTE] = ACTIONS(375),
    [sym_return] = ACTIONS(377),
    [sym_next] = ACTIONS(377),
    [sym_break] = ACTIONS(377),
    [sym_true] = ACTIONS(377),
    [sym_false] = ACTIONS(377),
    [sym_null] = ACTIONS(377),
    [sym_inf] = ACTIONS(377),
    [sym_nan] = ACTIONS(377),
    [anon_sym_NA] = ACTIONS(377),
    [anon_sym_NA_integer_] = ACTIONS(377),
    [anon_sym_NA_real_] = ACTIONS(377),
    [anon_sym_NA_complex_] = ACTIONS(377),
    [anon_sym_NA_character_] = ACTIONS(377),
    [sym_dots] = ACTIONS(377),
    [sym_dot_dot_i] = ACTIONS(375),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(375),
    [sym__semicolon] = ACTIONS(375),
    [sym__raw_string_literal] = ACTIONS(375),
    [sym__external_else] = ACTIONS(375),
    [sym__external_open_parenthesis] = ACTIONS(145),
    [sym__external_open_brace] = ACTIONS(375),
    [sym__external_open_bracket] = ACTIONS(147),
    [sym__external_open_bracket2] = ACTIONS(149),
  },
  [46] = {
    [sym_call_arguments] = STATE(862),
    [sym_subset_arguments] = STATE(885),
    [sym_subset2_arguments] = STATE(900),
    [sym__open_parenthesis] = STATE(341),
    [sym__open_bracket] = STATE(342),
    [sym__open_bracket2] = STATE(343),
    [ts_builtin_sym_end] = ACTIONS(379),
    [sym_identifier] = ACTIONS(381),
    [anon_sym_BSLASH] = ACTIONS(379),
    [anon_sym_function] = ACTIONS(381),
    [anon_sym_EQ] = ACTIONS(105),
    [anon_sym_if] = ACTIONS(381),
    [anon_sym_for] = ACTIONS(381),
    [anon_sym_while] = ACTIONS(381),
    [anon_sym_repeat] = ACTIONS(381),
    [anon_sym_QMARK] = ACTIONS(379),
    [anon_sym_TILDE] = ACTIONS(107),
    [anon_sym_BANG] = ACTIONS(381),
    [anon_sym_PLUS] = ACTIONS(109),
    [anon_sym_DASH] = ACTIONS(111),
    [anon_sym_LT_DASH] = ACTIONS(113),
    [anon_sym_LT_LT_DASH] = ACTIONS(113),
    [anon_sym_COLON_EQ] = ACTIONS(113),
    [anon_sym_DASH_GT] = ACTIONS(115),
    [anon_sym_DASH_GT_GT] = ACTIONS(117),
    [anon_sym_PIPE] = ACTIONS(119),
    [anon_sym_AMP] = ACTIONS(121),
    [anon_sym_PIPE_PIPE] = ACTIONS(123),
    [anon_sym_AMP_AMP] = ACTIONS(125),
    [anon_sym_LT] = ACTIONS(127),
    [anon_sym_LT_EQ] = ACTIONS(129),
    [anon_sym_GT] = ACTIONS(127),
    [anon_sym_GT_EQ] = ACTIONS(129),
    [anon_sym_EQ_EQ] = ACTIONS(129),
    [anon_sym_BANG_EQ] = ACTIONS(129),
    [anon_sym_STAR] = ACTIONS(131),
    [anon_sym_SLASH] = ACTIONS(133),
    [anon_sym_STAR_STAR] = ACTIONS(135),
    [anon_sym_CARET] = ACTIONS(135),
    [aux_sym_binary_operator_token1] = ACTIONS(137),
    [anon_sym_PIPE_GT] = ACTIONS(137),
    [anon_sym_COLON] = ACTIONS(139),
    [anon_sym_DOLLAR] = ACTIONS(141),
    [anon_sym_AT] = ACTIONS(141),
    [aux_sym__hex_literal_token1] = ACTIONS(379),
    [sym__number_literal] = ACTIONS(381),
    [anon_sym_SQUOTE] = ACTIONS(379),
    [anon_sym_DQUOTE] = ACTIONS(379),
    [sym_return] = ACTIONS(381),
    [sym_next] = ACTIONS(381),
    [sym_break] = ACTIONS(381),
    [sym_true] = ACTIONS(381),
    [sym_false] = ACTIONS(381),
    [sym_null] = ACTIONS(381),
    [sym_inf] = ACTIONS(381),
    [sym_nan] = ACTIONS(381),
    [anon_sym_NA] = ACTIONS(381),
    [anon_sym_NA_integer_] = ACTIONS(381),
    [anon_sym_NA_real_] = ACTIONS(381),
    [anon_sym_NA_complex_] = ACTIONS(381),
    [anon_sym_NA_character_] = ACTIONS(381),
    [sym_dots] = ACTIONS(381),
    [sym_dot_dot_i] = ACTIONS(379),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(379),
    [sym__semicolon] = ACTIONS(379),
    [sym__raw_string_literal] = ACTIONS(379),
    [sym__external_else] = ACTIONS(379),
    [sym__external_open_parenthesis] = ACTIONS(145),
    [sym__external_open_brace] = ACTIONS(379),
    [sym__external_open_bracket] = ACTIONS(147),
    [sym__external_open_bracket2] = ACTIONS(149),
  },
  [47] = {
    [sym_call_arguments] = STATE(862),
    [sym_subset_arguments] = STATE(885),
    [sym_subset2_arguments] = STATE(900),
    [sym__open_parenthesis] = STATE(341),
    [sym__open_bracket] = STATE(342),
    [sym__open_bracket2] = STATE(343),
    [ts_builtin_sym_end] = ACTIONS(379),
    [sym_identifier] = ACTIONS(381),
    [anon_sym_BSLASH] = ACTIONS(379),
    [anon_sym_function] = ACTIONS(381),
    [anon_sym_EQ] = ACTIONS(381),
    [anon_sym_if] = ACTIONS(381),
    [anon_sym_for] = ACTIONS(381),
    [anon_sym_while] = ACTIONS(381),
    [anon_sym_repeat] = ACTIONS(381),
    [anon_sym_QMARK] = ACTIONS(379),
    [anon_sym_TILDE] = ACTIONS(379),
    [anon_sym_BANG] = ACTIONS(381),
    [anon_sym_PLUS] = ACTIONS(109),
    [anon_sym_DASH] = ACTIONS(111),
    [anon_sym_LT_DASH] = ACTIONS(379),
    [anon_sym_LT_LT_DASH] = ACTIONS(379),
    [anon_sym_COLON_EQ] = ACTIONS(379),
    [anon_sym_DASH_GT] = ACTIONS(381),
    [anon_sym_DASH_GT_GT] = ACTIONS(379),
    [anon_sym_PIPE] = ACTIONS(119),
    [anon_sym_AMP] = ACTIONS(121),
    [anon_sym_PIPE_PIPE] = ACTIONS(123),
    [anon_sym_AMP_AMP] = ACTIONS(125),
    [anon_sym_LT] = ACTIONS(127),
    [anon_sym_LT_EQ] = ACTIONS(129),
    [anon_sym_GT] = ACTIONS(127),
    [anon_sym_GT_EQ] = ACTIONS(129),
    [anon_sym_EQ_EQ] = ACTIONS(129),
    [anon_sym_BANG_EQ] = ACTIONS(129),
    [anon_sym_STAR] = ACTIONS(131),
    [anon_sym_SLASH] = ACTIONS(133),
    [anon_sym_STAR_STAR] = ACTIONS(135),
    [anon_sym_CARET] = ACTIONS(135),
    [aux_sym_binary_operator_token1] = ACTIONS(137),
    [anon_sym_PIPE_GT] = ACTIONS(137),
    [anon_sym_COLON] = ACTIONS(139),
    [anon_sym_DOLLAR] = ACTIONS(141),
    [anon_sym_AT] = ACTIONS(141),
    [aux_sym__hex_literal_token1] = ACTIONS(379),
    [sym__number_literal] = ACTIONS(381),
    [anon_sym_SQUOTE] = ACTIONS(379),
    [anon_sym_DQUOTE] = ACTIONS(379),
    [sym_return] = ACTIONS(381),
    [sym_next] = ACTIONS(381),
    [sym_break] = ACTIONS(381),
    [sym_true] = ACTIONS(381),
    [sym_false] = ACTIONS(381),
    [sym_null] = ACTIONS(381),
    [sym_inf] = ACTIONS(381),
    [sym_nan] = ACTIONS(381),
    [anon_sym_NA] = ACTIONS(381),
    [anon_sym_NA_integer_] = ACTIONS(381),
    [anon_sym_NA_real_] = ACTIONS(381),
    [anon_sym_NA_complex_] = ACTIONS(381),
    [anon_sym_NA_character_] = ACTIONS(381),
    [sym_dots] = ACTIONS(381),
    [sym_dot_dot_i] = ACTIONS(379),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(379),
    [sym__semicolon] = ACTIONS(379),
    [sym__raw_string_literal] = ACTIONS(379),
    [sym__external_else] = ACTIONS(379),
    [sym__external_open_parenthesis] = ACTIONS(145),
    [sym__external_open_brace] = ACTIONS(379),
    [sym__external_open_bracket] = ACTIONS(147),
    [sym__external_open_bracket2] = ACTIONS(149),
  },
  [48] = {
    [sym_call_arguments] = STATE(862),
    [sym_subset_arguments] = STATE(885),
    [sym_subset2_arguments] = STATE(900),
    [sym__open_parenthesis] = STATE(341),
    [sym__open_bracket] = STATE(342),
    [sym__open_bracket2] = STATE(343),
    [ts_builtin_sym_end] = ACTIONS(379),
    [sym_identifier] = ACTIONS(381),
    [anon_sym_BSLASH] = ACTIONS(379),
    [anon_sym_function] = ACTIONS(381),
    [anon_sym_EQ] = ACTIONS(381),
    [anon_sym_if] = ACTIONS(381),
    [anon_sym_for] = ACTIONS(381),
    [anon_sym_while] = ACTIONS(381),
    [anon_sym_repeat] = ACTIONS(381),
    [anon_sym_QMARK] = ACTIONS(379),
    [anon_sym_TILDE] = ACTIONS(379),
    [anon_sym_BANG] = ACTIONS(381),
    [anon_sym_PLUS] = ACTIONS(109),
    [anon_sym_DASH] = ACTIONS(111),
    [anon_sym_LT_DASH] = ACTIONS(379),
    [anon_sym_LT_LT_DASH] = ACTIONS(379),
    [anon_sym_COLON_EQ] = ACTIONS(379),
    [anon_sym_DASH_GT] = ACTIONS(381),
    [anon_sym_DASH_GT_GT] = ACTIONS(379),
    [anon_sym_PIPE] = ACTIONS(381),
    [anon_sym_AMP] = ACTIONS(381),
    [anon_sym_PIPE_PIPE] = ACTIONS(379),
    [anon_sym_AMP_AMP] = ACTIONS(379),
    [anon_sym_LT] = ACTIONS(127),
    [anon_sym_LT_EQ] = ACTIONS(129),
    [anon_sym_GT] = ACTIONS(127),
    [anon_sym_GT_EQ] = ACTIONS(129),
    [anon_sym_EQ_EQ] = ACTIONS(129),
    [anon_sym_BANG_EQ] = ACTIONS(129),
    [anon_sym_STAR] = ACTIONS(131),
    [anon_sym_SLASH] = ACTIONS(133),
    [anon_sym_STAR_STAR] = ACTIONS(135),
    [anon_sym_CARET] = ACTIONS(135),
    [aux_sym_binary_operator_token1] = ACTIONS(137),
    [anon_sym_PIPE_GT] = ACTIONS(137),
    [anon_sym_COLON] = ACTIONS(139),
    [anon_sym_DOLLAR] = ACTIONS(141),
    [anon_sym_AT] = ACTIONS(141),
    [aux_sym__hex_literal_token1] = ACTIONS(379),
    [sym__number_literal] = ACTIONS(381),
    [anon_sym_SQUOTE] = ACTIONS(379),
    [anon_sym_DQUOTE] = ACTIONS(379),
    [sym_return] = ACTIONS(381),
    [sym_next] = ACTIONS(381),
    [sym_break] = ACTIONS(381),
    [sym_true] = ACTIONS(381),
    [sym_false] = ACTIONS(381),
    [sym_null] = ACTIONS(381),
    [sym_inf] = ACTIONS(381),
    [sym_nan] = ACTIONS(381),
    [anon_sym_NA] = ACTIONS(381),
    [anon_sym_NA_integer_] = ACTIONS(381),
    [anon_sym_NA_real_] = ACTIONS(381),
    [anon_sym_NA_complex_] = ACTIONS(381),
    [anon_sym_NA_character_] = ACTIONS(381),
    [sym_dots] = ACTIONS(381),
    [sym_dot_dot_i] = ACTIONS(379),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(379),
    [sym__semicolon] = ACTIONS(379),
    [sym__raw_string_literal] = ACTIONS(379),
    [sym__external_else] = ACTIONS(379),
    [sym__external_open_parenthesis] = ACTIONS(145),
    [sym__external_open_brace] = ACTIONS(379),
    [sym__external_open_bracket] = ACTIONS(147),
    [sym__external_open_bracket2] = ACTIONS(149),
  },
  [49] = {
    [sym_call_arguments] = STATE(862),
    [sym_subset_arguments] = STATE(885),
    [sym_subset2_arguments] = STATE(900),
    [sym__open_parenthesis] = STATE(341),
    [sym__open_bracket] = STATE(342),
    [sym__open_bracket2] = STATE(343),
    [ts_builtin_sym_end] = ACTIONS(379),
    [sym_identifier] = ACTIONS(381),
    [anon_sym_BSLASH] = ACTIONS(379),
    [anon_sym_function] = ACTIONS(381),
    [anon_sym_EQ] = ACTIONS(381),
    [anon_sym_if] = ACTIONS(381),
    [anon_sym_for] = ACTIONS(381),
    [anon_sym_while] = ACTIONS(381),
    [anon_sym_repeat] = ACTIONS(381),
    [anon_sym_QMARK] = ACTIONS(379),
    [anon_sym_TILDE] = ACTIONS(379),
    [anon_sym_BANG] = ACTIONS(381),
    [anon_sym_PLUS] = ACTIONS(379),
    [anon_sym_DASH] = ACTIONS(381),
    [anon_sym_LT_DASH] = ACTIONS(379),
    [anon_sym_LT_LT_DASH] = ACTIONS(379),
    [anon_sym_COLON_EQ] = ACTIONS(379),
    [anon_sym_DASH_GT] = ACTIONS(381),
    [anon_sym_DASH_GT_GT] = ACTIONS(379),
    [anon_sym_PIPE] = ACTIONS(381),
    [anon_sym_AMP] = ACTIONS(381),
    [anon_sym_PIPE_PIPE] = ACTIONS(379),
    [anon_sym_AMP_AMP] = ACTIONS(379),
    [anon_sym_LT] = ACTIONS(381),
    [anon_sym_LT_EQ] = ACTIONS(379),
    [anon_sym_GT] = ACTIONS(381),
    [anon_sym_GT_EQ] = ACTIONS(379),
    [anon_sym_EQ_EQ] = ACTIONS(379),
    [anon_sym_BANG_EQ] = ACTIONS(379),
    [anon_sym_STAR] = ACTIONS(381),
    [anon_sym_SLASH] = ACTIONS(379),
    [anon_sym_STAR_STAR] = ACTIONS(135),
    [anon_sym_CARET] = ACTIONS(135),
    [aux_sym_binary_operator_token1] = ACTIONS(379),
    [anon_sym_PIPE_GT] = ACTIONS(379),
    [anon_sym_COLON] = ACTIONS(381),
    [anon_sym_DOLLAR] = ACTIONS(141),
    [anon_sym_AT] = ACTIONS(141),
    [aux_sym__hex_literal_token1] = ACTIONS(379),
    [sym__number_literal] = ACTIONS(381),
    [anon_sym_SQUOTE] = ACTIONS(379),
    [anon_sym_DQUOTE] = ACTIONS(379),
    [sym_return] = ACTIONS(381),
    [sym_next] = ACTIONS(381),
    [sym_break] = ACTIONS(381),
    [sym_true] = ACTIONS(381),
    [sym_false] = ACTIONS(381),
    [sym_null] = ACTIONS(381),
    [sym_inf] = ACTIONS(381),
    [sym_nan] = ACTIONS(381),
    [anon_sym_NA] = ACTIONS(381),
    [anon_sym_NA_integer_] = ACTIONS(381),
    [anon_sym_NA_real_] = ACTIONS(381),
    [anon_sym_NA_complex_] = ACTIONS(381),
    [anon_sym_NA_character_] = ACTIONS(381),
    [sym_dots] = ACTIONS(381),
    [sym_dot_dot_i] = ACTIONS(379),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(379),
    [sym__semicolon] = ACTIONS(379),
    [sym__raw_string_literal] = ACTIONS(379),
    [sym__external_else] = ACTIONS(379),
    [sym__external_open_parenthesis] = ACTIONS(145),
    [sym__external_open_brace] = ACTIONS(379),
    [sym__external_open_bracket] = ACTIONS(147),
    [sym__external_open_bracket2] = ACTIONS(149),
  },
  [50] = {
    [sym_call_arguments] = STATE(862),
    [sym_subset_arguments] = STATE(885),
    [sym_subset2_arguments] = STATE(900),
    [sym__open_parenthesis] = STATE(341),
    [sym__open_bracket] = STATE(342),
    [sym__open_bracket2] = STATE(343),
    [ts_builtin_sym_end] = ACTIONS(383),
    [sym_identifier] = ACTIONS(385),
    [anon_sym_BSLASH] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_EQ] = ACTIONS(105),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_for] = ACTIONS(385),
    [anon_sym_while] = ACTIONS(385),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_QMARK] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(107),
    [anon_sym_BANG] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(109),
    [anon_sym_DASH] = ACTIONS(111),
    [anon_sym_LT_DASH] = ACTIONS(383),
    [anon_sym_LT_LT_DASH] = ACTIONS(383),
    [anon_sym_COLON_EQ] = ACTIONS(383),
    [anon_sym_DASH_GT] = ACTIONS(115),
    [anon_sym_DASH_GT_GT] = ACTIONS(117),
    [anon_sym_PIPE] = ACTIONS(119),
    [anon_sym_AMP] = ACTIONS(121),
    [anon_sym_PIPE_PIPE] = ACTIONS(123),
    [anon_sym_AMP_AMP] = ACTIONS(125),
    [anon_sym_LT] = ACTIONS(127),
    [anon_sym_LT_EQ] = ACTIONS(129),
    [anon_sym_GT] = ACTIONS(127),
    [anon_sym_GT_EQ] = ACTIONS(129),
    [anon_sym_EQ_EQ] = ACTIONS(129),
    [anon_sym_BANG_EQ] = ACTIONS(129),
    [anon_sym_STAR] = ACTIONS(131),
    [anon_sym_SLASH] = ACTIONS(133),
    [anon_sym_STAR_STAR] = ACTIONS(135),
    [anon_sym_CARET] = ACTIONS(135),
    [aux_sym_binary_operator_token1] = ACTIONS(137),
    [anon_sym_PIPE_GT] = ACTIONS(137),
    [anon_sym_COLON] = ACTIONS(139),
    [anon_sym_DOLLAR] = ACTIONS(141),
    [anon_sym_AT] = ACTIONS(141),
    [aux_sym__hex_literal_token1] = ACTIONS(383),
    [sym__number_literal] = ACTIONS(385),
    [anon_sym_SQUOTE] = ACTIONS(383),
    [anon_sym_DQUOTE] = ACTIONS(383),
    [sym_return] = ACTIONS(385),
    [sym_next] = ACTIONS(385),
    [sym_break] = ACTIONS(385),
    [sym_true] = ACTIONS(385),
    [sym_false] = ACTIONS(385),
    [sym_null] = ACTIONS(385),
    [sym_inf] = ACTIONS(385),
    [sym_nan] = ACTIONS(385),
    [anon_sym_NA] = ACTIONS(385),
    [anon_sym_NA_integer_] = ACTIONS(385),
    [anon_sym_NA_real_] = ACTIONS(385),
    [anon_sym_NA_complex_] = ACTIONS(385),
    [anon_sym_NA_character_] = ACTIONS(385),
    [sym_dots] = ACTIONS(385),
    [sym_dot_dot_i] = ACTIONS(383),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(383),
    [sym__semicolon] = ACTIONS(383),
    [sym__raw_string_literal] = ACTIONS(383),
    [sym__external_else] = ACTIONS(383),
    [sym__external_open_parenthesis] = ACTIONS(145),
    [sym__external_open_brace] = ACTIONS(383),
    [sym__external_open_bracket] = ACTIONS(147),
    [sym__external_open_bracket2] = ACTIONS(149),
  },
  [51] = {
    [sym_call_arguments] = STATE(862),
    [sym_subset_arguments] = STATE(885),
    [sym_subset2_arguments] = STATE(900),
    [sym__open_parenthesis] = STATE(341),
    [sym__open_bracket] = STATE(342),
    [sym__open_bracket2] = STATE(343),
    [ts_builtin_sym_end] = ACTIONS(383),
    [sym_identifier] = ACTIONS(385),
    [anon_sym_BSLASH] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_EQ] = ACTIONS(105),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_for] = ACTIONS(385),
    [anon_sym_while] = ACTIONS(385),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_QMARK] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(107),
    [anon_sym_BANG] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(109),
    [anon_sym_DASH] = ACTIONS(111),
    [anon_sym_LT_DASH] = ACTIONS(113),
    [anon_sym_LT_LT_DASH] = ACTIONS(113),
    [anon_sym_COLON_EQ] = ACTIONS(113),
    [anon_sym_DASH_GT] = ACTIONS(115),
    [anon_sym_DASH_GT_GT] = ACTIONS(117),
    [anon_sym_PIPE] = ACTIONS(119),
    [anon_sym_AMP] = ACTIONS(121),
    [anon_sym_PIPE_PIPE] = ACTIONS(123),
    [anon_sym_AMP_AMP] = ACTIONS(125),
    [anon_sym_LT] = ACTIONS(127),
    [anon_sym_LT_EQ] = ACTIONS(129),
    [anon_sym_GT] = ACTIONS(127),
    [anon_sym_GT_EQ] = ACTIONS(129),
    [anon_sym_EQ_EQ] = ACTIONS(129),
    [anon_sym_BANG_EQ] = ACTIONS(129),
    [anon_sym_STAR] = ACTIONS(131),
    [anon_sym_SLASH] = ACTIONS(133),
    [anon_sym_STAR_STAR] = ACTIONS(135),
    [anon_sym_CARET] = ACTIONS(135),
    [aux_sym_binary_operator_token1] = ACTIONS(137),
    [anon_sym_PIPE_GT] = ACTIONS(137),
    [anon_sym_COLON] = ACTIONS(139),
    [anon_sym_DOLLAR] = ACTIONS(141),
    [anon_sym_AT] = ACTIONS(141),
    [aux_sym__hex_literal_token1] = ACTIONS(383),
    [sym__number_literal] = ACTIONS(385),
    [anon_sym_SQUOTE] = ACTIONS(383),
    [anon_sym_DQUOTE] = ACTIONS(383),
    [sym_return] = ACTIONS(385),
    [sym_next] = ACTIONS(385),
    [sym_break] = ACTIONS(385),
    [sym_true] = ACTIONS(385),
    [sym_false] = ACTIONS(385),
    [sym_null] = ACTIONS(385),
    [sym_inf] = ACTIONS(385),
    [sym_nan] = ACTIONS(385),
    [anon_sym_NA] = ACTIONS(385),
    [anon_sym_NA_integer_] = ACTIONS(385),
    [anon_sym_NA_real_] = ACTIONS(385),
    [anon_sym_NA_complex_] = ACTIONS(385),
    [anon_sym_NA_character_] = ACTIONS(385),
    [sym_dots] = ACTIONS(385),
    [sym_dot_dot_i] = ACTIONS(383),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(383),
    [sym__semicolon] = ACTIONS(383),
    [sym__raw_string_literal] = ACTIONS(383),
    [sym__external_else] = ACTIONS(383),
    [sym__external_open_parenthesis] = ACTIONS(145),
    [sym__external_open_brace] = ACTIONS(383),
    [sym__external_open_bracket] = ACTIONS(147),
    [sym__external_open_bracket2] = ACTIONS(149),
  },
  [52] = {
    [sym_call_arguments] = STATE(862),
    [sym_subset_arguments] = STATE(885),
    [sym_subset2_arguments] = STATE(900),
    [sym__open_parenthesis] = STATE(341),
    [sym__open_bracket] = STATE(342),
    [sym__open_bracket2] = STATE(343),
    [ts_builtin_sym_end] = ACTIONS(383),
    [sym_identifier] = ACTIONS(385),
    [anon_sym_BSLASH] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_EQ] = ACTIONS(385),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_for] = ACTIONS(385),
    [anon_sym_while] = ACTIONS(385),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_QMARK] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(383),
    [anon_sym_BANG] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(109),
    [anon_sym_DASH] = ACTIONS(111),
    [anon_sym_LT_DASH] = ACTIONS(383),
    [anon_sym_LT_LT_DASH] = ACTIONS(383),
    [anon_sym_COLON_EQ] = ACTIONS(383),
    [anon_sym_DASH_GT] = ACTIONS(385),
    [anon_sym_DASH_GT_GT] = ACTIONS(383),
    [anon_sym_PIPE] = ACTIONS(119),
    [anon_sym_AMP] = ACTIONS(121),
    [anon_sym_PIPE_PIPE] = ACTIONS(123),
    [anon_sym_AMP_AMP] = ACTIONS(125),
    [anon_sym_LT] = ACTIONS(127),
    [anon_sym_LT_EQ] = ACTIONS(129),
    [anon_sym_GT] = ACTIONS(127),
    [anon_sym_GT_EQ] = ACTIONS(129),
    [anon_sym_EQ_EQ] = ACTIONS(129),
    [anon_sym_BANG_EQ] = ACTIONS(129),
    [anon_sym_STAR] = ACTIONS(131),
    [anon_sym_SLASH] = ACTIONS(133),
    [anon_sym_STAR_STAR] = ACTIONS(135),
    [anon_sym_CARET] = ACTIONS(135),
    [aux_sym_binary_operator_token1] = ACTIONS(137),
    [anon_sym_PIPE_GT] = ACTIONS(137),
    [anon_sym_COLON] = ACTIONS(139),
    [anon_sym_DOLLAR] = ACTIONS(141),
    [anon_sym_AT] = ACTIONS(141),
    [aux_sym__hex_literal_token1] = ACTIONS(383),
    [sym__number_literal] = ACTIONS(385),
    [anon_sym_SQUOTE] = ACTIONS(383),
    [anon_sym_DQUOTE] = ACTIONS(383),
    [sym_return] = ACTIONS(385),
    [sym_next] = ACTIONS(385),
    [sym_break] = ACTIONS(385),
    [sym_true] = ACTIONS(385),
    [sym_false] = ACTIONS(385),
    [sym_null] = ACTIONS(385),
    [sym_inf] = ACTIONS(385),
    [sym_nan] = ACTIONS(385),
    [anon_sym_NA] = ACTIONS(385),
    [anon_sym_NA_integer_] = ACTIONS(385),
    [anon_sym_NA_real_] = ACTIONS(385),
    [anon_sym_NA_complex_] = ACTIONS(385),
    [anon_sym_NA_character_] = ACTIONS(385),
    [sym_dots] = ACTIONS(385),
    [sym_dot_dot_i] = ACTIONS(383),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(383),
    [sym__semicolon] = ACTIONS(383),
    [sym__raw_string_literal] = ACTIONS(383),
    [sym__external_else] = ACTIONS(383),
    [sym__external_open_parenthesis] = ACTIONS(145),
    [sym__external_open_brace] = ACTIONS(383),
    [sym__external_open_bracket] = ACTIONS(147),
    [sym__external_open_bracket2] = ACTIONS(149),
  },
  [53] = {
    [sym_call_arguments] = STATE(862),
    [sym_subset_arguments] = STATE(885),
    [sym_subset2_arguments] = STATE(900),
    [sym__open_parenthesis] = STATE(341),
    [sym__open_bracket] = STATE(342),
    [sym__open_bracket2] = STATE(343),
    [ts_builtin_sym_end] = ACTIONS(383),
    [sym_identifier] = ACTIONS(385),
    [anon_sym_BSLASH] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_EQ] = ACTIONS(385),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_for] = ACTIONS(385),
    [anon_sym_while] = ACTIONS(385),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_QMARK] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(383),
    [anon_sym_BANG] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(385),
    [anon_sym_LT_DASH] = ACTIONS(383),
    [anon_sym_LT_LT_DASH] = ACTIONS(383),
    [anon_sym_COLON_EQ] = ACTIONS(383),
    [anon_sym_DASH_GT] = ACTIONS(385),
    [anon_sym_DASH_GT_GT] = ACTIONS(383),
    [anon_sym_PIPE] = ACTIONS(385),
    [anon_sym_AMP] = ACTIONS(385),
    [anon_sym_PIPE_PIPE] = ACTIONS(383),
    [anon_sym_AMP_AMP] = ACTIONS(383),
    [anon_sym_LT] = ACTIONS(385),
    [anon_sym_LT_EQ] = ACTIONS(383),
    [anon_sym_GT] = ACTIONS(385),
    [anon_sym_GT_EQ] = ACTIONS(383),
    [anon_sym_EQ_EQ] = ACTIONS(383),
    [anon_sym_BANG_EQ] = ACTIONS(383),
    [anon_sym_STAR] = ACTIONS(131),
    [anon_sym_SLASH] = ACTIONS(133),
    [anon_sym_STAR_STAR] = ACTIONS(135),
    [anon_sym_CARET] = ACTIONS(135),
    [aux_sym_binary_operator_token1] = ACTIONS(137),
    [anon_sym_PIPE_GT] = ACTIONS(137),
    [anon_sym_COLON] = ACTIONS(139),
    [anon_sym_DOLLAR] = ACTIONS(141),
    [anon_sym_AT] = ACTIONS(141),
    [aux_sym__hex_literal_token1] = ACTIONS(383),
    [sym__number_literal] = ACTIONS(385),
    [anon_sym_SQUOTE] = ACTIONS(383),
    [anon_sym_DQUOTE] = ACTIONS(383),
    [sym_return] = ACTIONS(385),
    [sym_next] = ACTIONS(385),
    [sym_break] = ACTIONS(385),
    [sym_true] = ACTIONS(385),
    [sym_false] = ACTIONS(385),
    [sym_null] = ACTIONS(385),
    [sym_inf] = ACTIONS(385),
    [sym_nan] = ACTIONS(385),
    [anon_sym_NA] = ACTIONS(385),
    [anon_sym_NA_integer_] = ACTIONS(385),
    [anon_sym_NA_real_] = ACTIONS(385),
    [anon_sym_NA_complex_] = ACTIONS(385),
    [anon_sym_NA_character_] = ACTIONS(385),
    [sym_dots] = ACTIONS(385),
    [sym_dot_dot_i] = ACTIONS(383),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(383),
    [sym__semicolon] = ACTIONS(383),
    [sym__raw_string_literal] = ACTIONS(383),
    [sym__external_else] = ACTIONS(383),
    [sym__external_open_parenthesis] = ACTIONS(145),
    [sym__external_open_brace] = ACTIONS(383),
    [sym__external_open_bracket] = ACTIONS(147),
    [sym__external_open_bracket2] = ACTIONS(149),
  },
  [54] = {
    [sym_call_arguments] = STATE(862),
    [sym_subset_arguments] = STATE(885),
    [sym_subset2_arguments] = STATE(900),
    [sym__open_parenthesis] = STATE(341),
    [sym__open_bracket] = STATE(342),
    [sym__open_bracket2] = STATE(343),
    [ts_builtin_sym_end] = ACTIONS(383),
    [sym_identifier] = ACTIONS(385),
    [anon_sym_BSLASH] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_EQ] = ACTIONS(105),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_for] = ACTIONS(385),
    [anon_sym_while] = ACTIONS(385),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_QMARK] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(107),
    [anon_sym_BANG] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(109),
    [anon_sym_DASH] = ACTIONS(111),
    [anon_sym_LT_DASH] = ACTIONS(113),
    [anon_sym_LT_LT_DASH] = ACTIONS(113),
    [anon_sym_COLON_EQ] = ACTIONS(113),
    [anon_sym_DASH_GT] = ACTIONS(115),
    [anon_sym_DASH_GT_GT] = ACTIONS(117),
    [anon_sym_PIPE] = ACTIONS(119),
    [anon_sym_AMP] = ACTIONS(121),
    [anon_sym_PIPE_PIPE] = ACTIONS(123),
    [anon_sym_AMP_AMP] = ACTIONS(125),
    [anon_sym_LT] = ACTIONS(127),
    [anon_sym_LT_EQ] = ACTIONS(129),
    [anon_sym_GT] = ACTIONS(127),
    [anon_sym_GT_EQ] = ACTIONS(129),
    [anon_sym_EQ_EQ] = ACTIONS(129),
    [anon_sym_BANG_EQ] = ACTIONS(129),
    [anon_sym_STAR] = ACTIONS(131),
    [anon_sym_SLASH] = ACTIONS(133),
    [anon_sym_STAR_STAR] = ACTIONS(135),
    [anon_sym_CARET] = ACTIONS(135),
    [aux_sym_binary_operator_token1] = ACTIONS(137),
    [anon_sym_PIPE_GT] = ACTIONS(137),
    [anon_sym_COLON] = ACTIONS(139),
    [anon_sym_DOLLAR] = ACTIONS(141),
    [anon_sym_AT] = ACTIONS(141),
    [aux_sym__hex_literal_token1] = ACTIONS(383),
    [sym__number_literal] = ACTIONS(385),
    [anon_sym_SQUOTE] = ACTIONS(383),
    [anon_sym_DQUOTE] = ACTIONS(383),
    [sym_return] = ACTIONS(385),
    [sym_next] = ACTIONS(385),
    [sym_break] = ACTIONS(385),
    [sym_true] = ACTIONS(385),
    [sym_false] = ACTIONS(385),
    [sym_null] = ACTIONS(385),
    [sym_inf] = ACTIONS(385),
    [sym_nan] = ACTIONS(385),
    [anon_sym_NA] = ACTIONS(385),
    [anon_sym_NA_integer_] = ACTIONS(385),
    [anon_sym_NA_real_] = ACTIONS(385),
    [anon_sym_NA_complex_] = ACTIONS(385),
    [anon_sym_NA_character_] = ACTIONS(385),
    [sym_dots] = ACTIONS(385),
    [sym_dot_dot_i] = ACTIONS(383),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(383),
    [sym__semicolon] = ACTIONS(383),
    [sym__raw_string_literal] = ACTIONS(383),
    [sym__external_else] = ACTIONS(383),
    [sym__external_open_parenthesis] = ACTIONS(145),
    [sym__external_open_brace] = ACTIONS(383),
    [sym__external_open_bracket] = ACTIONS(147),
    [sym__external_open_bracket2] = ACTIONS(149),
  },
  [55] = {
    [sym_call_arguments] = STATE(862),
    [sym_subset_arguments] = STATE(885),
    [sym_subset2_arguments] = STATE(900),
    [sym__open_parenthesis] = STATE(341),
    [sym__open_bracket] = STATE(342),
    [sym__open_bracket2] = STATE(343),
    [ts_builtin_sym_end] = ACTIONS(383),
    [sym_identifier] = ACTIONS(385),
    [anon_sym_BSLASH] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_EQ] = ACTIONS(385),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_for] = ACTIONS(385),
    [anon_sym_while] = ACTIONS(385),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_QMARK] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(107),
    [anon_sym_BANG] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(109),
    [anon_sym_DASH] = ACTIONS(111),
    [anon_sym_LT_DASH] = ACTIONS(383),
    [anon_sym_LT_LT_DASH] = ACTIONS(383),
    [anon_sym_COLON_EQ] = ACTIONS(383),
    [anon_sym_DASH_GT] = ACTIONS(385),
    [anon_sym_DASH_GT_GT] = ACTIONS(383),
    [anon_sym_PIPE] = ACTIONS(119),
    [anon_sym_AMP] = ACTIONS(121),
    [anon_sym_PIPE_PIPE] = ACTIONS(123),
    [anon_sym_AMP_AMP] = ACTIONS(125),
    [anon_sym_LT] = ACTIONS(127),
    [anon_sym_LT_EQ] = ACTIONS(129),
    [anon_sym_GT] = ACTIONS(127),
    [anon_sym_GT_EQ] = ACTIONS(129),
    [anon_sym_EQ_EQ] = ACTIONS(129),
    [anon_sym_BANG_EQ] = ACTIONS(129),
    [anon_sym_STAR] = ACTIONS(131),
    [anon_sym_SLASH] = ACTIONS(133),
    [anon_sym_STAR_STAR] = ACTIONS(135),
    [anon_sym_CARET] = ACTIONS(135),
    [aux_sym_binary_operator_token1] = ACTIONS(137),
    [anon_sym_PIPE_GT] = ACTIONS(137),
    [anon_sym_COLON] = ACTIONS(139),
    [anon_sym_DOLLAR] = ACTIONS(141),
    [anon_sym_AT] = ACTIONS(141),
    [aux_sym__hex_literal_token1] = ACTIONS(383),
    [sym__number_literal] = ACTIONS(385),
    [anon_sym_SQUOTE] = ACTIONS(383),
    [anon_sym_DQUOTE] = ACTIONS(383),
    [sym_return] = ACTIONS(385),
    [sym_next] = ACTIONS(385),
    [sym_break] = ACTIONS(385),
    [sym_true] = ACTIONS(385),
    [sym_false] = ACTIONS(385),
    [sym_null] = ACTIONS(385),
    [sym_inf] = ACTIONS(385),
    [sym_nan] = ACTIONS(385),
    [anon_sym_NA] = ACTIONS(385),
    [anon_sym_NA_integer_] = ACTIONS(385),
    [anon_sym_NA_real_] = ACTIONS(385),
    [anon_sym_NA_complex_] = ACTIONS(385),
    [anon_sym_NA_character_] = ACTIONS(385),
    [sym_dots] = ACTIONS(385),
    [sym_dot_dot_i] = ACTIONS(383),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(383),
    [sym__semicolon] = ACTIONS(383),
    [sym__raw_string_literal] = ACTIONS(383),
    [sym__external_else] = ACTIONS(383),
    [sym__external_open_parenthesis] = ACTIONS(145),
    [sym__external_open_brace] = ACTIONS(383),
    [sym__external_open_bracket] = ACTIONS(147),
    [sym__external_open_bracket2] = ACTIONS(149),
  },
  [56] = {
    [sym_call_arguments] = STATE(862),
    [sym_subset_arguments] = STATE(885),
    [sym_subset2_arguments] = STATE(900),
    [sym__open_parenthesis] = STATE(341),
    [sym__open_bracket] = STATE(342),
    [sym__open_bracket2] = STATE(343),
    [ts_builtin_sym_end] = ACTIONS(383),
    [sym_identifier] = ACTIONS(385),
    [anon_sym_BSLASH] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_EQ] = ACTIONS(385),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_for] = ACTIONS(385),
    [anon_sym_while] = ACTIONS(385),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_QMARK] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(383),
    [anon_sym_BANG] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(109),
    [anon_sym_DASH] = ACTIONS(111),
    [anon_sym_LT_DASH] = ACTIONS(383),
    [anon_sym_LT_LT_DASH] = ACTIONS(383),
    [anon_sym_COLON_EQ] = ACTIONS(383),
    [anon_sym_DASH_GT] = ACTIONS(385),
    [anon_sym_DASH_GT_GT] = ACTIONS(383),
    [anon_sym_PIPE] = ACTIONS(385),
    [anon_sym_AMP] = ACTIONS(121),
    [anon_sym_PIPE_PIPE] = ACTIONS(383),
    [anon_sym_AMP_AMP] = ACTIONS(125),
    [anon_sym_LT] = ACTIONS(127),
    [anon_sym_LT_EQ] = ACTIONS(129),
    [anon_sym_GT] = ACTIONS(127),
    [anon_sym_GT_EQ] = ACTIONS(129),
    [anon_sym_EQ_EQ] = ACTIONS(129),
    [anon_sym_BANG_EQ] = ACTIONS(129),
    [anon_sym_STAR] = ACTIONS(131),
    [anon_sym_SLASH] = ACTIONS(133),
    [anon_sym_STAR_STAR] = ACTIONS(135),
    [anon_sym_CARET] = ACTIONS(135),
    [aux_sym_binary_operator_token1] = ACTIONS(137),
    [anon_sym_PIPE_GT] = ACTIONS(137),
    [anon_sym_COLON] = ACTIONS(139),
    [anon_sym_DOLLAR] = ACTIONS(141),
    [anon_sym_AT] = ACTIONS(141),
    [aux_sym__hex_literal_token1] = ACTIONS(383),
    [sym__number_literal] = ACTIONS(385),
    [anon_sym_SQUOTE] = ACTIONS(383),
    [anon_sym_DQUOTE] = ACTIONS(383),
    [sym_return] = ACTIONS(385),
    [sym_next] = ACTIONS(385),
    [sym_break] = ACTIONS(385),
    [sym_true] = ACTIONS(385),
    [sym_false] = ACTIONS(385),
    [sym_null] = ACTIONS(385),
    [sym_inf] = ACTIONS(385),
    [sym_nan] = ACTIONS(385),
    [anon_sym_NA] = ACTIONS(385),
    [anon_sym_NA_integer_] = ACTIONS(385),
    [anon_sym_NA_real_] = ACTIONS(385),
    [anon_sym_NA_complex_] = ACTIONS(385),
    [anon_sym_NA_character_] = ACTIONS(385),
    [sym_dots] = ACTIONS(385),
    [sym_dot_dot_i] = ACTIONS(383),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(383),
    [sym__semicolon] = ACTIONS(383),
    [sym__raw_string_literal] = ACTIONS(383),
    [sym__external_else] = ACTIONS(383),
    [sym__external_open_parenthesis] = ACTIONS(145),
    [sym__external_open_brace] = ACTIONS(383),
    [sym__external_open_bracket] = ACTIONS(147),
    [sym__external_open_bracket2] = ACTIONS(149),
  },
  [57] = {
    [sym_call_arguments] = STATE(862),
    [sym_subset_arguments] = STATE(885),
    [sym_subset2_arguments] = STATE(900),
    [sym__open_parenthesis] = STATE(341),
    [sym__open_bracket] = STATE(342),
    [sym__open_bracket2] = STATE(343),
    [ts_builtin_sym_end] = ACTIONS(383),
    [sym_identifier] = ACTIONS(385),
    [anon_sym_BSLASH] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_EQ] = ACTIONS(385),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_for] = ACTIONS(385),
    [anon_sym_while] = ACTIONS(385),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_QMARK] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(383),
    [anon_sym_BANG] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(109),
    [anon_sym_DASH] = ACTIONS(111),
    [anon_sym_LT_DASH] = ACTIONS(383),
    [anon_sym_LT_LT_DASH] = ACTIONS(383),
    [anon_sym_COLON_EQ] = ACTIONS(383),
    [anon_sym_DASH_GT] = ACTIONS(385),
    [anon_sym_DASH_GT_GT] = ACTIONS(383),
    [anon_sym_PIPE] = ACTIONS(385),
    [anon_sym_AMP] = ACTIONS(385),
    [anon_sym_PIPE_PIPE] = ACTIONS(383),
    [anon_sym_AMP_AMP] = ACTIONS(383),
    [anon_sym_LT] = ACTIONS(127),
    [anon_sym_LT_EQ] = ACTIONS(129),
    [anon_sym_GT] = ACTIONS(127),
    [anon_sym_GT_EQ] = ACTIONS(129),
    [anon_sym_EQ_EQ] = ACTIONS(129),
    [anon_sym_BANG_EQ] = ACTIONS(129),
    [anon_sym_STAR] = ACTIONS(131),
    [anon_sym_SLASH] = ACTIONS(133),
    [anon_sym_STAR_STAR] = ACTIONS(135),
    [anon_sym_CARET] = ACTIONS(135),
    [aux_sym_binary_operator_token1] = ACTIONS(137),
    [anon_sym_PIPE_GT] = ACTIONS(137),
    [anon_sym_COLON] = ACTIONS(139),
    [anon_sym_DOLLAR] = ACTIONS(141),
    [anon_sym_AT] = ACTIONS(141),
    [aux_sym__hex_literal_token1] = ACTIONS(383),
    [sym__number_literal] = ACTIONS(385),
    [anon_sym_SQUOTE] = ACTIONS(383),
    [anon_sym_DQUOTE] = ACTIONS(383),
    [sym_return] = ACTIONS(385),
    [sym_next] = ACTIONS(385),
    [sym_break] = ACTIONS(385),
    [sym_true] = ACTIONS(385),
    [sym_false] = ACTIONS(385),
    [sym_null] = ACTIONS(385),
    [sym_inf] = ACTIONS(385),
    [sym_nan] = ACTIONS(385),
    [anon_sym_NA] = ACTIONS(385),
    [anon_sym_NA_integer_] = ACTIONS(385),
    [anon_sym_NA_real_] = ACTIONS(385),
    [anon_sym_NA_complex_] = ACTIONS(385),
    [anon_sym_NA_character_] = ACTIONS(385),
    [sym_dots] = ACTIONS(385),
    [sym_dot_dot_i] = ACTIONS(383),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(383),
    [sym__semicolon] = ACTIONS(383),
    [sym__raw_string_literal] = ACTIONS(383),
    [sym__external_else] = ACTIONS(383),
    [sym__external_open_parenthesis] = ACTIONS(145),
    [sym__external_open_brace] = ACTIONS(383),
    [sym__external_open_bracket] = ACTIONS(147),
    [sym__external_open_bracket2] = ACTIONS(149),
  },
  [58] = {
    [sym_call_arguments] = STATE(862),
    [sym_subset_arguments] = STATE(885),
    [sym_subset2_arguments] = STATE(900),
    [sym__open_parenthesis] = STATE(341),
    [sym__open_bracket] = STATE(342),
    [sym__open_bracket2] = STATE(343),
    [ts_builtin_sym_end] = ACTIONS(383),
    [sym_identifier] = ACTIONS(385),
    [anon_sym_BSLASH] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_EQ] = ACTIONS(385),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_for] = ACTIONS(385),
    [anon_sym_while] = ACTIONS(385),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_QMARK] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(383),
    [anon_sym_BANG] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(109),
    [anon_sym_DASH] = ACTIONS(111),
    [anon_sym_LT_DASH] = ACTIONS(383),
    [anon_sym_LT_LT_DASH] = ACTIONS(383),
    [anon_sym_COLON_EQ] = ACTIONS(383),
    [anon_sym_DASH_GT] = ACTIONS(385),
    [anon_sym_DASH_GT_GT] = ACTIONS(383),
    [anon_sym_PIPE] = ACTIONS(385),
    [anon_sym_AMP] = ACTIONS(385),
    [anon_sym_PIPE_PIPE] = ACTIONS(383),
    [anon_sym_AMP_AMP] = ACTIONS(383),
    [anon_sym_LT] = ACTIONS(385),
    [anon_sym_LT_EQ] = ACTIONS(383),
    [anon_sym_GT] = ACTIONS(385),
    [anon_sym_GT_EQ] = ACTIONS(383),
    [anon_sym_EQ_EQ] = ACTIONS(383),
    [anon_sym_BANG_EQ] = ACTIONS(383),
    [anon_sym_STAR] = ACTIONS(131),
    [anon_sym_SLASH] = ACTIONS(133),
    [anon_sym_STAR_STAR] = ACTIONS(135),
    [anon_sym_CARET] = ACTIONS(135),
    [aux_sym_binary_operator_token1] = ACTIONS(137),
    [anon_sym_PIPE_GT] = ACTIONS(137),
    [anon_sym_COLON] = ACTIONS(139),
    [anon_sym_DOLLAR] = ACTIONS(141),
    [anon_sym_AT] = ACTIONS(141),
    [aux_sym__hex_literal_token1] = ACTIONS(383),
    [sym__number_literal] = ACTIONS(385),
    [anon_sym_SQUOTE] = ACTIONS(383),
    [anon_sym_DQUOTE] = ACTIONS(383),
    [sym_return] = ACTIONS(385),
    [sym_next] = ACTIONS(385),
    [sym_break] = ACTIONS(385),
    [sym_true] = ACTIONS(385),
    [sym_false] = ACTIONS(385),
    [sym_null] = ACTIONS(385),
    [sym_inf] = ACTIONS(385),
    [sym_nan] = ACTIONS(385),
    [anon_sym_NA] = ACTIONS(385),
    [anon_sym_NA_integer_] = ACTIONS(385),
    [anon_sym_NA_real_] = ACTIONS(385),
    [anon_sym_NA_complex_] = ACTIONS(385),
    [anon_sym_NA_character_] = ACTIONS(385),
    [sym_dots] = ACTIONS(385),
    [sym_dot_dot_i] = ACTIONS(383),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(383),
    [sym__semicolon] = ACTIONS(383),
    [sym__raw_string_literal] = ACTIONS(383),
    [sym__external_else] = ACTIONS(383),
    [sym__external_open_parenthesis] = ACTIONS(145),
    [sym__external_open_brace] = ACTIONS(383),
    [sym__external_open_bracket] = ACTIONS(147),
    [sym__external_open_bracket2] = ACTIONS(149),
  },
  [59] = {
    [sym_call_arguments] = STATE(862),
    [sym_subset_arguments] = STATE(885),
    [sym_subset2_arguments] = STATE(900),
    [sym__open_parenthesis] = STATE(341),
    [sym__open_bracket] = STATE(342),
    [sym__open_bracket2] = STATE(343),
    [ts_builtin_sym_end] = ACTIONS(383),
    [sym_identifier] = ACTIONS(385),
    [anon_sym_BSLASH] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_EQ] = ACTIONS(385),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_for] = ACTIONS(385),
    [anon_sym_while] = ACTIONS(385),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_QMARK] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(383),
    [anon_sym_BANG] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(385),
    [anon_sym_LT_DASH] = ACTIONS(383),
    [anon_sym_LT_LT_DASH] = ACTIONS(383),
    [anon_sym_COLON_EQ] = ACTIONS(383),
    [anon_sym_DASH_GT] = ACTIONS(385),
    [anon_sym_DASH_GT_GT] = ACTIONS(383),
    [anon_sym_PIPE] = ACTIONS(385),
    [anon_sym_AMP] = ACTIONS(385),
    [anon_sym_PIPE_PIPE] = ACTIONS(383),
    [anon_sym_AMP_AMP] = ACTIONS(383),
    [anon_sym_LT] = ACTIONS(385),
    [anon_sym_LT_EQ] = ACTIONS(383),
    [anon_sym_GT] = ACTIONS(385),
    [anon_sym_GT_EQ] = ACTIONS(383),
    [anon_sym_EQ_EQ] = ACTIONS(383),
    [anon_sym_BANG_EQ] = ACTIONS(383),
    [anon_sym_STAR] = ACTIONS(385),
    [anon_sym_SLASH] = ACTIONS(383),
    [anon_sym_STAR_STAR] = ACTIONS(135),
    [anon_sym_CARET] = ACTIONS(135),
    [aux_sym_binary_operator_token1] = ACTIONS(137),
    [anon_sym_PIPE_GT] = ACTIONS(137),
    [anon_sym_COLON] = ACTIONS(139),
    [anon_sym_DOLLAR] = ACTIONS(141),
    [anon_sym_AT] = ACTIONS(141),
    [aux_sym__hex_literal_token1] = ACTIONS(383),
    [sym__number_literal] = ACTIONS(385),
    [anon_sym_SQUOTE] = ACTIONS(383),
    [anon_sym_DQUOTE] = ACTIONS(383),
    [sym_return] = ACTIONS(385),
    [sym_next] = ACTIONS(385),
    [sym_break] = ACTIONS(385),
    [sym_true] = ACTIONS(385),
    [sym_false] = ACTIONS(385),
    [sym_null] = ACTIONS(385),
    [sym_inf] = ACTIONS(385),
    [sym_nan] = ACTIONS(385),
    [anon_sym_NA] = ACTIONS(385),
    [anon_sym_NA_integer_] = ACTIONS(385),
    [anon_sym_NA_real_] = ACTIONS(385),
    [anon_sym_NA_complex_] = ACTIONS(385),
    [anon_sym_NA_character_] = ACTIONS(385),
    [sym_dots] = ACTIONS(385),
    [sym_dot_dot_i] = ACTIONS(383),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(383),
    [sym__semicolon] = ACTIONS(383),
    [sym__raw_string_literal] = ACTIONS(383),
    [sym__external_else] = ACTIONS(383),
    [sym__external_open_parenthesis] = ACTIONS(145),
    [sym__external_open_brace] = ACTIONS(383),
    [sym__external_open_bracket] = ACTIONS(147),
    [sym__external_open_bracket2] = ACTIONS(149),
  },
  [60] = {
    [sym_call_arguments] = STATE(862),
    [sym_subset_arguments] = STATE(885),
    [sym_subset2_arguments] = STATE(900),
    [sym__open_parenthesis] = STATE(341),
    [sym__open_bracket] = STATE(342),
    [sym__open_bracket2] = STATE(343),
    [ts_builtin_sym_end] = ACTIONS(383),
    [sym_identifier] = ACTIONS(385),
    [anon_sym_BSLASH] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_EQ] = ACTIONS(385),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_for] = ACTIONS(385),
    [anon_sym_while] = ACTIONS(385),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_QMARK] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(383),
    [anon_sym_BANG] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(385),
    [anon_sym_LT_DASH] = ACTIONS(383),
    [anon_sym_LT_LT_DASH] = ACTIONS(383),
    [anon_sym_COLON_EQ] = ACTIONS(383),
    [anon_sym_DASH_GT] = ACTIONS(385),
    [anon_sym_DASH_GT_GT] = ACTIONS(383),
    [anon_sym_PIPE] = ACTIONS(385),
    [anon_sym_AMP] = ACTIONS(385),
    [anon_sym_PIPE_PIPE] = ACTIONS(383),
    [anon_sym_AMP_AMP] = ACTIONS(383),
    [anon_sym_LT] = ACTIONS(385),
    [anon_sym_LT_EQ] = ACTIONS(383),
    [anon_sym_GT] = ACTIONS(385),
    [anon_sym_GT_EQ] = ACTIONS(383),
    [anon_sym_EQ_EQ] = ACTIONS(383),
    [anon_sym_BANG_EQ] = ACTIONS(383),
    [anon_sym_STAR] = ACTIONS(385),
    [anon_sym_SLASH] = ACTIONS(383),
    [anon_sym_STAR_STAR] = ACTIONS(135),
    [anon_sym_CARET] = ACTIONS(135),
    [aux_sym_binary_operator_token1] = ACTIONS(383),
    [anon_sym_PIPE_GT] = ACTIONS(383),
    [anon_sym_COLON] = ACTIONS(385),
    [anon_sym_DOLLAR] = ACTIONS(141),
    [anon_sym_AT] = ACTIONS(141),
    [aux_sym__hex_literal_token1] = ACTIONS(383),
    [sym__number_literal] = ACTIONS(385),
    [anon_sym_SQUOTE] = ACTIONS(383),
    [anon_sym_DQUOTE] = ACTIONS(383),
    [sym_return] = ACTIONS(385),
    [sym_next] = ACTIONS(385),
    [sym_break] = ACTIONS(385),
    [sym_true] = ACTIONS(385),
    [sym_false] = ACTIONS(385),
    [sym_null] = ACTIONS(385),
    [sym_inf] = ACTIONS(385),
    [sym_nan] = ACTIONS(385),
    [anon_sym_NA] = ACTIONS(385),
    [anon_sym_NA_integer_] = ACTIONS(385),
    [anon_sym_NA_real_] = ACTIONS(385),
    [anon_sym_NA_complex_] = ACTIONS(385),
    [anon_sym_NA_character_] = ACTIONS(385),
    [sym_dots] = ACTIONS(385),
    [sym_dot_dot_i] = ACTIONS(383),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(383),
    [sym__semicolon] = ACTIONS(383),
    [sym__raw_string_literal] = ACTIONS(383),
    [sym__external_else] = ACTIONS(383),
    [sym__external_open_parenthesis] = ACTIONS(145),
    [sym__external_open_brace] = ACTIONS(383),
    [sym__external_open_bracket] = ACTIONS(147),
    [sym__external_open_bracket2] = ACTIONS(149),
  },
  [61] = {
    [sym_call_arguments] = STATE(862),
    [sym_subset_arguments] = STATE(885),
    [sym_subset2_arguments] = STATE(900),
    [sym__open_parenthesis] = STATE(341),
    [sym__open_bracket] = STATE(342),
    [sym__open_bracket2] = STATE(343),
    [ts_builtin_sym_end] = ACTIONS(383),
    [sym_identifier] = ACTIONS(385),
    [anon_sym_BSLASH] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_EQ] = ACTIONS(385),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_for] = ACTIONS(385),
    [anon_sym_while] = ACTIONS(385),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_QMARK] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(383),
    [anon_sym_BANG] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(385),
    [anon_sym_LT_DASH] = ACTIONS(383),
    [anon_sym_LT_LT_DASH] = ACTIONS(383),
    [anon_sym_COLON_EQ] = ACTIONS(383),
    [anon_sym_DASH_GT] = ACTIONS(385),
    [anon_sym_DASH_GT_GT] = ACTIONS(383),
    [anon_sym_PIPE] = ACTIONS(385),
    [anon_sym_AMP] = ACTIONS(385),
    [anon_sym_PIPE_PIPE] = ACTIONS(383),
    [anon_sym_AMP_AMP] = ACTIONS(383),
    [anon_sym_LT] = ACTIONS(385),
    [anon_sym_LT_EQ] = ACTIONS(383),
    [anon_sym_GT] = ACTIONS(385),
    [anon_sym_GT_EQ] = ACTIONS(383),
    [anon_sym_EQ_EQ] = ACTIONS(383),
    [anon_sym_BANG_EQ] = ACTIONS(383),
    [anon_sym_STAR] = ACTIONS(385),
    [anon_sym_SLASH] = ACTIONS(383),
    [anon_sym_STAR_STAR] = ACTIONS(135),
    [anon_sym_CARET] = ACTIONS(135),
    [aux_sym_binary_operator_token1] = ACTIONS(383),
    [anon_sym_PIPE_GT] = ACTIONS(383),
    [anon_sym_COLON] = ACTIONS(139),
    [anon_sym_DOLLAR] = ACTIONS(141),
    [anon_sym_AT] = ACTIONS(141),
    [aux_sym__hex_literal_token1] = ACTIONS(383),
    [sym__number_literal] = ACTIONS(385),
    [anon_sym_SQUOTE] = ACTIONS(383),
    [anon_sym_DQUOTE] = ACTIONS(383),
    [sym_return] = ACTIONS(385),
    [sym_next] = ACTIONS(385),
    [sym_break] = ACTIONS(385),
    [sym_true] = ACTIONS(385),
    [sym_false] = ACTIONS(385),
    [sym_null] = ACTIONS(385),
    [sym_inf] = ACTIONS(385),
    [sym_nan] = ACTIONS(385),
    [anon_sym_NA] = ACTIONS(385),
    [anon_sym_NA_integer_] = ACTIONS(385),
    [anon_sym_NA_real_] = ACTIONS(385),
    [anon_sym_NA_complex_] = ACTIONS(385),
    [anon_sym_NA_character_] = ACTIONS(385),
    [sym_dots] = ACTIONS(385),
    [sym_dot_dot_i] = ACTIONS(383),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(383),
    [sym__semicolon] = ACTIONS(383),
    [sym__raw_string_literal] = ACTIONS(383),
    [sym__external_else] = ACTIONS(383),
    [sym__external_open_parenthesis] = ACTIONS(145),
    [sym__external_open_brace] = ACTIONS(383),
    [sym__external_open_bracket] = ACTIONS(147),
    [sym__external_open_bracket2] = ACTIONS(149),
  },
  [62] = {
    [sym_call_arguments] = STATE(862),
    [sym_subset_arguments] = STATE(885),
    [sym_subset2_arguments] = STATE(900),
    [sym__open_parenthesis] = STATE(341),
    [sym__open_bracket] = STATE(342),
    [sym__open_bracket2] = STATE(343),
    [ts_builtin_sym_end] = ACTIONS(383),
    [sym_identifier] = ACTIONS(385),
    [anon_sym_BSLASH] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_EQ] = ACTIONS(385),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_for] = ACTIONS(385),
    [anon_sym_while] = ACTIONS(385),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_QMARK] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(383),
    [anon_sym_BANG] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(385),
    [anon_sym_LT_DASH] = ACTIONS(383),
    [anon_sym_LT_LT_DASH] = ACTIONS(383),
    [anon_sym_COLON_EQ] = ACTIONS(383),
    [anon_sym_DASH_GT] = ACTIONS(385),
    [anon_sym_DASH_GT_GT] = ACTIONS(383),
    [anon_sym_PIPE] = ACTIONS(385),
    [anon_sym_AMP] = ACTIONS(385),
    [anon_sym_PIPE_PIPE] = ACTIONS(383),
    [anon_sym_AMP_AMP] = ACTIONS(383),
    [anon_sym_LT] = ACTIONS(385),
    [anon_sym_LT_EQ] = ACTIONS(383),
    [anon_sym_GT] = ACTIONS(385),
    [anon_sym_GT_EQ] = ACTIONS(383),
    [anon_sym_EQ_EQ] = ACTIONS(383),
    [anon_sym_BANG_EQ] = ACTIONS(383),
    [anon_sym_STAR] = ACTIONS(385),
    [anon_sym_SLASH] = ACTIONS(383),
    [anon_sym_STAR_STAR] = ACTIONS(135),
    [anon_sym_CARET] = ACTIONS(135),
    [aux_sym_binary_operator_token1] = ACTIONS(383),
    [anon_sym_PIPE_GT] = ACTIONS(383),
    [anon_sym_COLON] = ACTIONS(385),
    [anon_sym_DOLLAR] = ACTIONS(141),
    [anon_sym_AT] = ACTIONS(141),
    [aux_sym__hex_literal_token1] = ACTIONS(383),
    [sym__number_literal] = ACTIONS(385),
    [anon_sym_SQUOTE] = ACTIONS(383),
    [anon_sym_DQUOTE] = ACTIONS(383),
    [sym_return] = ACTIONS(385),
    [sym_next] = ACTIONS(385),
    [sym_break] = ACTIONS(385),
    [sym_true] = ACTIONS(385),
    [sym_false] = ACTIONS(385),
    [sym_null] = ACTIONS(385),
    [sym_inf] = ACTIONS(385),
    [sym_nan] = ACTIONS(385),
    [anon_sym_NA] = ACTIONS(385),
    [anon_sym_NA_integer_] = ACTIONS(385),
    [anon_sym_NA_real_] = ACTIONS(385),
    [anon_sym_NA_complex_] = ACTIONS(385),
    [anon_sym_NA_character_] = ACTIONS(385),
    [sym_dots] = ACTIONS(385),
    [sym_dot_dot_i] = ACTIONS(383),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(383),
    [sym__semicolon] = ACTIONS(383),
    [sym__raw_string_literal] = ACTIONS(383),
    [sym__external_else] = ACTIONS(383),
    [sym__external_open_parenthesis] = ACTIONS(145),
    [sym__external_open_brace] = ACTIONS(383),
    [sym__external_open_bracket] = ACTIONS(147),
    [sym__external_open_bracket2] = ACTIONS(149),
  },
  [63] = {
    [sym_function_definition] = STATE(631),
    [sym_if_statement] = STATE(631),
    [sym_for_statement] = STATE(631),
    [sym_while_statement] = STATE(631),
    [sym_repeat_statement] = STATE(631),
    [sym_braced_expression] = STATE(631),
    [sym_parenthesized_expression] = STATE(631),
    [sym_call] = STATE(631),
    [sym_subset] = STATE(631),
    [sym_subset2] = STATE(631),
    [sym__argument] = STATE(1934),
    [sym_argument] = STATE(1937),
    [sym__argument_named] = STATE(1909),
    [sym__argument_unnamed] = STATE(1932),
    [sym__argument_value] = STATE(1920),
    [sym_unary_operator] = STATE(631),
    [sym_binary_operator] = STATE(631),
    [sym_extract_operator] = STATE(631),
    [sym_namespace_operator] = STATE(631),
    [sym_integer] = STATE(631),
    [sym_complex] = STATE(631),
    [sym_float] = STATE(631),
    [sym__hex_literal] = STATE(752),
    [sym__float_literal] = STATE(752),
    [sym_string] = STATE(766),
    [sym__single_quoted_string] = STATE(753),
    [sym__double_quoted_string] = STATE(754),
    [sym_na] = STATE(631),
    [sym__expression] = STATE(631),
    [sym__string_or_identifier] = STATE(2143),
    [sym__open_parenthesis] = STATE(869),
    [sym__open_brace] = STATE(764),
    [sym__close_bracket] = STATE(877),
    [aux_sym_call_arguments_repeat1] = STATE(529),
    [sym_identifier] = ACTIONS(387),
    [anon_sym_BSLASH] = ACTIONS(389),
    [anon_sym_function] = ACTIONS(391),
    [anon_sym_if] = ACTIONS(393),
    [anon_sym_for] = ACTIONS(395),
    [anon_sym_while] = ACTIONS(397),
    [anon_sym_repeat] = ACTIONS(399),
    [anon_sym_QMARK] = ACTIONS(401),
    [anon_sym_TILDE] = ACTIONS(403),
    [anon_sym_BANG] = ACTIONS(405),
    [anon_sym_PLUS] = ACTIONS(407),
    [anon_sym_DASH] = ACTIONS(407),
    [aux_sym__hex_literal_token1] = ACTIONS(409),
    [sym__number_literal] = ACTIONS(411),
    [anon_sym_SQUOTE] = ACTIONS(413),
    [anon_sym_DQUOTE] = ACTIONS(415),
    [sym_return] = ACTIONS(417),
    [sym_next] = ACTIONS(417),
    [sym_break] = ACTIONS(417),
    [sym_true] = ACTIONS(417),
    [sym_false] = ACTIONS(417),
    [sym_null] = ACTIONS(417),
    [sym_inf] = ACTIONS(417),
    [sym_nan] = ACTIONS(417),
    [anon_sym_NA] = ACTIONS(419),
    [anon_sym_NA_integer_] = ACTIONS(419),
    [anon_sym_NA_real_] = ACTIONS(419),
    [anon_sym_NA_complex_] = ACTIONS(419),
    [anon_sym_NA_character_] = ACTIONS(419),
    [sym_dots] = ACTIONS(421),
    [sym_dot_dot_i] = ACTIONS(423),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(425),
    [sym__newline] = ACTIONS(427),
    [sym__raw_string_literal] = ACTIONS(429),
    [sym__external_open_parenthesis] = ACTIONS(431),
    [sym__external_open_brace] = ACTIONS(433),
    [sym__external_close_bracket] = ACTIONS(435),
  },
  [64] = {
    [sym_function_definition] = STATE(568),
    [sym_if_statement] = STATE(568),
    [sym_for_statement] = STATE(568),
    [sym_while_statement] = STATE(568),
    [sym_repeat_statement] = STATE(568),
    [sym_braced_expression] = STATE(568),
    [sym_parenthesized_expression] = STATE(568),
    [sym_call] = STATE(568),
    [sym_subset] = STATE(568),
    [sym_subset2] = STATE(568),
    [sym__argument] = STATE(1928),
    [sym_argument] = STATE(1930),
    [sym__argument_named] = STATE(1908),
    [sym__argument_unnamed] = STATE(1933),
    [sym__argument_value] = STATE(1936),
    [sym_unary_operator] = STATE(568),
    [sym_binary_operator] = STATE(568),
    [sym_extract_operator] = STATE(568),
    [sym_namespace_operator] = STATE(568),
    [sym_integer] = STATE(568),
    [sym_complex] = STATE(568),
    [sym_float] = STATE(568),
    [sym__hex_literal] = STATE(703),
    [sym__float_literal] = STATE(703),
    [sym_string] = STATE(736),
    [sym__single_quoted_string] = STATE(705),
    [sym__double_quoted_string] = STATE(706),
    [sym_na] = STATE(568),
    [sym__expression] = STATE(568),
    [sym__string_or_identifier] = STATE(2142),
    [sym__open_parenthesis] = STATE(874),
    [sym__open_brace] = STATE(765),
    [sym__close_bracket2] = STATE(881),
    [aux_sym_call_arguments_repeat1] = STATE(585),
    [sym_identifier] = ACTIONS(437),
    [anon_sym_BSLASH] = ACTIONS(439),
    [anon_sym_function] = ACTIONS(441),
    [anon_sym_if] = ACTIONS(443),
    [anon_sym_for] = ACTIONS(445),
    [anon_sym_while] = ACTIONS(447),
    [anon_sym_repeat] = ACTIONS(449),
    [anon_sym_QMARK] = ACTIONS(451),
    [anon_sym_TILDE] = ACTIONS(453),
    [anon_sym_BANG] = ACTIONS(455),
    [anon_sym_PLUS] = ACTIONS(457),
    [anon_sym_DASH] = ACTIONS(457),
    [aux_sym__hex_literal_token1] = ACTIONS(459),
    [sym__number_literal] = ACTIONS(461),
    [anon_sym_SQUOTE] = ACTIONS(463),
    [anon_sym_DQUOTE] = ACTIONS(465),
    [sym_return] = ACTIONS(467),
    [sym_next] = ACTIONS(467),
    [sym_break] = ACTIONS(467),
    [sym_true] = ACTIONS(467),
    [sym_false] = ACTIONS(467),
    [sym_null] = ACTIONS(467),
    [sym_inf] = ACTIONS(467),
    [sym_nan] = ACTIONS(467),
    [anon_sym_NA] = ACTIONS(469),
    [anon_sym_NA_integer_] = ACTIONS(469),
    [anon_sym_NA_real_] = ACTIONS(469),
    [anon_sym_NA_complex_] = ACTIONS(469),
    [anon_sym_NA_character_] = ACTIONS(469),
    [sym_dots] = ACTIONS(471),
    [sym_dot_dot_i] = ACTIONS(473),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(475),
    [sym__newline] = ACTIONS(477),
    [sym__raw_string_literal] = ACTIONS(479),
    [sym__external_open_parenthesis] = ACTIONS(481),
    [sym__external_open_brace] = ACTIONS(483),
    [sym__external_close_bracket2] = ACTIONS(485),
  },
  [65] = {
    [sym_call_arguments] = STATE(862),
    [sym_subset_arguments] = STATE(885),
    [sym_subset2_arguments] = STATE(900),
    [sym__open_parenthesis] = STATE(341),
    [sym__open_bracket] = STATE(342),
    [sym__open_bracket2] = STATE(343),
    [ts_builtin_sym_end] = ACTIONS(487),
    [sym_identifier] = ACTIONS(489),
    [anon_sym_BSLASH] = ACTIONS(487),
    [anon_sym_function] = ACTIONS(489),
    [anon_sym_EQ] = ACTIONS(105),
    [anon_sym_if] = ACTIONS(489),
    [anon_sym_for] = ACTIONS(489),
    [anon_sym_while] = ACTIONS(489),
    [anon_sym_repeat] = ACTIONS(489),
    [anon_sym_QMARK] = ACTIONS(487),
    [anon_sym_TILDE] = ACTIONS(107),
    [anon_sym_BANG] = ACTIONS(489),
    [anon_sym_PLUS] = ACTIONS(109),
    [anon_sym_DASH] = ACTIONS(111),
    [anon_sym_LT_DASH] = ACTIONS(113),
    [anon_sym_LT_LT_DASH] = ACTIONS(113),
    [anon_sym_COLON_EQ] = ACTIONS(113),
    [anon_sym_DASH_GT] = ACTIONS(115),
    [anon_sym_DASH_GT_GT] = ACTIONS(117),
    [anon_sym_PIPE] = ACTIONS(119),
    [anon_sym_AMP] = ACTIONS(121),
    [anon_sym_PIPE_PIPE] = ACTIONS(123),
    [anon_sym_AMP_AMP] = ACTIONS(125),
    [anon_sym_LT] = ACTIONS(127),
    [anon_sym_LT_EQ] = ACTIONS(129),
    [anon_sym_GT] = ACTIONS(127),
    [anon_sym_GT_EQ] = ACTIONS(129),
    [anon_sym_EQ_EQ] = ACTIONS(129),
    [anon_sym_BANG_EQ] = ACTIONS(129),
    [anon_sym_STAR] = ACTIONS(131),
    [anon_sym_SLASH] = ACTIONS(133),
    [anon_sym_STAR_STAR] = ACTIONS(135),
    [anon_sym_CARET] = ACTIONS(135),
    [aux_sym_binary_operator_token1] = ACTIONS(137),
    [anon_sym_PIPE_GT] = ACTIONS(137),
    [anon_sym_COLON] = ACTIONS(139),
    [anon_sym_DOLLAR] = ACTIONS(141),
    [anon_sym_AT] = ACTIONS(141),
    [aux_sym__hex_literal_token1] = ACTIONS(487),
    [sym__number_literal] = ACTIONS(489),
    [anon_sym_SQUOTE] = ACTIONS(487),
    [anon_sym_DQUOTE] = ACTIONS(487),
    [sym_return] = ACTIONS(489),
    [sym_next] = ACTIONS(489),
    [sym_break] = ACTIONS(489),
    [sym_true] = ACTIONS(489),
    [sym_false] = ACTIONS(489),
    [sym_null] = ACTIONS(489),
    [sym_inf] = ACTIONS(489),
    [sym_nan] = ACTIONS(489),
    [anon_sym_NA] = ACTIONS(489),
    [anon_sym_NA_integer_] = ACTIONS(489),
    [anon_sym_NA_real_] = ACTIONS(489),
    [anon_sym_NA_complex_] = ACTIONS(489),
    [anon_sym_NA_character_] = ACTIONS(489),
    [sym_dots] = ACTIONS(489),
    [sym_dot_dot_i] = ACTIONS(487),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(487),
    [sym__semicolon] = ACTIONS(487),
    [sym__raw_string_literal] = ACTIONS(487),
    [sym__external_else] = ACTIONS(487),
    [sym__external_open_parenthesis] = ACTIONS(145),
    [sym__external_open_brace] = ACTIONS(487),
    [sym__external_open_bracket] = ACTIONS(147),
    [sym__external_open_bracket2] = ACTIONS(149),
  },
  [66] = {
    [sym_call_arguments] = STATE(862),
    [sym_subset_arguments] = STATE(885),
    [sym_subset2_arguments] = STATE(900),
    [sym__open_parenthesis] = STATE(341),
    [sym__open_bracket] = STATE(342),
    [sym__open_bracket2] = STATE(343),
    [ts_builtin_sym_end] = ACTIONS(491),
    [sym_identifier] = ACTIONS(493),
    [anon_sym_BSLASH] = ACTIONS(491),
    [anon_sym_function] = ACTIONS(493),
    [anon_sym_EQ] = ACTIONS(105),
    [anon_sym_if] = ACTIONS(493),
    [anon_sym_for] = ACTIONS(493),
    [anon_sym_while] = ACTIONS(493),
    [anon_sym_repeat] = ACTIONS(493),
    [anon_sym_QMARK] = ACTIONS(491),
    [anon_sym_TILDE] = ACTIONS(107),
    [anon_sym_BANG] = ACTIONS(493),
    [anon_sym_PLUS] = ACTIONS(109),
    [anon_sym_DASH] = ACTIONS(111),
    [anon_sym_LT_DASH] = ACTIONS(491),
    [anon_sym_LT_LT_DASH] = ACTIONS(491),
    [anon_sym_COLON_EQ] = ACTIONS(491),
    [anon_sym_DASH_GT] = ACTIONS(115),
    [anon_sym_DASH_GT_GT] = ACTIONS(117),
    [anon_sym_PIPE] = ACTIONS(119),
    [anon_sym_AMP] = ACTIONS(121),
    [anon_sym_PIPE_PIPE] = ACTIONS(123),
    [anon_sym_AMP_AMP] = ACTIONS(125),
    [anon_sym_LT] = ACTIONS(127),
    [anon_sym_LT_EQ] = ACTIONS(129),
    [anon_sym_GT] = ACTIONS(127),
    [anon_sym_GT_EQ] = ACTIONS(129),
    [anon_sym_EQ_EQ] = ACTIONS(129),
    [anon_sym_BANG_EQ] = ACTIONS(129),
    [anon_sym_STAR] = ACTIONS(131),
    [anon_sym_SLASH] = ACTIONS(133),
    [anon_sym_STAR_STAR] = ACTIONS(135),
    [anon_sym_CARET] = ACTIONS(135),
    [aux_sym_binary_operator_token1] = ACTIONS(137),
    [anon_sym_PIPE_GT] = ACTIONS(137),
    [anon_sym_COLON] = ACTIONS(139),
    [anon_sym_DOLLAR] = ACTIONS(141),
    [anon_sym_AT] = ACTIONS(141),
    [aux_sym__hex_literal_token1] = ACTIONS(491),
    [sym__number_literal] = ACTIONS(493),
    [anon_sym_SQUOTE] = ACTIONS(491),
    [anon_sym_DQUOTE] = ACTIONS(491),
    [sym_return] = ACTIONS(493),
    [sym_next] = ACTIONS(493),
    [sym_break] = ACTIONS(493),
    [sym_true] = ACTIONS(493),
    [sym_false] = ACTIONS(493),
    [sym_null] = ACTIONS(493),
    [sym_inf] = ACTIONS(493),
    [sym_nan] = ACTIONS(493),
    [anon_sym_NA] = ACTIONS(493),
    [anon_sym_NA_integer_] = ACTIONS(493),
    [anon_sym_NA_real_] = ACTIONS(493),
    [anon_sym_NA_complex_] = ACTIONS(493),
    [anon_sym_NA_character_] = ACTIONS(493),
    [sym_dots] = ACTIONS(493),
    [sym_dot_dot_i] = ACTIONS(491),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(491),
    [sym__semicolon] = ACTIONS(491),
    [sym__raw_string_literal] = ACTIONS(491),
    [sym__external_else] = ACTIONS(491),
    [sym__external_open_parenthesis] = ACTIONS(145),
    [sym__external_open_brace] = ACTIONS(491),
    [sym__external_open_bracket] = ACTIONS(147),
    [sym__external_open_bracket2] = ACTIONS(149),
  },
  [67] = {
    [sym_call_arguments] = STATE(862),
    [sym_subset_arguments] = STATE(885),
    [sym_subset2_arguments] = STATE(900),
    [sym__open_parenthesis] = STATE(341),
    [sym__open_bracket] = STATE(342),
    [sym__open_bracket2] = STATE(343),
    [ts_builtin_sym_end] = ACTIONS(491),
    [sym_identifier] = ACTIONS(493),
    [anon_sym_BSLASH] = ACTIONS(491),
    [anon_sym_function] = ACTIONS(493),
    [anon_sym_EQ] = ACTIONS(105),
    [anon_sym_if] = ACTIONS(493),
    [anon_sym_for] = ACTIONS(493),
    [anon_sym_while] = ACTIONS(493),
    [anon_sym_repeat] = ACTIONS(493),
    [anon_sym_QMARK] = ACTIONS(491),
    [anon_sym_TILDE] = ACTIONS(107),
    [anon_sym_BANG] = ACTIONS(493),
    [anon_sym_PLUS] = ACTIONS(109),
    [anon_sym_DASH] = ACTIONS(111),
    [anon_sym_LT_DASH] = ACTIONS(113),
    [anon_sym_LT_LT_DASH] = ACTIONS(113),
    [anon_sym_COLON_EQ] = ACTIONS(113),
    [anon_sym_DASH_GT] = ACTIONS(115),
    [anon_sym_DASH_GT_GT] = ACTIONS(117),
    [anon_sym_PIPE] = ACTIONS(119),
    [anon_sym_AMP] = ACTIONS(121),
    [anon_sym_PIPE_PIPE] = ACTIONS(123),
    [anon_sym_AMP_AMP] = ACTIONS(125),
    [anon_sym_LT] = ACTIONS(127),
    [anon_sym_LT_EQ] = ACTIONS(129),
    [anon_sym_GT] = ACTIONS(127),
    [anon_sym_GT_EQ] = ACTIONS(129),
    [anon_sym_EQ_EQ] = ACTIONS(129),
    [anon_sym_BANG_EQ] = ACTIONS(129),
    [anon_sym_STAR] = ACTIONS(131),
    [anon_sym_SLASH] = ACTIONS(133),
    [anon_sym_STAR_STAR] = ACTIONS(135),
    [anon_sym_CARET] = ACTIONS(135),
    [aux_sym_binary_operator_token1] = ACTIONS(137),
    [anon_sym_PIPE_GT] = ACTIONS(137),
    [anon_sym_COLON] = ACTIONS(139),
    [anon_sym_DOLLAR] = ACTIONS(141),
    [anon_sym_AT] = ACTIONS(141),
    [aux_sym__hex_literal_token1] = ACTIONS(491),
    [sym__number_literal] = ACTIONS(493),
    [anon_sym_SQUOTE] = ACTIONS(491),
    [anon_sym_DQUOTE] = ACTIONS(491),
    [sym_return] = ACTIONS(493),
    [sym_next] = ACTIONS(493),
    [sym_break] = ACTIONS(493),
    [sym_true] = ACTIONS(493),
    [sym_false] = ACTIONS(493),
    [sym_null] = ACTIONS(493),
    [sym_inf] = ACTIONS(493),
    [sym_nan] = ACTIONS(493),
    [anon_sym_NA] = ACTIONS(493),
    [anon_sym_NA_integer_] = ACTIONS(493),
    [anon_sym_NA_real_] = ACTIONS(493),
    [anon_sym_NA_complex_] = ACTIONS(493),
    [anon_sym_NA_character_] = ACTIONS(493),
    [sym_dots] = ACTIONS(493),
    [sym_dot_dot_i] = ACTIONS(491),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(491),
    [sym__semicolon] = ACTIONS(491),
    [sym__raw_string_literal] = ACTIONS(491),
    [sym__external_else] = ACTIONS(491),
    [sym__external_open_parenthesis] = ACTIONS(145),
    [sym__external_open_brace] = ACTIONS(491),
    [sym__external_open_bracket] = ACTIONS(147),
    [sym__external_open_bracket2] = ACTIONS(149),
  },
  [68] = {
    [sym_call_arguments] = STATE(862),
    [sym_subset_arguments] = STATE(885),
    [sym_subset2_arguments] = STATE(900),
    [sym__open_parenthesis] = STATE(341),
    [sym__open_bracket] = STATE(342),
    [sym__open_bracket2] = STATE(343),
    [ts_builtin_sym_end] = ACTIONS(491),
    [sym_identifier] = ACTIONS(493),
    [anon_sym_BSLASH] = ACTIONS(491),
    [anon_sym_function] = ACTIONS(493),
    [anon_sym_EQ] = ACTIONS(493),
    [anon_sym_if] = ACTIONS(493),
    [anon_sym_for] = ACTIONS(493),
    [anon_sym_while] = ACTIONS(493),
    [anon_sym_repeat] = ACTIONS(493),
    [anon_sym_QMARK] = ACTIONS(491),
    [anon_sym_TILDE] = ACTIONS(491),
    [anon_sym_BANG] = ACTIONS(493),
    [anon_sym_PLUS] = ACTIONS(109),
    [anon_sym_DASH] = ACTIONS(111),
    [anon_sym_LT_DASH] = ACTIONS(491),
    [anon_sym_LT_LT_DASH] = ACTIONS(491),
    [anon_sym_COLON_EQ] = ACTIONS(491),
    [anon_sym_DASH_GT] = ACTIONS(493),
    [anon_sym_DASH_GT_GT] = ACTIONS(491),
    [anon_sym_PIPE] = ACTIONS(119),
    [anon_sym_AMP] = ACTIONS(121),
    [anon_sym_PIPE_PIPE] = ACTIONS(123),
    [anon_sym_AMP_AMP] = ACTIONS(125),
    [anon_sym_LT] = ACTIONS(127),
    [anon_sym_LT_EQ] = ACTIONS(129),
    [anon_sym_GT] = ACTIONS(127),
    [anon_sym_GT_EQ] = ACTIONS(129),
    [anon_sym_EQ_EQ] = ACTIONS(129),
    [anon_sym_BANG_EQ] = ACTIONS(129),
    [anon_sym_STAR] = ACTIONS(131),
    [anon_sym_SLASH] = ACTIONS(133),
    [anon_sym_STAR_STAR] = ACTIONS(135),
    [anon_sym_CARET] = ACTIONS(135),
    [aux_sym_binary_operator_token1] = ACTIONS(137),
    [anon_sym_PIPE_GT] = ACTIONS(137),
    [anon_sym_COLON] = ACTIONS(139),
    [anon_sym_DOLLAR] = ACTIONS(141),
    [anon_sym_AT] = ACTIONS(141),
    [aux_sym__hex_literal_token1] = ACTIONS(491),
    [sym__number_literal] = ACTIONS(493),
    [anon_sym_SQUOTE] = ACTIONS(491),
    [anon_sym_DQUOTE] = ACTIONS(491),
    [sym_return] = ACTIONS(493),
    [sym_next] = ACTIONS(493),
    [sym_break] = ACTIONS(493),
    [sym_true] = ACTIONS(493),
    [sym_false] = ACTIONS(493),
    [sym_null] = ACTIONS(493),
    [sym_inf] = ACTIONS(493),
    [sym_nan] = ACTIONS(493),
    [anon_sym_NA] = ACTIONS(493),
    [anon_sym_NA_integer_] = ACTIONS(493),
    [anon_sym_NA_real_] = ACTIONS(493),
    [anon_sym_NA_complex_] = ACTIONS(493),
    [anon_sym_NA_character_] = ACTIONS(493),
    [sym_dots] = ACTIONS(493),
    [sym_dot_dot_i] = ACTIONS(491),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(491),
    [sym__semicolon] = ACTIONS(491),
    [sym__raw_string_literal] = ACTIONS(491),
    [sym__external_else] = ACTIONS(491),
    [sym__external_open_parenthesis] = ACTIONS(145),
    [sym__external_open_brace] = ACTIONS(491),
    [sym__external_open_bracket] = ACTIONS(147),
    [sym__external_open_bracket2] = ACTIONS(149),
  },
  [69] = {
    [sym_call_arguments] = STATE(862),
    [sym_subset_arguments] = STATE(885),
    [sym_subset2_arguments] = STATE(900),
    [sym__open_parenthesis] = STATE(341),
    [sym__open_bracket] = STATE(342),
    [sym__open_bracket2] = STATE(343),
    [ts_builtin_sym_end] = ACTIONS(491),
    [sym_identifier] = ACTIONS(493),
    [anon_sym_BSLASH] = ACTIONS(491),
    [anon_sym_function] = ACTIONS(493),
    [anon_sym_EQ] = ACTIONS(493),
    [anon_sym_if] = ACTIONS(493),
    [anon_sym_for] = ACTIONS(493),
    [anon_sym_while] = ACTIONS(493),
    [anon_sym_repeat] = ACTIONS(493),
    [anon_sym_QMARK] = ACTIONS(491),
    [anon_sym_TILDE] = ACTIONS(491),
    [anon_sym_BANG] = ACTIONS(493),
    [anon_sym_PLUS] = ACTIONS(491),
    [anon_sym_DASH] = ACTIONS(493),
    [anon_sym_LT_DASH] = ACTIONS(491),
    [anon_sym_LT_LT_DASH] = ACTIONS(491),
    [anon_sym_COLON_EQ] = ACTIONS(491),
    [anon_sym_DASH_GT] = ACTIONS(493),
    [anon_sym_DASH_GT_GT] = ACTIONS(491),
    [anon_sym_PIPE] = ACTIONS(493),
    [anon_sym_AMP] = ACTIONS(493),
    [anon_sym_PIPE_PIPE] = ACTIONS(491),
    [anon_sym_AMP_AMP] = ACTIONS(491),
    [anon_sym_LT] = ACTIONS(493),
    [anon_sym_LT_EQ] = ACTIONS(491),
    [anon_sym_GT] = ACTIONS(493),
    [anon_sym_GT_EQ] = ACTIONS(491),
    [anon_sym_EQ_EQ] = ACTIONS(491),
    [anon_sym_BANG_EQ] = ACTIONS(491),
    [anon_sym_STAR] = ACTIONS(131),
    [anon_sym_SLASH] = ACTIONS(133),
    [anon_sym_STAR_STAR] = ACTIONS(135),
    [anon_sym_CARET] = ACTIONS(135),
    [aux_sym_binary_operator_token1] = ACTIONS(137),
    [anon_sym_PIPE_GT] = ACTIONS(137),
    [anon_sym_COLON] = ACTIONS(139),
    [anon_sym_DOLLAR] = ACTIONS(141),
    [anon_sym_AT] = ACTIONS(141),
    [aux_sym__hex_literal_token1] = ACTIONS(491),
    [sym__number_literal] = ACTIONS(493),
    [anon_sym_SQUOTE] = ACTIONS(491),
    [anon_sym_DQUOTE] = ACTIONS(491),
    [sym_return] = ACTIONS(493),
    [sym_next] = ACTIONS(493),
    [sym_break] = ACTIONS(493),
    [sym_true] = ACTIONS(493),
    [sym_false] = ACTIONS(493),
    [sym_null] = ACTIONS(493),
    [sym_inf] = ACTIONS(493),
    [sym_nan] = ACTIONS(493),
    [anon_sym_NA] = ACTIONS(493),
    [anon_sym_NA_integer_] = ACTIONS(493),
    [anon_sym_NA_real_] = ACTIONS(493),
    [anon_sym_NA_complex_] = ACTIONS(493),
    [anon_sym_NA_character_] = ACTIONS(493),
    [sym_dots] = ACTIONS(493),
    [sym_dot_dot_i] = ACTIONS(491),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(491),
    [sym__semicolon] = ACTIONS(491),
    [sym__raw_string_literal] = ACTIONS(491),
    [sym__external_else] = ACTIONS(491),
    [sym__external_open_parenthesis] = ACTIONS(145),
    [sym__external_open_brace] = ACTIONS(491),
    [sym__external_open_bracket] = ACTIONS(147),
    [sym__external_open_bracket2] = ACTIONS(149),
  },
  [70] = {
    [sym_call_arguments] = STATE(862),
    [sym_subset_arguments] = STATE(885),
    [sym_subset2_arguments] = STATE(900),
    [sym__open_parenthesis] = STATE(341),
    [sym__open_bracket] = STATE(342),
    [sym__open_bracket2] = STATE(343),
    [ts_builtin_sym_end] = ACTIONS(491),
    [sym_identifier] = ACTIONS(493),
    [anon_sym_BSLASH] = ACTIONS(491),
    [anon_sym_function] = ACTIONS(493),
    [anon_sym_EQ] = ACTIONS(105),
    [anon_sym_if] = ACTIONS(493),
    [anon_sym_for] = ACTIONS(493),
    [anon_sym_while] = ACTIONS(493),
    [anon_sym_repeat] = ACTIONS(493),
    [anon_sym_QMARK] = ACTIONS(491),
    [anon_sym_TILDE] = ACTIONS(107),
    [anon_sym_BANG] = ACTIONS(493),
    [anon_sym_PLUS] = ACTIONS(109),
    [anon_sym_DASH] = ACTIONS(111),
    [anon_sym_LT_DASH] = ACTIONS(113),
    [anon_sym_LT_LT_DASH] = ACTIONS(113),
    [anon_sym_COLON_EQ] = ACTIONS(113),
    [anon_sym_DASH_GT] = ACTIONS(115),
    [anon_sym_DASH_GT_GT] = ACTIONS(117),
    [anon_sym_PIPE] = ACTIONS(119),
    [anon_sym_AMP] = ACTIONS(121),
    [anon_sym_PIPE_PIPE] = ACTIONS(123),
    [anon_sym_AMP_AMP] = ACTIONS(125),
    [anon_sym_LT] = ACTIONS(127),
    [anon_sym_LT_EQ] = ACTIONS(129),
    [anon_sym_GT] = ACTIONS(127),
    [anon_sym_GT_EQ] = ACTIONS(129),
    [anon_sym_EQ_EQ] = ACTIONS(129),
    [anon_sym_BANG_EQ] = ACTIONS(129),
    [anon_sym_STAR] = ACTIONS(131),
    [anon_sym_SLASH] = ACTIONS(133),
    [anon_sym_STAR_STAR] = ACTIONS(135),
    [anon_sym_CARET] = ACTIONS(135),
    [aux_sym_binary_operator_token1] = ACTIONS(137),
    [anon_sym_PIPE_GT] = ACTIONS(137),
    [anon_sym_COLON] = ACTIONS(139),
    [anon_sym_DOLLAR] = ACTIONS(141),
    [anon_sym_AT] = ACTIONS(141),
    [aux_sym__hex_literal_token1] = ACTIONS(491),
    [sym__number_literal] = ACTIONS(493),
    [anon_sym_SQUOTE] = ACTIONS(491),
    [anon_sym_DQUOTE] = ACTIONS(491),
    [sym_return] = ACTIONS(493),
    [sym_next] = ACTIONS(493),
    [sym_break] = ACTIONS(493),
    [sym_true] = ACTIONS(493),
    [sym_false] = ACTIONS(493),
    [sym_null] = ACTIONS(493),
    [sym_inf] = ACTIONS(493),
    [sym_nan] = ACTIONS(493),
    [anon_sym_NA] = ACTIONS(493),
    [anon_sym_NA_integer_] = ACTIONS(493),
    [anon_sym_NA_real_] = ACTIONS(493),
    [anon_sym_NA_complex_] = ACTIONS(493),
    [anon_sym_NA_character_] = ACTIONS(493),
    [sym_dots] = ACTIONS(493),
    [sym_dot_dot_i] = ACTIONS(491),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(491),
    [sym__semicolon] = ACTIONS(491),
    [sym__raw_string_literal] = ACTIONS(491),
    [sym__external_else] = ACTIONS(491),
    [sym__external_open_parenthesis] = ACTIONS(145),
    [sym__external_open_brace] = ACTIONS(491),
    [sym__external_open_bracket] = ACTIONS(147),
    [sym__external_open_bracket2] = ACTIONS(149),
  },
  [71] = {
    [sym_call_arguments] = STATE(862),
    [sym_subset_arguments] = STATE(885),
    [sym_subset2_arguments] = STATE(900),
    [sym__open_parenthesis] = STATE(341),
    [sym__open_bracket] = STATE(342),
    [sym__open_bracket2] = STATE(343),
    [ts_builtin_sym_end] = ACTIONS(491),
    [sym_identifier] = ACTIONS(493),
    [anon_sym_BSLASH] = ACTIONS(491),
    [anon_sym_function] = ACTIONS(493),
    [anon_sym_EQ] = ACTIONS(493),
    [anon_sym_if] = ACTIONS(493),
    [anon_sym_for] = ACTIONS(493),
    [anon_sym_while] = ACTIONS(493),
    [anon_sym_repeat] = ACTIONS(493),
    [anon_sym_QMARK] = ACTIONS(491),
    [anon_sym_TILDE] = ACTIONS(107),
    [anon_sym_BANG] = ACTIONS(493),
    [anon_sym_PLUS] = ACTIONS(109),
    [anon_sym_DASH] = ACTIONS(111),
    [anon_sym_LT_DASH] = ACTIONS(491),
    [anon_sym_LT_LT_DASH] = ACTIONS(491),
    [anon_sym_COLON_EQ] = ACTIONS(491),
    [anon_sym_DASH_GT] = ACTIONS(493),
    [anon_sym_DASH_GT_GT] = ACTIONS(491),
    [anon_sym_PIPE] = ACTIONS(119),
    [anon_sym_AMP] = ACTIONS(121),
    [anon_sym_PIPE_PIPE] = ACTIONS(123),
    [anon_sym_AMP_AMP] = ACTIONS(125),
    [anon_sym_LT] = ACTIONS(127),
    [anon_sym_LT_EQ] = ACTIONS(129),
    [anon_sym_GT] = ACTIONS(127),
    [anon_sym_GT_EQ] = ACTIONS(129),
    [anon_sym_EQ_EQ] = ACTIONS(129),
    [anon_sym_BANG_EQ] = ACTIONS(129),
    [anon_sym_STAR] = ACTIONS(131),
    [anon_sym_SLASH] = ACTIONS(133),
    [anon_sym_STAR_STAR] = ACTIONS(135),
    [anon_sym_CARET] = ACTIONS(135),
    [aux_sym_binary_operator_token1] = ACTIONS(137),
    [anon_sym_PIPE_GT] = ACTIONS(137),
    [anon_sym_COLON] = ACTIONS(139),
    [anon_sym_DOLLAR] = ACTIONS(141),
    [anon_sym_AT] = ACTIONS(141),
    [aux_sym__hex_literal_token1] = ACTIONS(491),
    [sym__number_literal] = ACTIONS(493),
    [anon_sym_SQUOTE] = ACTIONS(491),
    [anon_sym_DQUOTE] = ACTIONS(491),
    [sym_return] = ACTIONS(493),
    [sym_next] = ACTIONS(493),
    [sym_break] = ACTIONS(493),
    [sym_true] = ACTIONS(493),
    [sym_false] = ACTIONS(493),
    [sym_null] = ACTIONS(493),
    [sym_inf] = ACTIONS(493),
    [sym_nan] = ACTIONS(493),
    [anon_sym_NA] = ACTIONS(493),
    [anon_sym_NA_integer_] = ACTIONS(493),
    [anon_sym_NA_real_] = ACTIONS(493),
    [anon_sym_NA_complex_] = ACTIONS(493),
    [anon_sym_NA_character_] = ACTIONS(493),
    [sym_dots] = ACTIONS(493),
    [sym_dot_dot_i] = ACTIONS(491),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(491),
    [sym__semicolon] = ACTIONS(491),
    [sym__raw_string_literal] = ACTIONS(491),
    [sym__external_else] = ACTIONS(491),
    [sym__external_open_parenthesis] = ACTIONS(145),
    [sym__external_open_brace] = ACTIONS(491),
    [sym__external_open_bracket] = ACTIONS(147),
    [sym__external_open_bracket2] = ACTIONS(149),
  },
  [72] = {
    [sym_call_arguments] = STATE(862),
    [sym_subset_arguments] = STATE(885),
    [sym_subset2_arguments] = STATE(900),
    [sym__open_parenthesis] = STATE(341),
    [sym__open_bracket] = STATE(342),
    [sym__open_bracket2] = STATE(343),
    [ts_builtin_sym_end] = ACTIONS(491),
    [sym_identifier] = ACTIONS(493),
    [anon_sym_BSLASH] = ACTIONS(491),
    [anon_sym_function] = ACTIONS(493),
    [anon_sym_EQ] = ACTIONS(493),
    [anon_sym_if] = ACTIONS(493),
    [anon_sym_for] = ACTIONS(493),
    [anon_sym_while] = ACTIONS(493),
    [anon_sym_repeat] = ACTIONS(493),
    [anon_sym_QMARK] = ACTIONS(491),
    [anon_sym_TILDE] = ACTIONS(491),
    [anon_sym_BANG] = ACTIONS(493),
    [anon_sym_PLUS] = ACTIONS(109),
    [anon_sym_DASH] = ACTIONS(111),
    [anon_sym_LT_DASH] = ACTIONS(491),
    [anon_sym_LT_LT_DASH] = ACTIONS(491),
    [anon_sym_COLON_EQ] = ACTIONS(491),
    [anon_sym_DASH_GT] = ACTIONS(493),
    [anon_sym_DASH_GT_GT] = ACTIONS(491),
    [anon_sym_PIPE] = ACTIONS(493),
    [anon_sym_AMP] = ACTIONS(121),
    [anon_sym_PIPE_PIPE] = ACTIONS(491),
    [anon_sym_AMP_AMP] = ACTIONS(125),
    [anon_sym_LT] = ACTIONS(127),
    [anon_sym_LT_EQ] = ACTIONS(129),
    [anon_sym_GT] = ACTIONS(127),
    [anon_sym_GT_EQ] = ACTIONS(129),
    [anon_sym_EQ_EQ] = ACTIONS(129),
    [anon_sym_BANG_EQ] = ACTIONS(129),
    [anon_sym_STAR] = ACTIONS(131),
    [anon_sym_SLASH] = ACTIONS(133),
    [anon_sym_STAR_STAR] = ACTIONS(135),
    [anon_sym_CARET] = ACTIONS(135),
    [aux_sym_binary_operator_token1] = ACTIONS(137),
    [anon_sym_PIPE_GT] = ACTIONS(137),
    [anon_sym_COLON] = ACTIONS(139),
    [anon_sym_DOLLAR] = ACTIONS(141),
    [anon_sym_AT] = ACTIONS(141),
    [aux_sym__hex_literal_token1] = ACTIONS(491),
    [sym__number_literal] = ACTIONS(493),
    [anon_sym_SQUOTE] = ACTIONS(491),
    [anon_sym_DQUOTE] = ACTIONS(491),
    [sym_return] = ACTIONS(493),
    [sym_next] = ACTIONS(493),
    [sym_break] = ACTIONS(493),
    [sym_true] = ACTIONS(493),
    [sym_false] = ACTIONS(493),
    [sym_null] = ACTIONS(493),
    [sym_inf] = ACTIONS(493),
    [sym_nan] = ACTIONS(493),
    [anon_sym_NA] = ACTIONS(493),
    [anon_sym_NA_integer_] = ACTIONS(493),
    [anon_sym_NA_real_] = ACTIONS(493),
    [anon_sym_NA_complex_] = ACTIONS(493),
    [anon_sym_NA_character_] = ACTIONS(493),
    [sym_dots] = ACTIONS(493),
    [sym_dot_dot_i] = ACTIONS(491),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(491),
    [sym__semicolon] = ACTIONS(491),
    [sym__raw_string_literal] = ACTIONS(491),
    [sym__external_else] = ACTIONS(491),
    [sym__external_open_parenthesis] = ACTIONS(145),
    [sym__external_open_brace] = ACTIONS(491),
    [sym__external_open_bracket] = ACTIONS(147),
    [sym__external_open_bracket2] = ACTIONS(149),
  },
  [73] = {
    [sym_call_arguments] = STATE(862),
    [sym_subset_arguments] = STATE(885),
    [sym_subset2_arguments] = STATE(900),
    [sym__open_parenthesis] = STATE(341),
    [sym__open_bracket] = STATE(342),
    [sym__open_bracket2] = STATE(343),
    [ts_builtin_sym_end] = ACTIONS(491),
    [sym_identifier] = ACTIONS(493),
    [anon_sym_BSLASH] = ACTIONS(491),
    [anon_sym_function] = ACTIONS(493),
    [anon_sym_EQ] = ACTIONS(493),
    [anon_sym_if] = ACTIONS(493),
    [anon_sym_for] = ACTIONS(493),
    [anon_sym_while] = ACTIONS(493),
    [anon_sym_repeat] = ACTIONS(493),
    [anon_sym_QMARK] = ACTIONS(491),
    [anon_sym_TILDE] = ACTIONS(491),
    [anon_sym_BANG] = ACTIONS(493),
    [anon_sym_PLUS] = ACTIONS(109),
    [anon_sym_DASH] = ACTIONS(111),
    [anon_sym_LT_DASH] = ACTIONS(491),
    [anon_sym_LT_LT_DASH] = ACTIONS(491),
    [anon_sym_COLON_EQ] = ACTIONS(491),
    [anon_sym_DASH_GT] = ACTIONS(493),
    [anon_sym_DASH_GT_GT] = ACTIONS(491),
    [anon_sym_PIPE] = ACTIONS(493),
    [anon_sym_AMP] = ACTIONS(493),
    [anon_sym_PIPE_PIPE] = ACTIONS(491),
    [anon_sym_AMP_AMP] = ACTIONS(491),
    [anon_sym_LT] = ACTIONS(127),
    [anon_sym_LT_EQ] = ACTIONS(129),
    [anon_sym_GT] = ACTIONS(127),
    [anon_sym_GT_EQ] = ACTIONS(129),
    [anon_sym_EQ_EQ] = ACTIONS(129),
    [anon_sym_BANG_EQ] = ACTIONS(129),
    [anon_sym_STAR] = ACTIONS(131),
    [anon_sym_SLASH] = ACTIONS(133),
    [anon_sym_STAR_STAR] = ACTIONS(135),
    [anon_sym_CARET] = ACTIONS(135),
    [aux_sym_binary_operator_token1] = ACTIONS(137),
    [anon_sym_PIPE_GT] = ACTIONS(137),
    [anon_sym_COLON] = ACTIONS(139),
    [anon_sym_DOLLAR] = ACTIONS(141),
    [anon_sym_AT] = ACTIONS(141),
    [aux_sym__hex_literal_token1] = ACTIONS(491),
    [sym__number_literal] = ACTIONS(493),
    [anon_sym_SQUOTE] = ACTIONS(491),
    [anon_sym_DQUOTE] = ACTIONS(491),
    [sym_return] = ACTIONS(493),
    [sym_next] = ACTIONS(493),
    [sym_break] = ACTIONS(493),
    [sym_true] = ACTIONS(493),
    [sym_false] = ACTIONS(493),
    [sym_null] = ACTIONS(493),
    [sym_inf] = ACTIONS(493),
    [sym_nan] = ACTIONS(493),
    [anon_sym_NA] = ACTIONS(493),
    [anon_sym_NA_integer_] = ACTIONS(493),
    [anon_sym_NA_real_] = ACTIONS(493),
    [anon_sym_NA_complex_] = ACTIONS(493),
    [anon_sym_NA_character_] = ACTIONS(493),
    [sym_dots] = ACTIONS(493),
    [sym_dot_dot_i] = ACTIONS(491),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(491),
    [sym__semicolon] = ACTIONS(491),
    [sym__raw_string_literal] = ACTIONS(491),
    [sym__external_else] = ACTIONS(491),
    [sym__external_open_parenthesis] = ACTIONS(145),
    [sym__external_open_brace] = ACTIONS(491),
    [sym__external_open_bracket] = ACTIONS(147),
    [sym__external_open_bracket2] = ACTIONS(149),
  },
  [74] = {
    [sym_call_arguments] = STATE(862),
    [sym_subset_arguments] = STATE(885),
    [sym_subset2_arguments] = STATE(900),
    [sym__open_parenthesis] = STATE(341),
    [sym__open_bracket] = STATE(342),
    [sym__open_bracket2] = STATE(343),
    [ts_builtin_sym_end] = ACTIONS(491),
    [sym_identifier] = ACTIONS(493),
    [anon_sym_BSLASH] = ACTIONS(491),
    [anon_sym_function] = ACTIONS(493),
    [anon_sym_EQ] = ACTIONS(493),
    [anon_sym_if] = ACTIONS(493),
    [anon_sym_for] = ACTIONS(493),
    [anon_sym_while] = ACTIONS(493),
    [anon_sym_repeat] = ACTIONS(493),
    [anon_sym_QMARK] = ACTIONS(491),
    [anon_sym_TILDE] = ACTIONS(491),
    [anon_sym_BANG] = ACTIONS(493),
    [anon_sym_PLUS] = ACTIONS(109),
    [anon_sym_DASH] = ACTIONS(111),
    [anon_sym_LT_DASH] = ACTIONS(491),
    [anon_sym_LT_LT_DASH] = ACTIONS(491),
    [anon_sym_COLON_EQ] = ACTIONS(491),
    [anon_sym_DASH_GT] = ACTIONS(493),
    [anon_sym_DASH_GT_GT] = ACTIONS(491),
    [anon_sym_PIPE] = ACTIONS(493),
    [anon_sym_AMP] = ACTIONS(493),
    [anon_sym_PIPE_PIPE] = ACTIONS(491),
    [anon_sym_AMP_AMP] = ACTIONS(491),
    [anon_sym_LT] = ACTIONS(493),
    [anon_sym_LT_EQ] = ACTIONS(491),
    [anon_sym_GT] = ACTIONS(493),
    [anon_sym_GT_EQ] = ACTIONS(491),
    [anon_sym_EQ_EQ] = ACTIONS(491),
    [anon_sym_BANG_EQ] = ACTIONS(491),
    [anon_sym_STAR] = ACTIONS(131),
    [anon_sym_SLASH] = ACTIONS(133),
    [anon_sym_STAR_STAR] = ACTIONS(135),
    [anon_sym_CARET] = ACTIONS(135),
    [aux_sym_binary_operator_token1] = ACTIONS(137),
    [anon_sym_PIPE_GT] = ACTIONS(137),
    [anon_sym_COLON] = ACTIONS(139),
    [anon_sym_DOLLAR] = ACTIONS(141),
    [anon_sym_AT] = ACTIONS(141),
    [aux_sym__hex_literal_token1] = ACTIONS(491),
    [sym__number_literal] = ACTIONS(493),
    [anon_sym_SQUOTE] = ACTIONS(491),
    [anon_sym_DQUOTE] = ACTIONS(491),
    [sym_return] = ACTIONS(493),
    [sym_next] = ACTIONS(493),
    [sym_break] = ACTIONS(493),
    [sym_true] = ACTIONS(493),
    [sym_false] = ACTIONS(493),
    [sym_null] = ACTIONS(493),
    [sym_inf] = ACTIONS(493),
    [sym_nan] = ACTIONS(493),
    [anon_sym_NA] = ACTIONS(493),
    [anon_sym_NA_integer_] = ACTIONS(493),
    [anon_sym_NA_real_] = ACTIONS(493),
    [anon_sym_NA_complex_] = ACTIONS(493),
    [anon_sym_NA_character_] = ACTIONS(493),
    [sym_dots] = ACTIONS(493),
    [sym_dot_dot_i] = ACTIONS(491),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(491),
    [sym__semicolon] = ACTIONS(491),
    [sym__raw_string_literal] = ACTIONS(491),
    [sym__external_else] = ACTIONS(491),
    [sym__external_open_parenthesis] = ACTIONS(145),
    [sym__external_open_brace] = ACTIONS(491),
    [sym__external_open_bracket] = ACTIONS(147),
    [sym__external_open_bracket2] = ACTIONS(149),
  },
  [75] = {
    [sym_call_arguments] = STATE(862),
    [sym_subset_arguments] = STATE(885),
    [sym_subset2_arguments] = STATE(900),
    [sym__open_parenthesis] = STATE(341),
    [sym__open_bracket] = STATE(342),
    [sym__open_bracket2] = STATE(343),
    [ts_builtin_sym_end] = ACTIONS(491),
    [sym_identifier] = ACTIONS(493),
    [anon_sym_BSLASH] = ACTIONS(491),
    [anon_sym_function] = ACTIONS(493),
    [anon_sym_EQ] = ACTIONS(493),
    [anon_sym_if] = ACTIONS(493),
    [anon_sym_for] = ACTIONS(493),
    [anon_sym_while] = ACTIONS(493),
    [anon_sym_repeat] = ACTIONS(493),
    [anon_sym_QMARK] = ACTIONS(491),
    [anon_sym_TILDE] = ACTIONS(491),
    [anon_sym_BANG] = ACTIONS(493),
    [anon_sym_PLUS] = ACTIONS(491),
    [anon_sym_DASH] = ACTIONS(493),
    [anon_sym_LT_DASH] = ACTIONS(491),
    [anon_sym_LT_LT_DASH] = ACTIONS(491),
    [anon_sym_COLON_EQ] = ACTIONS(491),
    [anon_sym_DASH_GT] = ACTIONS(493),
    [anon_sym_DASH_GT_GT] = ACTIONS(491),
    [anon_sym_PIPE] = ACTIONS(493),
    [anon_sym_AMP] = ACTIONS(493),
    [anon_sym_PIPE_PIPE] = ACTIONS(491),
    [anon_sym_AMP_AMP] = ACTIONS(491),
    [anon_sym_LT] = ACTIONS(493),
    [anon_sym_LT_EQ] = ACTIONS(491),
    [anon_sym_GT] = ACTIONS(493),
    [anon_sym_GT_EQ] = ACTIONS(491),
    [anon_sym_EQ_EQ] = ACTIONS(491),
    [anon_sym_BANG_EQ] = ACTIONS(491),
    [anon_sym_STAR] = ACTIONS(493),
    [anon_sym_SLASH] = ACTIONS(491),
    [anon_sym_STAR_STAR] = ACTIONS(135),
    [anon_sym_CARET] = ACTIONS(135),
    [aux_sym_binary_operator_token1] = ACTIONS(137),
    [anon_sym_PIPE_GT] = ACTIONS(137),
    [anon_sym_COLON] = ACTIONS(139),
    [anon_sym_DOLLAR] = ACTIONS(141),
    [anon_sym_AT] = ACTIONS(141),
    [aux_sym__hex_literal_token1] = ACTIONS(491),
    [sym__number_literal] = ACTIONS(493),
    [anon_sym_SQUOTE] = ACTIONS(491),
    [anon_sym_DQUOTE] = ACTIONS(491),
    [sym_return] = ACTIONS(493),
    [sym_next] = ACTIONS(493),
    [sym_break] = ACTIONS(493),
    [sym_true] = ACTIONS(493),
    [sym_false] = ACTIONS(493),
    [sym_null] = ACTIONS(493),
    [sym_inf] = ACTIONS(493),
    [sym_nan] = ACTIONS(493),
    [anon_sym_NA] = ACTIONS(493),
    [anon_sym_NA_integer_] = ACTIONS(493),
    [anon_sym_NA_real_] = ACTIONS(493),
    [anon_sym_NA_complex_] = ACTIONS(493),
    [anon_sym_NA_character_] = ACTIONS(493),
    [sym_dots] = ACTIONS(493),
    [sym_dot_dot_i] = ACTIONS(491),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(491),
    [sym__semicolon] = ACTIONS(491),
    [sym__raw_string_literal] = ACTIONS(491),
    [sym__external_else] = ACTIONS(491),
    [sym__external_open_parenthesis] = ACTIONS(145),
    [sym__external_open_brace] = ACTIONS(491),
    [sym__external_open_bracket] = ACTIONS(147),
    [sym__external_open_bracket2] = ACTIONS(149),
  },
  [76] = {
    [sym_call_arguments] = STATE(862),
    [sym_subset_arguments] = STATE(885),
    [sym_subset2_arguments] = STATE(900),
    [sym__open_parenthesis] = STATE(341),
    [sym__open_bracket] = STATE(342),
    [sym__open_bracket2] = STATE(343),
    [ts_builtin_sym_end] = ACTIONS(491),
    [sym_identifier] = ACTIONS(493),
    [anon_sym_BSLASH] = ACTIONS(491),
    [anon_sym_function] = ACTIONS(493),
    [anon_sym_EQ] = ACTIONS(493),
    [anon_sym_if] = ACTIONS(493),
    [anon_sym_for] = ACTIONS(493),
    [anon_sym_while] = ACTIONS(493),
    [anon_sym_repeat] = ACTIONS(493),
    [anon_sym_QMARK] = ACTIONS(491),
    [anon_sym_TILDE] = ACTIONS(491),
    [anon_sym_BANG] = ACTIONS(493),
    [anon_sym_PLUS] = ACTIONS(491),
    [anon_sym_DASH] = ACTIONS(493),
    [anon_sym_LT_DASH] = ACTIONS(491),
    [anon_sym_LT_LT_DASH] = ACTIONS(491),
    [anon_sym_COLON_EQ] = ACTIONS(491),
    [anon_sym_DASH_GT] = ACTIONS(493),
    [anon_sym_DASH_GT_GT] = ACTIONS(491),
    [anon_sym_PIPE] = ACTIONS(493),
    [anon_sym_AMP] = ACTIONS(493),
    [anon_sym_PIPE_PIPE] = ACTIONS(491),
    [anon_sym_AMP_AMP] = ACTIONS(491),
    [anon_sym_LT] = ACTIONS(493),
    [anon_sym_LT_EQ] = ACTIONS(491),
    [anon_sym_GT] = ACTIONS(493),
    [anon_sym_GT_EQ] = ACTIONS(491),
    [anon_sym_EQ_EQ] = ACTIONS(491),
    [anon_sym_BANG_EQ] = ACTIONS(491),
    [anon_sym_STAR] = ACTIONS(493),
    [anon_sym_SLASH] = ACTIONS(491),
    [anon_sym_STAR_STAR] = ACTIONS(135),
    [anon_sym_CARET] = ACTIONS(135),
    [aux_sym_binary_operator_token1] = ACTIONS(491),
    [anon_sym_PIPE_GT] = ACTIONS(491),
    [anon_sym_COLON] = ACTIONS(493),
    [anon_sym_DOLLAR] = ACTIONS(141),
    [anon_sym_AT] = ACTIONS(141),
    [aux_sym__hex_literal_token1] = ACTIONS(491),
    [sym__number_literal] = ACTIONS(493),
    [anon_sym_SQUOTE] = ACTIONS(491),
    [anon_sym_DQUOTE] = ACTIONS(491),
    [sym_return] = ACTIONS(493),
    [sym_next] = ACTIONS(493),
    [sym_break] = ACTIONS(493),
    [sym_true] = ACTIONS(493),
    [sym_false] = ACTIONS(493),
    [sym_null] = ACTIONS(493),
    [sym_inf] = ACTIONS(493),
    [sym_nan] = ACTIONS(493),
    [anon_sym_NA] = ACTIONS(493),
    [anon_sym_NA_integer_] = ACTIONS(493),
    [anon_sym_NA_real_] = ACTIONS(493),
    [anon_sym_NA_complex_] = ACTIONS(493),
    [anon_sym_NA_character_] = ACTIONS(493),
    [sym_dots] = ACTIONS(493),
    [sym_dot_dot_i] = ACTIONS(491),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(491),
    [sym__semicolon] = ACTIONS(491),
    [sym__raw_string_literal] = ACTIONS(491),
    [sym__external_else] = ACTIONS(491),
    [sym__external_open_parenthesis] = ACTIONS(145),
    [sym__external_open_brace] = ACTIONS(491),
    [sym__external_open_bracket] = ACTIONS(147),
    [sym__external_open_bracket2] = ACTIONS(149),
  },
  [77] = {
    [sym_call_arguments] = STATE(862),
    [sym_subset_arguments] = STATE(885),
    [sym_subset2_arguments] = STATE(900),
    [sym__open_parenthesis] = STATE(341),
    [sym__open_bracket] = STATE(342),
    [sym__open_bracket2] = STATE(343),
    [ts_builtin_sym_end] = ACTIONS(491),
    [sym_identifier] = ACTIONS(493),
    [anon_sym_BSLASH] = ACTIONS(491),
    [anon_sym_function] = ACTIONS(493),
    [anon_sym_EQ] = ACTIONS(493),
    [anon_sym_if] = ACTIONS(493),
    [anon_sym_for] = ACTIONS(493),
    [anon_sym_while] = ACTIONS(493),
    [anon_sym_repeat] = ACTIONS(493),
    [anon_sym_QMARK] = ACTIONS(491),
    [anon_sym_TILDE] = ACTIONS(491),
    [anon_sym_BANG] = ACTIONS(493),
    [anon_sym_PLUS] = ACTIONS(491),
    [anon_sym_DASH] = ACTIONS(493),
    [anon_sym_LT_DASH] = ACTIONS(491),
    [anon_sym_LT_LT_DASH] = ACTIONS(491),
    [anon_sym_COLON_EQ] = ACTIONS(491),
    [anon_sym_DASH_GT] = ACTIONS(493),
    [anon_sym_DASH_GT_GT] = ACTIONS(491),
    [anon_sym_PIPE] = ACTIONS(493),
    [anon_sym_AMP] = ACTIONS(493),
    [anon_sym_PIPE_PIPE] = ACTIONS(491),
    [anon_sym_AMP_AMP] = ACTIONS(491),
    [anon_sym_LT] = ACTIONS(493),
    [anon_sym_LT_EQ] = ACTIONS(491),
    [anon_sym_GT] = ACTIONS(493),
    [anon_sym_GT_EQ] = ACTIONS(491),
    [anon_sym_EQ_EQ] = ACTIONS(491),
    [anon_sym_BANG_EQ] = ACTIONS(491),
    [anon_sym_STAR] = ACTIONS(493),
    [anon_sym_SLASH] = ACTIONS(491),
    [anon_sym_STAR_STAR] = ACTIONS(135),
    [anon_sym_CARET] = ACTIONS(135),
    [aux_sym_binary_operator_token1] = ACTIONS(491),
    [anon_sym_PIPE_GT] = ACTIONS(491),
    [anon_sym_COLON] = ACTIONS(139),
    [anon_sym_DOLLAR] = ACTIONS(141),
    [anon_sym_AT] = ACTIONS(141),
    [aux_sym__hex_literal_token1] = ACTIONS(491),
    [sym__number_literal] = ACTIONS(493),
    [anon_sym_SQUOTE] = ACTIONS(491),
    [anon_sym_DQUOTE] = ACTIONS(491),
    [sym_return] = ACTIONS(493),
    [sym_next] = ACTIONS(493),
    [sym_break] = ACTIONS(493),
    [sym_true] = ACTIONS(493),
    [sym_false] = ACTIONS(493),
    [sym_null] = ACTIONS(493),
    [sym_inf] = ACTIONS(493),
    [sym_nan] = ACTIONS(493),
    [anon_sym_NA] = ACTIONS(493),
    [anon_sym_NA_integer_] = ACTIONS(493),
    [anon_sym_NA_real_] = ACTIONS(493),
    [anon_sym_NA_complex_] = ACTIONS(493),
    [anon_sym_NA_character_] = ACTIONS(493),
    [sym_dots] = ACTIONS(493),
    [sym_dot_dot_i] = ACTIONS(491),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(491),
    [sym__semicolon] = ACTIONS(491),
    [sym__raw_string_literal] = ACTIONS(491),
    [sym__external_else] = ACTIONS(491),
    [sym__external_open_parenthesis] = ACTIONS(145),
    [sym__external_open_brace] = ACTIONS(491),
    [sym__external_open_bracket] = ACTIONS(147),
    [sym__external_open_bracket2] = ACTIONS(149),
  },
  [78] = {
    [sym_call_arguments] = STATE(862),
    [sym_subset_arguments] = STATE(885),
    [sym_subset2_arguments] = STATE(900),
    [sym__open_parenthesis] = STATE(341),
    [sym__open_bracket] = STATE(342),
    [sym__open_bracket2] = STATE(343),
    [ts_builtin_sym_end] = ACTIONS(491),
    [sym_identifier] = ACTIONS(493),
    [anon_sym_BSLASH] = ACTIONS(491),
    [anon_sym_function] = ACTIONS(493),
    [anon_sym_EQ] = ACTIONS(493),
    [anon_sym_if] = ACTIONS(493),
    [anon_sym_for] = ACTIONS(493),
    [anon_sym_while] = ACTIONS(493),
    [anon_sym_repeat] = ACTIONS(493),
    [anon_sym_QMARK] = ACTIONS(491),
    [anon_sym_TILDE] = ACTIONS(491),
    [anon_sym_BANG] = ACTIONS(493),
    [anon_sym_PLUS] = ACTIONS(491),
    [anon_sym_DASH] = ACTIONS(493),
    [anon_sym_LT_DASH] = ACTIONS(491),
    [anon_sym_LT_LT_DASH] = ACTIONS(491),
    [anon_sym_COLON_EQ] = ACTIONS(491),
    [anon_sym_DASH_GT] = ACTIONS(493),
    [anon_sym_DASH_GT_GT] = ACTIONS(491),
    [anon_sym_PIPE] = ACTIONS(493),
    [anon_sym_AMP] = ACTIONS(493),
    [anon_sym_PIPE_PIPE] = ACTIONS(491),
    [anon_sym_AMP_AMP] = ACTIONS(491),
    [anon_sym_LT] = ACTIONS(493),
    [anon_sym_LT_EQ] = ACTIONS(491),
    [anon_sym_GT] = ACTIONS(493),
    [anon_sym_GT_EQ] = ACTIONS(491),
    [anon_sym_EQ_EQ] = ACTIONS(491),
    [anon_sym_BANG_EQ] = ACTIONS(491),
    [anon_sym_STAR] = ACTIONS(493),
    [anon_sym_SLASH] = ACTIONS(491),
    [anon_sym_STAR_STAR] = ACTIONS(135),
    [anon_sym_CARET] = ACTIONS(135),
    [aux_sym_binary_operator_token1] = ACTIONS(491),
    [anon_sym_PIPE_GT] = ACTIONS(491),
    [anon_sym_COLON] = ACTIONS(493),
    [anon_sym_DOLLAR] = ACTIONS(141),
    [anon_sym_AT] = ACTIONS(141),
    [aux_sym__hex_literal_token1] = ACTIONS(491),
    [sym__number_literal] = ACTIONS(493),
    [anon_sym_SQUOTE] = ACTIONS(491),
    [anon_sym_DQUOTE] = ACTIONS(491),
    [sym_return] = ACTIONS(493),
    [sym_next] = ACTIONS(493),
    [sym_break] = ACTIONS(493),
    [sym_true] = ACTIONS(493),
    [sym_false] = ACTIONS(493),
    [sym_null] = ACTIONS(493),
    [sym_inf] = ACTIONS(493),
    [sym_nan] = ACTIONS(493),
    [anon_sym_NA] = ACTIONS(493),
    [anon_sym_NA_integer_] = ACTIONS(493),
    [anon_sym_NA_real_] = ACTIONS(493),
    [anon_sym_NA_complex_] = ACTIONS(493),
    [anon_sym_NA_character_] = ACTIONS(493),
    [sym_dots] = ACTIONS(493),
    [sym_dot_dot_i] = ACTIONS(491),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(491),
    [sym__semicolon] = ACTIONS(491),
    [sym__raw_string_literal] = ACTIONS(491),
    [sym__external_else] = ACTIONS(491),
    [sym__external_open_parenthesis] = ACTIONS(145),
    [sym__external_open_brace] = ACTIONS(491),
    [sym__external_open_bracket] = ACTIONS(147),
    [sym__external_open_bracket2] = ACTIONS(149),
  },
  [79] = {
    [sym_call_arguments] = STATE(862),
    [sym_subset_arguments] = STATE(885),
    [sym_subset2_arguments] = STATE(900),
    [sym__open_parenthesis] = STATE(341),
    [sym__open_bracket] = STATE(342),
    [sym__open_bracket2] = STATE(343),
    [ts_builtin_sym_end] = ACTIONS(495),
    [sym_identifier] = ACTIONS(497),
    [anon_sym_BSLASH] = ACTIONS(495),
    [anon_sym_function] = ACTIONS(497),
    [anon_sym_EQ] = ACTIONS(105),
    [anon_sym_if] = ACTIONS(497),
    [anon_sym_for] = ACTIONS(497),
    [anon_sym_while] = ACTIONS(497),
    [anon_sym_repeat] = ACTIONS(497),
    [anon_sym_QMARK] = ACTIONS(495),
    [anon_sym_TILDE] = ACTIONS(107),
    [anon_sym_BANG] = ACTIONS(497),
    [anon_sym_PLUS] = ACTIONS(109),
    [anon_sym_DASH] = ACTIONS(111),
    [anon_sym_LT_DASH] = ACTIONS(113),
    [anon_sym_LT_LT_DASH] = ACTIONS(113),
    [anon_sym_COLON_EQ] = ACTIONS(113),
    [anon_sym_DASH_GT] = ACTIONS(115),
    [anon_sym_DASH_GT_GT] = ACTIONS(117),
    [anon_sym_PIPE] = ACTIONS(119),
    [anon_sym_AMP] = ACTIONS(121),
    [anon_sym_PIPE_PIPE] = ACTIONS(123),
    [anon_sym_AMP_AMP] = ACTIONS(125),
    [anon_sym_LT] = ACTIONS(127),
    [anon_sym_LT_EQ] = ACTIONS(129),
    [anon_sym_GT] = ACTIONS(127),
    [anon_sym_GT_EQ] = ACTIONS(129),
    [anon_sym_EQ_EQ] = ACTIONS(129),
    [anon_sym_BANG_EQ] = ACTIONS(129),
    [anon_sym_STAR] = ACTIONS(131),
    [anon_sym_SLASH] = ACTIONS(133),
    [anon_sym_STAR_STAR] = ACTIONS(135),
    [anon_sym_CARET] = ACTIONS(135),
    [aux_sym_binary_operator_token1] = ACTIONS(137),
    [anon_sym_PIPE_GT] = ACTIONS(137),
    [anon_sym_COLON] = ACTIONS(139),
    [anon_sym_DOLLAR] = ACTIONS(141),
    [anon_sym_AT] = ACTIONS(141),
    [aux_sym__hex_literal_token1] = ACTIONS(495),
    [sym__number_literal] = ACTIONS(497),
    [anon_sym_SQUOTE] = ACTIONS(495),
    [anon_sym_DQUOTE] = ACTIONS(495),
    [sym_return] = ACTIONS(497),
    [sym_next] = ACTIONS(497),
    [sym_break] = ACTIONS(497),
    [sym_true] = ACTIONS(497),
    [sym_false] = ACTIONS(497),
    [sym_null] = ACTIONS(497),
    [sym_inf] = ACTIONS(497),
    [sym_nan] = ACTIONS(497),
    [anon_sym_NA] = ACTIONS(497),
    [anon_sym_NA_integer_] = ACTIONS(497),
    [anon_sym_NA_real_] = ACTIONS(497),
    [anon_sym_NA_complex_] = ACTIONS(497),
    [anon_sym_NA_character_] = ACTIONS(497),
    [sym_dots] = ACTIONS(497),
    [sym_dot_dot_i] = ACTIONS(495),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(495),
    [sym__semicolon] = ACTIONS(495),
    [sym__raw_string_literal] = ACTIONS(495),
    [sym__external_else] = ACTIONS(495),
    [sym__external_open_parenthesis] = ACTIONS(145),
    [sym__external_open_brace] = ACTIONS(495),
    [sym__external_open_bracket] = ACTIONS(147),
    [sym__external_open_bracket2] = ACTIONS(149),
  },
  [80] = {
    [sym_call_arguments] = STATE(862),
    [sym_subset_arguments] = STATE(885),
    [sym_subset2_arguments] = STATE(900),
    [sym__open_parenthesis] = STATE(341),
    [sym__open_bracket] = STATE(342),
    [sym__open_bracket2] = STATE(343),
    [ts_builtin_sym_end] = ACTIONS(499),
    [sym_identifier] = ACTIONS(501),
    [anon_sym_BSLASH] = ACTIONS(499),
    [anon_sym_function] = ACTIONS(501),
    [anon_sym_EQ] = ACTIONS(105),
    [anon_sym_if] = ACTIONS(501),
    [anon_sym_for] = ACTIONS(501),
    [anon_sym_while] = ACTIONS(501),
    [anon_sym_repeat] = ACTIONS(501),
    [anon_sym_QMARK] = ACTIONS(499),
    [anon_sym_TILDE] = ACTIONS(107),
    [anon_sym_BANG] = ACTIONS(501),
    [anon_sym_PLUS] = ACTIONS(109),
    [anon_sym_DASH] = ACTIONS(111),
    [anon_sym_LT_DASH] = ACTIONS(113),
    [anon_sym_LT_LT_DASH] = ACTIONS(113),
    [anon_sym_COLON_EQ] = ACTIONS(113),
    [anon_sym_DASH_GT] = ACTIONS(115),
    [anon_sym_DASH_GT_GT] = ACTIONS(117),
    [anon_sym_PIPE] = ACTIONS(119),
    [anon_sym_AMP] = ACTIONS(121),
    [anon_sym_PIPE_PIPE] = ACTIONS(123),
    [anon_sym_AMP_AMP] = ACTIONS(125),
    [anon_sym_LT] = ACTIONS(127),
    [anon_sym_LT_EQ] = ACTIONS(129),
    [anon_sym_GT] = ACTIONS(127),
    [anon_sym_GT_EQ] = ACTIONS(129),
    [anon_sym_EQ_EQ] = ACTIONS(129),
    [anon_sym_BANG_EQ] = ACTIONS(129),
    [anon_sym_STAR] = ACTIONS(131),
    [anon_sym_SLASH] = ACTIONS(133),
    [anon_sym_STAR_STAR] = ACTIONS(135),
    [anon_sym_CARET] = ACTIONS(135),
    [aux_sym_binary_operator_token1] = ACTIONS(137),
    [anon_sym_PIPE_GT] = ACTIONS(137),
    [anon_sym_COLON] = ACTIONS(139),
    [anon_sym_DOLLAR] = ACTIONS(141),
    [anon_sym_AT] = ACTIONS(141),
    [aux_sym__hex_literal_token1] = ACTIONS(499),
    [sym__number_literal] = ACTIONS(501),
    [anon_sym_SQUOTE] = ACTIONS(499),
    [anon_sym_DQUOTE] = ACTIONS(499),
    [sym_return] = ACTIONS(501),
    [sym_next] = ACTIONS(501),
    [sym_break] = ACTIONS(501),
    [sym_true] = ACTIONS(501),
    [sym_false] = ACTIONS(501),
    [sym_null] = ACTIONS(501),
    [sym_inf] = ACTIONS(501),
    [sym_nan] = ACTIONS(501),
    [anon_sym_NA] = ACTIONS(501),
    [anon_sym_NA_integer_] = ACTIONS(501),
    [anon_sym_NA_real_] = ACTIONS(501),
    [anon_sym_NA_complex_] = ACTIONS(501),
    [anon_sym_NA_character_] = ACTIONS(501),
    [sym_dots] = ACTIONS(501),
    [sym_dot_dot_i] = ACTIONS(499),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(499),
    [sym__semicolon] = ACTIONS(499),
    [sym__raw_string_literal] = ACTIONS(499),
    [sym__external_else] = ACTIONS(499),
    [sym__external_open_parenthesis] = ACTIONS(145),
    [sym__external_open_brace] = ACTIONS(499),
    [sym__external_open_bracket] = ACTIONS(147),
    [sym__external_open_bracket2] = ACTIONS(149),
  },
  [81] = {
    [sym_call_arguments] = STATE(862),
    [sym_subset_arguments] = STATE(885),
    [sym_subset2_arguments] = STATE(900),
    [sym__open_parenthesis] = STATE(341),
    [sym__open_bracket] = STATE(342),
    [sym__open_bracket2] = STATE(343),
    [ts_builtin_sym_end] = ACTIONS(503),
    [sym_identifier] = ACTIONS(505),
    [anon_sym_BSLASH] = ACTIONS(503),
    [anon_sym_function] = ACTIONS(505),
    [anon_sym_EQ] = ACTIONS(105),
    [anon_sym_if] = ACTIONS(505),
    [anon_sym_for] = ACTIONS(505),
    [anon_sym_while] = ACTIONS(505),
    [anon_sym_repeat] = ACTIONS(505),
    [anon_sym_QMARK] = ACTIONS(503),
    [anon_sym_TILDE] = ACTIONS(107),
    [anon_sym_BANG] = ACTIONS(505),
    [anon_sym_PLUS] = ACTIONS(109),
    [anon_sym_DASH] = ACTIONS(111),
    [anon_sym_LT_DASH] = ACTIONS(113),
    [anon_sym_LT_LT_DASH] = ACTIONS(113),
    [anon_sym_COLON_EQ] = ACTIONS(113),
    [anon_sym_DASH_GT] = ACTIONS(115),
    [anon_sym_DASH_GT_GT] = ACTIONS(117),
    [anon_sym_PIPE] = ACTIONS(119),
    [anon_sym_AMP] = ACTIONS(121),
    [anon_sym_PIPE_PIPE] = ACTIONS(123),
    [anon_sym_AMP_AMP] = ACTIONS(125),
    [anon_sym_LT] = ACTIONS(127),
    [anon_sym_LT_EQ] = ACTIONS(129),
    [anon_sym_GT] = ACTIONS(127),
    [anon_sym_GT_EQ] = ACTIONS(129),
    [anon_sym_EQ_EQ] = ACTIONS(129),
    [anon_sym_BANG_EQ] = ACTIONS(129),
    [anon_sym_STAR] = ACTIONS(131),
    [anon_sym_SLASH] = ACTIONS(133),
    [anon_sym_STAR_STAR] = ACTIONS(135),
    [anon_sym_CARET] = ACTIONS(135),
    [aux_sym_binary_operator_token1] = ACTIONS(137),
    [anon_sym_PIPE_GT] = ACTIONS(137),
    [anon_sym_COLON] = ACTIONS(139),
    [anon_sym_DOLLAR] = ACTIONS(141),
    [anon_sym_AT] = ACTIONS(141),
    [aux_sym__hex_literal_token1] = ACTIONS(503),
    [sym__number_literal] = ACTIONS(505),
    [anon_sym_SQUOTE] = ACTIONS(503),
    [anon_sym_DQUOTE] = ACTIONS(503),
    [sym_return] = ACTIONS(505),
    [sym_next] = ACTIONS(505),
    [sym_break] = ACTIONS(505),
    [sym_true] = ACTIONS(505),
    [sym_false] = ACTIONS(505),
    [sym_null] = ACTIONS(505),
    [sym_inf] = ACTIONS(505),
    [sym_nan] = ACTIONS(505),
    [anon_sym_NA] = ACTIONS(505),
    [anon_sym_NA_integer_] = ACTIONS(505),
    [anon_sym_NA_real_] = ACTIONS(505),
    [anon_sym_NA_complex_] = ACTIONS(505),
    [anon_sym_NA_character_] = ACTIONS(505),
    [sym_dots] = ACTIONS(505),
    [sym_dot_dot_i] = ACTIONS(503),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(503),
    [sym__semicolon] = ACTIONS(503),
    [sym__raw_string_literal] = ACTIONS(503),
    [sym__external_else] = ACTIONS(503),
    [sym__external_open_parenthesis] = ACTIONS(145),
    [sym__external_open_brace] = ACTIONS(503),
    [sym__external_open_bracket] = ACTIONS(147),
    [sym__external_open_bracket2] = ACTIONS(149),
  },
  [82] = {
    [sym_call_arguments] = STATE(862),
    [sym_subset_arguments] = STATE(885),
    [sym_subset2_arguments] = STATE(900),
    [sym__open_parenthesis] = STATE(341),
    [sym__open_bracket] = STATE(342),
    [sym__open_bracket2] = STATE(343),
    [ts_builtin_sym_end] = ACTIONS(507),
    [sym_identifier] = ACTIONS(509),
    [anon_sym_BSLASH] = ACTIONS(507),
    [anon_sym_function] = ACTIONS(509),
    [anon_sym_EQ] = ACTIONS(105),
    [anon_sym_if] = ACTIONS(509),
    [anon_sym_for] = ACTIONS(509),
    [anon_sym_while] = ACTIONS(509),
    [anon_sym_repeat] = ACTIONS(509),
    [anon_sym_QMARK] = ACTIONS(507),
    [anon_sym_TILDE] = ACTIONS(107),
    [anon_sym_BANG] = ACTIONS(509),
    [anon_sym_PLUS] = ACTIONS(109),
    [anon_sym_DASH] = ACTIONS(111),
    [anon_sym_LT_DASH] = ACTIONS(113),
    [anon_sym_LT_LT_DASH] = ACTIONS(113),
    [anon_sym_COLON_EQ] = ACTIONS(113),
    [anon_sym_DASH_GT] = ACTIONS(115),
    [anon_sym_DASH_GT_GT] = ACTIONS(117),
    [anon_sym_PIPE] = ACTIONS(119),
    [anon_sym_AMP] = ACTIONS(121),
    [anon_sym_PIPE_PIPE] = ACTIONS(123),
    [anon_sym_AMP_AMP] = ACTIONS(125),
    [anon_sym_LT] = ACTIONS(127),
    [anon_sym_LT_EQ] = ACTIONS(129),
    [anon_sym_GT] = ACTIONS(127),
    [anon_sym_GT_EQ] = ACTIONS(129),
    [anon_sym_EQ_EQ] = ACTIONS(129),
    [anon_sym_BANG_EQ] = ACTIONS(129),
    [anon_sym_STAR] = ACTIONS(131),
    [anon_sym_SLASH] = ACTIONS(133),
    [anon_sym_STAR_STAR] = ACTIONS(135),
    [anon_sym_CARET] = ACTIONS(135),
    [aux_sym_binary_operator_token1] = ACTIONS(137),
    [anon_sym_PIPE_GT] = ACTIONS(137),
    [anon_sym_COLON] = ACTIONS(139),
    [anon_sym_DOLLAR] = ACTIONS(141),
    [anon_sym_AT] = ACTIONS(141),
    [aux_sym__hex_literal_token1] = ACTIONS(507),
    [sym__number_literal] = ACTIONS(509),
    [anon_sym_SQUOTE] = ACTIONS(507),
    [anon_sym_DQUOTE] = ACTIONS(507),
    [sym_return] = ACTIONS(509),
    [sym_next] = ACTIONS(509),
    [sym_break] = ACTIONS(509),
    [sym_true] = ACTIONS(509),
    [sym_false] = ACTIONS(509),
    [sym_null] = ACTIONS(509),
    [sym_inf] = ACTIONS(509),
    [sym_nan] = ACTIONS(509),
    [anon_sym_NA] = ACTIONS(509),
    [anon_sym_NA_integer_] = ACTIONS(509),
    [anon_sym_NA_real_] = ACTIONS(509),
    [anon_sym_NA_complex_] = ACTIONS(509),
    [anon_sym_NA_character_] = ACTIONS(509),
    [sym_dots] = ACTIONS(509),
    [sym_dot_dot_i] = ACTIONS(507),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(507),
    [sym__semicolon] = ACTIONS(507),
    [sym__raw_string_literal] = ACTIONS(507),
    [sym__external_else] = ACTIONS(507),
    [sym__external_open_parenthesis] = ACTIONS(145),
    [sym__external_open_brace] = ACTIONS(507),
    [sym__external_open_bracket] = ACTIONS(147),
    [sym__external_open_bracket2] = ACTIONS(149),
  },
  [83] = {
    [sym_call_arguments] = STATE(862),
    [sym_subset_arguments] = STATE(885),
    [sym_subset2_arguments] = STATE(900),
    [sym__open_parenthesis] = STATE(341),
    [sym__open_bracket] = STATE(342),
    [sym__open_bracket2] = STATE(343),
    [ts_builtin_sym_end] = ACTIONS(511),
    [sym_identifier] = ACTIONS(513),
    [anon_sym_BSLASH] = ACTIONS(511),
    [anon_sym_function] = ACTIONS(513),
    [anon_sym_EQ] = ACTIONS(105),
    [anon_sym_if] = ACTIONS(513),
    [anon_sym_for] = ACTIONS(513),
    [anon_sym_while] = ACTIONS(513),
    [anon_sym_repeat] = ACTIONS(513),
    [anon_sym_QMARK] = ACTIONS(511),
    [anon_sym_TILDE] = ACTIONS(107),
    [anon_sym_BANG] = ACTIONS(513),
    [anon_sym_PLUS] = ACTIONS(109),
    [anon_sym_DASH] = ACTIONS(111),
    [anon_sym_LT_DASH] = ACTIONS(113),
    [anon_sym_LT_LT_DASH] = ACTIONS(113),
    [anon_sym_COLON_EQ] = ACTIONS(113),
    [anon_sym_DASH_GT] = ACTIONS(115),
    [anon_sym_DASH_GT_GT] = ACTIONS(117),
    [anon_sym_PIPE] = ACTIONS(119),
    [anon_sym_AMP] = ACTIONS(121),
    [anon_sym_PIPE_PIPE] = ACTIONS(123),
    [anon_sym_AMP_AMP] = ACTIONS(125),
    [anon_sym_LT] = ACTIONS(127),
    [anon_sym_LT_EQ] = ACTIONS(129),
    [anon_sym_GT] = ACTIONS(127),
    [anon_sym_GT_EQ] = ACTIONS(129),
    [anon_sym_EQ_EQ] = ACTIONS(129),
    [anon_sym_BANG_EQ] = ACTIONS(129),
    [anon_sym_STAR] = ACTIONS(131),
    [anon_sym_SLASH] = ACTIONS(133),
    [anon_sym_STAR_STAR] = ACTIONS(135),
    [anon_sym_CARET] = ACTIONS(135),
    [aux_sym_binary_operator_token1] = ACTIONS(137),
    [anon_sym_PIPE_GT] = ACTIONS(137),
    [anon_sym_COLON] = ACTIONS(139),
    [anon_sym_DOLLAR] = ACTIONS(141),
    [anon_sym_AT] = ACTIONS(141),
    [aux_sym__hex_literal_token1] = ACTIONS(511),
    [sym__number_literal] = ACTIONS(513),
    [anon_sym_SQUOTE] = ACTIONS(511),
    [anon_sym_DQUOTE] = ACTIONS(511),
    [sym_return] = ACTIONS(513),
    [sym_next] = ACTIONS(513),
    [sym_break] = ACTIONS(513),
    [sym_true] = ACTIONS(513),
    [sym_false] = ACTIONS(513),
    [sym_null] = ACTIONS(513),
    [sym_inf] = ACTIONS(513),
    [sym_nan] = ACTIONS(513),
    [anon_sym_NA] = ACTIONS(513),
    [anon_sym_NA_integer_] = ACTIONS(513),
    [anon_sym_NA_real_] = ACTIONS(513),
    [anon_sym_NA_complex_] = ACTIONS(513),
    [anon_sym_NA_character_] = ACTIONS(513),
    [sym_dots] = ACTIONS(513),
    [sym_dot_dot_i] = ACTIONS(511),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(511),
    [sym__semicolon] = ACTIONS(511),
    [sym__raw_string_literal] = ACTIONS(511),
    [sym__external_else] = ACTIONS(511),
    [sym__external_open_parenthesis] = ACTIONS(145),
    [sym__external_open_brace] = ACTIONS(511),
    [sym__external_open_bracket] = ACTIONS(147),
    [sym__external_open_bracket2] = ACTIONS(149),
  },
  [84] = {
    [sym_call_arguments] = STATE(862),
    [sym_subset_arguments] = STATE(885),
    [sym_subset2_arguments] = STATE(900),
    [sym__open_parenthesis] = STATE(341),
    [sym__open_bracket] = STATE(342),
    [sym__open_bracket2] = STATE(343),
    [ts_builtin_sym_end] = ACTIONS(515),
    [sym_identifier] = ACTIONS(517),
    [anon_sym_BSLASH] = ACTIONS(515),
    [anon_sym_function] = ACTIONS(517),
    [anon_sym_EQ] = ACTIONS(105),
    [anon_sym_if] = ACTIONS(517),
    [anon_sym_for] = ACTIONS(517),
    [anon_sym_while] = ACTIONS(517),
    [anon_sym_repeat] = ACTIONS(517),
    [anon_sym_QMARK] = ACTIONS(515),
    [anon_sym_TILDE] = ACTIONS(107),
    [anon_sym_BANG] = ACTIONS(517),
    [anon_sym_PLUS] = ACTIONS(109),
    [anon_sym_DASH] = ACTIONS(111),
    [anon_sym_LT_DASH] = ACTIONS(113),
    [anon_sym_LT_LT_DASH] = ACTIONS(113),
    [anon_sym_COLON_EQ] = ACTIONS(113),
    [anon_sym_DASH_GT] = ACTIONS(115),
    [anon_sym_DASH_GT_GT] = ACTIONS(117),
    [anon_sym_PIPE] = ACTIONS(119),
    [anon_sym_AMP] = ACTIONS(121),
    [anon_sym_PIPE_PIPE] = ACTIONS(123),
    [anon_sym_AMP_AMP] = ACTIONS(125),
    [anon_sym_LT] = ACTIONS(127),
    [anon_sym_LT_EQ] = ACTIONS(129),
    [anon_sym_GT] = ACTIONS(127),
    [anon_sym_GT_EQ] = ACTIONS(129),
    [anon_sym_EQ_EQ] = ACTIONS(129),
    [anon_sym_BANG_EQ] = ACTIONS(129),
    [anon_sym_STAR] = ACTIONS(131),
    [anon_sym_SLASH] = ACTIONS(133),
    [anon_sym_STAR_STAR] = ACTIONS(135),
    [anon_sym_CARET] = ACTIONS(135),
    [aux_sym_binary_operator_token1] = ACTIONS(137),
    [anon_sym_PIPE_GT] = ACTIONS(137),
    [anon_sym_COLON] = ACTIONS(139),
    [anon_sym_DOLLAR] = ACTIONS(141),
    [anon_sym_AT] = ACTIONS(141),
    [aux_sym__hex_literal_token1] = ACTIONS(515),
    [sym__number_literal] = ACTIONS(517),
    [anon_sym_SQUOTE] = ACTIONS(515),
    [anon_sym_DQUOTE] = ACTIONS(515),
    [sym_return] = ACTIONS(517),
    [sym_next] = ACTIONS(517),
    [sym_break] = ACTIONS(517),
    [sym_true] = ACTIONS(517),
    [sym_false] = ACTIONS(517),
    [sym_null] = ACTIONS(517),
    [sym_inf] = ACTIONS(517),
    [sym_nan] = ACTIONS(517),
    [anon_sym_NA] = ACTIONS(517),
    [anon_sym_NA_integer_] = ACTIONS(517),
    [anon_sym_NA_real_] = ACTIONS(517),
    [anon_sym_NA_complex_] = ACTIONS(517),
    [anon_sym_NA_character_] = ACTIONS(517),
    [sym_dots] = ACTIONS(517),
    [sym_dot_dot_i] = ACTIONS(515),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(515),
    [sym__semicolon] = ACTIONS(515),
    [sym__raw_string_literal] = ACTIONS(515),
    [sym__external_else] = ACTIONS(515),
    [sym__external_open_parenthesis] = ACTIONS(145),
    [sym__external_open_brace] = ACTIONS(515),
    [sym__external_open_bracket] = ACTIONS(147),
    [sym__external_open_bracket2] = ACTIONS(149),
  },
  [85] = {
    [sym_call_arguments] = STATE(862),
    [sym_subset_arguments] = STATE(885),
    [sym_subset2_arguments] = STATE(900),
    [sym__open_parenthesis] = STATE(341),
    [sym__open_bracket] = STATE(342),
    [sym__open_bracket2] = STATE(343),
    [ts_builtin_sym_end] = ACTIONS(519),
    [sym_identifier] = ACTIONS(521),
    [anon_sym_BSLASH] = ACTIONS(519),
    [anon_sym_function] = ACTIONS(521),
    [anon_sym_EQ] = ACTIONS(105),
    [anon_sym_if] = ACTIONS(521),
    [anon_sym_for] = ACTIONS(521),
    [anon_sym_while] = ACTIONS(521),
    [anon_sym_repeat] = ACTIONS(521),
    [anon_sym_QMARK] = ACTIONS(519),
    [anon_sym_TILDE] = ACTIONS(107),
    [anon_sym_BANG] = ACTIONS(521),
    [anon_sym_PLUS] = ACTIONS(109),
    [anon_sym_DASH] = ACTIONS(111),
    [anon_sym_LT_DASH] = ACTIONS(113),
    [anon_sym_LT_LT_DASH] = ACTIONS(113),
    [anon_sym_COLON_EQ] = ACTIONS(113),
    [anon_sym_DASH_GT] = ACTIONS(115),
    [anon_sym_DASH_GT_GT] = ACTIONS(117),
    [anon_sym_PIPE] = ACTIONS(119),
    [anon_sym_AMP] = ACTIONS(121),
    [anon_sym_PIPE_PIPE] = ACTIONS(123),
    [anon_sym_AMP_AMP] = ACTIONS(125),
    [anon_sym_LT] = ACTIONS(127),
    [anon_sym_LT_EQ] = ACTIONS(129),
    [anon_sym_GT] = ACTIONS(127),
    [anon_sym_GT_EQ] = ACTIONS(129),
    [anon_sym_EQ_EQ] = ACTIONS(129),
    [anon_sym_BANG_EQ] = ACTIONS(129),
    [anon_sym_STAR] = ACTIONS(131),
    [anon_sym_SLASH] = ACTIONS(133),
    [anon_sym_STAR_STAR] = ACTIONS(135),
    [anon_sym_CARET] = ACTIONS(135),
    [aux_sym_binary_operator_token1] = ACTIONS(137),
    [anon_sym_PIPE_GT] = ACTIONS(137),
    [anon_sym_COLON] = ACTIONS(139),
    [anon_sym_DOLLAR] = ACTIONS(141),
    [anon_sym_AT] = ACTIONS(141),
    [aux_sym__hex_literal_token1] = ACTIONS(519),
    [sym__number_literal] = ACTIONS(521),
    [anon_sym_SQUOTE] = ACTIONS(519),
    [anon_sym_DQUOTE] = ACTIONS(519),
    [sym_return] = ACTIONS(521),
    [sym_next] = ACTIONS(521),
    [sym_break] = ACTIONS(521),
    [sym_true] = ACTIONS(521),
    [sym_false] = ACTIONS(521),
    [sym_null] = ACTIONS(521),
    [sym_inf] = ACTIONS(521),
    [sym_nan] = ACTIONS(521),
    [anon_sym_NA] = ACTIONS(521),
    [anon_sym_NA_integer_] = ACTIONS(521),
    [anon_sym_NA_real_] = ACTIONS(521),
    [anon_sym_NA_complex_] = ACTIONS(521),
    [anon_sym_NA_character_] = ACTIONS(521),
    [sym_dots] = ACTIONS(521),
    [sym_dot_dot_i] = ACTIONS(519),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(519),
    [sym__semicolon] = ACTIONS(519),
    [sym__raw_string_literal] = ACTIONS(519),
    [sym__external_else] = ACTIONS(519),
    [sym__external_open_parenthesis] = ACTIONS(145),
    [sym__external_open_brace] = ACTIONS(519),
    [sym__external_open_bracket] = ACTIONS(147),
    [sym__external_open_bracket2] = ACTIONS(149),
  },
  [86] = {
    [sym_call_arguments] = STATE(862),
    [sym_subset_arguments] = STATE(885),
    [sym_subset2_arguments] = STATE(900),
    [sym__open_parenthesis] = STATE(341),
    [sym__open_bracket] = STATE(342),
    [sym__open_bracket2] = STATE(343),
    [ts_builtin_sym_end] = ACTIONS(523),
    [sym_identifier] = ACTIONS(525),
    [anon_sym_BSLASH] = ACTIONS(523),
    [anon_sym_function] = ACTIONS(525),
    [anon_sym_EQ] = ACTIONS(105),
    [anon_sym_if] = ACTIONS(525),
    [anon_sym_for] = ACTIONS(525),
    [anon_sym_while] = ACTIONS(525),
    [anon_sym_repeat] = ACTIONS(525),
    [anon_sym_QMARK] = ACTIONS(523),
    [anon_sym_TILDE] = ACTIONS(107),
    [anon_sym_BANG] = ACTIONS(525),
    [anon_sym_PLUS] = ACTIONS(109),
    [anon_sym_DASH] = ACTIONS(111),
    [anon_sym_LT_DASH] = ACTIONS(113),
    [anon_sym_LT_LT_DASH] = ACTIONS(113),
    [anon_sym_COLON_EQ] = ACTIONS(113),
    [anon_sym_DASH_GT] = ACTIONS(115),
    [anon_sym_DASH_GT_GT] = ACTIONS(117),
    [anon_sym_PIPE] = ACTIONS(119),
    [anon_sym_AMP] = ACTIONS(121),
    [anon_sym_PIPE_PIPE] = ACTIONS(123),
    [anon_sym_AMP_AMP] = ACTIONS(125),
    [anon_sym_LT] = ACTIONS(127),
    [anon_sym_LT_EQ] = ACTIONS(129),
    [anon_sym_GT] = ACTIONS(127),
    [anon_sym_GT_EQ] = ACTIONS(129),
    [anon_sym_EQ_EQ] = ACTIONS(129),
    [anon_sym_BANG_EQ] = ACTIONS(129),
    [anon_sym_STAR] = ACTIONS(131),
    [anon_sym_SLASH] = ACTIONS(133),
    [anon_sym_STAR_STAR] = ACTIONS(135),
    [anon_sym_CARET] = ACTIONS(135),
    [aux_sym_binary_operator_token1] = ACTIONS(137),
    [anon_sym_PIPE_GT] = ACTIONS(137),
    [anon_sym_COLON] = ACTIONS(139),
    [anon_sym_DOLLAR] = ACTIONS(141),
    [anon_sym_AT] = ACTIONS(141),
    [aux_sym__hex_literal_token1] = ACTIONS(523),
    [sym__number_literal] = ACTIONS(525),
    [anon_sym_SQUOTE] = ACTIONS(523),
    [anon_sym_DQUOTE] = ACTIONS(523),
    [sym_return] = ACTIONS(525),
    [sym_next] = ACTIONS(525),
    [sym_break] = ACTIONS(525),
    [sym_true] = ACTIONS(525),
    [sym_false] = ACTIONS(525),
    [sym_null] = ACTIONS(525),
    [sym_inf] = ACTIONS(525),
    [sym_nan] = ACTIONS(525),
    [anon_sym_NA] = ACTIONS(525),
    [anon_sym_NA_integer_] = ACTIONS(525),
    [anon_sym_NA_real_] = ACTIONS(525),
    [anon_sym_NA_complex_] = ACTIONS(525),
    [anon_sym_NA_character_] = ACTIONS(525),
    [sym_dots] = ACTIONS(525),
    [sym_dot_dot_i] = ACTIONS(523),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(523),
    [sym__semicolon] = ACTIONS(523),
    [sym__raw_string_literal] = ACTIONS(523),
    [sym__external_else] = ACTIONS(523),
    [sym__external_open_parenthesis] = ACTIONS(145),
    [sym__external_open_brace] = ACTIONS(523),
    [sym__external_open_bracket] = ACTIONS(147),
    [sym__external_open_bracket2] = ACTIONS(149),
  },
  [87] = {
    [sym_call_arguments] = STATE(862),
    [sym_subset_arguments] = STATE(885),
    [sym_subset2_arguments] = STATE(900),
    [sym__open_parenthesis] = STATE(341),
    [sym__open_bracket] = STATE(342),
    [sym__open_bracket2] = STATE(343),
    [ts_builtin_sym_end] = ACTIONS(527),
    [sym_identifier] = ACTIONS(529),
    [anon_sym_BSLASH] = ACTIONS(527),
    [anon_sym_function] = ACTIONS(529),
    [anon_sym_EQ] = ACTIONS(105),
    [anon_sym_if] = ACTIONS(529),
    [anon_sym_for] = ACTIONS(529),
    [anon_sym_while] = ACTIONS(529),
    [anon_sym_repeat] = ACTIONS(529),
    [anon_sym_QMARK] = ACTIONS(527),
    [anon_sym_TILDE] = ACTIONS(107),
    [anon_sym_BANG] = ACTIONS(529),
    [anon_sym_PLUS] = ACTIONS(109),
    [anon_sym_DASH] = ACTIONS(111),
    [anon_sym_LT_DASH] = ACTIONS(113),
    [anon_sym_LT_LT_DASH] = ACTIONS(113),
    [anon_sym_COLON_EQ] = ACTIONS(113),
    [anon_sym_DASH_GT] = ACTIONS(115),
    [anon_sym_DASH_GT_GT] = ACTIONS(117),
    [anon_sym_PIPE] = ACTIONS(119),
    [anon_sym_AMP] = ACTIONS(121),
    [anon_sym_PIPE_PIPE] = ACTIONS(123),
    [anon_sym_AMP_AMP] = ACTIONS(125),
    [anon_sym_LT] = ACTIONS(127),
    [anon_sym_LT_EQ] = ACTIONS(129),
    [anon_sym_GT] = ACTIONS(127),
    [anon_sym_GT_EQ] = ACTIONS(129),
    [anon_sym_EQ_EQ] = ACTIONS(129),
    [anon_sym_BANG_EQ] = ACTIONS(129),
    [anon_sym_STAR] = ACTIONS(131),
    [anon_sym_SLASH] = ACTIONS(133),
    [anon_sym_STAR_STAR] = ACTIONS(135),
    [anon_sym_CARET] = ACTIONS(135),
    [aux_sym_binary_operator_token1] = ACTIONS(137),
    [anon_sym_PIPE_GT] = ACTIONS(137),
    [anon_sym_COLON] = ACTIONS(139),
    [anon_sym_DOLLAR] = ACTIONS(141),
    [anon_sym_AT] = ACTIONS(141),
    [aux_sym__hex_literal_token1] = ACTIONS(527),
    [sym__number_literal] = ACTIONS(529),
    [anon_sym_SQUOTE] = ACTIONS(527),
    [anon_sym_DQUOTE] = ACTIONS(527),
    [sym_return] = ACTIONS(529),
    [sym_next] = ACTIONS(529),
    [sym_break] = ACTIONS(529),
    [sym_true] = ACTIONS(529),
    [sym_false] = ACTIONS(529),
    [sym_null] = ACTIONS(529),
    [sym_inf] = ACTIONS(529),
    [sym_nan] = ACTIONS(529),
    [anon_sym_NA] = ACTIONS(529),
    [anon_sym_NA_integer_] = ACTIONS(529),
    [anon_sym_NA_real_] = ACTIONS(529),
    [anon_sym_NA_complex_] = ACTIONS(529),
    [anon_sym_NA_character_] = ACTIONS(529),
    [sym_dots] = ACTIONS(529),
    [sym_dot_dot_i] = ACTIONS(527),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(527),
    [sym__semicolon] = ACTIONS(527),
    [sym__raw_string_literal] = ACTIONS(527),
    [sym__external_else] = ACTIONS(527),
    [sym__external_open_parenthesis] = ACTIONS(145),
    [sym__external_open_brace] = ACTIONS(527),
    [sym__external_open_bracket] = ACTIONS(147),
    [sym__external_open_bracket2] = ACTIONS(149),
  },
  [88] = {
    [sym_call_arguments] = STATE(862),
    [sym_subset_arguments] = STATE(885),
    [sym_subset2_arguments] = STATE(900),
    [sym__open_parenthesis] = STATE(341),
    [sym__open_bracket] = STATE(342),
    [sym__open_bracket2] = STATE(343),
    [ts_builtin_sym_end] = ACTIONS(531),
    [sym_identifier] = ACTIONS(533),
    [anon_sym_BSLASH] = ACTIONS(531),
    [anon_sym_function] = ACTIONS(533),
    [anon_sym_EQ] = ACTIONS(105),
    [anon_sym_if] = ACTIONS(533),
    [anon_sym_for] = ACTIONS(533),
    [anon_sym_while] = ACTIONS(533),
    [anon_sym_repeat] = ACTIONS(533),
    [anon_sym_QMARK] = ACTIONS(531),
    [anon_sym_TILDE] = ACTIONS(107),
    [anon_sym_BANG] = ACTIONS(533),
    [anon_sym_PLUS] = ACTIONS(109),
    [anon_sym_DASH] = ACTIONS(111),
    [anon_sym_LT_DASH] = ACTIONS(113),
    [anon_sym_LT_LT_DASH] = ACTIONS(113),
    [anon_sym_COLON_EQ] = ACTIONS(113),
    [anon_sym_DASH_GT] = ACTIONS(115),
    [anon_sym_DASH_GT_GT] = ACTIONS(117),
    [anon_sym_PIPE] = ACTIONS(119),
    [anon_sym_AMP] = ACTIONS(121),
    [anon_sym_PIPE_PIPE] = ACTIONS(123),
    [anon_sym_AMP_AMP] = ACTIONS(125),
    [anon_sym_LT] = ACTIONS(127),
    [anon_sym_LT_EQ] = ACTIONS(129),
    [anon_sym_GT] = ACTIONS(127),
    [anon_sym_GT_EQ] = ACTIONS(129),
    [anon_sym_EQ_EQ] = ACTIONS(129),
    [anon_sym_BANG_EQ] = ACTIONS(129),
    [anon_sym_STAR] = ACTIONS(131),
    [anon_sym_SLASH] = ACTIONS(133),
    [anon_sym_STAR_STAR] = ACTIONS(135),
    [anon_sym_CARET] = ACTIONS(135),
    [aux_sym_binary_operator_token1] = ACTIONS(137),
    [anon_sym_PIPE_GT] = ACTIONS(137),
    [anon_sym_COLON] = ACTIONS(139),
    [anon_sym_DOLLAR] = ACTIONS(141),
    [anon_sym_AT] = ACTIONS(141),
    [aux_sym__hex_literal_token1] = ACTIONS(531),
    [sym__number_literal] = ACTIONS(533),
    [anon_sym_SQUOTE] = ACTIONS(531),
    [anon_sym_DQUOTE] = ACTIONS(531),
    [sym_return] = ACTIONS(533),
    [sym_next] = ACTIONS(533),
    [sym_break] = ACTIONS(533),
    [sym_true] = ACTIONS(533),
    [sym_false] = ACTIONS(533),
    [sym_null] = ACTIONS(533),
    [sym_inf] = ACTIONS(533),
    [sym_nan] = ACTIONS(533),
    [anon_sym_NA] = ACTIONS(533),
    [anon_sym_NA_integer_] = ACTIONS(533),
    [anon_sym_NA_real_] = ACTIONS(533),
    [anon_sym_NA_complex_] = ACTIONS(533),
    [anon_sym_NA_character_] = ACTIONS(533),
    [sym_dots] = ACTIONS(533),
    [sym_dot_dot_i] = ACTIONS(531),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(531),
    [sym__semicolon] = ACTIONS(531),
    [sym__raw_string_literal] = ACTIONS(531),
    [sym__external_else] = ACTIONS(531),
    [sym__external_open_parenthesis] = ACTIONS(145),
    [sym__external_open_brace] = ACTIONS(531),
    [sym__external_open_bracket] = ACTIONS(147),
    [sym__external_open_bracket2] = ACTIONS(149),
  },
  [89] = {
    [sym_call_arguments] = STATE(862),
    [sym_subset_arguments] = STATE(885),
    [sym_subset2_arguments] = STATE(900),
    [sym__open_parenthesis] = STATE(341),
    [sym__open_bracket] = STATE(342),
    [sym__open_bracket2] = STATE(343),
    [ts_builtin_sym_end] = ACTIONS(535),
    [sym_identifier] = ACTIONS(537),
    [anon_sym_BSLASH] = ACTIONS(535),
    [anon_sym_function] = ACTIONS(537),
    [anon_sym_EQ] = ACTIONS(105),
    [anon_sym_if] = ACTIONS(537),
    [anon_sym_for] = ACTIONS(537),
    [anon_sym_while] = ACTIONS(537),
    [anon_sym_repeat] = ACTIONS(537),
    [anon_sym_QMARK] = ACTIONS(535),
    [anon_sym_TILDE] = ACTIONS(107),
    [anon_sym_BANG] = ACTIONS(537),
    [anon_sym_PLUS] = ACTIONS(109),
    [anon_sym_DASH] = ACTIONS(111),
    [anon_sym_LT_DASH] = ACTIONS(113),
    [anon_sym_LT_LT_DASH] = ACTIONS(113),
    [anon_sym_COLON_EQ] = ACTIONS(113),
    [anon_sym_DASH_GT] = ACTIONS(115),
    [anon_sym_DASH_GT_GT] = ACTIONS(117),
    [anon_sym_PIPE] = ACTIONS(119),
    [anon_sym_AMP] = ACTIONS(121),
    [anon_sym_PIPE_PIPE] = ACTIONS(123),
    [anon_sym_AMP_AMP] = ACTIONS(125),
    [anon_sym_LT] = ACTIONS(127),
    [anon_sym_LT_EQ] = ACTIONS(129),
    [anon_sym_GT] = ACTIONS(127),
    [anon_sym_GT_EQ] = ACTIONS(129),
    [anon_sym_EQ_EQ] = ACTIONS(129),
    [anon_sym_BANG_EQ] = ACTIONS(129),
    [anon_sym_STAR] = ACTIONS(131),
    [anon_sym_SLASH] = ACTIONS(133),
    [anon_sym_STAR_STAR] = ACTIONS(135),
    [anon_sym_CARET] = ACTIONS(135),
    [aux_sym_binary_operator_token1] = ACTIONS(137),
    [anon_sym_PIPE_GT] = ACTIONS(137),
    [anon_sym_COLON] = ACTIONS(139),
    [anon_sym_DOLLAR] = ACTIONS(141),
    [anon_sym_AT] = ACTIONS(141),
    [aux_sym__hex_literal_token1] = ACTIONS(535),
    [sym__number_literal] = ACTIONS(537),
    [anon_sym_SQUOTE] = ACTIONS(535),
    [anon_sym_DQUOTE] = ACTIONS(535),
    [sym_return] = ACTIONS(537),
    [sym_next] = ACTIONS(537),
    [sym_break] = ACTIONS(537),
    [sym_true] = ACTIONS(537),
    [sym_false] = ACTIONS(537),
    [sym_null] = ACTIONS(537),
    [sym_inf] = ACTIONS(537),
    [sym_nan] = ACTIONS(537),
    [anon_sym_NA] = ACTIONS(537),
    [anon_sym_NA_integer_] = ACTIONS(537),
    [anon_sym_NA_real_] = ACTIONS(537),
    [anon_sym_NA_complex_] = ACTIONS(537),
    [anon_sym_NA_character_] = ACTIONS(537),
    [sym_dots] = ACTIONS(537),
    [sym_dot_dot_i] = ACTIONS(535),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(535),
    [sym__semicolon] = ACTIONS(535),
    [sym__raw_string_literal] = ACTIONS(535),
    [sym__external_else] = ACTIONS(535),
    [sym__external_open_parenthesis] = ACTIONS(145),
    [sym__external_open_brace] = ACTIONS(535),
    [sym__external_open_bracket] = ACTIONS(147),
    [sym__external_open_bracket2] = ACTIONS(149),
  },
  [90] = {
    [sym_call_arguments] = STATE(862),
    [sym_subset_arguments] = STATE(885),
    [sym_subset2_arguments] = STATE(900),
    [sym__open_parenthesis] = STATE(341),
    [sym__open_bracket] = STATE(342),
    [sym__open_bracket2] = STATE(343),
    [ts_builtin_sym_end] = ACTIONS(539),
    [sym_identifier] = ACTIONS(541),
    [anon_sym_BSLASH] = ACTIONS(539),
    [anon_sym_function] = ACTIONS(541),
    [anon_sym_EQ] = ACTIONS(105),
    [anon_sym_if] = ACTIONS(541),
    [anon_sym_for] = ACTIONS(541),
    [anon_sym_while] = ACTIONS(541),
    [anon_sym_repeat] = ACTIONS(541),
    [anon_sym_QMARK] = ACTIONS(539),
    [anon_sym_TILDE] = ACTIONS(107),
    [anon_sym_BANG] = ACTIONS(541),
    [anon_sym_PLUS] = ACTIONS(109),
    [anon_sym_DASH] = ACTIONS(111),
    [anon_sym_LT_DASH] = ACTIONS(113),
    [anon_sym_LT_LT_DASH] = ACTIONS(113),
    [anon_sym_COLON_EQ] = ACTIONS(113),
    [anon_sym_DASH_GT] = ACTIONS(115),
    [anon_sym_DASH_GT_GT] = ACTIONS(117),
    [anon_sym_PIPE] = ACTIONS(119),
    [anon_sym_AMP] = ACTIONS(121),
    [anon_sym_PIPE_PIPE] = ACTIONS(123),
    [anon_sym_AMP_AMP] = ACTIONS(125),
    [anon_sym_LT] = ACTIONS(127),
    [anon_sym_LT_EQ] = ACTIONS(129),
    [anon_sym_GT] = ACTIONS(127),
    [anon_sym_GT_EQ] = ACTIONS(129),
    [anon_sym_EQ_EQ] = ACTIONS(129),
    [anon_sym_BANG_EQ] = ACTIONS(129),
    [anon_sym_STAR] = ACTIONS(131),
    [anon_sym_SLASH] = ACTIONS(133),
    [anon_sym_STAR_STAR] = ACTIONS(135),
    [anon_sym_CARET] = ACTIONS(135),
    [aux_sym_binary_operator_token1] = ACTIONS(137),
    [anon_sym_PIPE_GT] = ACTIONS(137),
    [anon_sym_COLON] = ACTIONS(139),
    [anon_sym_DOLLAR] = ACTIONS(141),
    [anon_sym_AT] = ACTIONS(141),
    [aux_sym__hex_literal_token1] = ACTIONS(539),
    [sym__number_literal] = ACTIONS(541),
    [anon_sym_SQUOTE] = ACTIONS(539),
    [anon_sym_DQUOTE] = ACTIONS(539),
    [sym_return] = ACTIONS(541),
    [sym_next] = ACTIONS(541),
    [sym_break] = ACTIONS(541),
    [sym_true] = ACTIONS(541),
    [sym_false] = ACTIONS(541),
    [sym_null] = ACTIONS(541),
    [sym_inf] = ACTIONS(541),
    [sym_nan] = ACTIONS(541),
    [anon_sym_NA] = ACTIONS(541),
    [anon_sym_NA_integer_] = ACTIONS(541),
    [anon_sym_NA_real_] = ACTIONS(541),
    [anon_sym_NA_complex_] = ACTIONS(541),
    [anon_sym_NA_character_] = ACTIONS(541),
    [sym_dots] = ACTIONS(541),
    [sym_dot_dot_i] = ACTIONS(539),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(539),
    [sym__semicolon] = ACTIONS(539),
    [sym__raw_string_literal] = ACTIONS(539),
    [sym__external_else] = ACTIONS(539),
    [sym__external_open_parenthesis] = ACTIONS(145),
    [sym__external_open_brace] = ACTIONS(539),
    [sym__external_open_bracket] = ACTIONS(147),
    [sym__external_open_bracket2] = ACTIONS(149),
  },
  [91] = {
    [sym_call_arguments] = STATE(888),
    [sym_subset_arguments] = STATE(892),
    [sym_subset2_arguments] = STATE(895),
    [sym__open_parenthesis] = STATE(345),
    [sym__open_bracket] = STATE(346),
    [sym__open_bracket2] = STATE(347),
    [sym_identifier] = ACTIONS(543),
    [anon_sym_BSLASH] = ACTIONS(545),
    [anon_sym_function] = ACTIONS(543),
    [anon_sym_EQ] = ACTIONS(157),
    [anon_sym_if] = ACTIONS(543),
    [anon_sym_for] = ACTIONS(543),
    [anon_sym_while] = ACTIONS(543),
    [anon_sym_repeat] = ACTIONS(543),
    [anon_sym_QMARK] = ACTIONS(545),
    [anon_sym_TILDE] = ACTIONS(159),
    [anon_sym_BANG] = ACTIONS(543),
    [anon_sym_PLUS] = ACTIONS(161),
    [anon_sym_DASH] = ACTIONS(163),
    [anon_sym_LT_DASH] = ACTIONS(165),
    [anon_sym_LT_LT_DASH] = ACTIONS(165),
    [anon_sym_COLON_EQ] = ACTIONS(165),
    [anon_sym_DASH_GT] = ACTIONS(167),
    [anon_sym_DASH_GT_GT] = ACTIONS(169),
    [anon_sym_PIPE] = ACTIONS(171),
    [anon_sym_AMP] = ACTIONS(173),
    [anon_sym_PIPE_PIPE] = ACTIONS(175),
    [anon_sym_AMP_AMP] = ACTIONS(177),
    [anon_sym_LT] = ACTIONS(179),
    [anon_sym_LT_EQ] = ACTIONS(181),
    [anon_sym_GT] = ACTIONS(179),
    [anon_sym_GT_EQ] = ACTIONS(181),
    [anon_sym_EQ_EQ] = ACTIONS(181),
    [anon_sym_BANG_EQ] = ACTIONS(181),
    [anon_sym_STAR] = ACTIONS(183),
    [anon_sym_SLASH] = ACTIONS(185),
    [anon_sym_STAR_STAR] = ACTIONS(187),
    [anon_sym_CARET] = ACTIONS(187),
    [aux_sym_binary_operator_token1] = ACTIONS(189),
    [anon_sym_PIPE_GT] = ACTIONS(189),
    [anon_sym_COLON] = ACTIONS(191),
    [anon_sym_DOLLAR] = ACTIONS(193),
    [anon_sym_AT] = ACTIONS(193),
    [aux_sym__hex_literal_token1] = ACTIONS(545),
    [sym__number_literal] = ACTIONS(543),
    [anon_sym_SQUOTE] = ACTIONS(545),
    [anon_sym_DQUOTE] = ACTIONS(545),
    [sym_return] = ACTIONS(543),
    [sym_next] = ACTIONS(543),
    [sym_break] = ACTIONS(543),
    [sym_true] = ACTIONS(543),
    [sym_false] = ACTIONS(543),
    [sym_null] = ACTIONS(543),
    [sym_inf] = ACTIONS(543),
    [sym_nan] = ACTIONS(543),
    [anon_sym_NA] = ACTIONS(543),
    [anon_sym_NA_integer_] = ACTIONS(543),
    [anon_sym_NA_real_] = ACTIONS(543),
    [anon_sym_NA_complex_] = ACTIONS(543),
    [anon_sym_NA_character_] = ACTIONS(543),
    [sym_dots] = ACTIONS(543),
    [sym_dot_dot_i] = ACTIONS(545),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(545),
    [sym__newline] = ACTIONS(545),
    [sym__raw_string_literal] = ACTIONS(545),
    [sym__external_else] = ACTIONS(545),
    [sym__external_open_parenthesis] = ACTIONS(197),
    [sym__external_close_parenthesis] = ACTIONS(545),
    [sym__external_open_brace] = ACTIONS(545),
    [sym__external_open_bracket] = ACTIONS(199),
    [sym__external_open_bracket2] = ACTIONS(201),
  },
  [92] = {
    [sym_call_arguments] = STATE(888),
    [sym_subset_arguments] = STATE(892),
    [sym_subset2_arguments] = STATE(895),
    [sym__open_parenthesis] = STATE(345),
    [sym__open_bracket] = STATE(346),
    [sym__open_bracket2] = STATE(347),
    [sym_identifier] = ACTIONS(367),
    [anon_sym_BSLASH] = ACTIONS(369),
    [anon_sym_function] = ACTIONS(367),
    [anon_sym_EQ] = ACTIONS(157),
    [anon_sym_if] = ACTIONS(367),
    [anon_sym_for] = ACTIONS(367),
    [anon_sym_while] = ACTIONS(367),
    [anon_sym_repeat] = ACTIONS(367),
    [anon_sym_QMARK] = ACTIONS(369),
    [anon_sym_TILDE] = ACTIONS(159),
    [anon_sym_BANG] = ACTIONS(367),
    [anon_sym_PLUS] = ACTIONS(161),
    [anon_sym_DASH] = ACTIONS(163),
    [anon_sym_LT_DASH] = ACTIONS(165),
    [anon_sym_LT_LT_DASH] = ACTIONS(165),
    [anon_sym_COLON_EQ] = ACTIONS(165),
    [anon_sym_DASH_GT] = ACTIONS(167),
    [anon_sym_DASH_GT_GT] = ACTIONS(169),
    [anon_sym_PIPE] = ACTIONS(171),
    [anon_sym_AMP] = ACTIONS(173),
    [anon_sym_PIPE_PIPE] = ACTIONS(175),
    [anon_sym_AMP_AMP] = ACTIONS(177),
    [anon_sym_LT] = ACTIONS(179),
    [anon_sym_LT_EQ] = ACTIONS(181),
    [anon_sym_GT] = ACTIONS(179),
    [anon_sym_GT_EQ] = ACTIONS(181),
    [anon_sym_EQ_EQ] = ACTIONS(181),
    [anon_sym_BANG_EQ] = ACTIONS(181),
    [anon_sym_STAR] = ACTIONS(183),
    [anon_sym_SLASH] = ACTIONS(185),
    [anon_sym_STAR_STAR] = ACTIONS(187),
    [anon_sym_CARET] = ACTIONS(187),
    [aux_sym_binary_operator_token1] = ACTIONS(189),
    [anon_sym_PIPE_GT] = ACTIONS(189),
    [anon_sym_COLON] = ACTIONS(191),
    [anon_sym_DOLLAR] = ACTIONS(193),
    [anon_sym_AT] = ACTIONS(193),
    [aux_sym__hex_literal_token1] = ACTIONS(369),
    [sym__number_literal] = ACTIONS(367),
    [anon_sym_SQUOTE] = ACTIONS(369),
    [anon_sym_DQUOTE] = ACTIONS(369),
    [sym_return] = ACTIONS(367),
    [sym_next] = ACTIONS(367),
    [sym_break] = ACTIONS(367),
    [sym_true] = ACTIONS(367),
    [sym_false] = ACTIONS(367),
    [sym_null] = ACTIONS(367),
    [sym_inf] = ACTIONS(367),
    [sym_nan] = ACTIONS(367),
    [anon_sym_NA] = ACTIONS(367),
    [anon_sym_NA_integer_] = ACTIONS(367),
    [anon_sym_NA_real_] = ACTIONS(367),
    [anon_sym_NA_complex_] = ACTIONS(367),
    [anon_sym_NA_character_] = ACTIONS(367),
    [sym_dots] = ACTIONS(367),
    [sym_dot_dot_i] = ACTIONS(369),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(369),
    [sym__newline] = ACTIONS(369),
    [sym__raw_string_literal] = ACTIONS(369),
    [sym__external_else] = ACTIONS(369),
    [sym__external_open_parenthesis] = ACTIONS(197),
    [sym__external_close_parenthesis] = ACTIONS(369),
    [sym__external_open_brace] = ACTIONS(369),
    [sym__external_open_bracket] = ACTIONS(199),
    [sym__external_open_bracket2] = ACTIONS(201),
  },
  [93] = {
    [sym_call_arguments] = STATE(888),
    [sym_subset_arguments] = STATE(892),
    [sym_subset2_arguments] = STATE(895),
    [sym__open_parenthesis] = STATE(345),
    [sym__open_bracket] = STATE(346),
    [sym__open_bracket2] = STATE(347),
    [sym_identifier] = ACTIONS(367),
    [anon_sym_BSLASH] = ACTIONS(369),
    [anon_sym_function] = ACTIONS(367),
    [anon_sym_EQ] = ACTIONS(367),
    [anon_sym_if] = ACTIONS(367),
    [anon_sym_for] = ACTIONS(367),
    [anon_sym_while] = ACTIONS(367),
    [anon_sym_repeat] = ACTIONS(367),
    [anon_sym_QMARK] = ACTIONS(369),
    [anon_sym_TILDE] = ACTIONS(369),
    [anon_sym_BANG] = ACTIONS(367),
    [anon_sym_PLUS] = ACTIONS(161),
    [anon_sym_DASH] = ACTIONS(163),
    [anon_sym_LT_DASH] = ACTIONS(369),
    [anon_sym_LT_LT_DASH] = ACTIONS(369),
    [anon_sym_COLON_EQ] = ACTIONS(369),
    [anon_sym_DASH_GT] = ACTIONS(367),
    [anon_sym_DASH_GT_GT] = ACTIONS(369),
    [anon_sym_PIPE] = ACTIONS(171),
    [anon_sym_AMP] = ACTIONS(173),
    [anon_sym_PIPE_PIPE] = ACTIONS(175),
    [anon_sym_AMP_AMP] = ACTIONS(177),
    [anon_sym_LT] = ACTIONS(179),
    [anon_sym_LT_EQ] = ACTIONS(181),
    [anon_sym_GT] = ACTIONS(179),
    [anon_sym_GT_EQ] = ACTIONS(181),
    [anon_sym_EQ_EQ] = ACTIONS(181),
    [anon_sym_BANG_EQ] = ACTIONS(181),
    [anon_sym_STAR] = ACTIONS(183),
    [anon_sym_SLASH] = ACTIONS(185),
    [anon_sym_STAR_STAR] = ACTIONS(187),
    [anon_sym_CARET] = ACTIONS(187),
    [aux_sym_binary_operator_token1] = ACTIONS(189),
    [anon_sym_PIPE_GT] = ACTIONS(189),
    [anon_sym_COLON] = ACTIONS(191),
    [anon_sym_DOLLAR] = ACTIONS(193),
    [anon_sym_AT] = ACTIONS(193),
    [aux_sym__hex_literal_token1] = ACTIONS(369),
    [sym__number_literal] = ACTIONS(367),
    [anon_sym_SQUOTE] = ACTIONS(369),
    [anon_sym_DQUOTE] = ACTIONS(369),
    [sym_return] = ACTIONS(367),
    [sym_next] = ACTIONS(367),
    [sym_break] = ACTIONS(367),
    [sym_true] = ACTIONS(367),
    [sym_false] = ACTIONS(367),
    [sym_null] = ACTIONS(367),
    [sym_inf] = ACTIONS(367),
    [sym_nan] = ACTIONS(367),
    [anon_sym_NA] = ACTIONS(367),
    [anon_sym_NA_integer_] = ACTIONS(367),
    [anon_sym_NA_real_] = ACTIONS(367),
    [anon_sym_NA_complex_] = ACTIONS(367),
    [anon_sym_NA_character_] = ACTIONS(367),
    [sym_dots] = ACTIONS(367),
    [sym_dot_dot_i] = ACTIONS(369),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(369),
    [sym__newline] = ACTIONS(369),
    [sym__raw_string_literal] = ACTIONS(369),
    [sym__external_else] = ACTIONS(369),
    [sym__external_open_parenthesis] = ACTIONS(197),
    [sym__external_close_parenthesis] = ACTIONS(369),
    [sym__external_open_brace] = ACTIONS(369),
    [sym__external_open_bracket] = ACTIONS(199),
    [sym__external_open_bracket2] = ACTIONS(201),
  },
  [94] = {
    [sym_call_arguments] = STATE(888),
    [sym_subset_arguments] = STATE(892),
    [sym_subset2_arguments] = STATE(895),
    [sym__open_parenthesis] = STATE(345),
    [sym__open_bracket] = STATE(346),
    [sym__open_bracket2] = STATE(347),
    [sym_identifier] = ACTIONS(367),
    [anon_sym_BSLASH] = ACTIONS(369),
    [anon_sym_function] = ACTIONS(367),
    [anon_sym_EQ] = ACTIONS(367),
    [anon_sym_if] = ACTIONS(367),
    [anon_sym_for] = ACTIONS(367),
    [anon_sym_while] = ACTIONS(367),
    [anon_sym_repeat] = ACTIONS(367),
    [anon_sym_QMARK] = ACTIONS(369),
    [anon_sym_TILDE] = ACTIONS(369),
    [anon_sym_BANG] = ACTIONS(367),
    [anon_sym_PLUS] = ACTIONS(161),
    [anon_sym_DASH] = ACTIONS(163),
    [anon_sym_LT_DASH] = ACTIONS(369),
    [anon_sym_LT_LT_DASH] = ACTIONS(369),
    [anon_sym_COLON_EQ] = ACTIONS(369),
    [anon_sym_DASH_GT] = ACTIONS(367),
    [anon_sym_DASH_GT_GT] = ACTIONS(369),
    [anon_sym_PIPE] = ACTIONS(367),
    [anon_sym_AMP] = ACTIONS(367),
    [anon_sym_PIPE_PIPE] = ACTIONS(369),
    [anon_sym_AMP_AMP] = ACTIONS(369),
    [anon_sym_LT] = ACTIONS(179),
    [anon_sym_LT_EQ] = ACTIONS(181),
    [anon_sym_GT] = ACTIONS(179),
    [anon_sym_GT_EQ] = ACTIONS(181),
    [anon_sym_EQ_EQ] = ACTIONS(181),
    [anon_sym_BANG_EQ] = ACTIONS(181),
    [anon_sym_STAR] = ACTIONS(183),
    [anon_sym_SLASH] = ACTIONS(185),
    [anon_sym_STAR_STAR] = ACTIONS(187),
    [anon_sym_CARET] = ACTIONS(187),
    [aux_sym_binary_operator_token1] = ACTIONS(189),
    [anon_sym_PIPE_GT] = ACTIONS(189),
    [anon_sym_COLON] = ACTIONS(191),
    [anon_sym_DOLLAR] = ACTIONS(193),
    [anon_sym_AT] = ACTIONS(193),
    [aux_sym__hex_literal_token1] = ACTIONS(369),
    [sym__number_literal] = ACTIONS(367),
    [anon_sym_SQUOTE] = ACTIONS(369),
    [anon_sym_DQUOTE] = ACTIONS(369),
    [sym_return] = ACTIONS(367),
    [sym_next] = ACTIONS(367),
    [sym_break] = ACTIONS(367),
    [sym_true] = ACTIONS(367),
    [sym_false] = ACTIONS(367),
    [sym_null] = ACTIONS(367),
    [sym_inf] = ACTIONS(367),
    [sym_nan] = ACTIONS(367),
    [anon_sym_NA] = ACTIONS(367),
    [anon_sym_NA_integer_] = ACTIONS(367),
    [anon_sym_NA_real_] = ACTIONS(367),
    [anon_sym_NA_complex_] = ACTIONS(367),
    [anon_sym_NA_character_] = ACTIONS(367),
    [sym_dots] = ACTIONS(367),
    [sym_dot_dot_i] = ACTIONS(369),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(369),
    [sym__newline] = ACTIONS(369),
    [sym__raw_string_literal] = ACTIONS(369),
    [sym__external_else] = ACTIONS(369),
    [sym__external_open_parenthesis] = ACTIONS(197),
    [sym__external_close_parenthesis] = ACTIONS(369),
    [sym__external_open_brace] = ACTIONS(369),
    [sym__external_open_bracket] = ACTIONS(199),
    [sym__external_open_bracket2] = ACTIONS(201),
  },
  [95] = {
    [sym_call_arguments] = STATE(888),
    [sym_subset_arguments] = STATE(892),
    [sym_subset2_arguments] = STATE(895),
    [sym__open_parenthesis] = STATE(345),
    [sym__open_bracket] = STATE(346),
    [sym__open_bracket2] = STATE(347),
    [sym_identifier] = ACTIONS(367),
    [anon_sym_BSLASH] = ACTIONS(369),
    [anon_sym_function] = ACTIONS(367),
    [anon_sym_EQ] = ACTIONS(367),
    [anon_sym_if] = ACTIONS(367),
    [anon_sym_for] = ACTIONS(367),
    [anon_sym_while] = ACTIONS(367),
    [anon_sym_repeat] = ACTIONS(367),
    [anon_sym_QMARK] = ACTIONS(369),
    [anon_sym_TILDE] = ACTIONS(369),
    [anon_sym_BANG] = ACTIONS(367),
    [anon_sym_PLUS] = ACTIONS(369),
    [anon_sym_DASH] = ACTIONS(367),
    [anon_sym_LT_DASH] = ACTIONS(369),
    [anon_sym_LT_LT_DASH] = ACTIONS(369),
    [anon_sym_COLON_EQ] = ACTIONS(369),
    [anon_sym_DASH_GT] = ACTIONS(367),
    [anon_sym_DASH_GT_GT] = ACTIONS(369),
    [anon_sym_PIPE] = ACTIONS(367),
    [anon_sym_AMP] = ACTIONS(367),
    [anon_sym_PIPE_PIPE] = ACTIONS(369),
    [anon_sym_AMP_AMP] = ACTIONS(369),
    [anon_sym_LT] = ACTIONS(367),
    [anon_sym_LT_EQ] = ACTIONS(369),
    [anon_sym_GT] = ACTIONS(367),
    [anon_sym_GT_EQ] = ACTIONS(369),
    [anon_sym_EQ_EQ] = ACTIONS(369),
    [anon_sym_BANG_EQ] = ACTIONS(369),
    [anon_sym_STAR] = ACTIONS(367),
    [anon_sym_SLASH] = ACTIONS(369),
    [anon_sym_STAR_STAR] = ACTIONS(187),
    [anon_sym_CARET] = ACTIONS(187),
    [aux_sym_binary_operator_token1] = ACTIONS(369),
    [anon_sym_PIPE_GT] = ACTIONS(369),
    [anon_sym_COLON] = ACTIONS(367),
    [anon_sym_DOLLAR] = ACTIONS(193),
    [anon_sym_AT] = ACTIONS(193),
    [aux_sym__hex_literal_token1] = ACTIONS(369),
    [sym__number_literal] = ACTIONS(367),
    [anon_sym_SQUOTE] = ACTIONS(369),
    [anon_sym_DQUOTE] = ACTIONS(369),
    [sym_return] = ACTIONS(367),
    [sym_next] = ACTIONS(367),
    [sym_break] = ACTIONS(367),
    [sym_true] = ACTIONS(367),
    [sym_false] = ACTIONS(367),
    [sym_null] = ACTIONS(367),
    [sym_inf] = ACTIONS(367),
    [sym_nan] = ACTIONS(367),
    [anon_sym_NA] = ACTIONS(367),
    [anon_sym_NA_integer_] = ACTIONS(367),
    [anon_sym_NA_real_] = ACTIONS(367),
    [anon_sym_NA_complex_] = ACTIONS(367),
    [anon_sym_NA_character_] = ACTIONS(367),
    [sym_dots] = ACTIONS(367),
    [sym_dot_dot_i] = ACTIONS(369),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(369),
    [sym__newline] = ACTIONS(369),
    [sym__raw_string_literal] = ACTIONS(369),
    [sym__external_else] = ACTIONS(369),
    [sym__external_open_parenthesis] = ACTIONS(197),
    [sym__external_close_parenthesis] = ACTIONS(369),
    [sym__external_open_brace] = ACTIONS(369),
    [sym__external_open_bracket] = ACTIONS(199),
    [sym__external_open_bracket2] = ACTIONS(201),
  },
  [96] = {
    [sym_call_arguments] = STATE(888),
    [sym_subset_arguments] = STATE(892),
    [sym_subset2_arguments] = STATE(895),
    [sym__open_parenthesis] = STATE(345),
    [sym__open_bracket] = STATE(346),
    [sym__open_bracket2] = STATE(347),
    [sym_identifier] = ACTIONS(373),
    [anon_sym_BSLASH] = ACTIONS(371),
    [anon_sym_function] = ACTIONS(373),
    [anon_sym_EQ] = ACTIONS(157),
    [anon_sym_if] = ACTIONS(373),
    [anon_sym_for] = ACTIONS(373),
    [anon_sym_while] = ACTIONS(373),
    [anon_sym_repeat] = ACTIONS(373),
    [anon_sym_QMARK] = ACTIONS(371),
    [anon_sym_TILDE] = ACTIONS(159),
    [anon_sym_BANG] = ACTIONS(373),
    [anon_sym_PLUS] = ACTIONS(161),
    [anon_sym_DASH] = ACTIONS(163),
    [anon_sym_LT_DASH] = ACTIONS(165),
    [anon_sym_LT_LT_DASH] = ACTIONS(165),
    [anon_sym_COLON_EQ] = ACTIONS(165),
    [anon_sym_DASH_GT] = ACTIONS(167),
    [anon_sym_DASH_GT_GT] = ACTIONS(169),
    [anon_sym_PIPE] = ACTIONS(171),
    [anon_sym_AMP] = ACTIONS(173),
    [anon_sym_PIPE_PIPE] = ACTIONS(175),
    [anon_sym_AMP_AMP] = ACTIONS(177),
    [anon_sym_LT] = ACTIONS(179),
    [anon_sym_LT_EQ] = ACTIONS(181),
    [anon_sym_GT] = ACTIONS(179),
    [anon_sym_GT_EQ] = ACTIONS(181),
    [anon_sym_EQ_EQ] = ACTIONS(181),
    [anon_sym_BANG_EQ] = ACTIONS(181),
    [anon_sym_STAR] = ACTIONS(183),
    [anon_sym_SLASH] = ACTIONS(185),
    [anon_sym_STAR_STAR] = ACTIONS(187),
    [anon_sym_CARET] = ACTIONS(187),
    [aux_sym_binary_operator_token1] = ACTIONS(189),
    [anon_sym_PIPE_GT] = ACTIONS(189),
    [anon_sym_COLON] = ACTIONS(191),
    [anon_sym_DOLLAR] = ACTIONS(193),
    [anon_sym_AT] = ACTIONS(193),
    [aux_sym__hex_literal_token1] = ACTIONS(371),
    [sym__number_literal] = ACTIONS(373),
    [anon_sym_SQUOTE] = ACTIONS(371),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [sym_return] = ACTIONS(373),
    [sym_next] = ACTIONS(373),
    [sym_break] = ACTIONS(373),
    [sym_true] = ACTIONS(373),
    [sym_false] = ACTIONS(373),
    [sym_null] = ACTIONS(373),
    [sym_inf] = ACTIONS(373),
    [sym_nan] = ACTIONS(373),
    [anon_sym_NA] = ACTIONS(373),
    [anon_sym_NA_integer_] = ACTIONS(373),
    [anon_sym_NA_real_] = ACTIONS(373),
    [anon_sym_NA_complex_] = ACTIONS(373),
    [anon_sym_NA_character_] = ACTIONS(373),
    [sym_dots] = ACTIONS(373),
    [sym_dot_dot_i] = ACTIONS(371),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(371),
    [sym__newline] = ACTIONS(371),
    [sym__raw_string_literal] = ACTIONS(371),
    [sym__external_else] = ACTIONS(371),
    [sym__external_open_parenthesis] = ACTIONS(197),
    [sym__external_close_parenthesis] = ACTIONS(371),
    [sym__external_open_brace] = ACTIONS(371),
    [sym__external_open_bracket] = ACTIONS(199),
    [sym__external_open_bracket2] = ACTIONS(201),
  },
  [97] = {
    [sym_call_arguments] = STATE(888),
    [sym_subset_arguments] = STATE(892),
    [sym_subset2_arguments] = STATE(895),
    [sym__open_parenthesis] = STATE(345),
    [sym__open_bracket] = STATE(346),
    [sym__open_bracket2] = STATE(347),
    [sym_identifier] = ACTIONS(377),
    [anon_sym_BSLASH] = ACTIONS(375),
    [anon_sym_function] = ACTIONS(377),
    [anon_sym_EQ] = ACTIONS(157),
    [anon_sym_if] = ACTIONS(377),
    [anon_sym_for] = ACTIONS(377),
    [anon_sym_while] = ACTIONS(377),
    [anon_sym_repeat] = ACTIONS(377),
    [anon_sym_QMARK] = ACTIONS(375),
    [anon_sym_TILDE] = ACTIONS(159),
    [anon_sym_BANG] = ACTIONS(377),
    [anon_sym_PLUS] = ACTIONS(161),
    [anon_sym_DASH] = ACTIONS(163),
    [anon_sym_LT_DASH] = ACTIONS(165),
    [anon_sym_LT_LT_DASH] = ACTIONS(165),
    [anon_sym_COLON_EQ] = ACTIONS(165),
    [anon_sym_DASH_GT] = ACTIONS(167),
    [anon_sym_DASH_GT_GT] = ACTIONS(169),
    [anon_sym_PIPE] = ACTIONS(171),
    [anon_sym_AMP] = ACTIONS(173),
    [anon_sym_PIPE_PIPE] = ACTIONS(175),
    [anon_sym_AMP_AMP] = ACTIONS(177),
    [anon_sym_LT] = ACTIONS(179),
    [anon_sym_LT_EQ] = ACTIONS(181),
    [anon_sym_GT] = ACTIONS(179),
    [anon_sym_GT_EQ] = ACTIONS(181),
    [anon_sym_EQ_EQ] = ACTIONS(181),
    [anon_sym_BANG_EQ] = ACTIONS(181),
    [anon_sym_STAR] = ACTIONS(183),
    [anon_sym_SLASH] = ACTIONS(185),
    [anon_sym_STAR_STAR] = ACTIONS(187),
    [anon_sym_CARET] = ACTIONS(187),
    [aux_sym_binary_operator_token1] = ACTIONS(189),
    [anon_sym_PIPE_GT] = ACTIONS(189),
    [anon_sym_COLON] = ACTIONS(191),
    [anon_sym_DOLLAR] = ACTIONS(193),
    [anon_sym_AT] = ACTIONS(193),
    [aux_sym__hex_literal_token1] = ACTIONS(375),
    [sym__number_literal] = ACTIONS(377),
    [anon_sym_SQUOTE] = ACTIONS(375),
    [anon_sym_DQUOTE] = ACTIONS(375),
    [sym_return] = ACTIONS(377),
    [sym_next] = ACTIONS(377),
    [sym_break] = ACTIONS(377),
    [sym_true] = ACTIONS(377),
    [sym_false] = ACTIONS(377),
    [sym_null] = ACTIONS(377),
    [sym_inf] = ACTIONS(377),
    [sym_nan] = ACTIONS(377),
    [anon_sym_NA] = ACTIONS(377),
    [anon_sym_NA_integer_] = ACTIONS(377),
    [anon_sym_NA_real_] = ACTIONS(377),
    [anon_sym_NA_complex_] = ACTIONS(377),
    [anon_sym_NA_character_] = ACTIONS(377),
    [sym_dots] = ACTIONS(377),
    [sym_dot_dot_i] = ACTIONS(375),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(375),
    [sym__newline] = ACTIONS(375),
    [sym__raw_string_literal] = ACTIONS(375),
    [sym__external_else] = ACTIONS(375),
    [sym__external_open_parenthesis] = ACTIONS(197),
    [sym__external_close_parenthesis] = ACTIONS(375),
    [sym__external_open_brace] = ACTIONS(375),
    [sym__external_open_bracket] = ACTIONS(199),
    [sym__external_open_bracket2] = ACTIONS(201),
  },
  [98] = {
    [sym_call_arguments] = STATE(888),
    [sym_subset_arguments] = STATE(892),
    [sym_subset2_arguments] = STATE(895),
    [sym__open_parenthesis] = STATE(345),
    [sym__open_bracket] = STATE(346),
    [sym__open_bracket2] = STATE(347),
    [sym_identifier] = ACTIONS(381),
    [anon_sym_BSLASH] = ACTIONS(379),
    [anon_sym_function] = ACTIONS(381),
    [anon_sym_EQ] = ACTIONS(157),
    [anon_sym_if] = ACTIONS(381),
    [anon_sym_for] = ACTIONS(381),
    [anon_sym_while] = ACTIONS(381),
    [anon_sym_repeat] = ACTIONS(381),
    [anon_sym_QMARK] = ACTIONS(379),
    [anon_sym_TILDE] = ACTIONS(159),
    [anon_sym_BANG] = ACTIONS(381),
    [anon_sym_PLUS] = ACTIONS(161),
    [anon_sym_DASH] = ACTIONS(163),
    [anon_sym_LT_DASH] = ACTIONS(165),
    [anon_sym_LT_LT_DASH] = ACTIONS(165),
    [anon_sym_COLON_EQ] = ACTIONS(165),
    [anon_sym_DASH_GT] = ACTIONS(167),
    [anon_sym_DASH_GT_GT] = ACTIONS(169),
    [anon_sym_PIPE] = ACTIONS(171),
    [anon_sym_AMP] = ACTIONS(173),
    [anon_sym_PIPE_PIPE] = ACTIONS(175),
    [anon_sym_AMP_AMP] = ACTIONS(177),
    [anon_sym_LT] = ACTIONS(179),
    [anon_sym_LT_EQ] = ACTIONS(181),
    [anon_sym_GT] = ACTIONS(179),
    [anon_sym_GT_EQ] = ACTIONS(181),
    [anon_sym_EQ_EQ] = ACTIONS(181),
    [anon_sym_BANG_EQ] = ACTIONS(181),
    [anon_sym_STAR] = ACTIONS(183),
    [anon_sym_SLASH] = ACTIONS(185),
    [anon_sym_STAR_STAR] = ACTIONS(187),
    [anon_sym_CARET] = ACTIONS(187),
    [aux_sym_binary_operator_token1] = ACTIONS(189),
    [anon_sym_PIPE_GT] = ACTIONS(189),
    [anon_sym_COLON] = ACTIONS(191),
    [anon_sym_DOLLAR] = ACTIONS(193),
    [anon_sym_AT] = ACTIONS(193),
    [aux_sym__hex_literal_token1] = ACTIONS(379),
    [sym__number_literal] = ACTIONS(381),
    [anon_sym_SQUOTE] = ACTIONS(379),
    [anon_sym_DQUOTE] = ACTIONS(379),
    [sym_return] = ACTIONS(381),
    [sym_next] = ACTIONS(381),
    [sym_break] = ACTIONS(381),
    [sym_true] = ACTIONS(381),
    [sym_false] = ACTIONS(381),
    [sym_null] = ACTIONS(381),
    [sym_inf] = ACTIONS(381),
    [sym_nan] = ACTIONS(381),
    [anon_sym_NA] = ACTIONS(381),
    [anon_sym_NA_integer_] = ACTIONS(381),
    [anon_sym_NA_real_] = ACTIONS(381),
    [anon_sym_NA_complex_] = ACTIONS(381),
    [anon_sym_NA_character_] = ACTIONS(381),
    [sym_dots] = ACTIONS(381),
    [sym_dot_dot_i] = ACTIONS(379),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(379),
    [sym__newline] = ACTIONS(379),
    [sym__raw_string_literal] = ACTIONS(379),
    [sym__external_else] = ACTIONS(379),
    [sym__external_open_parenthesis] = ACTIONS(197),
    [sym__external_close_parenthesis] = ACTIONS(379),
    [sym__external_open_brace] = ACTIONS(379),
    [sym__external_open_bracket] = ACTIONS(199),
    [sym__external_open_bracket2] = ACTIONS(201),
  },
  [99] = {
    [sym_call_arguments] = STATE(888),
    [sym_subset_arguments] = STATE(892),
    [sym_subset2_arguments] = STATE(895),
    [sym__open_parenthesis] = STATE(345),
    [sym__open_bracket] = STATE(346),
    [sym__open_bracket2] = STATE(347),
    [sym_identifier] = ACTIONS(381),
    [anon_sym_BSLASH] = ACTIONS(379),
    [anon_sym_function] = ACTIONS(381),
    [anon_sym_EQ] = ACTIONS(381),
    [anon_sym_if] = ACTIONS(381),
    [anon_sym_for] = ACTIONS(381),
    [anon_sym_while] = ACTIONS(381),
    [anon_sym_repeat] = ACTIONS(381),
    [anon_sym_QMARK] = ACTIONS(379),
    [anon_sym_TILDE] = ACTIONS(379),
    [anon_sym_BANG] = ACTIONS(381),
    [anon_sym_PLUS] = ACTIONS(161),
    [anon_sym_DASH] = ACTIONS(163),
    [anon_sym_LT_DASH] = ACTIONS(379),
    [anon_sym_LT_LT_DASH] = ACTIONS(379),
    [anon_sym_COLON_EQ] = ACTIONS(379),
    [anon_sym_DASH_GT] = ACTIONS(381),
    [anon_sym_DASH_GT_GT] = ACTIONS(379),
    [anon_sym_PIPE] = ACTIONS(171),
    [anon_sym_AMP] = ACTIONS(173),
    [anon_sym_PIPE_PIPE] = ACTIONS(175),
    [anon_sym_AMP_AMP] = ACTIONS(177),
    [anon_sym_LT] = ACTIONS(179),
    [anon_sym_LT_EQ] = ACTIONS(181),
    [anon_sym_GT] = ACTIONS(179),
    [anon_sym_GT_EQ] = ACTIONS(181),
    [anon_sym_EQ_EQ] = ACTIONS(181),
    [anon_sym_BANG_EQ] = ACTIONS(181),
    [anon_sym_STAR] = ACTIONS(183),
    [anon_sym_SLASH] = ACTIONS(185),
    [anon_sym_STAR_STAR] = ACTIONS(187),
    [anon_sym_CARET] = ACTIONS(187),
    [aux_sym_binary_operator_token1] = ACTIONS(189),
    [anon_sym_PIPE_GT] = ACTIONS(189),
    [anon_sym_COLON] = ACTIONS(191),
    [anon_sym_DOLLAR] = ACTIONS(193),
    [anon_sym_AT] = ACTIONS(193),
    [aux_sym__hex_literal_token1] = ACTIONS(379),
    [sym__number_literal] = ACTIONS(381),
    [anon_sym_SQUOTE] = ACTIONS(379),
    [anon_sym_DQUOTE] = ACTIONS(379),
    [sym_return] = ACTIONS(381),
    [sym_next] = ACTIONS(381),
    [sym_break] = ACTIONS(381),
    [sym_true] = ACTIONS(381),
    [sym_false] = ACTIONS(381),
    [sym_null] = ACTIONS(381),
    [sym_inf] = ACTIONS(381),
    [sym_nan] = ACTIONS(381),
    [anon_sym_NA] = ACTIONS(381),
    [anon_sym_NA_integer_] = ACTIONS(381),
    [anon_sym_NA_real_] = ACTIONS(381),
    [anon_sym_NA_complex_] = ACTIONS(381),
    [anon_sym_NA_character_] = ACTIONS(381),
    [sym_dots] = ACTIONS(381),
    [sym_dot_dot_i] = ACTIONS(379),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(379),
    [sym__newline] = ACTIONS(379),
    [sym__raw_string_literal] = ACTIONS(379),
    [sym__external_else] = ACTIONS(379),
    [sym__external_open_parenthesis] = ACTIONS(197),
    [sym__external_close_parenthesis] = ACTIONS(379),
    [sym__external_open_brace] = ACTIONS(379),
    [sym__external_open_bracket] = ACTIONS(199),
    [sym__external_open_bracket2] = ACTIONS(201),
  },
  [100] = {
    [sym_call_arguments] = STATE(888),
    [sym_subset_arguments] = STATE(892),
    [sym_subset2_arguments] = STATE(895),
    [sym__open_parenthesis] = STATE(345),
    [sym__open_bracket] = STATE(346),
    [sym__open_bracket2] = STATE(347),
    [sym_identifier] = ACTIONS(381),
    [anon_sym_BSLASH] = ACTIONS(379),
    [anon_sym_function] = ACTIONS(381),
    [anon_sym_EQ] = ACTIONS(381),
    [anon_sym_if] = ACTIONS(381),
    [anon_sym_for] = ACTIONS(381),
    [anon_sym_while] = ACTIONS(381),
    [anon_sym_repeat] = ACTIONS(381),
    [anon_sym_QMARK] = ACTIONS(379),
    [anon_sym_TILDE] = ACTIONS(379),
    [anon_sym_BANG] = ACTIONS(381),
    [anon_sym_PLUS] = ACTIONS(161),
    [anon_sym_DASH] = ACTIONS(163),
    [anon_sym_LT_DASH] = ACTIONS(379),
    [anon_sym_LT_LT_DASH] = ACTIONS(379),
    [anon_sym_COLON_EQ] = ACTIONS(379),
    [anon_sym_DASH_GT] = ACTIONS(381),
    [anon_sym_DASH_GT_GT] = ACTIONS(379),
    [anon_sym_PIPE] = ACTIONS(381),
    [anon_sym_AMP] = ACTIONS(381),
    [anon_sym_PIPE_PIPE] = ACTIONS(379),
    [anon_sym_AMP_AMP] = ACTIONS(379),
    [anon_sym_LT] = ACTIONS(179),
    [anon_sym_LT_EQ] = ACTIONS(181),
    [anon_sym_GT] = ACTIONS(179),
    [anon_sym_GT_EQ] = ACTIONS(181),
    [anon_sym_EQ_EQ] = ACTIONS(181),
    [anon_sym_BANG_EQ] = ACTIONS(181),
    [anon_sym_STAR] = ACTIONS(183),
    [anon_sym_SLASH] = ACTIONS(185),
    [anon_sym_STAR_STAR] = ACTIONS(187),
    [anon_sym_CARET] = ACTIONS(187),
    [aux_sym_binary_operator_token1] = ACTIONS(189),
    [anon_sym_PIPE_GT] = ACTIONS(189),
    [anon_sym_COLON] = ACTIONS(191),
    [anon_sym_DOLLAR] = ACTIONS(193),
    [anon_sym_AT] = ACTIONS(193),
    [aux_sym__hex_literal_token1] = ACTIONS(379),
    [sym__number_literal] = ACTIONS(381),
    [anon_sym_SQUOTE] = ACTIONS(379),
    [anon_sym_DQUOTE] = ACTIONS(379),
    [sym_return] = ACTIONS(381),
    [sym_next] = ACTIONS(381),
    [sym_break] = ACTIONS(381),
    [sym_true] = ACTIONS(381),
    [sym_false] = ACTIONS(381),
    [sym_null] = ACTIONS(381),
    [sym_inf] = ACTIONS(381),
    [sym_nan] = ACTIONS(381),
    [anon_sym_NA] = ACTIONS(381),
    [anon_sym_NA_integer_] = ACTIONS(381),
    [anon_sym_NA_real_] = ACTIONS(381),
    [anon_sym_NA_complex_] = ACTIONS(381),
    [anon_sym_NA_character_] = ACTIONS(381),
    [sym_dots] = ACTIONS(381),
    [sym_dot_dot_i] = ACTIONS(379),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(379),
    [sym__newline] = ACTIONS(379),
    [sym__raw_string_literal] = ACTIONS(379),
    [sym__external_else] = ACTIONS(379),
    [sym__external_open_parenthesis] = ACTIONS(197),
    [sym__external_close_parenthesis] = ACTIONS(379),
    [sym__external_open_brace] = ACTIONS(379),
    [sym__external_open_bracket] = ACTIONS(199),
    [sym__external_open_bracket2] = ACTIONS(201),
  },
  [101] = {
    [sym_call_arguments] = STATE(888),
    [sym_subset_arguments] = STATE(892),
    [sym_subset2_arguments] = STATE(895),
    [sym__open_parenthesis] = STATE(345),
    [sym__open_bracket] = STATE(346),
    [sym__open_bracket2] = STATE(347),
    [sym_identifier] = ACTIONS(381),
    [anon_sym_BSLASH] = ACTIONS(379),
    [anon_sym_function] = ACTIONS(381),
    [anon_sym_EQ] = ACTIONS(381),
    [anon_sym_if] = ACTIONS(381),
    [anon_sym_for] = ACTIONS(381),
    [anon_sym_while] = ACTIONS(381),
    [anon_sym_repeat] = ACTIONS(381),
    [anon_sym_QMARK] = ACTIONS(379),
    [anon_sym_TILDE] = ACTIONS(379),
    [anon_sym_BANG] = ACTIONS(381),
    [anon_sym_PLUS] = ACTIONS(379),
    [anon_sym_DASH] = ACTIONS(381),
    [anon_sym_LT_DASH] = ACTIONS(379),
    [anon_sym_LT_LT_DASH] = ACTIONS(379),
    [anon_sym_COLON_EQ] = ACTIONS(379),
    [anon_sym_DASH_GT] = ACTIONS(381),
    [anon_sym_DASH_GT_GT] = ACTIONS(379),
    [anon_sym_PIPE] = ACTIONS(381),
    [anon_sym_AMP] = ACTIONS(381),
    [anon_sym_PIPE_PIPE] = ACTIONS(379),
    [anon_sym_AMP_AMP] = ACTIONS(379),
    [anon_sym_LT] = ACTIONS(381),
    [anon_sym_LT_EQ] = ACTIONS(379),
    [anon_sym_GT] = ACTIONS(381),
    [anon_sym_GT_EQ] = ACTIONS(379),
    [anon_sym_EQ_EQ] = ACTIONS(379),
    [anon_sym_BANG_EQ] = ACTIONS(379),
    [anon_sym_STAR] = ACTIONS(381),
    [anon_sym_SLASH] = ACTIONS(379),
    [anon_sym_STAR_STAR] = ACTIONS(187),
    [anon_sym_CARET] = ACTIONS(187),
    [aux_sym_binary_operator_token1] = ACTIONS(379),
    [anon_sym_PIPE_GT] = ACTIONS(379),
    [anon_sym_COLON] = ACTIONS(381),
    [anon_sym_DOLLAR] = ACTIONS(193),
    [anon_sym_AT] = ACTIONS(193),
    [aux_sym__hex_literal_token1] = ACTIONS(379),
    [sym__number_literal] = ACTIONS(381),
    [anon_sym_SQUOTE] = ACTIONS(379),
    [anon_sym_DQUOTE] = ACTIONS(379),
    [sym_return] = ACTIONS(381),
    [sym_next] = ACTIONS(381),
    [sym_break] = ACTIONS(381),
    [sym_true] = ACTIONS(381),
    [sym_false] = ACTIONS(381),
    [sym_null] = ACTIONS(381),
    [sym_inf] = ACTIONS(381),
    [sym_nan] = ACTIONS(381),
    [anon_sym_NA] = ACTIONS(381),
    [anon_sym_NA_integer_] = ACTIONS(381),
    [anon_sym_NA_real_] = ACTIONS(381),
    [anon_sym_NA_complex_] = ACTIONS(381),
    [anon_sym_NA_character_] = ACTIONS(381),
    [sym_dots] = ACTIONS(381),
    [sym_dot_dot_i] = ACTIONS(379),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(379),
    [sym__newline] = ACTIONS(379),
    [sym__raw_string_literal] = ACTIONS(379),
    [sym__external_else] = ACTIONS(379),
    [sym__external_open_parenthesis] = ACTIONS(197),
    [sym__external_close_parenthesis] = ACTIONS(379),
    [sym__external_open_brace] = ACTIONS(379),
    [sym__external_open_bracket] = ACTIONS(199),
    [sym__external_open_bracket2] = ACTIONS(201),
  },
  [102] = {
    [sym_call_arguments] = STATE(888),
    [sym_subset_arguments] = STATE(892),
    [sym_subset2_arguments] = STATE(895),
    [sym__open_parenthesis] = STATE(345),
    [sym__open_bracket] = STATE(346),
    [sym__open_bracket2] = STATE(347),
    [sym_identifier] = ACTIONS(385),
    [anon_sym_BSLASH] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_EQ] = ACTIONS(157),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_for] = ACTIONS(385),
    [anon_sym_while] = ACTIONS(385),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_QMARK] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(159),
    [anon_sym_BANG] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(161),
    [anon_sym_DASH] = ACTIONS(163),
    [anon_sym_LT_DASH] = ACTIONS(383),
    [anon_sym_LT_LT_DASH] = ACTIONS(383),
    [anon_sym_COLON_EQ] = ACTIONS(383),
    [anon_sym_DASH_GT] = ACTIONS(167),
    [anon_sym_DASH_GT_GT] = ACTIONS(169),
    [anon_sym_PIPE] = ACTIONS(171),
    [anon_sym_AMP] = ACTIONS(173),
    [anon_sym_PIPE_PIPE] = ACTIONS(175),
    [anon_sym_AMP_AMP] = ACTIONS(177),
    [anon_sym_LT] = ACTIONS(179),
    [anon_sym_LT_EQ] = ACTIONS(181),
    [anon_sym_GT] = ACTIONS(179),
    [anon_sym_GT_EQ] = ACTIONS(181),
    [anon_sym_EQ_EQ] = ACTIONS(181),
    [anon_sym_BANG_EQ] = ACTIONS(181),
    [anon_sym_STAR] = ACTIONS(183),
    [anon_sym_SLASH] = ACTIONS(185),
    [anon_sym_STAR_STAR] = ACTIONS(187),
    [anon_sym_CARET] = ACTIONS(187),
    [aux_sym_binary_operator_token1] = ACTIONS(189),
    [anon_sym_PIPE_GT] = ACTIONS(189),
    [anon_sym_COLON] = ACTIONS(191),
    [anon_sym_DOLLAR] = ACTIONS(193),
    [anon_sym_AT] = ACTIONS(193),
    [aux_sym__hex_literal_token1] = ACTIONS(383),
    [sym__number_literal] = ACTIONS(385),
    [anon_sym_SQUOTE] = ACTIONS(383),
    [anon_sym_DQUOTE] = ACTIONS(383),
    [sym_return] = ACTIONS(385),
    [sym_next] = ACTIONS(385),
    [sym_break] = ACTIONS(385),
    [sym_true] = ACTIONS(385),
    [sym_false] = ACTIONS(385),
    [sym_null] = ACTIONS(385),
    [sym_inf] = ACTIONS(385),
    [sym_nan] = ACTIONS(385),
    [anon_sym_NA] = ACTIONS(385),
    [anon_sym_NA_integer_] = ACTIONS(385),
    [anon_sym_NA_real_] = ACTIONS(385),
    [anon_sym_NA_complex_] = ACTIONS(385),
    [anon_sym_NA_character_] = ACTIONS(385),
    [sym_dots] = ACTIONS(385),
    [sym_dot_dot_i] = ACTIONS(383),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(383),
    [sym__newline] = ACTIONS(383),
    [sym__raw_string_literal] = ACTIONS(383),
    [sym__external_else] = ACTIONS(383),
    [sym__external_open_parenthesis] = ACTIONS(197),
    [sym__external_close_parenthesis] = ACTIONS(383),
    [sym__external_open_brace] = ACTIONS(383),
    [sym__external_open_bracket] = ACTIONS(199),
    [sym__external_open_bracket2] = ACTIONS(201),
  },
  [103] = {
    [sym_call_arguments] = STATE(888),
    [sym_subset_arguments] = STATE(892),
    [sym_subset2_arguments] = STATE(895),
    [sym__open_parenthesis] = STATE(345),
    [sym__open_bracket] = STATE(346),
    [sym__open_bracket2] = STATE(347),
    [sym_identifier] = ACTIONS(385),
    [anon_sym_BSLASH] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_EQ] = ACTIONS(157),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_for] = ACTIONS(385),
    [anon_sym_while] = ACTIONS(385),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_QMARK] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(159),
    [anon_sym_BANG] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(161),
    [anon_sym_DASH] = ACTIONS(163),
    [anon_sym_LT_DASH] = ACTIONS(165),
    [anon_sym_LT_LT_DASH] = ACTIONS(165),
    [anon_sym_COLON_EQ] = ACTIONS(165),
    [anon_sym_DASH_GT] = ACTIONS(167),
    [anon_sym_DASH_GT_GT] = ACTIONS(169),
    [anon_sym_PIPE] = ACTIONS(171),
    [anon_sym_AMP] = ACTIONS(173),
    [anon_sym_PIPE_PIPE] = ACTIONS(175),
    [anon_sym_AMP_AMP] = ACTIONS(177),
    [anon_sym_LT] = ACTIONS(179),
    [anon_sym_LT_EQ] = ACTIONS(181),
    [anon_sym_GT] = ACTIONS(179),
    [anon_sym_GT_EQ] = ACTIONS(181),
    [anon_sym_EQ_EQ] = ACTIONS(181),
    [anon_sym_BANG_EQ] = ACTIONS(181),
    [anon_sym_STAR] = ACTIONS(183),
    [anon_sym_SLASH] = ACTIONS(185),
    [anon_sym_STAR_STAR] = ACTIONS(187),
    [anon_sym_CARET] = ACTIONS(187),
    [aux_sym_binary_operator_token1] = ACTIONS(189),
    [anon_sym_PIPE_GT] = ACTIONS(189),
    [anon_sym_COLON] = ACTIONS(191),
    [anon_sym_DOLLAR] = ACTIONS(193),
    [anon_sym_AT] = ACTIONS(193),
    [aux_sym__hex_literal_token1] = ACTIONS(383),
    [sym__number_literal] = ACTIONS(385),
    [anon_sym_SQUOTE] = ACTIONS(383),
    [anon_sym_DQUOTE] = ACTIONS(383),
    [sym_return] = ACTIONS(385),
    [sym_next] = ACTIONS(385),
    [sym_break] = ACTIONS(385),
    [sym_true] = ACTIONS(385),
    [sym_false] = ACTIONS(385),
    [sym_null] = ACTIONS(385),
    [sym_inf] = ACTIONS(385),
    [sym_nan] = ACTIONS(385),
    [anon_sym_NA] = ACTIONS(385),
    [anon_sym_NA_integer_] = ACTIONS(385),
    [anon_sym_NA_real_] = ACTIONS(385),
    [anon_sym_NA_complex_] = ACTIONS(385),
    [anon_sym_NA_character_] = ACTIONS(385),
    [sym_dots] = ACTIONS(385),
    [sym_dot_dot_i] = ACTIONS(383),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(383),
    [sym__newline] = ACTIONS(383),
    [sym__raw_string_literal] = ACTIONS(383),
    [sym__external_else] = ACTIONS(383),
    [sym__external_open_parenthesis] = ACTIONS(197),
    [sym__external_close_parenthesis] = ACTIONS(383),
    [sym__external_open_brace] = ACTIONS(383),
    [sym__external_open_bracket] = ACTIONS(199),
    [sym__external_open_bracket2] = ACTIONS(201),
  },
  [104] = {
    [sym_call_arguments] = STATE(888),
    [sym_subset_arguments] = STATE(892),
    [sym_subset2_arguments] = STATE(895),
    [sym__open_parenthesis] = STATE(345),
    [sym__open_bracket] = STATE(346),
    [sym__open_bracket2] = STATE(347),
    [sym_identifier] = ACTIONS(385),
    [anon_sym_BSLASH] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_EQ] = ACTIONS(385),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_for] = ACTIONS(385),
    [anon_sym_while] = ACTIONS(385),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_QMARK] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(383),
    [anon_sym_BANG] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(161),
    [anon_sym_DASH] = ACTIONS(163),
    [anon_sym_LT_DASH] = ACTIONS(383),
    [anon_sym_LT_LT_DASH] = ACTIONS(383),
    [anon_sym_COLON_EQ] = ACTIONS(383),
    [anon_sym_DASH_GT] = ACTIONS(385),
    [anon_sym_DASH_GT_GT] = ACTIONS(383),
    [anon_sym_PIPE] = ACTIONS(171),
    [anon_sym_AMP] = ACTIONS(173),
    [anon_sym_PIPE_PIPE] = ACTIONS(175),
    [anon_sym_AMP_AMP] = ACTIONS(177),
    [anon_sym_LT] = ACTIONS(179),
    [anon_sym_LT_EQ] = ACTIONS(181),
    [anon_sym_GT] = ACTIONS(179),
    [anon_sym_GT_EQ] = ACTIONS(181),
    [anon_sym_EQ_EQ] = ACTIONS(181),
    [anon_sym_BANG_EQ] = ACTIONS(181),
    [anon_sym_STAR] = ACTIONS(183),
    [anon_sym_SLASH] = ACTIONS(185),
    [anon_sym_STAR_STAR] = ACTIONS(187),
    [anon_sym_CARET] = ACTIONS(187),
    [aux_sym_binary_operator_token1] = ACTIONS(189),
    [anon_sym_PIPE_GT] = ACTIONS(189),
    [anon_sym_COLON] = ACTIONS(191),
    [anon_sym_DOLLAR] = ACTIONS(193),
    [anon_sym_AT] = ACTIONS(193),
    [aux_sym__hex_literal_token1] = ACTIONS(383),
    [sym__number_literal] = ACTIONS(385),
    [anon_sym_SQUOTE] = ACTIONS(383),
    [anon_sym_DQUOTE] = ACTIONS(383),
    [sym_return] = ACTIONS(385),
    [sym_next] = ACTIONS(385),
    [sym_break] = ACTIONS(385),
    [sym_true] = ACTIONS(385),
    [sym_false] = ACTIONS(385),
    [sym_null] = ACTIONS(385),
    [sym_inf] = ACTIONS(385),
    [sym_nan] = ACTIONS(385),
    [anon_sym_NA] = ACTIONS(385),
    [anon_sym_NA_integer_] = ACTIONS(385),
    [anon_sym_NA_real_] = ACTIONS(385),
    [anon_sym_NA_complex_] = ACTIONS(385),
    [anon_sym_NA_character_] = ACTIONS(385),
    [sym_dots] = ACTIONS(385),
    [sym_dot_dot_i] = ACTIONS(383),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(383),
    [sym__newline] = ACTIONS(383),
    [sym__raw_string_literal] = ACTIONS(383),
    [sym__external_else] = ACTIONS(383),
    [sym__external_open_parenthesis] = ACTIONS(197),
    [sym__external_close_parenthesis] = ACTIONS(383),
    [sym__external_open_brace] = ACTIONS(383),
    [sym__external_open_bracket] = ACTIONS(199),
    [sym__external_open_bracket2] = ACTIONS(201),
  },
  [105] = {
    [sym_call_arguments] = STATE(888),
    [sym_subset_arguments] = STATE(892),
    [sym_subset2_arguments] = STATE(895),
    [sym__open_parenthesis] = STATE(345),
    [sym__open_bracket] = STATE(346),
    [sym__open_bracket2] = STATE(347),
    [sym_identifier] = ACTIONS(385),
    [anon_sym_BSLASH] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_EQ] = ACTIONS(385),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_for] = ACTIONS(385),
    [anon_sym_while] = ACTIONS(385),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_QMARK] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(383),
    [anon_sym_BANG] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(385),
    [anon_sym_LT_DASH] = ACTIONS(383),
    [anon_sym_LT_LT_DASH] = ACTIONS(383),
    [anon_sym_COLON_EQ] = ACTIONS(383),
    [anon_sym_DASH_GT] = ACTIONS(385),
    [anon_sym_DASH_GT_GT] = ACTIONS(383),
    [anon_sym_PIPE] = ACTIONS(385),
    [anon_sym_AMP] = ACTIONS(385),
    [anon_sym_PIPE_PIPE] = ACTIONS(383),
    [anon_sym_AMP_AMP] = ACTIONS(383),
    [anon_sym_LT] = ACTIONS(385),
    [anon_sym_LT_EQ] = ACTIONS(383),
    [anon_sym_GT] = ACTIONS(385),
    [anon_sym_GT_EQ] = ACTIONS(383),
    [anon_sym_EQ_EQ] = ACTIONS(383),
    [anon_sym_BANG_EQ] = ACTIONS(383),
    [anon_sym_STAR] = ACTIONS(183),
    [anon_sym_SLASH] = ACTIONS(185),
    [anon_sym_STAR_STAR] = ACTIONS(187),
    [anon_sym_CARET] = ACTIONS(187),
    [aux_sym_binary_operator_token1] = ACTIONS(189),
    [anon_sym_PIPE_GT] = ACTIONS(189),
    [anon_sym_COLON] = ACTIONS(191),
    [anon_sym_DOLLAR] = ACTIONS(193),
    [anon_sym_AT] = ACTIONS(193),
    [aux_sym__hex_literal_token1] = ACTIONS(383),
    [sym__number_literal] = ACTIONS(385),
    [anon_sym_SQUOTE] = ACTIONS(383),
    [anon_sym_DQUOTE] = ACTIONS(383),
    [sym_return] = ACTIONS(385),
    [sym_next] = ACTIONS(385),
    [sym_break] = ACTIONS(385),
    [sym_true] = ACTIONS(385),
    [sym_false] = ACTIONS(385),
    [sym_null] = ACTIONS(385),
    [sym_inf] = ACTIONS(385),
    [sym_nan] = ACTIONS(385),
    [anon_sym_NA] = ACTIONS(385),
    [anon_sym_NA_integer_] = ACTIONS(385),
    [anon_sym_NA_real_] = ACTIONS(385),
    [anon_sym_NA_complex_] = ACTIONS(385),
    [anon_sym_NA_character_] = ACTIONS(385),
    [sym_dots] = ACTIONS(385),
    [sym_dot_dot_i] = ACTIONS(383),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(383),
    [sym__newline] = ACTIONS(383),
    [sym__raw_string_literal] = ACTIONS(383),
    [sym__external_else] = ACTIONS(383),
    [sym__external_open_parenthesis] = ACTIONS(197),
    [sym__external_close_parenthesis] = ACTIONS(383),
    [sym__external_open_brace] = ACTIONS(383),
    [sym__external_open_bracket] = ACTIONS(199),
    [sym__external_open_bracket2] = ACTIONS(201),
  },
  [106] = {
    [sym_call_arguments] = STATE(888),
    [sym_subset_arguments] = STATE(892),
    [sym_subset2_arguments] = STATE(895),
    [sym__open_parenthesis] = STATE(345),
    [sym__open_bracket] = STATE(346),
    [sym__open_bracket2] = STATE(347),
    [sym_identifier] = ACTIONS(385),
    [anon_sym_BSLASH] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_EQ] = ACTIONS(157),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_for] = ACTIONS(385),
    [anon_sym_while] = ACTIONS(385),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_QMARK] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(159),
    [anon_sym_BANG] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(161),
    [anon_sym_DASH] = ACTIONS(163),
    [anon_sym_LT_DASH] = ACTIONS(165),
    [anon_sym_LT_LT_DASH] = ACTIONS(165),
    [anon_sym_COLON_EQ] = ACTIONS(165),
    [anon_sym_DASH_GT] = ACTIONS(167),
    [anon_sym_DASH_GT_GT] = ACTIONS(169),
    [anon_sym_PIPE] = ACTIONS(171),
    [anon_sym_AMP] = ACTIONS(173),
    [anon_sym_PIPE_PIPE] = ACTIONS(175),
    [anon_sym_AMP_AMP] = ACTIONS(177),
    [anon_sym_LT] = ACTIONS(179),
    [anon_sym_LT_EQ] = ACTIONS(181),
    [anon_sym_GT] = ACTIONS(179),
    [anon_sym_GT_EQ] = ACTIONS(181),
    [anon_sym_EQ_EQ] = ACTIONS(181),
    [anon_sym_BANG_EQ] = ACTIONS(181),
    [anon_sym_STAR] = ACTIONS(183),
    [anon_sym_SLASH] = ACTIONS(185),
    [anon_sym_STAR_STAR] = ACTIONS(187),
    [anon_sym_CARET] = ACTIONS(187),
    [aux_sym_binary_operator_token1] = ACTIONS(189),
    [anon_sym_PIPE_GT] = ACTIONS(189),
    [anon_sym_COLON] = ACTIONS(191),
    [anon_sym_DOLLAR] = ACTIONS(193),
    [anon_sym_AT] = ACTIONS(193),
    [aux_sym__hex_literal_token1] = ACTIONS(383),
    [sym__number_literal] = ACTIONS(385),
    [anon_sym_SQUOTE] = ACTIONS(383),
    [anon_sym_DQUOTE] = ACTIONS(383),
    [sym_return] = ACTIONS(385),
    [sym_next] = ACTIONS(385),
    [sym_break] = ACTIONS(385),
    [sym_true] = ACTIONS(385),
    [sym_false] = ACTIONS(385),
    [sym_null] = ACTIONS(385),
    [sym_inf] = ACTIONS(385),
    [sym_nan] = ACTIONS(385),
    [anon_sym_NA] = ACTIONS(385),
    [anon_sym_NA_integer_] = ACTIONS(385),
    [anon_sym_NA_real_] = ACTIONS(385),
    [anon_sym_NA_complex_] = ACTIONS(385),
    [anon_sym_NA_character_] = ACTIONS(385),
    [sym_dots] = ACTIONS(385),
    [sym_dot_dot_i] = ACTIONS(383),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(383),
    [sym__newline] = ACTIONS(383),
    [sym__raw_string_literal] = ACTIONS(383),
    [sym__external_else] = ACTIONS(383),
    [sym__external_open_parenthesis] = ACTIONS(197),
    [sym__external_close_parenthesis] = ACTIONS(383),
    [sym__external_open_brace] = ACTIONS(383),
    [sym__external_open_bracket] = ACTIONS(199),
    [sym__external_open_bracket2] = ACTIONS(201),
  },
  [107] = {
    [sym_call_arguments] = STATE(888),
    [sym_subset_arguments] = STATE(892),
    [sym_subset2_arguments] = STATE(895),
    [sym__open_parenthesis] = STATE(345),
    [sym__open_bracket] = STATE(346),
    [sym__open_bracket2] = STATE(347),
    [sym_identifier] = ACTIONS(385),
    [anon_sym_BSLASH] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_EQ] = ACTIONS(385),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_for] = ACTIONS(385),
    [anon_sym_while] = ACTIONS(385),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_QMARK] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(159),
    [anon_sym_BANG] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(161),
    [anon_sym_DASH] = ACTIONS(163),
    [anon_sym_LT_DASH] = ACTIONS(383),
    [anon_sym_LT_LT_DASH] = ACTIONS(383),
    [anon_sym_COLON_EQ] = ACTIONS(383),
    [anon_sym_DASH_GT] = ACTIONS(385),
    [anon_sym_DASH_GT_GT] = ACTIONS(383),
    [anon_sym_PIPE] = ACTIONS(171),
    [anon_sym_AMP] = ACTIONS(173),
    [anon_sym_PIPE_PIPE] = ACTIONS(175),
    [anon_sym_AMP_AMP] = ACTIONS(177),
    [anon_sym_LT] = ACTIONS(179),
    [anon_sym_LT_EQ] = ACTIONS(181),
    [anon_sym_GT] = ACTIONS(179),
    [anon_sym_GT_EQ] = ACTIONS(181),
    [anon_sym_EQ_EQ] = ACTIONS(181),
    [anon_sym_BANG_EQ] = ACTIONS(181),
    [anon_sym_STAR] = ACTIONS(183),
    [anon_sym_SLASH] = ACTIONS(185),
    [anon_sym_STAR_STAR] = ACTIONS(187),
    [anon_sym_CARET] = ACTIONS(187),
    [aux_sym_binary_operator_token1] = ACTIONS(189),
    [anon_sym_PIPE_GT] = ACTIONS(189),
    [anon_sym_COLON] = ACTIONS(191),
    [anon_sym_DOLLAR] = ACTIONS(193),
    [anon_sym_AT] = ACTIONS(193),
    [aux_sym__hex_literal_token1] = ACTIONS(383),
    [sym__number_literal] = ACTIONS(385),
    [anon_sym_SQUOTE] = ACTIONS(383),
    [anon_sym_DQUOTE] = ACTIONS(383),
    [sym_return] = ACTIONS(385),
    [sym_next] = ACTIONS(385),
    [sym_break] = ACTIONS(385),
    [sym_true] = ACTIONS(385),
    [sym_false] = ACTIONS(385),
    [sym_null] = ACTIONS(385),
    [sym_inf] = ACTIONS(385),
    [sym_nan] = ACTIONS(385),
    [anon_sym_NA] = ACTIONS(385),
    [anon_sym_NA_integer_] = ACTIONS(385),
    [anon_sym_NA_real_] = ACTIONS(385),
    [anon_sym_NA_complex_] = ACTIONS(385),
    [anon_sym_NA_character_] = ACTIONS(385),
    [sym_dots] = ACTIONS(385),
    [sym_dot_dot_i] = ACTIONS(383),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(383),
    [sym__newline] = ACTIONS(383),
    [sym__raw_string_literal] = ACTIONS(383),
    [sym__external_else] = ACTIONS(383),
    [sym__external_open_parenthesis] = ACTIONS(197),
    [sym__external_close_parenthesis] = ACTIONS(383),
    [sym__external_open_brace] = ACTIONS(383),
    [sym__external_open_bracket] = ACTIONS(199),
    [sym__external_open_bracket2] = ACTIONS(201),
  },
  [108] = {
    [sym_call_arguments] = STATE(888),
    [sym_subset_arguments] = STATE(892),
    [sym_subset2_arguments] = STATE(895),
    [sym__open_parenthesis] = STATE(345),
    [sym__open_bracket] = STATE(346),
    [sym__open_bracket2] = STATE(347),
    [sym_identifier] = ACTIONS(385),
    [anon_sym_BSLASH] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_EQ] = ACTIONS(385),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_for] = ACTIONS(385),
    [anon_sym_while] = ACTIONS(385),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_QMARK] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(383),
    [anon_sym_BANG] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(161),
    [anon_sym_DASH] = ACTIONS(163),
    [anon_sym_LT_DASH] = ACTIONS(383),
    [anon_sym_LT_LT_DASH] = ACTIONS(383),
    [anon_sym_COLON_EQ] = ACTIONS(383),
    [anon_sym_DASH_GT] = ACTIONS(385),
    [anon_sym_DASH_GT_GT] = ACTIONS(383),
    [anon_sym_PIPE] = ACTIONS(385),
    [anon_sym_AMP] = ACTIONS(173),
    [anon_sym_PIPE_PIPE] = ACTIONS(383),
    [anon_sym_AMP_AMP] = ACTIONS(177),
    [anon_sym_LT] = ACTIONS(179),
    [anon_sym_LT_EQ] = ACTIONS(181),
    [anon_sym_GT] = ACTIONS(179),
    [anon_sym_GT_EQ] = ACTIONS(181),
    [anon_sym_EQ_EQ] = ACTIONS(181),
    [anon_sym_BANG_EQ] = ACTIONS(181),
    [anon_sym_STAR] = ACTIONS(183),
    [anon_sym_SLASH] = ACTIONS(185),
    [anon_sym_STAR_STAR] = ACTIONS(187),
    [anon_sym_CARET] = ACTIONS(187),
    [aux_sym_binary_operator_token1] = ACTIONS(189),
    [anon_sym_PIPE_GT] = ACTIONS(189),
    [anon_sym_COLON] = ACTIONS(191),
    [anon_sym_DOLLAR] = ACTIONS(193),
    [anon_sym_AT] = ACTIONS(193),
    [aux_sym__hex_literal_token1] = ACTIONS(383),
    [sym__number_literal] = ACTIONS(385),
    [anon_sym_SQUOTE] = ACTIONS(383),
    [anon_sym_DQUOTE] = ACTIONS(383),
    [sym_return] = ACTIONS(385),
    [sym_next] = ACTIONS(385),
    [sym_break] = ACTIONS(385),
    [sym_true] = ACTIONS(385),
    [sym_false] = ACTIONS(385),
    [sym_null] = ACTIONS(385),
    [sym_inf] = ACTIONS(385),
    [sym_nan] = ACTIONS(385),
    [anon_sym_NA] = ACTIONS(385),
    [anon_sym_NA_integer_] = ACTIONS(385),
    [anon_sym_NA_real_] = ACTIONS(385),
    [anon_sym_NA_complex_] = ACTIONS(385),
    [anon_sym_NA_character_] = ACTIONS(385),
    [sym_dots] = ACTIONS(385),
    [sym_dot_dot_i] = ACTIONS(383),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(383),
    [sym__newline] = ACTIONS(383),
    [sym__raw_string_literal] = ACTIONS(383),
    [sym__external_else] = ACTIONS(383),
    [sym__external_open_parenthesis] = ACTIONS(197),
    [sym__external_close_parenthesis] = ACTIONS(383),
    [sym__external_open_brace] = ACTIONS(383),
    [sym__external_open_bracket] = ACTIONS(199),
    [sym__external_open_bracket2] = ACTIONS(201),
  },
  [109] = {
    [sym_call_arguments] = STATE(888),
    [sym_subset_arguments] = STATE(892),
    [sym_subset2_arguments] = STATE(895),
    [sym__open_parenthesis] = STATE(345),
    [sym__open_bracket] = STATE(346),
    [sym__open_bracket2] = STATE(347),
    [sym_identifier] = ACTIONS(385),
    [anon_sym_BSLASH] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_EQ] = ACTIONS(385),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_for] = ACTIONS(385),
    [anon_sym_while] = ACTIONS(385),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_QMARK] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(383),
    [anon_sym_BANG] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(161),
    [anon_sym_DASH] = ACTIONS(163),
    [anon_sym_LT_DASH] = ACTIONS(383),
    [anon_sym_LT_LT_DASH] = ACTIONS(383),
    [anon_sym_COLON_EQ] = ACTIONS(383),
    [anon_sym_DASH_GT] = ACTIONS(385),
    [anon_sym_DASH_GT_GT] = ACTIONS(383),
    [anon_sym_PIPE] = ACTIONS(385),
    [anon_sym_AMP] = ACTIONS(385),
    [anon_sym_PIPE_PIPE] = ACTIONS(383),
    [anon_sym_AMP_AMP] = ACTIONS(383),
    [anon_sym_LT] = ACTIONS(179),
    [anon_sym_LT_EQ] = ACTIONS(181),
    [anon_sym_GT] = ACTIONS(179),
    [anon_sym_GT_EQ] = ACTIONS(181),
    [anon_sym_EQ_EQ] = ACTIONS(181),
    [anon_sym_BANG_EQ] = ACTIONS(181),
    [anon_sym_STAR] = ACTIONS(183),
    [anon_sym_SLASH] = ACTIONS(185),
    [anon_sym_STAR_STAR] = ACTIONS(187),
    [anon_sym_CARET] = ACTIONS(187),
    [aux_sym_binary_operator_token1] = ACTIONS(189),
    [anon_sym_PIPE_GT] = ACTIONS(189),
    [anon_sym_COLON] = ACTIONS(191),
    [anon_sym_DOLLAR] = ACTIONS(193),
    [anon_sym_AT] = ACTIONS(193),
    [aux_sym__hex_literal_token1] = ACTIONS(383),
    [sym__number_literal] = ACTIONS(385),
    [anon_sym_SQUOTE] = ACTIONS(383),
    [anon_sym_DQUOTE] = ACTIONS(383),
    [sym_return] = ACTIONS(385),
    [sym_next] = ACTIONS(385),
    [sym_break] = ACTIONS(385),
    [sym_true] = ACTIONS(385),
    [sym_false] = ACTIONS(385),
    [sym_null] = ACTIONS(385),
    [sym_inf] = ACTIONS(385),
    [sym_nan] = ACTIONS(385),
    [anon_sym_NA] = ACTIONS(385),
    [anon_sym_NA_integer_] = ACTIONS(385),
    [anon_sym_NA_real_] = ACTIONS(385),
    [anon_sym_NA_complex_] = ACTIONS(385),
    [anon_sym_NA_character_] = ACTIONS(385),
    [sym_dots] = ACTIONS(385),
    [sym_dot_dot_i] = ACTIONS(383),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(383),
    [sym__newline] = ACTIONS(383),
    [sym__raw_string_literal] = ACTIONS(383),
    [sym__external_else] = ACTIONS(383),
    [sym__external_open_parenthesis] = ACTIONS(197),
    [sym__external_close_parenthesis] = ACTIONS(383),
    [sym__external_open_brace] = ACTIONS(383),
    [sym__external_open_bracket] = ACTIONS(199),
    [sym__external_open_bracket2] = ACTIONS(201),
  },
  [110] = {
    [sym_call_arguments] = STATE(888),
    [sym_subset_arguments] = STATE(892),
    [sym_subset2_arguments] = STATE(895),
    [sym__open_parenthesis] = STATE(345),
    [sym__open_bracket] = STATE(346),
    [sym__open_bracket2] = STATE(347),
    [sym_identifier] = ACTIONS(385),
    [anon_sym_BSLASH] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_EQ] = ACTIONS(385),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_for] = ACTIONS(385),
    [anon_sym_while] = ACTIONS(385),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_QMARK] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(383),
    [anon_sym_BANG] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(161),
    [anon_sym_DASH] = ACTIONS(163),
    [anon_sym_LT_DASH] = ACTIONS(383),
    [anon_sym_LT_LT_DASH] = ACTIONS(383),
    [anon_sym_COLON_EQ] = ACTIONS(383),
    [anon_sym_DASH_GT] = ACTIONS(385),
    [anon_sym_DASH_GT_GT] = ACTIONS(383),
    [anon_sym_PIPE] = ACTIONS(385),
    [anon_sym_AMP] = ACTIONS(385),
    [anon_sym_PIPE_PIPE] = ACTIONS(383),
    [anon_sym_AMP_AMP] = ACTIONS(383),
    [anon_sym_LT] = ACTIONS(385),
    [anon_sym_LT_EQ] = ACTIONS(383),
    [anon_sym_GT] = ACTIONS(385),
    [anon_sym_GT_EQ] = ACTIONS(383),
    [anon_sym_EQ_EQ] = ACTIONS(383),
    [anon_sym_BANG_EQ] = ACTIONS(383),
    [anon_sym_STAR] = ACTIONS(183),
    [anon_sym_SLASH] = ACTIONS(185),
    [anon_sym_STAR_STAR] = ACTIONS(187),
    [anon_sym_CARET] = ACTIONS(187),
    [aux_sym_binary_operator_token1] = ACTIONS(189),
    [anon_sym_PIPE_GT] = ACTIONS(189),
    [anon_sym_COLON] = ACTIONS(191),
    [anon_sym_DOLLAR] = ACTIONS(193),
    [anon_sym_AT] = ACTIONS(193),
    [aux_sym__hex_literal_token1] = ACTIONS(383),
    [sym__number_literal] = ACTIONS(385),
    [anon_sym_SQUOTE] = ACTIONS(383),
    [anon_sym_DQUOTE] = ACTIONS(383),
    [sym_return] = ACTIONS(385),
    [sym_next] = ACTIONS(385),
    [sym_break] = ACTIONS(385),
    [sym_true] = ACTIONS(385),
    [sym_false] = ACTIONS(385),
    [sym_null] = ACTIONS(385),
    [sym_inf] = ACTIONS(385),
    [sym_nan] = ACTIONS(385),
    [anon_sym_NA] = ACTIONS(385),
    [anon_sym_NA_integer_] = ACTIONS(385),
    [anon_sym_NA_real_] = ACTIONS(385),
    [anon_sym_NA_complex_] = ACTIONS(385),
    [anon_sym_NA_character_] = ACTIONS(385),
    [sym_dots] = ACTIONS(385),
    [sym_dot_dot_i] = ACTIONS(383),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(383),
    [sym__newline] = ACTIONS(383),
    [sym__raw_string_literal] = ACTIONS(383),
    [sym__external_else] = ACTIONS(383),
    [sym__external_open_parenthesis] = ACTIONS(197),
    [sym__external_close_parenthesis] = ACTIONS(383),
    [sym__external_open_brace] = ACTIONS(383),
    [sym__external_open_bracket] = ACTIONS(199),
    [sym__external_open_bracket2] = ACTIONS(201),
  },
  [111] = {
    [sym_call_arguments] = STATE(888),
    [sym_subset_arguments] = STATE(892),
    [sym_subset2_arguments] = STATE(895),
    [sym__open_parenthesis] = STATE(345),
    [sym__open_bracket] = STATE(346),
    [sym__open_bracket2] = STATE(347),
    [sym_identifier] = ACTIONS(385),
    [anon_sym_BSLASH] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_EQ] = ACTIONS(385),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_for] = ACTIONS(385),
    [anon_sym_while] = ACTIONS(385),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_QMARK] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(383),
    [anon_sym_BANG] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(385),
    [anon_sym_LT_DASH] = ACTIONS(383),
    [anon_sym_LT_LT_DASH] = ACTIONS(383),
    [anon_sym_COLON_EQ] = ACTIONS(383),
    [anon_sym_DASH_GT] = ACTIONS(385),
    [anon_sym_DASH_GT_GT] = ACTIONS(383),
    [anon_sym_PIPE] = ACTIONS(385),
    [anon_sym_AMP] = ACTIONS(385),
    [anon_sym_PIPE_PIPE] = ACTIONS(383),
    [anon_sym_AMP_AMP] = ACTIONS(383),
    [anon_sym_LT] = ACTIONS(385),
    [anon_sym_LT_EQ] = ACTIONS(383),
    [anon_sym_GT] = ACTIONS(385),
    [anon_sym_GT_EQ] = ACTIONS(383),
    [anon_sym_EQ_EQ] = ACTIONS(383),
    [anon_sym_BANG_EQ] = ACTIONS(383),
    [anon_sym_STAR] = ACTIONS(385),
    [anon_sym_SLASH] = ACTIONS(383),
    [anon_sym_STAR_STAR] = ACTIONS(187),
    [anon_sym_CARET] = ACTIONS(187),
    [aux_sym_binary_operator_token1] = ACTIONS(189),
    [anon_sym_PIPE_GT] = ACTIONS(189),
    [anon_sym_COLON] = ACTIONS(191),
    [anon_sym_DOLLAR] = ACTIONS(193),
    [anon_sym_AT] = ACTIONS(193),
    [aux_sym__hex_literal_token1] = ACTIONS(383),
    [sym__number_literal] = ACTIONS(385),
    [anon_sym_SQUOTE] = ACTIONS(383),
    [anon_sym_DQUOTE] = ACTIONS(383),
    [sym_return] = ACTIONS(385),
    [sym_next] = ACTIONS(385),
    [sym_break] = ACTIONS(385),
    [sym_true] = ACTIONS(385),
    [sym_false] = ACTIONS(385),
    [sym_null] = ACTIONS(385),
    [sym_inf] = ACTIONS(385),
    [sym_nan] = ACTIONS(385),
    [anon_sym_NA] = ACTIONS(385),
    [anon_sym_NA_integer_] = ACTIONS(385),
    [anon_sym_NA_real_] = ACTIONS(385),
    [anon_sym_NA_complex_] = ACTIONS(385),
    [anon_sym_NA_character_] = ACTIONS(385),
    [sym_dots] = ACTIONS(385),
    [sym_dot_dot_i] = ACTIONS(383),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(383),
    [sym__newline] = ACTIONS(383),
    [sym__raw_string_literal] = ACTIONS(383),
    [sym__external_else] = ACTIONS(383),
    [sym__external_open_parenthesis] = ACTIONS(197),
    [sym__external_close_parenthesis] = ACTIONS(383),
    [sym__external_open_brace] = ACTIONS(383),
    [sym__external_open_bracket] = ACTIONS(199),
    [sym__external_open_bracket2] = ACTIONS(201),
  },
  [112] = {
    [sym_call_arguments] = STATE(888),
    [sym_subset_arguments] = STATE(892),
    [sym_subset2_arguments] = STATE(895),
    [sym__open_parenthesis] = STATE(345),
    [sym__open_bracket] = STATE(346),
    [sym__open_bracket2] = STATE(347),
    [sym_identifier] = ACTIONS(385),
    [anon_sym_BSLASH] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_EQ] = ACTIONS(385),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_for] = ACTIONS(385),
    [anon_sym_while] = ACTIONS(385),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_QMARK] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(383),
    [anon_sym_BANG] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(385),
    [anon_sym_LT_DASH] = ACTIONS(383),
    [anon_sym_LT_LT_DASH] = ACTIONS(383),
    [anon_sym_COLON_EQ] = ACTIONS(383),
    [anon_sym_DASH_GT] = ACTIONS(385),
    [anon_sym_DASH_GT_GT] = ACTIONS(383),
    [anon_sym_PIPE] = ACTIONS(385),
    [anon_sym_AMP] = ACTIONS(385),
    [anon_sym_PIPE_PIPE] = ACTIONS(383),
    [anon_sym_AMP_AMP] = ACTIONS(383),
    [anon_sym_LT] = ACTIONS(385),
    [anon_sym_LT_EQ] = ACTIONS(383),
    [anon_sym_GT] = ACTIONS(385),
    [anon_sym_GT_EQ] = ACTIONS(383),
    [anon_sym_EQ_EQ] = ACTIONS(383),
    [anon_sym_BANG_EQ] = ACTIONS(383),
    [anon_sym_STAR] = ACTIONS(385),
    [anon_sym_SLASH] = ACTIONS(383),
    [anon_sym_STAR_STAR] = ACTIONS(187),
    [anon_sym_CARET] = ACTIONS(187),
    [aux_sym_binary_operator_token1] = ACTIONS(383),
    [anon_sym_PIPE_GT] = ACTIONS(383),
    [anon_sym_COLON] = ACTIONS(385),
    [anon_sym_DOLLAR] = ACTIONS(193),
    [anon_sym_AT] = ACTIONS(193),
    [aux_sym__hex_literal_token1] = ACTIONS(383),
    [sym__number_literal] = ACTIONS(385),
    [anon_sym_SQUOTE] = ACTIONS(383),
    [anon_sym_DQUOTE] = ACTIONS(383),
    [sym_return] = ACTIONS(385),
    [sym_next] = ACTIONS(385),
    [sym_break] = ACTIONS(385),
    [sym_true] = ACTIONS(385),
    [sym_false] = ACTIONS(385),
    [sym_null] = ACTIONS(385),
    [sym_inf] = ACTIONS(385),
    [sym_nan] = ACTIONS(385),
    [anon_sym_NA] = ACTIONS(385),
    [anon_sym_NA_integer_] = ACTIONS(385),
    [anon_sym_NA_real_] = ACTIONS(385),
    [anon_sym_NA_complex_] = ACTIONS(385),
    [anon_sym_NA_character_] = ACTIONS(385),
    [sym_dots] = ACTIONS(385),
    [sym_dot_dot_i] = ACTIONS(383),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(383),
    [sym__newline] = ACTIONS(383),
    [sym__raw_string_literal] = ACTIONS(383),
    [sym__external_else] = ACTIONS(383),
    [sym__external_open_parenthesis] = ACTIONS(197),
    [sym__external_close_parenthesis] = ACTIONS(383),
    [sym__external_open_brace] = ACTIONS(383),
    [sym__external_open_bracket] = ACTIONS(199),
    [sym__external_open_bracket2] = ACTIONS(201),
  },
  [113] = {
    [sym_call_arguments] = STATE(888),
    [sym_subset_arguments] = STATE(892),
    [sym_subset2_arguments] = STATE(895),
    [sym__open_parenthesis] = STATE(345),
    [sym__open_bracket] = STATE(346),
    [sym__open_bracket2] = STATE(347),
    [sym_identifier] = ACTIONS(385),
    [anon_sym_BSLASH] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_EQ] = ACTIONS(385),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_for] = ACTIONS(385),
    [anon_sym_while] = ACTIONS(385),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_QMARK] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(383),
    [anon_sym_BANG] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(385),
    [anon_sym_LT_DASH] = ACTIONS(383),
    [anon_sym_LT_LT_DASH] = ACTIONS(383),
    [anon_sym_COLON_EQ] = ACTIONS(383),
    [anon_sym_DASH_GT] = ACTIONS(385),
    [anon_sym_DASH_GT_GT] = ACTIONS(383),
    [anon_sym_PIPE] = ACTIONS(385),
    [anon_sym_AMP] = ACTIONS(385),
    [anon_sym_PIPE_PIPE] = ACTIONS(383),
    [anon_sym_AMP_AMP] = ACTIONS(383),
    [anon_sym_LT] = ACTIONS(385),
    [anon_sym_LT_EQ] = ACTIONS(383),
    [anon_sym_GT] = ACTIONS(385),
    [anon_sym_GT_EQ] = ACTIONS(383),
    [anon_sym_EQ_EQ] = ACTIONS(383),
    [anon_sym_BANG_EQ] = ACTIONS(383),
    [anon_sym_STAR] = ACTIONS(385),
    [anon_sym_SLASH] = ACTIONS(383),
    [anon_sym_STAR_STAR] = ACTIONS(187),
    [anon_sym_CARET] = ACTIONS(187),
    [aux_sym_binary_operator_token1] = ACTIONS(383),
    [anon_sym_PIPE_GT] = ACTIONS(383),
    [anon_sym_COLON] = ACTIONS(191),
    [anon_sym_DOLLAR] = ACTIONS(193),
    [anon_sym_AT] = ACTIONS(193),
    [aux_sym__hex_literal_token1] = ACTIONS(383),
    [sym__number_literal] = ACTIONS(385),
    [anon_sym_SQUOTE] = ACTIONS(383),
    [anon_sym_DQUOTE] = ACTIONS(383),
    [sym_return] = ACTIONS(385),
    [sym_next] = ACTIONS(385),
    [sym_break] = ACTIONS(385),
    [sym_true] = ACTIONS(385),
    [sym_false] = ACTIONS(385),
    [sym_null] = ACTIONS(385),
    [sym_inf] = ACTIONS(385),
    [sym_nan] = ACTIONS(385),
    [anon_sym_NA] = ACTIONS(385),
    [anon_sym_NA_integer_] = ACTIONS(385),
    [anon_sym_NA_real_] = ACTIONS(385),
    [anon_sym_NA_complex_] = ACTIONS(385),
    [anon_sym_NA_character_] = ACTIONS(385),
    [sym_dots] = ACTIONS(385),
    [sym_dot_dot_i] = ACTIONS(383),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(383),
    [sym__newline] = ACTIONS(383),
    [sym__raw_string_literal] = ACTIONS(383),
    [sym__external_else] = ACTIONS(383),
    [sym__external_open_parenthesis] = ACTIONS(197),
    [sym__external_close_parenthesis] = ACTIONS(383),
    [sym__external_open_brace] = ACTIONS(383),
    [sym__external_open_bracket] = ACTIONS(199),
    [sym__external_open_bracket2] = ACTIONS(201),
  },
  [114] = {
    [sym_call_arguments] = STATE(888),
    [sym_subset_arguments] = STATE(892),
    [sym_subset2_arguments] = STATE(895),
    [sym__open_parenthesis] = STATE(345),
    [sym__open_bracket] = STATE(346),
    [sym__open_bracket2] = STATE(347),
    [sym_identifier] = ACTIONS(385),
    [anon_sym_BSLASH] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_EQ] = ACTIONS(385),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_for] = ACTIONS(385),
    [anon_sym_while] = ACTIONS(385),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_QMARK] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(383),
    [anon_sym_BANG] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(385),
    [anon_sym_LT_DASH] = ACTIONS(383),
    [anon_sym_LT_LT_DASH] = ACTIONS(383),
    [anon_sym_COLON_EQ] = ACTIONS(383),
    [anon_sym_DASH_GT] = ACTIONS(385),
    [anon_sym_DASH_GT_GT] = ACTIONS(383),
    [anon_sym_PIPE] = ACTIONS(385),
    [anon_sym_AMP] = ACTIONS(385),
    [anon_sym_PIPE_PIPE] = ACTIONS(383),
    [anon_sym_AMP_AMP] = ACTIONS(383),
    [anon_sym_LT] = ACTIONS(385),
    [anon_sym_LT_EQ] = ACTIONS(383),
    [anon_sym_GT] = ACTIONS(385),
    [anon_sym_GT_EQ] = ACTIONS(383),
    [anon_sym_EQ_EQ] = ACTIONS(383),
    [anon_sym_BANG_EQ] = ACTIONS(383),
    [anon_sym_STAR] = ACTIONS(385),
    [anon_sym_SLASH] = ACTIONS(383),
    [anon_sym_STAR_STAR] = ACTIONS(187),
    [anon_sym_CARET] = ACTIONS(187),
    [aux_sym_binary_operator_token1] = ACTIONS(383),
    [anon_sym_PIPE_GT] = ACTIONS(383),
    [anon_sym_COLON] = ACTIONS(385),
    [anon_sym_DOLLAR] = ACTIONS(193),
    [anon_sym_AT] = ACTIONS(193),
    [aux_sym__hex_literal_token1] = ACTIONS(383),
    [sym__number_literal] = ACTIONS(385),
    [anon_sym_SQUOTE] = ACTIONS(383),
    [anon_sym_DQUOTE] = ACTIONS(383),
    [sym_return] = ACTIONS(385),
    [sym_next] = ACTIONS(385),
    [sym_break] = ACTIONS(385),
    [sym_true] = ACTIONS(385),
    [sym_false] = ACTIONS(385),
    [sym_null] = ACTIONS(385),
    [sym_inf] = ACTIONS(385),
    [sym_nan] = ACTIONS(385),
    [anon_sym_NA] = ACTIONS(385),
    [anon_sym_NA_integer_] = ACTIONS(385),
    [anon_sym_NA_real_] = ACTIONS(385),
    [anon_sym_NA_complex_] = ACTIONS(385),
    [anon_sym_NA_character_] = ACTIONS(385),
    [sym_dots] = ACTIONS(385),
    [sym_dot_dot_i] = ACTIONS(383),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(383),
    [sym__newline] = ACTIONS(383),
    [sym__raw_string_literal] = ACTIONS(383),
    [sym__external_else] = ACTIONS(383),
    [sym__external_open_parenthesis] = ACTIONS(197),
    [sym__external_close_parenthesis] = ACTIONS(383),
    [sym__external_open_brace] = ACTIONS(383),
    [sym__external_open_bracket] = ACTIONS(199),
    [sym__external_open_bracket2] = ACTIONS(201),
  },
  [115] = {
    [sym_function_definition] = STATE(631),
    [sym_if_statement] = STATE(631),
    [sym_for_statement] = STATE(631),
    [sym_while_statement] = STATE(631),
    [sym_repeat_statement] = STATE(631),
    [sym_braced_expression] = STATE(631),
    [sym_parenthesized_expression] = STATE(631),
    [sym_call] = STATE(631),
    [sym_subset] = STATE(631),
    [sym_subset2] = STATE(631),
    [sym__argument] = STATE(1934),
    [sym_argument] = STATE(1937),
    [sym__argument_named] = STATE(1909),
    [sym__argument_unnamed] = STATE(1932),
    [sym__argument_value] = STATE(1920),
    [sym_unary_operator] = STATE(631),
    [sym_binary_operator] = STATE(631),
    [sym_extract_operator] = STATE(631),
    [sym_namespace_operator] = STATE(631),
    [sym_integer] = STATE(631),
    [sym_complex] = STATE(631),
    [sym_float] = STATE(631),
    [sym__hex_literal] = STATE(752),
    [sym__float_literal] = STATE(752),
    [sym_string] = STATE(766),
    [sym__single_quoted_string] = STATE(753),
    [sym__double_quoted_string] = STATE(754),
    [sym_na] = STATE(631),
    [sym__expression] = STATE(631),
    [sym__string_or_identifier] = STATE(2143),
    [sym__open_parenthesis] = STATE(869),
    [sym__open_brace] = STATE(764),
    [sym__close_bracket] = STATE(805),
    [aux_sym_call_arguments_repeat1] = STATE(529),
    [sym_identifier] = ACTIONS(387),
    [anon_sym_BSLASH] = ACTIONS(389),
    [anon_sym_function] = ACTIONS(391),
    [anon_sym_if] = ACTIONS(393),
    [anon_sym_for] = ACTIONS(395),
    [anon_sym_while] = ACTIONS(397),
    [anon_sym_repeat] = ACTIONS(399),
    [anon_sym_QMARK] = ACTIONS(401),
    [anon_sym_TILDE] = ACTIONS(403),
    [anon_sym_BANG] = ACTIONS(405),
    [anon_sym_PLUS] = ACTIONS(407),
    [anon_sym_DASH] = ACTIONS(407),
    [aux_sym__hex_literal_token1] = ACTIONS(409),
    [sym__number_literal] = ACTIONS(411),
    [anon_sym_SQUOTE] = ACTIONS(413),
    [anon_sym_DQUOTE] = ACTIONS(415),
    [sym_return] = ACTIONS(417),
    [sym_next] = ACTIONS(417),
    [sym_break] = ACTIONS(417),
    [sym_true] = ACTIONS(417),
    [sym_false] = ACTIONS(417),
    [sym_null] = ACTIONS(417),
    [sym_inf] = ACTIONS(417),
    [sym_nan] = ACTIONS(417),
    [anon_sym_NA] = ACTIONS(419),
    [anon_sym_NA_integer_] = ACTIONS(419),
    [anon_sym_NA_real_] = ACTIONS(419),
    [anon_sym_NA_complex_] = ACTIONS(419),
    [anon_sym_NA_character_] = ACTIONS(419),
    [sym_dots] = ACTIONS(421),
    [sym_dot_dot_i] = ACTIONS(423),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(425),
    [sym__newline] = ACTIONS(427),
    [sym__raw_string_literal] = ACTIONS(429),
    [sym__external_open_parenthesis] = ACTIONS(431),
    [sym__external_open_brace] = ACTIONS(433),
    [sym__external_close_bracket] = ACTIONS(547),
  },
  [116] = {
    [sym_function_definition] = STATE(568),
    [sym_if_statement] = STATE(568),
    [sym_for_statement] = STATE(568),
    [sym_while_statement] = STATE(568),
    [sym_repeat_statement] = STATE(568),
    [sym_braced_expression] = STATE(568),
    [sym_parenthesized_expression] = STATE(568),
    [sym_call] = STATE(568),
    [sym_subset] = STATE(568),
    [sym_subset2] = STATE(568),
    [sym__argument] = STATE(1928),
    [sym_argument] = STATE(1930),
    [sym__argument_named] = STATE(1908),
    [sym__argument_unnamed] = STATE(1933),
    [sym__argument_value] = STATE(1936),
    [sym_unary_operator] = STATE(568),
    [sym_binary_operator] = STATE(568),
    [sym_extract_operator] = STATE(568),
    [sym_namespace_operator] = STATE(568),
    [sym_integer] = STATE(568),
    [sym_complex] = STATE(568),
    [sym_float] = STATE(568),
    [sym__hex_literal] = STATE(703),
    [sym__float_literal] = STATE(703),
    [sym_string] = STATE(736),
    [sym__single_quoted_string] = STATE(705),
    [sym__double_quoted_string] = STATE(706),
    [sym_na] = STATE(568),
    [sym__expression] = STATE(568),
    [sym__string_or_identifier] = STATE(2142),
    [sym__open_parenthesis] = STATE(874),
    [sym__open_brace] = STATE(765),
    [sym__close_bracket2] = STATE(806),
    [aux_sym_call_arguments_repeat1] = STATE(585),
    [sym_identifier] = ACTIONS(437),
    [anon_sym_BSLASH] = ACTIONS(439),
    [anon_sym_function] = ACTIONS(441),
    [anon_sym_if] = ACTIONS(443),
    [anon_sym_for] = ACTIONS(445),
    [anon_sym_while] = ACTIONS(447),
    [anon_sym_repeat] = ACTIONS(449),
    [anon_sym_QMARK] = ACTIONS(451),
    [anon_sym_TILDE] = ACTIONS(453),
    [anon_sym_BANG] = ACTIONS(455),
    [anon_sym_PLUS] = ACTIONS(457),
    [anon_sym_DASH] = ACTIONS(457),
    [aux_sym__hex_literal_token1] = ACTIONS(459),
    [sym__number_literal] = ACTIONS(461),
    [anon_sym_SQUOTE] = ACTIONS(463),
    [anon_sym_DQUOTE] = ACTIONS(465),
    [sym_return] = ACTIONS(467),
    [sym_next] = ACTIONS(467),
    [sym_break] = ACTIONS(467),
    [sym_true] = ACTIONS(467),
    [sym_false] = ACTIONS(467),
    [sym_null] = ACTIONS(467),
    [sym_inf] = ACTIONS(467),
    [sym_nan] = ACTIONS(467),
    [anon_sym_NA] = ACTIONS(469),
    [anon_sym_NA_integer_] = ACTIONS(469),
    [anon_sym_NA_real_] = ACTIONS(469),
    [anon_sym_NA_complex_] = ACTIONS(469),
    [anon_sym_NA_character_] = ACTIONS(469),
    [sym_dots] = ACTIONS(471),
    [sym_dot_dot_i] = ACTIONS(473),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(475),
    [sym__newline] = ACTIONS(477),
    [sym__raw_string_literal] = ACTIONS(479),
    [sym__external_open_parenthesis] = ACTIONS(481),
    [sym__external_open_brace] = ACTIONS(483),
    [sym__external_close_bracket2] = ACTIONS(549),
  },
  [117] = {
    [sym_call_arguments] = STATE(888),
    [sym_subset_arguments] = STATE(892),
    [sym_subset2_arguments] = STATE(895),
    [sym__open_parenthesis] = STATE(345),
    [sym__open_bracket] = STATE(346),
    [sym__open_bracket2] = STATE(347),
    [sym_identifier] = ACTIONS(489),
    [anon_sym_BSLASH] = ACTIONS(487),
    [anon_sym_function] = ACTIONS(489),
    [anon_sym_EQ] = ACTIONS(157),
    [anon_sym_if] = ACTIONS(489),
    [anon_sym_for] = ACTIONS(489),
    [anon_sym_while] = ACTIONS(489),
    [anon_sym_repeat] = ACTIONS(489),
    [anon_sym_QMARK] = ACTIONS(487),
    [anon_sym_TILDE] = ACTIONS(159),
    [anon_sym_BANG] = ACTIONS(489),
    [anon_sym_PLUS] = ACTIONS(161),
    [anon_sym_DASH] = ACTIONS(163),
    [anon_sym_LT_DASH] = ACTIONS(165),
    [anon_sym_LT_LT_DASH] = ACTIONS(165),
    [anon_sym_COLON_EQ] = ACTIONS(165),
    [anon_sym_DASH_GT] = ACTIONS(167),
    [anon_sym_DASH_GT_GT] = ACTIONS(169),
    [anon_sym_PIPE] = ACTIONS(171),
    [anon_sym_AMP] = ACTIONS(173),
    [anon_sym_PIPE_PIPE] = ACTIONS(175),
    [anon_sym_AMP_AMP] = ACTIONS(177),
    [anon_sym_LT] = ACTIONS(179),
    [anon_sym_LT_EQ] = ACTIONS(181),
    [anon_sym_GT] = ACTIONS(179),
    [anon_sym_GT_EQ] = ACTIONS(181),
    [anon_sym_EQ_EQ] = ACTIONS(181),
    [anon_sym_BANG_EQ] = ACTIONS(181),
    [anon_sym_STAR] = ACTIONS(183),
    [anon_sym_SLASH] = ACTIONS(185),
    [anon_sym_STAR_STAR] = ACTIONS(187),
    [anon_sym_CARET] = ACTIONS(187),
    [aux_sym_binary_operator_token1] = ACTIONS(189),
    [anon_sym_PIPE_GT] = ACTIONS(189),
    [anon_sym_COLON] = ACTIONS(191),
    [anon_sym_DOLLAR] = ACTIONS(193),
    [anon_sym_AT] = ACTIONS(193),
    [aux_sym__hex_literal_token1] = ACTIONS(487),
    [sym__number_literal] = ACTIONS(489),
    [anon_sym_SQUOTE] = ACTIONS(487),
    [anon_sym_DQUOTE] = ACTIONS(487),
    [sym_return] = ACTIONS(489),
    [sym_next] = ACTIONS(489),
    [sym_break] = ACTIONS(489),
    [sym_true] = ACTIONS(489),
    [sym_false] = ACTIONS(489),
    [sym_null] = ACTIONS(489),
    [sym_inf] = ACTIONS(489),
    [sym_nan] = ACTIONS(489),
    [anon_sym_NA] = ACTIONS(489),
    [anon_sym_NA_integer_] = ACTIONS(489),
    [anon_sym_NA_real_] = ACTIONS(489),
    [anon_sym_NA_complex_] = ACTIONS(489),
    [anon_sym_NA_character_] = ACTIONS(489),
    [sym_dots] = ACTIONS(489),
    [sym_dot_dot_i] = ACTIONS(487),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(487),
    [sym__newline] = ACTIONS(487),
    [sym__raw_string_literal] = ACTIONS(487),
    [sym__external_else] = ACTIONS(487),
    [sym__external_open_parenthesis] = ACTIONS(197),
    [sym__external_close_parenthesis] = ACTIONS(487),
    [sym__external_open_brace] = ACTIONS(487),
    [sym__external_open_bracket] = ACTIONS(199),
    [sym__external_open_bracket2] = ACTIONS(201),
  },
  [118] = {
    [sym_call_arguments] = STATE(888),
    [sym_subset_arguments] = STATE(892),
    [sym_subset2_arguments] = STATE(895),
    [sym__open_parenthesis] = STATE(345),
    [sym__open_bracket] = STATE(346),
    [sym__open_bracket2] = STATE(347),
    [sym_identifier] = ACTIONS(493),
    [anon_sym_BSLASH] = ACTIONS(491),
    [anon_sym_function] = ACTIONS(493),
    [anon_sym_EQ] = ACTIONS(157),
    [anon_sym_if] = ACTIONS(493),
    [anon_sym_for] = ACTIONS(493),
    [anon_sym_while] = ACTIONS(493),
    [anon_sym_repeat] = ACTIONS(493),
    [anon_sym_QMARK] = ACTIONS(491),
    [anon_sym_TILDE] = ACTIONS(159),
    [anon_sym_BANG] = ACTIONS(493),
    [anon_sym_PLUS] = ACTIONS(161),
    [anon_sym_DASH] = ACTIONS(163),
    [anon_sym_LT_DASH] = ACTIONS(491),
    [anon_sym_LT_LT_DASH] = ACTIONS(491),
    [anon_sym_COLON_EQ] = ACTIONS(491),
    [anon_sym_DASH_GT] = ACTIONS(167),
    [anon_sym_DASH_GT_GT] = ACTIONS(169),
    [anon_sym_PIPE] = ACTIONS(171),
    [anon_sym_AMP] = ACTIONS(173),
    [anon_sym_PIPE_PIPE] = ACTIONS(175),
    [anon_sym_AMP_AMP] = ACTIONS(177),
    [anon_sym_LT] = ACTIONS(179),
    [anon_sym_LT_EQ] = ACTIONS(181),
    [anon_sym_GT] = ACTIONS(179),
    [anon_sym_GT_EQ] = ACTIONS(181),
    [anon_sym_EQ_EQ] = ACTIONS(181),
    [anon_sym_BANG_EQ] = ACTIONS(181),
    [anon_sym_STAR] = ACTIONS(183),
    [anon_sym_SLASH] = ACTIONS(185),
    [anon_sym_STAR_STAR] = ACTIONS(187),
    [anon_sym_CARET] = ACTIONS(187),
    [aux_sym_binary_operator_token1] = ACTIONS(189),
    [anon_sym_PIPE_GT] = ACTIONS(189),
    [anon_sym_COLON] = ACTIONS(191),
    [anon_sym_DOLLAR] = ACTIONS(193),
    [anon_sym_AT] = ACTIONS(193),
    [aux_sym__hex_literal_token1] = ACTIONS(491),
    [sym__number_literal] = ACTIONS(493),
    [anon_sym_SQUOTE] = ACTIONS(491),
    [anon_sym_DQUOTE] = ACTIONS(491),
    [sym_return] = ACTIONS(493),
    [sym_next] = ACTIONS(493),
    [sym_break] = ACTIONS(493),
    [sym_true] = ACTIONS(493),
    [sym_false] = ACTIONS(493),
    [sym_null] = ACTIONS(493),
    [sym_inf] = ACTIONS(493),
    [sym_nan] = ACTIONS(493),
    [anon_sym_NA] = ACTIONS(493),
    [anon_sym_NA_integer_] = ACTIONS(493),
    [anon_sym_NA_real_] = ACTIONS(493),
    [anon_sym_NA_complex_] = ACTIONS(493),
    [anon_sym_NA_character_] = ACTIONS(493),
    [sym_dots] = ACTIONS(493),
    [sym_dot_dot_i] = ACTIONS(491),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(491),
    [sym__newline] = ACTIONS(491),
    [sym__raw_string_literal] = ACTIONS(491),
    [sym__external_else] = ACTIONS(491),
    [sym__external_open_parenthesis] = ACTIONS(197),
    [sym__external_close_parenthesis] = ACTIONS(491),
    [sym__external_open_brace] = ACTIONS(491),
    [sym__external_open_bracket] = ACTIONS(199),
    [sym__external_open_bracket2] = ACTIONS(201),
  },
  [119] = {
    [sym_call_arguments] = STATE(888),
    [sym_subset_arguments] = STATE(892),
    [sym_subset2_arguments] = STATE(895),
    [sym__open_parenthesis] = STATE(345),
    [sym__open_bracket] = STATE(346),
    [sym__open_bracket2] = STATE(347),
    [sym_identifier] = ACTIONS(493),
    [anon_sym_BSLASH] = ACTIONS(491),
    [anon_sym_function] = ACTIONS(493),
    [anon_sym_EQ] = ACTIONS(157),
    [anon_sym_if] = ACTIONS(493),
    [anon_sym_for] = ACTIONS(493),
    [anon_sym_while] = ACTIONS(493),
    [anon_sym_repeat] = ACTIONS(493),
    [anon_sym_QMARK] = ACTIONS(491),
    [anon_sym_TILDE] = ACTIONS(159),
    [anon_sym_BANG] = ACTIONS(493),
    [anon_sym_PLUS] = ACTIONS(161),
    [anon_sym_DASH] = ACTIONS(163),
    [anon_sym_LT_DASH] = ACTIONS(165),
    [anon_sym_LT_LT_DASH] = ACTIONS(165),
    [anon_sym_COLON_EQ] = ACTIONS(165),
    [anon_sym_DASH_GT] = ACTIONS(167),
    [anon_sym_DASH_GT_GT] = ACTIONS(169),
    [anon_sym_PIPE] = ACTIONS(171),
    [anon_sym_AMP] = ACTIONS(173),
    [anon_sym_PIPE_PIPE] = ACTIONS(175),
    [anon_sym_AMP_AMP] = ACTIONS(177),
    [anon_sym_LT] = ACTIONS(179),
    [anon_sym_LT_EQ] = ACTIONS(181),
    [anon_sym_GT] = ACTIONS(179),
    [anon_sym_GT_EQ] = ACTIONS(181),
    [anon_sym_EQ_EQ] = ACTIONS(181),
    [anon_sym_BANG_EQ] = ACTIONS(181),
    [anon_sym_STAR] = ACTIONS(183),
    [anon_sym_SLASH] = ACTIONS(185),
    [anon_sym_STAR_STAR] = ACTIONS(187),
    [anon_sym_CARET] = ACTIONS(187),
    [aux_sym_binary_operator_token1] = ACTIONS(189),
    [anon_sym_PIPE_GT] = ACTIONS(189),
    [anon_sym_COLON] = ACTIONS(191),
    [anon_sym_DOLLAR] = ACTIONS(193),
    [anon_sym_AT] = ACTIONS(193),
    [aux_sym__hex_literal_token1] = ACTIONS(491),
    [sym__number_literal] = ACTIONS(493),
    [anon_sym_SQUOTE] = ACTIONS(491),
    [anon_sym_DQUOTE] = ACTIONS(491),
    [sym_return] = ACTIONS(493),
    [sym_next] = ACTIONS(493),
    [sym_break] = ACTIONS(493),
    [sym_true] = ACTIONS(493),
    [sym_false] = ACTIONS(493),
    [sym_null] = ACTIONS(493),
    [sym_inf] = ACTIONS(493),
    [sym_nan] = ACTIONS(493),
    [anon_sym_NA] = ACTIONS(493),
    [anon_sym_NA_integer_] = ACTIONS(493),
    [anon_sym_NA_real_] = ACTIONS(493),
    [anon_sym_NA_complex_] = ACTIONS(493),
    [anon_sym_NA_character_] = ACTIONS(493),
    [sym_dots] = ACTIONS(493),
    [sym_dot_dot_i] = ACTIONS(491),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(491),
    [sym__newline] = ACTIONS(491),
    [sym__raw_string_literal] = ACTIONS(491),
    [sym__external_else] = ACTIONS(491),
    [sym__external_open_parenthesis] = ACTIONS(197),
    [sym__external_close_parenthesis] = ACTIONS(491),
    [sym__external_open_brace] = ACTIONS(491),
    [sym__external_open_bracket] = ACTIONS(199),
    [sym__external_open_bracket2] = ACTIONS(201),
  },
  [120] = {
    [sym_call_arguments] = STATE(888),
    [sym_subset_arguments] = STATE(892),
    [sym_subset2_arguments] = STATE(895),
    [sym__open_parenthesis] = STATE(345),
    [sym__open_bracket] = STATE(346),
    [sym__open_bracket2] = STATE(347),
    [sym_identifier] = ACTIONS(493),
    [anon_sym_BSLASH] = ACTIONS(491),
    [anon_sym_function] = ACTIONS(493),
    [anon_sym_EQ] = ACTIONS(493),
    [anon_sym_if] = ACTIONS(493),
    [anon_sym_for] = ACTIONS(493),
    [anon_sym_while] = ACTIONS(493),
    [anon_sym_repeat] = ACTIONS(493),
    [anon_sym_QMARK] = ACTIONS(491),
    [anon_sym_TILDE] = ACTIONS(491),
    [anon_sym_BANG] = ACTIONS(493),
    [anon_sym_PLUS] = ACTIONS(161),
    [anon_sym_DASH] = ACTIONS(163),
    [anon_sym_LT_DASH] = ACTIONS(491),
    [anon_sym_LT_LT_DASH] = ACTIONS(491),
    [anon_sym_COLON_EQ] = ACTIONS(491),
    [anon_sym_DASH_GT] = ACTIONS(493),
    [anon_sym_DASH_GT_GT] = ACTIONS(491),
    [anon_sym_PIPE] = ACTIONS(171),
    [anon_sym_AMP] = ACTIONS(173),
    [anon_sym_PIPE_PIPE] = ACTIONS(175),
    [anon_sym_AMP_AMP] = ACTIONS(177),
    [anon_sym_LT] = ACTIONS(179),
    [anon_sym_LT_EQ] = ACTIONS(181),
    [anon_sym_GT] = ACTIONS(179),
    [anon_sym_GT_EQ] = ACTIONS(181),
    [anon_sym_EQ_EQ] = ACTIONS(181),
    [anon_sym_BANG_EQ] = ACTIONS(181),
    [anon_sym_STAR] = ACTIONS(183),
    [anon_sym_SLASH] = ACTIONS(185),
    [anon_sym_STAR_STAR] = ACTIONS(187),
    [anon_sym_CARET] = ACTIONS(187),
    [aux_sym_binary_operator_token1] = ACTIONS(189),
    [anon_sym_PIPE_GT] = ACTIONS(189),
    [anon_sym_COLON] = ACTIONS(191),
    [anon_sym_DOLLAR] = ACTIONS(193),
    [anon_sym_AT] = ACTIONS(193),
    [aux_sym__hex_literal_token1] = ACTIONS(491),
    [sym__number_literal] = ACTIONS(493),
    [anon_sym_SQUOTE] = ACTIONS(491),
    [anon_sym_DQUOTE] = ACTIONS(491),
    [sym_return] = ACTIONS(493),
    [sym_next] = ACTIONS(493),
    [sym_break] = ACTIONS(493),
    [sym_true] = ACTIONS(493),
    [sym_false] = ACTIONS(493),
    [sym_null] = ACTIONS(493),
    [sym_inf] = ACTIONS(493),
    [sym_nan] = ACTIONS(493),
    [anon_sym_NA] = ACTIONS(493),
    [anon_sym_NA_integer_] = ACTIONS(493),
    [anon_sym_NA_real_] = ACTIONS(493),
    [anon_sym_NA_complex_] = ACTIONS(493),
    [anon_sym_NA_character_] = ACTIONS(493),
    [sym_dots] = ACTIONS(493),
    [sym_dot_dot_i] = ACTIONS(491),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(491),
    [sym__newline] = ACTIONS(491),
    [sym__raw_string_literal] = ACTIONS(491),
    [sym__external_else] = ACTIONS(491),
    [sym__external_open_parenthesis] = ACTIONS(197),
    [sym__external_close_parenthesis] = ACTIONS(491),
    [sym__external_open_brace] = ACTIONS(491),
    [sym__external_open_bracket] = ACTIONS(199),
    [sym__external_open_bracket2] = ACTIONS(201),
  },
  [121] = {
    [sym_call_arguments] = STATE(888),
    [sym_subset_arguments] = STATE(892),
    [sym_subset2_arguments] = STATE(895),
    [sym__open_parenthesis] = STATE(345),
    [sym__open_bracket] = STATE(346),
    [sym__open_bracket2] = STATE(347),
    [sym_identifier] = ACTIONS(493),
    [anon_sym_BSLASH] = ACTIONS(491),
    [anon_sym_function] = ACTIONS(493),
    [anon_sym_EQ] = ACTIONS(493),
    [anon_sym_if] = ACTIONS(493),
    [anon_sym_for] = ACTIONS(493),
    [anon_sym_while] = ACTIONS(493),
    [anon_sym_repeat] = ACTIONS(493),
    [anon_sym_QMARK] = ACTIONS(491),
    [anon_sym_TILDE] = ACTIONS(491),
    [anon_sym_BANG] = ACTIONS(493),
    [anon_sym_PLUS] = ACTIONS(491),
    [anon_sym_DASH] = ACTIONS(493),
    [anon_sym_LT_DASH] = ACTIONS(491),
    [anon_sym_LT_LT_DASH] = ACTIONS(491),
    [anon_sym_COLON_EQ] = ACTIONS(491),
    [anon_sym_DASH_GT] = ACTIONS(493),
    [anon_sym_DASH_GT_GT] = ACTIONS(491),
    [anon_sym_PIPE] = ACTIONS(493),
    [anon_sym_AMP] = ACTIONS(493),
    [anon_sym_PIPE_PIPE] = ACTIONS(491),
    [anon_sym_AMP_AMP] = ACTIONS(491),
    [anon_sym_LT] = ACTIONS(493),
    [anon_sym_LT_EQ] = ACTIONS(491),
    [anon_sym_GT] = ACTIONS(493),
    [anon_sym_GT_EQ] = ACTIONS(491),
    [anon_sym_EQ_EQ] = ACTIONS(491),
    [anon_sym_BANG_EQ] = ACTIONS(491),
    [anon_sym_STAR] = ACTIONS(183),
    [anon_sym_SLASH] = ACTIONS(185),
    [anon_sym_STAR_STAR] = ACTIONS(187),
    [anon_sym_CARET] = ACTIONS(187),
    [aux_sym_binary_operator_token1] = ACTIONS(189),
    [anon_sym_PIPE_GT] = ACTIONS(189),
    [anon_sym_COLON] = ACTIONS(191),
    [anon_sym_DOLLAR] = ACTIONS(193),
    [anon_sym_AT] = ACTIONS(193),
    [aux_sym__hex_literal_token1] = ACTIONS(491),
    [sym__number_literal] = ACTIONS(493),
    [anon_sym_SQUOTE] = ACTIONS(491),
    [anon_sym_DQUOTE] = ACTIONS(491),
    [sym_return] = ACTIONS(493),
    [sym_next] = ACTIONS(493),
    [sym_break] = ACTIONS(493),
    [sym_true] = ACTIONS(493),
    [sym_false] = ACTIONS(493),
    [sym_null] = ACTIONS(493),
    [sym_inf] = ACTIONS(493),
    [sym_nan] = ACTIONS(493),
    [anon_sym_NA] = ACTIONS(493),
    [anon_sym_NA_integer_] = ACTIONS(493),
    [anon_sym_NA_real_] = ACTIONS(493),
    [anon_sym_NA_complex_] = ACTIONS(493),
    [anon_sym_NA_character_] = ACTIONS(493),
    [sym_dots] = ACTIONS(493),
    [sym_dot_dot_i] = ACTIONS(491),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(491),
    [sym__newline] = ACTIONS(491),
    [sym__raw_string_literal] = ACTIONS(491),
    [sym__external_else] = ACTIONS(491),
    [sym__external_open_parenthesis] = ACTIONS(197),
    [sym__external_close_parenthesis] = ACTIONS(491),
    [sym__external_open_brace] = ACTIONS(491),
    [sym__external_open_bracket] = ACTIONS(199),
    [sym__external_open_bracket2] = ACTIONS(201),
  },
  [122] = {
    [sym_call_arguments] = STATE(888),
    [sym_subset_arguments] = STATE(892),
    [sym_subset2_arguments] = STATE(895),
    [sym__open_parenthesis] = STATE(345),
    [sym__open_bracket] = STATE(346),
    [sym__open_bracket2] = STATE(347),
    [sym_identifier] = ACTIONS(493),
    [anon_sym_BSLASH] = ACTIONS(491),
    [anon_sym_function] = ACTIONS(493),
    [anon_sym_EQ] = ACTIONS(157),
    [anon_sym_if] = ACTIONS(493),
    [anon_sym_for] = ACTIONS(493),
    [anon_sym_while] = ACTIONS(493),
    [anon_sym_repeat] = ACTIONS(493),
    [anon_sym_QMARK] = ACTIONS(491),
    [anon_sym_TILDE] = ACTIONS(159),
    [anon_sym_BANG] = ACTIONS(493),
    [anon_sym_PLUS] = ACTIONS(161),
    [anon_sym_DASH] = ACTIONS(163),
    [anon_sym_LT_DASH] = ACTIONS(165),
    [anon_sym_LT_LT_DASH] = ACTIONS(165),
    [anon_sym_COLON_EQ] = ACTIONS(165),
    [anon_sym_DASH_GT] = ACTIONS(167),
    [anon_sym_DASH_GT_GT] = ACTIONS(169),
    [anon_sym_PIPE] = ACTIONS(171),
    [anon_sym_AMP] = ACTIONS(173),
    [anon_sym_PIPE_PIPE] = ACTIONS(175),
    [anon_sym_AMP_AMP] = ACTIONS(177),
    [anon_sym_LT] = ACTIONS(179),
    [anon_sym_LT_EQ] = ACTIONS(181),
    [anon_sym_GT] = ACTIONS(179),
    [anon_sym_GT_EQ] = ACTIONS(181),
    [anon_sym_EQ_EQ] = ACTIONS(181),
    [anon_sym_BANG_EQ] = ACTIONS(181),
    [anon_sym_STAR] = ACTIONS(183),
    [anon_sym_SLASH] = ACTIONS(185),
    [anon_sym_STAR_STAR] = ACTIONS(187),
    [anon_sym_CARET] = ACTIONS(187),
    [aux_sym_binary_operator_token1] = ACTIONS(189),
    [anon_sym_PIPE_GT] = ACTIONS(189),
    [anon_sym_COLON] = ACTIONS(191),
    [anon_sym_DOLLAR] = ACTIONS(193),
    [anon_sym_AT] = ACTIONS(193),
    [aux_sym__hex_literal_token1] = ACTIONS(491),
    [sym__number_literal] = ACTIONS(493),
    [anon_sym_SQUOTE] = ACTIONS(491),
    [anon_sym_DQUOTE] = ACTIONS(491),
    [sym_return] = ACTIONS(493),
    [sym_next] = ACTIONS(493),
    [sym_break] = ACTIONS(493),
    [sym_true] = ACTIONS(493),
    [sym_false] = ACTIONS(493),
    [sym_null] = ACTIONS(493),
    [sym_inf] = ACTIONS(493),
    [sym_nan] = ACTIONS(493),
    [anon_sym_NA] = ACTIONS(493),
    [anon_sym_NA_integer_] = ACTIONS(493),
    [anon_sym_NA_real_] = ACTIONS(493),
    [anon_sym_NA_complex_] = ACTIONS(493),
    [anon_sym_NA_character_] = ACTIONS(493),
    [sym_dots] = ACTIONS(493),
    [sym_dot_dot_i] = ACTIONS(491),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(491),
    [sym__newline] = ACTIONS(491),
    [sym__raw_string_literal] = ACTIONS(491),
    [sym__external_else] = ACTIONS(491),
    [sym__external_open_parenthesis] = ACTIONS(197),
    [sym__external_close_parenthesis] = ACTIONS(491),
    [sym__external_open_brace] = ACTIONS(491),
    [sym__external_open_bracket] = ACTIONS(199),
    [sym__external_open_bracket2] = ACTIONS(201),
  },
  [123] = {
    [sym_call_arguments] = STATE(888),
    [sym_subset_arguments] = STATE(892),
    [sym_subset2_arguments] = STATE(895),
    [sym__open_parenthesis] = STATE(345),
    [sym__open_bracket] = STATE(346),
    [sym__open_bracket2] = STATE(347),
    [sym_identifier] = ACTIONS(493),
    [anon_sym_BSLASH] = ACTIONS(491),
    [anon_sym_function] = ACTIONS(493),
    [anon_sym_EQ] = ACTIONS(493),
    [anon_sym_if] = ACTIONS(493),
    [anon_sym_for] = ACTIONS(493),
    [anon_sym_while] = ACTIONS(493),
    [anon_sym_repeat] = ACTIONS(493),
    [anon_sym_QMARK] = ACTIONS(491),
    [anon_sym_TILDE] = ACTIONS(159),
    [anon_sym_BANG] = ACTIONS(493),
    [anon_sym_PLUS] = ACTIONS(161),
    [anon_sym_DASH] = ACTIONS(163),
    [anon_sym_LT_DASH] = ACTIONS(491),
    [anon_sym_LT_LT_DASH] = ACTIONS(491),
    [anon_sym_COLON_EQ] = ACTIONS(491),
    [anon_sym_DASH_GT] = ACTIONS(493),
    [anon_sym_DASH_GT_GT] = ACTIONS(491),
    [anon_sym_PIPE] = ACTIONS(171),
    [anon_sym_AMP] = ACTIONS(173),
    [anon_sym_PIPE_PIPE] = ACTIONS(175),
    [anon_sym_AMP_AMP] = ACTIONS(177),
    [anon_sym_LT] = ACTIONS(179),
    [anon_sym_LT_EQ] = ACTIONS(181),
    [anon_sym_GT] = ACTIONS(179),
    [anon_sym_GT_EQ] = ACTIONS(181),
    [anon_sym_EQ_EQ] = ACTIONS(181),
    [anon_sym_BANG_EQ] = ACTIONS(181),
    [anon_sym_STAR] = ACTIONS(183),
    [anon_sym_SLASH] = ACTIONS(185),
    [anon_sym_STAR_STAR] = ACTIONS(187),
    [anon_sym_CARET] = ACTIONS(187),
    [aux_sym_binary_operator_token1] = ACTIONS(189),
    [anon_sym_PIPE_GT] = ACTIONS(189),
    [anon_sym_COLON] = ACTIONS(191),
    [anon_sym_DOLLAR] = ACTIONS(193),
    [anon_sym_AT] = ACTIONS(193),
    [aux_sym__hex_literal_token1] = ACTIONS(491),
    [sym__number_literal] = ACTIONS(493),
    [anon_sym_SQUOTE] = ACTIONS(491),
    [anon_sym_DQUOTE] = ACTIONS(491),
    [sym_return] = ACTIONS(493),
    [sym_next] = ACTIONS(493),
    [sym_break] = ACTIONS(493),
    [sym_true] = ACTIONS(493),
    [sym_false] = ACTIONS(493),
    [sym_null] = ACTIONS(493),
    [sym_inf] = ACTIONS(493),
    [sym_nan] = ACTIONS(493),
    [anon_sym_NA] = ACTIONS(493),
    [anon_sym_NA_integer_] = ACTIONS(493),
    [anon_sym_NA_real_] = ACTIONS(493),
    [anon_sym_NA_complex_] = ACTIONS(493),
    [anon_sym_NA_character_] = ACTIONS(493),
    [sym_dots] = ACTIONS(493),
    [sym_dot_dot_i] = ACTIONS(491),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(491),
    [sym__newline] = ACTIONS(491),
    [sym__raw_string_literal] = ACTIONS(491),
    [sym__external_else] = ACTIONS(491),
    [sym__external_open_parenthesis] = ACTIONS(197),
    [sym__external_close_parenthesis] = ACTIONS(491),
    [sym__external_open_brace] = ACTIONS(491),
    [sym__external_open_bracket] = ACTIONS(199),
    [sym__external_open_bracket2] = ACTIONS(201),
  },
  [124] = {
    [sym_call_arguments] = STATE(888),
    [sym_subset_arguments] = STATE(892),
    [sym_subset2_arguments] = STATE(895),
    [sym__open_parenthesis] = STATE(345),
    [sym__open_bracket] = STATE(346),
    [sym__open_bracket2] = STATE(347),
    [sym_identifier] = ACTIONS(493),
    [anon_sym_BSLASH] = ACTIONS(491),
    [anon_sym_function] = ACTIONS(493),
    [anon_sym_EQ] = ACTIONS(493),
    [anon_sym_if] = ACTIONS(493),
    [anon_sym_for] = ACTIONS(493),
    [anon_sym_while] = ACTIONS(493),
    [anon_sym_repeat] = ACTIONS(493),
    [anon_sym_QMARK] = ACTIONS(491),
    [anon_sym_TILDE] = ACTIONS(491),
    [anon_sym_BANG] = ACTIONS(493),
    [anon_sym_PLUS] = ACTIONS(161),
    [anon_sym_DASH] = ACTIONS(163),
    [anon_sym_LT_DASH] = ACTIONS(491),
    [anon_sym_LT_LT_DASH] = ACTIONS(491),
    [anon_sym_COLON_EQ] = ACTIONS(491),
    [anon_sym_DASH_GT] = ACTIONS(493),
    [anon_sym_DASH_GT_GT] = ACTIONS(491),
    [anon_sym_PIPE] = ACTIONS(493),
    [anon_sym_AMP] = ACTIONS(173),
    [anon_sym_PIPE_PIPE] = ACTIONS(491),
    [anon_sym_AMP_AMP] = ACTIONS(177),
    [anon_sym_LT] = ACTIONS(179),
    [anon_sym_LT_EQ] = ACTIONS(181),
    [anon_sym_GT] = ACTIONS(179),
    [anon_sym_GT_EQ] = ACTIONS(181),
    [anon_sym_EQ_EQ] = ACTIONS(181),
    [anon_sym_BANG_EQ] = ACTIONS(181),
    [anon_sym_STAR] = ACTIONS(183),
    [anon_sym_SLASH] = ACTIONS(185),
    [anon_sym_STAR_STAR] = ACTIONS(187),
    [anon_sym_CARET] = ACTIONS(187),
    [aux_sym_binary_operator_token1] = ACTIONS(189),
    [anon_sym_PIPE_GT] = ACTIONS(189),
    [anon_sym_COLON] = ACTIONS(191),
    [anon_sym_DOLLAR] = ACTIONS(193),
    [anon_sym_AT] = ACTIONS(193),
    [aux_sym__hex_literal_token1] = ACTIONS(491),
    [sym__number_literal] = ACTIONS(493),
    [anon_sym_SQUOTE] = ACTIONS(491),
    [anon_sym_DQUOTE] = ACTIONS(491),
    [sym_return] = ACTIONS(493),
    [sym_next] = ACTIONS(493),
    [sym_break] = ACTIONS(493),
    [sym_true] = ACTIONS(493),
    [sym_false] = ACTIONS(493),
    [sym_null] = ACTIONS(493),
    [sym_inf] = ACTIONS(493),
    [sym_nan] = ACTIONS(493),
    [anon_sym_NA] = ACTIONS(493),
    [anon_sym_NA_integer_] = ACTIONS(493),
    [anon_sym_NA_real_] = ACTIONS(493),
    [anon_sym_NA_complex_] = ACTIONS(493),
    [anon_sym_NA_character_] = ACTIONS(493),
    [sym_dots] = ACTIONS(493),
    [sym_dot_dot_i] = ACTIONS(491),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(491),
    [sym__newline] = ACTIONS(491),
    [sym__raw_string_literal] = ACTIONS(491),
    [sym__external_else] = ACTIONS(491),
    [sym__external_open_parenthesis] = ACTIONS(197),
    [sym__external_close_parenthesis] = ACTIONS(491),
    [sym__external_open_brace] = ACTIONS(491),
    [sym__external_open_bracket] = ACTIONS(199),
    [sym__external_open_bracket2] = ACTIONS(201),
  },
  [125] = {
    [sym_call_arguments] = STATE(888),
    [sym_subset_arguments] = STATE(892),
    [sym_subset2_arguments] = STATE(895),
    [sym__open_parenthesis] = STATE(345),
    [sym__open_bracket] = STATE(346),
    [sym__open_bracket2] = STATE(347),
    [sym_identifier] = ACTIONS(493),
    [anon_sym_BSLASH] = ACTIONS(491),
    [anon_sym_function] = ACTIONS(493),
    [anon_sym_EQ] = ACTIONS(493),
    [anon_sym_if] = ACTIONS(493),
    [anon_sym_for] = ACTIONS(493),
    [anon_sym_while] = ACTIONS(493),
    [anon_sym_repeat] = ACTIONS(493),
    [anon_sym_QMARK] = ACTIONS(491),
    [anon_sym_TILDE] = ACTIONS(491),
    [anon_sym_BANG] = ACTIONS(493),
    [anon_sym_PLUS] = ACTIONS(161),
    [anon_sym_DASH] = ACTIONS(163),
    [anon_sym_LT_DASH] = ACTIONS(491),
    [anon_sym_LT_LT_DASH] = ACTIONS(491),
    [anon_sym_COLON_EQ] = ACTIONS(491),
    [anon_sym_DASH_GT] = ACTIONS(493),
    [anon_sym_DASH_GT_GT] = ACTIONS(491),
    [anon_sym_PIPE] = ACTIONS(493),
    [anon_sym_AMP] = ACTIONS(493),
    [anon_sym_PIPE_PIPE] = ACTIONS(491),
    [anon_sym_AMP_AMP] = ACTIONS(491),
    [anon_sym_LT] = ACTIONS(179),
    [anon_sym_LT_EQ] = ACTIONS(181),
    [anon_sym_GT] = ACTIONS(179),
    [anon_sym_GT_EQ] = ACTIONS(181),
    [anon_sym_EQ_EQ] = ACTIONS(181),
    [anon_sym_BANG_EQ] = ACTIONS(181),
    [anon_sym_STAR] = ACTIONS(183),
    [anon_sym_SLASH] = ACTIONS(185),
    [anon_sym_STAR_STAR] = ACTIONS(187),
    [anon_sym_CARET] = ACTIONS(187),
    [aux_sym_binary_operator_token1] = ACTIONS(189),
    [anon_sym_PIPE_GT] = ACTIONS(189),
    [anon_sym_COLON] = ACTIONS(191),
    [anon_sym_DOLLAR] = ACTIONS(193),
    [anon_sym_AT] = ACTIONS(193),
    [aux_sym__hex_literal_token1] = ACTIONS(491),
    [sym__number_literal] = ACTIONS(493),
    [anon_sym_SQUOTE] = ACTIONS(491),
    [anon_sym_DQUOTE] = ACTIONS(491),
    [sym_return] = ACTIONS(493),
    [sym_next] = ACTIONS(493),
    [sym_break] = ACTIONS(493),
    [sym_true] = ACTIONS(493),
    [sym_false] = ACTIONS(493),
    [sym_null] = ACTIONS(493),
    [sym_inf] = ACTIONS(493),
    [sym_nan] = ACTIONS(493),
    [anon_sym_NA] = ACTIONS(493),
    [anon_sym_NA_integer_] = ACTIONS(493),
    [anon_sym_NA_real_] = ACTIONS(493),
    [anon_sym_NA_complex_] = ACTIONS(493),
    [anon_sym_NA_character_] = ACTIONS(493),
    [sym_dots] = ACTIONS(493),
    [sym_dot_dot_i] = ACTIONS(491),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(491),
    [sym__newline] = ACTIONS(491),
    [sym__raw_string_literal] = ACTIONS(491),
    [sym__external_else] = ACTIONS(491),
    [sym__external_open_parenthesis] = ACTIONS(197),
    [sym__external_close_parenthesis] = ACTIONS(491),
    [sym__external_open_brace] = ACTIONS(491),
    [sym__external_open_bracket] = ACTIONS(199),
    [sym__external_open_bracket2] = ACTIONS(201),
  },
  [126] = {
    [sym_call_arguments] = STATE(888),
    [sym_subset_arguments] = STATE(892),
    [sym_subset2_arguments] = STATE(895),
    [sym__open_parenthesis] = STATE(345),
    [sym__open_bracket] = STATE(346),
    [sym__open_bracket2] = STATE(347),
    [sym_identifier] = ACTIONS(493),
    [anon_sym_BSLASH] = ACTIONS(491),
    [anon_sym_function] = ACTIONS(493),
    [anon_sym_EQ] = ACTIONS(493),
    [anon_sym_if] = ACTIONS(493),
    [anon_sym_for] = ACTIONS(493),
    [anon_sym_while] = ACTIONS(493),
    [anon_sym_repeat] = ACTIONS(493),
    [anon_sym_QMARK] = ACTIONS(491),
    [anon_sym_TILDE] = ACTIONS(491),
    [anon_sym_BANG] = ACTIONS(493),
    [anon_sym_PLUS] = ACTIONS(161),
    [anon_sym_DASH] = ACTIONS(163),
    [anon_sym_LT_DASH] = ACTIONS(491),
    [anon_sym_LT_LT_DASH] = ACTIONS(491),
    [anon_sym_COLON_EQ] = ACTIONS(491),
    [anon_sym_DASH_GT] = ACTIONS(493),
    [anon_sym_DASH_GT_GT] = ACTIONS(491),
    [anon_sym_PIPE] = ACTIONS(493),
    [anon_sym_AMP] = ACTIONS(493),
    [anon_sym_PIPE_PIPE] = ACTIONS(491),
    [anon_sym_AMP_AMP] = ACTIONS(491),
    [anon_sym_LT] = ACTIONS(493),
    [anon_sym_LT_EQ] = ACTIONS(491),
    [anon_sym_GT] = ACTIONS(493),
    [anon_sym_GT_EQ] = ACTIONS(491),
    [anon_sym_EQ_EQ] = ACTIONS(491),
    [anon_sym_BANG_EQ] = ACTIONS(491),
    [anon_sym_STAR] = ACTIONS(183),
    [anon_sym_SLASH] = ACTIONS(185),
    [anon_sym_STAR_STAR] = ACTIONS(187),
    [anon_sym_CARET] = ACTIONS(187),
    [aux_sym_binary_operator_token1] = ACTIONS(189),
    [anon_sym_PIPE_GT] = ACTIONS(189),
    [anon_sym_COLON] = ACTIONS(191),
    [anon_sym_DOLLAR] = ACTIONS(193),
    [anon_sym_AT] = ACTIONS(193),
    [aux_sym__hex_literal_token1] = ACTIONS(491),
    [sym__number_literal] = ACTIONS(493),
    [anon_sym_SQUOTE] = ACTIONS(491),
    [anon_sym_DQUOTE] = ACTIONS(491),
    [sym_return] = ACTIONS(493),
    [sym_next] = ACTIONS(493),
    [sym_break] = ACTIONS(493),
    [sym_true] = ACTIONS(493),
    [sym_false] = ACTIONS(493),
    [sym_null] = ACTIONS(493),
    [sym_inf] = ACTIONS(493),
    [sym_nan] = ACTIONS(493),
    [anon_sym_NA] = ACTIONS(493),
    [anon_sym_NA_integer_] = ACTIONS(493),
    [anon_sym_NA_real_] = ACTIONS(493),
    [anon_sym_NA_complex_] = ACTIONS(493),
    [anon_sym_NA_character_] = ACTIONS(493),
    [sym_dots] = ACTIONS(493),
    [sym_dot_dot_i] = ACTIONS(491),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(491),
    [sym__newline] = ACTIONS(491),
    [sym__raw_string_literal] = ACTIONS(491),
    [sym__external_else] = ACTIONS(491),
    [sym__external_open_parenthesis] = ACTIONS(197),
    [sym__external_close_parenthesis] = ACTIONS(491),
    [sym__external_open_brace] = ACTIONS(491),
    [sym__external_open_bracket] = ACTIONS(199),
    [sym__external_open_bracket2] = ACTIONS(201),
  },
  [127] = {
    [sym_call_arguments] = STATE(888),
    [sym_subset_arguments] = STATE(892),
    [sym_subset2_arguments] = STATE(895),
    [sym__open_parenthesis] = STATE(345),
    [sym__open_bracket] = STATE(346),
    [sym__open_bracket2] = STATE(347),
    [sym_identifier] = ACTIONS(493),
    [anon_sym_BSLASH] = ACTIONS(491),
    [anon_sym_function] = ACTIONS(493),
    [anon_sym_EQ] = ACTIONS(493),
    [anon_sym_if] = ACTIONS(493),
    [anon_sym_for] = ACTIONS(493),
    [anon_sym_while] = ACTIONS(493),
    [anon_sym_repeat] = ACTIONS(493),
    [anon_sym_QMARK] = ACTIONS(491),
    [anon_sym_TILDE] = ACTIONS(491),
    [anon_sym_BANG] = ACTIONS(493),
    [anon_sym_PLUS] = ACTIONS(491),
    [anon_sym_DASH] = ACTIONS(493),
    [anon_sym_LT_DASH] = ACTIONS(491),
    [anon_sym_LT_LT_DASH] = ACTIONS(491),
    [anon_sym_COLON_EQ] = ACTIONS(491),
    [anon_sym_DASH_GT] = ACTIONS(493),
    [anon_sym_DASH_GT_GT] = ACTIONS(491),
    [anon_sym_PIPE] = ACTIONS(493),
    [anon_sym_AMP] = ACTIONS(493),
    [anon_sym_PIPE_PIPE] = ACTIONS(491),
    [anon_sym_AMP_AMP] = ACTIONS(491),
    [anon_sym_LT] = ACTIONS(493),
    [anon_sym_LT_EQ] = ACTIONS(491),
    [anon_sym_GT] = ACTIONS(493),
    [anon_sym_GT_EQ] = ACTIONS(491),
    [anon_sym_EQ_EQ] = ACTIONS(491),
    [anon_sym_BANG_EQ] = ACTIONS(491),
    [anon_sym_STAR] = ACTIONS(493),
    [anon_sym_SLASH] = ACTIONS(491),
    [anon_sym_STAR_STAR] = ACTIONS(187),
    [anon_sym_CARET] = ACTIONS(187),
    [aux_sym_binary_operator_token1] = ACTIONS(189),
    [anon_sym_PIPE_GT] = ACTIONS(189),
    [anon_sym_COLON] = ACTIONS(191),
    [anon_sym_DOLLAR] = ACTIONS(193),
    [anon_sym_AT] = ACTIONS(193),
    [aux_sym__hex_literal_token1] = ACTIONS(491),
    [sym__number_literal] = ACTIONS(493),
    [anon_sym_SQUOTE] = ACTIONS(491),
    [anon_sym_DQUOTE] = ACTIONS(491),
    [sym_return] = ACTIONS(493),
    [sym_next] = ACTIONS(493),
    [sym_break] = ACTIONS(493),
    [sym_true] = ACTIONS(493),
    [sym_false] = ACTIONS(493),
    [sym_null] = ACTIONS(493),
    [sym_inf] = ACTIONS(493),
    [sym_nan] = ACTIONS(493),
    [anon_sym_NA] = ACTIONS(493),
    [anon_sym_NA_integer_] = ACTIONS(493),
    [anon_sym_NA_real_] = ACTIONS(493),
    [anon_sym_NA_complex_] = ACTIONS(493),
    [anon_sym_NA_character_] = ACTIONS(493),
    [sym_dots] = ACTIONS(493),
    [sym_dot_dot_i] = ACTIONS(491),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(491),
    [sym__newline] = ACTIONS(491),
    [sym__raw_string_literal] = ACTIONS(491),
    [sym__external_else] = ACTIONS(491),
    [sym__external_open_parenthesis] = ACTIONS(197),
    [sym__external_close_parenthesis] = ACTIONS(491),
    [sym__external_open_brace] = ACTIONS(491),
    [sym__external_open_bracket] = ACTIONS(199),
    [sym__external_open_bracket2] = ACTIONS(201),
  },
  [128] = {
    [sym_call_arguments] = STATE(888),
    [sym_subset_arguments] = STATE(892),
    [sym_subset2_arguments] = STATE(895),
    [sym__open_parenthesis] = STATE(345),
    [sym__open_bracket] = STATE(346),
    [sym__open_bracket2] = STATE(347),
    [sym_identifier] = ACTIONS(493),
    [anon_sym_BSLASH] = ACTIONS(491),
    [anon_sym_function] = ACTIONS(493),
    [anon_sym_EQ] = ACTIONS(493),
    [anon_sym_if] = ACTIONS(493),
    [anon_sym_for] = ACTIONS(493),
    [anon_sym_while] = ACTIONS(493),
    [anon_sym_repeat] = ACTIONS(493),
    [anon_sym_QMARK] = ACTIONS(491),
    [anon_sym_TILDE] = ACTIONS(491),
    [anon_sym_BANG] = ACTIONS(493),
    [anon_sym_PLUS] = ACTIONS(491),
    [anon_sym_DASH] = ACTIONS(493),
    [anon_sym_LT_DASH] = ACTIONS(491),
    [anon_sym_LT_LT_DASH] = ACTIONS(491),
    [anon_sym_COLON_EQ] = ACTIONS(491),
    [anon_sym_DASH_GT] = ACTIONS(493),
    [anon_sym_DASH_GT_GT] = ACTIONS(491),
    [anon_sym_PIPE] = ACTIONS(493),
    [anon_sym_AMP] = ACTIONS(493),
    [anon_sym_PIPE_PIPE] = ACTIONS(491),
    [anon_sym_AMP_AMP] = ACTIONS(491),
    [anon_sym_LT] = ACTIONS(493),
    [anon_sym_LT_EQ] = ACTIONS(491),
    [anon_sym_GT] = ACTIONS(493),
    [anon_sym_GT_EQ] = ACTIONS(491),
    [anon_sym_EQ_EQ] = ACTIONS(491),
    [anon_sym_BANG_EQ] = ACTIONS(491),
    [anon_sym_STAR] = ACTIONS(493),
    [anon_sym_SLASH] = ACTIONS(491),
    [anon_sym_STAR_STAR] = ACTIONS(187),
    [anon_sym_CARET] = ACTIONS(187),
    [aux_sym_binary_operator_token1] = ACTIONS(491),
    [anon_sym_PIPE_GT] = ACTIONS(491),
    [anon_sym_COLON] = ACTIONS(493),
    [anon_sym_DOLLAR] = ACTIONS(193),
    [anon_sym_AT] = ACTIONS(193),
    [aux_sym__hex_literal_token1] = ACTIONS(491),
    [sym__number_literal] = ACTIONS(493),
    [anon_sym_SQUOTE] = ACTIONS(491),
    [anon_sym_DQUOTE] = ACTIONS(491),
    [sym_return] = ACTIONS(493),
    [sym_next] = ACTIONS(493),
    [sym_break] = ACTIONS(493),
    [sym_true] = ACTIONS(493),
    [sym_false] = ACTIONS(493),
    [sym_null] = ACTIONS(493),
    [sym_inf] = ACTIONS(493),
    [sym_nan] = ACTIONS(493),
    [anon_sym_NA] = ACTIONS(493),
    [anon_sym_NA_integer_] = ACTIONS(493),
    [anon_sym_NA_real_] = ACTIONS(493),
    [anon_sym_NA_complex_] = ACTIONS(493),
    [anon_sym_NA_character_] = ACTIONS(493),
    [sym_dots] = ACTIONS(493),
    [sym_dot_dot_i] = ACTIONS(491),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(491),
    [sym__newline] = ACTIONS(491),
    [sym__raw_string_literal] = ACTIONS(491),
    [sym__external_else] = ACTIONS(491),
    [sym__external_open_parenthesis] = ACTIONS(197),
    [sym__external_close_parenthesis] = ACTIONS(491),
    [sym__external_open_brace] = ACTIONS(491),
    [sym__external_open_bracket] = ACTIONS(199),
    [sym__external_open_bracket2] = ACTIONS(201),
  },
  [129] = {
    [sym_call_arguments] = STATE(888),
    [sym_subset_arguments] = STATE(892),
    [sym_subset2_arguments] = STATE(895),
    [sym__open_parenthesis] = STATE(345),
    [sym__open_bracket] = STATE(346),
    [sym__open_bracket2] = STATE(347),
    [sym_identifier] = ACTIONS(493),
    [anon_sym_BSLASH] = ACTIONS(491),
    [anon_sym_function] = ACTIONS(493),
    [anon_sym_EQ] = ACTIONS(493),
    [anon_sym_if] = ACTIONS(493),
    [anon_sym_for] = ACTIONS(493),
    [anon_sym_while] = ACTIONS(493),
    [anon_sym_repeat] = ACTIONS(493),
    [anon_sym_QMARK] = ACTIONS(491),
    [anon_sym_TILDE] = ACTIONS(491),
    [anon_sym_BANG] = ACTIONS(493),
    [anon_sym_PLUS] = ACTIONS(491),
    [anon_sym_DASH] = ACTIONS(493),
    [anon_sym_LT_DASH] = ACTIONS(491),
    [anon_sym_LT_LT_DASH] = ACTIONS(491),
    [anon_sym_COLON_EQ] = ACTIONS(491),
    [anon_sym_DASH_GT] = ACTIONS(493),
    [anon_sym_DASH_GT_GT] = ACTIONS(491),
    [anon_sym_PIPE] = ACTIONS(493),
    [anon_sym_AMP] = ACTIONS(493),
    [anon_sym_PIPE_PIPE] = ACTIONS(491),
    [anon_sym_AMP_AMP] = ACTIONS(491),
    [anon_sym_LT] = ACTIONS(493),
    [anon_sym_LT_EQ] = ACTIONS(491),
    [anon_sym_GT] = ACTIONS(493),
    [anon_sym_GT_EQ] = ACTIONS(491),
    [anon_sym_EQ_EQ] = ACTIONS(491),
    [anon_sym_BANG_EQ] = ACTIONS(491),
    [anon_sym_STAR] = ACTIONS(493),
    [anon_sym_SLASH] = ACTIONS(491),
    [anon_sym_STAR_STAR] = ACTIONS(187),
    [anon_sym_CARET] = ACTIONS(187),
    [aux_sym_binary_operator_token1] = ACTIONS(491),
    [anon_sym_PIPE_GT] = ACTIONS(491),
    [anon_sym_COLON] = ACTIONS(191),
    [anon_sym_DOLLAR] = ACTIONS(193),
    [anon_sym_AT] = ACTIONS(193),
    [aux_sym__hex_literal_token1] = ACTIONS(491),
    [sym__number_literal] = ACTIONS(493),
    [anon_sym_SQUOTE] = ACTIONS(491),
    [anon_sym_DQUOTE] = ACTIONS(491),
    [sym_return] = ACTIONS(493),
    [sym_next] = ACTIONS(493),
    [sym_break] = ACTIONS(493),
    [sym_true] = ACTIONS(493),
    [sym_false] = ACTIONS(493),
    [sym_null] = ACTIONS(493),
    [sym_inf] = ACTIONS(493),
    [sym_nan] = ACTIONS(493),
    [anon_sym_NA] = ACTIONS(493),
    [anon_sym_NA_integer_] = ACTIONS(493),
    [anon_sym_NA_real_] = ACTIONS(493),
    [anon_sym_NA_complex_] = ACTIONS(493),
    [anon_sym_NA_character_] = ACTIONS(493),
    [sym_dots] = ACTIONS(493),
    [sym_dot_dot_i] = ACTIONS(491),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(491),
    [sym__newline] = ACTIONS(491),
    [sym__raw_string_literal] = ACTIONS(491),
    [sym__external_else] = ACTIONS(491),
    [sym__external_open_parenthesis] = ACTIONS(197),
    [sym__external_close_parenthesis] = ACTIONS(491),
    [sym__external_open_brace] = ACTIONS(491),
    [sym__external_open_bracket] = ACTIONS(199),
    [sym__external_open_bracket2] = ACTIONS(201),
  },
  [130] = {
    [sym_call_arguments] = STATE(888),
    [sym_subset_arguments] = STATE(892),
    [sym_subset2_arguments] = STATE(895),
    [sym__open_parenthesis] = STATE(345),
    [sym__open_bracket] = STATE(346),
    [sym__open_bracket2] = STATE(347),
    [sym_identifier] = ACTIONS(493),
    [anon_sym_BSLASH] = ACTIONS(491),
    [anon_sym_function] = ACTIONS(493),
    [anon_sym_EQ] = ACTIONS(493),
    [anon_sym_if] = ACTIONS(493),
    [anon_sym_for] = ACTIONS(493),
    [anon_sym_while] = ACTIONS(493),
    [anon_sym_repeat] = ACTIONS(493),
    [anon_sym_QMARK] = ACTIONS(491),
    [anon_sym_TILDE] = ACTIONS(491),
    [anon_sym_BANG] = ACTIONS(493),
    [anon_sym_PLUS] = ACTIONS(491),
    [anon_sym_DASH] = ACTIONS(493),
    [anon_sym_LT_DASH] = ACTIONS(491),
    [anon_sym_LT_LT_DASH] = ACTIONS(491),
    [anon_sym_COLON_EQ] = ACTIONS(491),
    [anon_sym_DASH_GT] = ACTIONS(493),
    [anon_sym_DASH_GT_GT] = ACTIONS(491),
    [anon_sym_PIPE] = ACTIONS(493),
    [anon_sym_AMP] = ACTIONS(493),
    [anon_sym_PIPE_PIPE] = ACTIONS(491),
    [anon_sym_AMP_AMP] = ACTIONS(491),
    [anon_sym_LT] = ACTIONS(493),
    [anon_sym_LT_EQ] = ACTIONS(491),
    [anon_sym_GT] = ACTIONS(493),
    [anon_sym_GT_EQ] = ACTIONS(491),
    [anon_sym_EQ_EQ] = ACTIONS(491),
    [anon_sym_BANG_EQ] = ACTIONS(491),
    [anon_sym_STAR] = ACTIONS(493),
    [anon_sym_SLASH] = ACTIONS(491),
    [anon_sym_STAR_STAR] = ACTIONS(187),
    [anon_sym_CARET] = ACTIONS(187),
    [aux_sym_binary_operator_token1] = ACTIONS(491),
    [anon_sym_PIPE_GT] = ACTIONS(491),
    [anon_sym_COLON] = ACTIONS(493),
    [anon_sym_DOLLAR] = ACTIONS(193),
    [anon_sym_AT] = ACTIONS(193),
    [aux_sym__hex_literal_token1] = ACTIONS(491),
    [sym__number_literal] = ACTIONS(493),
    [anon_sym_SQUOTE] = ACTIONS(491),
    [anon_sym_DQUOTE] = ACTIONS(491),
    [sym_return] = ACTIONS(493),
    [sym_next] = ACTIONS(493),
    [sym_break] = ACTIONS(493),
    [sym_true] = ACTIONS(493),
    [sym_false] = ACTIONS(493),
    [sym_null] = ACTIONS(493),
    [sym_inf] = ACTIONS(493),
    [sym_nan] = ACTIONS(493),
    [anon_sym_NA] = ACTIONS(493),
    [anon_sym_NA_integer_] = ACTIONS(493),
    [anon_sym_NA_real_] = ACTIONS(493),
    [anon_sym_NA_complex_] = ACTIONS(493),
    [anon_sym_NA_character_] = ACTIONS(493),
    [sym_dots] = ACTIONS(493),
    [sym_dot_dot_i] = ACTIONS(491),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(491),
    [sym__newline] = ACTIONS(491),
    [sym__raw_string_literal] = ACTIONS(491),
    [sym__external_else] = ACTIONS(491),
    [sym__external_open_parenthesis] = ACTIONS(197),
    [sym__external_close_parenthesis] = ACTIONS(491),
    [sym__external_open_brace] = ACTIONS(491),
    [sym__external_open_bracket] = ACTIONS(199),
    [sym__external_open_bracket2] = ACTIONS(201),
  },
  [131] = {
    [sym_call_arguments] = STATE(888),
    [sym_subset_arguments] = STATE(892),
    [sym_subset2_arguments] = STATE(895),
    [sym__open_parenthesis] = STATE(345),
    [sym__open_bracket] = STATE(346),
    [sym__open_bracket2] = STATE(347),
    [sym_identifier] = ACTIONS(497),
    [anon_sym_BSLASH] = ACTIONS(495),
    [anon_sym_function] = ACTIONS(497),
    [anon_sym_EQ] = ACTIONS(157),
    [anon_sym_if] = ACTIONS(497),
    [anon_sym_for] = ACTIONS(497),
    [anon_sym_while] = ACTIONS(497),
    [anon_sym_repeat] = ACTIONS(497),
    [anon_sym_QMARK] = ACTIONS(495),
    [anon_sym_TILDE] = ACTIONS(159),
    [anon_sym_BANG] = ACTIONS(497),
    [anon_sym_PLUS] = ACTIONS(161),
    [anon_sym_DASH] = ACTIONS(163),
    [anon_sym_LT_DASH] = ACTIONS(165),
    [anon_sym_LT_LT_DASH] = ACTIONS(165),
    [anon_sym_COLON_EQ] = ACTIONS(165),
    [anon_sym_DASH_GT] = ACTIONS(167),
    [anon_sym_DASH_GT_GT] = ACTIONS(169),
    [anon_sym_PIPE] = ACTIONS(171),
    [anon_sym_AMP] = ACTIONS(173),
    [anon_sym_PIPE_PIPE] = ACTIONS(175),
    [anon_sym_AMP_AMP] = ACTIONS(177),
    [anon_sym_LT] = ACTIONS(179),
    [anon_sym_LT_EQ] = ACTIONS(181),
    [anon_sym_GT] = ACTIONS(179),
    [anon_sym_GT_EQ] = ACTIONS(181),
    [anon_sym_EQ_EQ] = ACTIONS(181),
    [anon_sym_BANG_EQ] = ACTIONS(181),
    [anon_sym_STAR] = ACTIONS(183),
    [anon_sym_SLASH] = ACTIONS(185),
    [anon_sym_STAR_STAR] = ACTIONS(187),
    [anon_sym_CARET] = ACTIONS(187),
    [aux_sym_binary_operator_token1] = ACTIONS(189),
    [anon_sym_PIPE_GT] = ACTIONS(189),
    [anon_sym_COLON] = ACTIONS(191),
    [anon_sym_DOLLAR] = ACTIONS(193),
    [anon_sym_AT] = ACTIONS(193),
    [aux_sym__hex_literal_token1] = ACTIONS(495),
    [sym__number_literal] = ACTIONS(497),
    [anon_sym_SQUOTE] = ACTIONS(495),
    [anon_sym_DQUOTE] = ACTIONS(495),
    [sym_return] = ACTIONS(497),
    [sym_next] = ACTIONS(497),
    [sym_break] = ACTIONS(497),
    [sym_true] = ACTIONS(497),
    [sym_false] = ACTIONS(497),
    [sym_null] = ACTIONS(497),
    [sym_inf] = ACTIONS(497),
    [sym_nan] = ACTIONS(497),
    [anon_sym_NA] = ACTIONS(497),
    [anon_sym_NA_integer_] = ACTIONS(497),
    [anon_sym_NA_real_] = ACTIONS(497),
    [anon_sym_NA_complex_] = ACTIONS(497),
    [anon_sym_NA_character_] = ACTIONS(497),
    [sym_dots] = ACTIONS(497),
    [sym_dot_dot_i] = ACTIONS(495),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(495),
    [sym__newline] = ACTIONS(495),
    [sym__raw_string_literal] = ACTIONS(495),
    [sym__external_else] = ACTIONS(495),
    [sym__external_open_parenthesis] = ACTIONS(197),
    [sym__external_close_parenthesis] = ACTIONS(495),
    [sym__external_open_brace] = ACTIONS(495),
    [sym__external_open_bracket] = ACTIONS(199),
    [sym__external_open_bracket2] = ACTIONS(201),
  },
  [132] = {
    [sym_call_arguments] = STATE(888),
    [sym_subset_arguments] = STATE(892),
    [sym_subset2_arguments] = STATE(895),
    [sym__open_parenthesis] = STATE(345),
    [sym__open_bracket] = STATE(346),
    [sym__open_bracket2] = STATE(347),
    [sym_identifier] = ACTIONS(501),
    [anon_sym_BSLASH] = ACTIONS(499),
    [anon_sym_function] = ACTIONS(501),
    [anon_sym_EQ] = ACTIONS(157),
    [anon_sym_if] = ACTIONS(501),
    [anon_sym_for] = ACTIONS(501),
    [anon_sym_while] = ACTIONS(501),
    [anon_sym_repeat] = ACTIONS(501),
    [anon_sym_QMARK] = ACTIONS(499),
    [anon_sym_TILDE] = ACTIONS(159),
    [anon_sym_BANG] = ACTIONS(501),
    [anon_sym_PLUS] = ACTIONS(161),
    [anon_sym_DASH] = ACTIONS(163),
    [anon_sym_LT_DASH] = ACTIONS(165),
    [anon_sym_LT_LT_DASH] = ACTIONS(165),
    [anon_sym_COLON_EQ] = ACTIONS(165),
    [anon_sym_DASH_GT] = ACTIONS(167),
    [anon_sym_DASH_GT_GT] = ACTIONS(169),
    [anon_sym_PIPE] = ACTIONS(171),
    [anon_sym_AMP] = ACTIONS(173),
    [anon_sym_PIPE_PIPE] = ACTIONS(175),
    [anon_sym_AMP_AMP] = ACTIONS(177),
    [anon_sym_LT] = ACTIONS(179),
    [anon_sym_LT_EQ] = ACTIONS(181),
    [anon_sym_GT] = ACTIONS(179),
    [anon_sym_GT_EQ] = ACTIONS(181),
    [anon_sym_EQ_EQ] = ACTIONS(181),
    [anon_sym_BANG_EQ] = ACTIONS(181),
    [anon_sym_STAR] = ACTIONS(183),
    [anon_sym_SLASH] = ACTIONS(185),
    [anon_sym_STAR_STAR] = ACTIONS(187),
    [anon_sym_CARET] = ACTIONS(187),
    [aux_sym_binary_operator_token1] = ACTIONS(189),
    [anon_sym_PIPE_GT] = ACTIONS(189),
    [anon_sym_COLON] = ACTIONS(191),
    [anon_sym_DOLLAR] = ACTIONS(193),
    [anon_sym_AT] = ACTIONS(193),
    [aux_sym__hex_literal_token1] = ACTIONS(499),
    [sym__number_literal] = ACTIONS(501),
    [anon_sym_SQUOTE] = ACTIONS(499),
    [anon_sym_DQUOTE] = ACTIONS(499),
    [sym_return] = ACTIONS(501),
    [sym_next] = ACTIONS(501),
    [sym_break] = ACTIONS(501),
    [sym_true] = ACTIONS(501),
    [sym_false] = ACTIONS(501),
    [sym_null] = ACTIONS(501),
    [sym_inf] = ACTIONS(501),
    [sym_nan] = ACTIONS(501),
    [anon_sym_NA] = ACTIONS(501),
    [anon_sym_NA_integer_] = ACTIONS(501),
    [anon_sym_NA_real_] = ACTIONS(501),
    [anon_sym_NA_complex_] = ACTIONS(501),
    [anon_sym_NA_character_] = ACTIONS(501),
    [sym_dots] = ACTIONS(501),
    [sym_dot_dot_i] = ACTIONS(499),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(499),
    [sym__newline] = ACTIONS(499),
    [sym__raw_string_literal] = ACTIONS(499),
    [sym__external_else] = ACTIONS(499),
    [sym__external_open_parenthesis] = ACTIONS(197),
    [sym__external_close_parenthesis] = ACTIONS(499),
    [sym__external_open_brace] = ACTIONS(499),
    [sym__external_open_bracket] = ACTIONS(199),
    [sym__external_open_bracket2] = ACTIONS(201),
  },
  [133] = {
    [sym_call_arguments] = STATE(888),
    [sym_subset_arguments] = STATE(892),
    [sym_subset2_arguments] = STATE(895),
    [sym__open_parenthesis] = STATE(345),
    [sym__open_bracket] = STATE(346),
    [sym__open_bracket2] = STATE(347),
    [sym_identifier] = ACTIONS(505),
    [anon_sym_BSLASH] = ACTIONS(503),
    [anon_sym_function] = ACTIONS(505),
    [anon_sym_EQ] = ACTIONS(157),
    [anon_sym_if] = ACTIONS(505),
    [anon_sym_for] = ACTIONS(505),
    [anon_sym_while] = ACTIONS(505),
    [anon_sym_repeat] = ACTIONS(505),
    [anon_sym_QMARK] = ACTIONS(503),
    [anon_sym_TILDE] = ACTIONS(159),
    [anon_sym_BANG] = ACTIONS(505),
    [anon_sym_PLUS] = ACTIONS(161),
    [anon_sym_DASH] = ACTIONS(163),
    [anon_sym_LT_DASH] = ACTIONS(165),
    [anon_sym_LT_LT_DASH] = ACTIONS(165),
    [anon_sym_COLON_EQ] = ACTIONS(165),
    [anon_sym_DASH_GT] = ACTIONS(167),
    [anon_sym_DASH_GT_GT] = ACTIONS(169),
    [anon_sym_PIPE] = ACTIONS(171),
    [anon_sym_AMP] = ACTIONS(173),
    [anon_sym_PIPE_PIPE] = ACTIONS(175),
    [anon_sym_AMP_AMP] = ACTIONS(177),
    [anon_sym_LT] = ACTIONS(179),
    [anon_sym_LT_EQ] = ACTIONS(181),
    [anon_sym_GT] = ACTIONS(179),
    [anon_sym_GT_EQ] = ACTIONS(181),
    [anon_sym_EQ_EQ] = ACTIONS(181),
    [anon_sym_BANG_EQ] = ACTIONS(181),
    [anon_sym_STAR] = ACTIONS(183),
    [anon_sym_SLASH] = ACTIONS(185),
    [anon_sym_STAR_STAR] = ACTIONS(187),
    [anon_sym_CARET] = ACTIONS(187),
    [aux_sym_binary_operator_token1] = ACTIONS(189),
    [anon_sym_PIPE_GT] = ACTIONS(189),
    [anon_sym_COLON] = ACTIONS(191),
    [anon_sym_DOLLAR] = ACTIONS(193),
    [anon_sym_AT] = ACTIONS(193),
    [aux_sym__hex_literal_token1] = ACTIONS(503),
    [sym__number_literal] = ACTIONS(505),
    [anon_sym_SQUOTE] = ACTIONS(503),
    [anon_sym_DQUOTE] = ACTIONS(503),
    [sym_return] = ACTIONS(505),
    [sym_next] = ACTIONS(505),
    [sym_break] = ACTIONS(505),
    [sym_true] = ACTIONS(505),
    [sym_false] = ACTIONS(505),
    [sym_null] = ACTIONS(505),
    [sym_inf] = ACTIONS(505),
    [sym_nan] = ACTIONS(505),
    [anon_sym_NA] = ACTIONS(505),
    [anon_sym_NA_integer_] = ACTIONS(505),
    [anon_sym_NA_real_] = ACTIONS(505),
    [anon_sym_NA_complex_] = ACTIONS(505),
    [anon_sym_NA_character_] = ACTIONS(505),
    [sym_dots] = ACTIONS(505),
    [sym_dot_dot_i] = ACTIONS(503),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(503),
    [sym__newline] = ACTIONS(503),
    [sym__raw_string_literal] = ACTIONS(503),
    [sym__external_else] = ACTIONS(503),
    [sym__external_open_parenthesis] = ACTIONS(197),
    [sym__external_close_parenthesis] = ACTIONS(503),
    [sym__external_open_brace] = ACTIONS(503),
    [sym__external_open_bracket] = ACTIONS(199),
    [sym__external_open_bracket2] = ACTIONS(201),
  },
  [134] = {
    [sym_call_arguments] = STATE(888),
    [sym_subset_arguments] = STATE(892),
    [sym_subset2_arguments] = STATE(895),
    [sym__open_parenthesis] = STATE(345),
    [sym__open_bracket] = STATE(346),
    [sym__open_bracket2] = STATE(347),
    [sym_identifier] = ACTIONS(509),
    [anon_sym_BSLASH] = ACTIONS(507),
    [anon_sym_function] = ACTIONS(509),
    [anon_sym_EQ] = ACTIONS(157),
    [anon_sym_if] = ACTIONS(509),
    [anon_sym_for] = ACTIONS(509),
    [anon_sym_while] = ACTIONS(509),
    [anon_sym_repeat] = ACTIONS(509),
    [anon_sym_QMARK] = ACTIONS(507),
    [anon_sym_TILDE] = ACTIONS(159),
    [anon_sym_BANG] = ACTIONS(509),
    [anon_sym_PLUS] = ACTIONS(161),
    [anon_sym_DASH] = ACTIONS(163),
    [anon_sym_LT_DASH] = ACTIONS(165),
    [anon_sym_LT_LT_DASH] = ACTIONS(165),
    [anon_sym_COLON_EQ] = ACTIONS(165),
    [anon_sym_DASH_GT] = ACTIONS(167),
    [anon_sym_DASH_GT_GT] = ACTIONS(169),
    [anon_sym_PIPE] = ACTIONS(171),
    [anon_sym_AMP] = ACTIONS(173),
    [anon_sym_PIPE_PIPE] = ACTIONS(175),
    [anon_sym_AMP_AMP] = ACTIONS(177),
    [anon_sym_LT] = ACTIONS(179),
    [anon_sym_LT_EQ] = ACTIONS(181),
    [anon_sym_GT] = ACTIONS(179),
    [anon_sym_GT_EQ] = ACTIONS(181),
    [anon_sym_EQ_EQ] = ACTIONS(181),
    [anon_sym_BANG_EQ] = ACTIONS(181),
    [anon_sym_STAR] = ACTIONS(183),
    [anon_sym_SLASH] = ACTIONS(185),
    [anon_sym_STAR_STAR] = ACTIONS(187),
    [anon_sym_CARET] = ACTIONS(187),
    [aux_sym_binary_operator_token1] = ACTIONS(189),
    [anon_sym_PIPE_GT] = ACTIONS(189),
    [anon_sym_COLON] = ACTIONS(191),
    [anon_sym_DOLLAR] = ACTIONS(193),
    [anon_sym_AT] = ACTIONS(193),
    [aux_sym__hex_literal_token1] = ACTIONS(507),
    [sym__number_literal] = ACTIONS(509),
    [anon_sym_SQUOTE] = ACTIONS(507),
    [anon_sym_DQUOTE] = ACTIONS(507),
    [sym_return] = ACTIONS(509),
    [sym_next] = ACTIONS(509),
    [sym_break] = ACTIONS(509),
    [sym_true] = ACTIONS(509),
    [sym_false] = ACTIONS(509),
    [sym_null] = ACTIONS(509),
    [sym_inf] = ACTIONS(509),
    [sym_nan] = ACTIONS(509),
    [anon_sym_NA] = ACTIONS(509),
    [anon_sym_NA_integer_] = ACTIONS(509),
    [anon_sym_NA_real_] = ACTIONS(509),
    [anon_sym_NA_complex_] = ACTIONS(509),
    [anon_sym_NA_character_] = ACTIONS(509),
    [sym_dots] = ACTIONS(509),
    [sym_dot_dot_i] = ACTIONS(507),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(507),
    [sym__newline] = ACTIONS(507),
    [sym__raw_string_literal] = ACTIONS(507),
    [sym__external_else] = ACTIONS(507),
    [sym__external_open_parenthesis] = ACTIONS(197),
    [sym__external_close_parenthesis] = ACTIONS(507),
    [sym__external_open_brace] = ACTIONS(507),
    [sym__external_open_bracket] = ACTIONS(199),
    [sym__external_open_bracket2] = ACTIONS(201),
  },
  [135] = {
    [sym_call_arguments] = STATE(888),
    [sym_subset_arguments] = STATE(892),
    [sym_subset2_arguments] = STATE(895),
    [sym__open_parenthesis] = STATE(345),
    [sym__open_bracket] = STATE(346),
    [sym__open_bracket2] = STATE(347),
    [sym_identifier] = ACTIONS(513),
    [anon_sym_BSLASH] = ACTIONS(511),
    [anon_sym_function] = ACTIONS(513),
    [anon_sym_EQ] = ACTIONS(157),
    [anon_sym_if] = ACTIONS(513),
    [anon_sym_for] = ACTIONS(513),
    [anon_sym_while] = ACTIONS(513),
    [anon_sym_repeat] = ACTIONS(513),
    [anon_sym_QMARK] = ACTIONS(511),
    [anon_sym_TILDE] = ACTIONS(159),
    [anon_sym_BANG] = ACTIONS(513),
    [anon_sym_PLUS] = ACTIONS(161),
    [anon_sym_DASH] = ACTIONS(163),
    [anon_sym_LT_DASH] = ACTIONS(165),
    [anon_sym_LT_LT_DASH] = ACTIONS(165),
    [anon_sym_COLON_EQ] = ACTIONS(165),
    [anon_sym_DASH_GT] = ACTIONS(167),
    [anon_sym_DASH_GT_GT] = ACTIONS(169),
    [anon_sym_PIPE] = ACTIONS(171),
    [anon_sym_AMP] = ACTIONS(173),
    [anon_sym_PIPE_PIPE] = ACTIONS(175),
    [anon_sym_AMP_AMP] = ACTIONS(177),
    [anon_sym_LT] = ACTIONS(179),
    [anon_sym_LT_EQ] = ACTIONS(181),
    [anon_sym_GT] = ACTIONS(179),
    [anon_sym_GT_EQ] = ACTIONS(181),
    [anon_sym_EQ_EQ] = ACTIONS(181),
    [anon_sym_BANG_EQ] = ACTIONS(181),
    [anon_sym_STAR] = ACTIONS(183),
    [anon_sym_SLASH] = ACTIONS(185),
    [anon_sym_STAR_STAR] = ACTIONS(187),
    [anon_sym_CARET] = ACTIONS(187),
    [aux_sym_binary_operator_token1] = ACTIONS(189),
    [anon_sym_PIPE_GT] = ACTIONS(189),
    [anon_sym_COLON] = ACTIONS(191),
    [anon_sym_DOLLAR] = ACTIONS(193),
    [anon_sym_AT] = ACTIONS(193),
    [aux_sym__hex_literal_token1] = ACTIONS(511),
    [sym__number_literal] = ACTIONS(513),
    [anon_sym_SQUOTE] = ACTIONS(511),
    [anon_sym_DQUOTE] = ACTIONS(511),
    [sym_return] = ACTIONS(513),
    [sym_next] = ACTIONS(513),
    [sym_break] = ACTIONS(513),
    [sym_true] = ACTIONS(513),
    [sym_false] = ACTIONS(513),
    [sym_null] = ACTIONS(513),
    [sym_inf] = ACTIONS(513),
    [sym_nan] = ACTIONS(513),
    [anon_sym_NA] = ACTIONS(513),
    [anon_sym_NA_integer_] = ACTIONS(513),
    [anon_sym_NA_real_] = ACTIONS(513),
    [anon_sym_NA_complex_] = ACTIONS(513),
    [anon_sym_NA_character_] = ACTIONS(513),
    [sym_dots] = ACTIONS(513),
    [sym_dot_dot_i] = ACTIONS(511),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(511),
    [sym__newline] = ACTIONS(511),
    [sym__raw_string_literal] = ACTIONS(511),
    [sym__external_else] = ACTIONS(511),
    [sym__external_open_parenthesis] = ACTIONS(197),
    [sym__external_close_parenthesis] = ACTIONS(511),
    [sym__external_open_brace] = ACTIONS(511),
    [sym__external_open_bracket] = ACTIONS(199),
    [sym__external_open_bracket2] = ACTIONS(201),
  },
  [136] = {
    [sym_call_arguments] = STATE(888),
    [sym_subset_arguments] = STATE(892),
    [sym_subset2_arguments] = STATE(895),
    [sym__open_parenthesis] = STATE(345),
    [sym__open_bracket] = STATE(346),
    [sym__open_bracket2] = STATE(347),
    [sym_identifier] = ACTIONS(517),
    [anon_sym_BSLASH] = ACTIONS(515),
    [anon_sym_function] = ACTIONS(517),
    [anon_sym_EQ] = ACTIONS(157),
    [anon_sym_if] = ACTIONS(517),
    [anon_sym_for] = ACTIONS(517),
    [anon_sym_while] = ACTIONS(517),
    [anon_sym_repeat] = ACTIONS(517),
    [anon_sym_QMARK] = ACTIONS(515),
    [anon_sym_TILDE] = ACTIONS(159),
    [anon_sym_BANG] = ACTIONS(517),
    [anon_sym_PLUS] = ACTIONS(161),
    [anon_sym_DASH] = ACTIONS(163),
    [anon_sym_LT_DASH] = ACTIONS(165),
    [anon_sym_LT_LT_DASH] = ACTIONS(165),
    [anon_sym_COLON_EQ] = ACTIONS(165),
    [anon_sym_DASH_GT] = ACTIONS(167),
    [anon_sym_DASH_GT_GT] = ACTIONS(169),
    [anon_sym_PIPE] = ACTIONS(171),
    [anon_sym_AMP] = ACTIONS(173),
    [anon_sym_PIPE_PIPE] = ACTIONS(175),
    [anon_sym_AMP_AMP] = ACTIONS(177),
    [anon_sym_LT] = ACTIONS(179),
    [anon_sym_LT_EQ] = ACTIONS(181),
    [anon_sym_GT] = ACTIONS(179),
    [anon_sym_GT_EQ] = ACTIONS(181),
    [anon_sym_EQ_EQ] = ACTIONS(181),
    [anon_sym_BANG_EQ] = ACTIONS(181),
    [anon_sym_STAR] = ACTIONS(183),
    [anon_sym_SLASH] = ACTIONS(185),
    [anon_sym_STAR_STAR] = ACTIONS(187),
    [anon_sym_CARET] = ACTIONS(187),
    [aux_sym_binary_operator_token1] = ACTIONS(189),
    [anon_sym_PIPE_GT] = ACTIONS(189),
    [anon_sym_COLON] = ACTIONS(191),
    [anon_sym_DOLLAR] = ACTIONS(193),
    [anon_sym_AT] = ACTIONS(193),
    [aux_sym__hex_literal_token1] = ACTIONS(515),
    [sym__number_literal] = ACTIONS(517),
    [anon_sym_SQUOTE] = ACTIONS(515),
    [anon_sym_DQUOTE] = ACTIONS(515),
    [sym_return] = ACTIONS(517),
    [sym_next] = ACTIONS(517),
    [sym_break] = ACTIONS(517),
    [sym_true] = ACTIONS(517),
    [sym_false] = ACTIONS(517),
    [sym_null] = ACTIONS(517),
    [sym_inf] = ACTIONS(517),
    [sym_nan] = ACTIONS(517),
    [anon_sym_NA] = ACTIONS(517),
    [anon_sym_NA_integer_] = ACTIONS(517),
    [anon_sym_NA_real_] = ACTIONS(517),
    [anon_sym_NA_complex_] = ACTIONS(517),
    [anon_sym_NA_character_] = ACTIONS(517),
    [sym_dots] = ACTIONS(517),
    [sym_dot_dot_i] = ACTIONS(515),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(515),
    [sym__newline] = ACTIONS(515),
    [sym__raw_string_literal] = ACTIONS(515),
    [sym__external_else] = ACTIONS(515),
    [sym__external_open_parenthesis] = ACTIONS(197),
    [sym__external_close_parenthesis] = ACTIONS(515),
    [sym__external_open_brace] = ACTIONS(515),
    [sym__external_open_bracket] = ACTIONS(199),
    [sym__external_open_bracket2] = ACTIONS(201),
  },
  [137] = {
    [sym_call_arguments] = STATE(888),
    [sym_subset_arguments] = STATE(892),
    [sym_subset2_arguments] = STATE(895),
    [sym__open_parenthesis] = STATE(345),
    [sym__open_bracket] = STATE(346),
    [sym__open_bracket2] = STATE(347),
    [sym_identifier] = ACTIONS(521),
    [anon_sym_BSLASH] = ACTIONS(519),
    [anon_sym_function] = ACTIONS(521),
    [anon_sym_EQ] = ACTIONS(157),
    [anon_sym_if] = ACTIONS(521),
    [anon_sym_for] = ACTIONS(521),
    [anon_sym_while] = ACTIONS(521),
    [anon_sym_repeat] = ACTIONS(521),
    [anon_sym_QMARK] = ACTIONS(519),
    [anon_sym_TILDE] = ACTIONS(159),
    [anon_sym_BANG] = ACTIONS(521),
    [anon_sym_PLUS] = ACTIONS(161),
    [anon_sym_DASH] = ACTIONS(163),
    [anon_sym_LT_DASH] = ACTIONS(165),
    [anon_sym_LT_LT_DASH] = ACTIONS(165),
    [anon_sym_COLON_EQ] = ACTIONS(165),
    [anon_sym_DASH_GT] = ACTIONS(167),
    [anon_sym_DASH_GT_GT] = ACTIONS(169),
    [anon_sym_PIPE] = ACTIONS(171),
    [anon_sym_AMP] = ACTIONS(173),
    [anon_sym_PIPE_PIPE] = ACTIONS(175),
    [anon_sym_AMP_AMP] = ACTIONS(177),
    [anon_sym_LT] = ACTIONS(179),
    [anon_sym_LT_EQ] = ACTIONS(181),
    [anon_sym_GT] = ACTIONS(179),
    [anon_sym_GT_EQ] = ACTIONS(181),
    [anon_sym_EQ_EQ] = ACTIONS(181),
    [anon_sym_BANG_EQ] = ACTIONS(181),
    [anon_sym_STAR] = ACTIONS(183),
    [anon_sym_SLASH] = ACTIONS(185),
    [anon_sym_STAR_STAR] = ACTIONS(187),
    [anon_sym_CARET] = ACTIONS(187),
    [aux_sym_binary_operator_token1] = ACTIONS(189),
    [anon_sym_PIPE_GT] = ACTIONS(189),
    [anon_sym_COLON] = ACTIONS(191),
    [anon_sym_DOLLAR] = ACTIONS(193),
    [anon_sym_AT] = ACTIONS(193),
    [aux_sym__hex_literal_token1] = ACTIONS(519),
    [sym__number_literal] = ACTIONS(521),
    [anon_sym_SQUOTE] = ACTIONS(519),
    [anon_sym_DQUOTE] = ACTIONS(519),
    [sym_return] = ACTIONS(521),
    [sym_next] = ACTIONS(521),
    [sym_break] = ACTIONS(521),
    [sym_true] = ACTIONS(521),
    [sym_false] = ACTIONS(521),
    [sym_null] = ACTIONS(521),
    [sym_inf] = ACTIONS(521),
    [sym_nan] = ACTIONS(521),
    [anon_sym_NA] = ACTIONS(521),
    [anon_sym_NA_integer_] = ACTIONS(521),
    [anon_sym_NA_real_] = ACTIONS(521),
    [anon_sym_NA_complex_] = ACTIONS(521),
    [anon_sym_NA_character_] = ACTIONS(521),
    [sym_dots] = ACTIONS(521),
    [sym_dot_dot_i] = ACTIONS(519),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(519),
    [sym__newline] = ACTIONS(519),
    [sym__raw_string_literal] = ACTIONS(519),
    [sym__external_else] = ACTIONS(519),
    [sym__external_open_parenthesis] = ACTIONS(197),
    [sym__external_close_parenthesis] = ACTIONS(519),
    [sym__external_open_brace] = ACTIONS(519),
    [sym__external_open_bracket] = ACTIONS(199),
    [sym__external_open_bracket2] = ACTIONS(201),
  },
  [138] = {
    [sym_call_arguments] = STATE(888),
    [sym_subset_arguments] = STATE(892),
    [sym_subset2_arguments] = STATE(895),
    [sym__open_parenthesis] = STATE(345),
    [sym__open_bracket] = STATE(346),
    [sym__open_bracket2] = STATE(347),
    [sym_identifier] = ACTIONS(525),
    [anon_sym_BSLASH] = ACTIONS(523),
    [anon_sym_function] = ACTIONS(525),
    [anon_sym_EQ] = ACTIONS(157),
    [anon_sym_if] = ACTIONS(525),
    [anon_sym_for] = ACTIONS(525),
    [anon_sym_while] = ACTIONS(525),
    [anon_sym_repeat] = ACTIONS(525),
    [anon_sym_QMARK] = ACTIONS(523),
    [anon_sym_TILDE] = ACTIONS(159),
    [anon_sym_BANG] = ACTIONS(525),
    [anon_sym_PLUS] = ACTIONS(161),
    [anon_sym_DASH] = ACTIONS(163),
    [anon_sym_LT_DASH] = ACTIONS(165),
    [anon_sym_LT_LT_DASH] = ACTIONS(165),
    [anon_sym_COLON_EQ] = ACTIONS(165),
    [anon_sym_DASH_GT] = ACTIONS(167),
    [anon_sym_DASH_GT_GT] = ACTIONS(169),
    [anon_sym_PIPE] = ACTIONS(171),
    [anon_sym_AMP] = ACTIONS(173),
    [anon_sym_PIPE_PIPE] = ACTIONS(175),
    [anon_sym_AMP_AMP] = ACTIONS(177),
    [anon_sym_LT] = ACTIONS(179),
    [anon_sym_LT_EQ] = ACTIONS(181),
    [anon_sym_GT] = ACTIONS(179),
    [anon_sym_GT_EQ] = ACTIONS(181),
    [anon_sym_EQ_EQ] = ACTIONS(181),
    [anon_sym_BANG_EQ] = ACTIONS(181),
    [anon_sym_STAR] = ACTIONS(183),
    [anon_sym_SLASH] = ACTIONS(185),
    [anon_sym_STAR_STAR] = ACTIONS(187),
    [anon_sym_CARET] = ACTIONS(187),
    [aux_sym_binary_operator_token1] = ACTIONS(189),
    [anon_sym_PIPE_GT] = ACTIONS(189),
    [anon_sym_COLON] = ACTIONS(191),
    [anon_sym_DOLLAR] = ACTIONS(193),
    [anon_sym_AT] = ACTIONS(193),
    [aux_sym__hex_literal_token1] = ACTIONS(523),
    [sym__number_literal] = ACTIONS(525),
    [anon_sym_SQUOTE] = ACTIONS(523),
    [anon_sym_DQUOTE] = ACTIONS(523),
    [sym_return] = ACTIONS(525),
    [sym_next] = ACTIONS(525),
    [sym_break] = ACTIONS(525),
    [sym_true] = ACTIONS(525),
    [sym_false] = ACTIONS(525),
    [sym_null] = ACTIONS(525),
    [sym_inf] = ACTIONS(525),
    [sym_nan] = ACTIONS(525),
    [anon_sym_NA] = ACTIONS(525),
    [anon_sym_NA_integer_] = ACTIONS(525),
    [anon_sym_NA_real_] = ACTIONS(525),
    [anon_sym_NA_complex_] = ACTIONS(525),
    [anon_sym_NA_character_] = ACTIONS(525),
    [sym_dots] = ACTIONS(525),
    [sym_dot_dot_i] = ACTIONS(523),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(523),
    [sym__newline] = ACTIONS(523),
    [sym__raw_string_literal] = ACTIONS(523),
    [sym__external_else] = ACTIONS(523),
    [sym__external_open_parenthesis] = ACTIONS(197),
    [sym__external_close_parenthesis] = ACTIONS(523),
    [sym__external_open_brace] = ACTIONS(523),
    [sym__external_open_bracket] = ACTIONS(199),
    [sym__external_open_bracket2] = ACTIONS(201),
  },
  [139] = {
    [sym_call_arguments] = STATE(888),
    [sym_subset_arguments] = STATE(892),
    [sym_subset2_arguments] = STATE(895),
    [sym__open_parenthesis] = STATE(345),
    [sym__open_bracket] = STATE(346),
    [sym__open_bracket2] = STATE(347),
    [sym_identifier] = ACTIONS(529),
    [anon_sym_BSLASH] = ACTIONS(527),
    [anon_sym_function] = ACTIONS(529),
    [anon_sym_EQ] = ACTIONS(157),
    [anon_sym_if] = ACTIONS(529),
    [anon_sym_for] = ACTIONS(529),
    [anon_sym_while] = ACTIONS(529),
    [anon_sym_repeat] = ACTIONS(529),
    [anon_sym_QMARK] = ACTIONS(527),
    [anon_sym_TILDE] = ACTIONS(159),
    [anon_sym_BANG] = ACTIONS(529),
    [anon_sym_PLUS] = ACTIONS(161),
    [anon_sym_DASH] = ACTIONS(163),
    [anon_sym_LT_DASH] = ACTIONS(165),
    [anon_sym_LT_LT_DASH] = ACTIONS(165),
    [anon_sym_COLON_EQ] = ACTIONS(165),
    [anon_sym_DASH_GT] = ACTIONS(167),
    [anon_sym_DASH_GT_GT] = ACTIONS(169),
    [anon_sym_PIPE] = ACTIONS(171),
    [anon_sym_AMP] = ACTIONS(173),
    [anon_sym_PIPE_PIPE] = ACTIONS(175),
    [anon_sym_AMP_AMP] = ACTIONS(177),
    [anon_sym_LT] = ACTIONS(179),
    [anon_sym_LT_EQ] = ACTIONS(181),
    [anon_sym_GT] = ACTIONS(179),
    [anon_sym_GT_EQ] = ACTIONS(181),
    [anon_sym_EQ_EQ] = ACTIONS(181),
    [anon_sym_BANG_EQ] = ACTIONS(181),
    [anon_sym_STAR] = ACTIONS(183),
    [anon_sym_SLASH] = ACTIONS(185),
    [anon_sym_STAR_STAR] = ACTIONS(187),
    [anon_sym_CARET] = ACTIONS(187),
    [aux_sym_binary_operator_token1] = ACTIONS(189),
    [anon_sym_PIPE_GT] = ACTIONS(189),
    [anon_sym_COLON] = ACTIONS(191),
    [anon_sym_DOLLAR] = ACTIONS(193),
    [anon_sym_AT] = ACTIONS(193),
    [aux_sym__hex_literal_token1] = ACTIONS(527),
    [sym__number_literal] = ACTIONS(529),
    [anon_sym_SQUOTE] = ACTIONS(527),
    [anon_sym_DQUOTE] = ACTIONS(527),
    [sym_return] = ACTIONS(529),
    [sym_next] = ACTIONS(529),
    [sym_break] = ACTIONS(529),
    [sym_true] = ACTIONS(529),
    [sym_false] = ACTIONS(529),
    [sym_null] = ACTIONS(529),
    [sym_inf] = ACTIONS(529),
    [sym_nan] = ACTIONS(529),
    [anon_sym_NA] = ACTIONS(529),
    [anon_sym_NA_integer_] = ACTIONS(529),
    [anon_sym_NA_real_] = ACTIONS(529),
    [anon_sym_NA_complex_] = ACTIONS(529),
    [anon_sym_NA_character_] = ACTIONS(529),
    [sym_dots] = ACTIONS(529),
    [sym_dot_dot_i] = ACTIONS(527),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(527),
    [sym__newline] = ACTIONS(527),
    [sym__raw_string_literal] = ACTIONS(527),
    [sym__external_else] = ACTIONS(527),
    [sym__external_open_parenthesis] = ACTIONS(197),
    [sym__external_close_parenthesis] = ACTIONS(527),
    [sym__external_open_brace] = ACTIONS(527),
    [sym__external_open_bracket] = ACTIONS(199),
    [sym__external_open_bracket2] = ACTIONS(201),
  },
  [140] = {
    [sym_call_arguments] = STATE(888),
    [sym_subset_arguments] = STATE(892),
    [sym_subset2_arguments] = STATE(895),
    [sym__open_parenthesis] = STATE(345),
    [sym__open_bracket] = STATE(346),
    [sym__open_bracket2] = STATE(347),
    [sym_identifier] = ACTIONS(533),
    [anon_sym_BSLASH] = ACTIONS(531),
    [anon_sym_function] = ACTIONS(533),
    [anon_sym_EQ] = ACTIONS(157),
    [anon_sym_if] = ACTIONS(533),
    [anon_sym_for] = ACTIONS(533),
    [anon_sym_while] = ACTIONS(533),
    [anon_sym_repeat] = ACTIONS(533),
    [anon_sym_QMARK] = ACTIONS(531),
    [anon_sym_TILDE] = ACTIONS(159),
    [anon_sym_BANG] = ACTIONS(533),
    [anon_sym_PLUS] = ACTIONS(161),
    [anon_sym_DASH] = ACTIONS(163),
    [anon_sym_LT_DASH] = ACTIONS(165),
    [anon_sym_LT_LT_DASH] = ACTIONS(165),
    [anon_sym_COLON_EQ] = ACTIONS(165),
    [anon_sym_DASH_GT] = ACTIONS(167),
    [anon_sym_DASH_GT_GT] = ACTIONS(169),
    [anon_sym_PIPE] = ACTIONS(171),
    [anon_sym_AMP] = ACTIONS(173),
    [anon_sym_PIPE_PIPE] = ACTIONS(175),
    [anon_sym_AMP_AMP] = ACTIONS(177),
    [anon_sym_LT] = ACTIONS(179),
    [anon_sym_LT_EQ] = ACTIONS(181),
    [anon_sym_GT] = ACTIONS(179),
    [anon_sym_GT_EQ] = ACTIONS(181),
    [anon_sym_EQ_EQ] = ACTIONS(181),
    [anon_sym_BANG_EQ] = ACTIONS(181),
    [anon_sym_STAR] = ACTIONS(183),
    [anon_sym_SLASH] = ACTIONS(185),
    [anon_sym_STAR_STAR] = ACTIONS(187),
    [anon_sym_CARET] = ACTIONS(187),
    [aux_sym_binary_operator_token1] = ACTIONS(189),
    [anon_sym_PIPE_GT] = ACTIONS(189),
    [anon_sym_COLON] = ACTIONS(191),
    [anon_sym_DOLLAR] = ACTIONS(193),
    [anon_sym_AT] = ACTIONS(193),
    [aux_sym__hex_literal_token1] = ACTIONS(531),
    [sym__number_literal] = ACTIONS(533),
    [anon_sym_SQUOTE] = ACTIONS(531),
    [anon_sym_DQUOTE] = ACTIONS(531),
    [sym_return] = ACTIONS(533),
    [sym_next] = ACTIONS(533),
    [sym_break] = ACTIONS(533),
    [sym_true] = ACTIONS(533),
    [sym_false] = ACTIONS(533),
    [sym_null] = ACTIONS(533),
    [sym_inf] = ACTIONS(533),
    [sym_nan] = ACTIONS(533),
    [anon_sym_NA] = ACTIONS(533),
    [anon_sym_NA_integer_] = ACTIONS(533),
    [anon_sym_NA_real_] = ACTIONS(533),
    [anon_sym_NA_complex_] = ACTIONS(533),
    [anon_sym_NA_character_] = ACTIONS(533),
    [sym_dots] = ACTIONS(533),
    [sym_dot_dot_i] = ACTIONS(531),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(531),
    [sym__newline] = ACTIONS(531),
    [sym__raw_string_literal] = ACTIONS(531),
    [sym__external_else] = ACTIONS(531),
    [sym__external_open_parenthesis] = ACTIONS(197),
    [sym__external_close_parenthesis] = ACTIONS(531),
    [sym__external_open_brace] = ACTIONS(531),
    [sym__external_open_bracket] = ACTIONS(199),
    [sym__external_open_bracket2] = ACTIONS(201),
  },
  [141] = {
    [sym_call_arguments] = STATE(888),
    [sym_subset_arguments] = STATE(892),
    [sym_subset2_arguments] = STATE(895),
    [sym__open_parenthesis] = STATE(345),
    [sym__open_bracket] = STATE(346),
    [sym__open_bracket2] = STATE(347),
    [sym_identifier] = ACTIONS(537),
    [anon_sym_BSLASH] = ACTIONS(535),
    [anon_sym_function] = ACTIONS(537),
    [anon_sym_EQ] = ACTIONS(157),
    [anon_sym_if] = ACTIONS(537),
    [anon_sym_for] = ACTIONS(537),
    [anon_sym_while] = ACTIONS(537),
    [anon_sym_repeat] = ACTIONS(537),
    [anon_sym_QMARK] = ACTIONS(535),
    [anon_sym_TILDE] = ACTIONS(159),
    [anon_sym_BANG] = ACTIONS(537),
    [anon_sym_PLUS] = ACTIONS(161),
    [anon_sym_DASH] = ACTIONS(163),
    [anon_sym_LT_DASH] = ACTIONS(165),
    [anon_sym_LT_LT_DASH] = ACTIONS(165),
    [anon_sym_COLON_EQ] = ACTIONS(165),
    [anon_sym_DASH_GT] = ACTIONS(167),
    [anon_sym_DASH_GT_GT] = ACTIONS(169),
    [anon_sym_PIPE] = ACTIONS(171),
    [anon_sym_AMP] = ACTIONS(173),
    [anon_sym_PIPE_PIPE] = ACTIONS(175),
    [anon_sym_AMP_AMP] = ACTIONS(177),
    [anon_sym_LT] = ACTIONS(179),
    [anon_sym_LT_EQ] = ACTIONS(181),
    [anon_sym_GT] = ACTIONS(179),
    [anon_sym_GT_EQ] = ACTIONS(181),
    [anon_sym_EQ_EQ] = ACTIONS(181),
    [anon_sym_BANG_EQ] = ACTIONS(181),
    [anon_sym_STAR] = ACTIONS(183),
    [anon_sym_SLASH] = ACTIONS(185),
    [anon_sym_STAR_STAR] = ACTIONS(187),
    [anon_sym_CARET] = ACTIONS(187),
    [aux_sym_binary_operator_token1] = ACTIONS(189),
    [anon_sym_PIPE_GT] = ACTIONS(189),
    [anon_sym_COLON] = ACTIONS(191),
    [anon_sym_DOLLAR] = ACTIONS(193),
    [anon_sym_AT] = ACTIONS(193),
    [aux_sym__hex_literal_token1] = ACTIONS(535),
    [sym__number_literal] = ACTIONS(537),
    [anon_sym_SQUOTE] = ACTIONS(535),
    [anon_sym_DQUOTE] = ACTIONS(535),
    [sym_return] = ACTIONS(537),
    [sym_next] = ACTIONS(537),
    [sym_break] = ACTIONS(537),
    [sym_true] = ACTIONS(537),
    [sym_false] = ACTIONS(537),
    [sym_null] = ACTIONS(537),
    [sym_inf] = ACTIONS(537),
    [sym_nan] = ACTIONS(537),
    [anon_sym_NA] = ACTIONS(537),
    [anon_sym_NA_integer_] = ACTIONS(537),
    [anon_sym_NA_real_] = ACTIONS(537),
    [anon_sym_NA_complex_] = ACTIONS(537),
    [anon_sym_NA_character_] = ACTIONS(537),
    [sym_dots] = ACTIONS(537),
    [sym_dot_dot_i] = ACTIONS(535),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(535),
    [sym__newline] = ACTIONS(535),
    [sym__raw_string_literal] = ACTIONS(535),
    [sym__external_else] = ACTIONS(535),
    [sym__external_open_parenthesis] = ACTIONS(197),
    [sym__external_close_parenthesis] = ACTIONS(535),
    [sym__external_open_brace] = ACTIONS(535),
    [sym__external_open_bracket] = ACTIONS(199),
    [sym__external_open_bracket2] = ACTIONS(201),
  },
  [142] = {
    [sym_call_arguments] = STATE(888),
    [sym_subset_arguments] = STATE(892),
    [sym_subset2_arguments] = STATE(895),
    [sym__open_parenthesis] = STATE(345),
    [sym__open_bracket] = STATE(346),
    [sym__open_bracket2] = STATE(347),
    [sym_identifier] = ACTIONS(541),
    [anon_sym_BSLASH] = ACTIONS(539),
    [anon_sym_function] = ACTIONS(541),
    [anon_sym_EQ] = ACTIONS(157),
    [anon_sym_if] = ACTIONS(541),
    [anon_sym_for] = ACTIONS(541),
    [anon_sym_while] = ACTIONS(541),
    [anon_sym_repeat] = ACTIONS(541),
    [anon_sym_QMARK] = ACTIONS(539),
    [anon_sym_TILDE] = ACTIONS(159),
    [anon_sym_BANG] = ACTIONS(541),
    [anon_sym_PLUS] = ACTIONS(161),
    [anon_sym_DASH] = ACTIONS(163),
    [anon_sym_LT_DASH] = ACTIONS(165),
    [anon_sym_LT_LT_DASH] = ACTIONS(165),
    [anon_sym_COLON_EQ] = ACTIONS(165),
    [anon_sym_DASH_GT] = ACTIONS(167),
    [anon_sym_DASH_GT_GT] = ACTIONS(169),
    [anon_sym_PIPE] = ACTIONS(171),
    [anon_sym_AMP] = ACTIONS(173),
    [anon_sym_PIPE_PIPE] = ACTIONS(175),
    [anon_sym_AMP_AMP] = ACTIONS(177),
    [anon_sym_LT] = ACTIONS(179),
    [anon_sym_LT_EQ] = ACTIONS(181),
    [anon_sym_GT] = ACTIONS(179),
    [anon_sym_GT_EQ] = ACTIONS(181),
    [anon_sym_EQ_EQ] = ACTIONS(181),
    [anon_sym_BANG_EQ] = ACTIONS(181),
    [anon_sym_STAR] = ACTIONS(183),
    [anon_sym_SLASH] = ACTIONS(185),
    [anon_sym_STAR_STAR] = ACTIONS(187),
    [anon_sym_CARET] = ACTIONS(187),
    [aux_sym_binary_operator_token1] = ACTIONS(189),
    [anon_sym_PIPE_GT] = ACTIONS(189),
    [anon_sym_COLON] = ACTIONS(191),
    [anon_sym_DOLLAR] = ACTIONS(193),
    [anon_sym_AT] = ACTIONS(193),
    [aux_sym__hex_literal_token1] = ACTIONS(539),
    [sym__number_literal] = ACTIONS(541),
    [anon_sym_SQUOTE] = ACTIONS(539),
    [anon_sym_DQUOTE] = ACTIONS(539),
    [sym_return] = ACTIONS(541),
    [sym_next] = ACTIONS(541),
    [sym_break] = ACTIONS(541),
    [sym_true] = ACTIONS(541),
    [sym_false] = ACTIONS(541),
    [sym_null] = ACTIONS(541),
    [sym_inf] = ACTIONS(541),
    [sym_nan] = ACTIONS(541),
    [anon_sym_NA] = ACTIONS(541),
    [anon_sym_NA_integer_] = ACTIONS(541),
    [anon_sym_NA_real_] = ACTIONS(541),
    [anon_sym_NA_complex_] = ACTIONS(541),
    [anon_sym_NA_character_] = ACTIONS(541),
    [sym_dots] = ACTIONS(541),
    [sym_dot_dot_i] = ACTIONS(539),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(539),
    [sym__newline] = ACTIONS(539),
    [sym__raw_string_literal] = ACTIONS(539),
    [sym__external_else] = ACTIONS(539),
    [sym__external_open_parenthesis] = ACTIONS(197),
    [sym__external_close_parenthesis] = ACTIONS(539),
    [sym__external_open_brace] = ACTIONS(539),
    [sym__external_open_bracket] = ACTIONS(199),
    [sym__external_open_bracket2] = ACTIONS(201),
  },
  [143] = {
    [sym_call_arguments] = STATE(850),
    [sym_subset_arguments] = STATE(851),
    [sym_subset2_arguments] = STATE(852),
    [sym__open_parenthesis] = STATE(349),
    [sym__open_bracket] = STATE(350),
    [sym__open_bracket2] = STATE(351),
    [sym_identifier] = ACTIONS(543),
    [anon_sym_BSLASH] = ACTIONS(545),
    [anon_sym_function] = ACTIONS(543),
    [anon_sym_EQ] = ACTIONS(213),
    [anon_sym_if] = ACTIONS(543),
    [anon_sym_for] = ACTIONS(543),
    [anon_sym_while] = ACTIONS(543),
    [anon_sym_repeat] = ACTIONS(543),
    [anon_sym_QMARK] = ACTIONS(545),
    [anon_sym_TILDE] = ACTIONS(215),
    [anon_sym_BANG] = ACTIONS(543),
    [anon_sym_PLUS] = ACTIONS(217),
    [anon_sym_DASH] = ACTIONS(219),
    [anon_sym_LT_DASH] = ACTIONS(221),
    [anon_sym_LT_LT_DASH] = ACTIONS(221),
    [anon_sym_COLON_EQ] = ACTIONS(221),
    [anon_sym_DASH_GT] = ACTIONS(223),
    [anon_sym_DASH_GT_GT] = ACTIONS(225),
    [anon_sym_PIPE] = ACTIONS(227),
    [anon_sym_AMP] = ACTIONS(229),
    [anon_sym_PIPE_PIPE] = ACTIONS(231),
    [anon_sym_AMP_AMP] = ACTIONS(233),
    [anon_sym_LT] = ACTIONS(235),
    [anon_sym_LT_EQ] = ACTIONS(237),
    [anon_sym_GT] = ACTIONS(235),
    [anon_sym_GT_EQ] = ACTIONS(237),
    [anon_sym_EQ_EQ] = ACTIONS(237),
    [anon_sym_BANG_EQ] = ACTIONS(237),
    [anon_sym_STAR] = ACTIONS(239),
    [anon_sym_SLASH] = ACTIONS(241),
    [anon_sym_STAR_STAR] = ACTIONS(243),
    [anon_sym_CARET] = ACTIONS(243),
    [aux_sym_binary_operator_token1] = ACTIONS(245),
    [anon_sym_PIPE_GT] = ACTIONS(245),
    [anon_sym_COLON] = ACTIONS(247),
    [anon_sym_DOLLAR] = ACTIONS(249),
    [anon_sym_AT] = ACTIONS(249),
    [aux_sym__hex_literal_token1] = ACTIONS(545),
    [sym__number_literal] = ACTIONS(543),
    [anon_sym_SQUOTE] = ACTIONS(545),
    [anon_sym_DQUOTE] = ACTIONS(545),
    [sym_return] = ACTIONS(543),
    [sym_next] = ACTIONS(543),
    [sym_break] = ACTIONS(543),
    [sym_true] = ACTIONS(543),
    [sym_false] = ACTIONS(543),
    [sym_null] = ACTIONS(543),
    [sym_inf] = ACTIONS(543),
    [sym_nan] = ACTIONS(543),
    [anon_sym_NA] = ACTIONS(543),
    [anon_sym_NA_integer_] = ACTIONS(543),
    [anon_sym_NA_real_] = ACTIONS(543),
    [anon_sym_NA_complex_] = ACTIONS(543),
    [anon_sym_NA_character_] = ACTIONS(543),
    [sym_dots] = ACTIONS(543),
    [sym_dot_dot_i] = ACTIONS(545),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(545),
    [sym__semicolon] = ACTIONS(545),
    [sym__raw_string_literal] = ACTIONS(545),
    [sym__external_else] = ACTIONS(545),
    [sym__external_open_parenthesis] = ACTIONS(253),
    [sym__external_open_brace] = ACTIONS(545),
    [sym__external_close_brace] = ACTIONS(545),
    [sym__external_open_bracket] = ACTIONS(255),
    [sym__external_open_bracket2] = ACTIONS(257),
  },
  [144] = {
    [sym_call_arguments] = STATE(850),
    [sym_subset_arguments] = STATE(851),
    [sym_subset2_arguments] = STATE(852),
    [sym__open_parenthesis] = STATE(349),
    [sym__open_bracket] = STATE(350),
    [sym__open_bracket2] = STATE(351),
    [sym_identifier] = ACTIONS(367),
    [anon_sym_BSLASH] = ACTIONS(369),
    [anon_sym_function] = ACTIONS(367),
    [anon_sym_EQ] = ACTIONS(213),
    [anon_sym_if] = ACTIONS(367),
    [anon_sym_for] = ACTIONS(367),
    [anon_sym_while] = ACTIONS(367),
    [anon_sym_repeat] = ACTIONS(367),
    [anon_sym_QMARK] = ACTIONS(369),
    [anon_sym_TILDE] = ACTIONS(215),
    [anon_sym_BANG] = ACTIONS(367),
    [anon_sym_PLUS] = ACTIONS(217),
    [anon_sym_DASH] = ACTIONS(219),
    [anon_sym_LT_DASH] = ACTIONS(221),
    [anon_sym_LT_LT_DASH] = ACTIONS(221),
    [anon_sym_COLON_EQ] = ACTIONS(221),
    [anon_sym_DASH_GT] = ACTIONS(223),
    [anon_sym_DASH_GT_GT] = ACTIONS(225),
    [anon_sym_PIPE] = ACTIONS(227),
    [anon_sym_AMP] = ACTIONS(229),
    [anon_sym_PIPE_PIPE] = ACTIONS(231),
    [anon_sym_AMP_AMP] = ACTIONS(233),
    [anon_sym_LT] = ACTIONS(235),
    [anon_sym_LT_EQ] = ACTIONS(237),
    [anon_sym_GT] = ACTIONS(235),
    [anon_sym_GT_EQ] = ACTIONS(237),
    [anon_sym_EQ_EQ] = ACTIONS(237),
    [anon_sym_BANG_EQ] = ACTIONS(237),
    [anon_sym_STAR] = ACTIONS(239),
    [anon_sym_SLASH] = ACTIONS(241),
    [anon_sym_STAR_STAR] = ACTIONS(243),
    [anon_sym_CARET] = ACTIONS(243),
    [aux_sym_binary_operator_token1] = ACTIONS(245),
    [anon_sym_PIPE_GT] = ACTIONS(245),
    [anon_sym_COLON] = ACTIONS(247),
    [anon_sym_DOLLAR] = ACTIONS(249),
    [anon_sym_AT] = ACTIONS(249),
    [aux_sym__hex_literal_token1] = ACTIONS(369),
    [sym__number_literal] = ACTIONS(367),
    [anon_sym_SQUOTE] = ACTIONS(369),
    [anon_sym_DQUOTE] = ACTIONS(369),
    [sym_return] = ACTIONS(367),
    [sym_next] = ACTIONS(367),
    [sym_break] = ACTIONS(367),
    [sym_true] = ACTIONS(367),
    [sym_false] = ACTIONS(367),
    [sym_null] = ACTIONS(367),
    [sym_inf] = ACTIONS(367),
    [sym_nan] = ACTIONS(367),
    [anon_sym_NA] = ACTIONS(367),
    [anon_sym_NA_integer_] = ACTIONS(367),
    [anon_sym_NA_real_] = ACTIONS(367),
    [anon_sym_NA_complex_] = ACTIONS(367),
    [anon_sym_NA_character_] = ACTIONS(367),
    [sym_dots] = ACTIONS(367),
    [sym_dot_dot_i] = ACTIONS(369),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(369),
    [sym__semicolon] = ACTIONS(369),
    [sym__raw_string_literal] = ACTIONS(369),
    [sym__external_else] = ACTIONS(369),
    [sym__external_open_parenthesis] = ACTIONS(253),
    [sym__external_open_brace] = ACTIONS(369),
    [sym__external_close_brace] = ACTIONS(369),
    [sym__external_open_bracket] = ACTIONS(255),
    [sym__external_open_bracket2] = ACTIONS(257),
  },
  [145] = {
    [sym_call_arguments] = STATE(850),
    [sym_subset_arguments] = STATE(851),
    [sym_subset2_arguments] = STATE(852),
    [sym__open_parenthesis] = STATE(349),
    [sym__open_bracket] = STATE(350),
    [sym__open_bracket2] = STATE(351),
    [sym_identifier] = ACTIONS(367),
    [anon_sym_BSLASH] = ACTIONS(369),
    [anon_sym_function] = ACTIONS(367),
    [anon_sym_EQ] = ACTIONS(367),
    [anon_sym_if] = ACTIONS(367),
    [anon_sym_for] = ACTIONS(367),
    [anon_sym_while] = ACTIONS(367),
    [anon_sym_repeat] = ACTIONS(367),
    [anon_sym_QMARK] = ACTIONS(369),
    [anon_sym_TILDE] = ACTIONS(369),
    [anon_sym_BANG] = ACTIONS(367),
    [anon_sym_PLUS] = ACTIONS(217),
    [anon_sym_DASH] = ACTIONS(219),
    [anon_sym_LT_DASH] = ACTIONS(369),
    [anon_sym_LT_LT_DASH] = ACTIONS(369),
    [anon_sym_COLON_EQ] = ACTIONS(369),
    [anon_sym_DASH_GT] = ACTIONS(367),
    [anon_sym_DASH_GT_GT] = ACTIONS(369),
    [anon_sym_PIPE] = ACTIONS(227),
    [anon_sym_AMP] = ACTIONS(229),
    [anon_sym_PIPE_PIPE] = ACTIONS(231),
    [anon_sym_AMP_AMP] = ACTIONS(233),
    [anon_sym_LT] = ACTIONS(235),
    [anon_sym_LT_EQ] = ACTIONS(237),
    [anon_sym_GT] = ACTIONS(235),
    [anon_sym_GT_EQ] = ACTIONS(237),
    [anon_sym_EQ_EQ] = ACTIONS(237),
    [anon_sym_BANG_EQ] = ACTIONS(237),
    [anon_sym_STAR] = ACTIONS(239),
    [anon_sym_SLASH] = ACTIONS(241),
    [anon_sym_STAR_STAR] = ACTIONS(243),
    [anon_sym_CARET] = ACTIONS(243),
    [aux_sym_binary_operator_token1] = ACTIONS(245),
    [anon_sym_PIPE_GT] = ACTIONS(245),
    [anon_sym_COLON] = ACTIONS(247),
    [anon_sym_DOLLAR] = ACTIONS(249),
    [anon_sym_AT] = ACTIONS(249),
    [aux_sym__hex_literal_token1] = ACTIONS(369),
    [sym__number_literal] = ACTIONS(367),
    [anon_sym_SQUOTE] = ACTIONS(369),
    [anon_sym_DQUOTE] = ACTIONS(369),
    [sym_return] = ACTIONS(367),
    [sym_next] = ACTIONS(367),
    [sym_break] = ACTIONS(367),
    [sym_true] = ACTIONS(367),
    [sym_false] = ACTIONS(367),
    [sym_null] = ACTIONS(367),
    [sym_inf] = ACTIONS(367),
    [sym_nan] = ACTIONS(367),
    [anon_sym_NA] = ACTIONS(367),
    [anon_sym_NA_integer_] = ACTIONS(367),
    [anon_sym_NA_real_] = ACTIONS(367),
    [anon_sym_NA_complex_] = ACTIONS(367),
    [anon_sym_NA_character_] = ACTIONS(367),
    [sym_dots] = ACTIONS(367),
    [sym_dot_dot_i] = ACTIONS(369),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(369),
    [sym__semicolon] = ACTIONS(369),
    [sym__raw_string_literal] = ACTIONS(369),
    [sym__external_else] = ACTIONS(369),
    [sym__external_open_parenthesis] = ACTIONS(253),
    [sym__external_open_brace] = ACTIONS(369),
    [sym__external_close_brace] = ACTIONS(369),
    [sym__external_open_bracket] = ACTIONS(255),
    [sym__external_open_bracket2] = ACTIONS(257),
  },
  [146] = {
    [sym_call_arguments] = STATE(850),
    [sym_subset_arguments] = STATE(851),
    [sym_subset2_arguments] = STATE(852),
    [sym__open_parenthesis] = STATE(349),
    [sym__open_bracket] = STATE(350),
    [sym__open_bracket2] = STATE(351),
    [sym_identifier] = ACTIONS(367),
    [anon_sym_BSLASH] = ACTIONS(369),
    [anon_sym_function] = ACTIONS(367),
    [anon_sym_EQ] = ACTIONS(367),
    [anon_sym_if] = ACTIONS(367),
    [anon_sym_for] = ACTIONS(367),
    [anon_sym_while] = ACTIONS(367),
    [anon_sym_repeat] = ACTIONS(367),
    [anon_sym_QMARK] = ACTIONS(369),
    [anon_sym_TILDE] = ACTIONS(369),
    [anon_sym_BANG] = ACTIONS(367),
    [anon_sym_PLUS] = ACTIONS(217),
    [anon_sym_DASH] = ACTIONS(219),
    [anon_sym_LT_DASH] = ACTIONS(369),
    [anon_sym_LT_LT_DASH] = ACTIONS(369),
    [anon_sym_COLON_EQ] = ACTIONS(369),
    [anon_sym_DASH_GT] = ACTIONS(367),
    [anon_sym_DASH_GT_GT] = ACTIONS(369),
    [anon_sym_PIPE] = ACTIONS(367),
    [anon_sym_AMP] = ACTIONS(367),
    [anon_sym_PIPE_PIPE] = ACTIONS(369),
    [anon_sym_AMP_AMP] = ACTIONS(369),
    [anon_sym_LT] = ACTIONS(235),
    [anon_sym_LT_EQ] = ACTIONS(237),
    [anon_sym_GT] = ACTIONS(235),
    [anon_sym_GT_EQ] = ACTIONS(237),
    [anon_sym_EQ_EQ] = ACTIONS(237),
    [anon_sym_BANG_EQ] = ACTIONS(237),
    [anon_sym_STAR] = ACTIONS(239),
    [anon_sym_SLASH] = ACTIONS(241),
    [anon_sym_STAR_STAR] = ACTIONS(243),
    [anon_sym_CARET] = ACTIONS(243),
    [aux_sym_binary_operator_token1] = ACTIONS(245),
    [anon_sym_PIPE_GT] = ACTIONS(245),
    [anon_sym_COLON] = ACTIONS(247),
    [anon_sym_DOLLAR] = ACTIONS(249),
    [anon_sym_AT] = ACTIONS(249),
    [aux_sym__hex_literal_token1] = ACTIONS(369),
    [sym__number_literal] = ACTIONS(367),
    [anon_sym_SQUOTE] = ACTIONS(369),
    [anon_sym_DQUOTE] = ACTIONS(369),
    [sym_return] = ACTIONS(367),
    [sym_next] = ACTIONS(367),
    [sym_break] = ACTIONS(367),
    [sym_true] = ACTIONS(367),
    [sym_false] = ACTIONS(367),
    [sym_null] = ACTIONS(367),
    [sym_inf] = ACTIONS(367),
    [sym_nan] = ACTIONS(367),
    [anon_sym_NA] = ACTIONS(367),
    [anon_sym_NA_integer_] = ACTIONS(367),
    [anon_sym_NA_real_] = ACTIONS(367),
    [anon_sym_NA_complex_] = ACTIONS(367),
    [anon_sym_NA_character_] = ACTIONS(367),
    [sym_dots] = ACTIONS(367),
    [sym_dot_dot_i] = ACTIONS(369),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(369),
    [sym__semicolon] = ACTIONS(369),
    [sym__raw_string_literal] = ACTIONS(369),
    [sym__external_else] = ACTIONS(369),
    [sym__external_open_parenthesis] = ACTIONS(253),
    [sym__external_open_brace] = ACTIONS(369),
    [sym__external_close_brace] = ACTIONS(369),
    [sym__external_open_bracket] = ACTIONS(255),
    [sym__external_open_bracket2] = ACTIONS(257),
  },
  [147] = {
    [sym_call_arguments] = STATE(850),
    [sym_subset_arguments] = STATE(851),
    [sym_subset2_arguments] = STATE(852),
    [sym__open_parenthesis] = STATE(349),
    [sym__open_bracket] = STATE(350),
    [sym__open_bracket2] = STATE(351),
    [sym_identifier] = ACTIONS(367),
    [anon_sym_BSLASH] = ACTIONS(369),
    [anon_sym_function] = ACTIONS(367),
    [anon_sym_EQ] = ACTIONS(367),
    [anon_sym_if] = ACTIONS(367),
    [anon_sym_for] = ACTIONS(367),
    [anon_sym_while] = ACTIONS(367),
    [anon_sym_repeat] = ACTIONS(367),
    [anon_sym_QMARK] = ACTIONS(369),
    [anon_sym_TILDE] = ACTIONS(369),
    [anon_sym_BANG] = ACTIONS(367),
    [anon_sym_PLUS] = ACTIONS(369),
    [anon_sym_DASH] = ACTIONS(367),
    [anon_sym_LT_DASH] = ACTIONS(369),
    [anon_sym_LT_LT_DASH] = ACTIONS(369),
    [anon_sym_COLON_EQ] = ACTIONS(369),
    [anon_sym_DASH_GT] = ACTIONS(367),
    [anon_sym_DASH_GT_GT] = ACTIONS(369),
    [anon_sym_PIPE] = ACTIONS(367),
    [anon_sym_AMP] = ACTIONS(367),
    [anon_sym_PIPE_PIPE] = ACTIONS(369),
    [anon_sym_AMP_AMP] = ACTIONS(369),
    [anon_sym_LT] = ACTIONS(367),
    [anon_sym_LT_EQ] = ACTIONS(369),
    [anon_sym_GT] = ACTIONS(367),
    [anon_sym_GT_EQ] = ACTIONS(369),
    [anon_sym_EQ_EQ] = ACTIONS(369),
    [anon_sym_BANG_EQ] = ACTIONS(369),
    [anon_sym_STAR] = ACTIONS(367),
    [anon_sym_SLASH] = ACTIONS(369),
    [anon_sym_STAR_STAR] = ACTIONS(243),
    [anon_sym_CARET] = ACTIONS(243),
    [aux_sym_binary_operator_token1] = ACTIONS(369),
    [anon_sym_PIPE_GT] = ACTIONS(369),
    [anon_sym_COLON] = ACTIONS(367),
    [anon_sym_DOLLAR] = ACTIONS(249),
    [anon_sym_AT] = ACTIONS(249),
    [aux_sym__hex_literal_token1] = ACTIONS(369),
    [sym__number_literal] = ACTIONS(367),
    [anon_sym_SQUOTE] = ACTIONS(369),
    [anon_sym_DQUOTE] = ACTIONS(369),
    [sym_return] = ACTIONS(367),
    [sym_next] = ACTIONS(367),
    [sym_break] = ACTIONS(367),
    [sym_true] = ACTIONS(367),
    [sym_false] = ACTIONS(367),
    [sym_null] = ACTIONS(367),
    [sym_inf] = ACTIONS(367),
    [sym_nan] = ACTIONS(367),
    [anon_sym_NA] = ACTIONS(367),
    [anon_sym_NA_integer_] = ACTIONS(367),
    [anon_sym_NA_real_] = ACTIONS(367),
    [anon_sym_NA_complex_] = ACTIONS(367),
    [anon_sym_NA_character_] = ACTIONS(367),
    [sym_dots] = ACTIONS(367),
    [sym_dot_dot_i] = ACTIONS(369),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(369),
    [sym__semicolon] = ACTIONS(369),
    [sym__raw_string_literal] = ACTIONS(369),
    [sym__external_else] = ACTIONS(369),
    [sym__external_open_parenthesis] = ACTIONS(253),
    [sym__external_open_brace] = ACTIONS(369),
    [sym__external_close_brace] = ACTIONS(369),
    [sym__external_open_bracket] = ACTIONS(255),
    [sym__external_open_bracket2] = ACTIONS(257),
  },
  [148] = {
    [sym_call_arguments] = STATE(850),
    [sym_subset_arguments] = STATE(851),
    [sym_subset2_arguments] = STATE(852),
    [sym__open_parenthesis] = STATE(349),
    [sym__open_bracket] = STATE(350),
    [sym__open_bracket2] = STATE(351),
    [sym_identifier] = ACTIONS(373),
    [anon_sym_BSLASH] = ACTIONS(371),
    [anon_sym_function] = ACTIONS(373),
    [anon_sym_EQ] = ACTIONS(213),
    [anon_sym_if] = ACTIONS(373),
    [anon_sym_for] = ACTIONS(373),
    [anon_sym_while] = ACTIONS(373),
    [anon_sym_repeat] = ACTIONS(373),
    [anon_sym_QMARK] = ACTIONS(371),
    [anon_sym_TILDE] = ACTIONS(215),
    [anon_sym_BANG] = ACTIONS(373),
    [anon_sym_PLUS] = ACTIONS(217),
    [anon_sym_DASH] = ACTIONS(219),
    [anon_sym_LT_DASH] = ACTIONS(221),
    [anon_sym_LT_LT_DASH] = ACTIONS(221),
    [anon_sym_COLON_EQ] = ACTIONS(221),
    [anon_sym_DASH_GT] = ACTIONS(223),
    [anon_sym_DASH_GT_GT] = ACTIONS(225),
    [anon_sym_PIPE] = ACTIONS(227),
    [anon_sym_AMP] = ACTIONS(229),
    [anon_sym_PIPE_PIPE] = ACTIONS(231),
    [anon_sym_AMP_AMP] = ACTIONS(233),
    [anon_sym_LT] = ACTIONS(235),
    [anon_sym_LT_EQ] = ACTIONS(237),
    [anon_sym_GT] = ACTIONS(235),
    [anon_sym_GT_EQ] = ACTIONS(237),
    [anon_sym_EQ_EQ] = ACTIONS(237),
    [anon_sym_BANG_EQ] = ACTIONS(237),
    [anon_sym_STAR] = ACTIONS(239),
    [anon_sym_SLASH] = ACTIONS(241),
    [anon_sym_STAR_STAR] = ACTIONS(243),
    [anon_sym_CARET] = ACTIONS(243),
    [aux_sym_binary_operator_token1] = ACTIONS(245),
    [anon_sym_PIPE_GT] = ACTIONS(245),
    [anon_sym_COLON] = ACTIONS(247),
    [anon_sym_DOLLAR] = ACTIONS(249),
    [anon_sym_AT] = ACTIONS(249),
    [aux_sym__hex_literal_token1] = ACTIONS(371),
    [sym__number_literal] = ACTIONS(373),
    [anon_sym_SQUOTE] = ACTIONS(371),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [sym_return] = ACTIONS(373),
    [sym_next] = ACTIONS(373),
    [sym_break] = ACTIONS(373),
    [sym_true] = ACTIONS(373),
    [sym_false] = ACTIONS(373),
    [sym_null] = ACTIONS(373),
    [sym_inf] = ACTIONS(373),
    [sym_nan] = ACTIONS(373),
    [anon_sym_NA] = ACTIONS(373),
    [anon_sym_NA_integer_] = ACTIONS(373),
    [anon_sym_NA_real_] = ACTIONS(373),
    [anon_sym_NA_complex_] = ACTIONS(373),
    [anon_sym_NA_character_] = ACTIONS(373),
    [sym_dots] = ACTIONS(373),
    [sym_dot_dot_i] = ACTIONS(371),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(371),
    [sym__semicolon] = ACTIONS(371),
    [sym__raw_string_literal] = ACTIONS(371),
    [sym__external_else] = ACTIONS(371),
    [sym__external_open_parenthesis] = ACTIONS(253),
    [sym__external_open_brace] = ACTIONS(371),
    [sym__external_close_brace] = ACTIONS(371),
    [sym__external_open_bracket] = ACTIONS(255),
    [sym__external_open_bracket2] = ACTIONS(257),
  },
  [149] = {
    [sym_call_arguments] = STATE(850),
    [sym_subset_arguments] = STATE(851),
    [sym_subset2_arguments] = STATE(852),
    [sym__open_parenthesis] = STATE(349),
    [sym__open_bracket] = STATE(350),
    [sym__open_bracket2] = STATE(351),
    [sym_identifier] = ACTIONS(377),
    [anon_sym_BSLASH] = ACTIONS(375),
    [anon_sym_function] = ACTIONS(377),
    [anon_sym_EQ] = ACTIONS(213),
    [anon_sym_if] = ACTIONS(377),
    [anon_sym_for] = ACTIONS(377),
    [anon_sym_while] = ACTIONS(377),
    [anon_sym_repeat] = ACTIONS(377),
    [anon_sym_QMARK] = ACTIONS(375),
    [anon_sym_TILDE] = ACTIONS(215),
    [anon_sym_BANG] = ACTIONS(377),
    [anon_sym_PLUS] = ACTIONS(217),
    [anon_sym_DASH] = ACTIONS(219),
    [anon_sym_LT_DASH] = ACTIONS(221),
    [anon_sym_LT_LT_DASH] = ACTIONS(221),
    [anon_sym_COLON_EQ] = ACTIONS(221),
    [anon_sym_DASH_GT] = ACTIONS(223),
    [anon_sym_DASH_GT_GT] = ACTIONS(225),
    [anon_sym_PIPE] = ACTIONS(227),
    [anon_sym_AMP] = ACTIONS(229),
    [anon_sym_PIPE_PIPE] = ACTIONS(231),
    [anon_sym_AMP_AMP] = ACTIONS(233),
    [anon_sym_LT] = ACTIONS(235),
    [anon_sym_LT_EQ] = ACTIONS(237),
    [anon_sym_GT] = ACTIONS(235),
    [anon_sym_GT_EQ] = ACTIONS(237),
    [anon_sym_EQ_EQ] = ACTIONS(237),
    [anon_sym_BANG_EQ] = ACTIONS(237),
    [anon_sym_STAR] = ACTIONS(239),
    [anon_sym_SLASH] = ACTIONS(241),
    [anon_sym_STAR_STAR] = ACTIONS(243),
    [anon_sym_CARET] = ACTIONS(243),
    [aux_sym_binary_operator_token1] = ACTIONS(245),
    [anon_sym_PIPE_GT] = ACTIONS(245),
    [anon_sym_COLON] = ACTIONS(247),
    [anon_sym_DOLLAR] = ACTIONS(249),
    [anon_sym_AT] = ACTIONS(249),
    [aux_sym__hex_literal_token1] = ACTIONS(375),
    [sym__number_literal] = ACTIONS(377),
    [anon_sym_SQUOTE] = ACTIONS(375),
    [anon_sym_DQUOTE] = ACTIONS(375),
    [sym_return] = ACTIONS(377),
    [sym_next] = ACTIONS(377),
    [sym_break] = ACTIONS(377),
    [sym_true] = ACTIONS(377),
    [sym_false] = ACTIONS(377),
    [sym_null] = ACTIONS(377),
    [sym_inf] = ACTIONS(377),
    [sym_nan] = ACTIONS(377),
    [anon_sym_NA] = ACTIONS(377),
    [anon_sym_NA_integer_] = ACTIONS(377),
    [anon_sym_NA_real_] = ACTIONS(377),
    [anon_sym_NA_complex_] = ACTIONS(377),
    [anon_sym_NA_character_] = ACTIONS(377),
    [sym_dots] = ACTIONS(377),
    [sym_dot_dot_i] = ACTIONS(375),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(375),
    [sym__semicolon] = ACTIONS(375),
    [sym__raw_string_literal] = ACTIONS(375),
    [sym__external_else] = ACTIONS(375),
    [sym__external_open_parenthesis] = ACTIONS(253),
    [sym__external_open_brace] = ACTIONS(375),
    [sym__external_close_brace] = ACTIONS(375),
    [sym__external_open_bracket] = ACTIONS(255),
    [sym__external_open_bracket2] = ACTIONS(257),
  },
  [150] = {
    [sym_call_arguments] = STATE(850),
    [sym_subset_arguments] = STATE(851),
    [sym_subset2_arguments] = STATE(852),
    [sym__open_parenthesis] = STATE(349),
    [sym__open_bracket] = STATE(350),
    [sym__open_bracket2] = STATE(351),
    [sym_identifier] = ACTIONS(381),
    [anon_sym_BSLASH] = ACTIONS(379),
    [anon_sym_function] = ACTIONS(381),
    [anon_sym_EQ] = ACTIONS(213),
    [anon_sym_if] = ACTIONS(381),
    [anon_sym_for] = ACTIONS(381),
    [anon_sym_while] = ACTIONS(381),
    [anon_sym_repeat] = ACTIONS(381),
    [anon_sym_QMARK] = ACTIONS(379),
    [anon_sym_TILDE] = ACTIONS(215),
    [anon_sym_BANG] = ACTIONS(381),
    [anon_sym_PLUS] = ACTIONS(217),
    [anon_sym_DASH] = ACTIONS(219),
    [anon_sym_LT_DASH] = ACTIONS(221),
    [anon_sym_LT_LT_DASH] = ACTIONS(221),
    [anon_sym_COLON_EQ] = ACTIONS(221),
    [anon_sym_DASH_GT] = ACTIONS(223),
    [anon_sym_DASH_GT_GT] = ACTIONS(225),
    [anon_sym_PIPE] = ACTIONS(227),
    [anon_sym_AMP] = ACTIONS(229),
    [anon_sym_PIPE_PIPE] = ACTIONS(231),
    [anon_sym_AMP_AMP] = ACTIONS(233),
    [anon_sym_LT] = ACTIONS(235),
    [anon_sym_LT_EQ] = ACTIONS(237),
    [anon_sym_GT] = ACTIONS(235),
    [anon_sym_GT_EQ] = ACTIONS(237),
    [anon_sym_EQ_EQ] = ACTIONS(237),
    [anon_sym_BANG_EQ] = ACTIONS(237),
    [anon_sym_STAR] = ACTIONS(239),
    [anon_sym_SLASH] = ACTIONS(241),
    [anon_sym_STAR_STAR] = ACTIONS(243),
    [anon_sym_CARET] = ACTIONS(243),
    [aux_sym_binary_operator_token1] = ACTIONS(245),
    [anon_sym_PIPE_GT] = ACTIONS(245),
    [anon_sym_COLON] = ACTIONS(247),
    [anon_sym_DOLLAR] = ACTIONS(249),
    [anon_sym_AT] = ACTIONS(249),
    [aux_sym__hex_literal_token1] = ACTIONS(379),
    [sym__number_literal] = ACTIONS(381),
    [anon_sym_SQUOTE] = ACTIONS(379),
    [anon_sym_DQUOTE] = ACTIONS(379),
    [sym_return] = ACTIONS(381),
    [sym_next] = ACTIONS(381),
    [sym_break] = ACTIONS(381),
    [sym_true] = ACTIONS(381),
    [sym_false] = ACTIONS(381),
    [sym_null] = ACTIONS(381),
    [sym_inf] = ACTIONS(381),
    [sym_nan] = ACTIONS(381),
    [anon_sym_NA] = ACTIONS(381),
    [anon_sym_NA_integer_] = ACTIONS(381),
    [anon_sym_NA_real_] = ACTIONS(381),
    [anon_sym_NA_complex_] = ACTIONS(381),
    [anon_sym_NA_character_] = ACTIONS(381),
    [sym_dots] = ACTIONS(381),
    [sym_dot_dot_i] = ACTIONS(379),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(379),
    [sym__semicolon] = ACTIONS(379),
    [sym__raw_string_literal] = ACTIONS(379),
    [sym__external_else] = ACTIONS(379),
    [sym__external_open_parenthesis] = ACTIONS(253),
    [sym__external_open_brace] = ACTIONS(379),
    [sym__external_close_brace] = ACTIONS(379),
    [sym__external_open_bracket] = ACTIONS(255),
    [sym__external_open_bracket2] = ACTIONS(257),
  },
  [151] = {
    [sym_call_arguments] = STATE(850),
    [sym_subset_arguments] = STATE(851),
    [sym_subset2_arguments] = STATE(852),
    [sym__open_parenthesis] = STATE(349),
    [sym__open_bracket] = STATE(350),
    [sym__open_bracket2] = STATE(351),
    [sym_identifier] = ACTIONS(381),
    [anon_sym_BSLASH] = ACTIONS(379),
    [anon_sym_function] = ACTIONS(381),
    [anon_sym_EQ] = ACTIONS(381),
    [anon_sym_if] = ACTIONS(381),
    [anon_sym_for] = ACTIONS(381),
    [anon_sym_while] = ACTIONS(381),
    [anon_sym_repeat] = ACTIONS(381),
    [anon_sym_QMARK] = ACTIONS(379),
    [anon_sym_TILDE] = ACTIONS(379),
    [anon_sym_BANG] = ACTIONS(381),
    [anon_sym_PLUS] = ACTIONS(217),
    [anon_sym_DASH] = ACTIONS(219),
    [anon_sym_LT_DASH] = ACTIONS(379),
    [anon_sym_LT_LT_DASH] = ACTIONS(379),
    [anon_sym_COLON_EQ] = ACTIONS(379),
    [anon_sym_DASH_GT] = ACTIONS(381),
    [anon_sym_DASH_GT_GT] = ACTIONS(379),
    [anon_sym_PIPE] = ACTIONS(227),
    [anon_sym_AMP] = ACTIONS(229),
    [anon_sym_PIPE_PIPE] = ACTIONS(231),
    [anon_sym_AMP_AMP] = ACTIONS(233),
    [anon_sym_LT] = ACTIONS(235),
    [anon_sym_LT_EQ] = ACTIONS(237),
    [anon_sym_GT] = ACTIONS(235),
    [anon_sym_GT_EQ] = ACTIONS(237),
    [anon_sym_EQ_EQ] = ACTIONS(237),
    [anon_sym_BANG_EQ] = ACTIONS(237),
    [anon_sym_STAR] = ACTIONS(239),
    [anon_sym_SLASH] = ACTIONS(241),
    [anon_sym_STAR_STAR] = ACTIONS(243),
    [anon_sym_CARET] = ACTIONS(243),
    [aux_sym_binary_operator_token1] = ACTIONS(245),
    [anon_sym_PIPE_GT] = ACTIONS(245),
    [anon_sym_COLON] = ACTIONS(247),
    [anon_sym_DOLLAR] = ACTIONS(249),
    [anon_sym_AT] = ACTIONS(249),
    [aux_sym__hex_literal_token1] = ACTIONS(379),
    [sym__number_literal] = ACTIONS(381),
    [anon_sym_SQUOTE] = ACTIONS(379),
    [anon_sym_DQUOTE] = ACTIONS(379),
    [sym_return] = ACTIONS(381),
    [sym_next] = ACTIONS(381),
    [sym_break] = ACTIONS(381),
    [sym_true] = ACTIONS(381),
    [sym_false] = ACTIONS(381),
    [sym_null] = ACTIONS(381),
    [sym_inf] = ACTIONS(381),
    [sym_nan] = ACTIONS(381),
    [anon_sym_NA] = ACTIONS(381),
    [anon_sym_NA_integer_] = ACTIONS(381),
    [anon_sym_NA_real_] = ACTIONS(381),
    [anon_sym_NA_complex_] = ACTIONS(381),
    [anon_sym_NA_character_] = ACTIONS(381),
    [sym_dots] = ACTIONS(381),
    [sym_dot_dot_i] = ACTIONS(379),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(379),
    [sym__semicolon] = ACTIONS(379),
    [sym__raw_string_literal] = ACTIONS(379),
    [sym__external_else] = ACTIONS(379),
    [sym__external_open_parenthesis] = ACTIONS(253),
    [sym__external_open_brace] = ACTIONS(379),
    [sym__external_close_brace] = ACTIONS(379),
    [sym__external_open_bracket] = ACTIONS(255),
    [sym__external_open_bracket2] = ACTIONS(257),
  },
  [152] = {
    [sym_call_arguments] = STATE(850),
    [sym_subset_arguments] = STATE(851),
    [sym_subset2_arguments] = STATE(852),
    [sym__open_parenthesis] = STATE(349),
    [sym__open_bracket] = STATE(350),
    [sym__open_bracket2] = STATE(351),
    [sym_identifier] = ACTIONS(381),
    [anon_sym_BSLASH] = ACTIONS(379),
    [anon_sym_function] = ACTIONS(381),
    [anon_sym_EQ] = ACTIONS(381),
    [anon_sym_if] = ACTIONS(381),
    [anon_sym_for] = ACTIONS(381),
    [anon_sym_while] = ACTIONS(381),
    [anon_sym_repeat] = ACTIONS(381),
    [anon_sym_QMARK] = ACTIONS(379),
    [anon_sym_TILDE] = ACTIONS(379),
    [anon_sym_BANG] = ACTIONS(381),
    [anon_sym_PLUS] = ACTIONS(217),
    [anon_sym_DASH] = ACTIONS(219),
    [anon_sym_LT_DASH] = ACTIONS(379),
    [anon_sym_LT_LT_DASH] = ACTIONS(379),
    [anon_sym_COLON_EQ] = ACTIONS(379),
    [anon_sym_DASH_GT] = ACTIONS(381),
    [anon_sym_DASH_GT_GT] = ACTIONS(379),
    [anon_sym_PIPE] = ACTIONS(381),
    [anon_sym_AMP] = ACTIONS(381),
    [anon_sym_PIPE_PIPE] = ACTIONS(379),
    [anon_sym_AMP_AMP] = ACTIONS(379),
    [anon_sym_LT] = ACTIONS(235),
    [anon_sym_LT_EQ] = ACTIONS(237),
    [anon_sym_GT] = ACTIONS(235),
    [anon_sym_GT_EQ] = ACTIONS(237),
    [anon_sym_EQ_EQ] = ACTIONS(237),
    [anon_sym_BANG_EQ] = ACTIONS(237),
    [anon_sym_STAR] = ACTIONS(239),
    [anon_sym_SLASH] = ACTIONS(241),
    [anon_sym_STAR_STAR] = ACTIONS(243),
    [anon_sym_CARET] = ACTIONS(243),
    [aux_sym_binary_operator_token1] = ACTIONS(245),
    [anon_sym_PIPE_GT] = ACTIONS(245),
    [anon_sym_COLON] = ACTIONS(247),
    [anon_sym_DOLLAR] = ACTIONS(249),
    [anon_sym_AT] = ACTIONS(249),
    [aux_sym__hex_literal_token1] = ACTIONS(379),
    [sym__number_literal] = ACTIONS(381),
    [anon_sym_SQUOTE] = ACTIONS(379),
    [anon_sym_DQUOTE] = ACTIONS(379),
    [sym_return] = ACTIONS(381),
    [sym_next] = ACTIONS(381),
    [sym_break] = ACTIONS(381),
    [sym_true] = ACTIONS(381),
    [sym_false] = ACTIONS(381),
    [sym_null] = ACTIONS(381),
    [sym_inf] = ACTIONS(381),
    [sym_nan] = ACTIONS(381),
    [anon_sym_NA] = ACTIONS(381),
    [anon_sym_NA_integer_] = ACTIONS(381),
    [anon_sym_NA_real_] = ACTIONS(381),
    [anon_sym_NA_complex_] = ACTIONS(381),
    [anon_sym_NA_character_] = ACTIONS(381),
    [sym_dots] = ACTIONS(381),
    [sym_dot_dot_i] = ACTIONS(379),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(379),
    [sym__semicolon] = ACTIONS(379),
    [sym__raw_string_literal] = ACTIONS(379),
    [sym__external_else] = ACTIONS(379),
    [sym__external_open_parenthesis] = ACTIONS(253),
    [sym__external_open_brace] = ACTIONS(379),
    [sym__external_close_brace] = ACTIONS(379),
    [sym__external_open_bracket] = ACTIONS(255),
    [sym__external_open_bracket2] = ACTIONS(257),
  },
  [153] = {
    [sym_call_arguments] = STATE(850),
    [sym_subset_arguments] = STATE(851),
    [sym_subset2_arguments] = STATE(852),
    [sym__open_parenthesis] = STATE(349),
    [sym__open_bracket] = STATE(350),
    [sym__open_bracket2] = STATE(351),
    [sym_identifier] = ACTIONS(381),
    [anon_sym_BSLASH] = ACTIONS(379),
    [anon_sym_function] = ACTIONS(381),
    [anon_sym_EQ] = ACTIONS(381),
    [anon_sym_if] = ACTIONS(381),
    [anon_sym_for] = ACTIONS(381),
    [anon_sym_while] = ACTIONS(381),
    [anon_sym_repeat] = ACTIONS(381),
    [anon_sym_QMARK] = ACTIONS(379),
    [anon_sym_TILDE] = ACTIONS(379),
    [anon_sym_BANG] = ACTIONS(381),
    [anon_sym_PLUS] = ACTIONS(379),
    [anon_sym_DASH] = ACTIONS(381),
    [anon_sym_LT_DASH] = ACTIONS(379),
    [anon_sym_LT_LT_DASH] = ACTIONS(379),
    [anon_sym_COLON_EQ] = ACTIONS(379),
    [anon_sym_DASH_GT] = ACTIONS(381),
    [anon_sym_DASH_GT_GT] = ACTIONS(379),
    [anon_sym_PIPE] = ACTIONS(381),
    [anon_sym_AMP] = ACTIONS(381),
    [anon_sym_PIPE_PIPE] = ACTIONS(379),
    [anon_sym_AMP_AMP] = ACTIONS(379),
    [anon_sym_LT] = ACTIONS(381),
    [anon_sym_LT_EQ] = ACTIONS(379),
    [anon_sym_GT] = ACTIONS(381),
    [anon_sym_GT_EQ] = ACTIONS(379),
    [anon_sym_EQ_EQ] = ACTIONS(379),
    [anon_sym_BANG_EQ] = ACTIONS(379),
    [anon_sym_STAR] = ACTIONS(381),
    [anon_sym_SLASH] = ACTIONS(379),
    [anon_sym_STAR_STAR] = ACTIONS(243),
    [anon_sym_CARET] = ACTIONS(243),
    [aux_sym_binary_operator_token1] = ACTIONS(379),
    [anon_sym_PIPE_GT] = ACTIONS(379),
    [anon_sym_COLON] = ACTIONS(381),
    [anon_sym_DOLLAR] = ACTIONS(249),
    [anon_sym_AT] = ACTIONS(249),
    [aux_sym__hex_literal_token1] = ACTIONS(379),
    [sym__number_literal] = ACTIONS(381),
    [anon_sym_SQUOTE] = ACTIONS(379),
    [anon_sym_DQUOTE] = ACTIONS(379),
    [sym_return] = ACTIONS(381),
    [sym_next] = ACTIONS(381),
    [sym_break] = ACTIONS(381),
    [sym_true] = ACTIONS(381),
    [sym_false] = ACTIONS(381),
    [sym_null] = ACTIONS(381),
    [sym_inf] = ACTIONS(381),
    [sym_nan] = ACTIONS(381),
    [anon_sym_NA] = ACTIONS(381),
    [anon_sym_NA_integer_] = ACTIONS(381),
    [anon_sym_NA_real_] = ACTIONS(381),
    [anon_sym_NA_complex_] = ACTIONS(381),
    [anon_sym_NA_character_] = ACTIONS(381),
    [sym_dots] = ACTIONS(381),
    [sym_dot_dot_i] = ACTIONS(379),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(379),
    [sym__semicolon] = ACTIONS(379),
    [sym__raw_string_literal] = ACTIONS(379),
    [sym__external_else] = ACTIONS(379),
    [sym__external_open_parenthesis] = ACTIONS(253),
    [sym__external_open_brace] = ACTIONS(379),
    [sym__external_close_brace] = ACTIONS(379),
    [sym__external_open_bracket] = ACTIONS(255),
    [sym__external_open_bracket2] = ACTIONS(257),
  },
  [154] = {
    [sym_call_arguments] = STATE(850),
    [sym_subset_arguments] = STATE(851),
    [sym_subset2_arguments] = STATE(852),
    [sym__open_parenthesis] = STATE(349),
    [sym__open_bracket] = STATE(350),
    [sym__open_bracket2] = STATE(351),
    [sym_identifier] = ACTIONS(385),
    [anon_sym_BSLASH] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_EQ] = ACTIONS(213),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_for] = ACTIONS(385),
    [anon_sym_while] = ACTIONS(385),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_QMARK] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(215),
    [anon_sym_BANG] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(217),
    [anon_sym_DASH] = ACTIONS(219),
    [anon_sym_LT_DASH] = ACTIONS(383),
    [anon_sym_LT_LT_DASH] = ACTIONS(383),
    [anon_sym_COLON_EQ] = ACTIONS(383),
    [anon_sym_DASH_GT] = ACTIONS(223),
    [anon_sym_DASH_GT_GT] = ACTIONS(225),
    [anon_sym_PIPE] = ACTIONS(227),
    [anon_sym_AMP] = ACTIONS(229),
    [anon_sym_PIPE_PIPE] = ACTIONS(231),
    [anon_sym_AMP_AMP] = ACTIONS(233),
    [anon_sym_LT] = ACTIONS(235),
    [anon_sym_LT_EQ] = ACTIONS(237),
    [anon_sym_GT] = ACTIONS(235),
    [anon_sym_GT_EQ] = ACTIONS(237),
    [anon_sym_EQ_EQ] = ACTIONS(237),
    [anon_sym_BANG_EQ] = ACTIONS(237),
    [anon_sym_STAR] = ACTIONS(239),
    [anon_sym_SLASH] = ACTIONS(241),
    [anon_sym_STAR_STAR] = ACTIONS(243),
    [anon_sym_CARET] = ACTIONS(243),
    [aux_sym_binary_operator_token1] = ACTIONS(245),
    [anon_sym_PIPE_GT] = ACTIONS(245),
    [anon_sym_COLON] = ACTIONS(247),
    [anon_sym_DOLLAR] = ACTIONS(249),
    [anon_sym_AT] = ACTIONS(249),
    [aux_sym__hex_literal_token1] = ACTIONS(383),
    [sym__number_literal] = ACTIONS(385),
    [anon_sym_SQUOTE] = ACTIONS(383),
    [anon_sym_DQUOTE] = ACTIONS(383),
    [sym_return] = ACTIONS(385),
    [sym_next] = ACTIONS(385),
    [sym_break] = ACTIONS(385),
    [sym_true] = ACTIONS(385),
    [sym_false] = ACTIONS(385),
    [sym_null] = ACTIONS(385),
    [sym_inf] = ACTIONS(385),
    [sym_nan] = ACTIONS(385),
    [anon_sym_NA] = ACTIONS(385),
    [anon_sym_NA_integer_] = ACTIONS(385),
    [anon_sym_NA_real_] = ACTIONS(385),
    [anon_sym_NA_complex_] = ACTIONS(385),
    [anon_sym_NA_character_] = ACTIONS(385),
    [sym_dots] = ACTIONS(385),
    [sym_dot_dot_i] = ACTIONS(383),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(383),
    [sym__semicolon] = ACTIONS(383),
    [sym__raw_string_literal] = ACTIONS(383),
    [sym__external_else] = ACTIONS(383),
    [sym__external_open_parenthesis] = ACTIONS(253),
    [sym__external_open_brace] = ACTIONS(383),
    [sym__external_close_brace] = ACTIONS(383),
    [sym__external_open_bracket] = ACTIONS(255),
    [sym__external_open_bracket2] = ACTIONS(257),
  },
  [155] = {
    [sym_call_arguments] = STATE(850),
    [sym_subset_arguments] = STATE(851),
    [sym_subset2_arguments] = STATE(852),
    [sym__open_parenthesis] = STATE(349),
    [sym__open_bracket] = STATE(350),
    [sym__open_bracket2] = STATE(351),
    [sym_identifier] = ACTIONS(385),
    [anon_sym_BSLASH] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_EQ] = ACTIONS(213),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_for] = ACTIONS(385),
    [anon_sym_while] = ACTIONS(385),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_QMARK] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(215),
    [anon_sym_BANG] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(217),
    [anon_sym_DASH] = ACTIONS(219),
    [anon_sym_LT_DASH] = ACTIONS(221),
    [anon_sym_LT_LT_DASH] = ACTIONS(221),
    [anon_sym_COLON_EQ] = ACTIONS(221),
    [anon_sym_DASH_GT] = ACTIONS(223),
    [anon_sym_DASH_GT_GT] = ACTIONS(225),
    [anon_sym_PIPE] = ACTIONS(227),
    [anon_sym_AMP] = ACTIONS(229),
    [anon_sym_PIPE_PIPE] = ACTIONS(231),
    [anon_sym_AMP_AMP] = ACTIONS(233),
    [anon_sym_LT] = ACTIONS(235),
    [anon_sym_LT_EQ] = ACTIONS(237),
    [anon_sym_GT] = ACTIONS(235),
    [anon_sym_GT_EQ] = ACTIONS(237),
    [anon_sym_EQ_EQ] = ACTIONS(237),
    [anon_sym_BANG_EQ] = ACTIONS(237),
    [anon_sym_STAR] = ACTIONS(239),
    [anon_sym_SLASH] = ACTIONS(241),
    [anon_sym_STAR_STAR] = ACTIONS(243),
    [anon_sym_CARET] = ACTIONS(243),
    [aux_sym_binary_operator_token1] = ACTIONS(245),
    [anon_sym_PIPE_GT] = ACTIONS(245),
    [anon_sym_COLON] = ACTIONS(247),
    [anon_sym_DOLLAR] = ACTIONS(249),
    [anon_sym_AT] = ACTIONS(249),
    [aux_sym__hex_literal_token1] = ACTIONS(383),
    [sym__number_literal] = ACTIONS(385),
    [anon_sym_SQUOTE] = ACTIONS(383),
    [anon_sym_DQUOTE] = ACTIONS(383),
    [sym_return] = ACTIONS(385),
    [sym_next] = ACTIONS(385),
    [sym_break] = ACTIONS(385),
    [sym_true] = ACTIONS(385),
    [sym_false] = ACTIONS(385),
    [sym_null] = ACTIONS(385),
    [sym_inf] = ACTIONS(385),
    [sym_nan] = ACTIONS(385),
    [anon_sym_NA] = ACTIONS(385),
    [anon_sym_NA_integer_] = ACTIONS(385),
    [anon_sym_NA_real_] = ACTIONS(385),
    [anon_sym_NA_complex_] = ACTIONS(385),
    [anon_sym_NA_character_] = ACTIONS(385),
    [sym_dots] = ACTIONS(385),
    [sym_dot_dot_i] = ACTIONS(383),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(383),
    [sym__semicolon] = ACTIONS(383),
    [sym__raw_string_literal] = ACTIONS(383),
    [sym__external_else] = ACTIONS(383),
    [sym__external_open_parenthesis] = ACTIONS(253),
    [sym__external_open_brace] = ACTIONS(383),
    [sym__external_close_brace] = ACTIONS(383),
    [sym__external_open_bracket] = ACTIONS(255),
    [sym__external_open_bracket2] = ACTIONS(257),
  },
  [156] = {
    [sym_call_arguments] = STATE(850),
    [sym_subset_arguments] = STATE(851),
    [sym_subset2_arguments] = STATE(852),
    [sym__open_parenthesis] = STATE(349),
    [sym__open_bracket] = STATE(350),
    [sym__open_bracket2] = STATE(351),
    [sym_identifier] = ACTIONS(385),
    [anon_sym_BSLASH] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_EQ] = ACTIONS(385),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_for] = ACTIONS(385),
    [anon_sym_while] = ACTIONS(385),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_QMARK] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(383),
    [anon_sym_BANG] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(217),
    [anon_sym_DASH] = ACTIONS(219),
    [anon_sym_LT_DASH] = ACTIONS(383),
    [anon_sym_LT_LT_DASH] = ACTIONS(383),
    [anon_sym_COLON_EQ] = ACTIONS(383),
    [anon_sym_DASH_GT] = ACTIONS(385),
    [anon_sym_DASH_GT_GT] = ACTIONS(383),
    [anon_sym_PIPE] = ACTIONS(227),
    [anon_sym_AMP] = ACTIONS(229),
    [anon_sym_PIPE_PIPE] = ACTIONS(231),
    [anon_sym_AMP_AMP] = ACTIONS(233),
    [anon_sym_LT] = ACTIONS(235),
    [anon_sym_LT_EQ] = ACTIONS(237),
    [anon_sym_GT] = ACTIONS(235),
    [anon_sym_GT_EQ] = ACTIONS(237),
    [anon_sym_EQ_EQ] = ACTIONS(237),
    [anon_sym_BANG_EQ] = ACTIONS(237),
    [anon_sym_STAR] = ACTIONS(239),
    [anon_sym_SLASH] = ACTIONS(241),
    [anon_sym_STAR_STAR] = ACTIONS(243),
    [anon_sym_CARET] = ACTIONS(243),
    [aux_sym_binary_operator_token1] = ACTIONS(245),
    [anon_sym_PIPE_GT] = ACTIONS(245),
    [anon_sym_COLON] = ACTIONS(247),
    [anon_sym_DOLLAR] = ACTIONS(249),
    [anon_sym_AT] = ACTIONS(249),
    [aux_sym__hex_literal_token1] = ACTIONS(383),
    [sym__number_literal] = ACTIONS(385),
    [anon_sym_SQUOTE] = ACTIONS(383),
    [anon_sym_DQUOTE] = ACTIONS(383),
    [sym_return] = ACTIONS(385),
    [sym_next] = ACTIONS(385),
    [sym_break] = ACTIONS(385),
    [sym_true] = ACTIONS(385),
    [sym_false] = ACTIONS(385),
    [sym_null] = ACTIONS(385),
    [sym_inf] = ACTIONS(385),
    [sym_nan] = ACTIONS(385),
    [anon_sym_NA] = ACTIONS(385),
    [anon_sym_NA_integer_] = ACTIONS(385),
    [anon_sym_NA_real_] = ACTIONS(385),
    [anon_sym_NA_complex_] = ACTIONS(385),
    [anon_sym_NA_character_] = ACTIONS(385),
    [sym_dots] = ACTIONS(385),
    [sym_dot_dot_i] = ACTIONS(383),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(383),
    [sym__semicolon] = ACTIONS(383),
    [sym__raw_string_literal] = ACTIONS(383),
    [sym__external_else] = ACTIONS(383),
    [sym__external_open_parenthesis] = ACTIONS(253),
    [sym__external_open_brace] = ACTIONS(383),
    [sym__external_close_brace] = ACTIONS(383),
    [sym__external_open_bracket] = ACTIONS(255),
    [sym__external_open_bracket2] = ACTIONS(257),
  },
  [157] = {
    [sym_call_arguments] = STATE(850),
    [sym_subset_arguments] = STATE(851),
    [sym_subset2_arguments] = STATE(852),
    [sym__open_parenthesis] = STATE(349),
    [sym__open_bracket] = STATE(350),
    [sym__open_bracket2] = STATE(351),
    [sym_identifier] = ACTIONS(385),
    [anon_sym_BSLASH] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_EQ] = ACTIONS(385),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_for] = ACTIONS(385),
    [anon_sym_while] = ACTIONS(385),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_QMARK] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(383),
    [anon_sym_BANG] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(385),
    [anon_sym_LT_DASH] = ACTIONS(383),
    [anon_sym_LT_LT_DASH] = ACTIONS(383),
    [anon_sym_COLON_EQ] = ACTIONS(383),
    [anon_sym_DASH_GT] = ACTIONS(385),
    [anon_sym_DASH_GT_GT] = ACTIONS(383),
    [anon_sym_PIPE] = ACTIONS(385),
    [anon_sym_AMP] = ACTIONS(385),
    [anon_sym_PIPE_PIPE] = ACTIONS(383),
    [anon_sym_AMP_AMP] = ACTIONS(383),
    [anon_sym_LT] = ACTIONS(385),
    [anon_sym_LT_EQ] = ACTIONS(383),
    [anon_sym_GT] = ACTIONS(385),
    [anon_sym_GT_EQ] = ACTIONS(383),
    [anon_sym_EQ_EQ] = ACTIONS(383),
    [anon_sym_BANG_EQ] = ACTIONS(383),
    [anon_sym_STAR] = ACTIONS(239),
    [anon_sym_SLASH] = ACTIONS(241),
    [anon_sym_STAR_STAR] = ACTIONS(243),
    [anon_sym_CARET] = ACTIONS(243),
    [aux_sym_binary_operator_token1] = ACTIONS(245),
    [anon_sym_PIPE_GT] = ACTIONS(245),
    [anon_sym_COLON] = ACTIONS(247),
    [anon_sym_DOLLAR] = ACTIONS(249),
    [anon_sym_AT] = ACTIONS(249),
    [aux_sym__hex_literal_token1] = ACTIONS(383),
    [sym__number_literal] = ACTIONS(385),
    [anon_sym_SQUOTE] = ACTIONS(383),
    [anon_sym_DQUOTE] = ACTIONS(383),
    [sym_return] = ACTIONS(385),
    [sym_next] = ACTIONS(385),
    [sym_break] = ACTIONS(385),
    [sym_true] = ACTIONS(385),
    [sym_false] = ACTIONS(385),
    [sym_null] = ACTIONS(385),
    [sym_inf] = ACTIONS(385),
    [sym_nan] = ACTIONS(385),
    [anon_sym_NA] = ACTIONS(385),
    [anon_sym_NA_integer_] = ACTIONS(385),
    [anon_sym_NA_real_] = ACTIONS(385),
    [anon_sym_NA_complex_] = ACTIONS(385),
    [anon_sym_NA_character_] = ACTIONS(385),
    [sym_dots] = ACTIONS(385),
    [sym_dot_dot_i] = ACTIONS(383),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(383),
    [sym__semicolon] = ACTIONS(383),
    [sym__raw_string_literal] = ACTIONS(383),
    [sym__external_else] = ACTIONS(383),
    [sym__external_open_parenthesis] = ACTIONS(253),
    [sym__external_open_brace] = ACTIONS(383),
    [sym__external_close_brace] = ACTIONS(383),
    [sym__external_open_bracket] = ACTIONS(255),
    [sym__external_open_bracket2] = ACTIONS(257),
  },
  [158] = {
    [sym_call_arguments] = STATE(850),
    [sym_subset_arguments] = STATE(851),
    [sym_subset2_arguments] = STATE(852),
    [sym__open_parenthesis] = STATE(349),
    [sym__open_bracket] = STATE(350),
    [sym__open_bracket2] = STATE(351),
    [sym_identifier] = ACTIONS(385),
    [anon_sym_BSLASH] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_EQ] = ACTIONS(213),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_for] = ACTIONS(385),
    [anon_sym_while] = ACTIONS(385),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_QMARK] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(215),
    [anon_sym_BANG] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(217),
    [anon_sym_DASH] = ACTIONS(219),
    [anon_sym_LT_DASH] = ACTIONS(221),
    [anon_sym_LT_LT_DASH] = ACTIONS(221),
    [anon_sym_COLON_EQ] = ACTIONS(221),
    [anon_sym_DASH_GT] = ACTIONS(223),
    [anon_sym_DASH_GT_GT] = ACTIONS(225),
    [anon_sym_PIPE] = ACTIONS(227),
    [anon_sym_AMP] = ACTIONS(229),
    [anon_sym_PIPE_PIPE] = ACTIONS(231),
    [anon_sym_AMP_AMP] = ACTIONS(233),
    [anon_sym_LT] = ACTIONS(235),
    [anon_sym_LT_EQ] = ACTIONS(237),
    [anon_sym_GT] = ACTIONS(235),
    [anon_sym_GT_EQ] = ACTIONS(237),
    [anon_sym_EQ_EQ] = ACTIONS(237),
    [anon_sym_BANG_EQ] = ACTIONS(237),
    [anon_sym_STAR] = ACTIONS(239),
    [anon_sym_SLASH] = ACTIONS(241),
    [anon_sym_STAR_STAR] = ACTIONS(243),
    [anon_sym_CARET] = ACTIONS(243),
    [aux_sym_binary_operator_token1] = ACTIONS(245),
    [anon_sym_PIPE_GT] = ACTIONS(245),
    [anon_sym_COLON] = ACTIONS(247),
    [anon_sym_DOLLAR] = ACTIONS(249),
    [anon_sym_AT] = ACTIONS(249),
    [aux_sym__hex_literal_token1] = ACTIONS(383),
    [sym__number_literal] = ACTIONS(385),
    [anon_sym_SQUOTE] = ACTIONS(383),
    [anon_sym_DQUOTE] = ACTIONS(383),
    [sym_return] = ACTIONS(385),
    [sym_next] = ACTIONS(385),
    [sym_break] = ACTIONS(385),
    [sym_true] = ACTIONS(385),
    [sym_false] = ACTIONS(385),
    [sym_null] = ACTIONS(385),
    [sym_inf] = ACTIONS(385),
    [sym_nan] = ACTIONS(385),
    [anon_sym_NA] = ACTIONS(385),
    [anon_sym_NA_integer_] = ACTIONS(385),
    [anon_sym_NA_real_] = ACTIONS(385),
    [anon_sym_NA_complex_] = ACTIONS(385),
    [anon_sym_NA_character_] = ACTIONS(385),
    [sym_dots] = ACTIONS(385),
    [sym_dot_dot_i] = ACTIONS(383),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(383),
    [sym__semicolon] = ACTIONS(383),
    [sym__raw_string_literal] = ACTIONS(383),
    [sym__external_else] = ACTIONS(383),
    [sym__external_open_parenthesis] = ACTIONS(253),
    [sym__external_open_brace] = ACTIONS(383),
    [sym__external_close_brace] = ACTIONS(383),
    [sym__external_open_bracket] = ACTIONS(255),
    [sym__external_open_bracket2] = ACTIONS(257),
  },
  [159] = {
    [sym_call_arguments] = STATE(850),
    [sym_subset_arguments] = STATE(851),
    [sym_subset2_arguments] = STATE(852),
    [sym__open_parenthesis] = STATE(349),
    [sym__open_bracket] = STATE(350),
    [sym__open_bracket2] = STATE(351),
    [sym_identifier] = ACTIONS(385),
    [anon_sym_BSLASH] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_EQ] = ACTIONS(385),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_for] = ACTIONS(385),
    [anon_sym_while] = ACTIONS(385),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_QMARK] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(215),
    [anon_sym_BANG] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(217),
    [anon_sym_DASH] = ACTIONS(219),
    [anon_sym_LT_DASH] = ACTIONS(383),
    [anon_sym_LT_LT_DASH] = ACTIONS(383),
    [anon_sym_COLON_EQ] = ACTIONS(383),
    [anon_sym_DASH_GT] = ACTIONS(385),
    [anon_sym_DASH_GT_GT] = ACTIONS(383),
    [anon_sym_PIPE] = ACTIONS(227),
    [anon_sym_AMP] = ACTIONS(229),
    [anon_sym_PIPE_PIPE] = ACTIONS(231),
    [anon_sym_AMP_AMP] = ACTIONS(233),
    [anon_sym_LT] = ACTIONS(235),
    [anon_sym_LT_EQ] = ACTIONS(237),
    [anon_sym_GT] = ACTIONS(235),
    [anon_sym_GT_EQ] = ACTIONS(237),
    [anon_sym_EQ_EQ] = ACTIONS(237),
    [anon_sym_BANG_EQ] = ACTIONS(237),
    [anon_sym_STAR] = ACTIONS(239),
    [anon_sym_SLASH] = ACTIONS(241),
    [anon_sym_STAR_STAR] = ACTIONS(243),
    [anon_sym_CARET] = ACTIONS(243),
    [aux_sym_binary_operator_token1] = ACTIONS(245),
    [anon_sym_PIPE_GT] = ACTIONS(245),
    [anon_sym_COLON] = ACTIONS(247),
    [anon_sym_DOLLAR] = ACTIONS(249),
    [anon_sym_AT] = ACTIONS(249),
    [aux_sym__hex_literal_token1] = ACTIONS(383),
    [sym__number_literal] = ACTIONS(385),
    [anon_sym_SQUOTE] = ACTIONS(383),
    [anon_sym_DQUOTE] = ACTIONS(383),
    [sym_return] = ACTIONS(385),
    [sym_next] = ACTIONS(385),
    [sym_break] = ACTIONS(385),
    [sym_true] = ACTIONS(385),
    [sym_false] = ACTIONS(385),
    [sym_null] = ACTIONS(385),
    [sym_inf] = ACTIONS(385),
    [sym_nan] = ACTIONS(385),
    [anon_sym_NA] = ACTIONS(385),
    [anon_sym_NA_integer_] = ACTIONS(385),
    [anon_sym_NA_real_] = ACTIONS(385),
    [anon_sym_NA_complex_] = ACTIONS(385),
    [anon_sym_NA_character_] = ACTIONS(385),
    [sym_dots] = ACTIONS(385),
    [sym_dot_dot_i] = ACTIONS(383),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(383),
    [sym__semicolon] = ACTIONS(383),
    [sym__raw_string_literal] = ACTIONS(383),
    [sym__external_else] = ACTIONS(383),
    [sym__external_open_parenthesis] = ACTIONS(253),
    [sym__external_open_brace] = ACTIONS(383),
    [sym__external_close_brace] = ACTIONS(383),
    [sym__external_open_bracket] = ACTIONS(255),
    [sym__external_open_bracket2] = ACTIONS(257),
  },
  [160] = {
    [sym_call_arguments] = STATE(850),
    [sym_subset_arguments] = STATE(851),
    [sym_subset2_arguments] = STATE(852),
    [sym__open_parenthesis] = STATE(349),
    [sym__open_bracket] = STATE(350),
    [sym__open_bracket2] = STATE(351),
    [sym_identifier] = ACTIONS(385),
    [anon_sym_BSLASH] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_EQ] = ACTIONS(385),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_for] = ACTIONS(385),
    [anon_sym_while] = ACTIONS(385),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_QMARK] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(383),
    [anon_sym_BANG] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(217),
    [anon_sym_DASH] = ACTIONS(219),
    [anon_sym_LT_DASH] = ACTIONS(383),
    [anon_sym_LT_LT_DASH] = ACTIONS(383),
    [anon_sym_COLON_EQ] = ACTIONS(383),
    [anon_sym_DASH_GT] = ACTIONS(385),
    [anon_sym_DASH_GT_GT] = ACTIONS(383),
    [anon_sym_PIPE] = ACTIONS(385),
    [anon_sym_AMP] = ACTIONS(229),
    [anon_sym_PIPE_PIPE] = ACTIONS(383),
    [anon_sym_AMP_AMP] = ACTIONS(233),
    [anon_sym_LT] = ACTIONS(235),
    [anon_sym_LT_EQ] = ACTIONS(237),
    [anon_sym_GT] = ACTIONS(235),
    [anon_sym_GT_EQ] = ACTIONS(237),
    [anon_sym_EQ_EQ] = ACTIONS(237),
    [anon_sym_BANG_EQ] = ACTIONS(237),
    [anon_sym_STAR] = ACTIONS(239),
    [anon_sym_SLASH] = ACTIONS(241),
    [anon_sym_STAR_STAR] = ACTIONS(243),
    [anon_sym_CARET] = ACTIONS(243),
    [aux_sym_binary_operator_token1] = ACTIONS(245),
    [anon_sym_PIPE_GT] = ACTIONS(245),
    [anon_sym_COLON] = ACTIONS(247),
    [anon_sym_DOLLAR] = ACTIONS(249),
    [anon_sym_AT] = ACTIONS(249),
    [aux_sym__hex_literal_token1] = ACTIONS(383),
    [sym__number_literal] = ACTIONS(385),
    [anon_sym_SQUOTE] = ACTIONS(383),
    [anon_sym_DQUOTE] = ACTIONS(383),
    [sym_return] = ACTIONS(385),
    [sym_next] = ACTIONS(385),
    [sym_break] = ACTIONS(385),
    [sym_true] = ACTIONS(385),
    [sym_false] = ACTIONS(385),
    [sym_null] = ACTIONS(385),
    [sym_inf] = ACTIONS(385),
    [sym_nan] = ACTIONS(385),
    [anon_sym_NA] = ACTIONS(385),
    [anon_sym_NA_integer_] = ACTIONS(385),
    [anon_sym_NA_real_] = ACTIONS(385),
    [anon_sym_NA_complex_] = ACTIONS(385),
    [anon_sym_NA_character_] = ACTIONS(385),
    [sym_dots] = ACTIONS(385),
    [sym_dot_dot_i] = ACTIONS(383),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(383),
    [sym__semicolon] = ACTIONS(383),
    [sym__raw_string_literal] = ACTIONS(383),
    [sym__external_else] = ACTIONS(383),
    [sym__external_open_parenthesis] = ACTIONS(253),
    [sym__external_open_brace] = ACTIONS(383),
    [sym__external_close_brace] = ACTIONS(383),
    [sym__external_open_bracket] = ACTIONS(255),
    [sym__external_open_bracket2] = ACTIONS(257),
  },
  [161] = {
    [sym_call_arguments] = STATE(850),
    [sym_subset_arguments] = STATE(851),
    [sym_subset2_arguments] = STATE(852),
    [sym__open_parenthesis] = STATE(349),
    [sym__open_bracket] = STATE(350),
    [sym__open_bracket2] = STATE(351),
    [sym_identifier] = ACTIONS(385),
    [anon_sym_BSLASH] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_EQ] = ACTIONS(385),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_for] = ACTIONS(385),
    [anon_sym_while] = ACTIONS(385),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_QMARK] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(383),
    [anon_sym_BANG] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(217),
    [anon_sym_DASH] = ACTIONS(219),
    [anon_sym_LT_DASH] = ACTIONS(383),
    [anon_sym_LT_LT_DASH] = ACTIONS(383),
    [anon_sym_COLON_EQ] = ACTIONS(383),
    [anon_sym_DASH_GT] = ACTIONS(385),
    [anon_sym_DASH_GT_GT] = ACTIONS(383),
    [anon_sym_PIPE] = ACTIONS(385),
    [anon_sym_AMP] = ACTIONS(385),
    [anon_sym_PIPE_PIPE] = ACTIONS(383),
    [anon_sym_AMP_AMP] = ACTIONS(383),
    [anon_sym_LT] = ACTIONS(235),
    [anon_sym_LT_EQ] = ACTIONS(237),
    [anon_sym_GT] = ACTIONS(235),
    [anon_sym_GT_EQ] = ACTIONS(237),
    [anon_sym_EQ_EQ] = ACTIONS(237),
    [anon_sym_BANG_EQ] = ACTIONS(237),
    [anon_sym_STAR] = ACTIONS(239),
    [anon_sym_SLASH] = ACTIONS(241),
    [anon_sym_STAR_STAR] = ACTIONS(243),
    [anon_sym_CARET] = ACTIONS(243),
    [aux_sym_binary_operator_token1] = ACTIONS(245),
    [anon_sym_PIPE_GT] = ACTIONS(245),
    [anon_sym_COLON] = ACTIONS(247),
    [anon_sym_DOLLAR] = ACTIONS(249),
    [anon_sym_AT] = ACTIONS(249),
    [aux_sym__hex_literal_token1] = ACTIONS(383),
    [sym__number_literal] = ACTIONS(385),
    [anon_sym_SQUOTE] = ACTIONS(383),
    [anon_sym_DQUOTE] = ACTIONS(383),
    [sym_return] = ACTIONS(385),
    [sym_next] = ACTIONS(385),
    [sym_break] = ACTIONS(385),
    [sym_true] = ACTIONS(385),
    [sym_false] = ACTIONS(385),
    [sym_null] = ACTIONS(385),
    [sym_inf] = ACTIONS(385),
    [sym_nan] = ACTIONS(385),
    [anon_sym_NA] = ACTIONS(385),
    [anon_sym_NA_integer_] = ACTIONS(385),
    [anon_sym_NA_real_] = ACTIONS(385),
    [anon_sym_NA_complex_] = ACTIONS(385),
    [anon_sym_NA_character_] = ACTIONS(385),
    [sym_dots] = ACTIONS(385),
    [sym_dot_dot_i] = ACTIONS(383),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(383),
    [sym__semicolon] = ACTIONS(383),
    [sym__raw_string_literal] = ACTIONS(383),
    [sym__external_else] = ACTIONS(383),
    [sym__external_open_parenthesis] = ACTIONS(253),
    [sym__external_open_brace] = ACTIONS(383),
    [sym__external_close_brace] = ACTIONS(383),
    [sym__external_open_bracket] = ACTIONS(255),
    [sym__external_open_bracket2] = ACTIONS(257),
  },
  [162] = {
    [sym_call_arguments] = STATE(850),
    [sym_subset_arguments] = STATE(851),
    [sym_subset2_arguments] = STATE(852),
    [sym__open_parenthesis] = STATE(349),
    [sym__open_bracket] = STATE(350),
    [sym__open_bracket2] = STATE(351),
    [sym_identifier] = ACTIONS(385),
    [anon_sym_BSLASH] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_EQ] = ACTIONS(385),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_for] = ACTIONS(385),
    [anon_sym_while] = ACTIONS(385),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_QMARK] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(383),
    [anon_sym_BANG] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(217),
    [anon_sym_DASH] = ACTIONS(219),
    [anon_sym_LT_DASH] = ACTIONS(383),
    [anon_sym_LT_LT_DASH] = ACTIONS(383),
    [anon_sym_COLON_EQ] = ACTIONS(383),
    [anon_sym_DASH_GT] = ACTIONS(385),
    [anon_sym_DASH_GT_GT] = ACTIONS(383),
    [anon_sym_PIPE] = ACTIONS(385),
    [anon_sym_AMP] = ACTIONS(385),
    [anon_sym_PIPE_PIPE] = ACTIONS(383),
    [anon_sym_AMP_AMP] = ACTIONS(383),
    [anon_sym_LT] = ACTIONS(385),
    [anon_sym_LT_EQ] = ACTIONS(383),
    [anon_sym_GT] = ACTIONS(385),
    [anon_sym_GT_EQ] = ACTIONS(383),
    [anon_sym_EQ_EQ] = ACTIONS(383),
    [anon_sym_BANG_EQ] = ACTIONS(383),
    [anon_sym_STAR] = ACTIONS(239),
    [anon_sym_SLASH] = ACTIONS(241),
    [anon_sym_STAR_STAR] = ACTIONS(243),
    [anon_sym_CARET] = ACTIONS(243),
    [aux_sym_binary_operator_token1] = ACTIONS(245),
    [anon_sym_PIPE_GT] = ACTIONS(245),
    [anon_sym_COLON] = ACTIONS(247),
    [anon_sym_DOLLAR] = ACTIONS(249),
    [anon_sym_AT] = ACTIONS(249),
    [aux_sym__hex_literal_token1] = ACTIONS(383),
    [sym__number_literal] = ACTIONS(385),
    [anon_sym_SQUOTE] = ACTIONS(383),
    [anon_sym_DQUOTE] = ACTIONS(383),
    [sym_return] = ACTIONS(385),
    [sym_next] = ACTIONS(385),
    [sym_break] = ACTIONS(385),
    [sym_true] = ACTIONS(385),
    [sym_false] = ACTIONS(385),
    [sym_null] = ACTIONS(385),
    [sym_inf] = ACTIONS(385),
    [sym_nan] = ACTIONS(385),
    [anon_sym_NA] = ACTIONS(385),
    [anon_sym_NA_integer_] = ACTIONS(385),
    [anon_sym_NA_real_] = ACTIONS(385),
    [anon_sym_NA_complex_] = ACTIONS(385),
    [anon_sym_NA_character_] = ACTIONS(385),
    [sym_dots] = ACTIONS(385),
    [sym_dot_dot_i] = ACTIONS(383),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(383),
    [sym__semicolon] = ACTIONS(383),
    [sym__raw_string_literal] = ACTIONS(383),
    [sym__external_else] = ACTIONS(383),
    [sym__external_open_parenthesis] = ACTIONS(253),
    [sym__external_open_brace] = ACTIONS(383),
    [sym__external_close_brace] = ACTIONS(383),
    [sym__external_open_bracket] = ACTIONS(255),
    [sym__external_open_bracket2] = ACTIONS(257),
  },
  [163] = {
    [sym_call_arguments] = STATE(850),
    [sym_subset_arguments] = STATE(851),
    [sym_subset2_arguments] = STATE(852),
    [sym__open_parenthesis] = STATE(349),
    [sym__open_bracket] = STATE(350),
    [sym__open_bracket2] = STATE(351),
    [sym_identifier] = ACTIONS(385),
    [anon_sym_BSLASH] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_EQ] = ACTIONS(385),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_for] = ACTIONS(385),
    [anon_sym_while] = ACTIONS(385),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_QMARK] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(383),
    [anon_sym_BANG] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(385),
    [anon_sym_LT_DASH] = ACTIONS(383),
    [anon_sym_LT_LT_DASH] = ACTIONS(383),
    [anon_sym_COLON_EQ] = ACTIONS(383),
    [anon_sym_DASH_GT] = ACTIONS(385),
    [anon_sym_DASH_GT_GT] = ACTIONS(383),
    [anon_sym_PIPE] = ACTIONS(385),
    [anon_sym_AMP] = ACTIONS(385),
    [anon_sym_PIPE_PIPE] = ACTIONS(383),
    [anon_sym_AMP_AMP] = ACTIONS(383),
    [anon_sym_LT] = ACTIONS(385),
    [anon_sym_LT_EQ] = ACTIONS(383),
    [anon_sym_GT] = ACTIONS(385),
    [anon_sym_GT_EQ] = ACTIONS(383),
    [anon_sym_EQ_EQ] = ACTIONS(383),
    [anon_sym_BANG_EQ] = ACTIONS(383),
    [anon_sym_STAR] = ACTIONS(385),
    [anon_sym_SLASH] = ACTIONS(383),
    [anon_sym_STAR_STAR] = ACTIONS(243),
    [anon_sym_CARET] = ACTIONS(243),
    [aux_sym_binary_operator_token1] = ACTIONS(245),
    [anon_sym_PIPE_GT] = ACTIONS(245),
    [anon_sym_COLON] = ACTIONS(247),
    [anon_sym_DOLLAR] = ACTIONS(249),
    [anon_sym_AT] = ACTIONS(249),
    [aux_sym__hex_literal_token1] = ACTIONS(383),
    [sym__number_literal] = ACTIONS(385),
    [anon_sym_SQUOTE] = ACTIONS(383),
    [anon_sym_DQUOTE] = ACTIONS(383),
    [sym_return] = ACTIONS(385),
    [sym_next] = ACTIONS(385),
    [sym_break] = ACTIONS(385),
    [sym_true] = ACTIONS(385),
    [sym_false] = ACTIONS(385),
    [sym_null] = ACTIONS(385),
    [sym_inf] = ACTIONS(385),
    [sym_nan] = ACTIONS(385),
    [anon_sym_NA] = ACTIONS(385),
    [anon_sym_NA_integer_] = ACTIONS(385),
    [anon_sym_NA_real_] = ACTIONS(385),
    [anon_sym_NA_complex_] = ACTIONS(385),
    [anon_sym_NA_character_] = ACTIONS(385),
    [sym_dots] = ACTIONS(385),
    [sym_dot_dot_i] = ACTIONS(383),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(383),
    [sym__semicolon] = ACTIONS(383),
    [sym__raw_string_literal] = ACTIONS(383),
    [sym__external_else] = ACTIONS(383),
    [sym__external_open_parenthesis] = ACTIONS(253),
    [sym__external_open_brace] = ACTIONS(383),
    [sym__external_close_brace] = ACTIONS(383),
    [sym__external_open_bracket] = ACTIONS(255),
    [sym__external_open_bracket2] = ACTIONS(257),
  },
  [164] = {
    [sym_call_arguments] = STATE(850),
    [sym_subset_arguments] = STATE(851),
    [sym_subset2_arguments] = STATE(852),
    [sym__open_parenthesis] = STATE(349),
    [sym__open_bracket] = STATE(350),
    [sym__open_bracket2] = STATE(351),
    [sym_identifier] = ACTIONS(385),
    [anon_sym_BSLASH] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_EQ] = ACTIONS(385),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_for] = ACTIONS(385),
    [anon_sym_while] = ACTIONS(385),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_QMARK] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(383),
    [anon_sym_BANG] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(385),
    [anon_sym_LT_DASH] = ACTIONS(383),
    [anon_sym_LT_LT_DASH] = ACTIONS(383),
    [anon_sym_COLON_EQ] = ACTIONS(383),
    [anon_sym_DASH_GT] = ACTIONS(385),
    [anon_sym_DASH_GT_GT] = ACTIONS(383),
    [anon_sym_PIPE] = ACTIONS(385),
    [anon_sym_AMP] = ACTIONS(385),
    [anon_sym_PIPE_PIPE] = ACTIONS(383),
    [anon_sym_AMP_AMP] = ACTIONS(383),
    [anon_sym_LT] = ACTIONS(385),
    [anon_sym_LT_EQ] = ACTIONS(383),
    [anon_sym_GT] = ACTIONS(385),
    [anon_sym_GT_EQ] = ACTIONS(383),
    [anon_sym_EQ_EQ] = ACTIONS(383),
    [anon_sym_BANG_EQ] = ACTIONS(383),
    [anon_sym_STAR] = ACTIONS(385),
    [anon_sym_SLASH] = ACTIONS(383),
    [anon_sym_STAR_STAR] = ACTIONS(243),
    [anon_sym_CARET] = ACTIONS(243),
    [aux_sym_binary_operator_token1] = ACTIONS(383),
    [anon_sym_PIPE_GT] = ACTIONS(383),
    [anon_sym_COLON] = ACTIONS(385),
    [anon_sym_DOLLAR] = ACTIONS(249),
    [anon_sym_AT] = ACTIONS(249),
    [aux_sym__hex_literal_token1] = ACTIONS(383),
    [sym__number_literal] = ACTIONS(385),
    [anon_sym_SQUOTE] = ACTIONS(383),
    [anon_sym_DQUOTE] = ACTIONS(383),
    [sym_return] = ACTIONS(385),
    [sym_next] = ACTIONS(385),
    [sym_break] = ACTIONS(385),
    [sym_true] = ACTIONS(385),
    [sym_false] = ACTIONS(385),
    [sym_null] = ACTIONS(385),
    [sym_inf] = ACTIONS(385),
    [sym_nan] = ACTIONS(385),
    [anon_sym_NA] = ACTIONS(385),
    [anon_sym_NA_integer_] = ACTIONS(385),
    [anon_sym_NA_real_] = ACTIONS(385),
    [anon_sym_NA_complex_] = ACTIONS(385),
    [anon_sym_NA_character_] = ACTIONS(385),
    [sym_dots] = ACTIONS(385),
    [sym_dot_dot_i] = ACTIONS(383),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(383),
    [sym__semicolon] = ACTIONS(383),
    [sym__raw_string_literal] = ACTIONS(383),
    [sym__external_else] = ACTIONS(383),
    [sym__external_open_parenthesis] = ACTIONS(253),
    [sym__external_open_brace] = ACTIONS(383),
    [sym__external_close_brace] = ACTIONS(383),
    [sym__external_open_bracket] = ACTIONS(255),
    [sym__external_open_bracket2] = ACTIONS(257),
  },
  [165] = {
    [sym_call_arguments] = STATE(850),
    [sym_subset_arguments] = STATE(851),
    [sym_subset2_arguments] = STATE(852),
    [sym__open_parenthesis] = STATE(349),
    [sym__open_bracket] = STATE(350),
    [sym__open_bracket2] = STATE(351),
    [sym_identifier] = ACTIONS(385),
    [anon_sym_BSLASH] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_EQ] = ACTIONS(385),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_for] = ACTIONS(385),
    [anon_sym_while] = ACTIONS(385),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_QMARK] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(383),
    [anon_sym_BANG] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(385),
    [anon_sym_LT_DASH] = ACTIONS(383),
    [anon_sym_LT_LT_DASH] = ACTIONS(383),
    [anon_sym_COLON_EQ] = ACTIONS(383),
    [anon_sym_DASH_GT] = ACTIONS(385),
    [anon_sym_DASH_GT_GT] = ACTIONS(383),
    [anon_sym_PIPE] = ACTIONS(385),
    [anon_sym_AMP] = ACTIONS(385),
    [anon_sym_PIPE_PIPE] = ACTIONS(383),
    [anon_sym_AMP_AMP] = ACTIONS(383),
    [anon_sym_LT] = ACTIONS(385),
    [anon_sym_LT_EQ] = ACTIONS(383),
    [anon_sym_GT] = ACTIONS(385),
    [anon_sym_GT_EQ] = ACTIONS(383),
    [anon_sym_EQ_EQ] = ACTIONS(383),
    [anon_sym_BANG_EQ] = ACTIONS(383),
    [anon_sym_STAR] = ACTIONS(385),
    [anon_sym_SLASH] = ACTIONS(383),
    [anon_sym_STAR_STAR] = ACTIONS(243),
    [anon_sym_CARET] = ACTIONS(243),
    [aux_sym_binary_operator_token1] = ACTIONS(383),
    [anon_sym_PIPE_GT] = ACTIONS(383),
    [anon_sym_COLON] = ACTIONS(247),
    [anon_sym_DOLLAR] = ACTIONS(249),
    [anon_sym_AT] = ACTIONS(249),
    [aux_sym__hex_literal_token1] = ACTIONS(383),
    [sym__number_literal] = ACTIONS(385),
    [anon_sym_SQUOTE] = ACTIONS(383),
    [anon_sym_DQUOTE] = ACTIONS(383),
    [sym_return] = ACTIONS(385),
    [sym_next] = ACTIONS(385),
    [sym_break] = ACTIONS(385),
    [sym_true] = ACTIONS(385),
    [sym_false] = ACTIONS(385),
    [sym_null] = ACTIONS(385),
    [sym_inf] = ACTIONS(385),
    [sym_nan] = ACTIONS(385),
    [anon_sym_NA] = ACTIONS(385),
    [anon_sym_NA_integer_] = ACTIONS(385),
    [anon_sym_NA_real_] = ACTIONS(385),
    [anon_sym_NA_complex_] = ACTIONS(385),
    [anon_sym_NA_character_] = ACTIONS(385),
    [sym_dots] = ACTIONS(385),
    [sym_dot_dot_i] = ACTIONS(383),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(383),
    [sym__semicolon] = ACTIONS(383),
    [sym__raw_string_literal] = ACTIONS(383),
    [sym__external_else] = ACTIONS(383),
    [sym__external_open_parenthesis] = ACTIONS(253),
    [sym__external_open_brace] = ACTIONS(383),
    [sym__external_close_brace] = ACTIONS(383),
    [sym__external_open_bracket] = ACTIONS(255),
    [sym__external_open_bracket2] = ACTIONS(257),
  },
  [166] = {
    [sym_call_arguments] = STATE(850),
    [sym_subset_arguments] = STATE(851),
    [sym_subset2_arguments] = STATE(852),
    [sym__open_parenthesis] = STATE(349),
    [sym__open_bracket] = STATE(350),
    [sym__open_bracket2] = STATE(351),
    [sym_identifier] = ACTIONS(385),
    [anon_sym_BSLASH] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_EQ] = ACTIONS(385),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_for] = ACTIONS(385),
    [anon_sym_while] = ACTIONS(385),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_QMARK] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(383),
    [anon_sym_BANG] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(385),
    [anon_sym_LT_DASH] = ACTIONS(383),
    [anon_sym_LT_LT_DASH] = ACTIONS(383),
    [anon_sym_COLON_EQ] = ACTIONS(383),
    [anon_sym_DASH_GT] = ACTIONS(385),
    [anon_sym_DASH_GT_GT] = ACTIONS(383),
    [anon_sym_PIPE] = ACTIONS(385),
    [anon_sym_AMP] = ACTIONS(385),
    [anon_sym_PIPE_PIPE] = ACTIONS(383),
    [anon_sym_AMP_AMP] = ACTIONS(383),
    [anon_sym_LT] = ACTIONS(385),
    [anon_sym_LT_EQ] = ACTIONS(383),
    [anon_sym_GT] = ACTIONS(385),
    [anon_sym_GT_EQ] = ACTIONS(383),
    [anon_sym_EQ_EQ] = ACTIONS(383),
    [anon_sym_BANG_EQ] = ACTIONS(383),
    [anon_sym_STAR] = ACTIONS(385),
    [anon_sym_SLASH] = ACTIONS(383),
    [anon_sym_STAR_STAR] = ACTIONS(243),
    [anon_sym_CARET] = ACTIONS(243),
    [aux_sym_binary_operator_token1] = ACTIONS(383),
    [anon_sym_PIPE_GT] = ACTIONS(383),
    [anon_sym_COLON] = ACTIONS(385),
    [anon_sym_DOLLAR] = ACTIONS(249),
    [anon_sym_AT] = ACTIONS(249),
    [aux_sym__hex_literal_token1] = ACTIONS(383),
    [sym__number_literal] = ACTIONS(385),
    [anon_sym_SQUOTE] = ACTIONS(383),
    [anon_sym_DQUOTE] = ACTIONS(383),
    [sym_return] = ACTIONS(385),
    [sym_next] = ACTIONS(385),
    [sym_break] = ACTIONS(385),
    [sym_true] = ACTIONS(385),
    [sym_false] = ACTIONS(385),
    [sym_null] = ACTIONS(385),
    [sym_inf] = ACTIONS(385),
    [sym_nan] = ACTIONS(385),
    [anon_sym_NA] = ACTIONS(385),
    [anon_sym_NA_integer_] = ACTIONS(385),
    [anon_sym_NA_real_] = ACTIONS(385),
    [anon_sym_NA_complex_] = ACTIONS(385),
    [anon_sym_NA_character_] = ACTIONS(385),
    [sym_dots] = ACTIONS(385),
    [sym_dot_dot_i] = ACTIONS(383),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(383),
    [sym__semicolon] = ACTIONS(383),
    [sym__raw_string_literal] = ACTIONS(383),
    [sym__external_else] = ACTIONS(383),
    [sym__external_open_parenthesis] = ACTIONS(253),
    [sym__external_open_brace] = ACTIONS(383),
    [sym__external_close_brace] = ACTIONS(383),
    [sym__external_open_bracket] = ACTIONS(255),
    [sym__external_open_bracket2] = ACTIONS(257),
  },
  [167] = {
    [sym_function_definition] = STATE(631),
    [sym_if_statement] = STATE(631),
    [sym_for_statement] = STATE(631),
    [sym_while_statement] = STATE(631),
    [sym_repeat_statement] = STATE(631),
    [sym_braced_expression] = STATE(631),
    [sym_parenthesized_expression] = STATE(631),
    [sym_call] = STATE(631),
    [sym_subset] = STATE(631),
    [sym_subset2] = STATE(631),
    [sym__argument] = STATE(1934),
    [sym_argument] = STATE(1937),
    [sym__argument_named] = STATE(1909),
    [sym__argument_unnamed] = STATE(1932),
    [sym__argument_value] = STATE(1920),
    [sym_unary_operator] = STATE(631),
    [sym_binary_operator] = STATE(631),
    [sym_extract_operator] = STATE(631),
    [sym_namespace_operator] = STATE(631),
    [sym_integer] = STATE(631),
    [sym_complex] = STATE(631),
    [sym_float] = STATE(631),
    [sym__hex_literal] = STATE(752),
    [sym__float_literal] = STATE(752),
    [sym_string] = STATE(766),
    [sym__single_quoted_string] = STATE(753),
    [sym__double_quoted_string] = STATE(754),
    [sym_na] = STATE(631),
    [sym__expression] = STATE(631),
    [sym__string_or_identifier] = STATE(2143),
    [sym__open_parenthesis] = STATE(869),
    [sym__open_brace] = STATE(764),
    [sym__close_bracket] = STATE(854),
    [aux_sym_call_arguments_repeat1] = STATE(529),
    [sym_identifier] = ACTIONS(387),
    [anon_sym_BSLASH] = ACTIONS(389),
    [anon_sym_function] = ACTIONS(391),
    [anon_sym_if] = ACTIONS(393),
    [anon_sym_for] = ACTIONS(395),
    [anon_sym_while] = ACTIONS(397),
    [anon_sym_repeat] = ACTIONS(399),
    [anon_sym_QMARK] = ACTIONS(401),
    [anon_sym_TILDE] = ACTIONS(403),
    [anon_sym_BANG] = ACTIONS(405),
    [anon_sym_PLUS] = ACTIONS(407),
    [anon_sym_DASH] = ACTIONS(407),
    [aux_sym__hex_literal_token1] = ACTIONS(409),
    [sym__number_literal] = ACTIONS(411),
    [anon_sym_SQUOTE] = ACTIONS(413),
    [anon_sym_DQUOTE] = ACTIONS(415),
    [sym_return] = ACTIONS(417),
    [sym_next] = ACTIONS(417),
    [sym_break] = ACTIONS(417),
    [sym_true] = ACTIONS(417),
    [sym_false] = ACTIONS(417),
    [sym_null] = ACTIONS(417),
    [sym_inf] = ACTIONS(417),
    [sym_nan] = ACTIONS(417),
    [anon_sym_NA] = ACTIONS(419),
    [anon_sym_NA_integer_] = ACTIONS(419),
    [anon_sym_NA_real_] = ACTIONS(419),
    [anon_sym_NA_complex_] = ACTIONS(419),
    [anon_sym_NA_character_] = ACTIONS(419),
    [sym_dots] = ACTIONS(421),
    [sym_dot_dot_i] = ACTIONS(423),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(425),
    [sym__newline] = ACTIONS(427),
    [sym__raw_string_literal] = ACTIONS(429),
    [sym__external_open_parenthesis] = ACTIONS(431),
    [sym__external_open_brace] = ACTIONS(433),
    [sym__external_close_bracket] = ACTIONS(551),
  },
  [168] = {
    [sym_function_definition] = STATE(568),
    [sym_if_statement] = STATE(568),
    [sym_for_statement] = STATE(568),
    [sym_while_statement] = STATE(568),
    [sym_repeat_statement] = STATE(568),
    [sym_braced_expression] = STATE(568),
    [sym_parenthesized_expression] = STATE(568),
    [sym_call] = STATE(568),
    [sym_subset] = STATE(568),
    [sym_subset2] = STATE(568),
    [sym__argument] = STATE(1928),
    [sym_argument] = STATE(1930),
    [sym__argument_named] = STATE(1908),
    [sym__argument_unnamed] = STATE(1933),
    [sym__argument_value] = STATE(1936),
    [sym_unary_operator] = STATE(568),
    [sym_binary_operator] = STATE(568),
    [sym_extract_operator] = STATE(568),
    [sym_namespace_operator] = STATE(568),
    [sym_integer] = STATE(568),
    [sym_complex] = STATE(568),
    [sym_float] = STATE(568),
    [sym__hex_literal] = STATE(703),
    [sym__float_literal] = STATE(703),
    [sym_string] = STATE(736),
    [sym__single_quoted_string] = STATE(705),
    [sym__double_quoted_string] = STATE(706),
    [sym_na] = STATE(568),
    [sym__expression] = STATE(568),
    [sym__string_or_identifier] = STATE(2142),
    [sym__open_parenthesis] = STATE(874),
    [sym__open_brace] = STATE(765),
    [sym__close_bracket2] = STATE(788),
    [aux_sym_call_arguments_repeat1] = STATE(585),
    [sym_identifier] = ACTIONS(437),
    [anon_sym_BSLASH] = ACTIONS(439),
    [anon_sym_function] = ACTIONS(441),
    [anon_sym_if] = ACTIONS(443),
    [anon_sym_for] = ACTIONS(445),
    [anon_sym_while] = ACTIONS(447),
    [anon_sym_repeat] = ACTIONS(449),
    [anon_sym_QMARK] = ACTIONS(451),
    [anon_sym_TILDE] = ACTIONS(453),
    [anon_sym_BANG] = ACTIONS(455),
    [anon_sym_PLUS] = ACTIONS(457),
    [anon_sym_DASH] = ACTIONS(457),
    [aux_sym__hex_literal_token1] = ACTIONS(459),
    [sym__number_literal] = ACTIONS(461),
    [anon_sym_SQUOTE] = ACTIONS(463),
    [anon_sym_DQUOTE] = ACTIONS(465),
    [sym_return] = ACTIONS(467),
    [sym_next] = ACTIONS(467),
    [sym_break] = ACTIONS(467),
    [sym_true] = ACTIONS(467),
    [sym_false] = ACTIONS(467),
    [sym_null] = ACTIONS(467),
    [sym_inf] = ACTIONS(467),
    [sym_nan] = ACTIONS(467),
    [anon_sym_NA] = ACTIONS(469),
    [anon_sym_NA_integer_] = ACTIONS(469),
    [anon_sym_NA_real_] = ACTIONS(469),
    [anon_sym_NA_complex_] = ACTIONS(469),
    [anon_sym_NA_character_] = ACTIONS(469),
    [sym_dots] = ACTIONS(471),
    [sym_dot_dot_i] = ACTIONS(473),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(475),
    [sym__newline] = ACTIONS(477),
    [sym__raw_string_literal] = ACTIONS(479),
    [sym__external_open_parenthesis] = ACTIONS(481),
    [sym__external_open_brace] = ACTIONS(483),
    [sym__external_close_bracket2] = ACTIONS(553),
  },
  [169] = {
    [sym_call_arguments] = STATE(850),
    [sym_subset_arguments] = STATE(851),
    [sym_subset2_arguments] = STATE(852),
    [sym__open_parenthesis] = STATE(349),
    [sym__open_bracket] = STATE(350),
    [sym__open_bracket2] = STATE(351),
    [sym_identifier] = ACTIONS(489),
    [anon_sym_BSLASH] = ACTIONS(487),
    [anon_sym_function] = ACTIONS(489),
    [anon_sym_EQ] = ACTIONS(213),
    [anon_sym_if] = ACTIONS(489),
    [anon_sym_for] = ACTIONS(489),
    [anon_sym_while] = ACTIONS(489),
    [anon_sym_repeat] = ACTIONS(489),
    [anon_sym_QMARK] = ACTIONS(487),
    [anon_sym_TILDE] = ACTIONS(215),
    [anon_sym_BANG] = ACTIONS(489),
    [anon_sym_PLUS] = ACTIONS(217),
    [anon_sym_DASH] = ACTIONS(219),
    [anon_sym_LT_DASH] = ACTIONS(221),
    [anon_sym_LT_LT_DASH] = ACTIONS(221),
    [anon_sym_COLON_EQ] = ACTIONS(221),
    [anon_sym_DASH_GT] = ACTIONS(223),
    [anon_sym_DASH_GT_GT] = ACTIONS(225),
    [anon_sym_PIPE] = ACTIONS(227),
    [anon_sym_AMP] = ACTIONS(229),
    [anon_sym_PIPE_PIPE] = ACTIONS(231),
    [anon_sym_AMP_AMP] = ACTIONS(233),
    [anon_sym_LT] = ACTIONS(235),
    [anon_sym_LT_EQ] = ACTIONS(237),
    [anon_sym_GT] = ACTIONS(235),
    [anon_sym_GT_EQ] = ACTIONS(237),
    [anon_sym_EQ_EQ] = ACTIONS(237),
    [anon_sym_BANG_EQ] = ACTIONS(237),
    [anon_sym_STAR] = ACTIONS(239),
    [anon_sym_SLASH] = ACTIONS(241),
    [anon_sym_STAR_STAR] = ACTIONS(243),
    [anon_sym_CARET] = ACTIONS(243),
    [aux_sym_binary_operator_token1] = ACTIONS(245),
    [anon_sym_PIPE_GT] = ACTIONS(245),
    [anon_sym_COLON] = ACTIONS(247),
    [anon_sym_DOLLAR] = ACTIONS(249),
    [anon_sym_AT] = ACTIONS(249),
    [aux_sym__hex_literal_token1] = ACTIONS(487),
    [sym__number_literal] = ACTIONS(489),
    [anon_sym_SQUOTE] = ACTIONS(487),
    [anon_sym_DQUOTE] = ACTIONS(487),
    [sym_return] = ACTIONS(489),
    [sym_next] = ACTIONS(489),
    [sym_break] = ACTIONS(489),
    [sym_true] = ACTIONS(489),
    [sym_false] = ACTIONS(489),
    [sym_null] = ACTIONS(489),
    [sym_inf] = ACTIONS(489),
    [sym_nan] = ACTIONS(489),
    [anon_sym_NA] = ACTIONS(489),
    [anon_sym_NA_integer_] = ACTIONS(489),
    [anon_sym_NA_real_] = ACTIONS(489),
    [anon_sym_NA_complex_] = ACTIONS(489),
    [anon_sym_NA_character_] = ACTIONS(489),
    [sym_dots] = ACTIONS(489),
    [sym_dot_dot_i] = ACTIONS(487),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(487),
    [sym__semicolon] = ACTIONS(487),
    [sym__raw_string_literal] = ACTIONS(487),
    [sym__external_else] = ACTIONS(487),
    [sym__external_open_parenthesis] = ACTIONS(253),
    [sym__external_open_brace] = ACTIONS(487),
    [sym__external_close_brace] = ACTIONS(487),
    [sym__external_open_bracket] = ACTIONS(255),
    [sym__external_open_bracket2] = ACTIONS(257),
  },
  [170] = {
    [sym_call_arguments] = STATE(850),
    [sym_subset_arguments] = STATE(851),
    [sym_subset2_arguments] = STATE(852),
    [sym__open_parenthesis] = STATE(349),
    [sym__open_bracket] = STATE(350),
    [sym__open_bracket2] = STATE(351),
    [sym_identifier] = ACTIONS(493),
    [anon_sym_BSLASH] = ACTIONS(491),
    [anon_sym_function] = ACTIONS(493),
    [anon_sym_EQ] = ACTIONS(213),
    [anon_sym_if] = ACTIONS(493),
    [anon_sym_for] = ACTIONS(493),
    [anon_sym_while] = ACTIONS(493),
    [anon_sym_repeat] = ACTIONS(493),
    [anon_sym_QMARK] = ACTIONS(491),
    [anon_sym_TILDE] = ACTIONS(215),
    [anon_sym_BANG] = ACTIONS(493),
    [anon_sym_PLUS] = ACTIONS(217),
    [anon_sym_DASH] = ACTIONS(219),
    [anon_sym_LT_DASH] = ACTIONS(491),
    [anon_sym_LT_LT_DASH] = ACTIONS(491),
    [anon_sym_COLON_EQ] = ACTIONS(491),
    [anon_sym_DASH_GT] = ACTIONS(223),
    [anon_sym_DASH_GT_GT] = ACTIONS(225),
    [anon_sym_PIPE] = ACTIONS(227),
    [anon_sym_AMP] = ACTIONS(229),
    [anon_sym_PIPE_PIPE] = ACTIONS(231),
    [anon_sym_AMP_AMP] = ACTIONS(233),
    [anon_sym_LT] = ACTIONS(235),
    [anon_sym_LT_EQ] = ACTIONS(237),
    [anon_sym_GT] = ACTIONS(235),
    [anon_sym_GT_EQ] = ACTIONS(237),
    [anon_sym_EQ_EQ] = ACTIONS(237),
    [anon_sym_BANG_EQ] = ACTIONS(237),
    [anon_sym_STAR] = ACTIONS(239),
    [anon_sym_SLASH] = ACTIONS(241),
    [anon_sym_STAR_STAR] = ACTIONS(243),
    [anon_sym_CARET] = ACTIONS(243),
    [aux_sym_binary_operator_token1] = ACTIONS(245),
    [anon_sym_PIPE_GT] = ACTIONS(245),
    [anon_sym_COLON] = ACTIONS(247),
    [anon_sym_DOLLAR] = ACTIONS(249),
    [anon_sym_AT] = ACTIONS(249),
    [aux_sym__hex_literal_token1] = ACTIONS(491),
    [sym__number_literal] = ACTIONS(493),
    [anon_sym_SQUOTE] = ACTIONS(491),
    [anon_sym_DQUOTE] = ACTIONS(491),
    [sym_return] = ACTIONS(493),
    [sym_next] = ACTIONS(493),
    [sym_break] = ACTIONS(493),
    [sym_true] = ACTIONS(493),
    [sym_false] = ACTIONS(493),
    [sym_null] = ACTIONS(493),
    [sym_inf] = ACTIONS(493),
    [sym_nan] = ACTIONS(493),
    [anon_sym_NA] = ACTIONS(493),
    [anon_sym_NA_integer_] = ACTIONS(493),
    [anon_sym_NA_real_] = ACTIONS(493),
    [anon_sym_NA_complex_] = ACTIONS(493),
    [anon_sym_NA_character_] = ACTIONS(493),
    [sym_dots] = ACTIONS(493),
    [sym_dot_dot_i] = ACTIONS(491),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(491),
    [sym__semicolon] = ACTIONS(491),
    [sym__raw_string_literal] = ACTIONS(491),
    [sym__external_else] = ACTIONS(491),
    [sym__external_open_parenthesis] = ACTIONS(253),
    [sym__external_open_brace] = ACTIONS(491),
    [sym__external_close_brace] = ACTIONS(491),
    [sym__external_open_bracket] = ACTIONS(255),
    [sym__external_open_bracket2] = ACTIONS(257),
  },
  [171] = {
    [sym_call_arguments] = STATE(850),
    [sym_subset_arguments] = STATE(851),
    [sym_subset2_arguments] = STATE(852),
    [sym__open_parenthesis] = STATE(349),
    [sym__open_bracket] = STATE(350),
    [sym__open_bracket2] = STATE(351),
    [sym_identifier] = ACTIONS(493),
    [anon_sym_BSLASH] = ACTIONS(491),
    [anon_sym_function] = ACTIONS(493),
    [anon_sym_EQ] = ACTIONS(213),
    [anon_sym_if] = ACTIONS(493),
    [anon_sym_for] = ACTIONS(493),
    [anon_sym_while] = ACTIONS(493),
    [anon_sym_repeat] = ACTIONS(493),
    [anon_sym_QMARK] = ACTIONS(491),
    [anon_sym_TILDE] = ACTIONS(215),
    [anon_sym_BANG] = ACTIONS(493),
    [anon_sym_PLUS] = ACTIONS(217),
    [anon_sym_DASH] = ACTIONS(219),
    [anon_sym_LT_DASH] = ACTIONS(221),
    [anon_sym_LT_LT_DASH] = ACTIONS(221),
    [anon_sym_COLON_EQ] = ACTIONS(221),
    [anon_sym_DASH_GT] = ACTIONS(223),
    [anon_sym_DASH_GT_GT] = ACTIONS(225),
    [anon_sym_PIPE] = ACTIONS(227),
    [anon_sym_AMP] = ACTIONS(229),
    [anon_sym_PIPE_PIPE] = ACTIONS(231),
    [anon_sym_AMP_AMP] = ACTIONS(233),
    [anon_sym_LT] = ACTIONS(235),
    [anon_sym_LT_EQ] = ACTIONS(237),
    [anon_sym_GT] = ACTIONS(235),
    [anon_sym_GT_EQ] = ACTIONS(237),
    [anon_sym_EQ_EQ] = ACTIONS(237),
    [anon_sym_BANG_EQ] = ACTIONS(237),
    [anon_sym_STAR] = ACTIONS(239),
    [anon_sym_SLASH] = ACTIONS(241),
    [anon_sym_STAR_STAR] = ACTIONS(243),
    [anon_sym_CARET] = ACTIONS(243),
    [aux_sym_binary_operator_token1] = ACTIONS(245),
    [anon_sym_PIPE_GT] = ACTIONS(245),
    [anon_sym_COLON] = ACTIONS(247),
    [anon_sym_DOLLAR] = ACTIONS(249),
    [anon_sym_AT] = ACTIONS(249),
    [aux_sym__hex_literal_token1] = ACTIONS(491),
    [sym__number_literal] = ACTIONS(493),
    [anon_sym_SQUOTE] = ACTIONS(491),
    [anon_sym_DQUOTE] = ACTIONS(491),
    [sym_return] = ACTIONS(493),
    [sym_next] = ACTIONS(493),
    [sym_break] = ACTIONS(493),
    [sym_true] = ACTIONS(493),
    [sym_false] = ACTIONS(493),
    [sym_null] = ACTIONS(493),
    [sym_inf] = ACTIONS(493),
    [sym_nan] = ACTIONS(493),
    [anon_sym_NA] = ACTIONS(493),
    [anon_sym_NA_integer_] = ACTIONS(493),
    [anon_sym_NA_real_] = ACTIONS(493),
    [anon_sym_NA_complex_] = ACTIONS(493),
    [anon_sym_NA_character_] = ACTIONS(493),
    [sym_dots] = ACTIONS(493),
    [sym_dot_dot_i] = ACTIONS(491),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(491),
    [sym__semicolon] = ACTIONS(491),
    [sym__raw_string_literal] = ACTIONS(491),
    [sym__external_else] = ACTIONS(491),
    [sym__external_open_parenthesis] = ACTIONS(253),
    [sym__external_open_brace] = ACTIONS(491),
    [sym__external_close_brace] = ACTIONS(491),
    [sym__external_open_bracket] = ACTIONS(255),
    [sym__external_open_bracket2] = ACTIONS(257),
  },
  [172] = {
    [sym_call_arguments] = STATE(850),
    [sym_subset_arguments] = STATE(851),
    [sym_subset2_arguments] = STATE(852),
    [sym__open_parenthesis] = STATE(349),
    [sym__open_bracket] = STATE(350),
    [sym__open_bracket2] = STATE(351),
    [sym_identifier] = ACTIONS(493),
    [anon_sym_BSLASH] = ACTIONS(491),
    [anon_sym_function] = ACTIONS(493),
    [anon_sym_EQ] = ACTIONS(493),
    [anon_sym_if] = ACTIONS(493),
    [anon_sym_for] = ACTIONS(493),
    [anon_sym_while] = ACTIONS(493),
    [anon_sym_repeat] = ACTIONS(493),
    [anon_sym_QMARK] = ACTIONS(491),
    [anon_sym_TILDE] = ACTIONS(491),
    [anon_sym_BANG] = ACTIONS(493),
    [anon_sym_PLUS] = ACTIONS(217),
    [anon_sym_DASH] = ACTIONS(219),
    [anon_sym_LT_DASH] = ACTIONS(491),
    [anon_sym_LT_LT_DASH] = ACTIONS(491),
    [anon_sym_COLON_EQ] = ACTIONS(491),
    [anon_sym_DASH_GT] = ACTIONS(493),
    [anon_sym_DASH_GT_GT] = ACTIONS(491),
    [anon_sym_PIPE] = ACTIONS(227),
    [anon_sym_AMP] = ACTIONS(229),
    [anon_sym_PIPE_PIPE] = ACTIONS(231),
    [anon_sym_AMP_AMP] = ACTIONS(233),
    [anon_sym_LT] = ACTIONS(235),
    [anon_sym_LT_EQ] = ACTIONS(237),
    [anon_sym_GT] = ACTIONS(235),
    [anon_sym_GT_EQ] = ACTIONS(237),
    [anon_sym_EQ_EQ] = ACTIONS(237),
    [anon_sym_BANG_EQ] = ACTIONS(237),
    [anon_sym_STAR] = ACTIONS(239),
    [anon_sym_SLASH] = ACTIONS(241),
    [anon_sym_STAR_STAR] = ACTIONS(243),
    [anon_sym_CARET] = ACTIONS(243),
    [aux_sym_binary_operator_token1] = ACTIONS(245),
    [anon_sym_PIPE_GT] = ACTIONS(245),
    [anon_sym_COLON] = ACTIONS(247),
    [anon_sym_DOLLAR] = ACTIONS(249),
    [anon_sym_AT] = ACTIONS(249),
    [aux_sym__hex_literal_token1] = ACTIONS(491),
    [sym__number_literal] = ACTIONS(493),
    [anon_sym_SQUOTE] = ACTIONS(491),
    [anon_sym_DQUOTE] = ACTIONS(491),
    [sym_return] = ACTIONS(493),
    [sym_next] = ACTIONS(493),
    [sym_break] = ACTIONS(493),
    [sym_true] = ACTIONS(493),
    [sym_false] = ACTIONS(493),
    [sym_null] = ACTIONS(493),
    [sym_inf] = ACTIONS(493),
    [sym_nan] = ACTIONS(493),
    [anon_sym_NA] = ACTIONS(493),
    [anon_sym_NA_integer_] = ACTIONS(493),
    [anon_sym_NA_real_] = ACTIONS(493),
    [anon_sym_NA_complex_] = ACTIONS(493),
    [anon_sym_NA_character_] = ACTIONS(493),
    [sym_dots] = ACTIONS(493),
    [sym_dot_dot_i] = ACTIONS(491),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(491),
    [sym__semicolon] = ACTIONS(491),
    [sym__raw_string_literal] = ACTIONS(491),
    [sym__external_else] = ACTIONS(491),
    [sym__external_open_parenthesis] = ACTIONS(253),
    [sym__external_open_brace] = ACTIONS(491),
    [sym__external_close_brace] = ACTIONS(491),
    [sym__external_open_bracket] = ACTIONS(255),
    [sym__external_open_bracket2] = ACTIONS(257),
  },
  [173] = {
    [sym_call_arguments] = STATE(850),
    [sym_subset_arguments] = STATE(851),
    [sym_subset2_arguments] = STATE(852),
    [sym__open_parenthesis] = STATE(349),
    [sym__open_bracket] = STATE(350),
    [sym__open_bracket2] = STATE(351),
    [sym_identifier] = ACTIONS(493),
    [anon_sym_BSLASH] = ACTIONS(491),
    [anon_sym_function] = ACTIONS(493),
    [anon_sym_EQ] = ACTIONS(493),
    [anon_sym_if] = ACTIONS(493),
    [anon_sym_for] = ACTIONS(493),
    [anon_sym_while] = ACTIONS(493),
    [anon_sym_repeat] = ACTIONS(493),
    [anon_sym_QMARK] = ACTIONS(491),
    [anon_sym_TILDE] = ACTIONS(491),
    [anon_sym_BANG] = ACTIONS(493),
    [anon_sym_PLUS] = ACTIONS(491),
    [anon_sym_DASH] = ACTIONS(493),
    [anon_sym_LT_DASH] = ACTIONS(491),
    [anon_sym_LT_LT_DASH] = ACTIONS(491),
    [anon_sym_COLON_EQ] = ACTIONS(491),
    [anon_sym_DASH_GT] = ACTIONS(493),
    [anon_sym_DASH_GT_GT] = ACTIONS(491),
    [anon_sym_PIPE] = ACTIONS(493),
    [anon_sym_AMP] = ACTIONS(493),
    [anon_sym_PIPE_PIPE] = ACTIONS(491),
    [anon_sym_AMP_AMP] = ACTIONS(491),
    [anon_sym_LT] = ACTIONS(493),
    [anon_sym_LT_EQ] = ACTIONS(491),
    [anon_sym_GT] = ACTIONS(493),
    [anon_sym_GT_EQ] = ACTIONS(491),
    [anon_sym_EQ_EQ] = ACTIONS(491),
    [anon_sym_BANG_EQ] = ACTIONS(491),
    [anon_sym_STAR] = ACTIONS(239),
    [anon_sym_SLASH] = ACTIONS(241),
    [anon_sym_STAR_STAR] = ACTIONS(243),
    [anon_sym_CARET] = ACTIONS(243),
    [aux_sym_binary_operator_token1] = ACTIONS(245),
    [anon_sym_PIPE_GT] = ACTIONS(245),
    [anon_sym_COLON] = ACTIONS(247),
    [anon_sym_DOLLAR] = ACTIONS(249),
    [anon_sym_AT] = ACTIONS(249),
    [aux_sym__hex_literal_token1] = ACTIONS(491),
    [sym__number_literal] = ACTIONS(493),
    [anon_sym_SQUOTE] = ACTIONS(491),
    [anon_sym_DQUOTE] = ACTIONS(491),
    [sym_return] = ACTIONS(493),
    [sym_next] = ACTIONS(493),
    [sym_break] = ACTIONS(493),
    [sym_true] = ACTIONS(493),
    [sym_false] = ACTIONS(493),
    [sym_null] = ACTIONS(493),
    [sym_inf] = ACTIONS(493),
    [sym_nan] = ACTIONS(493),
    [anon_sym_NA] = ACTIONS(493),
    [anon_sym_NA_integer_] = ACTIONS(493),
    [anon_sym_NA_real_] = ACTIONS(493),
    [anon_sym_NA_complex_] = ACTIONS(493),
    [anon_sym_NA_character_] = ACTIONS(493),
    [sym_dots] = ACTIONS(493),
    [sym_dot_dot_i] = ACTIONS(491),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(491),
    [sym__semicolon] = ACTIONS(491),
    [sym__raw_string_literal] = ACTIONS(491),
    [sym__external_else] = ACTIONS(491),
    [sym__external_open_parenthesis] = ACTIONS(253),
    [sym__external_open_brace] = ACTIONS(491),
    [sym__external_close_brace] = ACTIONS(491),
    [sym__external_open_bracket] = ACTIONS(255),
    [sym__external_open_bracket2] = ACTIONS(257),
  },
  [174] = {
    [sym_call_arguments] = STATE(850),
    [sym_subset_arguments] = STATE(851),
    [sym_subset2_arguments] = STATE(852),
    [sym__open_parenthesis] = STATE(349),
    [sym__open_bracket] = STATE(350),
    [sym__open_bracket2] = STATE(351),
    [sym_identifier] = ACTIONS(493),
    [anon_sym_BSLASH] = ACTIONS(491),
    [anon_sym_function] = ACTIONS(493),
    [anon_sym_EQ] = ACTIONS(213),
    [anon_sym_if] = ACTIONS(493),
    [anon_sym_for] = ACTIONS(493),
    [anon_sym_while] = ACTIONS(493),
    [anon_sym_repeat] = ACTIONS(493),
    [anon_sym_QMARK] = ACTIONS(491),
    [anon_sym_TILDE] = ACTIONS(215),
    [anon_sym_BANG] = ACTIONS(493),
    [anon_sym_PLUS] = ACTIONS(217),
    [anon_sym_DASH] = ACTIONS(219),
    [anon_sym_LT_DASH] = ACTIONS(221),
    [anon_sym_LT_LT_DASH] = ACTIONS(221),
    [anon_sym_COLON_EQ] = ACTIONS(221),
    [anon_sym_DASH_GT] = ACTIONS(223),
    [anon_sym_DASH_GT_GT] = ACTIONS(225),
    [anon_sym_PIPE] = ACTIONS(227),
    [anon_sym_AMP] = ACTIONS(229),
    [anon_sym_PIPE_PIPE] = ACTIONS(231),
    [anon_sym_AMP_AMP] = ACTIONS(233),
    [anon_sym_LT] = ACTIONS(235),
    [anon_sym_LT_EQ] = ACTIONS(237),
    [anon_sym_GT] = ACTIONS(235),
    [anon_sym_GT_EQ] = ACTIONS(237),
    [anon_sym_EQ_EQ] = ACTIONS(237),
    [anon_sym_BANG_EQ] = ACTIONS(237),
    [anon_sym_STAR] = ACTIONS(239),
    [anon_sym_SLASH] = ACTIONS(241),
    [anon_sym_STAR_STAR] = ACTIONS(243),
    [anon_sym_CARET] = ACTIONS(243),
    [aux_sym_binary_operator_token1] = ACTIONS(245),
    [anon_sym_PIPE_GT] = ACTIONS(245),
    [anon_sym_COLON] = ACTIONS(247),
    [anon_sym_DOLLAR] = ACTIONS(249),
    [anon_sym_AT] = ACTIONS(249),
    [aux_sym__hex_literal_token1] = ACTIONS(491),
    [sym__number_literal] = ACTIONS(493),
    [anon_sym_SQUOTE] = ACTIONS(491),
    [anon_sym_DQUOTE] = ACTIONS(491),
    [sym_return] = ACTIONS(493),
    [sym_next] = ACTIONS(493),
    [sym_break] = ACTIONS(493),
    [sym_true] = ACTIONS(493),
    [sym_false] = ACTIONS(493),
    [sym_null] = ACTIONS(493),
    [sym_inf] = ACTIONS(493),
    [sym_nan] = ACTIONS(493),
    [anon_sym_NA] = ACTIONS(493),
    [anon_sym_NA_integer_] = ACTIONS(493),
    [anon_sym_NA_real_] = ACTIONS(493),
    [anon_sym_NA_complex_] = ACTIONS(493),
    [anon_sym_NA_character_] = ACTIONS(493),
    [sym_dots] = ACTIONS(493),
    [sym_dot_dot_i] = ACTIONS(491),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(491),
    [sym__semicolon] = ACTIONS(491),
    [sym__raw_string_literal] = ACTIONS(491),
    [sym__external_else] = ACTIONS(491),
    [sym__external_open_parenthesis] = ACTIONS(253),
    [sym__external_open_brace] = ACTIONS(491),
    [sym__external_close_brace] = ACTIONS(491),
    [sym__external_open_bracket] = ACTIONS(255),
    [sym__external_open_bracket2] = ACTIONS(257),
  },
  [175] = {
    [sym_call_arguments] = STATE(850),
    [sym_subset_arguments] = STATE(851),
    [sym_subset2_arguments] = STATE(852),
    [sym__open_parenthesis] = STATE(349),
    [sym__open_bracket] = STATE(350),
    [sym__open_bracket2] = STATE(351),
    [sym_identifier] = ACTIONS(493),
    [anon_sym_BSLASH] = ACTIONS(491),
    [anon_sym_function] = ACTIONS(493),
    [anon_sym_EQ] = ACTIONS(493),
    [anon_sym_if] = ACTIONS(493),
    [anon_sym_for] = ACTIONS(493),
    [anon_sym_while] = ACTIONS(493),
    [anon_sym_repeat] = ACTIONS(493),
    [anon_sym_QMARK] = ACTIONS(491),
    [anon_sym_TILDE] = ACTIONS(215),
    [anon_sym_BANG] = ACTIONS(493),
    [anon_sym_PLUS] = ACTIONS(217),
    [anon_sym_DASH] = ACTIONS(219),
    [anon_sym_LT_DASH] = ACTIONS(491),
    [anon_sym_LT_LT_DASH] = ACTIONS(491),
    [anon_sym_COLON_EQ] = ACTIONS(491),
    [anon_sym_DASH_GT] = ACTIONS(493),
    [anon_sym_DASH_GT_GT] = ACTIONS(491),
    [anon_sym_PIPE] = ACTIONS(227),
    [anon_sym_AMP] = ACTIONS(229),
    [anon_sym_PIPE_PIPE] = ACTIONS(231),
    [anon_sym_AMP_AMP] = ACTIONS(233),
    [anon_sym_LT] = ACTIONS(235),
    [anon_sym_LT_EQ] = ACTIONS(237),
    [anon_sym_GT] = ACTIONS(235),
    [anon_sym_GT_EQ] = ACTIONS(237),
    [anon_sym_EQ_EQ] = ACTIONS(237),
    [anon_sym_BANG_EQ] = ACTIONS(237),
    [anon_sym_STAR] = ACTIONS(239),
    [anon_sym_SLASH] = ACTIONS(241),
    [anon_sym_STAR_STAR] = ACTIONS(243),
    [anon_sym_CARET] = ACTIONS(243),
    [aux_sym_binary_operator_token1] = ACTIONS(245),
    [anon_sym_PIPE_GT] = ACTIONS(245),
    [anon_sym_COLON] = ACTIONS(247),
    [anon_sym_DOLLAR] = ACTIONS(249),
    [anon_sym_AT] = ACTIONS(249),
    [aux_sym__hex_literal_token1] = ACTIONS(491),
    [sym__number_literal] = ACTIONS(493),
    [anon_sym_SQUOTE] = ACTIONS(491),
    [anon_sym_DQUOTE] = ACTIONS(491),
    [sym_return] = ACTIONS(493),
    [sym_next] = ACTIONS(493),
    [sym_break] = ACTIONS(493),
    [sym_true] = ACTIONS(493),
    [sym_false] = ACTIONS(493),
    [sym_null] = ACTIONS(493),
    [sym_inf] = ACTIONS(493),
    [sym_nan] = ACTIONS(493),
    [anon_sym_NA] = ACTIONS(493),
    [anon_sym_NA_integer_] = ACTIONS(493),
    [anon_sym_NA_real_] = ACTIONS(493),
    [anon_sym_NA_complex_] = ACTIONS(493),
    [anon_sym_NA_character_] = ACTIONS(493),
    [sym_dots] = ACTIONS(493),
    [sym_dot_dot_i] = ACTIONS(491),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(491),
    [sym__semicolon] = ACTIONS(491),
    [sym__raw_string_literal] = ACTIONS(491),
    [sym__external_else] = ACTIONS(491),
    [sym__external_open_parenthesis] = ACTIONS(253),
    [sym__external_open_brace] = ACTIONS(491),
    [sym__external_close_brace] = ACTIONS(491),
    [sym__external_open_bracket] = ACTIONS(255),
    [sym__external_open_bracket2] = ACTIONS(257),
  },
  [176] = {
    [sym_call_arguments] = STATE(850),
    [sym_subset_arguments] = STATE(851),
    [sym_subset2_arguments] = STATE(852),
    [sym__open_parenthesis] = STATE(349),
    [sym__open_bracket] = STATE(350),
    [sym__open_bracket2] = STATE(351),
    [sym_identifier] = ACTIONS(493),
    [anon_sym_BSLASH] = ACTIONS(491),
    [anon_sym_function] = ACTIONS(493),
    [anon_sym_EQ] = ACTIONS(493),
    [anon_sym_if] = ACTIONS(493),
    [anon_sym_for] = ACTIONS(493),
    [anon_sym_while] = ACTIONS(493),
    [anon_sym_repeat] = ACTIONS(493),
    [anon_sym_QMARK] = ACTIONS(491),
    [anon_sym_TILDE] = ACTIONS(491),
    [anon_sym_BANG] = ACTIONS(493),
    [anon_sym_PLUS] = ACTIONS(217),
    [anon_sym_DASH] = ACTIONS(219),
    [anon_sym_LT_DASH] = ACTIONS(491),
    [anon_sym_LT_LT_DASH] = ACTIONS(491),
    [anon_sym_COLON_EQ] = ACTIONS(491),
    [anon_sym_DASH_GT] = ACTIONS(493),
    [anon_sym_DASH_GT_GT] = ACTIONS(491),
    [anon_sym_PIPE] = ACTIONS(493),
    [anon_sym_AMP] = ACTIONS(229),
    [anon_sym_PIPE_PIPE] = ACTIONS(491),
    [anon_sym_AMP_AMP] = ACTIONS(233),
    [anon_sym_LT] = ACTIONS(235),
    [anon_sym_LT_EQ] = ACTIONS(237),
    [anon_sym_GT] = ACTIONS(235),
    [anon_sym_GT_EQ] = ACTIONS(237),
    [anon_sym_EQ_EQ] = ACTIONS(237),
    [anon_sym_BANG_EQ] = ACTIONS(237),
    [anon_sym_STAR] = ACTIONS(239),
    [anon_sym_SLASH] = ACTIONS(241),
    [anon_sym_STAR_STAR] = ACTIONS(243),
    [anon_sym_CARET] = ACTIONS(243),
    [aux_sym_binary_operator_token1] = ACTIONS(245),
    [anon_sym_PIPE_GT] = ACTIONS(245),
    [anon_sym_COLON] = ACTIONS(247),
    [anon_sym_DOLLAR] = ACTIONS(249),
    [anon_sym_AT] = ACTIONS(249),
    [aux_sym__hex_literal_token1] = ACTIONS(491),
    [sym__number_literal] = ACTIONS(493),
    [anon_sym_SQUOTE] = ACTIONS(491),
    [anon_sym_DQUOTE] = ACTIONS(491),
    [sym_return] = ACTIONS(493),
    [sym_next] = ACTIONS(493),
    [sym_break] = ACTIONS(493),
    [sym_true] = ACTIONS(493),
    [sym_false] = ACTIONS(493),
    [sym_null] = ACTIONS(493),
    [sym_inf] = ACTIONS(493),
    [sym_nan] = ACTIONS(493),
    [anon_sym_NA] = ACTIONS(493),
    [anon_sym_NA_integer_] = ACTIONS(493),
    [anon_sym_NA_real_] = ACTIONS(493),
    [anon_sym_NA_complex_] = ACTIONS(493),
    [anon_sym_NA_character_] = ACTIONS(493),
    [sym_dots] = ACTIONS(493),
    [sym_dot_dot_i] = ACTIONS(491),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(491),
    [sym__semicolon] = ACTIONS(491),
    [sym__raw_string_literal] = ACTIONS(491),
    [sym__external_else] = ACTIONS(491),
    [sym__external_open_parenthesis] = ACTIONS(253),
    [sym__external_open_brace] = ACTIONS(491),
    [sym__external_close_brace] = ACTIONS(491),
    [sym__external_open_bracket] = ACTIONS(255),
    [sym__external_open_bracket2] = ACTIONS(257),
  },
  [177] = {
    [sym_call_arguments] = STATE(850),
    [sym_subset_arguments] = STATE(851),
    [sym_subset2_arguments] = STATE(852),
    [sym__open_parenthesis] = STATE(349),
    [sym__open_bracket] = STATE(350),
    [sym__open_bracket2] = STATE(351),
    [sym_identifier] = ACTIONS(493),
    [anon_sym_BSLASH] = ACTIONS(491),
    [anon_sym_function] = ACTIONS(493),
    [anon_sym_EQ] = ACTIONS(493),
    [anon_sym_if] = ACTIONS(493),
    [anon_sym_for] = ACTIONS(493),
    [anon_sym_while] = ACTIONS(493),
    [anon_sym_repeat] = ACTIONS(493),
    [anon_sym_QMARK] = ACTIONS(491),
    [anon_sym_TILDE] = ACTIONS(491),
    [anon_sym_BANG] = ACTIONS(493),
    [anon_sym_PLUS] = ACTIONS(217),
    [anon_sym_DASH] = ACTIONS(219),
    [anon_sym_LT_DASH] = ACTIONS(491),
    [anon_sym_LT_LT_DASH] = ACTIONS(491),
    [anon_sym_COLON_EQ] = ACTIONS(491),
    [anon_sym_DASH_GT] = ACTIONS(493),
    [anon_sym_DASH_GT_GT] = ACTIONS(491),
    [anon_sym_PIPE] = ACTIONS(493),
    [anon_sym_AMP] = ACTIONS(493),
    [anon_sym_PIPE_PIPE] = ACTIONS(491),
    [anon_sym_AMP_AMP] = ACTIONS(491),
    [anon_sym_LT] = ACTIONS(235),
    [anon_sym_LT_EQ] = ACTIONS(237),
    [anon_sym_GT] = ACTIONS(235),
    [anon_sym_GT_EQ] = ACTIONS(237),
    [anon_sym_EQ_EQ] = ACTIONS(237),
    [anon_sym_BANG_EQ] = ACTIONS(237),
    [anon_sym_STAR] = ACTIONS(239),
    [anon_sym_SLASH] = ACTIONS(241),
    [anon_sym_STAR_STAR] = ACTIONS(243),
    [anon_sym_CARET] = ACTIONS(243),
    [aux_sym_binary_operator_token1] = ACTIONS(245),
    [anon_sym_PIPE_GT] = ACTIONS(245),
    [anon_sym_COLON] = ACTIONS(247),
    [anon_sym_DOLLAR] = ACTIONS(249),
    [anon_sym_AT] = ACTIONS(249),
    [aux_sym__hex_literal_token1] = ACTIONS(491),
    [sym__number_literal] = ACTIONS(493),
    [anon_sym_SQUOTE] = ACTIONS(491),
    [anon_sym_DQUOTE] = ACTIONS(491),
    [sym_return] = ACTIONS(493),
    [sym_next] = ACTIONS(493),
    [sym_break] = ACTIONS(493),
    [sym_true] = ACTIONS(493),
    [sym_false] = ACTIONS(493),
    [sym_null] = ACTIONS(493),
    [sym_inf] = ACTIONS(493),
    [sym_nan] = ACTIONS(493),
    [anon_sym_NA] = ACTIONS(493),
    [anon_sym_NA_integer_] = ACTIONS(493),
    [anon_sym_NA_real_] = ACTIONS(493),
    [anon_sym_NA_complex_] = ACTIONS(493),
    [anon_sym_NA_character_] = ACTIONS(493),
    [sym_dots] = ACTIONS(493),
    [sym_dot_dot_i] = ACTIONS(491),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(491),
    [sym__semicolon] = ACTIONS(491),
    [sym__raw_string_literal] = ACTIONS(491),
    [sym__external_else] = ACTIONS(491),
    [sym__external_open_parenthesis] = ACTIONS(253),
    [sym__external_open_brace] = ACTIONS(491),
    [sym__external_close_brace] = ACTIONS(491),
    [sym__external_open_bracket] = ACTIONS(255),
    [sym__external_open_bracket2] = ACTIONS(257),
  },
  [178] = {
    [sym_call_arguments] = STATE(850),
    [sym_subset_arguments] = STATE(851),
    [sym_subset2_arguments] = STATE(852),
    [sym__open_parenthesis] = STATE(349),
    [sym__open_bracket] = STATE(350),
    [sym__open_bracket2] = STATE(351),
    [sym_identifier] = ACTIONS(493),
    [anon_sym_BSLASH] = ACTIONS(491),
    [anon_sym_function] = ACTIONS(493),
    [anon_sym_EQ] = ACTIONS(493),
    [anon_sym_if] = ACTIONS(493),
    [anon_sym_for] = ACTIONS(493),
    [anon_sym_while] = ACTIONS(493),
    [anon_sym_repeat] = ACTIONS(493),
    [anon_sym_QMARK] = ACTIONS(491),
    [anon_sym_TILDE] = ACTIONS(491),
    [anon_sym_BANG] = ACTIONS(493),
    [anon_sym_PLUS] = ACTIONS(217),
    [anon_sym_DASH] = ACTIONS(219),
    [anon_sym_LT_DASH] = ACTIONS(491),
    [anon_sym_LT_LT_DASH] = ACTIONS(491),
    [anon_sym_COLON_EQ] = ACTIONS(491),
    [anon_sym_DASH_GT] = ACTIONS(493),
    [anon_sym_DASH_GT_GT] = ACTIONS(491),
    [anon_sym_PIPE] = ACTIONS(493),
    [anon_sym_AMP] = ACTIONS(493),
    [anon_sym_PIPE_PIPE] = ACTIONS(491),
    [anon_sym_AMP_AMP] = ACTIONS(491),
    [anon_sym_LT] = ACTIONS(493),
    [anon_sym_LT_EQ] = ACTIONS(491),
    [anon_sym_GT] = ACTIONS(493),
    [anon_sym_GT_EQ] = ACTIONS(491),
    [anon_sym_EQ_EQ] = ACTIONS(491),
    [anon_sym_BANG_EQ] = ACTIONS(491),
    [anon_sym_STAR] = ACTIONS(239),
    [anon_sym_SLASH] = ACTIONS(241),
    [anon_sym_STAR_STAR] = ACTIONS(243),
    [anon_sym_CARET] = ACTIONS(243),
    [aux_sym_binary_operator_token1] = ACTIONS(245),
    [anon_sym_PIPE_GT] = ACTIONS(245),
    [anon_sym_COLON] = ACTIONS(247),
    [anon_sym_DOLLAR] = ACTIONS(249),
    [anon_sym_AT] = ACTIONS(249),
    [aux_sym__hex_literal_token1] = ACTIONS(491),
    [sym__number_literal] = ACTIONS(493),
    [anon_sym_SQUOTE] = ACTIONS(491),
    [anon_sym_DQUOTE] = ACTIONS(491),
    [sym_return] = ACTIONS(493),
    [sym_next] = ACTIONS(493),
    [sym_break] = ACTIONS(493),
    [sym_true] = ACTIONS(493),
    [sym_false] = ACTIONS(493),
    [sym_null] = ACTIONS(493),
    [sym_inf] = ACTIONS(493),
    [sym_nan] = ACTIONS(493),
    [anon_sym_NA] = ACTIONS(493),
    [anon_sym_NA_integer_] = ACTIONS(493),
    [anon_sym_NA_real_] = ACTIONS(493),
    [anon_sym_NA_complex_] = ACTIONS(493),
    [anon_sym_NA_character_] = ACTIONS(493),
    [sym_dots] = ACTIONS(493),
    [sym_dot_dot_i] = ACTIONS(491),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(491),
    [sym__semicolon] = ACTIONS(491),
    [sym__raw_string_literal] = ACTIONS(491),
    [sym__external_else] = ACTIONS(491),
    [sym__external_open_parenthesis] = ACTIONS(253),
    [sym__external_open_brace] = ACTIONS(491),
    [sym__external_close_brace] = ACTIONS(491),
    [sym__external_open_bracket] = ACTIONS(255),
    [sym__external_open_bracket2] = ACTIONS(257),
  },
  [179] = {
    [sym_call_arguments] = STATE(850),
    [sym_subset_arguments] = STATE(851),
    [sym_subset2_arguments] = STATE(852),
    [sym__open_parenthesis] = STATE(349),
    [sym__open_bracket] = STATE(350),
    [sym__open_bracket2] = STATE(351),
    [sym_identifier] = ACTIONS(493),
    [anon_sym_BSLASH] = ACTIONS(491),
    [anon_sym_function] = ACTIONS(493),
    [anon_sym_EQ] = ACTIONS(493),
    [anon_sym_if] = ACTIONS(493),
    [anon_sym_for] = ACTIONS(493),
    [anon_sym_while] = ACTIONS(493),
    [anon_sym_repeat] = ACTIONS(493),
    [anon_sym_QMARK] = ACTIONS(491),
    [anon_sym_TILDE] = ACTIONS(491),
    [anon_sym_BANG] = ACTIONS(493),
    [anon_sym_PLUS] = ACTIONS(491),
    [anon_sym_DASH] = ACTIONS(493),
    [anon_sym_LT_DASH] = ACTIONS(491),
    [anon_sym_LT_LT_DASH] = ACTIONS(491),
    [anon_sym_COLON_EQ] = ACTIONS(491),
    [anon_sym_DASH_GT] = ACTIONS(493),
    [anon_sym_DASH_GT_GT] = ACTIONS(491),
    [anon_sym_PIPE] = ACTIONS(493),
    [anon_sym_AMP] = ACTIONS(493),
    [anon_sym_PIPE_PIPE] = ACTIONS(491),
    [anon_sym_AMP_AMP] = ACTIONS(491),
    [anon_sym_LT] = ACTIONS(493),
    [anon_sym_LT_EQ] = ACTIONS(491),
    [anon_sym_GT] = ACTIONS(493),
    [anon_sym_GT_EQ] = ACTIONS(491),
    [anon_sym_EQ_EQ] = ACTIONS(491),
    [anon_sym_BANG_EQ] = ACTIONS(491),
    [anon_sym_STAR] = ACTIONS(493),
    [anon_sym_SLASH] = ACTIONS(491),
    [anon_sym_STAR_STAR] = ACTIONS(243),
    [anon_sym_CARET] = ACTIONS(243),
    [aux_sym_binary_operator_token1] = ACTIONS(245),
    [anon_sym_PIPE_GT] = ACTIONS(245),
    [anon_sym_COLON] = ACTIONS(247),
    [anon_sym_DOLLAR] = ACTIONS(249),
    [anon_sym_AT] = ACTIONS(249),
    [aux_sym__hex_literal_token1] = ACTIONS(491),
    [sym__number_literal] = ACTIONS(493),
    [anon_sym_SQUOTE] = ACTIONS(491),
    [anon_sym_DQUOTE] = ACTIONS(491),
    [sym_return] = ACTIONS(493),
    [sym_next] = ACTIONS(493),
    [sym_break] = ACTIONS(493),
    [sym_true] = ACTIONS(493),
    [sym_false] = ACTIONS(493),
    [sym_null] = ACTIONS(493),
    [sym_inf] = ACTIONS(493),
    [sym_nan] = ACTIONS(493),
    [anon_sym_NA] = ACTIONS(493),
    [anon_sym_NA_integer_] = ACTIONS(493),
    [anon_sym_NA_real_] = ACTIONS(493),
    [anon_sym_NA_complex_] = ACTIONS(493),
    [anon_sym_NA_character_] = ACTIONS(493),
    [sym_dots] = ACTIONS(493),
    [sym_dot_dot_i] = ACTIONS(491),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(491),
    [sym__semicolon] = ACTIONS(491),
    [sym__raw_string_literal] = ACTIONS(491),
    [sym__external_else] = ACTIONS(491),
    [sym__external_open_parenthesis] = ACTIONS(253),
    [sym__external_open_brace] = ACTIONS(491),
    [sym__external_close_brace] = ACTIONS(491),
    [sym__external_open_bracket] = ACTIONS(255),
    [sym__external_open_bracket2] = ACTIONS(257),
  },
  [180] = {
    [sym_call_arguments] = STATE(850),
    [sym_subset_arguments] = STATE(851),
    [sym_subset2_arguments] = STATE(852),
    [sym__open_parenthesis] = STATE(349),
    [sym__open_bracket] = STATE(350),
    [sym__open_bracket2] = STATE(351),
    [sym_identifier] = ACTIONS(493),
    [anon_sym_BSLASH] = ACTIONS(491),
    [anon_sym_function] = ACTIONS(493),
    [anon_sym_EQ] = ACTIONS(493),
    [anon_sym_if] = ACTIONS(493),
    [anon_sym_for] = ACTIONS(493),
    [anon_sym_while] = ACTIONS(493),
    [anon_sym_repeat] = ACTIONS(493),
    [anon_sym_QMARK] = ACTIONS(491),
    [anon_sym_TILDE] = ACTIONS(491),
    [anon_sym_BANG] = ACTIONS(493),
    [anon_sym_PLUS] = ACTIONS(491),
    [anon_sym_DASH] = ACTIONS(493),
    [anon_sym_LT_DASH] = ACTIONS(491),
    [anon_sym_LT_LT_DASH] = ACTIONS(491),
    [anon_sym_COLON_EQ] = ACTIONS(491),
    [anon_sym_DASH_GT] = ACTIONS(493),
    [anon_sym_DASH_GT_GT] = ACTIONS(491),
    [anon_sym_PIPE] = ACTIONS(493),
    [anon_sym_AMP] = ACTIONS(493),
    [anon_sym_PIPE_PIPE] = ACTIONS(491),
    [anon_sym_AMP_AMP] = ACTIONS(491),
    [anon_sym_LT] = ACTIONS(493),
    [anon_sym_LT_EQ] = ACTIONS(491),
    [anon_sym_GT] = ACTIONS(493),
    [anon_sym_GT_EQ] = ACTIONS(491),
    [anon_sym_EQ_EQ] = ACTIONS(491),
    [anon_sym_BANG_EQ] = ACTIONS(491),
    [anon_sym_STAR] = ACTIONS(493),
    [anon_sym_SLASH] = ACTIONS(491),
    [anon_sym_STAR_STAR] = ACTIONS(243),
    [anon_sym_CARET] = ACTIONS(243),
    [aux_sym_binary_operator_token1] = ACTIONS(491),
    [anon_sym_PIPE_GT] = ACTIONS(491),
    [anon_sym_COLON] = ACTIONS(493),
    [anon_sym_DOLLAR] = ACTIONS(249),
    [anon_sym_AT] = ACTIONS(249),
    [aux_sym__hex_literal_token1] = ACTIONS(491),
    [sym__number_literal] = ACTIONS(493),
    [anon_sym_SQUOTE] = ACTIONS(491),
    [anon_sym_DQUOTE] = ACTIONS(491),
    [sym_return] = ACTIONS(493),
    [sym_next] = ACTIONS(493),
    [sym_break] = ACTIONS(493),
    [sym_true] = ACTIONS(493),
    [sym_false] = ACTIONS(493),
    [sym_null] = ACTIONS(493),
    [sym_inf] = ACTIONS(493),
    [sym_nan] = ACTIONS(493),
    [anon_sym_NA] = ACTIONS(493),
    [anon_sym_NA_integer_] = ACTIONS(493),
    [anon_sym_NA_real_] = ACTIONS(493),
    [anon_sym_NA_complex_] = ACTIONS(493),
    [anon_sym_NA_character_] = ACTIONS(493),
    [sym_dots] = ACTIONS(493),
    [sym_dot_dot_i] = ACTIONS(491),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(491),
    [sym__semicolon] = ACTIONS(491),
    [sym__raw_string_literal] = ACTIONS(491),
    [sym__external_else] = ACTIONS(491),
    [sym__external_open_parenthesis] = ACTIONS(253),
    [sym__external_open_brace] = ACTIONS(491),
    [sym__external_close_brace] = ACTIONS(491),
    [sym__external_open_bracket] = ACTIONS(255),
    [sym__external_open_bracket2] = ACTIONS(257),
  },
  [181] = {
    [sym_call_arguments] = STATE(850),
    [sym_subset_arguments] = STATE(851),
    [sym_subset2_arguments] = STATE(852),
    [sym__open_parenthesis] = STATE(349),
    [sym__open_bracket] = STATE(350),
    [sym__open_bracket2] = STATE(351),
    [sym_identifier] = ACTIONS(493),
    [anon_sym_BSLASH] = ACTIONS(491),
    [anon_sym_function] = ACTIONS(493),
    [anon_sym_EQ] = ACTIONS(493),
    [anon_sym_if] = ACTIONS(493),
    [anon_sym_for] = ACTIONS(493),
    [anon_sym_while] = ACTIONS(493),
    [anon_sym_repeat] = ACTIONS(493),
    [anon_sym_QMARK] = ACTIONS(491),
    [anon_sym_TILDE] = ACTIONS(491),
    [anon_sym_BANG] = ACTIONS(493),
    [anon_sym_PLUS] = ACTIONS(491),
    [anon_sym_DASH] = ACTIONS(493),
    [anon_sym_LT_DASH] = ACTIONS(491),
    [anon_sym_LT_LT_DASH] = ACTIONS(491),
    [anon_sym_COLON_EQ] = ACTIONS(491),
    [anon_sym_DASH_GT] = ACTIONS(493),
    [anon_sym_DASH_GT_GT] = ACTIONS(491),
    [anon_sym_PIPE] = ACTIONS(493),
    [anon_sym_AMP] = ACTIONS(493),
    [anon_sym_PIPE_PIPE] = ACTIONS(491),
    [anon_sym_AMP_AMP] = ACTIONS(491),
    [anon_sym_LT] = ACTIONS(493),
    [anon_sym_LT_EQ] = ACTIONS(491),
    [anon_sym_GT] = ACTIONS(493),
    [anon_sym_GT_EQ] = ACTIONS(491),
    [anon_sym_EQ_EQ] = ACTIONS(491),
    [anon_sym_BANG_EQ] = ACTIONS(491),
    [anon_sym_STAR] = ACTIONS(493),
    [anon_sym_SLASH] = ACTIONS(491),
    [anon_sym_STAR_STAR] = ACTIONS(243),
    [anon_sym_CARET] = ACTIONS(243),
    [aux_sym_binary_operator_token1] = ACTIONS(491),
    [anon_sym_PIPE_GT] = ACTIONS(491),
    [anon_sym_COLON] = ACTIONS(247),
    [anon_sym_DOLLAR] = ACTIONS(249),
    [anon_sym_AT] = ACTIONS(249),
    [aux_sym__hex_literal_token1] = ACTIONS(491),
    [sym__number_literal] = ACTIONS(493),
    [anon_sym_SQUOTE] = ACTIONS(491),
    [anon_sym_DQUOTE] = ACTIONS(491),
    [sym_return] = ACTIONS(493),
    [sym_next] = ACTIONS(493),
    [sym_break] = ACTIONS(493),
    [sym_true] = ACTIONS(493),
    [sym_false] = ACTIONS(493),
    [sym_null] = ACTIONS(493),
    [sym_inf] = ACTIONS(493),
    [sym_nan] = ACTIONS(493),
    [anon_sym_NA] = ACTIONS(493),
    [anon_sym_NA_integer_] = ACTIONS(493),
    [anon_sym_NA_real_] = ACTIONS(493),
    [anon_sym_NA_complex_] = ACTIONS(493),
    [anon_sym_NA_character_] = ACTIONS(493),
    [sym_dots] = ACTIONS(493),
    [sym_dot_dot_i] = ACTIONS(491),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(491),
    [sym__semicolon] = ACTIONS(491),
    [sym__raw_string_literal] = ACTIONS(491),
    [sym__external_else] = ACTIONS(491),
    [sym__external_open_parenthesis] = ACTIONS(253),
    [sym__external_open_brace] = ACTIONS(491),
    [sym__external_close_brace] = ACTIONS(491),
    [sym__external_open_bracket] = ACTIONS(255),
    [sym__external_open_bracket2] = ACTIONS(257),
  },
  [182] = {
    [sym_call_arguments] = STATE(850),
    [sym_subset_arguments] = STATE(851),
    [sym_subset2_arguments] = STATE(852),
    [sym__open_parenthesis] = STATE(349),
    [sym__open_bracket] = STATE(350),
    [sym__open_bracket2] = STATE(351),
    [sym_identifier] = ACTIONS(493),
    [anon_sym_BSLASH] = ACTIONS(491),
    [anon_sym_function] = ACTIONS(493),
    [anon_sym_EQ] = ACTIONS(493),
    [anon_sym_if] = ACTIONS(493),
    [anon_sym_for] = ACTIONS(493),
    [anon_sym_while] = ACTIONS(493),
    [anon_sym_repeat] = ACTIONS(493),
    [anon_sym_QMARK] = ACTIONS(491),
    [anon_sym_TILDE] = ACTIONS(491),
    [anon_sym_BANG] = ACTIONS(493),
    [anon_sym_PLUS] = ACTIONS(491),
    [anon_sym_DASH] = ACTIONS(493),
    [anon_sym_LT_DASH] = ACTIONS(491),
    [anon_sym_LT_LT_DASH] = ACTIONS(491),
    [anon_sym_COLON_EQ] = ACTIONS(491),
    [anon_sym_DASH_GT] = ACTIONS(493),
    [anon_sym_DASH_GT_GT] = ACTIONS(491),
    [anon_sym_PIPE] = ACTIONS(493),
    [anon_sym_AMP] = ACTIONS(493),
    [anon_sym_PIPE_PIPE] = ACTIONS(491),
    [anon_sym_AMP_AMP] = ACTIONS(491),
    [anon_sym_LT] = ACTIONS(493),
    [anon_sym_LT_EQ] = ACTIONS(491),
    [anon_sym_GT] = ACTIONS(493),
    [anon_sym_GT_EQ] = ACTIONS(491),
    [anon_sym_EQ_EQ] = ACTIONS(491),
    [anon_sym_BANG_EQ] = ACTIONS(491),
    [anon_sym_STAR] = ACTIONS(493),
    [anon_sym_SLASH] = ACTIONS(491),
    [anon_sym_STAR_STAR] = ACTIONS(243),
    [anon_sym_CARET] = ACTIONS(243),
    [aux_sym_binary_operator_token1] = ACTIONS(491),
    [anon_sym_PIPE_GT] = ACTIONS(491),
    [anon_sym_COLON] = ACTIONS(493),
    [anon_sym_DOLLAR] = ACTIONS(249),
    [anon_sym_AT] = ACTIONS(249),
    [aux_sym__hex_literal_token1] = ACTIONS(491),
    [sym__number_literal] = ACTIONS(493),
    [anon_sym_SQUOTE] = ACTIONS(491),
    [anon_sym_DQUOTE] = ACTIONS(491),
    [sym_return] = ACTIONS(493),
    [sym_next] = ACTIONS(493),
    [sym_break] = ACTIONS(493),
    [sym_true] = ACTIONS(493),
    [sym_false] = ACTIONS(493),
    [sym_null] = ACTIONS(493),
    [sym_inf] = ACTIONS(493),
    [sym_nan] = ACTIONS(493),
    [anon_sym_NA] = ACTIONS(493),
    [anon_sym_NA_integer_] = ACTIONS(493),
    [anon_sym_NA_real_] = ACTIONS(493),
    [anon_sym_NA_complex_] = ACTIONS(493),
    [anon_sym_NA_character_] = ACTIONS(493),
    [sym_dots] = ACTIONS(493),
    [sym_dot_dot_i] = ACTIONS(491),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(491),
    [sym__semicolon] = ACTIONS(491),
    [sym__raw_string_literal] = ACTIONS(491),
    [sym__external_else] = ACTIONS(491),
    [sym__external_open_parenthesis] = ACTIONS(253),
    [sym__external_open_brace] = ACTIONS(491),
    [sym__external_close_brace] = ACTIONS(491),
    [sym__external_open_bracket] = ACTIONS(255),
    [sym__external_open_bracket2] = ACTIONS(257),
  },
  [183] = {
    [sym_call_arguments] = STATE(850),
    [sym_subset_arguments] = STATE(851),
    [sym_subset2_arguments] = STATE(852),
    [sym__open_parenthesis] = STATE(349),
    [sym__open_bracket] = STATE(350),
    [sym__open_bracket2] = STATE(351),
    [sym_identifier] = ACTIONS(497),
    [anon_sym_BSLASH] = ACTIONS(495),
    [anon_sym_function] = ACTIONS(497),
    [anon_sym_EQ] = ACTIONS(213),
    [anon_sym_if] = ACTIONS(497),
    [anon_sym_for] = ACTIONS(497),
    [anon_sym_while] = ACTIONS(497),
    [anon_sym_repeat] = ACTIONS(497),
    [anon_sym_QMARK] = ACTIONS(495),
    [anon_sym_TILDE] = ACTIONS(215),
    [anon_sym_BANG] = ACTIONS(497),
    [anon_sym_PLUS] = ACTIONS(217),
    [anon_sym_DASH] = ACTIONS(219),
    [anon_sym_LT_DASH] = ACTIONS(221),
    [anon_sym_LT_LT_DASH] = ACTIONS(221),
    [anon_sym_COLON_EQ] = ACTIONS(221),
    [anon_sym_DASH_GT] = ACTIONS(223),
    [anon_sym_DASH_GT_GT] = ACTIONS(225),
    [anon_sym_PIPE] = ACTIONS(227),
    [anon_sym_AMP] = ACTIONS(229),
    [anon_sym_PIPE_PIPE] = ACTIONS(231),
    [anon_sym_AMP_AMP] = ACTIONS(233),
    [anon_sym_LT] = ACTIONS(235),
    [anon_sym_LT_EQ] = ACTIONS(237),
    [anon_sym_GT] = ACTIONS(235),
    [anon_sym_GT_EQ] = ACTIONS(237),
    [anon_sym_EQ_EQ] = ACTIONS(237),
    [anon_sym_BANG_EQ] = ACTIONS(237),
    [anon_sym_STAR] = ACTIONS(239),
    [anon_sym_SLASH] = ACTIONS(241),
    [anon_sym_STAR_STAR] = ACTIONS(243),
    [anon_sym_CARET] = ACTIONS(243),
    [aux_sym_binary_operator_token1] = ACTIONS(245),
    [anon_sym_PIPE_GT] = ACTIONS(245),
    [anon_sym_COLON] = ACTIONS(247),
    [anon_sym_DOLLAR] = ACTIONS(249),
    [anon_sym_AT] = ACTIONS(249),
    [aux_sym__hex_literal_token1] = ACTIONS(495),
    [sym__number_literal] = ACTIONS(497),
    [anon_sym_SQUOTE] = ACTIONS(495),
    [anon_sym_DQUOTE] = ACTIONS(495),
    [sym_return] = ACTIONS(497),
    [sym_next] = ACTIONS(497),
    [sym_break] = ACTIONS(497),
    [sym_true] = ACTIONS(497),
    [sym_false] = ACTIONS(497),
    [sym_null] = ACTIONS(497),
    [sym_inf] = ACTIONS(497),
    [sym_nan] = ACTIONS(497),
    [anon_sym_NA] = ACTIONS(497),
    [anon_sym_NA_integer_] = ACTIONS(497),
    [anon_sym_NA_real_] = ACTIONS(497),
    [anon_sym_NA_complex_] = ACTIONS(497),
    [anon_sym_NA_character_] = ACTIONS(497),
    [sym_dots] = ACTIONS(497),
    [sym_dot_dot_i] = ACTIONS(495),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(495),
    [sym__semicolon] = ACTIONS(495),
    [sym__raw_string_literal] = ACTIONS(495),
    [sym__external_else] = ACTIONS(495),
    [sym__external_open_parenthesis] = ACTIONS(253),
    [sym__external_open_brace] = ACTIONS(495),
    [sym__external_close_brace] = ACTIONS(495),
    [sym__external_open_bracket] = ACTIONS(255),
    [sym__external_open_bracket2] = ACTIONS(257),
  },
  [184] = {
    [sym_call_arguments] = STATE(850),
    [sym_subset_arguments] = STATE(851),
    [sym_subset2_arguments] = STATE(852),
    [sym__open_parenthesis] = STATE(349),
    [sym__open_bracket] = STATE(350),
    [sym__open_bracket2] = STATE(351),
    [sym_identifier] = ACTIONS(501),
    [anon_sym_BSLASH] = ACTIONS(499),
    [anon_sym_function] = ACTIONS(501),
    [anon_sym_EQ] = ACTIONS(213),
    [anon_sym_if] = ACTIONS(501),
    [anon_sym_for] = ACTIONS(501),
    [anon_sym_while] = ACTIONS(501),
    [anon_sym_repeat] = ACTIONS(501),
    [anon_sym_QMARK] = ACTIONS(499),
    [anon_sym_TILDE] = ACTIONS(215),
    [anon_sym_BANG] = ACTIONS(501),
    [anon_sym_PLUS] = ACTIONS(217),
    [anon_sym_DASH] = ACTIONS(219),
    [anon_sym_LT_DASH] = ACTIONS(221),
    [anon_sym_LT_LT_DASH] = ACTIONS(221),
    [anon_sym_COLON_EQ] = ACTIONS(221),
    [anon_sym_DASH_GT] = ACTIONS(223),
    [anon_sym_DASH_GT_GT] = ACTIONS(225),
    [anon_sym_PIPE] = ACTIONS(227),
    [anon_sym_AMP] = ACTIONS(229),
    [anon_sym_PIPE_PIPE] = ACTIONS(231),
    [anon_sym_AMP_AMP] = ACTIONS(233),
    [anon_sym_LT] = ACTIONS(235),
    [anon_sym_LT_EQ] = ACTIONS(237),
    [anon_sym_GT] = ACTIONS(235),
    [anon_sym_GT_EQ] = ACTIONS(237),
    [anon_sym_EQ_EQ] = ACTIONS(237),
    [anon_sym_BANG_EQ] = ACTIONS(237),
    [anon_sym_STAR] = ACTIONS(239),
    [anon_sym_SLASH] = ACTIONS(241),
    [anon_sym_STAR_STAR] = ACTIONS(243),
    [anon_sym_CARET] = ACTIONS(243),
    [aux_sym_binary_operator_token1] = ACTIONS(245),
    [anon_sym_PIPE_GT] = ACTIONS(245),
    [anon_sym_COLON] = ACTIONS(247),
    [anon_sym_DOLLAR] = ACTIONS(249),
    [anon_sym_AT] = ACTIONS(249),
    [aux_sym__hex_literal_token1] = ACTIONS(499),
    [sym__number_literal] = ACTIONS(501),
    [anon_sym_SQUOTE] = ACTIONS(499),
    [anon_sym_DQUOTE] = ACTIONS(499),
    [sym_return] = ACTIONS(501),
    [sym_next] = ACTIONS(501),
    [sym_break] = ACTIONS(501),
    [sym_true] = ACTIONS(501),
    [sym_false] = ACTIONS(501),
    [sym_null] = ACTIONS(501),
    [sym_inf] = ACTIONS(501),
    [sym_nan] = ACTIONS(501),
    [anon_sym_NA] = ACTIONS(501),
    [anon_sym_NA_integer_] = ACTIONS(501),
    [anon_sym_NA_real_] = ACTIONS(501),
    [anon_sym_NA_complex_] = ACTIONS(501),
    [anon_sym_NA_character_] = ACTIONS(501),
    [sym_dots] = ACTIONS(501),
    [sym_dot_dot_i] = ACTIONS(499),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(499),
    [sym__semicolon] = ACTIONS(499),
    [sym__raw_string_literal] = ACTIONS(499),
    [sym__external_else] = ACTIONS(499),
    [sym__external_open_parenthesis] = ACTIONS(253),
    [sym__external_open_brace] = ACTIONS(499),
    [sym__external_close_brace] = ACTIONS(499),
    [sym__external_open_bracket] = ACTIONS(255),
    [sym__external_open_bracket2] = ACTIONS(257),
  },
  [185] = {
    [sym_call_arguments] = STATE(850),
    [sym_subset_arguments] = STATE(851),
    [sym_subset2_arguments] = STATE(852),
    [sym__open_parenthesis] = STATE(349),
    [sym__open_bracket] = STATE(350),
    [sym__open_bracket2] = STATE(351),
    [sym_identifier] = ACTIONS(505),
    [anon_sym_BSLASH] = ACTIONS(503),
    [anon_sym_function] = ACTIONS(505),
    [anon_sym_EQ] = ACTIONS(213),
    [anon_sym_if] = ACTIONS(505),
    [anon_sym_for] = ACTIONS(505),
    [anon_sym_while] = ACTIONS(505),
    [anon_sym_repeat] = ACTIONS(505),
    [anon_sym_QMARK] = ACTIONS(503),
    [anon_sym_TILDE] = ACTIONS(215),
    [anon_sym_BANG] = ACTIONS(505),
    [anon_sym_PLUS] = ACTIONS(217),
    [anon_sym_DASH] = ACTIONS(219),
    [anon_sym_LT_DASH] = ACTIONS(221),
    [anon_sym_LT_LT_DASH] = ACTIONS(221),
    [anon_sym_COLON_EQ] = ACTIONS(221),
    [anon_sym_DASH_GT] = ACTIONS(223),
    [anon_sym_DASH_GT_GT] = ACTIONS(225),
    [anon_sym_PIPE] = ACTIONS(227),
    [anon_sym_AMP] = ACTIONS(229),
    [anon_sym_PIPE_PIPE] = ACTIONS(231),
    [anon_sym_AMP_AMP] = ACTIONS(233),
    [anon_sym_LT] = ACTIONS(235),
    [anon_sym_LT_EQ] = ACTIONS(237),
    [anon_sym_GT] = ACTIONS(235),
    [anon_sym_GT_EQ] = ACTIONS(237),
    [anon_sym_EQ_EQ] = ACTIONS(237),
    [anon_sym_BANG_EQ] = ACTIONS(237),
    [anon_sym_STAR] = ACTIONS(239),
    [anon_sym_SLASH] = ACTIONS(241),
    [anon_sym_STAR_STAR] = ACTIONS(243),
    [anon_sym_CARET] = ACTIONS(243),
    [aux_sym_binary_operator_token1] = ACTIONS(245),
    [anon_sym_PIPE_GT] = ACTIONS(245),
    [anon_sym_COLON] = ACTIONS(247),
    [anon_sym_DOLLAR] = ACTIONS(249),
    [anon_sym_AT] = ACTIONS(249),
    [aux_sym__hex_literal_token1] = ACTIONS(503),
    [sym__number_literal] = ACTIONS(505),
    [anon_sym_SQUOTE] = ACTIONS(503),
    [anon_sym_DQUOTE] = ACTIONS(503),
    [sym_return] = ACTIONS(505),
    [sym_next] = ACTIONS(505),
    [sym_break] = ACTIONS(505),
    [sym_true] = ACTIONS(505),
    [sym_false] = ACTIONS(505),
    [sym_null] = ACTIONS(505),
    [sym_inf] = ACTIONS(505),
    [sym_nan] = ACTIONS(505),
    [anon_sym_NA] = ACTIONS(505),
    [anon_sym_NA_integer_] = ACTIONS(505),
    [anon_sym_NA_real_] = ACTIONS(505),
    [anon_sym_NA_complex_] = ACTIONS(505),
    [anon_sym_NA_character_] = ACTIONS(505),
    [sym_dots] = ACTIONS(505),
    [sym_dot_dot_i] = ACTIONS(503),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(503),
    [sym__semicolon] = ACTIONS(503),
    [sym__raw_string_literal] = ACTIONS(503),
    [sym__external_else] = ACTIONS(503),
    [sym__external_open_parenthesis] = ACTIONS(253),
    [sym__external_open_brace] = ACTIONS(503),
    [sym__external_close_brace] = ACTIONS(503),
    [sym__external_open_bracket] = ACTIONS(255),
    [sym__external_open_bracket2] = ACTIONS(257),
  },
  [186] = {
    [sym_call_arguments] = STATE(850),
    [sym_subset_arguments] = STATE(851),
    [sym_subset2_arguments] = STATE(852),
    [sym__open_parenthesis] = STATE(349),
    [sym__open_bracket] = STATE(350),
    [sym__open_bracket2] = STATE(351),
    [sym_identifier] = ACTIONS(509),
    [anon_sym_BSLASH] = ACTIONS(507),
    [anon_sym_function] = ACTIONS(509),
    [anon_sym_EQ] = ACTIONS(213),
    [anon_sym_if] = ACTIONS(509),
    [anon_sym_for] = ACTIONS(509),
    [anon_sym_while] = ACTIONS(509),
    [anon_sym_repeat] = ACTIONS(509),
    [anon_sym_QMARK] = ACTIONS(507),
    [anon_sym_TILDE] = ACTIONS(215),
    [anon_sym_BANG] = ACTIONS(509),
    [anon_sym_PLUS] = ACTIONS(217),
    [anon_sym_DASH] = ACTIONS(219),
    [anon_sym_LT_DASH] = ACTIONS(221),
    [anon_sym_LT_LT_DASH] = ACTIONS(221),
    [anon_sym_COLON_EQ] = ACTIONS(221),
    [anon_sym_DASH_GT] = ACTIONS(223),
    [anon_sym_DASH_GT_GT] = ACTIONS(225),
    [anon_sym_PIPE] = ACTIONS(227),
    [anon_sym_AMP] = ACTIONS(229),
    [anon_sym_PIPE_PIPE] = ACTIONS(231),
    [anon_sym_AMP_AMP] = ACTIONS(233),
    [anon_sym_LT] = ACTIONS(235),
    [anon_sym_LT_EQ] = ACTIONS(237),
    [anon_sym_GT] = ACTIONS(235),
    [anon_sym_GT_EQ] = ACTIONS(237),
    [anon_sym_EQ_EQ] = ACTIONS(237),
    [anon_sym_BANG_EQ] = ACTIONS(237),
    [anon_sym_STAR] = ACTIONS(239),
    [anon_sym_SLASH] = ACTIONS(241),
    [anon_sym_STAR_STAR] = ACTIONS(243),
    [anon_sym_CARET] = ACTIONS(243),
    [aux_sym_binary_operator_token1] = ACTIONS(245),
    [anon_sym_PIPE_GT] = ACTIONS(245),
    [anon_sym_COLON] = ACTIONS(247),
    [anon_sym_DOLLAR] = ACTIONS(249),
    [anon_sym_AT] = ACTIONS(249),
    [aux_sym__hex_literal_token1] = ACTIONS(507),
    [sym__number_literal] = ACTIONS(509),
    [anon_sym_SQUOTE] = ACTIONS(507),
    [anon_sym_DQUOTE] = ACTIONS(507),
    [sym_return] = ACTIONS(509),
    [sym_next] = ACTIONS(509),
    [sym_break] = ACTIONS(509),
    [sym_true] = ACTIONS(509),
    [sym_false] = ACTIONS(509),
    [sym_null] = ACTIONS(509),
    [sym_inf] = ACTIONS(509),
    [sym_nan] = ACTIONS(509),
    [anon_sym_NA] = ACTIONS(509),
    [anon_sym_NA_integer_] = ACTIONS(509),
    [anon_sym_NA_real_] = ACTIONS(509),
    [anon_sym_NA_complex_] = ACTIONS(509),
    [anon_sym_NA_character_] = ACTIONS(509),
    [sym_dots] = ACTIONS(509),
    [sym_dot_dot_i] = ACTIONS(507),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(507),
    [sym__semicolon] = ACTIONS(507),
    [sym__raw_string_literal] = ACTIONS(507),
    [sym__external_else] = ACTIONS(507),
    [sym__external_open_parenthesis] = ACTIONS(253),
    [sym__external_open_brace] = ACTIONS(507),
    [sym__external_close_brace] = ACTIONS(507),
    [sym__external_open_bracket] = ACTIONS(255),
    [sym__external_open_bracket2] = ACTIONS(257),
  },
  [187] = {
    [sym_call_arguments] = STATE(850),
    [sym_subset_arguments] = STATE(851),
    [sym_subset2_arguments] = STATE(852),
    [sym__open_parenthesis] = STATE(349),
    [sym__open_bracket] = STATE(350),
    [sym__open_bracket2] = STATE(351),
    [sym_identifier] = ACTIONS(513),
    [anon_sym_BSLASH] = ACTIONS(511),
    [anon_sym_function] = ACTIONS(513),
    [anon_sym_EQ] = ACTIONS(213),
    [anon_sym_if] = ACTIONS(513),
    [anon_sym_for] = ACTIONS(513),
    [anon_sym_while] = ACTIONS(513),
    [anon_sym_repeat] = ACTIONS(513),
    [anon_sym_QMARK] = ACTIONS(511),
    [anon_sym_TILDE] = ACTIONS(215),
    [anon_sym_BANG] = ACTIONS(513),
    [anon_sym_PLUS] = ACTIONS(217),
    [anon_sym_DASH] = ACTIONS(219),
    [anon_sym_LT_DASH] = ACTIONS(221),
    [anon_sym_LT_LT_DASH] = ACTIONS(221),
    [anon_sym_COLON_EQ] = ACTIONS(221),
    [anon_sym_DASH_GT] = ACTIONS(223),
    [anon_sym_DASH_GT_GT] = ACTIONS(225),
    [anon_sym_PIPE] = ACTIONS(227),
    [anon_sym_AMP] = ACTIONS(229),
    [anon_sym_PIPE_PIPE] = ACTIONS(231),
    [anon_sym_AMP_AMP] = ACTIONS(233),
    [anon_sym_LT] = ACTIONS(235),
    [anon_sym_LT_EQ] = ACTIONS(237),
    [anon_sym_GT] = ACTIONS(235),
    [anon_sym_GT_EQ] = ACTIONS(237),
    [anon_sym_EQ_EQ] = ACTIONS(237),
    [anon_sym_BANG_EQ] = ACTIONS(237),
    [anon_sym_STAR] = ACTIONS(239),
    [anon_sym_SLASH] = ACTIONS(241),
    [anon_sym_STAR_STAR] = ACTIONS(243),
    [anon_sym_CARET] = ACTIONS(243),
    [aux_sym_binary_operator_token1] = ACTIONS(245),
    [anon_sym_PIPE_GT] = ACTIONS(245),
    [anon_sym_COLON] = ACTIONS(247),
    [anon_sym_DOLLAR] = ACTIONS(249),
    [anon_sym_AT] = ACTIONS(249),
    [aux_sym__hex_literal_token1] = ACTIONS(511),
    [sym__number_literal] = ACTIONS(513),
    [anon_sym_SQUOTE] = ACTIONS(511),
    [anon_sym_DQUOTE] = ACTIONS(511),
    [sym_return] = ACTIONS(513),
    [sym_next] = ACTIONS(513),
    [sym_break] = ACTIONS(513),
    [sym_true] = ACTIONS(513),
    [sym_false] = ACTIONS(513),
    [sym_null] = ACTIONS(513),
    [sym_inf] = ACTIONS(513),
    [sym_nan] = ACTIONS(513),
    [anon_sym_NA] = ACTIONS(513),
    [anon_sym_NA_integer_] = ACTIONS(513),
    [anon_sym_NA_real_] = ACTIONS(513),
    [anon_sym_NA_complex_] = ACTIONS(513),
    [anon_sym_NA_character_] = ACTIONS(513),
    [sym_dots] = ACTIONS(513),
    [sym_dot_dot_i] = ACTIONS(511),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(511),
    [sym__semicolon] = ACTIONS(511),
    [sym__raw_string_literal] = ACTIONS(511),
    [sym__external_else] = ACTIONS(511),
    [sym__external_open_parenthesis] = ACTIONS(253),
    [sym__external_open_brace] = ACTIONS(511),
    [sym__external_close_brace] = ACTIONS(511),
    [sym__external_open_bracket] = ACTIONS(255),
    [sym__external_open_bracket2] = ACTIONS(257),
  },
  [188] = {
    [sym_call_arguments] = STATE(850),
    [sym_subset_arguments] = STATE(851),
    [sym_subset2_arguments] = STATE(852),
    [sym__open_parenthesis] = STATE(349),
    [sym__open_bracket] = STATE(350),
    [sym__open_bracket2] = STATE(351),
    [sym_identifier] = ACTIONS(517),
    [anon_sym_BSLASH] = ACTIONS(515),
    [anon_sym_function] = ACTIONS(517),
    [anon_sym_EQ] = ACTIONS(213),
    [anon_sym_if] = ACTIONS(517),
    [anon_sym_for] = ACTIONS(517),
    [anon_sym_while] = ACTIONS(517),
    [anon_sym_repeat] = ACTIONS(517),
    [anon_sym_QMARK] = ACTIONS(515),
    [anon_sym_TILDE] = ACTIONS(215),
    [anon_sym_BANG] = ACTIONS(517),
    [anon_sym_PLUS] = ACTIONS(217),
    [anon_sym_DASH] = ACTIONS(219),
    [anon_sym_LT_DASH] = ACTIONS(221),
    [anon_sym_LT_LT_DASH] = ACTIONS(221),
    [anon_sym_COLON_EQ] = ACTIONS(221),
    [anon_sym_DASH_GT] = ACTIONS(223),
    [anon_sym_DASH_GT_GT] = ACTIONS(225),
    [anon_sym_PIPE] = ACTIONS(227),
    [anon_sym_AMP] = ACTIONS(229),
    [anon_sym_PIPE_PIPE] = ACTIONS(231),
    [anon_sym_AMP_AMP] = ACTIONS(233),
    [anon_sym_LT] = ACTIONS(235),
    [anon_sym_LT_EQ] = ACTIONS(237),
    [anon_sym_GT] = ACTIONS(235),
    [anon_sym_GT_EQ] = ACTIONS(237),
    [anon_sym_EQ_EQ] = ACTIONS(237),
    [anon_sym_BANG_EQ] = ACTIONS(237),
    [anon_sym_STAR] = ACTIONS(239),
    [anon_sym_SLASH] = ACTIONS(241),
    [anon_sym_STAR_STAR] = ACTIONS(243),
    [anon_sym_CARET] = ACTIONS(243),
    [aux_sym_binary_operator_token1] = ACTIONS(245),
    [anon_sym_PIPE_GT] = ACTIONS(245),
    [anon_sym_COLON] = ACTIONS(247),
    [anon_sym_DOLLAR] = ACTIONS(249),
    [anon_sym_AT] = ACTIONS(249),
    [aux_sym__hex_literal_token1] = ACTIONS(515),
    [sym__number_literal] = ACTIONS(517),
    [anon_sym_SQUOTE] = ACTIONS(515),
    [anon_sym_DQUOTE] = ACTIONS(515),
    [sym_return] = ACTIONS(517),
    [sym_next] = ACTIONS(517),
    [sym_break] = ACTIONS(517),
    [sym_true] = ACTIONS(517),
    [sym_false] = ACTIONS(517),
    [sym_null] = ACTIONS(517),
    [sym_inf] = ACTIONS(517),
    [sym_nan] = ACTIONS(517),
    [anon_sym_NA] = ACTIONS(517),
    [anon_sym_NA_integer_] = ACTIONS(517),
    [anon_sym_NA_real_] = ACTIONS(517),
    [anon_sym_NA_complex_] = ACTIONS(517),
    [anon_sym_NA_character_] = ACTIONS(517),
    [sym_dots] = ACTIONS(517),
    [sym_dot_dot_i] = ACTIONS(515),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(515),
    [sym__semicolon] = ACTIONS(515),
    [sym__raw_string_literal] = ACTIONS(515),
    [sym__external_else] = ACTIONS(515),
    [sym__external_open_parenthesis] = ACTIONS(253),
    [sym__external_open_brace] = ACTIONS(515),
    [sym__external_close_brace] = ACTIONS(515),
    [sym__external_open_bracket] = ACTIONS(255),
    [sym__external_open_bracket2] = ACTIONS(257),
  },
  [189] = {
    [sym_call_arguments] = STATE(850),
    [sym_subset_arguments] = STATE(851),
    [sym_subset2_arguments] = STATE(852),
    [sym__open_parenthesis] = STATE(349),
    [sym__open_bracket] = STATE(350),
    [sym__open_bracket2] = STATE(351),
    [sym_identifier] = ACTIONS(521),
    [anon_sym_BSLASH] = ACTIONS(519),
    [anon_sym_function] = ACTIONS(521),
    [anon_sym_EQ] = ACTIONS(213),
    [anon_sym_if] = ACTIONS(521),
    [anon_sym_for] = ACTIONS(521),
    [anon_sym_while] = ACTIONS(521),
    [anon_sym_repeat] = ACTIONS(521),
    [anon_sym_QMARK] = ACTIONS(519),
    [anon_sym_TILDE] = ACTIONS(215),
    [anon_sym_BANG] = ACTIONS(521),
    [anon_sym_PLUS] = ACTIONS(217),
    [anon_sym_DASH] = ACTIONS(219),
    [anon_sym_LT_DASH] = ACTIONS(221),
    [anon_sym_LT_LT_DASH] = ACTIONS(221),
    [anon_sym_COLON_EQ] = ACTIONS(221),
    [anon_sym_DASH_GT] = ACTIONS(223),
    [anon_sym_DASH_GT_GT] = ACTIONS(225),
    [anon_sym_PIPE] = ACTIONS(227),
    [anon_sym_AMP] = ACTIONS(229),
    [anon_sym_PIPE_PIPE] = ACTIONS(231),
    [anon_sym_AMP_AMP] = ACTIONS(233),
    [anon_sym_LT] = ACTIONS(235),
    [anon_sym_LT_EQ] = ACTIONS(237),
    [anon_sym_GT] = ACTIONS(235),
    [anon_sym_GT_EQ] = ACTIONS(237),
    [anon_sym_EQ_EQ] = ACTIONS(237),
    [anon_sym_BANG_EQ] = ACTIONS(237),
    [anon_sym_STAR] = ACTIONS(239),
    [anon_sym_SLASH] = ACTIONS(241),
    [anon_sym_STAR_STAR] = ACTIONS(243),
    [anon_sym_CARET] = ACTIONS(243),
    [aux_sym_binary_operator_token1] = ACTIONS(245),
    [anon_sym_PIPE_GT] = ACTIONS(245),
    [anon_sym_COLON] = ACTIONS(247),
    [anon_sym_DOLLAR] = ACTIONS(249),
    [anon_sym_AT] = ACTIONS(249),
    [aux_sym__hex_literal_token1] = ACTIONS(519),
    [sym__number_literal] = ACTIONS(521),
    [anon_sym_SQUOTE] = ACTIONS(519),
    [anon_sym_DQUOTE] = ACTIONS(519),
    [sym_return] = ACTIONS(521),
    [sym_next] = ACTIONS(521),
    [sym_break] = ACTIONS(521),
    [sym_true] = ACTIONS(521),
    [sym_false] = ACTIONS(521),
    [sym_null] = ACTIONS(521),
    [sym_inf] = ACTIONS(521),
    [sym_nan] = ACTIONS(521),
    [anon_sym_NA] = ACTIONS(521),
    [anon_sym_NA_integer_] = ACTIONS(521),
    [anon_sym_NA_real_] = ACTIONS(521),
    [anon_sym_NA_complex_] = ACTIONS(521),
    [anon_sym_NA_character_] = ACTIONS(521),
    [sym_dots] = ACTIONS(521),
    [sym_dot_dot_i] = ACTIONS(519),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(519),
    [sym__semicolon] = ACTIONS(519),
    [sym__raw_string_literal] = ACTIONS(519),
    [sym__external_else] = ACTIONS(519),
    [sym__external_open_parenthesis] = ACTIONS(253),
    [sym__external_open_brace] = ACTIONS(519),
    [sym__external_close_brace] = ACTIONS(519),
    [sym__external_open_bracket] = ACTIONS(255),
    [sym__external_open_bracket2] = ACTIONS(257),
  },
  [190] = {
    [sym_call_arguments] = STATE(850),
    [sym_subset_arguments] = STATE(851),
    [sym_subset2_arguments] = STATE(852),
    [sym__open_parenthesis] = STATE(349),
    [sym__open_bracket] = STATE(350),
    [sym__open_bracket2] = STATE(351),
    [sym_identifier] = ACTIONS(525),
    [anon_sym_BSLASH] = ACTIONS(523),
    [anon_sym_function] = ACTIONS(525),
    [anon_sym_EQ] = ACTIONS(213),
    [anon_sym_if] = ACTIONS(525),
    [anon_sym_for] = ACTIONS(525),
    [anon_sym_while] = ACTIONS(525),
    [anon_sym_repeat] = ACTIONS(525),
    [anon_sym_QMARK] = ACTIONS(523),
    [anon_sym_TILDE] = ACTIONS(215),
    [anon_sym_BANG] = ACTIONS(525),
    [anon_sym_PLUS] = ACTIONS(217),
    [anon_sym_DASH] = ACTIONS(219),
    [anon_sym_LT_DASH] = ACTIONS(221),
    [anon_sym_LT_LT_DASH] = ACTIONS(221),
    [anon_sym_COLON_EQ] = ACTIONS(221),
    [anon_sym_DASH_GT] = ACTIONS(223),
    [anon_sym_DASH_GT_GT] = ACTIONS(225),
    [anon_sym_PIPE] = ACTIONS(227),
    [anon_sym_AMP] = ACTIONS(229),
    [anon_sym_PIPE_PIPE] = ACTIONS(231),
    [anon_sym_AMP_AMP] = ACTIONS(233),
    [anon_sym_LT] = ACTIONS(235),
    [anon_sym_LT_EQ] = ACTIONS(237),
    [anon_sym_GT] = ACTIONS(235),
    [anon_sym_GT_EQ] = ACTIONS(237),
    [anon_sym_EQ_EQ] = ACTIONS(237),
    [anon_sym_BANG_EQ] = ACTIONS(237),
    [anon_sym_STAR] = ACTIONS(239),
    [anon_sym_SLASH] = ACTIONS(241),
    [anon_sym_STAR_STAR] = ACTIONS(243),
    [anon_sym_CARET] = ACTIONS(243),
    [aux_sym_binary_operator_token1] = ACTIONS(245),
    [anon_sym_PIPE_GT] = ACTIONS(245),
    [anon_sym_COLON] = ACTIONS(247),
    [anon_sym_DOLLAR] = ACTIONS(249),
    [anon_sym_AT] = ACTIONS(249),
    [aux_sym__hex_literal_token1] = ACTIONS(523),
    [sym__number_literal] = ACTIONS(525),
    [anon_sym_SQUOTE] = ACTIONS(523),
    [anon_sym_DQUOTE] = ACTIONS(523),
    [sym_return] = ACTIONS(525),
    [sym_next] = ACTIONS(525),
    [sym_break] = ACTIONS(525),
    [sym_true] = ACTIONS(525),
    [sym_false] = ACTIONS(525),
    [sym_null] = ACTIONS(525),
    [sym_inf] = ACTIONS(525),
    [sym_nan] = ACTIONS(525),
    [anon_sym_NA] = ACTIONS(525),
    [anon_sym_NA_integer_] = ACTIONS(525),
    [anon_sym_NA_real_] = ACTIONS(525),
    [anon_sym_NA_complex_] = ACTIONS(525),
    [anon_sym_NA_character_] = ACTIONS(525),
    [sym_dots] = ACTIONS(525),
    [sym_dot_dot_i] = ACTIONS(523),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(523),
    [sym__semicolon] = ACTIONS(523),
    [sym__raw_string_literal] = ACTIONS(523),
    [sym__external_else] = ACTIONS(523),
    [sym__external_open_parenthesis] = ACTIONS(253),
    [sym__external_open_brace] = ACTIONS(523),
    [sym__external_close_brace] = ACTIONS(523),
    [sym__external_open_bracket] = ACTIONS(255),
    [sym__external_open_bracket2] = ACTIONS(257),
  },
  [191] = {
    [sym_call_arguments] = STATE(850),
    [sym_subset_arguments] = STATE(851),
    [sym_subset2_arguments] = STATE(852),
    [sym__open_parenthesis] = STATE(349),
    [sym__open_bracket] = STATE(350),
    [sym__open_bracket2] = STATE(351),
    [sym_identifier] = ACTIONS(529),
    [anon_sym_BSLASH] = ACTIONS(527),
    [anon_sym_function] = ACTIONS(529),
    [anon_sym_EQ] = ACTIONS(213),
    [anon_sym_if] = ACTIONS(529),
    [anon_sym_for] = ACTIONS(529),
    [anon_sym_while] = ACTIONS(529),
    [anon_sym_repeat] = ACTIONS(529),
    [anon_sym_QMARK] = ACTIONS(527),
    [anon_sym_TILDE] = ACTIONS(215),
    [anon_sym_BANG] = ACTIONS(529),
    [anon_sym_PLUS] = ACTIONS(217),
    [anon_sym_DASH] = ACTIONS(219),
    [anon_sym_LT_DASH] = ACTIONS(221),
    [anon_sym_LT_LT_DASH] = ACTIONS(221),
    [anon_sym_COLON_EQ] = ACTIONS(221),
    [anon_sym_DASH_GT] = ACTIONS(223),
    [anon_sym_DASH_GT_GT] = ACTIONS(225),
    [anon_sym_PIPE] = ACTIONS(227),
    [anon_sym_AMP] = ACTIONS(229),
    [anon_sym_PIPE_PIPE] = ACTIONS(231),
    [anon_sym_AMP_AMP] = ACTIONS(233),
    [anon_sym_LT] = ACTIONS(235),
    [anon_sym_LT_EQ] = ACTIONS(237),
    [anon_sym_GT] = ACTIONS(235),
    [anon_sym_GT_EQ] = ACTIONS(237),
    [anon_sym_EQ_EQ] = ACTIONS(237),
    [anon_sym_BANG_EQ] = ACTIONS(237),
    [anon_sym_STAR] = ACTIONS(239),
    [anon_sym_SLASH] = ACTIONS(241),
    [anon_sym_STAR_STAR] = ACTIONS(243),
    [anon_sym_CARET] = ACTIONS(243),
    [aux_sym_binary_operator_token1] = ACTIONS(245),
    [anon_sym_PIPE_GT] = ACTIONS(245),
    [anon_sym_COLON] = ACTIONS(247),
    [anon_sym_DOLLAR] = ACTIONS(249),
    [anon_sym_AT] = ACTIONS(249),
    [aux_sym__hex_literal_token1] = ACTIONS(527),
    [sym__number_literal] = ACTIONS(529),
    [anon_sym_SQUOTE] = ACTIONS(527),
    [anon_sym_DQUOTE] = ACTIONS(527),
    [sym_return] = ACTIONS(529),
    [sym_next] = ACTIONS(529),
    [sym_break] = ACTIONS(529),
    [sym_true] = ACTIONS(529),
    [sym_false] = ACTIONS(529),
    [sym_null] = ACTIONS(529),
    [sym_inf] = ACTIONS(529),
    [sym_nan] = ACTIONS(529),
    [anon_sym_NA] = ACTIONS(529),
    [anon_sym_NA_integer_] = ACTIONS(529),
    [anon_sym_NA_real_] = ACTIONS(529),
    [anon_sym_NA_complex_] = ACTIONS(529),
    [anon_sym_NA_character_] = ACTIONS(529),
    [sym_dots] = ACTIONS(529),
    [sym_dot_dot_i] = ACTIONS(527),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(527),
    [sym__semicolon] = ACTIONS(527),
    [sym__raw_string_literal] = ACTIONS(527),
    [sym__external_else] = ACTIONS(527),
    [sym__external_open_parenthesis] = ACTIONS(253),
    [sym__external_open_brace] = ACTIONS(527),
    [sym__external_close_brace] = ACTIONS(527),
    [sym__external_open_bracket] = ACTIONS(255),
    [sym__external_open_bracket2] = ACTIONS(257),
  },
  [192] = {
    [sym_call_arguments] = STATE(850),
    [sym_subset_arguments] = STATE(851),
    [sym_subset2_arguments] = STATE(852),
    [sym__open_parenthesis] = STATE(349),
    [sym__open_bracket] = STATE(350),
    [sym__open_bracket2] = STATE(351),
    [sym_identifier] = ACTIONS(533),
    [anon_sym_BSLASH] = ACTIONS(531),
    [anon_sym_function] = ACTIONS(533),
    [anon_sym_EQ] = ACTIONS(213),
    [anon_sym_if] = ACTIONS(533),
    [anon_sym_for] = ACTIONS(533),
    [anon_sym_while] = ACTIONS(533),
    [anon_sym_repeat] = ACTIONS(533),
    [anon_sym_QMARK] = ACTIONS(531),
    [anon_sym_TILDE] = ACTIONS(215),
    [anon_sym_BANG] = ACTIONS(533),
    [anon_sym_PLUS] = ACTIONS(217),
    [anon_sym_DASH] = ACTIONS(219),
    [anon_sym_LT_DASH] = ACTIONS(221),
    [anon_sym_LT_LT_DASH] = ACTIONS(221),
    [anon_sym_COLON_EQ] = ACTIONS(221),
    [anon_sym_DASH_GT] = ACTIONS(223),
    [anon_sym_DASH_GT_GT] = ACTIONS(225),
    [anon_sym_PIPE] = ACTIONS(227),
    [anon_sym_AMP] = ACTIONS(229),
    [anon_sym_PIPE_PIPE] = ACTIONS(231),
    [anon_sym_AMP_AMP] = ACTIONS(233),
    [anon_sym_LT] = ACTIONS(235),
    [anon_sym_LT_EQ] = ACTIONS(237),
    [anon_sym_GT] = ACTIONS(235),
    [anon_sym_GT_EQ] = ACTIONS(237),
    [anon_sym_EQ_EQ] = ACTIONS(237),
    [anon_sym_BANG_EQ] = ACTIONS(237),
    [anon_sym_STAR] = ACTIONS(239),
    [anon_sym_SLASH] = ACTIONS(241),
    [anon_sym_STAR_STAR] = ACTIONS(243),
    [anon_sym_CARET] = ACTIONS(243),
    [aux_sym_binary_operator_token1] = ACTIONS(245),
    [anon_sym_PIPE_GT] = ACTIONS(245),
    [anon_sym_COLON] = ACTIONS(247),
    [anon_sym_DOLLAR] = ACTIONS(249),
    [anon_sym_AT] = ACTIONS(249),
    [aux_sym__hex_literal_token1] = ACTIONS(531),
    [sym__number_literal] = ACTIONS(533),
    [anon_sym_SQUOTE] = ACTIONS(531),
    [anon_sym_DQUOTE] = ACTIONS(531),
    [sym_return] = ACTIONS(533),
    [sym_next] = ACTIONS(533),
    [sym_break] = ACTIONS(533),
    [sym_true] = ACTIONS(533),
    [sym_false] = ACTIONS(533),
    [sym_null] = ACTIONS(533),
    [sym_inf] = ACTIONS(533),
    [sym_nan] = ACTIONS(533),
    [anon_sym_NA] = ACTIONS(533),
    [anon_sym_NA_integer_] = ACTIONS(533),
    [anon_sym_NA_real_] = ACTIONS(533),
    [anon_sym_NA_complex_] = ACTIONS(533),
    [anon_sym_NA_character_] = ACTIONS(533),
    [sym_dots] = ACTIONS(533),
    [sym_dot_dot_i] = ACTIONS(531),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(531),
    [sym__semicolon] = ACTIONS(531),
    [sym__raw_string_literal] = ACTIONS(531),
    [sym__external_else] = ACTIONS(531),
    [sym__external_open_parenthesis] = ACTIONS(253),
    [sym__external_open_brace] = ACTIONS(531),
    [sym__external_close_brace] = ACTIONS(531),
    [sym__external_open_bracket] = ACTIONS(255),
    [sym__external_open_bracket2] = ACTIONS(257),
  },
  [193] = {
    [sym_call_arguments] = STATE(850),
    [sym_subset_arguments] = STATE(851),
    [sym_subset2_arguments] = STATE(852),
    [sym__open_parenthesis] = STATE(349),
    [sym__open_bracket] = STATE(350),
    [sym__open_bracket2] = STATE(351),
    [sym_identifier] = ACTIONS(537),
    [anon_sym_BSLASH] = ACTIONS(535),
    [anon_sym_function] = ACTIONS(537),
    [anon_sym_EQ] = ACTIONS(213),
    [anon_sym_if] = ACTIONS(537),
    [anon_sym_for] = ACTIONS(537),
    [anon_sym_while] = ACTIONS(537),
    [anon_sym_repeat] = ACTIONS(537),
    [anon_sym_QMARK] = ACTIONS(535),
    [anon_sym_TILDE] = ACTIONS(215),
    [anon_sym_BANG] = ACTIONS(537),
    [anon_sym_PLUS] = ACTIONS(217),
    [anon_sym_DASH] = ACTIONS(219),
    [anon_sym_LT_DASH] = ACTIONS(221),
    [anon_sym_LT_LT_DASH] = ACTIONS(221),
    [anon_sym_COLON_EQ] = ACTIONS(221),
    [anon_sym_DASH_GT] = ACTIONS(223),
    [anon_sym_DASH_GT_GT] = ACTIONS(225),
    [anon_sym_PIPE] = ACTIONS(227),
    [anon_sym_AMP] = ACTIONS(229),
    [anon_sym_PIPE_PIPE] = ACTIONS(231),
    [anon_sym_AMP_AMP] = ACTIONS(233),
    [anon_sym_LT] = ACTIONS(235),
    [anon_sym_LT_EQ] = ACTIONS(237),
    [anon_sym_GT] = ACTIONS(235),
    [anon_sym_GT_EQ] = ACTIONS(237),
    [anon_sym_EQ_EQ] = ACTIONS(237),
    [anon_sym_BANG_EQ] = ACTIONS(237),
    [anon_sym_STAR] = ACTIONS(239),
    [anon_sym_SLASH] = ACTIONS(241),
    [anon_sym_STAR_STAR] = ACTIONS(243),
    [anon_sym_CARET] = ACTIONS(243),
    [aux_sym_binary_operator_token1] = ACTIONS(245),
    [anon_sym_PIPE_GT] = ACTIONS(245),
    [anon_sym_COLON] = ACTIONS(247),
    [anon_sym_DOLLAR] = ACTIONS(249),
    [anon_sym_AT] = ACTIONS(249),
    [aux_sym__hex_literal_token1] = ACTIONS(535),
    [sym__number_literal] = ACTIONS(537),
    [anon_sym_SQUOTE] = ACTIONS(535),
    [anon_sym_DQUOTE] = ACTIONS(535),
    [sym_return] = ACTIONS(537),
    [sym_next] = ACTIONS(537),
    [sym_break] = ACTIONS(537),
    [sym_true] = ACTIONS(537),
    [sym_false] = ACTIONS(537),
    [sym_null] = ACTIONS(537),
    [sym_inf] = ACTIONS(537),
    [sym_nan] = ACTIONS(537),
    [anon_sym_NA] = ACTIONS(537),
    [anon_sym_NA_integer_] = ACTIONS(537),
    [anon_sym_NA_real_] = ACTIONS(537),
    [anon_sym_NA_complex_] = ACTIONS(537),
    [anon_sym_NA_character_] = ACTIONS(537),
    [sym_dots] = ACTIONS(537),
    [sym_dot_dot_i] = ACTIONS(535),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(535),
    [sym__semicolon] = ACTIONS(535),
    [sym__raw_string_literal] = ACTIONS(535),
    [sym__external_else] = ACTIONS(535),
    [sym__external_open_parenthesis] = ACTIONS(253),
    [sym__external_open_brace] = ACTIONS(535),
    [sym__external_close_brace] = ACTIONS(535),
    [sym__external_open_bracket] = ACTIONS(255),
    [sym__external_open_bracket2] = ACTIONS(257),
  },
  [194] = {
    [sym_call_arguments] = STATE(850),
    [sym_subset_arguments] = STATE(851),
    [sym_subset2_arguments] = STATE(852),
    [sym__open_parenthesis] = STATE(349),
    [sym__open_bracket] = STATE(350),
    [sym__open_bracket2] = STATE(351),
    [sym_identifier] = ACTIONS(541),
    [anon_sym_BSLASH] = ACTIONS(539),
    [anon_sym_function] = ACTIONS(541),
    [anon_sym_EQ] = ACTIONS(213),
    [anon_sym_if] = ACTIONS(541),
    [anon_sym_for] = ACTIONS(541),
    [anon_sym_while] = ACTIONS(541),
    [anon_sym_repeat] = ACTIONS(541),
    [anon_sym_QMARK] = ACTIONS(539),
    [anon_sym_TILDE] = ACTIONS(215),
    [anon_sym_BANG] = ACTIONS(541),
    [anon_sym_PLUS] = ACTIONS(217),
    [anon_sym_DASH] = ACTIONS(219),
    [anon_sym_LT_DASH] = ACTIONS(221),
    [anon_sym_LT_LT_DASH] = ACTIONS(221),
    [anon_sym_COLON_EQ] = ACTIONS(221),
    [anon_sym_DASH_GT] = ACTIONS(223),
    [anon_sym_DASH_GT_GT] = ACTIONS(225),
    [anon_sym_PIPE] = ACTIONS(227),
    [anon_sym_AMP] = ACTIONS(229),
    [anon_sym_PIPE_PIPE] = ACTIONS(231),
    [anon_sym_AMP_AMP] = ACTIONS(233),
    [anon_sym_LT] = ACTIONS(235),
    [anon_sym_LT_EQ] = ACTIONS(237),
    [anon_sym_GT] = ACTIONS(235),
    [anon_sym_GT_EQ] = ACTIONS(237),
    [anon_sym_EQ_EQ] = ACTIONS(237),
    [anon_sym_BANG_EQ] = ACTIONS(237),
    [anon_sym_STAR] = ACTIONS(239),
    [anon_sym_SLASH] = ACTIONS(241),
    [anon_sym_STAR_STAR] = ACTIONS(243),
    [anon_sym_CARET] = ACTIONS(243),
    [aux_sym_binary_operator_token1] = ACTIONS(245),
    [anon_sym_PIPE_GT] = ACTIONS(245),
    [anon_sym_COLON] = ACTIONS(247),
    [anon_sym_DOLLAR] = ACTIONS(249),
    [anon_sym_AT] = ACTIONS(249),
    [aux_sym__hex_literal_token1] = ACTIONS(539),
    [sym__number_literal] = ACTIONS(541),
    [anon_sym_SQUOTE] = ACTIONS(539),
    [anon_sym_DQUOTE] = ACTIONS(539),
    [sym_return] = ACTIONS(541),
    [sym_next] = ACTIONS(541),
    [sym_break] = ACTIONS(541),
    [sym_true] = ACTIONS(541),
    [sym_false] = ACTIONS(541),
    [sym_null] = ACTIONS(541),
    [sym_inf] = ACTIONS(541),
    [sym_nan] = ACTIONS(541),
    [anon_sym_NA] = ACTIONS(541),
    [anon_sym_NA_integer_] = ACTIONS(541),
    [anon_sym_NA_real_] = ACTIONS(541),
    [anon_sym_NA_complex_] = ACTIONS(541),
    [anon_sym_NA_character_] = ACTIONS(541),
    [sym_dots] = ACTIONS(541),
    [sym_dot_dot_i] = ACTIONS(539),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(539),
    [sym__semicolon] = ACTIONS(539),
    [sym__raw_string_literal] = ACTIONS(539),
    [sym__external_else] = ACTIONS(539),
    [sym__external_open_parenthesis] = ACTIONS(253),
    [sym__external_open_brace] = ACTIONS(539),
    [sym__external_close_brace] = ACTIONS(539),
    [sym__external_open_bracket] = ACTIONS(255),
    [sym__external_open_bracket2] = ACTIONS(257),
  },
  [195] = {
    [sym_function_definition] = STATE(631),
    [sym_if_statement] = STATE(631),
    [sym_for_statement] = STATE(631),
    [sym_while_statement] = STATE(631),
    [sym_repeat_statement] = STATE(631),
    [sym_braced_expression] = STATE(631),
    [sym_parenthesized_expression] = STATE(631),
    [sym_call] = STATE(631),
    [sym_subset] = STATE(631),
    [sym_subset2] = STATE(631),
    [sym__argument] = STATE(1934),
    [sym_argument] = STATE(1937),
    [sym__argument_named] = STATE(1909),
    [sym__argument_unnamed] = STATE(1932),
    [sym__argument_value] = STATE(1920),
    [sym_unary_operator] = STATE(631),
    [sym_binary_operator] = STATE(631),
    [sym_extract_operator] = STATE(631),
    [sym_namespace_operator] = STATE(631),
    [sym_integer] = STATE(631),
    [sym_complex] = STATE(631),
    [sym_float] = STATE(631),
    [sym__hex_literal] = STATE(752),
    [sym__float_literal] = STATE(752),
    [sym_string] = STATE(766),
    [sym__single_quoted_string] = STATE(753),
    [sym__double_quoted_string] = STATE(754),
    [sym_na] = STATE(631),
    [sym__expression] = STATE(631),
    [sym__string_or_identifier] = STATE(2143),
    [sym__open_parenthesis] = STATE(869),
    [sym__open_brace] = STATE(764),
    [sym__close_bracket] = STATE(1963),
    [aux_sym_call_arguments_repeat1] = STATE(529),
    [sym_identifier] = ACTIONS(387),
    [anon_sym_BSLASH] = ACTIONS(389),
    [anon_sym_function] = ACTIONS(391),
    [anon_sym_if] = ACTIONS(393),
    [anon_sym_for] = ACTIONS(395),
    [anon_sym_while] = ACTIONS(397),
    [anon_sym_repeat] = ACTIONS(399),
    [anon_sym_QMARK] = ACTIONS(401),
    [anon_sym_TILDE] = ACTIONS(403),
    [anon_sym_BANG] = ACTIONS(405),
    [anon_sym_PLUS] = ACTIONS(407),
    [anon_sym_DASH] = ACTIONS(407),
    [aux_sym__hex_literal_token1] = ACTIONS(409),
    [sym__number_literal] = ACTIONS(411),
    [anon_sym_SQUOTE] = ACTIONS(413),
    [anon_sym_DQUOTE] = ACTIONS(415),
    [sym_return] = ACTIONS(417),
    [sym_next] = ACTIONS(417),
    [sym_break] = ACTIONS(417),
    [sym_true] = ACTIONS(417),
    [sym_false] = ACTIONS(417),
    [sym_null] = ACTIONS(417),
    [sym_inf] = ACTIONS(417),
    [sym_nan] = ACTIONS(417),
    [anon_sym_NA] = ACTIONS(419),
    [anon_sym_NA_integer_] = ACTIONS(419),
    [anon_sym_NA_real_] = ACTIONS(419),
    [anon_sym_NA_complex_] = ACTIONS(419),
    [anon_sym_NA_character_] = ACTIONS(419),
    [sym_dots] = ACTIONS(421),
    [sym_dot_dot_i] = ACTIONS(423),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(425),
    [sym__newline] = ACTIONS(427),
    [sym__raw_string_literal] = ACTIONS(429),
    [sym__external_open_parenthesis] = ACTIONS(431),
    [sym__external_open_brace] = ACTIONS(433),
    [sym__external_close_bracket] = ACTIONS(555),
  },
  [196] = {
    [sym_function_definition] = STATE(568),
    [sym_if_statement] = STATE(568),
    [sym_for_statement] = STATE(568),
    [sym_while_statement] = STATE(568),
    [sym_repeat_statement] = STATE(568),
    [sym_braced_expression] = STATE(568),
    [sym_parenthesized_expression] = STATE(568),
    [sym_call] = STATE(568),
    [sym_subset] = STATE(568),
    [sym_subset2] = STATE(568),
    [sym__argument] = STATE(1928),
    [sym_argument] = STATE(1930),
    [sym__argument_named] = STATE(1908),
    [sym__argument_unnamed] = STATE(1933),
    [sym__argument_value] = STATE(1936),
    [sym_unary_operator] = STATE(568),
    [sym_binary_operator] = STATE(568),
    [sym_extract_operator] = STATE(568),
    [sym_namespace_operator] = STATE(568),
    [sym_integer] = STATE(568),
    [sym_complex] = STATE(568),
    [sym_float] = STATE(568),
    [sym__hex_literal] = STATE(703),
    [sym__float_literal] = STATE(703),
    [sym_string] = STATE(736),
    [sym__single_quoted_string] = STATE(705),
    [sym__double_quoted_string] = STATE(706),
    [sym_na] = STATE(568),
    [sym__expression] = STATE(568),
    [sym__string_or_identifier] = STATE(2142),
    [sym__open_parenthesis] = STATE(874),
    [sym__open_brace] = STATE(765),
    [sym__close_bracket2] = STATE(1966),
    [aux_sym_call_arguments_repeat1] = STATE(585),
    [sym_identifier] = ACTIONS(437),
    [anon_sym_BSLASH] = ACTIONS(439),
    [anon_sym_function] = ACTIONS(441),
    [anon_sym_if] = ACTIONS(443),
    [anon_sym_for] = ACTIONS(445),
    [anon_sym_while] = ACTIONS(447),
    [anon_sym_repeat] = ACTIONS(449),
    [anon_sym_QMARK] = ACTIONS(451),
    [anon_sym_TILDE] = ACTIONS(453),
    [anon_sym_BANG] = ACTIONS(455),
    [anon_sym_PLUS] = ACTIONS(457),
    [anon_sym_DASH] = ACTIONS(457),
    [aux_sym__hex_literal_token1] = ACTIONS(459),
    [sym__number_literal] = ACTIONS(461),
    [anon_sym_SQUOTE] = ACTIONS(463),
    [anon_sym_DQUOTE] = ACTIONS(465),
    [sym_return] = ACTIONS(467),
    [sym_next] = ACTIONS(467),
    [sym_break] = ACTIONS(467),
    [sym_true] = ACTIONS(467),
    [sym_false] = ACTIONS(467),
    [sym_null] = ACTIONS(467),
    [sym_inf] = ACTIONS(467),
    [sym_nan] = ACTIONS(467),
    [anon_sym_NA] = ACTIONS(469),
    [anon_sym_NA_integer_] = ACTIONS(469),
    [anon_sym_NA_real_] = ACTIONS(469),
    [anon_sym_NA_complex_] = ACTIONS(469),
    [anon_sym_NA_character_] = ACTIONS(469),
    [sym_dots] = ACTIONS(471),
    [sym_dot_dot_i] = ACTIONS(473),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(475),
    [sym__newline] = ACTIONS(477),
    [sym__raw_string_literal] = ACTIONS(479),
    [sym__external_open_parenthesis] = ACTIONS(481),
    [sym__external_open_brace] = ACTIONS(483),
    [sym__external_close_bracket2] = ACTIONS(557),
  },
  [197] = {
    [sym_call_arguments] = STATE(807),
    [sym_subset_arguments] = STATE(808),
    [sym_subset2_arguments] = STATE(810),
    [sym__open_parenthesis] = STATE(357),
    [sym__open_bracket] = STATE(358),
    [sym__open_bracket2] = STATE(359),
    [sym_identifier] = ACTIONS(543),
    [anon_sym_BSLASH] = ACTIONS(545),
    [anon_sym_function] = ACTIONS(543),
    [anon_sym_EQ] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(543),
    [anon_sym_for] = ACTIONS(543),
    [anon_sym_while] = ACTIONS(543),
    [anon_sym_repeat] = ACTIONS(543),
    [anon_sym_QMARK] = ACTIONS(545),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_BANG] = ACTIONS(543),
    [anon_sym_PLUS] = ACTIONS(59),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_LT_DASH] = ACTIONS(63),
    [anon_sym_LT_LT_DASH] = ACTIONS(63),
    [anon_sym_COLON_EQ] = ACTIONS(63),
    [anon_sym_DASH_GT] = ACTIONS(65),
    [anon_sym_DASH_GT_GT] = ACTIONS(67),
    [anon_sym_PIPE] = ACTIONS(69),
    [anon_sym_AMP] = ACTIONS(71),
    [anon_sym_PIPE_PIPE] = ACTIONS(73),
    [anon_sym_AMP_AMP] = ACTIONS(75),
    [anon_sym_LT] = ACTIONS(77),
    [anon_sym_LT_EQ] = ACTIONS(79),
    [anon_sym_GT] = ACTIONS(77),
    [anon_sym_GT_EQ] = ACTIONS(79),
    [anon_sym_EQ_EQ] = ACTIONS(79),
    [anon_sym_BANG_EQ] = ACTIONS(79),
    [anon_sym_STAR] = ACTIONS(81),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_STAR_STAR] = ACTIONS(85),
    [anon_sym_CARET] = ACTIONS(85),
    [aux_sym_binary_operator_token1] = ACTIONS(87),
    [anon_sym_PIPE_GT] = ACTIONS(87),
    [anon_sym_COLON] = ACTIONS(89),
    [anon_sym_DOLLAR] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(91),
    [aux_sym__hex_literal_token1] = ACTIONS(545),
    [sym__number_literal] = ACTIONS(543),
    [anon_sym_SQUOTE] = ACTIONS(545),
    [anon_sym_DQUOTE] = ACTIONS(545),
    [sym_return] = ACTIONS(543),
    [sym_next] = ACTIONS(543),
    [sym_break] = ACTIONS(543),
    [sym_true] = ACTIONS(543),
    [sym_false] = ACTIONS(543),
    [sym_null] = ACTIONS(543),
    [sym_inf] = ACTIONS(543),
    [sym_nan] = ACTIONS(543),
    [anon_sym_NA] = ACTIONS(543),
    [anon_sym_NA_integer_] = ACTIONS(543),
    [anon_sym_NA_real_] = ACTIONS(543),
    [anon_sym_NA_complex_] = ACTIONS(543),
    [anon_sym_NA_character_] = ACTIONS(543),
    [sym_dots] = ACTIONS(543),
    [sym_dot_dot_i] = ACTIONS(545),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(545),
    [sym__newline] = ACTIONS(545),
    [sym__raw_string_literal] = ACTIONS(545),
    [sym__external_else] = ACTIONS(545),
    [sym__external_open_parenthesis] = ACTIONS(95),
    [sym__external_open_brace] = ACTIONS(545),
    [sym__external_open_bracket] = ACTIONS(97),
    [sym__external_close_bracket] = ACTIONS(545),
    [sym__external_open_bracket2] = ACTIONS(99),
  },
  [198] = {
    [sym_call_arguments] = STATE(807),
    [sym_subset_arguments] = STATE(808),
    [sym_subset2_arguments] = STATE(810),
    [sym__open_parenthesis] = STATE(357),
    [sym__open_bracket] = STATE(358),
    [sym__open_bracket2] = STATE(359),
    [sym_identifier] = ACTIONS(367),
    [anon_sym_BSLASH] = ACTIONS(369),
    [anon_sym_function] = ACTIONS(367),
    [anon_sym_EQ] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(367),
    [anon_sym_for] = ACTIONS(367),
    [anon_sym_while] = ACTIONS(367),
    [anon_sym_repeat] = ACTIONS(367),
    [anon_sym_QMARK] = ACTIONS(369),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_BANG] = ACTIONS(367),
    [anon_sym_PLUS] = ACTIONS(59),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_LT_DASH] = ACTIONS(63),
    [anon_sym_LT_LT_DASH] = ACTIONS(63),
    [anon_sym_COLON_EQ] = ACTIONS(63),
    [anon_sym_DASH_GT] = ACTIONS(65),
    [anon_sym_DASH_GT_GT] = ACTIONS(67),
    [anon_sym_PIPE] = ACTIONS(69),
    [anon_sym_AMP] = ACTIONS(71),
    [anon_sym_PIPE_PIPE] = ACTIONS(73),
    [anon_sym_AMP_AMP] = ACTIONS(75),
    [anon_sym_LT] = ACTIONS(77),
    [anon_sym_LT_EQ] = ACTIONS(79),
    [anon_sym_GT] = ACTIONS(77),
    [anon_sym_GT_EQ] = ACTIONS(79),
    [anon_sym_EQ_EQ] = ACTIONS(79),
    [anon_sym_BANG_EQ] = ACTIONS(79),
    [anon_sym_STAR] = ACTIONS(81),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_STAR_STAR] = ACTIONS(85),
    [anon_sym_CARET] = ACTIONS(85),
    [aux_sym_binary_operator_token1] = ACTIONS(87),
    [anon_sym_PIPE_GT] = ACTIONS(87),
    [anon_sym_COLON] = ACTIONS(89),
    [anon_sym_DOLLAR] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(91),
    [aux_sym__hex_literal_token1] = ACTIONS(369),
    [sym__number_literal] = ACTIONS(367),
    [anon_sym_SQUOTE] = ACTIONS(369),
    [anon_sym_DQUOTE] = ACTIONS(369),
    [sym_return] = ACTIONS(367),
    [sym_next] = ACTIONS(367),
    [sym_break] = ACTIONS(367),
    [sym_true] = ACTIONS(367),
    [sym_false] = ACTIONS(367),
    [sym_null] = ACTIONS(367),
    [sym_inf] = ACTIONS(367),
    [sym_nan] = ACTIONS(367),
    [anon_sym_NA] = ACTIONS(367),
    [anon_sym_NA_integer_] = ACTIONS(367),
    [anon_sym_NA_real_] = ACTIONS(367),
    [anon_sym_NA_complex_] = ACTIONS(367),
    [anon_sym_NA_character_] = ACTIONS(367),
    [sym_dots] = ACTIONS(367),
    [sym_dot_dot_i] = ACTIONS(369),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(369),
    [sym__newline] = ACTIONS(369),
    [sym__raw_string_literal] = ACTIONS(369),
    [sym__external_else] = ACTIONS(369),
    [sym__external_open_parenthesis] = ACTIONS(95),
    [sym__external_open_brace] = ACTIONS(369),
    [sym__external_open_bracket] = ACTIONS(97),
    [sym__external_close_bracket] = ACTIONS(369),
    [sym__external_open_bracket2] = ACTIONS(99),
  },
  [199] = {
    [sym_function_definition] = STATE(568),
    [sym_if_statement] = STATE(568),
    [sym_for_statement] = STATE(568),
    [sym_while_statement] = STATE(568),
    [sym_repeat_statement] = STATE(568),
    [sym_braced_expression] = STATE(568),
    [sym_parenthesized_expression] = STATE(568),
    [sym_call] = STATE(568),
    [sym_subset] = STATE(568),
    [sym_subset2] = STATE(568),
    [sym__argument] = STATE(1928),
    [sym_argument] = STATE(1930),
    [sym__argument_named] = STATE(1908),
    [sym__argument_unnamed] = STATE(1933),
    [sym__argument_value] = STATE(1936),
    [sym_unary_operator] = STATE(568),
    [sym_binary_operator] = STATE(568),
    [sym_extract_operator] = STATE(568),
    [sym_namespace_operator] = STATE(568),
    [sym_integer] = STATE(568),
    [sym_complex] = STATE(568),
    [sym_float] = STATE(568),
    [sym__hex_literal] = STATE(703),
    [sym__float_literal] = STATE(703),
    [sym_string] = STATE(736),
    [sym__single_quoted_string] = STATE(705),
    [sym__double_quoted_string] = STATE(706),
    [sym_na] = STATE(568),
    [sym__expression] = STATE(568),
    [sym__string_or_identifier] = STATE(2142),
    [sym__open_parenthesis] = STATE(874),
    [sym__open_brace] = STATE(765),
    [sym__close_bracket2] = STATE(817),
    [aux_sym_call_arguments_repeat1] = STATE(274),
    [sym_identifier] = ACTIONS(437),
    [anon_sym_BSLASH] = ACTIONS(439),
    [anon_sym_function] = ACTIONS(441),
    [anon_sym_if] = ACTIONS(443),
    [anon_sym_for] = ACTIONS(445),
    [anon_sym_while] = ACTIONS(447),
    [anon_sym_repeat] = ACTIONS(449),
    [anon_sym_QMARK] = ACTIONS(451),
    [anon_sym_TILDE] = ACTIONS(453),
    [anon_sym_BANG] = ACTIONS(455),
    [anon_sym_PLUS] = ACTIONS(457),
    [anon_sym_DASH] = ACTIONS(457),
    [aux_sym__hex_literal_token1] = ACTIONS(459),
    [sym__number_literal] = ACTIONS(461),
    [anon_sym_SQUOTE] = ACTIONS(463),
    [anon_sym_DQUOTE] = ACTIONS(465),
    [sym_return] = ACTIONS(467),
    [sym_next] = ACTIONS(467),
    [sym_break] = ACTIONS(467),
    [sym_true] = ACTIONS(467),
    [sym_false] = ACTIONS(467),
    [sym_null] = ACTIONS(467),
    [sym_inf] = ACTIONS(467),
    [sym_nan] = ACTIONS(467),
    [anon_sym_NA] = ACTIONS(469),
    [anon_sym_NA_integer_] = ACTIONS(469),
    [anon_sym_NA_real_] = ACTIONS(469),
    [anon_sym_NA_complex_] = ACTIONS(469),
    [anon_sym_NA_character_] = ACTIONS(469),
    [sym_dots] = ACTIONS(471),
    [sym_dot_dot_i] = ACTIONS(473),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(475),
    [sym__newline] = ACTIONS(477),
    [sym__raw_string_literal] = ACTIONS(479),
    [sym__external_open_parenthesis] = ACTIONS(481),
    [sym__external_open_brace] = ACTIONS(483),
    [sym__external_close_bracket2] = ACTIONS(559),
  },
  [200] = {
    [sym_call_arguments] = STATE(807),
    [sym_subset_arguments] = STATE(808),
    [sym_subset2_arguments] = STATE(810),
    [sym__open_parenthesis] = STATE(357),
    [sym__open_bracket] = STATE(358),
    [sym__open_bracket2] = STATE(359),
    [sym_identifier] = ACTIONS(367),
    [anon_sym_BSLASH] = ACTIONS(369),
    [anon_sym_function] = ACTIONS(367),
    [anon_sym_EQ] = ACTIONS(367),
    [anon_sym_if] = ACTIONS(367),
    [anon_sym_for] = ACTIONS(367),
    [anon_sym_while] = ACTIONS(367),
    [anon_sym_repeat] = ACTIONS(367),
    [anon_sym_QMARK] = ACTIONS(369),
    [anon_sym_TILDE] = ACTIONS(369),
    [anon_sym_BANG] = ACTIONS(367),
    [anon_sym_PLUS] = ACTIONS(59),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_LT_DASH] = ACTIONS(369),
    [anon_sym_LT_LT_DASH] = ACTIONS(369),
    [anon_sym_COLON_EQ] = ACTIONS(369),
    [anon_sym_DASH_GT] = ACTIONS(367),
    [anon_sym_DASH_GT_GT] = ACTIONS(369),
    [anon_sym_PIPE] = ACTIONS(367),
    [anon_sym_AMP] = ACTIONS(367),
    [anon_sym_PIPE_PIPE] = ACTIONS(369),
    [anon_sym_AMP_AMP] = ACTIONS(369),
    [anon_sym_LT] = ACTIONS(77),
    [anon_sym_LT_EQ] = ACTIONS(79),
    [anon_sym_GT] = ACTIONS(77),
    [anon_sym_GT_EQ] = ACTIONS(79),
    [anon_sym_EQ_EQ] = ACTIONS(79),
    [anon_sym_BANG_EQ] = ACTIONS(79),
    [anon_sym_STAR] = ACTIONS(81),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_STAR_STAR] = ACTIONS(85),
    [anon_sym_CARET] = ACTIONS(85),
    [aux_sym_binary_operator_token1] = ACTIONS(87),
    [anon_sym_PIPE_GT] = ACTIONS(87),
    [anon_sym_COLON] = ACTIONS(89),
    [anon_sym_DOLLAR] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(91),
    [aux_sym__hex_literal_token1] = ACTIONS(369),
    [sym__number_literal] = ACTIONS(367),
    [anon_sym_SQUOTE] = ACTIONS(369),
    [anon_sym_DQUOTE] = ACTIONS(369),
    [sym_return] = ACTIONS(367),
    [sym_next] = ACTIONS(367),
    [sym_break] = ACTIONS(367),
    [sym_true] = ACTIONS(367),
    [sym_false] = ACTIONS(367),
    [sym_null] = ACTIONS(367),
    [sym_inf] = ACTIONS(367),
    [sym_nan] = ACTIONS(367),
    [anon_sym_NA] = ACTIONS(367),
    [anon_sym_NA_integer_] = ACTIONS(367),
    [anon_sym_NA_real_] = ACTIONS(367),
    [anon_sym_NA_complex_] = ACTIONS(367),
    [anon_sym_NA_character_] = ACTIONS(367),
    [sym_dots] = ACTIONS(367),
    [sym_dot_dot_i] = ACTIONS(369),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(369),
    [sym__newline] = ACTIONS(369),
    [sym__raw_string_literal] = ACTIONS(369),
    [sym__external_else] = ACTIONS(369),
    [sym__external_open_parenthesis] = ACTIONS(95),
    [sym__external_open_brace] = ACTIONS(369),
    [sym__external_open_bracket] = ACTIONS(97),
    [sym__external_close_bracket] = ACTIONS(369),
    [sym__external_open_bracket2] = ACTIONS(99),
  },
  [201] = {
    [sym_call_arguments] = STATE(807),
    [sym_subset_arguments] = STATE(808),
    [sym_subset2_arguments] = STATE(810),
    [sym__open_parenthesis] = STATE(357),
    [sym__open_bracket] = STATE(358),
    [sym__open_bracket2] = STATE(359),
    [sym_identifier] = ACTIONS(367),
    [anon_sym_BSLASH] = ACTIONS(369),
    [anon_sym_function] = ACTIONS(367),
    [anon_sym_EQ] = ACTIONS(367),
    [anon_sym_if] = ACTIONS(367),
    [anon_sym_for] = ACTIONS(367),
    [anon_sym_while] = ACTIONS(367),
    [anon_sym_repeat] = ACTIONS(367),
    [anon_sym_QMARK] = ACTIONS(369),
    [anon_sym_TILDE] = ACTIONS(369),
    [anon_sym_BANG] = ACTIONS(367),
    [anon_sym_PLUS] = ACTIONS(369),
    [anon_sym_DASH] = ACTIONS(367),
    [anon_sym_LT_DASH] = ACTIONS(369),
    [anon_sym_LT_LT_DASH] = ACTIONS(369),
    [anon_sym_COLON_EQ] = ACTIONS(369),
    [anon_sym_DASH_GT] = ACTIONS(367),
    [anon_sym_DASH_GT_GT] = ACTIONS(369),
    [anon_sym_PIPE] = ACTIONS(367),
    [anon_sym_AMP] = ACTIONS(367),
    [anon_sym_PIPE_PIPE] = ACTIONS(369),
    [anon_sym_AMP_AMP] = ACTIONS(369),
    [anon_sym_LT] = ACTIONS(367),
    [anon_sym_LT_EQ] = ACTIONS(369),
    [anon_sym_GT] = ACTIONS(367),
    [anon_sym_GT_EQ] = ACTIONS(369),
    [anon_sym_EQ_EQ] = ACTIONS(369),
    [anon_sym_BANG_EQ] = ACTIONS(369),
    [anon_sym_STAR] = ACTIONS(367),
    [anon_sym_SLASH] = ACTIONS(369),
    [anon_sym_STAR_STAR] = ACTIONS(85),
    [anon_sym_CARET] = ACTIONS(85),
    [aux_sym_binary_operator_token1] = ACTIONS(369),
    [anon_sym_PIPE_GT] = ACTIONS(369),
    [anon_sym_COLON] = ACTIONS(367),
    [anon_sym_DOLLAR] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(91),
    [aux_sym__hex_literal_token1] = ACTIONS(369),
    [sym__number_literal] = ACTIONS(367),
    [anon_sym_SQUOTE] = ACTIONS(369),
    [anon_sym_DQUOTE] = ACTIONS(369),
    [sym_return] = ACTIONS(367),
    [sym_next] = ACTIONS(367),
    [sym_break] = ACTIONS(367),
    [sym_true] = ACTIONS(367),
    [sym_false] = ACTIONS(367),
    [sym_null] = ACTIONS(367),
    [sym_inf] = ACTIONS(367),
    [sym_nan] = ACTIONS(367),
    [anon_sym_NA] = ACTIONS(367),
    [anon_sym_NA_integer_] = ACTIONS(367),
    [anon_sym_NA_real_] = ACTIONS(367),
    [anon_sym_NA_complex_] = ACTIONS(367),
    [anon_sym_NA_character_] = ACTIONS(367),
    [sym_dots] = ACTIONS(367),
    [sym_dot_dot_i] = ACTIONS(369),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(369),
    [sym__newline] = ACTIONS(369),
    [sym__raw_string_literal] = ACTIONS(369),
    [sym__external_else] = ACTIONS(369),
    [sym__external_open_parenthesis] = ACTIONS(95),
    [sym__external_open_brace] = ACTIONS(369),
    [sym__external_open_bracket] = ACTIONS(97),
    [sym__external_close_bracket] = ACTIONS(369),
    [sym__external_open_bracket2] = ACTIONS(99),
  },
  [202] = {
    [sym_call_arguments] = STATE(807),
    [sym_subset_arguments] = STATE(808),
    [sym_subset2_arguments] = STATE(810),
    [sym__open_parenthesis] = STATE(357),
    [sym__open_bracket] = STATE(358),
    [sym__open_bracket2] = STATE(359),
    [sym_identifier] = ACTIONS(373),
    [anon_sym_BSLASH] = ACTIONS(371),
    [anon_sym_function] = ACTIONS(373),
    [anon_sym_EQ] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(373),
    [anon_sym_for] = ACTIONS(373),
    [anon_sym_while] = ACTIONS(373),
    [anon_sym_repeat] = ACTIONS(373),
    [anon_sym_QMARK] = ACTIONS(371),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_BANG] = ACTIONS(373),
    [anon_sym_PLUS] = ACTIONS(59),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_LT_DASH] = ACTIONS(63),
    [anon_sym_LT_LT_DASH] = ACTIONS(63),
    [anon_sym_COLON_EQ] = ACTIONS(63),
    [anon_sym_DASH_GT] = ACTIONS(65),
    [anon_sym_DASH_GT_GT] = ACTIONS(67),
    [anon_sym_PIPE] = ACTIONS(69),
    [anon_sym_AMP] = ACTIONS(71),
    [anon_sym_PIPE_PIPE] = ACTIONS(73),
    [anon_sym_AMP_AMP] = ACTIONS(75),
    [anon_sym_LT] = ACTIONS(77),
    [anon_sym_LT_EQ] = ACTIONS(79),
    [anon_sym_GT] = ACTIONS(77),
    [anon_sym_GT_EQ] = ACTIONS(79),
    [anon_sym_EQ_EQ] = ACTIONS(79),
    [anon_sym_BANG_EQ] = ACTIONS(79),
    [anon_sym_STAR] = ACTIONS(81),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_STAR_STAR] = ACTIONS(85),
    [anon_sym_CARET] = ACTIONS(85),
    [aux_sym_binary_operator_token1] = ACTIONS(87),
    [anon_sym_PIPE_GT] = ACTIONS(87),
    [anon_sym_COLON] = ACTIONS(89),
    [anon_sym_DOLLAR] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(91),
    [aux_sym__hex_literal_token1] = ACTIONS(371),
    [sym__number_literal] = ACTIONS(373),
    [anon_sym_SQUOTE] = ACTIONS(371),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [sym_return] = ACTIONS(373),
    [sym_next] = ACTIONS(373),
    [sym_break] = ACTIONS(373),
    [sym_true] = ACTIONS(373),
    [sym_false] = ACTIONS(373),
    [sym_null] = ACTIONS(373),
    [sym_inf] = ACTIONS(373),
    [sym_nan] = ACTIONS(373),
    [anon_sym_NA] = ACTIONS(373),
    [anon_sym_NA_integer_] = ACTIONS(373),
    [anon_sym_NA_real_] = ACTIONS(373),
    [anon_sym_NA_complex_] = ACTIONS(373),
    [anon_sym_NA_character_] = ACTIONS(373),
    [sym_dots] = ACTIONS(373),
    [sym_dot_dot_i] = ACTIONS(371),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(371),
    [sym__newline] = ACTIONS(371),
    [sym__raw_string_literal] = ACTIONS(371),
    [sym__external_else] = ACTIONS(371),
    [sym__external_open_parenthesis] = ACTIONS(95),
    [sym__external_open_brace] = ACTIONS(371),
    [sym__external_open_bracket] = ACTIONS(97),
    [sym__external_close_bracket] = ACTIONS(371),
    [sym__external_open_bracket2] = ACTIONS(99),
  },
  [203] = {
    [sym_call_arguments] = STATE(807),
    [sym_subset_arguments] = STATE(808),
    [sym_subset2_arguments] = STATE(810),
    [sym__open_parenthesis] = STATE(357),
    [sym__open_bracket] = STATE(358),
    [sym__open_bracket2] = STATE(359),
    [sym_identifier] = ACTIONS(377),
    [anon_sym_BSLASH] = ACTIONS(375),
    [anon_sym_function] = ACTIONS(377),
    [anon_sym_EQ] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(377),
    [anon_sym_for] = ACTIONS(377),
    [anon_sym_while] = ACTIONS(377),
    [anon_sym_repeat] = ACTIONS(377),
    [anon_sym_QMARK] = ACTIONS(375),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_BANG] = ACTIONS(377),
    [anon_sym_PLUS] = ACTIONS(59),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_LT_DASH] = ACTIONS(63),
    [anon_sym_LT_LT_DASH] = ACTIONS(63),
    [anon_sym_COLON_EQ] = ACTIONS(63),
    [anon_sym_DASH_GT] = ACTIONS(65),
    [anon_sym_DASH_GT_GT] = ACTIONS(67),
    [anon_sym_PIPE] = ACTIONS(69),
    [anon_sym_AMP] = ACTIONS(71),
    [anon_sym_PIPE_PIPE] = ACTIONS(73),
    [anon_sym_AMP_AMP] = ACTIONS(75),
    [anon_sym_LT] = ACTIONS(77),
    [anon_sym_LT_EQ] = ACTIONS(79),
    [anon_sym_GT] = ACTIONS(77),
    [anon_sym_GT_EQ] = ACTIONS(79),
    [anon_sym_EQ_EQ] = ACTIONS(79),
    [anon_sym_BANG_EQ] = ACTIONS(79),
    [anon_sym_STAR] = ACTIONS(81),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_STAR_STAR] = ACTIONS(85),
    [anon_sym_CARET] = ACTIONS(85),
    [aux_sym_binary_operator_token1] = ACTIONS(87),
    [anon_sym_PIPE_GT] = ACTIONS(87),
    [anon_sym_COLON] = ACTIONS(89),
    [anon_sym_DOLLAR] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(91),
    [aux_sym__hex_literal_token1] = ACTIONS(375),
    [sym__number_literal] = ACTIONS(377),
    [anon_sym_SQUOTE] = ACTIONS(375),
    [anon_sym_DQUOTE] = ACTIONS(375),
    [sym_return] = ACTIONS(377),
    [sym_next] = ACTIONS(377),
    [sym_break] = ACTIONS(377),
    [sym_true] = ACTIONS(377),
    [sym_false] = ACTIONS(377),
    [sym_null] = ACTIONS(377),
    [sym_inf] = ACTIONS(377),
    [sym_nan] = ACTIONS(377),
    [anon_sym_NA] = ACTIONS(377),
    [anon_sym_NA_integer_] = ACTIONS(377),
    [anon_sym_NA_real_] = ACTIONS(377),
    [anon_sym_NA_complex_] = ACTIONS(377),
    [anon_sym_NA_character_] = ACTIONS(377),
    [sym_dots] = ACTIONS(377),
    [sym_dot_dot_i] = ACTIONS(375),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(375),
    [sym__newline] = ACTIONS(375),
    [sym__raw_string_literal] = ACTIONS(375),
    [sym__external_else] = ACTIONS(375),
    [sym__external_open_parenthesis] = ACTIONS(95),
    [sym__external_open_brace] = ACTIONS(375),
    [sym__external_open_bracket] = ACTIONS(97),
    [sym__external_close_bracket] = ACTIONS(375),
    [sym__external_open_bracket2] = ACTIONS(99),
  },
  [204] = {
    [sym_call_arguments] = STATE(807),
    [sym_subset_arguments] = STATE(808),
    [sym_subset2_arguments] = STATE(810),
    [sym__open_parenthesis] = STATE(357),
    [sym__open_bracket] = STATE(358),
    [sym__open_bracket2] = STATE(359),
    [sym_identifier] = ACTIONS(381),
    [anon_sym_BSLASH] = ACTIONS(379),
    [anon_sym_function] = ACTIONS(381),
    [anon_sym_EQ] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(381),
    [anon_sym_for] = ACTIONS(381),
    [anon_sym_while] = ACTIONS(381),
    [anon_sym_repeat] = ACTIONS(381),
    [anon_sym_QMARK] = ACTIONS(379),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_BANG] = ACTIONS(381),
    [anon_sym_PLUS] = ACTIONS(59),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_LT_DASH] = ACTIONS(63),
    [anon_sym_LT_LT_DASH] = ACTIONS(63),
    [anon_sym_COLON_EQ] = ACTIONS(63),
    [anon_sym_DASH_GT] = ACTIONS(65),
    [anon_sym_DASH_GT_GT] = ACTIONS(67),
    [anon_sym_PIPE] = ACTIONS(69),
    [anon_sym_AMP] = ACTIONS(71),
    [anon_sym_PIPE_PIPE] = ACTIONS(73),
    [anon_sym_AMP_AMP] = ACTIONS(75),
    [anon_sym_LT] = ACTIONS(77),
    [anon_sym_LT_EQ] = ACTIONS(79),
    [anon_sym_GT] = ACTIONS(77),
    [anon_sym_GT_EQ] = ACTIONS(79),
    [anon_sym_EQ_EQ] = ACTIONS(79),
    [anon_sym_BANG_EQ] = ACTIONS(79),
    [anon_sym_STAR] = ACTIONS(81),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_STAR_STAR] = ACTIONS(85),
    [anon_sym_CARET] = ACTIONS(85),
    [aux_sym_binary_operator_token1] = ACTIONS(87),
    [anon_sym_PIPE_GT] = ACTIONS(87),
    [anon_sym_COLON] = ACTIONS(89),
    [anon_sym_DOLLAR] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(91),
    [aux_sym__hex_literal_token1] = ACTIONS(379),
    [sym__number_literal] = ACTIONS(381),
    [anon_sym_SQUOTE] = ACTIONS(379),
    [anon_sym_DQUOTE] = ACTIONS(379),
    [sym_return] = ACTIONS(381),
    [sym_next] = ACTIONS(381),
    [sym_break] = ACTIONS(381),
    [sym_true] = ACTIONS(381),
    [sym_false] = ACTIONS(381),
    [sym_null] = ACTIONS(381),
    [sym_inf] = ACTIONS(381),
    [sym_nan] = ACTIONS(381),
    [anon_sym_NA] = ACTIONS(381),
    [anon_sym_NA_integer_] = ACTIONS(381),
    [anon_sym_NA_real_] = ACTIONS(381),
    [anon_sym_NA_complex_] = ACTIONS(381),
    [anon_sym_NA_character_] = ACTIONS(381),
    [sym_dots] = ACTIONS(381),
    [sym_dot_dot_i] = ACTIONS(379),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(379),
    [sym__newline] = ACTIONS(379),
    [sym__raw_string_literal] = ACTIONS(379),
    [sym__external_else] = ACTIONS(379),
    [sym__external_open_parenthesis] = ACTIONS(95),
    [sym__external_open_brace] = ACTIONS(379),
    [sym__external_open_bracket] = ACTIONS(97),
    [sym__external_close_bracket] = ACTIONS(379),
    [sym__external_open_bracket2] = ACTIONS(99),
  },
  [205] = {
    [sym_call_arguments] = STATE(807),
    [sym_subset_arguments] = STATE(808),
    [sym_subset2_arguments] = STATE(810),
    [sym__open_parenthesis] = STATE(357),
    [sym__open_bracket] = STATE(358),
    [sym__open_bracket2] = STATE(359),
    [sym_identifier] = ACTIONS(381),
    [anon_sym_BSLASH] = ACTIONS(379),
    [anon_sym_function] = ACTIONS(381),
    [anon_sym_EQ] = ACTIONS(381),
    [anon_sym_if] = ACTIONS(381),
    [anon_sym_for] = ACTIONS(381),
    [anon_sym_while] = ACTIONS(381),
    [anon_sym_repeat] = ACTIONS(381),
    [anon_sym_QMARK] = ACTIONS(379),
    [anon_sym_TILDE] = ACTIONS(379),
    [anon_sym_BANG] = ACTIONS(381),
    [anon_sym_PLUS] = ACTIONS(59),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_LT_DASH] = ACTIONS(379),
    [anon_sym_LT_LT_DASH] = ACTIONS(379),
    [anon_sym_COLON_EQ] = ACTIONS(379),
    [anon_sym_DASH_GT] = ACTIONS(381),
    [anon_sym_DASH_GT_GT] = ACTIONS(379),
    [anon_sym_PIPE] = ACTIONS(69),
    [anon_sym_AMP] = ACTIONS(71),
    [anon_sym_PIPE_PIPE] = ACTIONS(73),
    [anon_sym_AMP_AMP] = ACTIONS(75),
    [anon_sym_LT] = ACTIONS(77),
    [anon_sym_LT_EQ] = ACTIONS(79),
    [anon_sym_GT] = ACTIONS(77),
    [anon_sym_GT_EQ] = ACTIONS(79),
    [anon_sym_EQ_EQ] = ACTIONS(79),
    [anon_sym_BANG_EQ] = ACTIONS(79),
    [anon_sym_STAR] = ACTIONS(81),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_STAR_STAR] = ACTIONS(85),
    [anon_sym_CARET] = ACTIONS(85),
    [aux_sym_binary_operator_token1] = ACTIONS(87),
    [anon_sym_PIPE_GT] = ACTIONS(87),
    [anon_sym_COLON] = ACTIONS(89),
    [anon_sym_DOLLAR] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(91),
    [aux_sym__hex_literal_token1] = ACTIONS(379),
    [sym__number_literal] = ACTIONS(381),
    [anon_sym_SQUOTE] = ACTIONS(379),
    [anon_sym_DQUOTE] = ACTIONS(379),
    [sym_return] = ACTIONS(381),
    [sym_next] = ACTIONS(381),
    [sym_break] = ACTIONS(381),
    [sym_true] = ACTIONS(381),
    [sym_false] = ACTIONS(381),
    [sym_null] = ACTIONS(381),
    [sym_inf] = ACTIONS(381),
    [sym_nan] = ACTIONS(381),
    [anon_sym_NA] = ACTIONS(381),
    [anon_sym_NA_integer_] = ACTIONS(381),
    [anon_sym_NA_real_] = ACTIONS(381),
    [anon_sym_NA_complex_] = ACTIONS(381),
    [anon_sym_NA_character_] = ACTIONS(381),
    [sym_dots] = ACTIONS(381),
    [sym_dot_dot_i] = ACTIONS(379),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(379),
    [sym__newline] = ACTIONS(379),
    [sym__raw_string_literal] = ACTIONS(379),
    [sym__external_else] = ACTIONS(379),
    [sym__external_open_parenthesis] = ACTIONS(95),
    [sym__external_open_brace] = ACTIONS(379),
    [sym__external_open_bracket] = ACTIONS(97),
    [sym__external_close_bracket] = ACTIONS(379),
    [sym__external_open_bracket2] = ACTIONS(99),
  },
  [206] = {
    [sym_call_arguments] = STATE(807),
    [sym_subset_arguments] = STATE(808),
    [sym_subset2_arguments] = STATE(810),
    [sym__open_parenthesis] = STATE(357),
    [sym__open_bracket] = STATE(358),
    [sym__open_bracket2] = STATE(359),
    [sym_identifier] = ACTIONS(381),
    [anon_sym_BSLASH] = ACTIONS(379),
    [anon_sym_function] = ACTIONS(381),
    [anon_sym_EQ] = ACTIONS(381),
    [anon_sym_if] = ACTIONS(381),
    [anon_sym_for] = ACTIONS(381),
    [anon_sym_while] = ACTIONS(381),
    [anon_sym_repeat] = ACTIONS(381),
    [anon_sym_QMARK] = ACTIONS(379),
    [anon_sym_TILDE] = ACTIONS(379),
    [anon_sym_BANG] = ACTIONS(381),
    [anon_sym_PLUS] = ACTIONS(59),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_LT_DASH] = ACTIONS(379),
    [anon_sym_LT_LT_DASH] = ACTIONS(379),
    [anon_sym_COLON_EQ] = ACTIONS(379),
    [anon_sym_DASH_GT] = ACTIONS(381),
    [anon_sym_DASH_GT_GT] = ACTIONS(379),
    [anon_sym_PIPE] = ACTIONS(381),
    [anon_sym_AMP] = ACTIONS(381),
    [anon_sym_PIPE_PIPE] = ACTIONS(379),
    [anon_sym_AMP_AMP] = ACTIONS(379),
    [anon_sym_LT] = ACTIONS(77),
    [anon_sym_LT_EQ] = ACTIONS(79),
    [anon_sym_GT] = ACTIONS(77),
    [anon_sym_GT_EQ] = ACTIONS(79),
    [anon_sym_EQ_EQ] = ACTIONS(79),
    [anon_sym_BANG_EQ] = ACTIONS(79),
    [anon_sym_STAR] = ACTIONS(81),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_STAR_STAR] = ACTIONS(85),
    [anon_sym_CARET] = ACTIONS(85),
    [aux_sym_binary_operator_token1] = ACTIONS(87),
    [anon_sym_PIPE_GT] = ACTIONS(87),
    [anon_sym_COLON] = ACTIONS(89),
    [anon_sym_DOLLAR] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(91),
    [aux_sym__hex_literal_token1] = ACTIONS(379),
    [sym__number_literal] = ACTIONS(381),
    [anon_sym_SQUOTE] = ACTIONS(379),
    [anon_sym_DQUOTE] = ACTIONS(379),
    [sym_return] = ACTIONS(381),
    [sym_next] = ACTIONS(381),
    [sym_break] = ACTIONS(381),
    [sym_true] = ACTIONS(381),
    [sym_false] = ACTIONS(381),
    [sym_null] = ACTIONS(381),
    [sym_inf] = ACTIONS(381),
    [sym_nan] = ACTIONS(381),
    [anon_sym_NA] = ACTIONS(381),
    [anon_sym_NA_integer_] = ACTIONS(381),
    [anon_sym_NA_real_] = ACTIONS(381),
    [anon_sym_NA_complex_] = ACTIONS(381),
    [anon_sym_NA_character_] = ACTIONS(381),
    [sym_dots] = ACTIONS(381),
    [sym_dot_dot_i] = ACTIONS(379),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(379),
    [sym__newline] = ACTIONS(379),
    [sym__raw_string_literal] = ACTIONS(379),
    [sym__external_else] = ACTIONS(379),
    [sym__external_open_parenthesis] = ACTIONS(95),
    [sym__external_open_brace] = ACTIONS(379),
    [sym__external_open_bracket] = ACTIONS(97),
    [sym__external_close_bracket] = ACTIONS(379),
    [sym__external_open_bracket2] = ACTIONS(99),
  },
  [207] = {
    [sym_call_arguments] = STATE(807),
    [sym_subset_arguments] = STATE(808),
    [sym_subset2_arguments] = STATE(810),
    [sym__open_parenthesis] = STATE(357),
    [sym__open_bracket] = STATE(358),
    [sym__open_bracket2] = STATE(359),
    [sym_identifier] = ACTIONS(381),
    [anon_sym_BSLASH] = ACTIONS(379),
    [anon_sym_function] = ACTIONS(381),
    [anon_sym_EQ] = ACTIONS(381),
    [anon_sym_if] = ACTIONS(381),
    [anon_sym_for] = ACTIONS(381),
    [anon_sym_while] = ACTIONS(381),
    [anon_sym_repeat] = ACTIONS(381),
    [anon_sym_QMARK] = ACTIONS(379),
    [anon_sym_TILDE] = ACTIONS(379),
    [anon_sym_BANG] = ACTIONS(381),
    [anon_sym_PLUS] = ACTIONS(379),
    [anon_sym_DASH] = ACTIONS(381),
    [anon_sym_LT_DASH] = ACTIONS(379),
    [anon_sym_LT_LT_DASH] = ACTIONS(379),
    [anon_sym_COLON_EQ] = ACTIONS(379),
    [anon_sym_DASH_GT] = ACTIONS(381),
    [anon_sym_DASH_GT_GT] = ACTIONS(379),
    [anon_sym_PIPE] = ACTIONS(381),
    [anon_sym_AMP] = ACTIONS(381),
    [anon_sym_PIPE_PIPE] = ACTIONS(379),
    [anon_sym_AMP_AMP] = ACTIONS(379),
    [anon_sym_LT] = ACTIONS(381),
    [anon_sym_LT_EQ] = ACTIONS(379),
    [anon_sym_GT] = ACTIONS(381),
    [anon_sym_GT_EQ] = ACTIONS(379),
    [anon_sym_EQ_EQ] = ACTIONS(379),
    [anon_sym_BANG_EQ] = ACTIONS(379),
    [anon_sym_STAR] = ACTIONS(381),
    [anon_sym_SLASH] = ACTIONS(379),
    [anon_sym_STAR_STAR] = ACTIONS(85),
    [anon_sym_CARET] = ACTIONS(85),
    [aux_sym_binary_operator_token1] = ACTIONS(379),
    [anon_sym_PIPE_GT] = ACTIONS(379),
    [anon_sym_COLON] = ACTIONS(381),
    [anon_sym_DOLLAR] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(91),
    [aux_sym__hex_literal_token1] = ACTIONS(379),
    [sym__number_literal] = ACTIONS(381),
    [anon_sym_SQUOTE] = ACTIONS(379),
    [anon_sym_DQUOTE] = ACTIONS(379),
    [sym_return] = ACTIONS(381),
    [sym_next] = ACTIONS(381),
    [sym_break] = ACTIONS(381),
    [sym_true] = ACTIONS(381),
    [sym_false] = ACTIONS(381),
    [sym_null] = ACTIONS(381),
    [sym_inf] = ACTIONS(381),
    [sym_nan] = ACTIONS(381),
    [anon_sym_NA] = ACTIONS(381),
    [anon_sym_NA_integer_] = ACTIONS(381),
    [anon_sym_NA_real_] = ACTIONS(381),
    [anon_sym_NA_complex_] = ACTIONS(381),
    [anon_sym_NA_character_] = ACTIONS(381),
    [sym_dots] = ACTIONS(381),
    [sym_dot_dot_i] = ACTIONS(379),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(379),
    [sym__newline] = ACTIONS(379),
    [sym__raw_string_literal] = ACTIONS(379),
    [sym__external_else] = ACTIONS(379),
    [sym__external_open_parenthesis] = ACTIONS(95),
    [sym__external_open_brace] = ACTIONS(379),
    [sym__external_open_bracket] = ACTIONS(97),
    [sym__external_close_bracket] = ACTIONS(379),
    [sym__external_open_bracket2] = ACTIONS(99),
  },
  [208] = {
    [sym_call_arguments] = STATE(807),
    [sym_subset_arguments] = STATE(808),
    [sym_subset2_arguments] = STATE(810),
    [sym__open_parenthesis] = STATE(357),
    [sym__open_bracket] = STATE(358),
    [sym__open_bracket2] = STATE(359),
    [sym_identifier] = ACTIONS(385),
    [anon_sym_BSLASH] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_EQ] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_for] = ACTIONS(385),
    [anon_sym_while] = ACTIONS(385),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_QMARK] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_BANG] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(59),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_LT_DASH] = ACTIONS(383),
    [anon_sym_LT_LT_DASH] = ACTIONS(383),
    [anon_sym_COLON_EQ] = ACTIONS(383),
    [anon_sym_DASH_GT] = ACTIONS(65),
    [anon_sym_DASH_GT_GT] = ACTIONS(67),
    [anon_sym_PIPE] = ACTIONS(69),
    [anon_sym_AMP] = ACTIONS(71),
    [anon_sym_PIPE_PIPE] = ACTIONS(73),
    [anon_sym_AMP_AMP] = ACTIONS(75),
    [anon_sym_LT] = ACTIONS(77),
    [anon_sym_LT_EQ] = ACTIONS(79),
    [anon_sym_GT] = ACTIONS(77),
    [anon_sym_GT_EQ] = ACTIONS(79),
    [anon_sym_EQ_EQ] = ACTIONS(79),
    [anon_sym_BANG_EQ] = ACTIONS(79),
    [anon_sym_STAR] = ACTIONS(81),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_STAR_STAR] = ACTIONS(85),
    [anon_sym_CARET] = ACTIONS(85),
    [aux_sym_binary_operator_token1] = ACTIONS(87),
    [anon_sym_PIPE_GT] = ACTIONS(87),
    [anon_sym_COLON] = ACTIONS(89),
    [anon_sym_DOLLAR] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(91),
    [aux_sym__hex_literal_token1] = ACTIONS(383),
    [sym__number_literal] = ACTIONS(385),
    [anon_sym_SQUOTE] = ACTIONS(383),
    [anon_sym_DQUOTE] = ACTIONS(383),
    [sym_return] = ACTIONS(385),
    [sym_next] = ACTIONS(385),
    [sym_break] = ACTIONS(385),
    [sym_true] = ACTIONS(385),
    [sym_false] = ACTIONS(385),
    [sym_null] = ACTIONS(385),
    [sym_inf] = ACTIONS(385),
    [sym_nan] = ACTIONS(385),
    [anon_sym_NA] = ACTIONS(385),
    [anon_sym_NA_integer_] = ACTIONS(385),
    [anon_sym_NA_real_] = ACTIONS(385),
    [anon_sym_NA_complex_] = ACTIONS(385),
    [anon_sym_NA_character_] = ACTIONS(385),
    [sym_dots] = ACTIONS(385),
    [sym_dot_dot_i] = ACTIONS(383),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(383),
    [sym__newline] = ACTIONS(383),
    [sym__raw_string_literal] = ACTIONS(383),
    [sym__external_else] = ACTIONS(383),
    [sym__external_open_parenthesis] = ACTIONS(95),
    [sym__external_open_brace] = ACTIONS(383),
    [sym__external_open_bracket] = ACTIONS(97),
    [sym__external_close_bracket] = ACTIONS(383),
    [sym__external_open_bracket2] = ACTIONS(99),
  },
  [209] = {
    [sym_call_arguments] = STATE(807),
    [sym_subset_arguments] = STATE(808),
    [sym_subset2_arguments] = STATE(810),
    [sym__open_parenthesis] = STATE(357),
    [sym__open_bracket] = STATE(358),
    [sym__open_bracket2] = STATE(359),
    [sym_identifier] = ACTIONS(385),
    [anon_sym_BSLASH] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_EQ] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_for] = ACTIONS(385),
    [anon_sym_while] = ACTIONS(385),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_QMARK] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_BANG] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(59),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_LT_DASH] = ACTIONS(63),
    [anon_sym_LT_LT_DASH] = ACTIONS(63),
    [anon_sym_COLON_EQ] = ACTIONS(63),
    [anon_sym_DASH_GT] = ACTIONS(65),
    [anon_sym_DASH_GT_GT] = ACTIONS(67),
    [anon_sym_PIPE] = ACTIONS(69),
    [anon_sym_AMP] = ACTIONS(71),
    [anon_sym_PIPE_PIPE] = ACTIONS(73),
    [anon_sym_AMP_AMP] = ACTIONS(75),
    [anon_sym_LT] = ACTIONS(77),
    [anon_sym_LT_EQ] = ACTIONS(79),
    [anon_sym_GT] = ACTIONS(77),
    [anon_sym_GT_EQ] = ACTIONS(79),
    [anon_sym_EQ_EQ] = ACTIONS(79),
    [anon_sym_BANG_EQ] = ACTIONS(79),
    [anon_sym_STAR] = ACTIONS(81),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_STAR_STAR] = ACTIONS(85),
    [anon_sym_CARET] = ACTIONS(85),
    [aux_sym_binary_operator_token1] = ACTIONS(87),
    [anon_sym_PIPE_GT] = ACTIONS(87),
    [anon_sym_COLON] = ACTIONS(89),
    [anon_sym_DOLLAR] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(91),
    [aux_sym__hex_literal_token1] = ACTIONS(383),
    [sym__number_literal] = ACTIONS(385),
    [anon_sym_SQUOTE] = ACTIONS(383),
    [anon_sym_DQUOTE] = ACTIONS(383),
    [sym_return] = ACTIONS(385),
    [sym_next] = ACTIONS(385),
    [sym_break] = ACTIONS(385),
    [sym_true] = ACTIONS(385),
    [sym_false] = ACTIONS(385),
    [sym_null] = ACTIONS(385),
    [sym_inf] = ACTIONS(385),
    [sym_nan] = ACTIONS(385),
    [anon_sym_NA] = ACTIONS(385),
    [anon_sym_NA_integer_] = ACTIONS(385),
    [anon_sym_NA_real_] = ACTIONS(385),
    [anon_sym_NA_complex_] = ACTIONS(385),
    [anon_sym_NA_character_] = ACTIONS(385),
    [sym_dots] = ACTIONS(385),
    [sym_dot_dot_i] = ACTIONS(383),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(383),
    [sym__newline] = ACTIONS(383),
    [sym__raw_string_literal] = ACTIONS(383),
    [sym__external_else] = ACTIONS(383),
    [sym__external_open_parenthesis] = ACTIONS(95),
    [sym__external_open_brace] = ACTIONS(383),
    [sym__external_open_bracket] = ACTIONS(97),
    [sym__external_close_bracket] = ACTIONS(383),
    [sym__external_open_bracket2] = ACTIONS(99),
  },
  [210] = {
    [sym_call_arguments] = STATE(807),
    [sym_subset_arguments] = STATE(808),
    [sym_subset2_arguments] = STATE(810),
    [sym__open_parenthesis] = STATE(357),
    [sym__open_bracket] = STATE(358),
    [sym__open_bracket2] = STATE(359),
    [sym_identifier] = ACTIONS(385),
    [anon_sym_BSLASH] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_EQ] = ACTIONS(385),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_for] = ACTIONS(385),
    [anon_sym_while] = ACTIONS(385),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_QMARK] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(383),
    [anon_sym_BANG] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(59),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_LT_DASH] = ACTIONS(383),
    [anon_sym_LT_LT_DASH] = ACTIONS(383),
    [anon_sym_COLON_EQ] = ACTIONS(383),
    [anon_sym_DASH_GT] = ACTIONS(385),
    [anon_sym_DASH_GT_GT] = ACTIONS(383),
    [anon_sym_PIPE] = ACTIONS(69),
    [anon_sym_AMP] = ACTIONS(71),
    [anon_sym_PIPE_PIPE] = ACTIONS(73),
    [anon_sym_AMP_AMP] = ACTIONS(75),
    [anon_sym_LT] = ACTIONS(77),
    [anon_sym_LT_EQ] = ACTIONS(79),
    [anon_sym_GT] = ACTIONS(77),
    [anon_sym_GT_EQ] = ACTIONS(79),
    [anon_sym_EQ_EQ] = ACTIONS(79),
    [anon_sym_BANG_EQ] = ACTIONS(79),
    [anon_sym_STAR] = ACTIONS(81),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_STAR_STAR] = ACTIONS(85),
    [anon_sym_CARET] = ACTIONS(85),
    [aux_sym_binary_operator_token1] = ACTIONS(87),
    [anon_sym_PIPE_GT] = ACTIONS(87),
    [anon_sym_COLON] = ACTIONS(89),
    [anon_sym_DOLLAR] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(91),
    [aux_sym__hex_literal_token1] = ACTIONS(383),
    [sym__number_literal] = ACTIONS(385),
    [anon_sym_SQUOTE] = ACTIONS(383),
    [anon_sym_DQUOTE] = ACTIONS(383),
    [sym_return] = ACTIONS(385),
    [sym_next] = ACTIONS(385),
    [sym_break] = ACTIONS(385),
    [sym_true] = ACTIONS(385),
    [sym_false] = ACTIONS(385),
    [sym_null] = ACTIONS(385),
    [sym_inf] = ACTIONS(385),
    [sym_nan] = ACTIONS(385),
    [anon_sym_NA] = ACTIONS(385),
    [anon_sym_NA_integer_] = ACTIONS(385),
    [anon_sym_NA_real_] = ACTIONS(385),
    [anon_sym_NA_complex_] = ACTIONS(385),
    [anon_sym_NA_character_] = ACTIONS(385),
    [sym_dots] = ACTIONS(385),
    [sym_dot_dot_i] = ACTIONS(383),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(383),
    [sym__newline] = ACTIONS(383),
    [sym__raw_string_literal] = ACTIONS(383),
    [sym__external_else] = ACTIONS(383),
    [sym__external_open_parenthesis] = ACTIONS(95),
    [sym__external_open_brace] = ACTIONS(383),
    [sym__external_open_bracket] = ACTIONS(97),
    [sym__external_close_bracket] = ACTIONS(383),
    [sym__external_open_bracket2] = ACTIONS(99),
  },
  [211] = {
    [sym_call_arguments] = STATE(807),
    [sym_subset_arguments] = STATE(808),
    [sym_subset2_arguments] = STATE(810),
    [sym__open_parenthesis] = STATE(357),
    [sym__open_bracket] = STATE(358),
    [sym__open_bracket2] = STATE(359),
    [sym_identifier] = ACTIONS(385),
    [anon_sym_BSLASH] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_EQ] = ACTIONS(385),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_for] = ACTIONS(385),
    [anon_sym_while] = ACTIONS(385),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_QMARK] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(383),
    [anon_sym_BANG] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(385),
    [anon_sym_LT_DASH] = ACTIONS(383),
    [anon_sym_LT_LT_DASH] = ACTIONS(383),
    [anon_sym_COLON_EQ] = ACTIONS(383),
    [anon_sym_DASH_GT] = ACTIONS(385),
    [anon_sym_DASH_GT_GT] = ACTIONS(383),
    [anon_sym_PIPE] = ACTIONS(385),
    [anon_sym_AMP] = ACTIONS(385),
    [anon_sym_PIPE_PIPE] = ACTIONS(383),
    [anon_sym_AMP_AMP] = ACTIONS(383),
    [anon_sym_LT] = ACTIONS(385),
    [anon_sym_LT_EQ] = ACTIONS(383),
    [anon_sym_GT] = ACTIONS(385),
    [anon_sym_GT_EQ] = ACTIONS(383),
    [anon_sym_EQ_EQ] = ACTIONS(383),
    [anon_sym_BANG_EQ] = ACTIONS(383),
    [anon_sym_STAR] = ACTIONS(81),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_STAR_STAR] = ACTIONS(85),
    [anon_sym_CARET] = ACTIONS(85),
    [aux_sym_binary_operator_token1] = ACTIONS(87),
    [anon_sym_PIPE_GT] = ACTIONS(87),
    [anon_sym_COLON] = ACTIONS(89),
    [anon_sym_DOLLAR] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(91),
    [aux_sym__hex_literal_token1] = ACTIONS(383),
    [sym__number_literal] = ACTIONS(385),
    [anon_sym_SQUOTE] = ACTIONS(383),
    [anon_sym_DQUOTE] = ACTIONS(383),
    [sym_return] = ACTIONS(385),
    [sym_next] = ACTIONS(385),
    [sym_break] = ACTIONS(385),
    [sym_true] = ACTIONS(385),
    [sym_false] = ACTIONS(385),
    [sym_null] = ACTIONS(385),
    [sym_inf] = ACTIONS(385),
    [sym_nan] = ACTIONS(385),
    [anon_sym_NA] = ACTIONS(385),
    [anon_sym_NA_integer_] = ACTIONS(385),
    [anon_sym_NA_real_] = ACTIONS(385),
    [anon_sym_NA_complex_] = ACTIONS(385),
    [anon_sym_NA_character_] = ACTIONS(385),
    [sym_dots] = ACTIONS(385),
    [sym_dot_dot_i] = ACTIONS(383),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(383),
    [sym__newline] = ACTIONS(383),
    [sym__raw_string_literal] = ACTIONS(383),
    [sym__external_else] = ACTIONS(383),
    [sym__external_open_parenthesis] = ACTIONS(95),
    [sym__external_open_brace] = ACTIONS(383),
    [sym__external_open_bracket] = ACTIONS(97),
    [sym__external_close_bracket] = ACTIONS(383),
    [sym__external_open_bracket2] = ACTIONS(99),
  },
  [212] = {
    [sym_call_arguments] = STATE(807),
    [sym_subset_arguments] = STATE(808),
    [sym_subset2_arguments] = STATE(810),
    [sym__open_parenthesis] = STATE(357),
    [sym__open_bracket] = STATE(358),
    [sym__open_bracket2] = STATE(359),
    [sym_identifier] = ACTIONS(385),
    [anon_sym_BSLASH] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_EQ] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_for] = ACTIONS(385),
    [anon_sym_while] = ACTIONS(385),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_QMARK] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_BANG] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(59),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_LT_DASH] = ACTIONS(63),
    [anon_sym_LT_LT_DASH] = ACTIONS(63),
    [anon_sym_COLON_EQ] = ACTIONS(63),
    [anon_sym_DASH_GT] = ACTIONS(65),
    [anon_sym_DASH_GT_GT] = ACTIONS(67),
    [anon_sym_PIPE] = ACTIONS(69),
    [anon_sym_AMP] = ACTIONS(71),
    [anon_sym_PIPE_PIPE] = ACTIONS(73),
    [anon_sym_AMP_AMP] = ACTIONS(75),
    [anon_sym_LT] = ACTIONS(77),
    [anon_sym_LT_EQ] = ACTIONS(79),
    [anon_sym_GT] = ACTIONS(77),
    [anon_sym_GT_EQ] = ACTIONS(79),
    [anon_sym_EQ_EQ] = ACTIONS(79),
    [anon_sym_BANG_EQ] = ACTIONS(79),
    [anon_sym_STAR] = ACTIONS(81),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_STAR_STAR] = ACTIONS(85),
    [anon_sym_CARET] = ACTIONS(85),
    [aux_sym_binary_operator_token1] = ACTIONS(87),
    [anon_sym_PIPE_GT] = ACTIONS(87),
    [anon_sym_COLON] = ACTIONS(89),
    [anon_sym_DOLLAR] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(91),
    [aux_sym__hex_literal_token1] = ACTIONS(383),
    [sym__number_literal] = ACTIONS(385),
    [anon_sym_SQUOTE] = ACTIONS(383),
    [anon_sym_DQUOTE] = ACTIONS(383),
    [sym_return] = ACTIONS(385),
    [sym_next] = ACTIONS(385),
    [sym_break] = ACTIONS(385),
    [sym_true] = ACTIONS(385),
    [sym_false] = ACTIONS(385),
    [sym_null] = ACTIONS(385),
    [sym_inf] = ACTIONS(385),
    [sym_nan] = ACTIONS(385),
    [anon_sym_NA] = ACTIONS(385),
    [anon_sym_NA_integer_] = ACTIONS(385),
    [anon_sym_NA_real_] = ACTIONS(385),
    [anon_sym_NA_complex_] = ACTIONS(385),
    [anon_sym_NA_character_] = ACTIONS(385),
    [sym_dots] = ACTIONS(385),
    [sym_dot_dot_i] = ACTIONS(383),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(383),
    [sym__newline] = ACTIONS(383),
    [sym__raw_string_literal] = ACTIONS(383),
    [sym__external_else] = ACTIONS(383),
    [sym__external_open_parenthesis] = ACTIONS(95),
    [sym__external_open_brace] = ACTIONS(383),
    [sym__external_open_bracket] = ACTIONS(97),
    [sym__external_close_bracket] = ACTIONS(383),
    [sym__external_open_bracket2] = ACTIONS(99),
  },
  [213] = {
    [sym_call_arguments] = STATE(807),
    [sym_subset_arguments] = STATE(808),
    [sym_subset2_arguments] = STATE(810),
    [sym__open_parenthesis] = STATE(357),
    [sym__open_bracket] = STATE(358),
    [sym__open_bracket2] = STATE(359),
    [sym_identifier] = ACTIONS(385),
    [anon_sym_BSLASH] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_EQ] = ACTIONS(385),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_for] = ACTIONS(385),
    [anon_sym_while] = ACTIONS(385),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_QMARK] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_BANG] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(59),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_LT_DASH] = ACTIONS(383),
    [anon_sym_LT_LT_DASH] = ACTIONS(383),
    [anon_sym_COLON_EQ] = ACTIONS(383),
    [anon_sym_DASH_GT] = ACTIONS(385),
    [anon_sym_DASH_GT_GT] = ACTIONS(383),
    [anon_sym_PIPE] = ACTIONS(69),
    [anon_sym_AMP] = ACTIONS(71),
    [anon_sym_PIPE_PIPE] = ACTIONS(73),
    [anon_sym_AMP_AMP] = ACTIONS(75),
    [anon_sym_LT] = ACTIONS(77),
    [anon_sym_LT_EQ] = ACTIONS(79),
    [anon_sym_GT] = ACTIONS(77),
    [anon_sym_GT_EQ] = ACTIONS(79),
    [anon_sym_EQ_EQ] = ACTIONS(79),
    [anon_sym_BANG_EQ] = ACTIONS(79),
    [anon_sym_STAR] = ACTIONS(81),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_STAR_STAR] = ACTIONS(85),
    [anon_sym_CARET] = ACTIONS(85),
    [aux_sym_binary_operator_token1] = ACTIONS(87),
    [anon_sym_PIPE_GT] = ACTIONS(87),
    [anon_sym_COLON] = ACTIONS(89),
    [anon_sym_DOLLAR] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(91),
    [aux_sym__hex_literal_token1] = ACTIONS(383),
    [sym__number_literal] = ACTIONS(385),
    [anon_sym_SQUOTE] = ACTIONS(383),
    [anon_sym_DQUOTE] = ACTIONS(383),
    [sym_return] = ACTIONS(385),
    [sym_next] = ACTIONS(385),
    [sym_break] = ACTIONS(385),
    [sym_true] = ACTIONS(385),
    [sym_false] = ACTIONS(385),
    [sym_null] = ACTIONS(385),
    [sym_inf] = ACTIONS(385),
    [sym_nan] = ACTIONS(385),
    [anon_sym_NA] = ACTIONS(385),
    [anon_sym_NA_integer_] = ACTIONS(385),
    [anon_sym_NA_real_] = ACTIONS(385),
    [anon_sym_NA_complex_] = ACTIONS(385),
    [anon_sym_NA_character_] = ACTIONS(385),
    [sym_dots] = ACTIONS(385),
    [sym_dot_dot_i] = ACTIONS(383),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(383),
    [sym__newline] = ACTIONS(383),
    [sym__raw_string_literal] = ACTIONS(383),
    [sym__external_else] = ACTIONS(383),
    [sym__external_open_parenthesis] = ACTIONS(95),
    [sym__external_open_brace] = ACTIONS(383),
    [sym__external_open_bracket] = ACTIONS(97),
    [sym__external_close_bracket] = ACTIONS(383),
    [sym__external_open_bracket2] = ACTIONS(99),
  },
  [214] = {
    [sym_call_arguments] = STATE(807),
    [sym_subset_arguments] = STATE(808),
    [sym_subset2_arguments] = STATE(810),
    [sym__open_parenthesis] = STATE(357),
    [sym__open_bracket] = STATE(358),
    [sym__open_bracket2] = STATE(359),
    [sym_identifier] = ACTIONS(385),
    [anon_sym_BSLASH] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_EQ] = ACTIONS(385),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_for] = ACTIONS(385),
    [anon_sym_while] = ACTIONS(385),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_QMARK] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(383),
    [anon_sym_BANG] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(59),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_LT_DASH] = ACTIONS(383),
    [anon_sym_LT_LT_DASH] = ACTIONS(383),
    [anon_sym_COLON_EQ] = ACTIONS(383),
    [anon_sym_DASH_GT] = ACTIONS(385),
    [anon_sym_DASH_GT_GT] = ACTIONS(383),
    [anon_sym_PIPE] = ACTIONS(385),
    [anon_sym_AMP] = ACTIONS(71),
    [anon_sym_PIPE_PIPE] = ACTIONS(383),
    [anon_sym_AMP_AMP] = ACTIONS(75),
    [anon_sym_LT] = ACTIONS(77),
    [anon_sym_LT_EQ] = ACTIONS(79),
    [anon_sym_GT] = ACTIONS(77),
    [anon_sym_GT_EQ] = ACTIONS(79),
    [anon_sym_EQ_EQ] = ACTIONS(79),
    [anon_sym_BANG_EQ] = ACTIONS(79),
    [anon_sym_STAR] = ACTIONS(81),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_STAR_STAR] = ACTIONS(85),
    [anon_sym_CARET] = ACTIONS(85),
    [aux_sym_binary_operator_token1] = ACTIONS(87),
    [anon_sym_PIPE_GT] = ACTIONS(87),
    [anon_sym_COLON] = ACTIONS(89),
    [anon_sym_DOLLAR] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(91),
    [aux_sym__hex_literal_token1] = ACTIONS(383),
    [sym__number_literal] = ACTIONS(385),
    [anon_sym_SQUOTE] = ACTIONS(383),
    [anon_sym_DQUOTE] = ACTIONS(383),
    [sym_return] = ACTIONS(385),
    [sym_next] = ACTIONS(385),
    [sym_break] = ACTIONS(385),
    [sym_true] = ACTIONS(385),
    [sym_false] = ACTIONS(385),
    [sym_null] = ACTIONS(385),
    [sym_inf] = ACTIONS(385),
    [sym_nan] = ACTIONS(385),
    [anon_sym_NA] = ACTIONS(385),
    [anon_sym_NA_integer_] = ACTIONS(385),
    [anon_sym_NA_real_] = ACTIONS(385),
    [anon_sym_NA_complex_] = ACTIONS(385),
    [anon_sym_NA_character_] = ACTIONS(385),
    [sym_dots] = ACTIONS(385),
    [sym_dot_dot_i] = ACTIONS(383),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(383),
    [sym__newline] = ACTIONS(383),
    [sym__raw_string_literal] = ACTIONS(383),
    [sym__external_else] = ACTIONS(383),
    [sym__external_open_parenthesis] = ACTIONS(95),
    [sym__external_open_brace] = ACTIONS(383),
    [sym__external_open_bracket] = ACTIONS(97),
    [sym__external_close_bracket] = ACTIONS(383),
    [sym__external_open_bracket2] = ACTIONS(99),
  },
  [215] = {
    [sym_call_arguments] = STATE(807),
    [sym_subset_arguments] = STATE(808),
    [sym_subset2_arguments] = STATE(810),
    [sym__open_parenthesis] = STATE(357),
    [sym__open_bracket] = STATE(358),
    [sym__open_bracket2] = STATE(359),
    [sym_identifier] = ACTIONS(385),
    [anon_sym_BSLASH] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_EQ] = ACTIONS(385),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_for] = ACTIONS(385),
    [anon_sym_while] = ACTIONS(385),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_QMARK] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(383),
    [anon_sym_BANG] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(59),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_LT_DASH] = ACTIONS(383),
    [anon_sym_LT_LT_DASH] = ACTIONS(383),
    [anon_sym_COLON_EQ] = ACTIONS(383),
    [anon_sym_DASH_GT] = ACTIONS(385),
    [anon_sym_DASH_GT_GT] = ACTIONS(383),
    [anon_sym_PIPE] = ACTIONS(385),
    [anon_sym_AMP] = ACTIONS(385),
    [anon_sym_PIPE_PIPE] = ACTIONS(383),
    [anon_sym_AMP_AMP] = ACTIONS(383),
    [anon_sym_LT] = ACTIONS(77),
    [anon_sym_LT_EQ] = ACTIONS(79),
    [anon_sym_GT] = ACTIONS(77),
    [anon_sym_GT_EQ] = ACTIONS(79),
    [anon_sym_EQ_EQ] = ACTIONS(79),
    [anon_sym_BANG_EQ] = ACTIONS(79),
    [anon_sym_STAR] = ACTIONS(81),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_STAR_STAR] = ACTIONS(85),
    [anon_sym_CARET] = ACTIONS(85),
    [aux_sym_binary_operator_token1] = ACTIONS(87),
    [anon_sym_PIPE_GT] = ACTIONS(87),
    [anon_sym_COLON] = ACTIONS(89),
    [anon_sym_DOLLAR] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(91),
    [aux_sym__hex_literal_token1] = ACTIONS(383),
    [sym__number_literal] = ACTIONS(385),
    [anon_sym_SQUOTE] = ACTIONS(383),
    [anon_sym_DQUOTE] = ACTIONS(383),
    [sym_return] = ACTIONS(385),
    [sym_next] = ACTIONS(385),
    [sym_break] = ACTIONS(385),
    [sym_true] = ACTIONS(385),
    [sym_false] = ACTIONS(385),
    [sym_null] = ACTIONS(385),
    [sym_inf] = ACTIONS(385),
    [sym_nan] = ACTIONS(385),
    [anon_sym_NA] = ACTIONS(385),
    [anon_sym_NA_integer_] = ACTIONS(385),
    [anon_sym_NA_real_] = ACTIONS(385),
    [anon_sym_NA_complex_] = ACTIONS(385),
    [anon_sym_NA_character_] = ACTIONS(385),
    [sym_dots] = ACTIONS(385),
    [sym_dot_dot_i] = ACTIONS(383),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(383),
    [sym__newline] = ACTIONS(383),
    [sym__raw_string_literal] = ACTIONS(383),
    [sym__external_else] = ACTIONS(383),
    [sym__external_open_parenthesis] = ACTIONS(95),
    [sym__external_open_brace] = ACTIONS(383),
    [sym__external_open_bracket] = ACTIONS(97),
    [sym__external_close_bracket] = ACTIONS(383),
    [sym__external_open_bracket2] = ACTIONS(99),
  },
  [216] = {
    [sym_call_arguments] = STATE(807),
    [sym_subset_arguments] = STATE(808),
    [sym_subset2_arguments] = STATE(810),
    [sym__open_parenthesis] = STATE(357),
    [sym__open_bracket] = STATE(358),
    [sym__open_bracket2] = STATE(359),
    [sym_identifier] = ACTIONS(385),
    [anon_sym_BSLASH] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_EQ] = ACTIONS(385),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_for] = ACTIONS(385),
    [anon_sym_while] = ACTIONS(385),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_QMARK] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(383),
    [anon_sym_BANG] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(59),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_LT_DASH] = ACTIONS(383),
    [anon_sym_LT_LT_DASH] = ACTIONS(383),
    [anon_sym_COLON_EQ] = ACTIONS(383),
    [anon_sym_DASH_GT] = ACTIONS(385),
    [anon_sym_DASH_GT_GT] = ACTIONS(383),
    [anon_sym_PIPE] = ACTIONS(385),
    [anon_sym_AMP] = ACTIONS(385),
    [anon_sym_PIPE_PIPE] = ACTIONS(383),
    [anon_sym_AMP_AMP] = ACTIONS(383),
    [anon_sym_LT] = ACTIONS(385),
    [anon_sym_LT_EQ] = ACTIONS(383),
    [anon_sym_GT] = ACTIONS(385),
    [anon_sym_GT_EQ] = ACTIONS(383),
    [anon_sym_EQ_EQ] = ACTIONS(383),
    [anon_sym_BANG_EQ] = ACTIONS(383),
    [anon_sym_STAR] = ACTIONS(81),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_STAR_STAR] = ACTIONS(85),
    [anon_sym_CARET] = ACTIONS(85),
    [aux_sym_binary_operator_token1] = ACTIONS(87),
    [anon_sym_PIPE_GT] = ACTIONS(87),
    [anon_sym_COLON] = ACTIONS(89),
    [anon_sym_DOLLAR] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(91),
    [aux_sym__hex_literal_token1] = ACTIONS(383),
    [sym__number_literal] = ACTIONS(385),
    [anon_sym_SQUOTE] = ACTIONS(383),
    [anon_sym_DQUOTE] = ACTIONS(383),
    [sym_return] = ACTIONS(385),
    [sym_next] = ACTIONS(385),
    [sym_break] = ACTIONS(385),
    [sym_true] = ACTIONS(385),
    [sym_false] = ACTIONS(385),
    [sym_null] = ACTIONS(385),
    [sym_inf] = ACTIONS(385),
    [sym_nan] = ACTIONS(385),
    [anon_sym_NA] = ACTIONS(385),
    [anon_sym_NA_integer_] = ACTIONS(385),
    [anon_sym_NA_real_] = ACTIONS(385),
    [anon_sym_NA_complex_] = ACTIONS(385),
    [anon_sym_NA_character_] = ACTIONS(385),
    [sym_dots] = ACTIONS(385),
    [sym_dot_dot_i] = ACTIONS(383),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(383),
    [sym__newline] = ACTIONS(383),
    [sym__raw_string_literal] = ACTIONS(383),
    [sym__external_else] = ACTIONS(383),
    [sym__external_open_parenthesis] = ACTIONS(95),
    [sym__external_open_brace] = ACTIONS(383),
    [sym__external_open_bracket] = ACTIONS(97),
    [sym__external_close_bracket] = ACTIONS(383),
    [sym__external_open_bracket2] = ACTIONS(99),
  },
  [217] = {
    [sym_call_arguments] = STATE(807),
    [sym_subset_arguments] = STATE(808),
    [sym_subset2_arguments] = STATE(810),
    [sym__open_parenthesis] = STATE(357),
    [sym__open_bracket] = STATE(358),
    [sym__open_bracket2] = STATE(359),
    [sym_identifier] = ACTIONS(385),
    [anon_sym_BSLASH] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_EQ] = ACTIONS(385),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_for] = ACTIONS(385),
    [anon_sym_while] = ACTIONS(385),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_QMARK] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(383),
    [anon_sym_BANG] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(385),
    [anon_sym_LT_DASH] = ACTIONS(383),
    [anon_sym_LT_LT_DASH] = ACTIONS(383),
    [anon_sym_COLON_EQ] = ACTIONS(383),
    [anon_sym_DASH_GT] = ACTIONS(385),
    [anon_sym_DASH_GT_GT] = ACTIONS(383),
    [anon_sym_PIPE] = ACTIONS(385),
    [anon_sym_AMP] = ACTIONS(385),
    [anon_sym_PIPE_PIPE] = ACTIONS(383),
    [anon_sym_AMP_AMP] = ACTIONS(383),
    [anon_sym_LT] = ACTIONS(385),
    [anon_sym_LT_EQ] = ACTIONS(383),
    [anon_sym_GT] = ACTIONS(385),
    [anon_sym_GT_EQ] = ACTIONS(383),
    [anon_sym_EQ_EQ] = ACTIONS(383),
    [anon_sym_BANG_EQ] = ACTIONS(383),
    [anon_sym_STAR] = ACTIONS(385),
    [anon_sym_SLASH] = ACTIONS(383),
    [anon_sym_STAR_STAR] = ACTIONS(85),
    [anon_sym_CARET] = ACTIONS(85),
    [aux_sym_binary_operator_token1] = ACTIONS(87),
    [anon_sym_PIPE_GT] = ACTIONS(87),
    [anon_sym_COLON] = ACTIONS(89),
    [anon_sym_DOLLAR] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(91),
    [aux_sym__hex_literal_token1] = ACTIONS(383),
    [sym__number_literal] = ACTIONS(385),
    [anon_sym_SQUOTE] = ACTIONS(383),
    [anon_sym_DQUOTE] = ACTIONS(383),
    [sym_return] = ACTIONS(385),
    [sym_next] = ACTIONS(385),
    [sym_break] = ACTIONS(385),
    [sym_true] = ACTIONS(385),
    [sym_false] = ACTIONS(385),
    [sym_null] = ACTIONS(385),
    [sym_inf] = ACTIONS(385),
    [sym_nan] = ACTIONS(385),
    [anon_sym_NA] = ACTIONS(385),
    [anon_sym_NA_integer_] = ACTIONS(385),
    [anon_sym_NA_real_] = ACTIONS(385),
    [anon_sym_NA_complex_] = ACTIONS(385),
    [anon_sym_NA_character_] = ACTIONS(385),
    [sym_dots] = ACTIONS(385),
    [sym_dot_dot_i] = ACTIONS(383),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(383),
    [sym__newline] = ACTIONS(383),
    [sym__raw_string_literal] = ACTIONS(383),
    [sym__external_else] = ACTIONS(383),
    [sym__external_open_parenthesis] = ACTIONS(95),
    [sym__external_open_brace] = ACTIONS(383),
    [sym__external_open_bracket] = ACTIONS(97),
    [sym__external_close_bracket] = ACTIONS(383),
    [sym__external_open_bracket2] = ACTIONS(99),
  },
  [218] = {
    [sym_call_arguments] = STATE(807),
    [sym_subset_arguments] = STATE(808),
    [sym_subset2_arguments] = STATE(810),
    [sym__open_parenthesis] = STATE(357),
    [sym__open_bracket] = STATE(358),
    [sym__open_bracket2] = STATE(359),
    [sym_identifier] = ACTIONS(385),
    [anon_sym_BSLASH] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_EQ] = ACTIONS(385),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_for] = ACTIONS(385),
    [anon_sym_while] = ACTIONS(385),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_QMARK] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(383),
    [anon_sym_BANG] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(385),
    [anon_sym_LT_DASH] = ACTIONS(383),
    [anon_sym_LT_LT_DASH] = ACTIONS(383),
    [anon_sym_COLON_EQ] = ACTIONS(383),
    [anon_sym_DASH_GT] = ACTIONS(385),
    [anon_sym_DASH_GT_GT] = ACTIONS(383),
    [anon_sym_PIPE] = ACTIONS(385),
    [anon_sym_AMP] = ACTIONS(385),
    [anon_sym_PIPE_PIPE] = ACTIONS(383),
    [anon_sym_AMP_AMP] = ACTIONS(383),
    [anon_sym_LT] = ACTIONS(385),
    [anon_sym_LT_EQ] = ACTIONS(383),
    [anon_sym_GT] = ACTIONS(385),
    [anon_sym_GT_EQ] = ACTIONS(383),
    [anon_sym_EQ_EQ] = ACTIONS(383),
    [anon_sym_BANG_EQ] = ACTIONS(383),
    [anon_sym_STAR] = ACTIONS(385),
    [anon_sym_SLASH] = ACTIONS(383),
    [anon_sym_STAR_STAR] = ACTIONS(85),
    [anon_sym_CARET] = ACTIONS(85),
    [aux_sym_binary_operator_token1] = ACTIONS(383),
    [anon_sym_PIPE_GT] = ACTIONS(383),
    [anon_sym_COLON] = ACTIONS(385),
    [anon_sym_DOLLAR] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(91),
    [aux_sym__hex_literal_token1] = ACTIONS(383),
    [sym__number_literal] = ACTIONS(385),
    [anon_sym_SQUOTE] = ACTIONS(383),
    [anon_sym_DQUOTE] = ACTIONS(383),
    [sym_return] = ACTIONS(385),
    [sym_next] = ACTIONS(385),
    [sym_break] = ACTIONS(385),
    [sym_true] = ACTIONS(385),
    [sym_false] = ACTIONS(385),
    [sym_null] = ACTIONS(385),
    [sym_inf] = ACTIONS(385),
    [sym_nan] = ACTIONS(385),
    [anon_sym_NA] = ACTIONS(385),
    [anon_sym_NA_integer_] = ACTIONS(385),
    [anon_sym_NA_real_] = ACTIONS(385),
    [anon_sym_NA_complex_] = ACTIONS(385),
    [anon_sym_NA_character_] = ACTIONS(385),
    [sym_dots] = ACTIONS(385),
    [sym_dot_dot_i] = ACTIONS(383),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(383),
    [sym__newline] = ACTIONS(383),
    [sym__raw_string_literal] = ACTIONS(383),
    [sym__external_else] = ACTIONS(383),
    [sym__external_open_parenthesis] = ACTIONS(95),
    [sym__external_open_brace] = ACTIONS(383),
    [sym__external_open_bracket] = ACTIONS(97),
    [sym__external_close_bracket] = ACTIONS(383),
    [sym__external_open_bracket2] = ACTIONS(99),
  },
  [219] = {
    [sym_call_arguments] = STATE(807),
    [sym_subset_arguments] = STATE(808),
    [sym_subset2_arguments] = STATE(810),
    [sym__open_parenthesis] = STATE(357),
    [sym__open_bracket] = STATE(358),
    [sym__open_bracket2] = STATE(359),
    [sym_identifier] = ACTIONS(385),
    [anon_sym_BSLASH] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_EQ] = ACTIONS(385),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_for] = ACTIONS(385),
    [anon_sym_while] = ACTIONS(385),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_QMARK] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(383),
    [anon_sym_BANG] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(385),
    [anon_sym_LT_DASH] = ACTIONS(383),
    [anon_sym_LT_LT_DASH] = ACTIONS(383),
    [anon_sym_COLON_EQ] = ACTIONS(383),
    [anon_sym_DASH_GT] = ACTIONS(385),
    [anon_sym_DASH_GT_GT] = ACTIONS(383),
    [anon_sym_PIPE] = ACTIONS(385),
    [anon_sym_AMP] = ACTIONS(385),
    [anon_sym_PIPE_PIPE] = ACTIONS(383),
    [anon_sym_AMP_AMP] = ACTIONS(383),
    [anon_sym_LT] = ACTIONS(385),
    [anon_sym_LT_EQ] = ACTIONS(383),
    [anon_sym_GT] = ACTIONS(385),
    [anon_sym_GT_EQ] = ACTIONS(383),
    [anon_sym_EQ_EQ] = ACTIONS(383),
    [anon_sym_BANG_EQ] = ACTIONS(383),
    [anon_sym_STAR] = ACTIONS(385),
    [anon_sym_SLASH] = ACTIONS(383),
    [anon_sym_STAR_STAR] = ACTIONS(85),
    [anon_sym_CARET] = ACTIONS(85),
    [aux_sym_binary_operator_token1] = ACTIONS(383),
    [anon_sym_PIPE_GT] = ACTIONS(383),
    [anon_sym_COLON] = ACTIONS(89),
    [anon_sym_DOLLAR] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(91),
    [aux_sym__hex_literal_token1] = ACTIONS(383),
    [sym__number_literal] = ACTIONS(385),
    [anon_sym_SQUOTE] = ACTIONS(383),
    [anon_sym_DQUOTE] = ACTIONS(383),
    [sym_return] = ACTIONS(385),
    [sym_next] = ACTIONS(385),
    [sym_break] = ACTIONS(385),
    [sym_true] = ACTIONS(385),
    [sym_false] = ACTIONS(385),
    [sym_null] = ACTIONS(385),
    [sym_inf] = ACTIONS(385),
    [sym_nan] = ACTIONS(385),
    [anon_sym_NA] = ACTIONS(385),
    [anon_sym_NA_integer_] = ACTIONS(385),
    [anon_sym_NA_real_] = ACTIONS(385),
    [anon_sym_NA_complex_] = ACTIONS(385),
    [anon_sym_NA_character_] = ACTIONS(385),
    [sym_dots] = ACTIONS(385),
    [sym_dot_dot_i] = ACTIONS(383),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(383),
    [sym__newline] = ACTIONS(383),
    [sym__raw_string_literal] = ACTIONS(383),
    [sym__external_else] = ACTIONS(383),
    [sym__external_open_parenthesis] = ACTIONS(95),
    [sym__external_open_brace] = ACTIONS(383),
    [sym__external_open_bracket] = ACTIONS(97),
    [sym__external_close_bracket] = ACTIONS(383),
    [sym__external_open_bracket2] = ACTIONS(99),
  },
  [220] = {
    [sym_call_arguments] = STATE(807),
    [sym_subset_arguments] = STATE(808),
    [sym_subset2_arguments] = STATE(810),
    [sym__open_parenthesis] = STATE(357),
    [sym__open_bracket] = STATE(358),
    [sym__open_bracket2] = STATE(359),
    [sym_identifier] = ACTIONS(385),
    [anon_sym_BSLASH] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_EQ] = ACTIONS(385),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_for] = ACTIONS(385),
    [anon_sym_while] = ACTIONS(385),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_QMARK] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(383),
    [anon_sym_BANG] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(385),
    [anon_sym_LT_DASH] = ACTIONS(383),
    [anon_sym_LT_LT_DASH] = ACTIONS(383),
    [anon_sym_COLON_EQ] = ACTIONS(383),
    [anon_sym_DASH_GT] = ACTIONS(385),
    [anon_sym_DASH_GT_GT] = ACTIONS(383),
    [anon_sym_PIPE] = ACTIONS(385),
    [anon_sym_AMP] = ACTIONS(385),
    [anon_sym_PIPE_PIPE] = ACTIONS(383),
    [anon_sym_AMP_AMP] = ACTIONS(383),
    [anon_sym_LT] = ACTIONS(385),
    [anon_sym_LT_EQ] = ACTIONS(383),
    [anon_sym_GT] = ACTIONS(385),
    [anon_sym_GT_EQ] = ACTIONS(383),
    [anon_sym_EQ_EQ] = ACTIONS(383),
    [anon_sym_BANG_EQ] = ACTIONS(383),
    [anon_sym_STAR] = ACTIONS(385),
    [anon_sym_SLASH] = ACTIONS(383),
    [anon_sym_STAR_STAR] = ACTIONS(85),
    [anon_sym_CARET] = ACTIONS(85),
    [aux_sym_binary_operator_token1] = ACTIONS(383),
    [anon_sym_PIPE_GT] = ACTIONS(383),
    [anon_sym_COLON] = ACTIONS(385),
    [anon_sym_DOLLAR] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(91),
    [aux_sym__hex_literal_token1] = ACTIONS(383),
    [sym__number_literal] = ACTIONS(385),
    [anon_sym_SQUOTE] = ACTIONS(383),
    [anon_sym_DQUOTE] = ACTIONS(383),
    [sym_return] = ACTIONS(385),
    [sym_next] = ACTIONS(385),
    [sym_break] = ACTIONS(385),
    [sym_true] = ACTIONS(385),
    [sym_false] = ACTIONS(385),
    [sym_null] = ACTIONS(385),
    [sym_inf] = ACTIONS(385),
    [sym_nan] = ACTIONS(385),
    [anon_sym_NA] = ACTIONS(385),
    [anon_sym_NA_integer_] = ACTIONS(385),
    [anon_sym_NA_real_] = ACTIONS(385),
    [anon_sym_NA_complex_] = ACTIONS(385),
    [anon_sym_NA_character_] = ACTIONS(385),
    [sym_dots] = ACTIONS(385),
    [sym_dot_dot_i] = ACTIONS(383),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(383),
    [sym__newline] = ACTIONS(383),
    [sym__raw_string_literal] = ACTIONS(383),
    [sym__external_else] = ACTIONS(383),
    [sym__external_open_parenthesis] = ACTIONS(95),
    [sym__external_open_brace] = ACTIONS(383),
    [sym__external_open_bracket] = ACTIONS(97),
    [sym__external_close_bracket] = ACTIONS(383),
    [sym__external_open_bracket2] = ACTIONS(99),
  },
  [221] = {
    [sym_function_definition] = STATE(631),
    [sym_if_statement] = STATE(631),
    [sym_for_statement] = STATE(631),
    [sym_while_statement] = STATE(631),
    [sym_repeat_statement] = STATE(631),
    [sym_braced_expression] = STATE(631),
    [sym_parenthesized_expression] = STATE(631),
    [sym_call] = STATE(631),
    [sym_subset] = STATE(631),
    [sym_subset2] = STATE(631),
    [sym__argument] = STATE(1934),
    [sym_argument] = STATE(1937),
    [sym__argument_named] = STATE(1909),
    [sym__argument_unnamed] = STATE(1932),
    [sym__argument_value] = STATE(1920),
    [sym_unary_operator] = STATE(631),
    [sym_binary_operator] = STATE(631),
    [sym_extract_operator] = STATE(631),
    [sym_namespace_operator] = STATE(631),
    [sym_integer] = STATE(631),
    [sym_complex] = STATE(631),
    [sym_float] = STATE(631),
    [sym__hex_literal] = STATE(752),
    [sym__float_literal] = STATE(752),
    [sym_string] = STATE(766),
    [sym__single_quoted_string] = STATE(753),
    [sym__double_quoted_string] = STATE(754),
    [sym_na] = STATE(631),
    [sym__expression] = STATE(631),
    [sym__string_or_identifier] = STATE(2143),
    [sym__open_parenthesis] = STATE(869),
    [sym__open_brace] = STATE(764),
    [sym__close_bracket] = STATE(779),
    [aux_sym_call_arguments_repeat1] = STATE(529),
    [sym_identifier] = ACTIONS(387),
    [anon_sym_BSLASH] = ACTIONS(389),
    [anon_sym_function] = ACTIONS(391),
    [anon_sym_if] = ACTIONS(393),
    [anon_sym_for] = ACTIONS(395),
    [anon_sym_while] = ACTIONS(397),
    [anon_sym_repeat] = ACTIONS(399),
    [anon_sym_QMARK] = ACTIONS(401),
    [anon_sym_TILDE] = ACTIONS(403),
    [anon_sym_BANG] = ACTIONS(405),
    [anon_sym_PLUS] = ACTIONS(407),
    [anon_sym_DASH] = ACTIONS(407),
    [aux_sym__hex_literal_token1] = ACTIONS(409),
    [sym__number_literal] = ACTIONS(411),
    [anon_sym_SQUOTE] = ACTIONS(413),
    [anon_sym_DQUOTE] = ACTIONS(415),
    [sym_return] = ACTIONS(417),
    [sym_next] = ACTIONS(417),
    [sym_break] = ACTIONS(417),
    [sym_true] = ACTIONS(417),
    [sym_false] = ACTIONS(417),
    [sym_null] = ACTIONS(417),
    [sym_inf] = ACTIONS(417),
    [sym_nan] = ACTIONS(417),
    [anon_sym_NA] = ACTIONS(419),
    [anon_sym_NA_integer_] = ACTIONS(419),
    [anon_sym_NA_real_] = ACTIONS(419),
    [anon_sym_NA_complex_] = ACTIONS(419),
    [anon_sym_NA_character_] = ACTIONS(419),
    [sym_dots] = ACTIONS(421),
    [sym_dot_dot_i] = ACTIONS(423),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(425),
    [sym__newline] = ACTIONS(427),
    [sym__raw_string_literal] = ACTIONS(429),
    [sym__external_open_parenthesis] = ACTIONS(431),
    [sym__external_open_brace] = ACTIONS(433),
    [sym__external_close_bracket] = ACTIONS(561),
  },
  [222] = {
    [sym_call_arguments] = STATE(862),
    [sym_subset_arguments] = STATE(885),
    [sym_subset2_arguments] = STATE(900),
    [sym__open_parenthesis] = STATE(341),
    [sym__open_bracket] = STATE(342),
    [sym__open_bracket2] = STATE(343),
    [ts_builtin_sym_end] = ACTIONS(369),
    [sym_identifier] = ACTIONS(367),
    [anon_sym_BSLASH] = ACTIONS(369),
    [anon_sym_function] = ACTIONS(367),
    [anon_sym_EQ] = ACTIONS(367),
    [anon_sym_if] = ACTIONS(367),
    [anon_sym_for] = ACTIONS(367),
    [anon_sym_while] = ACTIONS(367),
    [anon_sym_repeat] = ACTIONS(367),
    [anon_sym_QMARK] = ACTIONS(369),
    [anon_sym_TILDE] = ACTIONS(369),
    [anon_sym_BANG] = ACTIONS(367),
    [anon_sym_PLUS] = ACTIONS(109),
    [anon_sym_DASH] = ACTIONS(111),
    [anon_sym_LT_DASH] = ACTIONS(369),
    [anon_sym_LT_LT_DASH] = ACTIONS(369),
    [anon_sym_COLON_EQ] = ACTIONS(369),
    [anon_sym_DASH_GT] = ACTIONS(367),
    [anon_sym_DASH_GT_GT] = ACTIONS(369),
    [anon_sym_PIPE] = ACTIONS(367),
    [anon_sym_AMP] = ACTIONS(367),
    [anon_sym_PIPE_PIPE] = ACTIONS(369),
    [anon_sym_AMP_AMP] = ACTIONS(369),
    [anon_sym_LT] = ACTIONS(127),
    [anon_sym_LT_EQ] = ACTIONS(129),
    [anon_sym_GT] = ACTIONS(127),
    [anon_sym_GT_EQ] = ACTIONS(129),
    [anon_sym_EQ_EQ] = ACTIONS(129),
    [anon_sym_BANG_EQ] = ACTIONS(129),
    [anon_sym_STAR] = ACTIONS(131),
    [anon_sym_SLASH] = ACTIONS(133),
    [anon_sym_STAR_STAR] = ACTIONS(135),
    [anon_sym_CARET] = ACTIONS(135),
    [aux_sym_binary_operator_token1] = ACTIONS(137),
    [anon_sym_PIPE_GT] = ACTIONS(137),
    [anon_sym_COLON] = ACTIONS(139),
    [anon_sym_DOLLAR] = ACTIONS(141),
    [anon_sym_AT] = ACTIONS(141),
    [aux_sym__hex_literal_token1] = ACTIONS(369),
    [sym__number_literal] = ACTIONS(367),
    [anon_sym_SQUOTE] = ACTIONS(369),
    [anon_sym_DQUOTE] = ACTIONS(369),
    [sym_return] = ACTIONS(367),
    [sym_next] = ACTIONS(367),
    [sym_break] = ACTIONS(367),
    [sym_true] = ACTIONS(367),
    [sym_false] = ACTIONS(367),
    [sym_null] = ACTIONS(367),
    [sym_inf] = ACTIONS(367),
    [sym_nan] = ACTIONS(367),
    [anon_sym_NA] = ACTIONS(367),
    [anon_sym_NA_integer_] = ACTIONS(367),
    [anon_sym_NA_real_] = ACTIONS(367),
    [anon_sym_NA_complex_] = ACTIONS(367),
    [anon_sym_NA_character_] = ACTIONS(367),
    [sym_dots] = ACTIONS(367),
    [sym_dot_dot_i] = ACTIONS(369),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(369),
    [sym__semicolon] = ACTIONS(369),
    [sym__raw_string_literal] = ACTIONS(369),
    [sym__external_else] = ACTIONS(369),
    [sym__external_open_parenthesis] = ACTIONS(145),
    [sym__external_open_brace] = ACTIONS(369),
    [sym__external_open_bracket] = ACTIONS(147),
    [sym__external_open_bracket2] = ACTIONS(149),
  },
  [223] = {
    [sym_call_arguments] = STATE(807),
    [sym_subset_arguments] = STATE(808),
    [sym_subset2_arguments] = STATE(810),
    [sym__open_parenthesis] = STATE(357),
    [sym__open_bracket] = STATE(358),
    [sym__open_bracket2] = STATE(359),
    [sym_identifier] = ACTIONS(489),
    [anon_sym_BSLASH] = ACTIONS(487),
    [anon_sym_function] = ACTIONS(489),
    [anon_sym_EQ] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(489),
    [anon_sym_for] = ACTIONS(489),
    [anon_sym_while] = ACTIONS(489),
    [anon_sym_repeat] = ACTIONS(489),
    [anon_sym_QMARK] = ACTIONS(487),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_BANG] = ACTIONS(489),
    [anon_sym_PLUS] = ACTIONS(59),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_LT_DASH] = ACTIONS(63),
    [anon_sym_LT_LT_DASH] = ACTIONS(63),
    [anon_sym_COLON_EQ] = ACTIONS(63),
    [anon_sym_DASH_GT] = ACTIONS(65),
    [anon_sym_DASH_GT_GT] = ACTIONS(67),
    [anon_sym_PIPE] = ACTIONS(69),
    [anon_sym_AMP] = ACTIONS(71),
    [anon_sym_PIPE_PIPE] = ACTIONS(73),
    [anon_sym_AMP_AMP] = ACTIONS(75),
    [anon_sym_LT] = ACTIONS(77),
    [anon_sym_LT_EQ] = ACTIONS(79),
    [anon_sym_GT] = ACTIONS(77),
    [anon_sym_GT_EQ] = ACTIONS(79),
    [anon_sym_EQ_EQ] = ACTIONS(79),
    [anon_sym_BANG_EQ] = ACTIONS(79),
    [anon_sym_STAR] = ACTIONS(81),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_STAR_STAR] = ACTIONS(85),
    [anon_sym_CARET] = ACTIONS(85),
    [aux_sym_binary_operator_token1] = ACTIONS(87),
    [anon_sym_PIPE_GT] = ACTIONS(87),
    [anon_sym_COLON] = ACTIONS(89),
    [anon_sym_DOLLAR] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(91),
    [aux_sym__hex_literal_token1] = ACTIONS(487),
    [sym__number_literal] = ACTIONS(489),
    [anon_sym_SQUOTE] = ACTIONS(487),
    [anon_sym_DQUOTE] = ACTIONS(487),
    [sym_return] = ACTIONS(489),
    [sym_next] = ACTIONS(489),
    [sym_break] = ACTIONS(489),
    [sym_true] = ACTIONS(489),
    [sym_false] = ACTIONS(489),
    [sym_null] = ACTIONS(489),
    [sym_inf] = ACTIONS(489),
    [sym_nan] = ACTIONS(489),
    [anon_sym_NA] = ACTIONS(489),
    [anon_sym_NA_integer_] = ACTIONS(489),
    [anon_sym_NA_real_] = ACTIONS(489),
    [anon_sym_NA_complex_] = ACTIONS(489),
    [anon_sym_NA_character_] = ACTIONS(489),
    [sym_dots] = ACTIONS(489),
    [sym_dot_dot_i] = ACTIONS(487),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(487),
    [sym__newline] = ACTIONS(487),
    [sym__raw_string_literal] = ACTIONS(487),
    [sym__external_else] = ACTIONS(487),
    [sym__external_open_parenthesis] = ACTIONS(95),
    [sym__external_open_brace] = ACTIONS(487),
    [sym__external_open_bracket] = ACTIONS(97),
    [sym__external_close_bracket] = ACTIONS(487),
    [sym__external_open_bracket2] = ACTIONS(99),
  },
  [224] = {
    [sym_call_arguments] = STATE(807),
    [sym_subset_arguments] = STATE(808),
    [sym_subset2_arguments] = STATE(810),
    [sym__open_parenthesis] = STATE(357),
    [sym__open_bracket] = STATE(358),
    [sym__open_bracket2] = STATE(359),
    [sym_identifier] = ACTIONS(493),
    [anon_sym_BSLASH] = ACTIONS(491),
    [anon_sym_function] = ACTIONS(493),
    [anon_sym_EQ] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(493),
    [anon_sym_for] = ACTIONS(493),
    [anon_sym_while] = ACTIONS(493),
    [anon_sym_repeat] = ACTIONS(493),
    [anon_sym_QMARK] = ACTIONS(491),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_BANG] = ACTIONS(493),
    [anon_sym_PLUS] = ACTIONS(59),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_LT_DASH] = ACTIONS(491),
    [anon_sym_LT_LT_DASH] = ACTIONS(491),
    [anon_sym_COLON_EQ] = ACTIONS(491),
    [anon_sym_DASH_GT] = ACTIONS(65),
    [anon_sym_DASH_GT_GT] = ACTIONS(67),
    [anon_sym_PIPE] = ACTIONS(69),
    [anon_sym_AMP] = ACTIONS(71),
    [anon_sym_PIPE_PIPE] = ACTIONS(73),
    [anon_sym_AMP_AMP] = ACTIONS(75),
    [anon_sym_LT] = ACTIONS(77),
    [anon_sym_LT_EQ] = ACTIONS(79),
    [anon_sym_GT] = ACTIONS(77),
    [anon_sym_GT_EQ] = ACTIONS(79),
    [anon_sym_EQ_EQ] = ACTIONS(79),
    [anon_sym_BANG_EQ] = ACTIONS(79),
    [anon_sym_STAR] = ACTIONS(81),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_STAR_STAR] = ACTIONS(85),
    [anon_sym_CARET] = ACTIONS(85),
    [aux_sym_binary_operator_token1] = ACTIONS(87),
    [anon_sym_PIPE_GT] = ACTIONS(87),
    [anon_sym_COLON] = ACTIONS(89),
    [anon_sym_DOLLAR] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(91),
    [aux_sym__hex_literal_token1] = ACTIONS(491),
    [sym__number_literal] = ACTIONS(493),
    [anon_sym_SQUOTE] = ACTIONS(491),
    [anon_sym_DQUOTE] = ACTIONS(491),
    [sym_return] = ACTIONS(493),
    [sym_next] = ACTIONS(493),
    [sym_break] = ACTIONS(493),
    [sym_true] = ACTIONS(493),
    [sym_false] = ACTIONS(493),
    [sym_null] = ACTIONS(493),
    [sym_inf] = ACTIONS(493),
    [sym_nan] = ACTIONS(493),
    [anon_sym_NA] = ACTIONS(493),
    [anon_sym_NA_integer_] = ACTIONS(493),
    [anon_sym_NA_real_] = ACTIONS(493),
    [anon_sym_NA_complex_] = ACTIONS(493),
    [anon_sym_NA_character_] = ACTIONS(493),
    [sym_dots] = ACTIONS(493),
    [sym_dot_dot_i] = ACTIONS(491),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(491),
    [sym__newline] = ACTIONS(491),
    [sym__raw_string_literal] = ACTIONS(491),
    [sym__external_else] = ACTIONS(491),
    [sym__external_open_parenthesis] = ACTIONS(95),
    [sym__external_open_brace] = ACTIONS(491),
    [sym__external_open_bracket] = ACTIONS(97),
    [sym__external_close_bracket] = ACTIONS(491),
    [sym__external_open_bracket2] = ACTIONS(99),
  },
  [225] = {
    [sym_call_arguments] = STATE(807),
    [sym_subset_arguments] = STATE(808),
    [sym_subset2_arguments] = STATE(810),
    [sym__open_parenthesis] = STATE(357),
    [sym__open_bracket] = STATE(358),
    [sym__open_bracket2] = STATE(359),
    [sym_identifier] = ACTIONS(493),
    [anon_sym_BSLASH] = ACTIONS(491),
    [anon_sym_function] = ACTIONS(493),
    [anon_sym_EQ] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(493),
    [anon_sym_for] = ACTIONS(493),
    [anon_sym_while] = ACTIONS(493),
    [anon_sym_repeat] = ACTIONS(493),
    [anon_sym_QMARK] = ACTIONS(491),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_BANG] = ACTIONS(493),
    [anon_sym_PLUS] = ACTIONS(59),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_LT_DASH] = ACTIONS(63),
    [anon_sym_LT_LT_DASH] = ACTIONS(63),
    [anon_sym_COLON_EQ] = ACTIONS(63),
    [anon_sym_DASH_GT] = ACTIONS(65),
    [anon_sym_DASH_GT_GT] = ACTIONS(67),
    [anon_sym_PIPE] = ACTIONS(69),
    [anon_sym_AMP] = ACTIONS(71),
    [anon_sym_PIPE_PIPE] = ACTIONS(73),
    [anon_sym_AMP_AMP] = ACTIONS(75),
    [anon_sym_LT] = ACTIONS(77),
    [anon_sym_LT_EQ] = ACTIONS(79),
    [anon_sym_GT] = ACTIONS(77),
    [anon_sym_GT_EQ] = ACTIONS(79),
    [anon_sym_EQ_EQ] = ACTIONS(79),
    [anon_sym_BANG_EQ] = ACTIONS(79),
    [anon_sym_STAR] = ACTIONS(81),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_STAR_STAR] = ACTIONS(85),
    [anon_sym_CARET] = ACTIONS(85),
    [aux_sym_binary_operator_token1] = ACTIONS(87),
    [anon_sym_PIPE_GT] = ACTIONS(87),
    [anon_sym_COLON] = ACTIONS(89),
    [anon_sym_DOLLAR] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(91),
    [aux_sym__hex_literal_token1] = ACTIONS(491),
    [sym__number_literal] = ACTIONS(493),
    [anon_sym_SQUOTE] = ACTIONS(491),
    [anon_sym_DQUOTE] = ACTIONS(491),
    [sym_return] = ACTIONS(493),
    [sym_next] = ACTIONS(493),
    [sym_break] = ACTIONS(493),
    [sym_true] = ACTIONS(493),
    [sym_false] = ACTIONS(493),
    [sym_null] = ACTIONS(493),
    [sym_inf] = ACTIONS(493),
    [sym_nan] = ACTIONS(493),
    [anon_sym_NA] = ACTIONS(493),
    [anon_sym_NA_integer_] = ACTIONS(493),
    [anon_sym_NA_real_] = ACTIONS(493),
    [anon_sym_NA_complex_] = ACTIONS(493),
    [anon_sym_NA_character_] = ACTIONS(493),
    [sym_dots] = ACTIONS(493),
    [sym_dot_dot_i] = ACTIONS(491),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(491),
    [sym__newline] = ACTIONS(491),
    [sym__raw_string_literal] = ACTIONS(491),
    [sym__external_else] = ACTIONS(491),
    [sym__external_open_parenthesis] = ACTIONS(95),
    [sym__external_open_brace] = ACTIONS(491),
    [sym__external_open_bracket] = ACTIONS(97),
    [sym__external_close_bracket] = ACTIONS(491),
    [sym__external_open_bracket2] = ACTIONS(99),
  },
  [226] = {
    [sym_call_arguments] = STATE(807),
    [sym_subset_arguments] = STATE(808),
    [sym_subset2_arguments] = STATE(810),
    [sym__open_parenthesis] = STATE(357),
    [sym__open_bracket] = STATE(358),
    [sym__open_bracket2] = STATE(359),
    [sym_identifier] = ACTIONS(493),
    [anon_sym_BSLASH] = ACTIONS(491),
    [anon_sym_function] = ACTIONS(493),
    [anon_sym_EQ] = ACTIONS(493),
    [anon_sym_if] = ACTIONS(493),
    [anon_sym_for] = ACTIONS(493),
    [anon_sym_while] = ACTIONS(493),
    [anon_sym_repeat] = ACTIONS(493),
    [anon_sym_QMARK] = ACTIONS(491),
    [anon_sym_TILDE] = ACTIONS(491),
    [anon_sym_BANG] = ACTIONS(493),
    [anon_sym_PLUS] = ACTIONS(59),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_LT_DASH] = ACTIONS(491),
    [anon_sym_LT_LT_DASH] = ACTIONS(491),
    [anon_sym_COLON_EQ] = ACTIONS(491),
    [anon_sym_DASH_GT] = ACTIONS(493),
    [anon_sym_DASH_GT_GT] = ACTIONS(491),
    [anon_sym_PIPE] = ACTIONS(69),
    [anon_sym_AMP] = ACTIONS(71),
    [anon_sym_PIPE_PIPE] = ACTIONS(73),
    [anon_sym_AMP_AMP] = ACTIONS(75),
    [anon_sym_LT] = ACTIONS(77),
    [anon_sym_LT_EQ] = ACTIONS(79),
    [anon_sym_GT] = ACTIONS(77),
    [anon_sym_GT_EQ] = ACTIONS(79),
    [anon_sym_EQ_EQ] = ACTIONS(79),
    [anon_sym_BANG_EQ] = ACTIONS(79),
    [anon_sym_STAR] = ACTIONS(81),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_STAR_STAR] = ACTIONS(85),
    [anon_sym_CARET] = ACTIONS(85),
    [aux_sym_binary_operator_token1] = ACTIONS(87),
    [anon_sym_PIPE_GT] = ACTIONS(87),
    [anon_sym_COLON] = ACTIONS(89),
    [anon_sym_DOLLAR] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(91),
    [aux_sym__hex_literal_token1] = ACTIONS(491),
    [sym__number_literal] = ACTIONS(493),
    [anon_sym_SQUOTE] = ACTIONS(491),
    [anon_sym_DQUOTE] = ACTIONS(491),
    [sym_return] = ACTIONS(493),
    [sym_next] = ACTIONS(493),
    [sym_break] = ACTIONS(493),
    [sym_true] = ACTIONS(493),
    [sym_false] = ACTIONS(493),
    [sym_null] = ACTIONS(493),
    [sym_inf] = ACTIONS(493),
    [sym_nan] = ACTIONS(493),
    [anon_sym_NA] = ACTIONS(493),
    [anon_sym_NA_integer_] = ACTIONS(493),
    [anon_sym_NA_real_] = ACTIONS(493),
    [anon_sym_NA_complex_] = ACTIONS(493),
    [anon_sym_NA_character_] = ACTIONS(493),
    [sym_dots] = ACTIONS(493),
    [sym_dot_dot_i] = ACTIONS(491),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(491),
    [sym__newline] = ACTIONS(491),
    [sym__raw_string_literal] = ACTIONS(491),
    [sym__external_else] = ACTIONS(491),
    [sym__external_open_parenthesis] = ACTIONS(95),
    [sym__external_open_brace] = ACTIONS(491),
    [sym__external_open_bracket] = ACTIONS(97),
    [sym__external_close_bracket] = ACTIONS(491),
    [sym__external_open_bracket2] = ACTIONS(99),
  },
  [227] = {
    [sym_call_arguments] = STATE(807),
    [sym_subset_arguments] = STATE(808),
    [sym_subset2_arguments] = STATE(810),
    [sym__open_parenthesis] = STATE(357),
    [sym__open_bracket] = STATE(358),
    [sym__open_bracket2] = STATE(359),
    [sym_identifier] = ACTIONS(493),
    [anon_sym_BSLASH] = ACTIONS(491),
    [anon_sym_function] = ACTIONS(493),
    [anon_sym_EQ] = ACTIONS(493),
    [anon_sym_if] = ACTIONS(493),
    [anon_sym_for] = ACTIONS(493),
    [anon_sym_while] = ACTIONS(493),
    [anon_sym_repeat] = ACTIONS(493),
    [anon_sym_QMARK] = ACTIONS(491),
    [anon_sym_TILDE] = ACTIONS(491),
    [anon_sym_BANG] = ACTIONS(493),
    [anon_sym_PLUS] = ACTIONS(491),
    [anon_sym_DASH] = ACTIONS(493),
    [anon_sym_LT_DASH] = ACTIONS(491),
    [anon_sym_LT_LT_DASH] = ACTIONS(491),
    [anon_sym_COLON_EQ] = ACTIONS(491),
    [anon_sym_DASH_GT] = ACTIONS(493),
    [anon_sym_DASH_GT_GT] = ACTIONS(491),
    [anon_sym_PIPE] = ACTIONS(493),
    [anon_sym_AMP] = ACTIONS(493),
    [anon_sym_PIPE_PIPE] = ACTIONS(491),
    [anon_sym_AMP_AMP] = ACTIONS(491),
    [anon_sym_LT] = ACTIONS(493),
    [anon_sym_LT_EQ] = ACTIONS(491),
    [anon_sym_GT] = ACTIONS(493),
    [anon_sym_GT_EQ] = ACTIONS(491),
    [anon_sym_EQ_EQ] = ACTIONS(491),
    [anon_sym_BANG_EQ] = ACTIONS(491),
    [anon_sym_STAR] = ACTIONS(81),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_STAR_STAR] = ACTIONS(85),
    [anon_sym_CARET] = ACTIONS(85),
    [aux_sym_binary_operator_token1] = ACTIONS(87),
    [anon_sym_PIPE_GT] = ACTIONS(87),
    [anon_sym_COLON] = ACTIONS(89),
    [anon_sym_DOLLAR] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(91),
    [aux_sym__hex_literal_token1] = ACTIONS(491),
    [sym__number_literal] = ACTIONS(493),
    [anon_sym_SQUOTE] = ACTIONS(491),
    [anon_sym_DQUOTE] = ACTIONS(491),
    [sym_return] = ACTIONS(493),
    [sym_next] = ACTIONS(493),
    [sym_break] = ACTIONS(493),
    [sym_true] = ACTIONS(493),
    [sym_false] = ACTIONS(493),
    [sym_null] = ACTIONS(493),
    [sym_inf] = ACTIONS(493),
    [sym_nan] = ACTIONS(493),
    [anon_sym_NA] = ACTIONS(493),
    [anon_sym_NA_integer_] = ACTIONS(493),
    [anon_sym_NA_real_] = ACTIONS(493),
    [anon_sym_NA_complex_] = ACTIONS(493),
    [anon_sym_NA_character_] = ACTIONS(493),
    [sym_dots] = ACTIONS(493),
    [sym_dot_dot_i] = ACTIONS(491),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(491),
    [sym__newline] = ACTIONS(491),
    [sym__raw_string_literal] = ACTIONS(491),
    [sym__external_else] = ACTIONS(491),
    [sym__external_open_parenthesis] = ACTIONS(95),
    [sym__external_open_brace] = ACTIONS(491),
    [sym__external_open_bracket] = ACTIONS(97),
    [sym__external_close_bracket] = ACTIONS(491),
    [sym__external_open_bracket2] = ACTIONS(99),
  },
  [228] = {
    [sym_call_arguments] = STATE(807),
    [sym_subset_arguments] = STATE(808),
    [sym_subset2_arguments] = STATE(810),
    [sym__open_parenthesis] = STATE(357),
    [sym__open_bracket] = STATE(358),
    [sym__open_bracket2] = STATE(359),
    [sym_identifier] = ACTIONS(493),
    [anon_sym_BSLASH] = ACTIONS(491),
    [anon_sym_function] = ACTIONS(493),
    [anon_sym_EQ] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(493),
    [anon_sym_for] = ACTIONS(493),
    [anon_sym_while] = ACTIONS(493),
    [anon_sym_repeat] = ACTIONS(493),
    [anon_sym_QMARK] = ACTIONS(491),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_BANG] = ACTIONS(493),
    [anon_sym_PLUS] = ACTIONS(59),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_LT_DASH] = ACTIONS(63),
    [anon_sym_LT_LT_DASH] = ACTIONS(63),
    [anon_sym_COLON_EQ] = ACTIONS(63),
    [anon_sym_DASH_GT] = ACTIONS(65),
    [anon_sym_DASH_GT_GT] = ACTIONS(67),
    [anon_sym_PIPE] = ACTIONS(69),
    [anon_sym_AMP] = ACTIONS(71),
    [anon_sym_PIPE_PIPE] = ACTIONS(73),
    [anon_sym_AMP_AMP] = ACTIONS(75),
    [anon_sym_LT] = ACTIONS(77),
    [anon_sym_LT_EQ] = ACTIONS(79),
    [anon_sym_GT] = ACTIONS(77),
    [anon_sym_GT_EQ] = ACTIONS(79),
    [anon_sym_EQ_EQ] = ACTIONS(79),
    [anon_sym_BANG_EQ] = ACTIONS(79),
    [anon_sym_STAR] = ACTIONS(81),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_STAR_STAR] = ACTIONS(85),
    [anon_sym_CARET] = ACTIONS(85),
    [aux_sym_binary_operator_token1] = ACTIONS(87),
    [anon_sym_PIPE_GT] = ACTIONS(87),
    [anon_sym_COLON] = ACTIONS(89),
    [anon_sym_DOLLAR] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(91),
    [aux_sym__hex_literal_token1] = ACTIONS(491),
    [sym__number_literal] = ACTIONS(493),
    [anon_sym_SQUOTE] = ACTIONS(491),
    [anon_sym_DQUOTE] = ACTIONS(491),
    [sym_return] = ACTIONS(493),
    [sym_next] = ACTIONS(493),
    [sym_break] = ACTIONS(493),
    [sym_true] = ACTIONS(493),
    [sym_false] = ACTIONS(493),
    [sym_null] = ACTIONS(493),
    [sym_inf] = ACTIONS(493),
    [sym_nan] = ACTIONS(493),
    [anon_sym_NA] = ACTIONS(493),
    [anon_sym_NA_integer_] = ACTIONS(493),
    [anon_sym_NA_real_] = ACTIONS(493),
    [anon_sym_NA_complex_] = ACTIONS(493),
    [anon_sym_NA_character_] = ACTIONS(493),
    [sym_dots] = ACTIONS(493),
    [sym_dot_dot_i] = ACTIONS(491),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(491),
    [sym__newline] = ACTIONS(491),
    [sym__raw_string_literal] = ACTIONS(491),
    [sym__external_else] = ACTIONS(491),
    [sym__external_open_parenthesis] = ACTIONS(95),
    [sym__external_open_brace] = ACTIONS(491),
    [sym__external_open_bracket] = ACTIONS(97),
    [sym__external_close_bracket] = ACTIONS(491),
    [sym__external_open_bracket2] = ACTIONS(99),
  },
  [229] = {
    [sym_call_arguments] = STATE(807),
    [sym_subset_arguments] = STATE(808),
    [sym_subset2_arguments] = STATE(810),
    [sym__open_parenthesis] = STATE(357),
    [sym__open_bracket] = STATE(358),
    [sym__open_bracket2] = STATE(359),
    [sym_identifier] = ACTIONS(493),
    [anon_sym_BSLASH] = ACTIONS(491),
    [anon_sym_function] = ACTIONS(493),
    [anon_sym_EQ] = ACTIONS(493),
    [anon_sym_if] = ACTIONS(493),
    [anon_sym_for] = ACTIONS(493),
    [anon_sym_while] = ACTIONS(493),
    [anon_sym_repeat] = ACTIONS(493),
    [anon_sym_QMARK] = ACTIONS(491),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_BANG] = ACTIONS(493),
    [anon_sym_PLUS] = ACTIONS(59),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_LT_DASH] = ACTIONS(491),
    [anon_sym_LT_LT_DASH] = ACTIONS(491),
    [anon_sym_COLON_EQ] = ACTIONS(491),
    [anon_sym_DASH_GT] = ACTIONS(493),
    [anon_sym_DASH_GT_GT] = ACTIONS(491),
    [anon_sym_PIPE] = ACTIONS(69),
    [anon_sym_AMP] = ACTIONS(71),
    [anon_sym_PIPE_PIPE] = ACTIONS(73),
    [anon_sym_AMP_AMP] = ACTIONS(75),
    [anon_sym_LT] = ACTIONS(77),
    [anon_sym_LT_EQ] = ACTIONS(79),
    [anon_sym_GT] = ACTIONS(77),
    [anon_sym_GT_EQ] = ACTIONS(79),
    [anon_sym_EQ_EQ] = ACTIONS(79),
    [anon_sym_BANG_EQ] = ACTIONS(79),
    [anon_sym_STAR] = ACTIONS(81),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_STAR_STAR] = ACTIONS(85),
    [anon_sym_CARET] = ACTIONS(85),
    [aux_sym_binary_operator_token1] = ACTIONS(87),
    [anon_sym_PIPE_GT] = ACTIONS(87),
    [anon_sym_COLON] = ACTIONS(89),
    [anon_sym_DOLLAR] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(91),
    [aux_sym__hex_literal_token1] = ACTIONS(491),
    [sym__number_literal] = ACTIONS(493),
    [anon_sym_SQUOTE] = ACTIONS(491),
    [anon_sym_DQUOTE] = ACTIONS(491),
    [sym_return] = ACTIONS(493),
    [sym_next] = ACTIONS(493),
    [sym_break] = ACTIONS(493),
    [sym_true] = ACTIONS(493),
    [sym_false] = ACTIONS(493),
    [sym_null] = ACTIONS(493),
    [sym_inf] = ACTIONS(493),
    [sym_nan] = ACTIONS(493),
    [anon_sym_NA] = ACTIONS(493),
    [anon_sym_NA_integer_] = ACTIONS(493),
    [anon_sym_NA_real_] = ACTIONS(493),
    [anon_sym_NA_complex_] = ACTIONS(493),
    [anon_sym_NA_character_] = ACTIONS(493),
    [sym_dots] = ACTIONS(493),
    [sym_dot_dot_i] = ACTIONS(491),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(491),
    [sym__newline] = ACTIONS(491),
    [sym__raw_string_literal] = ACTIONS(491),
    [sym__external_else] = ACTIONS(491),
    [sym__external_open_parenthesis] = ACTIONS(95),
    [sym__external_open_brace] = ACTIONS(491),
    [sym__external_open_bracket] = ACTIONS(97),
    [sym__external_close_bracket] = ACTIONS(491),
    [sym__external_open_bracket2] = ACTIONS(99),
  },
  [230] = {
    [sym_call_arguments] = STATE(807),
    [sym_subset_arguments] = STATE(808),
    [sym_subset2_arguments] = STATE(810),
    [sym__open_parenthesis] = STATE(357),
    [sym__open_bracket] = STATE(358),
    [sym__open_bracket2] = STATE(359),
    [sym_identifier] = ACTIONS(493),
    [anon_sym_BSLASH] = ACTIONS(491),
    [anon_sym_function] = ACTIONS(493),
    [anon_sym_EQ] = ACTIONS(493),
    [anon_sym_if] = ACTIONS(493),
    [anon_sym_for] = ACTIONS(493),
    [anon_sym_while] = ACTIONS(493),
    [anon_sym_repeat] = ACTIONS(493),
    [anon_sym_QMARK] = ACTIONS(491),
    [anon_sym_TILDE] = ACTIONS(491),
    [anon_sym_BANG] = ACTIONS(493),
    [anon_sym_PLUS] = ACTIONS(59),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_LT_DASH] = ACTIONS(491),
    [anon_sym_LT_LT_DASH] = ACTIONS(491),
    [anon_sym_COLON_EQ] = ACTIONS(491),
    [anon_sym_DASH_GT] = ACTIONS(493),
    [anon_sym_DASH_GT_GT] = ACTIONS(491),
    [anon_sym_PIPE] = ACTIONS(493),
    [anon_sym_AMP] = ACTIONS(71),
    [anon_sym_PIPE_PIPE] = ACTIONS(491),
    [anon_sym_AMP_AMP] = ACTIONS(75),
    [anon_sym_LT] = ACTIONS(77),
    [anon_sym_LT_EQ] = ACTIONS(79),
    [anon_sym_GT] = ACTIONS(77),
    [anon_sym_GT_EQ] = ACTIONS(79),
    [anon_sym_EQ_EQ] = ACTIONS(79),
    [anon_sym_BANG_EQ] = ACTIONS(79),
    [anon_sym_STAR] = ACTIONS(81),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_STAR_STAR] = ACTIONS(85),
    [anon_sym_CARET] = ACTIONS(85),
    [aux_sym_binary_operator_token1] = ACTIONS(87),
    [anon_sym_PIPE_GT] = ACTIONS(87),
    [anon_sym_COLON] = ACTIONS(89),
    [anon_sym_DOLLAR] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(91),
    [aux_sym__hex_literal_token1] = ACTIONS(491),
    [sym__number_literal] = ACTIONS(493),
    [anon_sym_SQUOTE] = ACTIONS(491),
    [anon_sym_DQUOTE] = ACTIONS(491),
    [sym_return] = ACTIONS(493),
    [sym_next] = ACTIONS(493),
    [sym_break] = ACTIONS(493),
    [sym_true] = ACTIONS(493),
    [sym_false] = ACTIONS(493),
    [sym_null] = ACTIONS(493),
    [sym_inf] = ACTIONS(493),
    [sym_nan] = ACTIONS(493),
    [anon_sym_NA] = ACTIONS(493),
    [anon_sym_NA_integer_] = ACTIONS(493),
    [anon_sym_NA_real_] = ACTIONS(493),
    [anon_sym_NA_complex_] = ACTIONS(493),
    [anon_sym_NA_character_] = ACTIONS(493),
    [sym_dots] = ACTIONS(493),
    [sym_dot_dot_i] = ACTIONS(491),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(491),
    [sym__newline] = ACTIONS(491),
    [sym__raw_string_literal] = ACTIONS(491),
    [sym__external_else] = ACTIONS(491),
    [sym__external_open_parenthesis] = ACTIONS(95),
    [sym__external_open_brace] = ACTIONS(491),
    [sym__external_open_bracket] = ACTIONS(97),
    [sym__external_close_bracket] = ACTIONS(491),
    [sym__external_open_bracket2] = ACTIONS(99),
  },
  [231] = {
    [sym_call_arguments] = STATE(807),
    [sym_subset_arguments] = STATE(808),
    [sym_subset2_arguments] = STATE(810),
    [sym__open_parenthesis] = STATE(357),
    [sym__open_bracket] = STATE(358),
    [sym__open_bracket2] = STATE(359),
    [sym_identifier] = ACTIONS(493),
    [anon_sym_BSLASH] = ACTIONS(491),
    [anon_sym_function] = ACTIONS(493),
    [anon_sym_EQ] = ACTIONS(493),
    [anon_sym_if] = ACTIONS(493),
    [anon_sym_for] = ACTIONS(493),
    [anon_sym_while] = ACTIONS(493),
    [anon_sym_repeat] = ACTIONS(493),
    [anon_sym_QMARK] = ACTIONS(491),
    [anon_sym_TILDE] = ACTIONS(491),
    [anon_sym_BANG] = ACTIONS(493),
    [anon_sym_PLUS] = ACTIONS(59),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_LT_DASH] = ACTIONS(491),
    [anon_sym_LT_LT_DASH] = ACTIONS(491),
    [anon_sym_COLON_EQ] = ACTIONS(491),
    [anon_sym_DASH_GT] = ACTIONS(493),
    [anon_sym_DASH_GT_GT] = ACTIONS(491),
    [anon_sym_PIPE] = ACTIONS(493),
    [anon_sym_AMP] = ACTIONS(493),
    [anon_sym_PIPE_PIPE] = ACTIONS(491),
    [anon_sym_AMP_AMP] = ACTIONS(491),
    [anon_sym_LT] = ACTIONS(77),
    [anon_sym_LT_EQ] = ACTIONS(79),
    [anon_sym_GT] = ACTIONS(77),
    [anon_sym_GT_EQ] = ACTIONS(79),
    [anon_sym_EQ_EQ] = ACTIONS(79),
    [anon_sym_BANG_EQ] = ACTIONS(79),
    [anon_sym_STAR] = ACTIONS(81),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_STAR_STAR] = ACTIONS(85),
    [anon_sym_CARET] = ACTIONS(85),
    [aux_sym_binary_operator_token1] = ACTIONS(87),
    [anon_sym_PIPE_GT] = ACTIONS(87),
    [anon_sym_COLON] = ACTIONS(89),
    [anon_sym_DOLLAR] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(91),
    [aux_sym__hex_literal_token1] = ACTIONS(491),
    [sym__number_literal] = ACTIONS(493),
    [anon_sym_SQUOTE] = ACTIONS(491),
    [anon_sym_DQUOTE] = ACTIONS(491),
    [sym_return] = ACTIONS(493),
    [sym_next] = ACTIONS(493),
    [sym_break] = ACTIONS(493),
    [sym_true] = ACTIONS(493),
    [sym_false] = ACTIONS(493),
    [sym_null] = ACTIONS(493),
    [sym_inf] = ACTIONS(493),
    [sym_nan] = ACTIONS(493),
    [anon_sym_NA] = ACTIONS(493),
    [anon_sym_NA_integer_] = ACTIONS(493),
    [anon_sym_NA_real_] = ACTIONS(493),
    [anon_sym_NA_complex_] = ACTIONS(493),
    [anon_sym_NA_character_] = ACTIONS(493),
    [sym_dots] = ACTIONS(493),
    [sym_dot_dot_i] = ACTIONS(491),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(491),
    [sym__newline] = ACTIONS(491),
    [sym__raw_string_literal] = ACTIONS(491),
    [sym__external_else] = ACTIONS(491),
    [sym__external_open_parenthesis] = ACTIONS(95),
    [sym__external_open_brace] = ACTIONS(491),
    [sym__external_open_bracket] = ACTIONS(97),
    [sym__external_close_bracket] = ACTIONS(491),
    [sym__external_open_bracket2] = ACTIONS(99),
  },
  [232] = {
    [sym_call_arguments] = STATE(807),
    [sym_subset_arguments] = STATE(808),
    [sym_subset2_arguments] = STATE(810),
    [sym__open_parenthesis] = STATE(357),
    [sym__open_bracket] = STATE(358),
    [sym__open_bracket2] = STATE(359),
    [sym_identifier] = ACTIONS(493),
    [anon_sym_BSLASH] = ACTIONS(491),
    [anon_sym_function] = ACTIONS(493),
    [anon_sym_EQ] = ACTIONS(493),
    [anon_sym_if] = ACTIONS(493),
    [anon_sym_for] = ACTIONS(493),
    [anon_sym_while] = ACTIONS(493),
    [anon_sym_repeat] = ACTIONS(493),
    [anon_sym_QMARK] = ACTIONS(491),
    [anon_sym_TILDE] = ACTIONS(491),
    [anon_sym_BANG] = ACTIONS(493),
    [anon_sym_PLUS] = ACTIONS(59),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_LT_DASH] = ACTIONS(491),
    [anon_sym_LT_LT_DASH] = ACTIONS(491),
    [anon_sym_COLON_EQ] = ACTIONS(491),
    [anon_sym_DASH_GT] = ACTIONS(493),
    [anon_sym_DASH_GT_GT] = ACTIONS(491),
    [anon_sym_PIPE] = ACTIONS(493),
    [anon_sym_AMP] = ACTIONS(493),
    [anon_sym_PIPE_PIPE] = ACTIONS(491),
    [anon_sym_AMP_AMP] = ACTIONS(491),
    [anon_sym_LT] = ACTIONS(493),
    [anon_sym_LT_EQ] = ACTIONS(491),
    [anon_sym_GT] = ACTIONS(493),
    [anon_sym_GT_EQ] = ACTIONS(491),
    [anon_sym_EQ_EQ] = ACTIONS(491),
    [anon_sym_BANG_EQ] = ACTIONS(491),
    [anon_sym_STAR] = ACTIONS(81),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_STAR_STAR] = ACTIONS(85),
    [anon_sym_CARET] = ACTIONS(85),
    [aux_sym_binary_operator_token1] = ACTIONS(87),
    [anon_sym_PIPE_GT] = ACTIONS(87),
    [anon_sym_COLON] = ACTIONS(89),
    [anon_sym_DOLLAR] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(91),
    [aux_sym__hex_literal_token1] = ACTIONS(491),
    [sym__number_literal] = ACTIONS(493),
    [anon_sym_SQUOTE] = ACTIONS(491),
    [anon_sym_DQUOTE] = ACTIONS(491),
    [sym_return] = ACTIONS(493),
    [sym_next] = ACTIONS(493),
    [sym_break] = ACTIONS(493),
    [sym_true] = ACTIONS(493),
    [sym_false] = ACTIONS(493),
    [sym_null] = ACTIONS(493),
    [sym_inf] = ACTIONS(493),
    [sym_nan] = ACTIONS(493),
    [anon_sym_NA] = ACTIONS(493),
    [anon_sym_NA_integer_] = ACTIONS(493),
    [anon_sym_NA_real_] = ACTIONS(493),
    [anon_sym_NA_complex_] = ACTIONS(493),
    [anon_sym_NA_character_] = ACTIONS(493),
    [sym_dots] = ACTIONS(493),
    [sym_dot_dot_i] = ACTIONS(491),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(491),
    [sym__newline] = ACTIONS(491),
    [sym__raw_string_literal] = ACTIONS(491),
    [sym__external_else] = ACTIONS(491),
    [sym__external_open_parenthesis] = ACTIONS(95),
    [sym__external_open_brace] = ACTIONS(491),
    [sym__external_open_bracket] = ACTIONS(97),
    [sym__external_close_bracket] = ACTIONS(491),
    [sym__external_open_bracket2] = ACTIONS(99),
  },
  [233] = {
    [sym_call_arguments] = STATE(807),
    [sym_subset_arguments] = STATE(808),
    [sym_subset2_arguments] = STATE(810),
    [sym__open_parenthesis] = STATE(357),
    [sym__open_bracket] = STATE(358),
    [sym__open_bracket2] = STATE(359),
    [sym_identifier] = ACTIONS(493),
    [anon_sym_BSLASH] = ACTIONS(491),
    [anon_sym_function] = ACTIONS(493),
    [anon_sym_EQ] = ACTIONS(493),
    [anon_sym_if] = ACTIONS(493),
    [anon_sym_for] = ACTIONS(493),
    [anon_sym_while] = ACTIONS(493),
    [anon_sym_repeat] = ACTIONS(493),
    [anon_sym_QMARK] = ACTIONS(491),
    [anon_sym_TILDE] = ACTIONS(491),
    [anon_sym_BANG] = ACTIONS(493),
    [anon_sym_PLUS] = ACTIONS(491),
    [anon_sym_DASH] = ACTIONS(493),
    [anon_sym_LT_DASH] = ACTIONS(491),
    [anon_sym_LT_LT_DASH] = ACTIONS(491),
    [anon_sym_COLON_EQ] = ACTIONS(491),
    [anon_sym_DASH_GT] = ACTIONS(493),
    [anon_sym_DASH_GT_GT] = ACTIONS(491),
    [anon_sym_PIPE] = ACTIONS(493),
    [anon_sym_AMP] = ACTIONS(493),
    [anon_sym_PIPE_PIPE] = ACTIONS(491),
    [anon_sym_AMP_AMP] = ACTIONS(491),
    [anon_sym_LT] = ACTIONS(493),
    [anon_sym_LT_EQ] = ACTIONS(491),
    [anon_sym_GT] = ACTIONS(493),
    [anon_sym_GT_EQ] = ACTIONS(491),
    [anon_sym_EQ_EQ] = ACTIONS(491),
    [anon_sym_BANG_EQ] = ACTIONS(491),
    [anon_sym_STAR] = ACTIONS(493),
    [anon_sym_SLASH] = ACTIONS(491),
    [anon_sym_STAR_STAR] = ACTIONS(85),
    [anon_sym_CARET] = ACTIONS(85),
    [aux_sym_binary_operator_token1] = ACTIONS(87),
    [anon_sym_PIPE_GT] = ACTIONS(87),
    [anon_sym_COLON] = ACTIONS(89),
    [anon_sym_DOLLAR] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(91),
    [aux_sym__hex_literal_token1] = ACTIONS(491),
    [sym__number_literal] = ACTIONS(493),
    [anon_sym_SQUOTE] = ACTIONS(491),
    [anon_sym_DQUOTE] = ACTIONS(491),
    [sym_return] = ACTIONS(493),
    [sym_next] = ACTIONS(493),
    [sym_break] = ACTIONS(493),
    [sym_true] = ACTIONS(493),
    [sym_false] = ACTIONS(493),
    [sym_null] = ACTIONS(493),
    [sym_inf] = ACTIONS(493),
    [sym_nan] = ACTIONS(493),
    [anon_sym_NA] = ACTIONS(493),
    [anon_sym_NA_integer_] = ACTIONS(493),
    [anon_sym_NA_real_] = ACTIONS(493),
    [anon_sym_NA_complex_] = ACTIONS(493),
    [anon_sym_NA_character_] = ACTIONS(493),
    [sym_dots] = ACTIONS(493),
    [sym_dot_dot_i] = ACTIONS(491),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(491),
    [sym__newline] = ACTIONS(491),
    [sym__raw_string_literal] = ACTIONS(491),
    [sym__external_else] = ACTIONS(491),
    [sym__external_open_parenthesis] = ACTIONS(95),
    [sym__external_open_brace] = ACTIONS(491),
    [sym__external_open_bracket] = ACTIONS(97),
    [sym__external_close_bracket] = ACTIONS(491),
    [sym__external_open_bracket2] = ACTIONS(99),
  },
  [234] = {
    [sym_call_arguments] = STATE(807),
    [sym_subset_arguments] = STATE(808),
    [sym_subset2_arguments] = STATE(810),
    [sym__open_parenthesis] = STATE(357),
    [sym__open_bracket] = STATE(358),
    [sym__open_bracket2] = STATE(359),
    [sym_identifier] = ACTIONS(493),
    [anon_sym_BSLASH] = ACTIONS(491),
    [anon_sym_function] = ACTIONS(493),
    [anon_sym_EQ] = ACTIONS(493),
    [anon_sym_if] = ACTIONS(493),
    [anon_sym_for] = ACTIONS(493),
    [anon_sym_while] = ACTIONS(493),
    [anon_sym_repeat] = ACTIONS(493),
    [anon_sym_QMARK] = ACTIONS(491),
    [anon_sym_TILDE] = ACTIONS(491),
    [anon_sym_BANG] = ACTIONS(493),
    [anon_sym_PLUS] = ACTIONS(491),
    [anon_sym_DASH] = ACTIONS(493),
    [anon_sym_LT_DASH] = ACTIONS(491),
    [anon_sym_LT_LT_DASH] = ACTIONS(491),
    [anon_sym_COLON_EQ] = ACTIONS(491),
    [anon_sym_DASH_GT] = ACTIONS(493),
    [anon_sym_DASH_GT_GT] = ACTIONS(491),
    [anon_sym_PIPE] = ACTIONS(493),
    [anon_sym_AMP] = ACTIONS(493),
    [anon_sym_PIPE_PIPE] = ACTIONS(491),
    [anon_sym_AMP_AMP] = ACTIONS(491),
    [anon_sym_LT] = ACTIONS(493),
    [anon_sym_LT_EQ] = ACTIONS(491),
    [anon_sym_GT] = ACTIONS(493),
    [anon_sym_GT_EQ] = ACTIONS(491),
    [anon_sym_EQ_EQ] = ACTIONS(491),
    [anon_sym_BANG_EQ] = ACTIONS(491),
    [anon_sym_STAR] = ACTIONS(493),
    [anon_sym_SLASH] = ACTIONS(491),
    [anon_sym_STAR_STAR] = ACTIONS(85),
    [anon_sym_CARET] = ACTIONS(85),
    [aux_sym_binary_operator_token1] = ACTIONS(491),
    [anon_sym_PIPE_GT] = ACTIONS(491),
    [anon_sym_COLON] = ACTIONS(493),
    [anon_sym_DOLLAR] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(91),
    [aux_sym__hex_literal_token1] = ACTIONS(491),
    [sym__number_literal] = ACTIONS(493),
    [anon_sym_SQUOTE] = ACTIONS(491),
    [anon_sym_DQUOTE] = ACTIONS(491),
    [sym_return] = ACTIONS(493),
    [sym_next] = ACTIONS(493),
    [sym_break] = ACTIONS(493),
    [sym_true] = ACTIONS(493),
    [sym_false] = ACTIONS(493),
    [sym_null] = ACTIONS(493),
    [sym_inf] = ACTIONS(493),
    [sym_nan] = ACTIONS(493),
    [anon_sym_NA] = ACTIONS(493),
    [anon_sym_NA_integer_] = ACTIONS(493),
    [anon_sym_NA_real_] = ACTIONS(493),
    [anon_sym_NA_complex_] = ACTIONS(493),
    [anon_sym_NA_character_] = ACTIONS(493),
    [sym_dots] = ACTIONS(493),
    [sym_dot_dot_i] = ACTIONS(491),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(491),
    [sym__newline] = ACTIONS(491),
    [sym__raw_string_literal] = ACTIONS(491),
    [sym__external_else] = ACTIONS(491),
    [sym__external_open_parenthesis] = ACTIONS(95),
    [sym__external_open_brace] = ACTIONS(491),
    [sym__external_open_bracket] = ACTIONS(97),
    [sym__external_close_bracket] = ACTIONS(491),
    [sym__external_open_bracket2] = ACTIONS(99),
  },
  [235] = {
    [sym_call_arguments] = STATE(807),
    [sym_subset_arguments] = STATE(808),
    [sym_subset2_arguments] = STATE(810),
    [sym__open_parenthesis] = STATE(357),
    [sym__open_bracket] = STATE(358),
    [sym__open_bracket2] = STATE(359),
    [sym_identifier] = ACTIONS(493),
    [anon_sym_BSLASH] = ACTIONS(491),
    [anon_sym_function] = ACTIONS(493),
    [anon_sym_EQ] = ACTIONS(493),
    [anon_sym_if] = ACTIONS(493),
    [anon_sym_for] = ACTIONS(493),
    [anon_sym_while] = ACTIONS(493),
    [anon_sym_repeat] = ACTIONS(493),
    [anon_sym_QMARK] = ACTIONS(491),
    [anon_sym_TILDE] = ACTIONS(491),
    [anon_sym_BANG] = ACTIONS(493),
    [anon_sym_PLUS] = ACTIONS(491),
    [anon_sym_DASH] = ACTIONS(493),
    [anon_sym_LT_DASH] = ACTIONS(491),
    [anon_sym_LT_LT_DASH] = ACTIONS(491),
    [anon_sym_COLON_EQ] = ACTIONS(491),
    [anon_sym_DASH_GT] = ACTIONS(493),
    [anon_sym_DASH_GT_GT] = ACTIONS(491),
    [anon_sym_PIPE] = ACTIONS(493),
    [anon_sym_AMP] = ACTIONS(493),
    [anon_sym_PIPE_PIPE] = ACTIONS(491),
    [anon_sym_AMP_AMP] = ACTIONS(491),
    [anon_sym_LT] = ACTIONS(493),
    [anon_sym_LT_EQ] = ACTIONS(491),
    [anon_sym_GT] = ACTIONS(493),
    [anon_sym_GT_EQ] = ACTIONS(491),
    [anon_sym_EQ_EQ] = ACTIONS(491),
    [anon_sym_BANG_EQ] = ACTIONS(491),
    [anon_sym_STAR] = ACTIONS(493),
    [anon_sym_SLASH] = ACTIONS(491),
    [anon_sym_STAR_STAR] = ACTIONS(85),
    [anon_sym_CARET] = ACTIONS(85),
    [aux_sym_binary_operator_token1] = ACTIONS(491),
    [anon_sym_PIPE_GT] = ACTIONS(491),
    [anon_sym_COLON] = ACTIONS(89),
    [anon_sym_DOLLAR] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(91),
    [aux_sym__hex_literal_token1] = ACTIONS(491),
    [sym__number_literal] = ACTIONS(493),
    [anon_sym_SQUOTE] = ACTIONS(491),
    [anon_sym_DQUOTE] = ACTIONS(491),
    [sym_return] = ACTIONS(493),
    [sym_next] = ACTIONS(493),
    [sym_break] = ACTIONS(493),
    [sym_true] = ACTIONS(493),
    [sym_false] = ACTIONS(493),
    [sym_null] = ACTIONS(493),
    [sym_inf] = ACTIONS(493),
    [sym_nan] = ACTIONS(493),
    [anon_sym_NA] = ACTIONS(493),
    [anon_sym_NA_integer_] = ACTIONS(493),
    [anon_sym_NA_real_] = ACTIONS(493),
    [anon_sym_NA_complex_] = ACTIONS(493),
    [anon_sym_NA_character_] = ACTIONS(493),
    [sym_dots] = ACTIONS(493),
    [sym_dot_dot_i] = ACTIONS(491),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(491),
    [sym__newline] = ACTIONS(491),
    [sym__raw_string_literal] = ACTIONS(491),
    [sym__external_else] = ACTIONS(491),
    [sym__external_open_parenthesis] = ACTIONS(95),
    [sym__external_open_brace] = ACTIONS(491),
    [sym__external_open_bracket] = ACTIONS(97),
    [sym__external_close_bracket] = ACTIONS(491),
    [sym__external_open_bracket2] = ACTIONS(99),
  },
  [236] = {
    [sym_call_arguments] = STATE(807),
    [sym_subset_arguments] = STATE(808),
    [sym_subset2_arguments] = STATE(810),
    [sym__open_parenthesis] = STATE(357),
    [sym__open_bracket] = STATE(358),
    [sym__open_bracket2] = STATE(359),
    [sym_identifier] = ACTIONS(493),
    [anon_sym_BSLASH] = ACTIONS(491),
    [anon_sym_function] = ACTIONS(493),
    [anon_sym_EQ] = ACTIONS(493),
    [anon_sym_if] = ACTIONS(493),
    [anon_sym_for] = ACTIONS(493),
    [anon_sym_while] = ACTIONS(493),
    [anon_sym_repeat] = ACTIONS(493),
    [anon_sym_QMARK] = ACTIONS(491),
    [anon_sym_TILDE] = ACTIONS(491),
    [anon_sym_BANG] = ACTIONS(493),
    [anon_sym_PLUS] = ACTIONS(491),
    [anon_sym_DASH] = ACTIONS(493),
    [anon_sym_LT_DASH] = ACTIONS(491),
    [anon_sym_LT_LT_DASH] = ACTIONS(491),
    [anon_sym_COLON_EQ] = ACTIONS(491),
    [anon_sym_DASH_GT] = ACTIONS(493),
    [anon_sym_DASH_GT_GT] = ACTIONS(491),
    [anon_sym_PIPE] = ACTIONS(493),
    [anon_sym_AMP] = ACTIONS(493),
    [anon_sym_PIPE_PIPE] = ACTIONS(491),
    [anon_sym_AMP_AMP] = ACTIONS(491),
    [anon_sym_LT] = ACTIONS(493),
    [anon_sym_LT_EQ] = ACTIONS(491),
    [anon_sym_GT] = ACTIONS(493),
    [anon_sym_GT_EQ] = ACTIONS(491),
    [anon_sym_EQ_EQ] = ACTIONS(491),
    [anon_sym_BANG_EQ] = ACTIONS(491),
    [anon_sym_STAR] = ACTIONS(493),
    [anon_sym_SLASH] = ACTIONS(491),
    [anon_sym_STAR_STAR] = ACTIONS(85),
    [anon_sym_CARET] = ACTIONS(85),
    [aux_sym_binary_operator_token1] = ACTIONS(491),
    [anon_sym_PIPE_GT] = ACTIONS(491),
    [anon_sym_COLON] = ACTIONS(493),
    [anon_sym_DOLLAR] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(91),
    [aux_sym__hex_literal_token1] = ACTIONS(491),
    [sym__number_literal] = ACTIONS(493),
    [anon_sym_SQUOTE] = ACTIONS(491),
    [anon_sym_DQUOTE] = ACTIONS(491),
    [sym_return] = ACTIONS(493),
    [sym_next] = ACTIONS(493),
    [sym_break] = ACTIONS(493),
    [sym_true] = ACTIONS(493),
    [sym_false] = ACTIONS(493),
    [sym_null] = ACTIONS(493),
    [sym_inf] = ACTIONS(493),
    [sym_nan] = ACTIONS(493),
    [anon_sym_NA] = ACTIONS(493),
    [anon_sym_NA_integer_] = ACTIONS(493),
    [anon_sym_NA_real_] = ACTIONS(493),
    [anon_sym_NA_complex_] = ACTIONS(493),
    [anon_sym_NA_character_] = ACTIONS(493),
    [sym_dots] = ACTIONS(493),
    [sym_dot_dot_i] = ACTIONS(491),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(491),
    [sym__newline] = ACTIONS(491),
    [sym__raw_string_literal] = ACTIONS(491),
    [sym__external_else] = ACTIONS(491),
    [sym__external_open_parenthesis] = ACTIONS(95),
    [sym__external_open_brace] = ACTIONS(491),
    [sym__external_open_bracket] = ACTIONS(97),
    [sym__external_close_bracket] = ACTIONS(491),
    [sym__external_open_bracket2] = ACTIONS(99),
  },
  [237] = {
    [sym_call_arguments] = STATE(807),
    [sym_subset_arguments] = STATE(808),
    [sym_subset2_arguments] = STATE(810),
    [sym__open_parenthesis] = STATE(357),
    [sym__open_bracket] = STATE(358),
    [sym__open_bracket2] = STATE(359),
    [sym_identifier] = ACTIONS(497),
    [anon_sym_BSLASH] = ACTIONS(495),
    [anon_sym_function] = ACTIONS(497),
    [anon_sym_EQ] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(497),
    [anon_sym_for] = ACTIONS(497),
    [anon_sym_while] = ACTIONS(497),
    [anon_sym_repeat] = ACTIONS(497),
    [anon_sym_QMARK] = ACTIONS(495),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_BANG] = ACTIONS(497),
    [anon_sym_PLUS] = ACTIONS(59),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_LT_DASH] = ACTIONS(63),
    [anon_sym_LT_LT_DASH] = ACTIONS(63),
    [anon_sym_COLON_EQ] = ACTIONS(63),
    [anon_sym_DASH_GT] = ACTIONS(65),
    [anon_sym_DASH_GT_GT] = ACTIONS(67),
    [anon_sym_PIPE] = ACTIONS(69),
    [anon_sym_AMP] = ACTIONS(71),
    [anon_sym_PIPE_PIPE] = ACTIONS(73),
    [anon_sym_AMP_AMP] = ACTIONS(75),
    [anon_sym_LT] = ACTIONS(77),
    [anon_sym_LT_EQ] = ACTIONS(79),
    [anon_sym_GT] = ACTIONS(77),
    [anon_sym_GT_EQ] = ACTIONS(79),
    [anon_sym_EQ_EQ] = ACTIONS(79),
    [anon_sym_BANG_EQ] = ACTIONS(79),
    [anon_sym_STAR] = ACTIONS(81),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_STAR_STAR] = ACTIONS(85),
    [anon_sym_CARET] = ACTIONS(85),
    [aux_sym_binary_operator_token1] = ACTIONS(87),
    [anon_sym_PIPE_GT] = ACTIONS(87),
    [anon_sym_COLON] = ACTIONS(89),
    [anon_sym_DOLLAR] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(91),
    [aux_sym__hex_literal_token1] = ACTIONS(495),
    [sym__number_literal] = ACTIONS(497),
    [anon_sym_SQUOTE] = ACTIONS(495),
    [anon_sym_DQUOTE] = ACTIONS(495),
    [sym_return] = ACTIONS(497),
    [sym_next] = ACTIONS(497),
    [sym_break] = ACTIONS(497),
    [sym_true] = ACTIONS(497),
    [sym_false] = ACTIONS(497),
    [sym_null] = ACTIONS(497),
    [sym_inf] = ACTIONS(497),
    [sym_nan] = ACTIONS(497),
    [anon_sym_NA] = ACTIONS(497),
    [anon_sym_NA_integer_] = ACTIONS(497),
    [anon_sym_NA_real_] = ACTIONS(497),
    [anon_sym_NA_complex_] = ACTIONS(497),
    [anon_sym_NA_character_] = ACTIONS(497),
    [sym_dots] = ACTIONS(497),
    [sym_dot_dot_i] = ACTIONS(495),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(495),
    [sym__newline] = ACTIONS(495),
    [sym__raw_string_literal] = ACTIONS(495),
    [sym__external_else] = ACTIONS(495),
    [sym__external_open_parenthesis] = ACTIONS(95),
    [sym__external_open_brace] = ACTIONS(495),
    [sym__external_open_bracket] = ACTIONS(97),
    [sym__external_close_bracket] = ACTIONS(495),
    [sym__external_open_bracket2] = ACTIONS(99),
  },
  [238] = {
    [sym_call_arguments] = STATE(807),
    [sym_subset_arguments] = STATE(808),
    [sym_subset2_arguments] = STATE(810),
    [sym__open_parenthesis] = STATE(357),
    [sym__open_bracket] = STATE(358),
    [sym__open_bracket2] = STATE(359),
    [sym_identifier] = ACTIONS(501),
    [anon_sym_BSLASH] = ACTIONS(499),
    [anon_sym_function] = ACTIONS(501),
    [anon_sym_EQ] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(501),
    [anon_sym_for] = ACTIONS(501),
    [anon_sym_while] = ACTIONS(501),
    [anon_sym_repeat] = ACTIONS(501),
    [anon_sym_QMARK] = ACTIONS(499),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_BANG] = ACTIONS(501),
    [anon_sym_PLUS] = ACTIONS(59),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_LT_DASH] = ACTIONS(63),
    [anon_sym_LT_LT_DASH] = ACTIONS(63),
    [anon_sym_COLON_EQ] = ACTIONS(63),
    [anon_sym_DASH_GT] = ACTIONS(65),
    [anon_sym_DASH_GT_GT] = ACTIONS(67),
    [anon_sym_PIPE] = ACTIONS(69),
    [anon_sym_AMP] = ACTIONS(71),
    [anon_sym_PIPE_PIPE] = ACTIONS(73),
    [anon_sym_AMP_AMP] = ACTIONS(75),
    [anon_sym_LT] = ACTIONS(77),
    [anon_sym_LT_EQ] = ACTIONS(79),
    [anon_sym_GT] = ACTIONS(77),
    [anon_sym_GT_EQ] = ACTIONS(79),
    [anon_sym_EQ_EQ] = ACTIONS(79),
    [anon_sym_BANG_EQ] = ACTIONS(79),
    [anon_sym_STAR] = ACTIONS(81),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_STAR_STAR] = ACTIONS(85),
    [anon_sym_CARET] = ACTIONS(85),
    [aux_sym_binary_operator_token1] = ACTIONS(87),
    [anon_sym_PIPE_GT] = ACTIONS(87),
    [anon_sym_COLON] = ACTIONS(89),
    [anon_sym_DOLLAR] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(91),
    [aux_sym__hex_literal_token1] = ACTIONS(499),
    [sym__number_literal] = ACTIONS(501),
    [anon_sym_SQUOTE] = ACTIONS(499),
    [anon_sym_DQUOTE] = ACTIONS(499),
    [sym_return] = ACTIONS(501),
    [sym_next] = ACTIONS(501),
    [sym_break] = ACTIONS(501),
    [sym_true] = ACTIONS(501),
    [sym_false] = ACTIONS(501),
    [sym_null] = ACTIONS(501),
    [sym_inf] = ACTIONS(501),
    [sym_nan] = ACTIONS(501),
    [anon_sym_NA] = ACTIONS(501),
    [anon_sym_NA_integer_] = ACTIONS(501),
    [anon_sym_NA_real_] = ACTIONS(501),
    [anon_sym_NA_complex_] = ACTIONS(501),
    [anon_sym_NA_character_] = ACTIONS(501),
    [sym_dots] = ACTIONS(501),
    [sym_dot_dot_i] = ACTIONS(499),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(499),
    [sym__newline] = ACTIONS(499),
    [sym__raw_string_literal] = ACTIONS(499),
    [sym__external_else] = ACTIONS(499),
    [sym__external_open_parenthesis] = ACTIONS(95),
    [sym__external_open_brace] = ACTIONS(499),
    [sym__external_open_bracket] = ACTIONS(97),
    [sym__external_close_bracket] = ACTIONS(499),
    [sym__external_open_bracket2] = ACTIONS(99),
  },
  [239] = {
    [sym_call_arguments] = STATE(807),
    [sym_subset_arguments] = STATE(808),
    [sym_subset2_arguments] = STATE(810),
    [sym__open_parenthesis] = STATE(357),
    [sym__open_bracket] = STATE(358),
    [sym__open_bracket2] = STATE(359),
    [sym_identifier] = ACTIONS(505),
    [anon_sym_BSLASH] = ACTIONS(503),
    [anon_sym_function] = ACTIONS(505),
    [anon_sym_EQ] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(505),
    [anon_sym_for] = ACTIONS(505),
    [anon_sym_while] = ACTIONS(505),
    [anon_sym_repeat] = ACTIONS(505),
    [anon_sym_QMARK] = ACTIONS(503),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_BANG] = ACTIONS(505),
    [anon_sym_PLUS] = ACTIONS(59),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_LT_DASH] = ACTIONS(63),
    [anon_sym_LT_LT_DASH] = ACTIONS(63),
    [anon_sym_COLON_EQ] = ACTIONS(63),
    [anon_sym_DASH_GT] = ACTIONS(65),
    [anon_sym_DASH_GT_GT] = ACTIONS(67),
    [anon_sym_PIPE] = ACTIONS(69),
    [anon_sym_AMP] = ACTIONS(71),
    [anon_sym_PIPE_PIPE] = ACTIONS(73),
    [anon_sym_AMP_AMP] = ACTIONS(75),
    [anon_sym_LT] = ACTIONS(77),
    [anon_sym_LT_EQ] = ACTIONS(79),
    [anon_sym_GT] = ACTIONS(77),
    [anon_sym_GT_EQ] = ACTIONS(79),
    [anon_sym_EQ_EQ] = ACTIONS(79),
    [anon_sym_BANG_EQ] = ACTIONS(79),
    [anon_sym_STAR] = ACTIONS(81),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_STAR_STAR] = ACTIONS(85),
    [anon_sym_CARET] = ACTIONS(85),
    [aux_sym_binary_operator_token1] = ACTIONS(87),
    [anon_sym_PIPE_GT] = ACTIONS(87),
    [anon_sym_COLON] = ACTIONS(89),
    [anon_sym_DOLLAR] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(91),
    [aux_sym__hex_literal_token1] = ACTIONS(503),
    [sym__number_literal] = ACTIONS(505),
    [anon_sym_SQUOTE] = ACTIONS(503),
    [anon_sym_DQUOTE] = ACTIONS(503),
    [sym_return] = ACTIONS(505),
    [sym_next] = ACTIONS(505),
    [sym_break] = ACTIONS(505),
    [sym_true] = ACTIONS(505),
    [sym_false] = ACTIONS(505),
    [sym_null] = ACTIONS(505),
    [sym_inf] = ACTIONS(505),
    [sym_nan] = ACTIONS(505),
    [anon_sym_NA] = ACTIONS(505),
    [anon_sym_NA_integer_] = ACTIONS(505),
    [anon_sym_NA_real_] = ACTIONS(505),
    [anon_sym_NA_complex_] = ACTIONS(505),
    [anon_sym_NA_character_] = ACTIONS(505),
    [sym_dots] = ACTIONS(505),
    [sym_dot_dot_i] = ACTIONS(503),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(503),
    [sym__newline] = ACTIONS(503),
    [sym__raw_string_literal] = ACTIONS(503),
    [sym__external_else] = ACTIONS(503),
    [sym__external_open_parenthesis] = ACTIONS(95),
    [sym__external_open_brace] = ACTIONS(503),
    [sym__external_open_bracket] = ACTIONS(97),
    [sym__external_close_bracket] = ACTIONS(503),
    [sym__external_open_bracket2] = ACTIONS(99),
  },
  [240] = {
    [sym_call_arguments] = STATE(807),
    [sym_subset_arguments] = STATE(808),
    [sym_subset2_arguments] = STATE(810),
    [sym__open_parenthesis] = STATE(357),
    [sym__open_bracket] = STATE(358),
    [sym__open_bracket2] = STATE(359),
    [sym_identifier] = ACTIONS(509),
    [anon_sym_BSLASH] = ACTIONS(507),
    [anon_sym_function] = ACTIONS(509),
    [anon_sym_EQ] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(509),
    [anon_sym_for] = ACTIONS(509),
    [anon_sym_while] = ACTIONS(509),
    [anon_sym_repeat] = ACTIONS(509),
    [anon_sym_QMARK] = ACTIONS(507),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_BANG] = ACTIONS(509),
    [anon_sym_PLUS] = ACTIONS(59),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_LT_DASH] = ACTIONS(63),
    [anon_sym_LT_LT_DASH] = ACTIONS(63),
    [anon_sym_COLON_EQ] = ACTIONS(63),
    [anon_sym_DASH_GT] = ACTIONS(65),
    [anon_sym_DASH_GT_GT] = ACTIONS(67),
    [anon_sym_PIPE] = ACTIONS(69),
    [anon_sym_AMP] = ACTIONS(71),
    [anon_sym_PIPE_PIPE] = ACTIONS(73),
    [anon_sym_AMP_AMP] = ACTIONS(75),
    [anon_sym_LT] = ACTIONS(77),
    [anon_sym_LT_EQ] = ACTIONS(79),
    [anon_sym_GT] = ACTIONS(77),
    [anon_sym_GT_EQ] = ACTIONS(79),
    [anon_sym_EQ_EQ] = ACTIONS(79),
    [anon_sym_BANG_EQ] = ACTIONS(79),
    [anon_sym_STAR] = ACTIONS(81),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_STAR_STAR] = ACTIONS(85),
    [anon_sym_CARET] = ACTIONS(85),
    [aux_sym_binary_operator_token1] = ACTIONS(87),
    [anon_sym_PIPE_GT] = ACTIONS(87),
    [anon_sym_COLON] = ACTIONS(89),
    [anon_sym_DOLLAR] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(91),
    [aux_sym__hex_literal_token1] = ACTIONS(507),
    [sym__number_literal] = ACTIONS(509),
    [anon_sym_SQUOTE] = ACTIONS(507),
    [anon_sym_DQUOTE] = ACTIONS(507),
    [sym_return] = ACTIONS(509),
    [sym_next] = ACTIONS(509),
    [sym_break] = ACTIONS(509),
    [sym_true] = ACTIONS(509),
    [sym_false] = ACTIONS(509),
    [sym_null] = ACTIONS(509),
    [sym_inf] = ACTIONS(509),
    [sym_nan] = ACTIONS(509),
    [anon_sym_NA] = ACTIONS(509),
    [anon_sym_NA_integer_] = ACTIONS(509),
    [anon_sym_NA_real_] = ACTIONS(509),
    [anon_sym_NA_complex_] = ACTIONS(509),
    [anon_sym_NA_character_] = ACTIONS(509),
    [sym_dots] = ACTIONS(509),
    [sym_dot_dot_i] = ACTIONS(507),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(507),
    [sym__newline] = ACTIONS(507),
    [sym__raw_string_literal] = ACTIONS(507),
    [sym__external_else] = ACTIONS(507),
    [sym__external_open_parenthesis] = ACTIONS(95),
    [sym__external_open_brace] = ACTIONS(507),
    [sym__external_open_bracket] = ACTIONS(97),
    [sym__external_close_bracket] = ACTIONS(507),
    [sym__external_open_bracket2] = ACTIONS(99),
  },
  [241] = {
    [sym_call_arguments] = STATE(807),
    [sym_subset_arguments] = STATE(808),
    [sym_subset2_arguments] = STATE(810),
    [sym__open_parenthesis] = STATE(357),
    [sym__open_bracket] = STATE(358),
    [sym__open_bracket2] = STATE(359),
    [sym_identifier] = ACTIONS(513),
    [anon_sym_BSLASH] = ACTIONS(511),
    [anon_sym_function] = ACTIONS(513),
    [anon_sym_EQ] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(513),
    [anon_sym_for] = ACTIONS(513),
    [anon_sym_while] = ACTIONS(513),
    [anon_sym_repeat] = ACTIONS(513),
    [anon_sym_QMARK] = ACTIONS(511),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_BANG] = ACTIONS(513),
    [anon_sym_PLUS] = ACTIONS(59),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_LT_DASH] = ACTIONS(63),
    [anon_sym_LT_LT_DASH] = ACTIONS(63),
    [anon_sym_COLON_EQ] = ACTIONS(63),
    [anon_sym_DASH_GT] = ACTIONS(65),
    [anon_sym_DASH_GT_GT] = ACTIONS(67),
    [anon_sym_PIPE] = ACTIONS(69),
    [anon_sym_AMP] = ACTIONS(71),
    [anon_sym_PIPE_PIPE] = ACTIONS(73),
    [anon_sym_AMP_AMP] = ACTIONS(75),
    [anon_sym_LT] = ACTIONS(77),
    [anon_sym_LT_EQ] = ACTIONS(79),
    [anon_sym_GT] = ACTIONS(77),
    [anon_sym_GT_EQ] = ACTIONS(79),
    [anon_sym_EQ_EQ] = ACTIONS(79),
    [anon_sym_BANG_EQ] = ACTIONS(79),
    [anon_sym_STAR] = ACTIONS(81),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_STAR_STAR] = ACTIONS(85),
    [anon_sym_CARET] = ACTIONS(85),
    [aux_sym_binary_operator_token1] = ACTIONS(87),
    [anon_sym_PIPE_GT] = ACTIONS(87),
    [anon_sym_COLON] = ACTIONS(89),
    [anon_sym_DOLLAR] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(91),
    [aux_sym__hex_literal_token1] = ACTIONS(511),
    [sym__number_literal] = ACTIONS(513),
    [anon_sym_SQUOTE] = ACTIONS(511),
    [anon_sym_DQUOTE] = ACTIONS(511),
    [sym_return] = ACTIONS(513),
    [sym_next] = ACTIONS(513),
    [sym_break] = ACTIONS(513),
    [sym_true] = ACTIONS(513),
    [sym_false] = ACTIONS(513),
    [sym_null] = ACTIONS(513),
    [sym_inf] = ACTIONS(513),
    [sym_nan] = ACTIONS(513),
    [anon_sym_NA] = ACTIONS(513),
    [anon_sym_NA_integer_] = ACTIONS(513),
    [anon_sym_NA_real_] = ACTIONS(513),
    [anon_sym_NA_complex_] = ACTIONS(513),
    [anon_sym_NA_character_] = ACTIONS(513),
    [sym_dots] = ACTIONS(513),
    [sym_dot_dot_i] = ACTIONS(511),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(511),
    [sym__newline] = ACTIONS(511),
    [sym__raw_string_literal] = ACTIONS(511),
    [sym__external_else] = ACTIONS(511),
    [sym__external_open_parenthesis] = ACTIONS(95),
    [sym__external_open_brace] = ACTIONS(511),
    [sym__external_open_bracket] = ACTIONS(97),
    [sym__external_close_bracket] = ACTIONS(511),
    [sym__external_open_bracket2] = ACTIONS(99),
  },
  [242] = {
    [sym_call_arguments] = STATE(807),
    [sym_subset_arguments] = STATE(808),
    [sym_subset2_arguments] = STATE(810),
    [sym__open_parenthesis] = STATE(357),
    [sym__open_bracket] = STATE(358),
    [sym__open_bracket2] = STATE(359),
    [sym_identifier] = ACTIONS(517),
    [anon_sym_BSLASH] = ACTIONS(515),
    [anon_sym_function] = ACTIONS(517),
    [anon_sym_EQ] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(517),
    [anon_sym_for] = ACTIONS(517),
    [anon_sym_while] = ACTIONS(517),
    [anon_sym_repeat] = ACTIONS(517),
    [anon_sym_QMARK] = ACTIONS(515),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_BANG] = ACTIONS(517),
    [anon_sym_PLUS] = ACTIONS(59),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_LT_DASH] = ACTIONS(63),
    [anon_sym_LT_LT_DASH] = ACTIONS(63),
    [anon_sym_COLON_EQ] = ACTIONS(63),
    [anon_sym_DASH_GT] = ACTIONS(65),
    [anon_sym_DASH_GT_GT] = ACTIONS(67),
    [anon_sym_PIPE] = ACTIONS(69),
    [anon_sym_AMP] = ACTIONS(71),
    [anon_sym_PIPE_PIPE] = ACTIONS(73),
    [anon_sym_AMP_AMP] = ACTIONS(75),
    [anon_sym_LT] = ACTIONS(77),
    [anon_sym_LT_EQ] = ACTIONS(79),
    [anon_sym_GT] = ACTIONS(77),
    [anon_sym_GT_EQ] = ACTIONS(79),
    [anon_sym_EQ_EQ] = ACTIONS(79),
    [anon_sym_BANG_EQ] = ACTIONS(79),
    [anon_sym_STAR] = ACTIONS(81),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_STAR_STAR] = ACTIONS(85),
    [anon_sym_CARET] = ACTIONS(85),
    [aux_sym_binary_operator_token1] = ACTIONS(87),
    [anon_sym_PIPE_GT] = ACTIONS(87),
    [anon_sym_COLON] = ACTIONS(89),
    [anon_sym_DOLLAR] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(91),
    [aux_sym__hex_literal_token1] = ACTIONS(515),
    [sym__number_literal] = ACTIONS(517),
    [anon_sym_SQUOTE] = ACTIONS(515),
    [anon_sym_DQUOTE] = ACTIONS(515),
    [sym_return] = ACTIONS(517),
    [sym_next] = ACTIONS(517),
    [sym_break] = ACTIONS(517),
    [sym_true] = ACTIONS(517),
    [sym_false] = ACTIONS(517),
    [sym_null] = ACTIONS(517),
    [sym_inf] = ACTIONS(517),
    [sym_nan] = ACTIONS(517),
    [anon_sym_NA] = ACTIONS(517),
    [anon_sym_NA_integer_] = ACTIONS(517),
    [anon_sym_NA_real_] = ACTIONS(517),
    [anon_sym_NA_complex_] = ACTIONS(517),
    [anon_sym_NA_character_] = ACTIONS(517),
    [sym_dots] = ACTIONS(517),
    [sym_dot_dot_i] = ACTIONS(515),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(515),
    [sym__newline] = ACTIONS(515),
    [sym__raw_string_literal] = ACTIONS(515),
    [sym__external_else] = ACTIONS(515),
    [sym__external_open_parenthesis] = ACTIONS(95),
    [sym__external_open_brace] = ACTIONS(515),
    [sym__external_open_bracket] = ACTIONS(97),
    [sym__external_close_bracket] = ACTIONS(515),
    [sym__external_open_bracket2] = ACTIONS(99),
  },
  [243] = {
    [sym_call_arguments] = STATE(807),
    [sym_subset_arguments] = STATE(808),
    [sym_subset2_arguments] = STATE(810),
    [sym__open_parenthesis] = STATE(357),
    [sym__open_bracket] = STATE(358),
    [sym__open_bracket2] = STATE(359),
    [sym_identifier] = ACTIONS(521),
    [anon_sym_BSLASH] = ACTIONS(519),
    [anon_sym_function] = ACTIONS(521),
    [anon_sym_EQ] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(521),
    [anon_sym_for] = ACTIONS(521),
    [anon_sym_while] = ACTIONS(521),
    [anon_sym_repeat] = ACTIONS(521),
    [anon_sym_QMARK] = ACTIONS(519),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_BANG] = ACTIONS(521),
    [anon_sym_PLUS] = ACTIONS(59),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_LT_DASH] = ACTIONS(63),
    [anon_sym_LT_LT_DASH] = ACTIONS(63),
    [anon_sym_COLON_EQ] = ACTIONS(63),
    [anon_sym_DASH_GT] = ACTIONS(65),
    [anon_sym_DASH_GT_GT] = ACTIONS(67),
    [anon_sym_PIPE] = ACTIONS(69),
    [anon_sym_AMP] = ACTIONS(71),
    [anon_sym_PIPE_PIPE] = ACTIONS(73),
    [anon_sym_AMP_AMP] = ACTIONS(75),
    [anon_sym_LT] = ACTIONS(77),
    [anon_sym_LT_EQ] = ACTIONS(79),
    [anon_sym_GT] = ACTIONS(77),
    [anon_sym_GT_EQ] = ACTIONS(79),
    [anon_sym_EQ_EQ] = ACTIONS(79),
    [anon_sym_BANG_EQ] = ACTIONS(79),
    [anon_sym_STAR] = ACTIONS(81),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_STAR_STAR] = ACTIONS(85),
    [anon_sym_CARET] = ACTIONS(85),
    [aux_sym_binary_operator_token1] = ACTIONS(87),
    [anon_sym_PIPE_GT] = ACTIONS(87),
    [anon_sym_COLON] = ACTIONS(89),
    [anon_sym_DOLLAR] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(91),
    [aux_sym__hex_literal_token1] = ACTIONS(519),
    [sym__number_literal] = ACTIONS(521),
    [anon_sym_SQUOTE] = ACTIONS(519),
    [anon_sym_DQUOTE] = ACTIONS(519),
    [sym_return] = ACTIONS(521),
    [sym_next] = ACTIONS(521),
    [sym_break] = ACTIONS(521),
    [sym_true] = ACTIONS(521),
    [sym_false] = ACTIONS(521),
    [sym_null] = ACTIONS(521),
    [sym_inf] = ACTIONS(521),
    [sym_nan] = ACTIONS(521),
    [anon_sym_NA] = ACTIONS(521),
    [anon_sym_NA_integer_] = ACTIONS(521),
    [anon_sym_NA_real_] = ACTIONS(521),
    [anon_sym_NA_complex_] = ACTIONS(521),
    [anon_sym_NA_character_] = ACTIONS(521),
    [sym_dots] = ACTIONS(521),
    [sym_dot_dot_i] = ACTIONS(519),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(519),
    [sym__newline] = ACTIONS(519),
    [sym__raw_string_literal] = ACTIONS(519),
    [sym__external_else] = ACTIONS(519),
    [sym__external_open_parenthesis] = ACTIONS(95),
    [sym__external_open_brace] = ACTIONS(519),
    [sym__external_open_bracket] = ACTIONS(97),
    [sym__external_close_bracket] = ACTIONS(519),
    [sym__external_open_bracket2] = ACTIONS(99),
  },
  [244] = {
    [sym_call_arguments] = STATE(807),
    [sym_subset_arguments] = STATE(808),
    [sym_subset2_arguments] = STATE(810),
    [sym__open_parenthesis] = STATE(357),
    [sym__open_bracket] = STATE(358),
    [sym__open_bracket2] = STATE(359),
    [sym_identifier] = ACTIONS(525),
    [anon_sym_BSLASH] = ACTIONS(523),
    [anon_sym_function] = ACTIONS(525),
    [anon_sym_EQ] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(525),
    [anon_sym_for] = ACTIONS(525),
    [anon_sym_while] = ACTIONS(525),
    [anon_sym_repeat] = ACTIONS(525),
    [anon_sym_QMARK] = ACTIONS(523),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_BANG] = ACTIONS(525),
    [anon_sym_PLUS] = ACTIONS(59),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_LT_DASH] = ACTIONS(63),
    [anon_sym_LT_LT_DASH] = ACTIONS(63),
    [anon_sym_COLON_EQ] = ACTIONS(63),
    [anon_sym_DASH_GT] = ACTIONS(65),
    [anon_sym_DASH_GT_GT] = ACTIONS(67),
    [anon_sym_PIPE] = ACTIONS(69),
    [anon_sym_AMP] = ACTIONS(71),
    [anon_sym_PIPE_PIPE] = ACTIONS(73),
    [anon_sym_AMP_AMP] = ACTIONS(75),
    [anon_sym_LT] = ACTIONS(77),
    [anon_sym_LT_EQ] = ACTIONS(79),
    [anon_sym_GT] = ACTIONS(77),
    [anon_sym_GT_EQ] = ACTIONS(79),
    [anon_sym_EQ_EQ] = ACTIONS(79),
    [anon_sym_BANG_EQ] = ACTIONS(79),
    [anon_sym_STAR] = ACTIONS(81),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_STAR_STAR] = ACTIONS(85),
    [anon_sym_CARET] = ACTIONS(85),
    [aux_sym_binary_operator_token1] = ACTIONS(87),
    [anon_sym_PIPE_GT] = ACTIONS(87),
    [anon_sym_COLON] = ACTIONS(89),
    [anon_sym_DOLLAR] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(91),
    [aux_sym__hex_literal_token1] = ACTIONS(523),
    [sym__number_literal] = ACTIONS(525),
    [anon_sym_SQUOTE] = ACTIONS(523),
    [anon_sym_DQUOTE] = ACTIONS(523),
    [sym_return] = ACTIONS(525),
    [sym_next] = ACTIONS(525),
    [sym_break] = ACTIONS(525),
    [sym_true] = ACTIONS(525),
    [sym_false] = ACTIONS(525),
    [sym_null] = ACTIONS(525),
    [sym_inf] = ACTIONS(525),
    [sym_nan] = ACTIONS(525),
    [anon_sym_NA] = ACTIONS(525),
    [anon_sym_NA_integer_] = ACTIONS(525),
    [anon_sym_NA_real_] = ACTIONS(525),
    [anon_sym_NA_complex_] = ACTIONS(525),
    [anon_sym_NA_character_] = ACTIONS(525),
    [sym_dots] = ACTIONS(525),
    [sym_dot_dot_i] = ACTIONS(523),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(523),
    [sym__newline] = ACTIONS(523),
    [sym__raw_string_literal] = ACTIONS(523),
    [sym__external_else] = ACTIONS(523),
    [sym__external_open_parenthesis] = ACTIONS(95),
    [sym__external_open_brace] = ACTIONS(523),
    [sym__external_open_bracket] = ACTIONS(97),
    [sym__external_close_bracket] = ACTIONS(523),
    [sym__external_open_bracket2] = ACTIONS(99),
  },
  [245] = {
    [sym_call_arguments] = STATE(807),
    [sym_subset_arguments] = STATE(808),
    [sym_subset2_arguments] = STATE(810),
    [sym__open_parenthesis] = STATE(357),
    [sym__open_bracket] = STATE(358),
    [sym__open_bracket2] = STATE(359),
    [sym_identifier] = ACTIONS(529),
    [anon_sym_BSLASH] = ACTIONS(527),
    [anon_sym_function] = ACTIONS(529),
    [anon_sym_EQ] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(529),
    [anon_sym_for] = ACTIONS(529),
    [anon_sym_while] = ACTIONS(529),
    [anon_sym_repeat] = ACTIONS(529),
    [anon_sym_QMARK] = ACTIONS(527),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_BANG] = ACTIONS(529),
    [anon_sym_PLUS] = ACTIONS(59),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_LT_DASH] = ACTIONS(63),
    [anon_sym_LT_LT_DASH] = ACTIONS(63),
    [anon_sym_COLON_EQ] = ACTIONS(63),
    [anon_sym_DASH_GT] = ACTIONS(65),
    [anon_sym_DASH_GT_GT] = ACTIONS(67),
    [anon_sym_PIPE] = ACTIONS(69),
    [anon_sym_AMP] = ACTIONS(71),
    [anon_sym_PIPE_PIPE] = ACTIONS(73),
    [anon_sym_AMP_AMP] = ACTIONS(75),
    [anon_sym_LT] = ACTIONS(77),
    [anon_sym_LT_EQ] = ACTIONS(79),
    [anon_sym_GT] = ACTIONS(77),
    [anon_sym_GT_EQ] = ACTIONS(79),
    [anon_sym_EQ_EQ] = ACTIONS(79),
    [anon_sym_BANG_EQ] = ACTIONS(79),
    [anon_sym_STAR] = ACTIONS(81),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_STAR_STAR] = ACTIONS(85),
    [anon_sym_CARET] = ACTIONS(85),
    [aux_sym_binary_operator_token1] = ACTIONS(87),
    [anon_sym_PIPE_GT] = ACTIONS(87),
    [anon_sym_COLON] = ACTIONS(89),
    [anon_sym_DOLLAR] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(91),
    [aux_sym__hex_literal_token1] = ACTIONS(527),
    [sym__number_literal] = ACTIONS(529),
    [anon_sym_SQUOTE] = ACTIONS(527),
    [anon_sym_DQUOTE] = ACTIONS(527),
    [sym_return] = ACTIONS(529),
    [sym_next] = ACTIONS(529),
    [sym_break] = ACTIONS(529),
    [sym_true] = ACTIONS(529),
    [sym_false] = ACTIONS(529),
    [sym_null] = ACTIONS(529),
    [sym_inf] = ACTIONS(529),
    [sym_nan] = ACTIONS(529),
    [anon_sym_NA] = ACTIONS(529),
    [anon_sym_NA_integer_] = ACTIONS(529),
    [anon_sym_NA_real_] = ACTIONS(529),
    [anon_sym_NA_complex_] = ACTIONS(529),
    [anon_sym_NA_character_] = ACTIONS(529),
    [sym_dots] = ACTIONS(529),
    [sym_dot_dot_i] = ACTIONS(527),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(527),
    [sym__newline] = ACTIONS(527),
    [sym__raw_string_literal] = ACTIONS(527),
    [sym__external_else] = ACTIONS(527),
    [sym__external_open_parenthesis] = ACTIONS(95),
    [sym__external_open_brace] = ACTIONS(527),
    [sym__external_open_bracket] = ACTIONS(97),
    [sym__external_close_bracket] = ACTIONS(527),
    [sym__external_open_bracket2] = ACTIONS(99),
  },
  [246] = {
    [sym_call_arguments] = STATE(807),
    [sym_subset_arguments] = STATE(808),
    [sym_subset2_arguments] = STATE(810),
    [sym__open_parenthesis] = STATE(357),
    [sym__open_bracket] = STATE(358),
    [sym__open_bracket2] = STATE(359),
    [sym_identifier] = ACTIONS(533),
    [anon_sym_BSLASH] = ACTIONS(531),
    [anon_sym_function] = ACTIONS(533),
    [anon_sym_EQ] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(533),
    [anon_sym_for] = ACTIONS(533),
    [anon_sym_while] = ACTIONS(533),
    [anon_sym_repeat] = ACTIONS(533),
    [anon_sym_QMARK] = ACTIONS(531),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_BANG] = ACTIONS(533),
    [anon_sym_PLUS] = ACTIONS(59),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_LT_DASH] = ACTIONS(63),
    [anon_sym_LT_LT_DASH] = ACTIONS(63),
    [anon_sym_COLON_EQ] = ACTIONS(63),
    [anon_sym_DASH_GT] = ACTIONS(65),
    [anon_sym_DASH_GT_GT] = ACTIONS(67),
    [anon_sym_PIPE] = ACTIONS(69),
    [anon_sym_AMP] = ACTIONS(71),
    [anon_sym_PIPE_PIPE] = ACTIONS(73),
    [anon_sym_AMP_AMP] = ACTIONS(75),
    [anon_sym_LT] = ACTIONS(77),
    [anon_sym_LT_EQ] = ACTIONS(79),
    [anon_sym_GT] = ACTIONS(77),
    [anon_sym_GT_EQ] = ACTIONS(79),
    [anon_sym_EQ_EQ] = ACTIONS(79),
    [anon_sym_BANG_EQ] = ACTIONS(79),
    [anon_sym_STAR] = ACTIONS(81),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_STAR_STAR] = ACTIONS(85),
    [anon_sym_CARET] = ACTIONS(85),
    [aux_sym_binary_operator_token1] = ACTIONS(87),
    [anon_sym_PIPE_GT] = ACTIONS(87),
    [anon_sym_COLON] = ACTIONS(89),
    [anon_sym_DOLLAR] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(91),
    [aux_sym__hex_literal_token1] = ACTIONS(531),
    [sym__number_literal] = ACTIONS(533),
    [anon_sym_SQUOTE] = ACTIONS(531),
    [anon_sym_DQUOTE] = ACTIONS(531),
    [sym_return] = ACTIONS(533),
    [sym_next] = ACTIONS(533),
    [sym_break] = ACTIONS(533),
    [sym_true] = ACTIONS(533),
    [sym_false] = ACTIONS(533),
    [sym_null] = ACTIONS(533),
    [sym_inf] = ACTIONS(533),
    [sym_nan] = ACTIONS(533),
    [anon_sym_NA] = ACTIONS(533),
    [anon_sym_NA_integer_] = ACTIONS(533),
    [anon_sym_NA_real_] = ACTIONS(533),
    [anon_sym_NA_complex_] = ACTIONS(533),
    [anon_sym_NA_character_] = ACTIONS(533),
    [sym_dots] = ACTIONS(533),
    [sym_dot_dot_i] = ACTIONS(531),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(531),
    [sym__newline] = ACTIONS(531),
    [sym__raw_string_literal] = ACTIONS(531),
    [sym__external_else] = ACTIONS(531),
    [sym__external_open_parenthesis] = ACTIONS(95),
    [sym__external_open_brace] = ACTIONS(531),
    [sym__external_open_bracket] = ACTIONS(97),
    [sym__external_close_bracket] = ACTIONS(531),
    [sym__external_open_bracket2] = ACTIONS(99),
  },
  [247] = {
    [sym_call_arguments] = STATE(807),
    [sym_subset_arguments] = STATE(808),
    [sym_subset2_arguments] = STATE(810),
    [sym__open_parenthesis] = STATE(357),
    [sym__open_bracket] = STATE(358),
    [sym__open_bracket2] = STATE(359),
    [sym_identifier] = ACTIONS(537),
    [anon_sym_BSLASH] = ACTIONS(535),
    [anon_sym_function] = ACTIONS(537),
    [anon_sym_EQ] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(537),
    [anon_sym_for] = ACTIONS(537),
    [anon_sym_while] = ACTIONS(537),
    [anon_sym_repeat] = ACTIONS(537),
    [anon_sym_QMARK] = ACTIONS(535),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_BANG] = ACTIONS(537),
    [anon_sym_PLUS] = ACTIONS(59),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_LT_DASH] = ACTIONS(63),
    [anon_sym_LT_LT_DASH] = ACTIONS(63),
    [anon_sym_COLON_EQ] = ACTIONS(63),
    [anon_sym_DASH_GT] = ACTIONS(65),
    [anon_sym_DASH_GT_GT] = ACTIONS(67),
    [anon_sym_PIPE] = ACTIONS(69),
    [anon_sym_AMP] = ACTIONS(71),
    [anon_sym_PIPE_PIPE] = ACTIONS(73),
    [anon_sym_AMP_AMP] = ACTIONS(75),
    [anon_sym_LT] = ACTIONS(77),
    [anon_sym_LT_EQ] = ACTIONS(79),
    [anon_sym_GT] = ACTIONS(77),
    [anon_sym_GT_EQ] = ACTIONS(79),
    [anon_sym_EQ_EQ] = ACTIONS(79),
    [anon_sym_BANG_EQ] = ACTIONS(79),
    [anon_sym_STAR] = ACTIONS(81),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_STAR_STAR] = ACTIONS(85),
    [anon_sym_CARET] = ACTIONS(85),
    [aux_sym_binary_operator_token1] = ACTIONS(87),
    [anon_sym_PIPE_GT] = ACTIONS(87),
    [anon_sym_COLON] = ACTIONS(89),
    [anon_sym_DOLLAR] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(91),
    [aux_sym__hex_literal_token1] = ACTIONS(535),
    [sym__number_literal] = ACTIONS(537),
    [anon_sym_SQUOTE] = ACTIONS(535),
    [anon_sym_DQUOTE] = ACTIONS(535),
    [sym_return] = ACTIONS(537),
    [sym_next] = ACTIONS(537),
    [sym_break] = ACTIONS(537),
    [sym_true] = ACTIONS(537),
    [sym_false] = ACTIONS(537),
    [sym_null] = ACTIONS(537),
    [sym_inf] = ACTIONS(537),
    [sym_nan] = ACTIONS(537),
    [anon_sym_NA] = ACTIONS(537),
    [anon_sym_NA_integer_] = ACTIONS(537),
    [anon_sym_NA_real_] = ACTIONS(537),
    [anon_sym_NA_complex_] = ACTIONS(537),
    [anon_sym_NA_character_] = ACTIONS(537),
    [sym_dots] = ACTIONS(537),
    [sym_dot_dot_i] = ACTIONS(535),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(535),
    [sym__newline] = ACTIONS(535),
    [sym__raw_string_literal] = ACTIONS(535),
    [sym__external_else] = ACTIONS(535),
    [sym__external_open_parenthesis] = ACTIONS(95),
    [sym__external_open_brace] = ACTIONS(535),
    [sym__external_open_bracket] = ACTIONS(97),
    [sym__external_close_bracket] = ACTIONS(535),
    [sym__external_open_bracket2] = ACTIONS(99),
  },
  [248] = {
    [sym_call_arguments] = STATE(807),
    [sym_subset_arguments] = STATE(808),
    [sym_subset2_arguments] = STATE(810),
    [sym__open_parenthesis] = STATE(357),
    [sym__open_bracket] = STATE(358),
    [sym__open_bracket2] = STATE(359),
    [sym_identifier] = ACTIONS(541),
    [anon_sym_BSLASH] = ACTIONS(539),
    [anon_sym_function] = ACTIONS(541),
    [anon_sym_EQ] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(541),
    [anon_sym_for] = ACTIONS(541),
    [anon_sym_while] = ACTIONS(541),
    [anon_sym_repeat] = ACTIONS(541),
    [anon_sym_QMARK] = ACTIONS(539),
    [anon_sym_TILDE] = ACTIONS(57),
    [anon_sym_BANG] = ACTIONS(541),
    [anon_sym_PLUS] = ACTIONS(59),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_LT_DASH] = ACTIONS(63),
    [anon_sym_LT_LT_DASH] = ACTIONS(63),
    [anon_sym_COLON_EQ] = ACTIONS(63),
    [anon_sym_DASH_GT] = ACTIONS(65),
    [anon_sym_DASH_GT_GT] = ACTIONS(67),
    [anon_sym_PIPE] = ACTIONS(69),
    [anon_sym_AMP] = ACTIONS(71),
    [anon_sym_PIPE_PIPE] = ACTIONS(73),
    [anon_sym_AMP_AMP] = ACTIONS(75),
    [anon_sym_LT] = ACTIONS(77),
    [anon_sym_LT_EQ] = ACTIONS(79),
    [anon_sym_GT] = ACTIONS(77),
    [anon_sym_GT_EQ] = ACTIONS(79),
    [anon_sym_EQ_EQ] = ACTIONS(79),
    [anon_sym_BANG_EQ] = ACTIONS(79),
    [anon_sym_STAR] = ACTIONS(81),
    [anon_sym_SLASH] = ACTIONS(83),
    [anon_sym_STAR_STAR] = ACTIONS(85),
    [anon_sym_CARET] = ACTIONS(85),
    [aux_sym_binary_operator_token1] = ACTIONS(87),
    [anon_sym_PIPE_GT] = ACTIONS(87),
    [anon_sym_COLON] = ACTIONS(89),
    [anon_sym_DOLLAR] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(91),
    [aux_sym__hex_literal_token1] = ACTIONS(539),
    [sym__number_literal] = ACTIONS(541),
    [anon_sym_SQUOTE] = ACTIONS(539),
    [anon_sym_DQUOTE] = ACTIONS(539),
    [sym_return] = ACTIONS(541),
    [sym_next] = ACTIONS(541),
    [sym_break] = ACTIONS(541),
    [sym_true] = ACTIONS(541),
    [sym_false] = ACTIONS(541),
    [sym_null] = ACTIONS(541),
    [sym_inf] = ACTIONS(541),
    [sym_nan] = ACTIONS(541),
    [anon_sym_NA] = ACTIONS(541),
    [anon_sym_NA_integer_] = ACTIONS(541),
    [anon_sym_NA_real_] = ACTIONS(541),
    [anon_sym_NA_complex_] = ACTIONS(541),
    [anon_sym_NA_character_] = ACTIONS(541),
    [sym_dots] = ACTIONS(541),
    [sym_dot_dot_i] = ACTIONS(539),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(539),
    [sym__newline] = ACTIONS(539),
    [sym__raw_string_literal] = ACTIONS(539),
    [sym__external_else] = ACTIONS(539),
    [sym__external_open_parenthesis] = ACTIONS(95),
    [sym__external_open_brace] = ACTIONS(539),
    [sym__external_open_bracket] = ACTIONS(97),
    [sym__external_close_bracket] = ACTIONS(539),
    [sym__external_open_bracket2] = ACTIONS(99),
  },
  [249] = {
    [sym_call_arguments] = STATE(795),
    [sym_subset_arguments] = STATE(796),
    [sym_subset2_arguments] = STATE(797),
    [sym__open_parenthesis] = STATE(361),
    [sym__open_bracket] = STATE(362),
    [sym__open_bracket2] = STATE(199),
    [sym_identifier] = ACTIONS(543),
    [anon_sym_BSLASH] = ACTIONS(545),
    [anon_sym_function] = ACTIONS(543),
    [anon_sym_EQ] = ACTIONS(273),
    [anon_sym_if] = ACTIONS(543),
    [anon_sym_for] = ACTIONS(543),
    [anon_sym_while] = ACTIONS(543),
    [anon_sym_repeat] = ACTIONS(543),
    [anon_sym_QMARK] = ACTIONS(545),
    [anon_sym_TILDE] = ACTIONS(275),
    [anon_sym_BANG] = ACTIONS(543),
    [anon_sym_PLUS] = ACTIONS(277),
    [anon_sym_DASH] = ACTIONS(279),
    [anon_sym_LT_DASH] = ACTIONS(281),
    [anon_sym_LT_LT_DASH] = ACTIONS(281),
    [anon_sym_COLON_EQ] = ACTIONS(281),
    [anon_sym_DASH_GT] = ACTIONS(283),
    [anon_sym_DASH_GT_GT] = ACTIONS(285),
    [anon_sym_PIPE] = ACTIONS(287),
    [anon_sym_AMP] = ACTIONS(289),
    [anon_sym_PIPE_PIPE] = ACTIONS(291),
    [anon_sym_AMP_AMP] = ACTIONS(293),
    [anon_sym_LT] = ACTIONS(295),
    [anon_sym_LT_EQ] = ACTIONS(297),
    [anon_sym_GT] = ACTIONS(295),
    [anon_sym_GT_EQ] = ACTIONS(297),
    [anon_sym_EQ_EQ] = ACTIONS(297),
    [anon_sym_BANG_EQ] = ACTIONS(297),
    [anon_sym_STAR] = ACTIONS(299),
    [anon_sym_SLASH] = ACTIONS(301),
    [anon_sym_STAR_STAR] = ACTIONS(303),
    [anon_sym_CARET] = ACTIONS(303),
    [aux_sym_binary_operator_token1] = ACTIONS(305),
    [anon_sym_PIPE_GT] = ACTIONS(305),
    [anon_sym_COLON] = ACTIONS(307),
    [anon_sym_DOLLAR] = ACTIONS(309),
    [anon_sym_AT] = ACTIONS(309),
    [aux_sym__hex_literal_token1] = ACTIONS(545),
    [sym__number_literal] = ACTIONS(543),
    [anon_sym_SQUOTE] = ACTIONS(545),
    [anon_sym_DQUOTE] = ACTIONS(545),
    [sym_return] = ACTIONS(543),
    [sym_next] = ACTIONS(543),
    [sym_break] = ACTIONS(543),
    [sym_true] = ACTIONS(543),
    [sym_false] = ACTIONS(543),
    [sym_null] = ACTIONS(543),
    [sym_inf] = ACTIONS(543),
    [sym_nan] = ACTIONS(543),
    [anon_sym_NA] = ACTIONS(543),
    [anon_sym_NA_integer_] = ACTIONS(543),
    [anon_sym_NA_real_] = ACTIONS(543),
    [anon_sym_NA_complex_] = ACTIONS(543),
    [anon_sym_NA_character_] = ACTIONS(543),
    [sym_dots] = ACTIONS(543),
    [sym_dot_dot_i] = ACTIONS(545),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(545),
    [sym__newline] = ACTIONS(545),
    [sym__raw_string_literal] = ACTIONS(545),
    [sym__external_else] = ACTIONS(545),
    [sym__external_open_parenthesis] = ACTIONS(313),
    [sym__external_open_brace] = ACTIONS(545),
    [sym__external_open_bracket] = ACTIONS(315),
    [sym__external_open_bracket2] = ACTIONS(317),
    [sym__external_close_bracket2] = ACTIONS(545),
  },
  [250] = {
    [sym_call_arguments] = STATE(795),
    [sym_subset_arguments] = STATE(796),
    [sym_subset2_arguments] = STATE(797),
    [sym__open_parenthesis] = STATE(361),
    [sym__open_bracket] = STATE(362),
    [sym__open_bracket2] = STATE(199),
    [sym_identifier] = ACTIONS(367),
    [anon_sym_BSLASH] = ACTIONS(369),
    [anon_sym_function] = ACTIONS(367),
    [anon_sym_EQ] = ACTIONS(273),
    [anon_sym_if] = ACTIONS(367),
    [anon_sym_for] = ACTIONS(367),
    [anon_sym_while] = ACTIONS(367),
    [anon_sym_repeat] = ACTIONS(367),
    [anon_sym_QMARK] = ACTIONS(369),
    [anon_sym_TILDE] = ACTIONS(275),
    [anon_sym_BANG] = ACTIONS(367),
    [anon_sym_PLUS] = ACTIONS(277),
    [anon_sym_DASH] = ACTIONS(279),
    [anon_sym_LT_DASH] = ACTIONS(281),
    [anon_sym_LT_LT_DASH] = ACTIONS(281),
    [anon_sym_COLON_EQ] = ACTIONS(281),
    [anon_sym_DASH_GT] = ACTIONS(283),
    [anon_sym_DASH_GT_GT] = ACTIONS(285),
    [anon_sym_PIPE] = ACTIONS(287),
    [anon_sym_AMP] = ACTIONS(289),
    [anon_sym_PIPE_PIPE] = ACTIONS(291),
    [anon_sym_AMP_AMP] = ACTIONS(293),
    [anon_sym_LT] = ACTIONS(295),
    [anon_sym_LT_EQ] = ACTIONS(297),
    [anon_sym_GT] = ACTIONS(295),
    [anon_sym_GT_EQ] = ACTIONS(297),
    [anon_sym_EQ_EQ] = ACTIONS(297),
    [anon_sym_BANG_EQ] = ACTIONS(297),
    [anon_sym_STAR] = ACTIONS(299),
    [anon_sym_SLASH] = ACTIONS(301),
    [anon_sym_STAR_STAR] = ACTIONS(303),
    [anon_sym_CARET] = ACTIONS(303),
    [aux_sym_binary_operator_token1] = ACTIONS(305),
    [anon_sym_PIPE_GT] = ACTIONS(305),
    [anon_sym_COLON] = ACTIONS(307),
    [anon_sym_DOLLAR] = ACTIONS(309),
    [anon_sym_AT] = ACTIONS(309),
    [aux_sym__hex_literal_token1] = ACTIONS(369),
    [sym__number_literal] = ACTIONS(367),
    [anon_sym_SQUOTE] = ACTIONS(369),
    [anon_sym_DQUOTE] = ACTIONS(369),
    [sym_return] = ACTIONS(367),
    [sym_next] = ACTIONS(367),
    [sym_break] = ACTIONS(367),
    [sym_true] = ACTIONS(367),
    [sym_false] = ACTIONS(367),
    [sym_null] = ACTIONS(367),
    [sym_inf] = ACTIONS(367),
    [sym_nan] = ACTIONS(367),
    [anon_sym_NA] = ACTIONS(367),
    [anon_sym_NA_integer_] = ACTIONS(367),
    [anon_sym_NA_real_] = ACTIONS(367),
    [anon_sym_NA_complex_] = ACTIONS(367),
    [anon_sym_NA_character_] = ACTIONS(367),
    [sym_dots] = ACTIONS(367),
    [sym_dot_dot_i] = ACTIONS(369),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(369),
    [sym__newline] = ACTIONS(369),
    [sym__raw_string_literal] = ACTIONS(369),
    [sym__external_else] = ACTIONS(369),
    [sym__external_open_parenthesis] = ACTIONS(313),
    [sym__external_open_brace] = ACTIONS(369),
    [sym__external_open_bracket] = ACTIONS(315),
    [sym__external_open_bracket2] = ACTIONS(317),
    [sym__external_close_bracket2] = ACTIONS(369),
  },
  [251] = {
    [sym_call_arguments] = STATE(795),
    [sym_subset_arguments] = STATE(796),
    [sym_subset2_arguments] = STATE(797),
    [sym__open_parenthesis] = STATE(361),
    [sym__open_bracket] = STATE(362),
    [sym__open_bracket2] = STATE(199),
    [sym_identifier] = ACTIONS(367),
    [anon_sym_BSLASH] = ACTIONS(369),
    [anon_sym_function] = ACTIONS(367),
    [anon_sym_EQ] = ACTIONS(367),
    [anon_sym_if] = ACTIONS(367),
    [anon_sym_for] = ACTIONS(367),
    [anon_sym_while] = ACTIONS(367),
    [anon_sym_repeat] = ACTIONS(367),
    [anon_sym_QMARK] = ACTIONS(369),
    [anon_sym_TILDE] = ACTIONS(369),
    [anon_sym_BANG] = ACTIONS(367),
    [anon_sym_PLUS] = ACTIONS(277),
    [anon_sym_DASH] = ACTIONS(279),
    [anon_sym_LT_DASH] = ACTIONS(369),
    [anon_sym_LT_LT_DASH] = ACTIONS(369),
    [anon_sym_COLON_EQ] = ACTIONS(369),
    [anon_sym_DASH_GT] = ACTIONS(367),
    [anon_sym_DASH_GT_GT] = ACTIONS(369),
    [anon_sym_PIPE] = ACTIONS(287),
    [anon_sym_AMP] = ACTIONS(289),
    [anon_sym_PIPE_PIPE] = ACTIONS(291),
    [anon_sym_AMP_AMP] = ACTIONS(293),
    [anon_sym_LT] = ACTIONS(295),
    [anon_sym_LT_EQ] = ACTIONS(297),
    [anon_sym_GT] = ACTIONS(295),
    [anon_sym_GT_EQ] = ACTIONS(297),
    [anon_sym_EQ_EQ] = ACTIONS(297),
    [anon_sym_BANG_EQ] = ACTIONS(297),
    [anon_sym_STAR] = ACTIONS(299),
    [anon_sym_SLASH] = ACTIONS(301),
    [anon_sym_STAR_STAR] = ACTIONS(303),
    [anon_sym_CARET] = ACTIONS(303),
    [aux_sym_binary_operator_token1] = ACTIONS(305),
    [anon_sym_PIPE_GT] = ACTIONS(305),
    [anon_sym_COLON] = ACTIONS(307),
    [anon_sym_DOLLAR] = ACTIONS(309),
    [anon_sym_AT] = ACTIONS(309),
    [aux_sym__hex_literal_token1] = ACTIONS(369),
    [sym__number_literal] = ACTIONS(367),
    [anon_sym_SQUOTE] = ACTIONS(369),
    [anon_sym_DQUOTE] = ACTIONS(369),
    [sym_return] = ACTIONS(367),
    [sym_next] = ACTIONS(367),
    [sym_break] = ACTIONS(367),
    [sym_true] = ACTIONS(367),
    [sym_false] = ACTIONS(367),
    [sym_null] = ACTIONS(367),
    [sym_inf] = ACTIONS(367),
    [sym_nan] = ACTIONS(367),
    [anon_sym_NA] = ACTIONS(367),
    [anon_sym_NA_integer_] = ACTIONS(367),
    [anon_sym_NA_real_] = ACTIONS(367),
    [anon_sym_NA_complex_] = ACTIONS(367),
    [anon_sym_NA_character_] = ACTIONS(367),
    [sym_dots] = ACTIONS(367),
    [sym_dot_dot_i] = ACTIONS(369),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(369),
    [sym__newline] = ACTIONS(369),
    [sym__raw_string_literal] = ACTIONS(369),
    [sym__external_else] = ACTIONS(369),
    [sym__external_open_parenthesis] = ACTIONS(313),
    [sym__external_open_brace] = ACTIONS(369),
    [sym__external_open_bracket] = ACTIONS(315),
    [sym__external_open_bracket2] = ACTIONS(317),
    [sym__external_close_bracket2] = ACTIONS(369),
  },
  [252] = {
    [sym_call_arguments] = STATE(795),
    [sym_subset_arguments] = STATE(796),
    [sym_subset2_arguments] = STATE(797),
    [sym__open_parenthesis] = STATE(361),
    [sym__open_bracket] = STATE(362),
    [sym__open_bracket2] = STATE(199),
    [sym_identifier] = ACTIONS(367),
    [anon_sym_BSLASH] = ACTIONS(369),
    [anon_sym_function] = ACTIONS(367),
    [anon_sym_EQ] = ACTIONS(367),
    [anon_sym_if] = ACTIONS(367),
    [anon_sym_for] = ACTIONS(367),
    [anon_sym_while] = ACTIONS(367),
    [anon_sym_repeat] = ACTIONS(367),
    [anon_sym_QMARK] = ACTIONS(369),
    [anon_sym_TILDE] = ACTIONS(369),
    [anon_sym_BANG] = ACTIONS(367),
    [anon_sym_PLUS] = ACTIONS(277),
    [anon_sym_DASH] = ACTIONS(279),
    [anon_sym_LT_DASH] = ACTIONS(369),
    [anon_sym_LT_LT_DASH] = ACTIONS(369),
    [anon_sym_COLON_EQ] = ACTIONS(369),
    [anon_sym_DASH_GT] = ACTIONS(367),
    [anon_sym_DASH_GT_GT] = ACTIONS(369),
    [anon_sym_PIPE] = ACTIONS(367),
    [anon_sym_AMP] = ACTIONS(367),
    [anon_sym_PIPE_PIPE] = ACTIONS(369),
    [anon_sym_AMP_AMP] = ACTIONS(369),
    [anon_sym_LT] = ACTIONS(295),
    [anon_sym_LT_EQ] = ACTIONS(297),
    [anon_sym_GT] = ACTIONS(295),
    [anon_sym_GT_EQ] = ACTIONS(297),
    [anon_sym_EQ_EQ] = ACTIONS(297),
    [anon_sym_BANG_EQ] = ACTIONS(297),
    [anon_sym_STAR] = ACTIONS(299),
    [anon_sym_SLASH] = ACTIONS(301),
    [anon_sym_STAR_STAR] = ACTIONS(303),
    [anon_sym_CARET] = ACTIONS(303),
    [aux_sym_binary_operator_token1] = ACTIONS(305),
    [anon_sym_PIPE_GT] = ACTIONS(305),
    [anon_sym_COLON] = ACTIONS(307),
    [anon_sym_DOLLAR] = ACTIONS(309),
    [anon_sym_AT] = ACTIONS(309),
    [aux_sym__hex_literal_token1] = ACTIONS(369),
    [sym__number_literal] = ACTIONS(367),
    [anon_sym_SQUOTE] = ACTIONS(369),
    [anon_sym_DQUOTE] = ACTIONS(369),
    [sym_return] = ACTIONS(367),
    [sym_next] = ACTIONS(367),
    [sym_break] = ACTIONS(367),
    [sym_true] = ACTIONS(367),
    [sym_false] = ACTIONS(367),
    [sym_null] = ACTIONS(367),
    [sym_inf] = ACTIONS(367),
    [sym_nan] = ACTIONS(367),
    [anon_sym_NA] = ACTIONS(367),
    [anon_sym_NA_integer_] = ACTIONS(367),
    [anon_sym_NA_real_] = ACTIONS(367),
    [anon_sym_NA_complex_] = ACTIONS(367),
    [anon_sym_NA_character_] = ACTIONS(367),
    [sym_dots] = ACTIONS(367),
    [sym_dot_dot_i] = ACTIONS(369),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(369),
    [sym__newline] = ACTIONS(369),
    [sym__raw_string_literal] = ACTIONS(369),
    [sym__external_else] = ACTIONS(369),
    [sym__external_open_parenthesis] = ACTIONS(313),
    [sym__external_open_brace] = ACTIONS(369),
    [sym__external_open_bracket] = ACTIONS(315),
    [sym__external_open_bracket2] = ACTIONS(317),
    [sym__external_close_bracket2] = ACTIONS(369),
  },
  [253] = {
    [sym_call_arguments] = STATE(795),
    [sym_subset_arguments] = STATE(796),
    [sym_subset2_arguments] = STATE(797),
    [sym__open_parenthesis] = STATE(361),
    [sym__open_bracket] = STATE(362),
    [sym__open_bracket2] = STATE(199),
    [sym_identifier] = ACTIONS(367),
    [anon_sym_BSLASH] = ACTIONS(369),
    [anon_sym_function] = ACTIONS(367),
    [anon_sym_EQ] = ACTIONS(367),
    [anon_sym_if] = ACTIONS(367),
    [anon_sym_for] = ACTIONS(367),
    [anon_sym_while] = ACTIONS(367),
    [anon_sym_repeat] = ACTIONS(367),
    [anon_sym_QMARK] = ACTIONS(369),
    [anon_sym_TILDE] = ACTIONS(369),
    [anon_sym_BANG] = ACTIONS(367),
    [anon_sym_PLUS] = ACTIONS(369),
    [anon_sym_DASH] = ACTIONS(367),
    [anon_sym_LT_DASH] = ACTIONS(369),
    [anon_sym_LT_LT_DASH] = ACTIONS(369),
    [anon_sym_COLON_EQ] = ACTIONS(369),
    [anon_sym_DASH_GT] = ACTIONS(367),
    [anon_sym_DASH_GT_GT] = ACTIONS(369),
    [anon_sym_PIPE] = ACTIONS(367),
    [anon_sym_AMP] = ACTIONS(367),
    [anon_sym_PIPE_PIPE] = ACTIONS(369),
    [anon_sym_AMP_AMP] = ACTIONS(369),
    [anon_sym_LT] = ACTIONS(367),
    [anon_sym_LT_EQ] = ACTIONS(369),
    [anon_sym_GT] = ACTIONS(367),
    [anon_sym_GT_EQ] = ACTIONS(369),
    [anon_sym_EQ_EQ] = ACTIONS(369),
    [anon_sym_BANG_EQ] = ACTIONS(369),
    [anon_sym_STAR] = ACTIONS(367),
    [anon_sym_SLASH] = ACTIONS(369),
    [anon_sym_STAR_STAR] = ACTIONS(303),
    [anon_sym_CARET] = ACTIONS(303),
    [aux_sym_binary_operator_token1] = ACTIONS(369),
    [anon_sym_PIPE_GT] = ACTIONS(369),
    [anon_sym_COLON] = ACTIONS(367),
    [anon_sym_DOLLAR] = ACTIONS(309),
    [anon_sym_AT] = ACTIONS(309),
    [aux_sym__hex_literal_token1] = ACTIONS(369),
    [sym__number_literal] = ACTIONS(367),
    [anon_sym_SQUOTE] = ACTIONS(369),
    [anon_sym_DQUOTE] = ACTIONS(369),
    [sym_return] = ACTIONS(367),
    [sym_next] = ACTIONS(367),
    [sym_break] = ACTIONS(367),
    [sym_true] = ACTIONS(367),
    [sym_false] = ACTIONS(367),
    [sym_null] = ACTIONS(367),
    [sym_inf] = ACTIONS(367),
    [sym_nan] = ACTIONS(367),
    [anon_sym_NA] = ACTIONS(367),
    [anon_sym_NA_integer_] = ACTIONS(367),
    [anon_sym_NA_real_] = ACTIONS(367),
    [anon_sym_NA_complex_] = ACTIONS(367),
    [anon_sym_NA_character_] = ACTIONS(367),
    [sym_dots] = ACTIONS(367),
    [sym_dot_dot_i] = ACTIONS(369),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(369),
    [sym__newline] = ACTIONS(369),
    [sym__raw_string_literal] = ACTIONS(369),
    [sym__external_else] = ACTIONS(369),
    [sym__external_open_parenthesis] = ACTIONS(313),
    [sym__external_open_brace] = ACTIONS(369),
    [sym__external_open_bracket] = ACTIONS(315),
    [sym__external_open_bracket2] = ACTIONS(317),
    [sym__external_close_bracket2] = ACTIONS(369),
  },
  [254] = {
    [sym_call_arguments] = STATE(795),
    [sym_subset_arguments] = STATE(796),
    [sym_subset2_arguments] = STATE(797),
    [sym__open_parenthesis] = STATE(361),
    [sym__open_bracket] = STATE(362),
    [sym__open_bracket2] = STATE(199),
    [sym_identifier] = ACTIONS(373),
    [anon_sym_BSLASH] = ACTIONS(371),
    [anon_sym_function] = ACTIONS(373),
    [anon_sym_EQ] = ACTIONS(273),
    [anon_sym_if] = ACTIONS(373),
    [anon_sym_for] = ACTIONS(373),
    [anon_sym_while] = ACTIONS(373),
    [anon_sym_repeat] = ACTIONS(373),
    [anon_sym_QMARK] = ACTIONS(371),
    [anon_sym_TILDE] = ACTIONS(275),
    [anon_sym_BANG] = ACTIONS(373),
    [anon_sym_PLUS] = ACTIONS(277),
    [anon_sym_DASH] = ACTIONS(279),
    [anon_sym_LT_DASH] = ACTIONS(281),
    [anon_sym_LT_LT_DASH] = ACTIONS(281),
    [anon_sym_COLON_EQ] = ACTIONS(281),
    [anon_sym_DASH_GT] = ACTIONS(283),
    [anon_sym_DASH_GT_GT] = ACTIONS(285),
    [anon_sym_PIPE] = ACTIONS(287),
    [anon_sym_AMP] = ACTIONS(289),
    [anon_sym_PIPE_PIPE] = ACTIONS(291),
    [anon_sym_AMP_AMP] = ACTIONS(293),
    [anon_sym_LT] = ACTIONS(295),
    [anon_sym_LT_EQ] = ACTIONS(297),
    [anon_sym_GT] = ACTIONS(295),
    [anon_sym_GT_EQ] = ACTIONS(297),
    [anon_sym_EQ_EQ] = ACTIONS(297),
    [anon_sym_BANG_EQ] = ACTIONS(297),
    [anon_sym_STAR] = ACTIONS(299),
    [anon_sym_SLASH] = ACTIONS(301),
    [anon_sym_STAR_STAR] = ACTIONS(303),
    [anon_sym_CARET] = ACTIONS(303),
    [aux_sym_binary_operator_token1] = ACTIONS(305),
    [anon_sym_PIPE_GT] = ACTIONS(305),
    [anon_sym_COLON] = ACTIONS(307),
    [anon_sym_DOLLAR] = ACTIONS(309),
    [anon_sym_AT] = ACTIONS(309),
    [aux_sym__hex_literal_token1] = ACTIONS(371),
    [sym__number_literal] = ACTIONS(373),
    [anon_sym_SQUOTE] = ACTIONS(371),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [sym_return] = ACTIONS(373),
    [sym_next] = ACTIONS(373),
    [sym_break] = ACTIONS(373),
    [sym_true] = ACTIONS(373),
    [sym_false] = ACTIONS(373),
    [sym_null] = ACTIONS(373),
    [sym_inf] = ACTIONS(373),
    [sym_nan] = ACTIONS(373),
    [anon_sym_NA] = ACTIONS(373),
    [anon_sym_NA_integer_] = ACTIONS(373),
    [anon_sym_NA_real_] = ACTIONS(373),
    [anon_sym_NA_complex_] = ACTIONS(373),
    [anon_sym_NA_character_] = ACTIONS(373),
    [sym_dots] = ACTIONS(373),
    [sym_dot_dot_i] = ACTIONS(371),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(371),
    [sym__newline] = ACTIONS(371),
    [sym__raw_string_literal] = ACTIONS(371),
    [sym__external_else] = ACTIONS(371),
    [sym__external_open_parenthesis] = ACTIONS(313),
    [sym__external_open_brace] = ACTIONS(371),
    [sym__external_open_bracket] = ACTIONS(315),
    [sym__external_open_bracket2] = ACTIONS(317),
    [sym__external_close_bracket2] = ACTIONS(371),
  },
  [255] = {
    [sym_call_arguments] = STATE(795),
    [sym_subset_arguments] = STATE(796),
    [sym_subset2_arguments] = STATE(797),
    [sym__open_parenthesis] = STATE(361),
    [sym__open_bracket] = STATE(362),
    [sym__open_bracket2] = STATE(199),
    [sym_identifier] = ACTIONS(377),
    [anon_sym_BSLASH] = ACTIONS(375),
    [anon_sym_function] = ACTIONS(377),
    [anon_sym_EQ] = ACTIONS(273),
    [anon_sym_if] = ACTIONS(377),
    [anon_sym_for] = ACTIONS(377),
    [anon_sym_while] = ACTIONS(377),
    [anon_sym_repeat] = ACTIONS(377),
    [anon_sym_QMARK] = ACTIONS(375),
    [anon_sym_TILDE] = ACTIONS(275),
    [anon_sym_BANG] = ACTIONS(377),
    [anon_sym_PLUS] = ACTIONS(277),
    [anon_sym_DASH] = ACTIONS(279),
    [anon_sym_LT_DASH] = ACTIONS(281),
    [anon_sym_LT_LT_DASH] = ACTIONS(281),
    [anon_sym_COLON_EQ] = ACTIONS(281),
    [anon_sym_DASH_GT] = ACTIONS(283),
    [anon_sym_DASH_GT_GT] = ACTIONS(285),
    [anon_sym_PIPE] = ACTIONS(287),
    [anon_sym_AMP] = ACTIONS(289),
    [anon_sym_PIPE_PIPE] = ACTIONS(291),
    [anon_sym_AMP_AMP] = ACTIONS(293),
    [anon_sym_LT] = ACTIONS(295),
    [anon_sym_LT_EQ] = ACTIONS(297),
    [anon_sym_GT] = ACTIONS(295),
    [anon_sym_GT_EQ] = ACTIONS(297),
    [anon_sym_EQ_EQ] = ACTIONS(297),
    [anon_sym_BANG_EQ] = ACTIONS(297),
    [anon_sym_STAR] = ACTIONS(299),
    [anon_sym_SLASH] = ACTIONS(301),
    [anon_sym_STAR_STAR] = ACTIONS(303),
    [anon_sym_CARET] = ACTIONS(303),
    [aux_sym_binary_operator_token1] = ACTIONS(305),
    [anon_sym_PIPE_GT] = ACTIONS(305),
    [anon_sym_COLON] = ACTIONS(307),
    [anon_sym_DOLLAR] = ACTIONS(309),
    [anon_sym_AT] = ACTIONS(309),
    [aux_sym__hex_literal_token1] = ACTIONS(375),
    [sym__number_literal] = ACTIONS(377),
    [anon_sym_SQUOTE] = ACTIONS(375),
    [anon_sym_DQUOTE] = ACTIONS(375),
    [sym_return] = ACTIONS(377),
    [sym_next] = ACTIONS(377),
    [sym_break] = ACTIONS(377),
    [sym_true] = ACTIONS(377),
    [sym_false] = ACTIONS(377),
    [sym_null] = ACTIONS(377),
    [sym_inf] = ACTIONS(377),
    [sym_nan] = ACTIONS(377),
    [anon_sym_NA] = ACTIONS(377),
    [anon_sym_NA_integer_] = ACTIONS(377),
    [anon_sym_NA_real_] = ACTIONS(377),
    [anon_sym_NA_complex_] = ACTIONS(377),
    [anon_sym_NA_character_] = ACTIONS(377),
    [sym_dots] = ACTIONS(377),
    [sym_dot_dot_i] = ACTIONS(375),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(375),
    [sym__newline] = ACTIONS(375),
    [sym__raw_string_literal] = ACTIONS(375),
    [sym__external_else] = ACTIONS(375),
    [sym__external_open_parenthesis] = ACTIONS(313),
    [sym__external_open_brace] = ACTIONS(375),
    [sym__external_open_bracket] = ACTIONS(315),
    [sym__external_open_bracket2] = ACTIONS(317),
    [sym__external_close_bracket2] = ACTIONS(375),
  },
  [256] = {
    [sym_call_arguments] = STATE(795),
    [sym_subset_arguments] = STATE(796),
    [sym_subset2_arguments] = STATE(797),
    [sym__open_parenthesis] = STATE(361),
    [sym__open_bracket] = STATE(362),
    [sym__open_bracket2] = STATE(199),
    [sym_identifier] = ACTIONS(381),
    [anon_sym_BSLASH] = ACTIONS(379),
    [anon_sym_function] = ACTIONS(381),
    [anon_sym_EQ] = ACTIONS(273),
    [anon_sym_if] = ACTIONS(381),
    [anon_sym_for] = ACTIONS(381),
    [anon_sym_while] = ACTIONS(381),
    [anon_sym_repeat] = ACTIONS(381),
    [anon_sym_QMARK] = ACTIONS(379),
    [anon_sym_TILDE] = ACTIONS(275),
    [anon_sym_BANG] = ACTIONS(381),
    [anon_sym_PLUS] = ACTIONS(277),
    [anon_sym_DASH] = ACTIONS(279),
    [anon_sym_LT_DASH] = ACTIONS(281),
    [anon_sym_LT_LT_DASH] = ACTIONS(281),
    [anon_sym_COLON_EQ] = ACTIONS(281),
    [anon_sym_DASH_GT] = ACTIONS(283),
    [anon_sym_DASH_GT_GT] = ACTIONS(285),
    [anon_sym_PIPE] = ACTIONS(287),
    [anon_sym_AMP] = ACTIONS(289),
    [anon_sym_PIPE_PIPE] = ACTIONS(291),
    [anon_sym_AMP_AMP] = ACTIONS(293),
    [anon_sym_LT] = ACTIONS(295),
    [anon_sym_LT_EQ] = ACTIONS(297),
    [anon_sym_GT] = ACTIONS(295),
    [anon_sym_GT_EQ] = ACTIONS(297),
    [anon_sym_EQ_EQ] = ACTIONS(297),
    [anon_sym_BANG_EQ] = ACTIONS(297),
    [anon_sym_STAR] = ACTIONS(299),
    [anon_sym_SLASH] = ACTIONS(301),
    [anon_sym_STAR_STAR] = ACTIONS(303),
    [anon_sym_CARET] = ACTIONS(303),
    [aux_sym_binary_operator_token1] = ACTIONS(305),
    [anon_sym_PIPE_GT] = ACTIONS(305),
    [anon_sym_COLON] = ACTIONS(307),
    [anon_sym_DOLLAR] = ACTIONS(309),
    [anon_sym_AT] = ACTIONS(309),
    [aux_sym__hex_literal_token1] = ACTIONS(379),
    [sym__number_literal] = ACTIONS(381),
    [anon_sym_SQUOTE] = ACTIONS(379),
    [anon_sym_DQUOTE] = ACTIONS(379),
    [sym_return] = ACTIONS(381),
    [sym_next] = ACTIONS(381),
    [sym_break] = ACTIONS(381),
    [sym_true] = ACTIONS(381),
    [sym_false] = ACTIONS(381),
    [sym_null] = ACTIONS(381),
    [sym_inf] = ACTIONS(381),
    [sym_nan] = ACTIONS(381),
    [anon_sym_NA] = ACTIONS(381),
    [anon_sym_NA_integer_] = ACTIONS(381),
    [anon_sym_NA_real_] = ACTIONS(381),
    [anon_sym_NA_complex_] = ACTIONS(381),
    [anon_sym_NA_character_] = ACTIONS(381),
    [sym_dots] = ACTIONS(381),
    [sym_dot_dot_i] = ACTIONS(379),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(379),
    [sym__newline] = ACTIONS(379),
    [sym__raw_string_literal] = ACTIONS(379),
    [sym__external_else] = ACTIONS(379),
    [sym__external_open_parenthesis] = ACTIONS(313),
    [sym__external_open_brace] = ACTIONS(379),
    [sym__external_open_bracket] = ACTIONS(315),
    [sym__external_open_bracket2] = ACTIONS(317),
    [sym__external_close_bracket2] = ACTIONS(379),
  },
  [257] = {
    [sym_call_arguments] = STATE(795),
    [sym_subset_arguments] = STATE(796),
    [sym_subset2_arguments] = STATE(797),
    [sym__open_parenthesis] = STATE(361),
    [sym__open_bracket] = STATE(362),
    [sym__open_bracket2] = STATE(199),
    [sym_identifier] = ACTIONS(381),
    [anon_sym_BSLASH] = ACTIONS(379),
    [anon_sym_function] = ACTIONS(381),
    [anon_sym_EQ] = ACTIONS(381),
    [anon_sym_if] = ACTIONS(381),
    [anon_sym_for] = ACTIONS(381),
    [anon_sym_while] = ACTIONS(381),
    [anon_sym_repeat] = ACTIONS(381),
    [anon_sym_QMARK] = ACTIONS(379),
    [anon_sym_TILDE] = ACTIONS(379),
    [anon_sym_BANG] = ACTIONS(381),
    [anon_sym_PLUS] = ACTIONS(277),
    [anon_sym_DASH] = ACTIONS(279),
    [anon_sym_LT_DASH] = ACTIONS(379),
    [anon_sym_LT_LT_DASH] = ACTIONS(379),
    [anon_sym_COLON_EQ] = ACTIONS(379),
    [anon_sym_DASH_GT] = ACTIONS(381),
    [anon_sym_DASH_GT_GT] = ACTIONS(379),
    [anon_sym_PIPE] = ACTIONS(287),
    [anon_sym_AMP] = ACTIONS(289),
    [anon_sym_PIPE_PIPE] = ACTIONS(291),
    [anon_sym_AMP_AMP] = ACTIONS(293),
    [anon_sym_LT] = ACTIONS(295),
    [anon_sym_LT_EQ] = ACTIONS(297),
    [anon_sym_GT] = ACTIONS(295),
    [anon_sym_GT_EQ] = ACTIONS(297),
    [anon_sym_EQ_EQ] = ACTIONS(297),
    [anon_sym_BANG_EQ] = ACTIONS(297),
    [anon_sym_STAR] = ACTIONS(299),
    [anon_sym_SLASH] = ACTIONS(301),
    [anon_sym_STAR_STAR] = ACTIONS(303),
    [anon_sym_CARET] = ACTIONS(303),
    [aux_sym_binary_operator_token1] = ACTIONS(305),
    [anon_sym_PIPE_GT] = ACTIONS(305),
    [anon_sym_COLON] = ACTIONS(307),
    [anon_sym_DOLLAR] = ACTIONS(309),
    [anon_sym_AT] = ACTIONS(309),
    [aux_sym__hex_literal_token1] = ACTIONS(379),
    [sym__number_literal] = ACTIONS(381),
    [anon_sym_SQUOTE] = ACTIONS(379),
    [anon_sym_DQUOTE] = ACTIONS(379),
    [sym_return] = ACTIONS(381),
    [sym_next] = ACTIONS(381),
    [sym_break] = ACTIONS(381),
    [sym_true] = ACTIONS(381),
    [sym_false] = ACTIONS(381),
    [sym_null] = ACTIONS(381),
    [sym_inf] = ACTIONS(381),
    [sym_nan] = ACTIONS(381),
    [anon_sym_NA] = ACTIONS(381),
    [anon_sym_NA_integer_] = ACTIONS(381),
    [anon_sym_NA_real_] = ACTIONS(381),
    [anon_sym_NA_complex_] = ACTIONS(381),
    [anon_sym_NA_character_] = ACTIONS(381),
    [sym_dots] = ACTIONS(381),
    [sym_dot_dot_i] = ACTIONS(379),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(379),
    [sym__newline] = ACTIONS(379),
    [sym__raw_string_literal] = ACTIONS(379),
    [sym__external_else] = ACTIONS(379),
    [sym__external_open_parenthesis] = ACTIONS(313),
    [sym__external_open_brace] = ACTIONS(379),
    [sym__external_open_bracket] = ACTIONS(315),
    [sym__external_open_bracket2] = ACTIONS(317),
    [sym__external_close_bracket2] = ACTIONS(379),
  },
  [258] = {
    [sym_call_arguments] = STATE(795),
    [sym_subset_arguments] = STATE(796),
    [sym_subset2_arguments] = STATE(797),
    [sym__open_parenthesis] = STATE(361),
    [sym__open_bracket] = STATE(362),
    [sym__open_bracket2] = STATE(199),
    [sym_identifier] = ACTIONS(381),
    [anon_sym_BSLASH] = ACTIONS(379),
    [anon_sym_function] = ACTIONS(381),
    [anon_sym_EQ] = ACTIONS(381),
    [anon_sym_if] = ACTIONS(381),
    [anon_sym_for] = ACTIONS(381),
    [anon_sym_while] = ACTIONS(381),
    [anon_sym_repeat] = ACTIONS(381),
    [anon_sym_QMARK] = ACTIONS(379),
    [anon_sym_TILDE] = ACTIONS(379),
    [anon_sym_BANG] = ACTIONS(381),
    [anon_sym_PLUS] = ACTIONS(277),
    [anon_sym_DASH] = ACTIONS(279),
    [anon_sym_LT_DASH] = ACTIONS(379),
    [anon_sym_LT_LT_DASH] = ACTIONS(379),
    [anon_sym_COLON_EQ] = ACTIONS(379),
    [anon_sym_DASH_GT] = ACTIONS(381),
    [anon_sym_DASH_GT_GT] = ACTIONS(379),
    [anon_sym_PIPE] = ACTIONS(381),
    [anon_sym_AMP] = ACTIONS(381),
    [anon_sym_PIPE_PIPE] = ACTIONS(379),
    [anon_sym_AMP_AMP] = ACTIONS(379),
    [anon_sym_LT] = ACTIONS(295),
    [anon_sym_LT_EQ] = ACTIONS(297),
    [anon_sym_GT] = ACTIONS(295),
    [anon_sym_GT_EQ] = ACTIONS(297),
    [anon_sym_EQ_EQ] = ACTIONS(297),
    [anon_sym_BANG_EQ] = ACTIONS(297),
    [anon_sym_STAR] = ACTIONS(299),
    [anon_sym_SLASH] = ACTIONS(301),
    [anon_sym_STAR_STAR] = ACTIONS(303),
    [anon_sym_CARET] = ACTIONS(303),
    [aux_sym_binary_operator_token1] = ACTIONS(305),
    [anon_sym_PIPE_GT] = ACTIONS(305),
    [anon_sym_COLON] = ACTIONS(307),
    [anon_sym_DOLLAR] = ACTIONS(309),
    [anon_sym_AT] = ACTIONS(309),
    [aux_sym__hex_literal_token1] = ACTIONS(379),
    [sym__number_literal] = ACTIONS(381),
    [anon_sym_SQUOTE] = ACTIONS(379),
    [anon_sym_DQUOTE] = ACTIONS(379),
    [sym_return] = ACTIONS(381),
    [sym_next] = ACTIONS(381),
    [sym_break] = ACTIONS(381),
    [sym_true] = ACTIONS(381),
    [sym_false] = ACTIONS(381),
    [sym_null] = ACTIONS(381),
    [sym_inf] = ACTIONS(381),
    [sym_nan] = ACTIONS(381),
    [anon_sym_NA] = ACTIONS(381),
    [anon_sym_NA_integer_] = ACTIONS(381),
    [anon_sym_NA_real_] = ACTIONS(381),
    [anon_sym_NA_complex_] = ACTIONS(381),
    [anon_sym_NA_character_] = ACTIONS(381),
    [sym_dots] = ACTIONS(381),
    [sym_dot_dot_i] = ACTIONS(379),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(379),
    [sym__newline] = ACTIONS(379),
    [sym__raw_string_literal] = ACTIONS(379),
    [sym__external_else] = ACTIONS(379),
    [sym__external_open_parenthesis] = ACTIONS(313),
    [sym__external_open_brace] = ACTIONS(379),
    [sym__external_open_bracket] = ACTIONS(315),
    [sym__external_open_bracket2] = ACTIONS(317),
    [sym__external_close_bracket2] = ACTIONS(379),
  },
  [259] = {
    [sym_call_arguments] = STATE(795),
    [sym_subset_arguments] = STATE(796),
    [sym_subset2_arguments] = STATE(797),
    [sym__open_parenthesis] = STATE(361),
    [sym__open_bracket] = STATE(362),
    [sym__open_bracket2] = STATE(199),
    [sym_identifier] = ACTIONS(381),
    [anon_sym_BSLASH] = ACTIONS(379),
    [anon_sym_function] = ACTIONS(381),
    [anon_sym_EQ] = ACTIONS(381),
    [anon_sym_if] = ACTIONS(381),
    [anon_sym_for] = ACTIONS(381),
    [anon_sym_while] = ACTIONS(381),
    [anon_sym_repeat] = ACTIONS(381),
    [anon_sym_QMARK] = ACTIONS(379),
    [anon_sym_TILDE] = ACTIONS(379),
    [anon_sym_BANG] = ACTIONS(381),
    [anon_sym_PLUS] = ACTIONS(379),
    [anon_sym_DASH] = ACTIONS(381),
    [anon_sym_LT_DASH] = ACTIONS(379),
    [anon_sym_LT_LT_DASH] = ACTIONS(379),
    [anon_sym_COLON_EQ] = ACTIONS(379),
    [anon_sym_DASH_GT] = ACTIONS(381),
    [anon_sym_DASH_GT_GT] = ACTIONS(379),
    [anon_sym_PIPE] = ACTIONS(381),
    [anon_sym_AMP] = ACTIONS(381),
    [anon_sym_PIPE_PIPE] = ACTIONS(379),
    [anon_sym_AMP_AMP] = ACTIONS(379),
    [anon_sym_LT] = ACTIONS(381),
    [anon_sym_LT_EQ] = ACTIONS(379),
    [anon_sym_GT] = ACTIONS(381),
    [anon_sym_GT_EQ] = ACTIONS(379),
    [anon_sym_EQ_EQ] = ACTIONS(379),
    [anon_sym_BANG_EQ] = ACTIONS(379),
    [anon_sym_STAR] = ACTIONS(381),
    [anon_sym_SLASH] = ACTIONS(379),
    [anon_sym_STAR_STAR] = ACTIONS(303),
    [anon_sym_CARET] = ACTIONS(303),
    [aux_sym_binary_operator_token1] = ACTIONS(379),
    [anon_sym_PIPE_GT] = ACTIONS(379),
    [anon_sym_COLON] = ACTIONS(381),
    [anon_sym_DOLLAR] = ACTIONS(309),
    [anon_sym_AT] = ACTIONS(309),
    [aux_sym__hex_literal_token1] = ACTIONS(379),
    [sym__number_literal] = ACTIONS(381),
    [anon_sym_SQUOTE] = ACTIONS(379),
    [anon_sym_DQUOTE] = ACTIONS(379),
    [sym_return] = ACTIONS(381),
    [sym_next] = ACTIONS(381),
    [sym_break] = ACTIONS(381),
    [sym_true] = ACTIONS(381),
    [sym_false] = ACTIONS(381),
    [sym_null] = ACTIONS(381),
    [sym_inf] = ACTIONS(381),
    [sym_nan] = ACTIONS(381),
    [anon_sym_NA] = ACTIONS(381),
    [anon_sym_NA_integer_] = ACTIONS(381),
    [anon_sym_NA_real_] = ACTIONS(381),
    [anon_sym_NA_complex_] = ACTIONS(381),
    [anon_sym_NA_character_] = ACTIONS(381),
    [sym_dots] = ACTIONS(381),
    [sym_dot_dot_i] = ACTIONS(379),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(379),
    [sym__newline] = ACTIONS(379),
    [sym__raw_string_literal] = ACTIONS(379),
    [sym__external_else] = ACTIONS(379),
    [sym__external_open_parenthesis] = ACTIONS(313),
    [sym__external_open_brace] = ACTIONS(379),
    [sym__external_open_bracket] = ACTIONS(315),
    [sym__external_open_bracket2] = ACTIONS(317),
    [sym__external_close_bracket2] = ACTIONS(379),
  },
  [260] = {
    [sym_call_arguments] = STATE(795),
    [sym_subset_arguments] = STATE(796),
    [sym_subset2_arguments] = STATE(797),
    [sym__open_parenthesis] = STATE(361),
    [sym__open_bracket] = STATE(362),
    [sym__open_bracket2] = STATE(199),
    [sym_identifier] = ACTIONS(385),
    [anon_sym_BSLASH] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_EQ] = ACTIONS(273),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_for] = ACTIONS(385),
    [anon_sym_while] = ACTIONS(385),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_QMARK] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(275),
    [anon_sym_BANG] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(277),
    [anon_sym_DASH] = ACTIONS(279),
    [anon_sym_LT_DASH] = ACTIONS(383),
    [anon_sym_LT_LT_DASH] = ACTIONS(383),
    [anon_sym_COLON_EQ] = ACTIONS(383),
    [anon_sym_DASH_GT] = ACTIONS(283),
    [anon_sym_DASH_GT_GT] = ACTIONS(285),
    [anon_sym_PIPE] = ACTIONS(287),
    [anon_sym_AMP] = ACTIONS(289),
    [anon_sym_PIPE_PIPE] = ACTIONS(291),
    [anon_sym_AMP_AMP] = ACTIONS(293),
    [anon_sym_LT] = ACTIONS(295),
    [anon_sym_LT_EQ] = ACTIONS(297),
    [anon_sym_GT] = ACTIONS(295),
    [anon_sym_GT_EQ] = ACTIONS(297),
    [anon_sym_EQ_EQ] = ACTIONS(297),
    [anon_sym_BANG_EQ] = ACTIONS(297),
    [anon_sym_STAR] = ACTIONS(299),
    [anon_sym_SLASH] = ACTIONS(301),
    [anon_sym_STAR_STAR] = ACTIONS(303),
    [anon_sym_CARET] = ACTIONS(303),
    [aux_sym_binary_operator_token1] = ACTIONS(305),
    [anon_sym_PIPE_GT] = ACTIONS(305),
    [anon_sym_COLON] = ACTIONS(307),
    [anon_sym_DOLLAR] = ACTIONS(309),
    [anon_sym_AT] = ACTIONS(309),
    [aux_sym__hex_literal_token1] = ACTIONS(383),
    [sym__number_literal] = ACTIONS(385),
    [anon_sym_SQUOTE] = ACTIONS(383),
    [anon_sym_DQUOTE] = ACTIONS(383),
    [sym_return] = ACTIONS(385),
    [sym_next] = ACTIONS(385),
    [sym_break] = ACTIONS(385),
    [sym_true] = ACTIONS(385),
    [sym_false] = ACTIONS(385),
    [sym_null] = ACTIONS(385),
    [sym_inf] = ACTIONS(385),
    [sym_nan] = ACTIONS(385),
    [anon_sym_NA] = ACTIONS(385),
    [anon_sym_NA_integer_] = ACTIONS(385),
    [anon_sym_NA_real_] = ACTIONS(385),
    [anon_sym_NA_complex_] = ACTIONS(385),
    [anon_sym_NA_character_] = ACTIONS(385),
    [sym_dots] = ACTIONS(385),
    [sym_dot_dot_i] = ACTIONS(383),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(383),
    [sym__newline] = ACTIONS(383),
    [sym__raw_string_literal] = ACTIONS(383),
    [sym__external_else] = ACTIONS(383),
    [sym__external_open_parenthesis] = ACTIONS(313),
    [sym__external_open_brace] = ACTIONS(383),
    [sym__external_open_bracket] = ACTIONS(315),
    [sym__external_open_bracket2] = ACTIONS(317),
    [sym__external_close_bracket2] = ACTIONS(383),
  },
  [261] = {
    [sym_call_arguments] = STATE(795),
    [sym_subset_arguments] = STATE(796),
    [sym_subset2_arguments] = STATE(797),
    [sym__open_parenthesis] = STATE(361),
    [sym__open_bracket] = STATE(362),
    [sym__open_bracket2] = STATE(199),
    [sym_identifier] = ACTIONS(385),
    [anon_sym_BSLASH] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_EQ] = ACTIONS(273),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_for] = ACTIONS(385),
    [anon_sym_while] = ACTIONS(385),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_QMARK] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(275),
    [anon_sym_BANG] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(277),
    [anon_sym_DASH] = ACTIONS(279),
    [anon_sym_LT_DASH] = ACTIONS(281),
    [anon_sym_LT_LT_DASH] = ACTIONS(281),
    [anon_sym_COLON_EQ] = ACTIONS(281),
    [anon_sym_DASH_GT] = ACTIONS(283),
    [anon_sym_DASH_GT_GT] = ACTIONS(285),
    [anon_sym_PIPE] = ACTIONS(287),
    [anon_sym_AMP] = ACTIONS(289),
    [anon_sym_PIPE_PIPE] = ACTIONS(291),
    [anon_sym_AMP_AMP] = ACTIONS(293),
    [anon_sym_LT] = ACTIONS(295),
    [anon_sym_LT_EQ] = ACTIONS(297),
    [anon_sym_GT] = ACTIONS(295),
    [anon_sym_GT_EQ] = ACTIONS(297),
    [anon_sym_EQ_EQ] = ACTIONS(297),
    [anon_sym_BANG_EQ] = ACTIONS(297),
    [anon_sym_STAR] = ACTIONS(299),
    [anon_sym_SLASH] = ACTIONS(301),
    [anon_sym_STAR_STAR] = ACTIONS(303),
    [anon_sym_CARET] = ACTIONS(303),
    [aux_sym_binary_operator_token1] = ACTIONS(305),
    [anon_sym_PIPE_GT] = ACTIONS(305),
    [anon_sym_COLON] = ACTIONS(307),
    [anon_sym_DOLLAR] = ACTIONS(309),
    [anon_sym_AT] = ACTIONS(309),
    [aux_sym__hex_literal_token1] = ACTIONS(383),
    [sym__number_literal] = ACTIONS(385),
    [anon_sym_SQUOTE] = ACTIONS(383),
    [anon_sym_DQUOTE] = ACTIONS(383),
    [sym_return] = ACTIONS(385),
    [sym_next] = ACTIONS(385),
    [sym_break] = ACTIONS(385),
    [sym_true] = ACTIONS(385),
    [sym_false] = ACTIONS(385),
    [sym_null] = ACTIONS(385),
    [sym_inf] = ACTIONS(385),
    [sym_nan] = ACTIONS(385),
    [anon_sym_NA] = ACTIONS(385),
    [anon_sym_NA_integer_] = ACTIONS(385),
    [anon_sym_NA_real_] = ACTIONS(385),
    [anon_sym_NA_complex_] = ACTIONS(385),
    [anon_sym_NA_character_] = ACTIONS(385),
    [sym_dots] = ACTIONS(385),
    [sym_dot_dot_i] = ACTIONS(383),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(383),
    [sym__newline] = ACTIONS(383),
    [sym__raw_string_literal] = ACTIONS(383),
    [sym__external_else] = ACTIONS(383),
    [sym__external_open_parenthesis] = ACTIONS(313),
    [sym__external_open_brace] = ACTIONS(383),
    [sym__external_open_bracket] = ACTIONS(315),
    [sym__external_open_bracket2] = ACTIONS(317),
    [sym__external_close_bracket2] = ACTIONS(383),
  },
  [262] = {
    [sym_call_arguments] = STATE(795),
    [sym_subset_arguments] = STATE(796),
    [sym_subset2_arguments] = STATE(797),
    [sym__open_parenthesis] = STATE(361),
    [sym__open_bracket] = STATE(362),
    [sym__open_bracket2] = STATE(199),
    [sym_identifier] = ACTIONS(385),
    [anon_sym_BSLASH] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_EQ] = ACTIONS(385),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_for] = ACTIONS(385),
    [anon_sym_while] = ACTIONS(385),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_QMARK] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(383),
    [anon_sym_BANG] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(277),
    [anon_sym_DASH] = ACTIONS(279),
    [anon_sym_LT_DASH] = ACTIONS(383),
    [anon_sym_LT_LT_DASH] = ACTIONS(383),
    [anon_sym_COLON_EQ] = ACTIONS(383),
    [anon_sym_DASH_GT] = ACTIONS(385),
    [anon_sym_DASH_GT_GT] = ACTIONS(383),
    [anon_sym_PIPE] = ACTIONS(287),
    [anon_sym_AMP] = ACTIONS(289),
    [anon_sym_PIPE_PIPE] = ACTIONS(291),
    [anon_sym_AMP_AMP] = ACTIONS(293),
    [anon_sym_LT] = ACTIONS(295),
    [anon_sym_LT_EQ] = ACTIONS(297),
    [anon_sym_GT] = ACTIONS(295),
    [anon_sym_GT_EQ] = ACTIONS(297),
    [anon_sym_EQ_EQ] = ACTIONS(297),
    [anon_sym_BANG_EQ] = ACTIONS(297),
    [anon_sym_STAR] = ACTIONS(299),
    [anon_sym_SLASH] = ACTIONS(301),
    [anon_sym_STAR_STAR] = ACTIONS(303),
    [anon_sym_CARET] = ACTIONS(303),
    [aux_sym_binary_operator_token1] = ACTIONS(305),
    [anon_sym_PIPE_GT] = ACTIONS(305),
    [anon_sym_COLON] = ACTIONS(307),
    [anon_sym_DOLLAR] = ACTIONS(309),
    [anon_sym_AT] = ACTIONS(309),
    [aux_sym__hex_literal_token1] = ACTIONS(383),
    [sym__number_literal] = ACTIONS(385),
    [anon_sym_SQUOTE] = ACTIONS(383),
    [anon_sym_DQUOTE] = ACTIONS(383),
    [sym_return] = ACTIONS(385),
    [sym_next] = ACTIONS(385),
    [sym_break] = ACTIONS(385),
    [sym_true] = ACTIONS(385),
    [sym_false] = ACTIONS(385),
    [sym_null] = ACTIONS(385),
    [sym_inf] = ACTIONS(385),
    [sym_nan] = ACTIONS(385),
    [anon_sym_NA] = ACTIONS(385),
    [anon_sym_NA_integer_] = ACTIONS(385),
    [anon_sym_NA_real_] = ACTIONS(385),
    [anon_sym_NA_complex_] = ACTIONS(385),
    [anon_sym_NA_character_] = ACTIONS(385),
    [sym_dots] = ACTIONS(385),
    [sym_dot_dot_i] = ACTIONS(383),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(383),
    [sym__newline] = ACTIONS(383),
    [sym__raw_string_literal] = ACTIONS(383),
    [sym__external_else] = ACTIONS(383),
    [sym__external_open_parenthesis] = ACTIONS(313),
    [sym__external_open_brace] = ACTIONS(383),
    [sym__external_open_bracket] = ACTIONS(315),
    [sym__external_open_bracket2] = ACTIONS(317),
    [sym__external_close_bracket2] = ACTIONS(383),
  },
  [263] = {
    [sym_call_arguments] = STATE(795),
    [sym_subset_arguments] = STATE(796),
    [sym_subset2_arguments] = STATE(797),
    [sym__open_parenthesis] = STATE(361),
    [sym__open_bracket] = STATE(362),
    [sym__open_bracket2] = STATE(199),
    [sym_identifier] = ACTIONS(385),
    [anon_sym_BSLASH] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_EQ] = ACTIONS(385),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_for] = ACTIONS(385),
    [anon_sym_while] = ACTIONS(385),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_QMARK] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(383),
    [anon_sym_BANG] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(385),
    [anon_sym_LT_DASH] = ACTIONS(383),
    [anon_sym_LT_LT_DASH] = ACTIONS(383),
    [anon_sym_COLON_EQ] = ACTIONS(383),
    [anon_sym_DASH_GT] = ACTIONS(385),
    [anon_sym_DASH_GT_GT] = ACTIONS(383),
    [anon_sym_PIPE] = ACTIONS(385),
    [anon_sym_AMP] = ACTIONS(385),
    [anon_sym_PIPE_PIPE] = ACTIONS(383),
    [anon_sym_AMP_AMP] = ACTIONS(383),
    [anon_sym_LT] = ACTIONS(385),
    [anon_sym_LT_EQ] = ACTIONS(383),
    [anon_sym_GT] = ACTIONS(385),
    [anon_sym_GT_EQ] = ACTIONS(383),
    [anon_sym_EQ_EQ] = ACTIONS(383),
    [anon_sym_BANG_EQ] = ACTIONS(383),
    [anon_sym_STAR] = ACTIONS(299),
    [anon_sym_SLASH] = ACTIONS(301),
    [anon_sym_STAR_STAR] = ACTIONS(303),
    [anon_sym_CARET] = ACTIONS(303),
    [aux_sym_binary_operator_token1] = ACTIONS(305),
    [anon_sym_PIPE_GT] = ACTIONS(305),
    [anon_sym_COLON] = ACTIONS(307),
    [anon_sym_DOLLAR] = ACTIONS(309),
    [anon_sym_AT] = ACTIONS(309),
    [aux_sym__hex_literal_token1] = ACTIONS(383),
    [sym__number_literal] = ACTIONS(385),
    [anon_sym_SQUOTE] = ACTIONS(383),
    [anon_sym_DQUOTE] = ACTIONS(383),
    [sym_return] = ACTIONS(385),
    [sym_next] = ACTIONS(385),
    [sym_break] = ACTIONS(385),
    [sym_true] = ACTIONS(385),
    [sym_false] = ACTIONS(385),
    [sym_null] = ACTIONS(385),
    [sym_inf] = ACTIONS(385),
    [sym_nan] = ACTIONS(385),
    [anon_sym_NA] = ACTIONS(385),
    [anon_sym_NA_integer_] = ACTIONS(385),
    [anon_sym_NA_real_] = ACTIONS(385),
    [anon_sym_NA_complex_] = ACTIONS(385),
    [anon_sym_NA_character_] = ACTIONS(385),
    [sym_dots] = ACTIONS(385),
    [sym_dot_dot_i] = ACTIONS(383),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(383),
    [sym__newline] = ACTIONS(383),
    [sym__raw_string_literal] = ACTIONS(383),
    [sym__external_else] = ACTIONS(383),
    [sym__external_open_parenthesis] = ACTIONS(313),
    [sym__external_open_brace] = ACTIONS(383),
    [sym__external_open_bracket] = ACTIONS(315),
    [sym__external_open_bracket2] = ACTIONS(317),
    [sym__external_close_bracket2] = ACTIONS(383),
  },
  [264] = {
    [sym_call_arguments] = STATE(795),
    [sym_subset_arguments] = STATE(796),
    [sym_subset2_arguments] = STATE(797),
    [sym__open_parenthesis] = STATE(361),
    [sym__open_bracket] = STATE(362),
    [sym__open_bracket2] = STATE(199),
    [sym_identifier] = ACTIONS(385),
    [anon_sym_BSLASH] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_EQ] = ACTIONS(273),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_for] = ACTIONS(385),
    [anon_sym_while] = ACTIONS(385),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_QMARK] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(275),
    [anon_sym_BANG] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(277),
    [anon_sym_DASH] = ACTIONS(279),
    [anon_sym_LT_DASH] = ACTIONS(281),
    [anon_sym_LT_LT_DASH] = ACTIONS(281),
    [anon_sym_COLON_EQ] = ACTIONS(281),
    [anon_sym_DASH_GT] = ACTIONS(283),
    [anon_sym_DASH_GT_GT] = ACTIONS(285),
    [anon_sym_PIPE] = ACTIONS(287),
    [anon_sym_AMP] = ACTIONS(289),
    [anon_sym_PIPE_PIPE] = ACTIONS(291),
    [anon_sym_AMP_AMP] = ACTIONS(293),
    [anon_sym_LT] = ACTIONS(295),
    [anon_sym_LT_EQ] = ACTIONS(297),
    [anon_sym_GT] = ACTIONS(295),
    [anon_sym_GT_EQ] = ACTIONS(297),
    [anon_sym_EQ_EQ] = ACTIONS(297),
    [anon_sym_BANG_EQ] = ACTIONS(297),
    [anon_sym_STAR] = ACTIONS(299),
    [anon_sym_SLASH] = ACTIONS(301),
    [anon_sym_STAR_STAR] = ACTIONS(303),
    [anon_sym_CARET] = ACTIONS(303),
    [aux_sym_binary_operator_token1] = ACTIONS(305),
    [anon_sym_PIPE_GT] = ACTIONS(305),
    [anon_sym_COLON] = ACTIONS(307),
    [anon_sym_DOLLAR] = ACTIONS(309),
    [anon_sym_AT] = ACTIONS(309),
    [aux_sym__hex_literal_token1] = ACTIONS(383),
    [sym__number_literal] = ACTIONS(385),
    [anon_sym_SQUOTE] = ACTIONS(383),
    [anon_sym_DQUOTE] = ACTIONS(383),
    [sym_return] = ACTIONS(385),
    [sym_next] = ACTIONS(385),
    [sym_break] = ACTIONS(385),
    [sym_true] = ACTIONS(385),
    [sym_false] = ACTIONS(385),
    [sym_null] = ACTIONS(385),
    [sym_inf] = ACTIONS(385),
    [sym_nan] = ACTIONS(385),
    [anon_sym_NA] = ACTIONS(385),
    [anon_sym_NA_integer_] = ACTIONS(385),
    [anon_sym_NA_real_] = ACTIONS(385),
    [anon_sym_NA_complex_] = ACTIONS(385),
    [anon_sym_NA_character_] = ACTIONS(385),
    [sym_dots] = ACTIONS(385),
    [sym_dot_dot_i] = ACTIONS(383),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(383),
    [sym__newline] = ACTIONS(383),
    [sym__raw_string_literal] = ACTIONS(383),
    [sym__external_else] = ACTIONS(383),
    [sym__external_open_parenthesis] = ACTIONS(313),
    [sym__external_open_brace] = ACTIONS(383),
    [sym__external_open_bracket] = ACTIONS(315),
    [sym__external_open_bracket2] = ACTIONS(317),
    [sym__external_close_bracket2] = ACTIONS(383),
  },
  [265] = {
    [sym_call_arguments] = STATE(795),
    [sym_subset_arguments] = STATE(796),
    [sym_subset2_arguments] = STATE(797),
    [sym__open_parenthesis] = STATE(361),
    [sym__open_bracket] = STATE(362),
    [sym__open_bracket2] = STATE(199),
    [sym_identifier] = ACTIONS(385),
    [anon_sym_BSLASH] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_EQ] = ACTIONS(385),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_for] = ACTIONS(385),
    [anon_sym_while] = ACTIONS(385),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_QMARK] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(275),
    [anon_sym_BANG] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(277),
    [anon_sym_DASH] = ACTIONS(279),
    [anon_sym_LT_DASH] = ACTIONS(383),
    [anon_sym_LT_LT_DASH] = ACTIONS(383),
    [anon_sym_COLON_EQ] = ACTIONS(383),
    [anon_sym_DASH_GT] = ACTIONS(385),
    [anon_sym_DASH_GT_GT] = ACTIONS(383),
    [anon_sym_PIPE] = ACTIONS(287),
    [anon_sym_AMP] = ACTIONS(289),
    [anon_sym_PIPE_PIPE] = ACTIONS(291),
    [anon_sym_AMP_AMP] = ACTIONS(293),
    [anon_sym_LT] = ACTIONS(295),
    [anon_sym_LT_EQ] = ACTIONS(297),
    [anon_sym_GT] = ACTIONS(295),
    [anon_sym_GT_EQ] = ACTIONS(297),
    [anon_sym_EQ_EQ] = ACTIONS(297),
    [anon_sym_BANG_EQ] = ACTIONS(297),
    [anon_sym_STAR] = ACTIONS(299),
    [anon_sym_SLASH] = ACTIONS(301),
    [anon_sym_STAR_STAR] = ACTIONS(303),
    [anon_sym_CARET] = ACTIONS(303),
    [aux_sym_binary_operator_token1] = ACTIONS(305),
    [anon_sym_PIPE_GT] = ACTIONS(305),
    [anon_sym_COLON] = ACTIONS(307),
    [anon_sym_DOLLAR] = ACTIONS(309),
    [anon_sym_AT] = ACTIONS(309),
    [aux_sym__hex_literal_token1] = ACTIONS(383),
    [sym__number_literal] = ACTIONS(385),
    [anon_sym_SQUOTE] = ACTIONS(383),
    [anon_sym_DQUOTE] = ACTIONS(383),
    [sym_return] = ACTIONS(385),
    [sym_next] = ACTIONS(385),
    [sym_break] = ACTIONS(385),
    [sym_true] = ACTIONS(385),
    [sym_false] = ACTIONS(385),
    [sym_null] = ACTIONS(385),
    [sym_inf] = ACTIONS(385),
    [sym_nan] = ACTIONS(385),
    [anon_sym_NA] = ACTIONS(385),
    [anon_sym_NA_integer_] = ACTIONS(385),
    [anon_sym_NA_real_] = ACTIONS(385),
    [anon_sym_NA_complex_] = ACTIONS(385),
    [anon_sym_NA_character_] = ACTIONS(385),
    [sym_dots] = ACTIONS(385),
    [sym_dot_dot_i] = ACTIONS(383),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(383),
    [sym__newline] = ACTIONS(383),
    [sym__raw_string_literal] = ACTIONS(383),
    [sym__external_else] = ACTIONS(383),
    [sym__external_open_parenthesis] = ACTIONS(313),
    [sym__external_open_brace] = ACTIONS(383),
    [sym__external_open_bracket] = ACTIONS(315),
    [sym__external_open_bracket2] = ACTIONS(317),
    [sym__external_close_bracket2] = ACTIONS(383),
  },
  [266] = {
    [sym_call_arguments] = STATE(795),
    [sym_subset_arguments] = STATE(796),
    [sym_subset2_arguments] = STATE(797),
    [sym__open_parenthesis] = STATE(361),
    [sym__open_bracket] = STATE(362),
    [sym__open_bracket2] = STATE(199),
    [sym_identifier] = ACTIONS(385),
    [anon_sym_BSLASH] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_EQ] = ACTIONS(385),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_for] = ACTIONS(385),
    [anon_sym_while] = ACTIONS(385),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_QMARK] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(383),
    [anon_sym_BANG] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(277),
    [anon_sym_DASH] = ACTIONS(279),
    [anon_sym_LT_DASH] = ACTIONS(383),
    [anon_sym_LT_LT_DASH] = ACTIONS(383),
    [anon_sym_COLON_EQ] = ACTIONS(383),
    [anon_sym_DASH_GT] = ACTIONS(385),
    [anon_sym_DASH_GT_GT] = ACTIONS(383),
    [anon_sym_PIPE] = ACTIONS(385),
    [anon_sym_AMP] = ACTIONS(289),
    [anon_sym_PIPE_PIPE] = ACTIONS(383),
    [anon_sym_AMP_AMP] = ACTIONS(293),
    [anon_sym_LT] = ACTIONS(295),
    [anon_sym_LT_EQ] = ACTIONS(297),
    [anon_sym_GT] = ACTIONS(295),
    [anon_sym_GT_EQ] = ACTIONS(297),
    [anon_sym_EQ_EQ] = ACTIONS(297),
    [anon_sym_BANG_EQ] = ACTIONS(297),
    [anon_sym_STAR] = ACTIONS(299),
    [anon_sym_SLASH] = ACTIONS(301),
    [anon_sym_STAR_STAR] = ACTIONS(303),
    [anon_sym_CARET] = ACTIONS(303),
    [aux_sym_binary_operator_token1] = ACTIONS(305),
    [anon_sym_PIPE_GT] = ACTIONS(305),
    [anon_sym_COLON] = ACTIONS(307),
    [anon_sym_DOLLAR] = ACTIONS(309),
    [anon_sym_AT] = ACTIONS(309),
    [aux_sym__hex_literal_token1] = ACTIONS(383),
    [sym__number_literal] = ACTIONS(385),
    [anon_sym_SQUOTE] = ACTIONS(383),
    [anon_sym_DQUOTE] = ACTIONS(383),
    [sym_return] = ACTIONS(385),
    [sym_next] = ACTIONS(385),
    [sym_break] = ACTIONS(385),
    [sym_true] = ACTIONS(385),
    [sym_false] = ACTIONS(385),
    [sym_null] = ACTIONS(385),
    [sym_inf] = ACTIONS(385),
    [sym_nan] = ACTIONS(385),
    [anon_sym_NA] = ACTIONS(385),
    [anon_sym_NA_integer_] = ACTIONS(385),
    [anon_sym_NA_real_] = ACTIONS(385),
    [anon_sym_NA_complex_] = ACTIONS(385),
    [anon_sym_NA_character_] = ACTIONS(385),
    [sym_dots] = ACTIONS(385),
    [sym_dot_dot_i] = ACTIONS(383),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(383),
    [sym__newline] = ACTIONS(383),
    [sym__raw_string_literal] = ACTIONS(383),
    [sym__external_else] = ACTIONS(383),
    [sym__external_open_parenthesis] = ACTIONS(313),
    [sym__external_open_brace] = ACTIONS(383),
    [sym__external_open_bracket] = ACTIONS(315),
    [sym__external_open_bracket2] = ACTIONS(317),
    [sym__external_close_bracket2] = ACTIONS(383),
  },
  [267] = {
    [sym_call_arguments] = STATE(795),
    [sym_subset_arguments] = STATE(796),
    [sym_subset2_arguments] = STATE(797),
    [sym__open_parenthesis] = STATE(361),
    [sym__open_bracket] = STATE(362),
    [sym__open_bracket2] = STATE(199),
    [sym_identifier] = ACTIONS(385),
    [anon_sym_BSLASH] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_EQ] = ACTIONS(385),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_for] = ACTIONS(385),
    [anon_sym_while] = ACTIONS(385),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_QMARK] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(383),
    [anon_sym_BANG] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(277),
    [anon_sym_DASH] = ACTIONS(279),
    [anon_sym_LT_DASH] = ACTIONS(383),
    [anon_sym_LT_LT_DASH] = ACTIONS(383),
    [anon_sym_COLON_EQ] = ACTIONS(383),
    [anon_sym_DASH_GT] = ACTIONS(385),
    [anon_sym_DASH_GT_GT] = ACTIONS(383),
    [anon_sym_PIPE] = ACTIONS(385),
    [anon_sym_AMP] = ACTIONS(385),
    [anon_sym_PIPE_PIPE] = ACTIONS(383),
    [anon_sym_AMP_AMP] = ACTIONS(383),
    [anon_sym_LT] = ACTIONS(295),
    [anon_sym_LT_EQ] = ACTIONS(297),
    [anon_sym_GT] = ACTIONS(295),
    [anon_sym_GT_EQ] = ACTIONS(297),
    [anon_sym_EQ_EQ] = ACTIONS(297),
    [anon_sym_BANG_EQ] = ACTIONS(297),
    [anon_sym_STAR] = ACTIONS(299),
    [anon_sym_SLASH] = ACTIONS(301),
    [anon_sym_STAR_STAR] = ACTIONS(303),
    [anon_sym_CARET] = ACTIONS(303),
    [aux_sym_binary_operator_token1] = ACTIONS(305),
    [anon_sym_PIPE_GT] = ACTIONS(305),
    [anon_sym_COLON] = ACTIONS(307),
    [anon_sym_DOLLAR] = ACTIONS(309),
    [anon_sym_AT] = ACTIONS(309),
    [aux_sym__hex_literal_token1] = ACTIONS(383),
    [sym__number_literal] = ACTIONS(385),
    [anon_sym_SQUOTE] = ACTIONS(383),
    [anon_sym_DQUOTE] = ACTIONS(383),
    [sym_return] = ACTIONS(385),
    [sym_next] = ACTIONS(385),
    [sym_break] = ACTIONS(385),
    [sym_true] = ACTIONS(385),
    [sym_false] = ACTIONS(385),
    [sym_null] = ACTIONS(385),
    [sym_inf] = ACTIONS(385),
    [sym_nan] = ACTIONS(385),
    [anon_sym_NA] = ACTIONS(385),
    [anon_sym_NA_integer_] = ACTIONS(385),
    [anon_sym_NA_real_] = ACTIONS(385),
    [anon_sym_NA_complex_] = ACTIONS(385),
    [anon_sym_NA_character_] = ACTIONS(385),
    [sym_dots] = ACTIONS(385),
    [sym_dot_dot_i] = ACTIONS(383),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(383),
    [sym__newline] = ACTIONS(383),
    [sym__raw_string_literal] = ACTIONS(383),
    [sym__external_else] = ACTIONS(383),
    [sym__external_open_parenthesis] = ACTIONS(313),
    [sym__external_open_brace] = ACTIONS(383),
    [sym__external_open_bracket] = ACTIONS(315),
    [sym__external_open_bracket2] = ACTIONS(317),
    [sym__external_close_bracket2] = ACTIONS(383),
  },
  [268] = {
    [sym_call_arguments] = STATE(795),
    [sym_subset_arguments] = STATE(796),
    [sym_subset2_arguments] = STATE(797),
    [sym__open_parenthesis] = STATE(361),
    [sym__open_bracket] = STATE(362),
    [sym__open_bracket2] = STATE(199),
    [sym_identifier] = ACTIONS(385),
    [anon_sym_BSLASH] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_EQ] = ACTIONS(385),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_for] = ACTIONS(385),
    [anon_sym_while] = ACTIONS(385),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_QMARK] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(383),
    [anon_sym_BANG] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(277),
    [anon_sym_DASH] = ACTIONS(279),
    [anon_sym_LT_DASH] = ACTIONS(383),
    [anon_sym_LT_LT_DASH] = ACTIONS(383),
    [anon_sym_COLON_EQ] = ACTIONS(383),
    [anon_sym_DASH_GT] = ACTIONS(385),
    [anon_sym_DASH_GT_GT] = ACTIONS(383),
    [anon_sym_PIPE] = ACTIONS(385),
    [anon_sym_AMP] = ACTIONS(385),
    [anon_sym_PIPE_PIPE] = ACTIONS(383),
    [anon_sym_AMP_AMP] = ACTIONS(383),
    [anon_sym_LT] = ACTIONS(385),
    [anon_sym_LT_EQ] = ACTIONS(383),
    [anon_sym_GT] = ACTIONS(385),
    [anon_sym_GT_EQ] = ACTIONS(383),
    [anon_sym_EQ_EQ] = ACTIONS(383),
    [anon_sym_BANG_EQ] = ACTIONS(383),
    [anon_sym_STAR] = ACTIONS(299),
    [anon_sym_SLASH] = ACTIONS(301),
    [anon_sym_STAR_STAR] = ACTIONS(303),
    [anon_sym_CARET] = ACTIONS(303),
    [aux_sym_binary_operator_token1] = ACTIONS(305),
    [anon_sym_PIPE_GT] = ACTIONS(305),
    [anon_sym_COLON] = ACTIONS(307),
    [anon_sym_DOLLAR] = ACTIONS(309),
    [anon_sym_AT] = ACTIONS(309),
    [aux_sym__hex_literal_token1] = ACTIONS(383),
    [sym__number_literal] = ACTIONS(385),
    [anon_sym_SQUOTE] = ACTIONS(383),
    [anon_sym_DQUOTE] = ACTIONS(383),
    [sym_return] = ACTIONS(385),
    [sym_next] = ACTIONS(385),
    [sym_break] = ACTIONS(385),
    [sym_true] = ACTIONS(385),
    [sym_false] = ACTIONS(385),
    [sym_null] = ACTIONS(385),
    [sym_inf] = ACTIONS(385),
    [sym_nan] = ACTIONS(385),
    [anon_sym_NA] = ACTIONS(385),
    [anon_sym_NA_integer_] = ACTIONS(385),
    [anon_sym_NA_real_] = ACTIONS(385),
    [anon_sym_NA_complex_] = ACTIONS(385),
    [anon_sym_NA_character_] = ACTIONS(385),
    [sym_dots] = ACTIONS(385),
    [sym_dot_dot_i] = ACTIONS(383),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(383),
    [sym__newline] = ACTIONS(383),
    [sym__raw_string_literal] = ACTIONS(383),
    [sym__external_else] = ACTIONS(383),
    [sym__external_open_parenthesis] = ACTIONS(313),
    [sym__external_open_brace] = ACTIONS(383),
    [sym__external_open_bracket] = ACTIONS(315),
    [sym__external_open_bracket2] = ACTIONS(317),
    [sym__external_close_bracket2] = ACTIONS(383),
  },
  [269] = {
    [sym_call_arguments] = STATE(795),
    [sym_subset_arguments] = STATE(796),
    [sym_subset2_arguments] = STATE(797),
    [sym__open_parenthesis] = STATE(361),
    [sym__open_bracket] = STATE(362),
    [sym__open_bracket2] = STATE(199),
    [sym_identifier] = ACTIONS(385),
    [anon_sym_BSLASH] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_EQ] = ACTIONS(385),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_for] = ACTIONS(385),
    [anon_sym_while] = ACTIONS(385),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_QMARK] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(383),
    [anon_sym_BANG] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(385),
    [anon_sym_LT_DASH] = ACTIONS(383),
    [anon_sym_LT_LT_DASH] = ACTIONS(383),
    [anon_sym_COLON_EQ] = ACTIONS(383),
    [anon_sym_DASH_GT] = ACTIONS(385),
    [anon_sym_DASH_GT_GT] = ACTIONS(383),
    [anon_sym_PIPE] = ACTIONS(385),
    [anon_sym_AMP] = ACTIONS(385),
    [anon_sym_PIPE_PIPE] = ACTIONS(383),
    [anon_sym_AMP_AMP] = ACTIONS(383),
    [anon_sym_LT] = ACTIONS(385),
    [anon_sym_LT_EQ] = ACTIONS(383),
    [anon_sym_GT] = ACTIONS(385),
    [anon_sym_GT_EQ] = ACTIONS(383),
    [anon_sym_EQ_EQ] = ACTIONS(383),
    [anon_sym_BANG_EQ] = ACTIONS(383),
    [anon_sym_STAR] = ACTIONS(385),
    [anon_sym_SLASH] = ACTIONS(383),
    [anon_sym_STAR_STAR] = ACTIONS(303),
    [anon_sym_CARET] = ACTIONS(303),
    [aux_sym_binary_operator_token1] = ACTIONS(305),
    [anon_sym_PIPE_GT] = ACTIONS(305),
    [anon_sym_COLON] = ACTIONS(307),
    [anon_sym_DOLLAR] = ACTIONS(309),
    [anon_sym_AT] = ACTIONS(309),
    [aux_sym__hex_literal_token1] = ACTIONS(383),
    [sym__number_literal] = ACTIONS(385),
    [anon_sym_SQUOTE] = ACTIONS(383),
    [anon_sym_DQUOTE] = ACTIONS(383),
    [sym_return] = ACTIONS(385),
    [sym_next] = ACTIONS(385),
    [sym_break] = ACTIONS(385),
    [sym_true] = ACTIONS(385),
    [sym_false] = ACTIONS(385),
    [sym_null] = ACTIONS(385),
    [sym_inf] = ACTIONS(385),
    [sym_nan] = ACTIONS(385),
    [anon_sym_NA] = ACTIONS(385),
    [anon_sym_NA_integer_] = ACTIONS(385),
    [anon_sym_NA_real_] = ACTIONS(385),
    [anon_sym_NA_complex_] = ACTIONS(385),
    [anon_sym_NA_character_] = ACTIONS(385),
    [sym_dots] = ACTIONS(385),
    [sym_dot_dot_i] = ACTIONS(383),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(383),
    [sym__newline] = ACTIONS(383),
    [sym__raw_string_literal] = ACTIONS(383),
    [sym__external_else] = ACTIONS(383),
    [sym__external_open_parenthesis] = ACTIONS(313),
    [sym__external_open_brace] = ACTIONS(383),
    [sym__external_open_bracket] = ACTIONS(315),
    [sym__external_open_bracket2] = ACTIONS(317),
    [sym__external_close_bracket2] = ACTIONS(383),
  },
  [270] = {
    [sym_call_arguments] = STATE(795),
    [sym_subset_arguments] = STATE(796),
    [sym_subset2_arguments] = STATE(797),
    [sym__open_parenthesis] = STATE(361),
    [sym__open_bracket] = STATE(362),
    [sym__open_bracket2] = STATE(199),
    [sym_identifier] = ACTIONS(385),
    [anon_sym_BSLASH] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_EQ] = ACTIONS(385),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_for] = ACTIONS(385),
    [anon_sym_while] = ACTIONS(385),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_QMARK] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(383),
    [anon_sym_BANG] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(385),
    [anon_sym_LT_DASH] = ACTIONS(383),
    [anon_sym_LT_LT_DASH] = ACTIONS(383),
    [anon_sym_COLON_EQ] = ACTIONS(383),
    [anon_sym_DASH_GT] = ACTIONS(385),
    [anon_sym_DASH_GT_GT] = ACTIONS(383),
    [anon_sym_PIPE] = ACTIONS(385),
    [anon_sym_AMP] = ACTIONS(385),
    [anon_sym_PIPE_PIPE] = ACTIONS(383),
    [anon_sym_AMP_AMP] = ACTIONS(383),
    [anon_sym_LT] = ACTIONS(385),
    [anon_sym_LT_EQ] = ACTIONS(383),
    [anon_sym_GT] = ACTIONS(385),
    [anon_sym_GT_EQ] = ACTIONS(383),
    [anon_sym_EQ_EQ] = ACTIONS(383),
    [anon_sym_BANG_EQ] = ACTIONS(383),
    [anon_sym_STAR] = ACTIONS(385),
    [anon_sym_SLASH] = ACTIONS(383),
    [anon_sym_STAR_STAR] = ACTIONS(303),
    [anon_sym_CARET] = ACTIONS(303),
    [aux_sym_binary_operator_token1] = ACTIONS(383),
    [anon_sym_PIPE_GT] = ACTIONS(383),
    [anon_sym_COLON] = ACTIONS(385),
    [anon_sym_DOLLAR] = ACTIONS(309),
    [anon_sym_AT] = ACTIONS(309),
    [aux_sym__hex_literal_token1] = ACTIONS(383),
    [sym__number_literal] = ACTIONS(385),
    [anon_sym_SQUOTE] = ACTIONS(383),
    [anon_sym_DQUOTE] = ACTIONS(383),
    [sym_return] = ACTIONS(385),
    [sym_next] = ACTIONS(385),
    [sym_break] = ACTIONS(385),
    [sym_true] = ACTIONS(385),
    [sym_false] = ACTIONS(385),
    [sym_null] = ACTIONS(385),
    [sym_inf] = ACTIONS(385),
    [sym_nan] = ACTIONS(385),
    [anon_sym_NA] = ACTIONS(385),
    [anon_sym_NA_integer_] = ACTIONS(385),
    [anon_sym_NA_real_] = ACTIONS(385),
    [anon_sym_NA_complex_] = ACTIONS(385),
    [anon_sym_NA_character_] = ACTIONS(385),
    [sym_dots] = ACTIONS(385),
    [sym_dot_dot_i] = ACTIONS(383),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(383),
    [sym__newline] = ACTIONS(383),
    [sym__raw_string_literal] = ACTIONS(383),
    [sym__external_else] = ACTIONS(383),
    [sym__external_open_parenthesis] = ACTIONS(313),
    [sym__external_open_brace] = ACTIONS(383),
    [sym__external_open_bracket] = ACTIONS(315),
    [sym__external_open_bracket2] = ACTIONS(317),
    [sym__external_close_bracket2] = ACTIONS(383),
  },
  [271] = {
    [sym_call_arguments] = STATE(795),
    [sym_subset_arguments] = STATE(796),
    [sym_subset2_arguments] = STATE(797),
    [sym__open_parenthesis] = STATE(361),
    [sym__open_bracket] = STATE(362),
    [sym__open_bracket2] = STATE(199),
    [sym_identifier] = ACTIONS(385),
    [anon_sym_BSLASH] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_EQ] = ACTIONS(385),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_for] = ACTIONS(385),
    [anon_sym_while] = ACTIONS(385),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_QMARK] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(383),
    [anon_sym_BANG] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(385),
    [anon_sym_LT_DASH] = ACTIONS(383),
    [anon_sym_LT_LT_DASH] = ACTIONS(383),
    [anon_sym_COLON_EQ] = ACTIONS(383),
    [anon_sym_DASH_GT] = ACTIONS(385),
    [anon_sym_DASH_GT_GT] = ACTIONS(383),
    [anon_sym_PIPE] = ACTIONS(385),
    [anon_sym_AMP] = ACTIONS(385),
    [anon_sym_PIPE_PIPE] = ACTIONS(383),
    [anon_sym_AMP_AMP] = ACTIONS(383),
    [anon_sym_LT] = ACTIONS(385),
    [anon_sym_LT_EQ] = ACTIONS(383),
    [anon_sym_GT] = ACTIONS(385),
    [anon_sym_GT_EQ] = ACTIONS(383),
    [anon_sym_EQ_EQ] = ACTIONS(383),
    [anon_sym_BANG_EQ] = ACTIONS(383),
    [anon_sym_STAR] = ACTIONS(385),
    [anon_sym_SLASH] = ACTIONS(383),
    [anon_sym_STAR_STAR] = ACTIONS(303),
    [anon_sym_CARET] = ACTIONS(303),
    [aux_sym_binary_operator_token1] = ACTIONS(383),
    [anon_sym_PIPE_GT] = ACTIONS(383),
    [anon_sym_COLON] = ACTIONS(307),
    [anon_sym_DOLLAR] = ACTIONS(309),
    [anon_sym_AT] = ACTIONS(309),
    [aux_sym__hex_literal_token1] = ACTIONS(383),
    [sym__number_literal] = ACTIONS(385),
    [anon_sym_SQUOTE] = ACTIONS(383),
    [anon_sym_DQUOTE] = ACTIONS(383),
    [sym_return] = ACTIONS(385),
    [sym_next] = ACTIONS(385),
    [sym_break] = ACTIONS(385),
    [sym_true] = ACTIONS(385),
    [sym_false] = ACTIONS(385),
    [sym_null] = ACTIONS(385),
    [sym_inf] = ACTIONS(385),
    [sym_nan] = ACTIONS(385),
    [anon_sym_NA] = ACTIONS(385),
    [anon_sym_NA_integer_] = ACTIONS(385),
    [anon_sym_NA_real_] = ACTIONS(385),
    [anon_sym_NA_complex_] = ACTIONS(385),
    [anon_sym_NA_character_] = ACTIONS(385),
    [sym_dots] = ACTIONS(385),
    [sym_dot_dot_i] = ACTIONS(383),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(383),
    [sym__newline] = ACTIONS(383),
    [sym__raw_string_literal] = ACTIONS(383),
    [sym__external_else] = ACTIONS(383),
    [sym__external_open_parenthesis] = ACTIONS(313),
    [sym__external_open_brace] = ACTIONS(383),
    [sym__external_open_bracket] = ACTIONS(315),
    [sym__external_open_bracket2] = ACTIONS(317),
    [sym__external_close_bracket2] = ACTIONS(383),
  },
  [272] = {
    [sym_call_arguments] = STATE(795),
    [sym_subset_arguments] = STATE(796),
    [sym_subset2_arguments] = STATE(797),
    [sym__open_parenthesis] = STATE(361),
    [sym__open_bracket] = STATE(362),
    [sym__open_bracket2] = STATE(199),
    [sym_identifier] = ACTIONS(385),
    [anon_sym_BSLASH] = ACTIONS(383),
    [anon_sym_function] = ACTIONS(385),
    [anon_sym_EQ] = ACTIONS(385),
    [anon_sym_if] = ACTIONS(385),
    [anon_sym_for] = ACTIONS(385),
    [anon_sym_while] = ACTIONS(385),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_QMARK] = ACTIONS(383),
    [anon_sym_TILDE] = ACTIONS(383),
    [anon_sym_BANG] = ACTIONS(385),
    [anon_sym_PLUS] = ACTIONS(383),
    [anon_sym_DASH] = ACTIONS(385),
    [anon_sym_LT_DASH] = ACTIONS(383),
    [anon_sym_LT_LT_DASH] = ACTIONS(383),
    [anon_sym_COLON_EQ] = ACTIONS(383),
    [anon_sym_DASH_GT] = ACTIONS(385),
    [anon_sym_DASH_GT_GT] = ACTIONS(383),
    [anon_sym_PIPE] = ACTIONS(385),
    [anon_sym_AMP] = ACTIONS(385),
    [anon_sym_PIPE_PIPE] = ACTIONS(383),
    [anon_sym_AMP_AMP] = ACTIONS(383),
    [anon_sym_LT] = ACTIONS(385),
    [anon_sym_LT_EQ] = ACTIONS(383),
    [anon_sym_GT] = ACTIONS(385),
    [anon_sym_GT_EQ] = ACTIONS(383),
    [anon_sym_EQ_EQ] = ACTIONS(383),
    [anon_sym_BANG_EQ] = ACTIONS(383),
    [anon_sym_STAR] = ACTIONS(385),
    [anon_sym_SLASH] = ACTIONS(383),
    [anon_sym_STAR_STAR] = ACTIONS(303),
    [anon_sym_CARET] = ACTIONS(303),
    [aux_sym_binary_operator_token1] = ACTIONS(383),
    [anon_sym_PIPE_GT] = ACTIONS(383),
    [anon_sym_COLON] = ACTIONS(385),
    [anon_sym_DOLLAR] = ACTIONS(309),
    [anon_sym_AT] = ACTIONS(309),
    [aux_sym__hex_literal_token1] = ACTIONS(383),
    [sym__number_literal] = ACTIONS(385),
    [anon_sym_SQUOTE] = ACTIONS(383),
    [anon_sym_DQUOTE] = ACTIONS(383),
    [sym_return] = ACTIONS(385),
    [sym_next] = ACTIONS(385),
    [sym_break] = ACTIONS(385),
    [sym_true] = ACTIONS(385),
    [sym_false] = ACTIONS(385),
    [sym_null] = ACTIONS(385),
    [sym_inf] = ACTIONS(385),
    [sym_nan] = ACTIONS(385),
    [anon_sym_NA] = ACTIONS(385),
    [anon_sym_NA_integer_] = ACTIONS(385),
    [anon_sym_NA_real_] = ACTIONS(385),
    [anon_sym_NA_complex_] = ACTIONS(385),
    [anon_sym_NA_character_] = ACTIONS(385),
    [sym_dots] = ACTIONS(385),
    [sym_dot_dot_i] = ACTIONS(383),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(383),
    [sym__newline] = ACTIONS(383),
    [sym__raw_string_literal] = ACTIONS(383),
    [sym__external_else] = ACTIONS(383),
    [sym__external_open_parenthesis] = ACTIONS(313),
    [sym__external_open_brace] = ACTIONS(383),
    [sym__external_open_bracket] = ACTIONS(315),
    [sym__external_open_bracket2] = ACTIONS(317),
    [sym__external_close_bracket2] = ACTIONS(383),
  },
  [273] = {
    [sym_function_definition] = STATE(631),
    [sym_if_statement] = STATE(631),
    [sym_for_statement] = STATE(631),
    [sym_while_statement] = STATE(631),
    [sym_repeat_statement] = STATE(631),
    [sym_braced_expression] = STATE(631),
    [sym_parenthesized_expression] = STATE(631),
    [sym_call] = STATE(631),
    [sym_subset] = STATE(631),
    [sym_subset2] = STATE(631),
    [sym__argument] = STATE(1934),
    [sym_argument] = STATE(1937),
    [sym__argument_named] = STATE(1909),
    [sym__argument_unnamed] = STATE(1932),
    [sym__argument_value] = STATE(1920),
    [sym_unary_operator] = STATE(631),
    [sym_binary_operator] = STATE(631),
    [sym_extract_operator] = STATE(631),
    [sym_namespace_operator] = STATE(631),
    [sym_integer] = STATE(631),
    [sym_complex] = STATE(631),
    [sym_float] = STATE(631),
    [sym__hex_literal] = STATE(752),
    [sym__float_literal] = STATE(752),
    [sym_string] = STATE(766),
    [sym__single_quoted_string] = STATE(753),
    [sym__double_quoted_string] = STATE(754),
    [sym_na] = STATE(631),
    [sym__expression] = STATE(631),
    [sym__string_or_identifier] = STATE(2143),
    [sym__open_parenthesis] = STATE(869),
    [sym__open_brace] = STATE(764),
    [sym__close_bracket] = STATE(832),
    [aux_sym_call_arguments_repeat1] = STATE(529),
    [sym_identifier] = ACTIONS(387),
    [anon_sym_BSLASH] = ACTIONS(389),
    [anon_sym_function] = ACTIONS(391),
    [anon_sym_if] = ACTIONS(393),
    [anon_sym_for] = ACTIONS(395),
    [anon_sym_while] = ACTIONS(397),
    [anon_sym_repeat] = ACTIONS(399),
    [anon_sym_QMARK] = ACTIONS(401),
    [anon_sym_TILDE] = ACTIONS(403),
    [anon_sym_BANG] = ACTIONS(405),
    [anon_sym_PLUS] = ACTIONS(407),
    [anon_sym_DASH] = ACTIONS(407),
    [aux_sym__hex_literal_token1] = ACTIONS(409),
    [sym__number_literal] = ACTIONS(411),
    [anon_sym_SQUOTE] = ACTIONS(413),
    [anon_sym_DQUOTE] = ACTIONS(415),
    [sym_return] = ACTIONS(417),
    [sym_next] = ACTIONS(417),
    [sym_break] = ACTIONS(417),
    [sym_true] = ACTIONS(417),
    [sym_false] = ACTIONS(417),
    [sym_null] = ACTIONS(417),
    [sym_inf] = ACTIONS(417),
    [sym_nan] = ACTIONS(417),
    [anon_sym_NA] = ACTIONS(419),
    [anon_sym_NA_integer_] = ACTIONS(419),
    [anon_sym_NA_real_] = ACTIONS(419),
    [anon_sym_NA_complex_] = ACTIONS(419),
    [anon_sym_NA_character_] = ACTIONS(419),
    [sym_dots] = ACTIONS(421),
    [sym_dot_dot_i] = ACTIONS(423),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(425),
    [sym__newline] = ACTIONS(427),
    [sym__raw_string_literal] = ACTIONS(429),
    [sym__external_open_parenthesis] = ACTIONS(431),
    [sym__external_open_brace] = ACTIONS(433),
    [sym__external_close_bracket] = ACTIONS(563),
  },
  [274] = {
    [sym_function_definition] = STATE(568),
    [sym_if_statement] = STATE(568),
    [sym_for_statement] = STATE(568),
    [sym_while_statement] = STATE(568),
    [sym_repeat_statement] = STATE(568),
    [sym_braced_expression] = STATE(568),
    [sym_parenthesized_expression] = STATE(568),
    [sym_call] = STATE(568),
    [sym_subset] = STATE(568),
    [sym_subset2] = STATE(568),
    [sym__argument] = STATE(1928),
    [sym_argument] = STATE(1930),
    [sym__argument_named] = STATE(1908),
    [sym__argument_unnamed] = STATE(1933),
    [sym__argument_value] = STATE(1936),
    [sym_unary_operator] = STATE(568),
    [sym_binary_operator] = STATE(568),
    [sym_extract_operator] = STATE(568),
    [sym_namespace_operator] = STATE(568),
    [sym_integer] = STATE(568),
    [sym_complex] = STATE(568),
    [sym_float] = STATE(568),
    [sym__hex_literal] = STATE(703),
    [sym__float_literal] = STATE(703),
    [sym_string] = STATE(736),
    [sym__single_quoted_string] = STATE(705),
    [sym__double_quoted_string] = STATE(706),
    [sym_na] = STATE(568),
    [sym__expression] = STATE(568),
    [sym__string_or_identifier] = STATE(2142),
    [sym__open_parenthesis] = STATE(874),
    [sym__open_brace] = STATE(765),
    [sym__close_bracket2] = STATE(833),
    [aux_sym_call_arguments_repeat1] = STATE(585),
    [sym_identifier] = ACTIONS(437),
    [anon_sym_BSLASH] = ACTIONS(439),
    [anon_sym_function] = ACTIONS(441),
    [anon_sym_if] = ACTIONS(443),
    [anon_sym_for] = ACTIONS(445),
    [anon_sym_while] = ACTIONS(447),
    [anon_sym_repeat] = ACTIONS(449),
    [anon_sym_QMARK] = ACTIONS(451),
    [anon_sym_TILDE] = ACTIONS(453),
    [anon_sym_BANG] = ACTIONS(455),
    [anon_sym_PLUS] = ACTIONS(457),
    [anon_sym_DASH] = ACTIONS(457),
    [aux_sym__hex_literal_token1] = ACTIONS(459),
    [sym__number_literal] = ACTIONS(461),
    [anon_sym_SQUOTE] = ACTIONS(463),
    [anon_sym_DQUOTE] = ACTIONS(465),
    [sym_return] = ACTIONS(467),
    [sym_next] = ACTIONS(467),
    [sym_break] = ACTIONS(467),
    [sym_true] = ACTIONS(467),
    [sym_false] = ACTIONS(467),
    [sym_null] = ACTIONS(467),
    [sym_inf] = ACTIONS(467),
    [sym_nan] = ACTIONS(467),
    [anon_sym_NA] = ACTIONS(469),
    [anon_sym_NA_integer_] = ACTIONS(469),
    [anon_sym_NA_real_] = ACTIONS(469),
    [anon_sym_NA_complex_] = ACTIONS(469),
    [anon_sym_NA_character_] = ACTIONS(469),
    [sym_dots] = ACTIONS(471),
    [sym_dot_dot_i] = ACTIONS(473),
    [sym_comment] = ACTIONS(3),
    [sym_comma] = ACTIONS(475),
    [sym__newline] = ACTIONS(477),
    [sym__raw_string_literal] = ACTIONS(479),
    [sym__external_open_parenthesis] = ACTIONS(481),
    [sym__external_open_brace] = ACTIONS(483),
    [sym__external_close_bracket2] = ACTIONS(565),
  },
  [275] = {
    [sym_call_arguments] = STATE(795),
    [sym_subset_arguments] = STATE(796),
    [sym_subset2_arguments] = STATE(797),
    [sym__open_parenthesis] = STATE(361),
    [sym__open_bracket] = STATE(362),
    [sym__open_bracket2] = STATE(199),
    [sym_identifier] = ACTIONS(489),
    [anon_sym_BSLASH] = ACTIONS(487),
    [anon_sym_function] = ACTIONS(489),
    [anon_sym_EQ] = ACTIONS(273),
    [anon_sym_if] = ACTIONS(489),
    [anon_sym_for] = ACTIONS(489),
    [anon_sym_while] = ACTIONS(489),
    [anon_sym_repeat] = ACTIONS(489),
    [anon_sym_QMARK] = ACTIONS(487),
    [anon_sym_TILDE] = ACTIONS(275),
    [anon_sym_BANG] = ACTIONS(489),
    [anon_sym_PLUS] = ACTIONS(277),
    [anon_sym_DASH] = ACTIONS(279),
    [anon_sym_LT_DASH] = ACTIONS(281),
    [anon_sym_LT_LT_DASH] = ACTIONS(281),
    [anon_sym_COLON_EQ] = ACTIONS(281),
    [anon_sym_DASH_GT] = ACTIONS(283),
    [anon_sym_DASH_GT_GT] = ACTIONS(285),
    [anon_sym_PIPE] = ACTIONS(287),
    [anon_sym_AMP] = ACTIONS(289),
    [anon_sym_PIPE_PIPE] = ACTIONS(291),
    [anon_sym_AMP_AMP] = ACTIONS(293),
    [anon_sym_LT] = ACTIONS(295),
    [anon_sym_LT_EQ] = ACTIONS(297),
    [anon_sym_GT] = ACTIONS(295),
    [anon_sym_GT_EQ] = ACTIONS(297),
    [anon_sym_EQ_EQ] = ACTIONS(297),
    [anon_sym_BANG_EQ] = ACTIONS(297),
    [anon_sym_STAR] = ACTIONS(299),
    [anon_sym_SLASH] = ACTIONS(301),
    [anon_sym_STAR_STAR] = ACTIONS(303),
    [anon_sym_CARET] = AC