% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate.R
\name{generate_n_arms_star_data}
\alias{generate_n_arms_star_data}
\title{Generate a multi-dimensional star tree data}
\usage{
generate_n_arms_star_data(n_features, n_samples, n_arms, fatness)
}
\arguments{
\item{n_features}{The number of features (dimensions) to be
generated.}

\item{n_samples}{The number of samples to be generated.}

\item{n_arms}{The number of arms to be generated.}

\item{fatness}{How fat from the based star tree. \verb{[0.0, 1.0]} is
available value range.}
}
\value{
A generated \code{martix}. The rows and columns correspond to
samples and features.
}
\description{
Generate a multi-dimensional star tree data that contain
\code{n_samples} data points and fit a star tree with \code{n_arms} arms.
}
\examples{
# Generate a 100-dimensional star tree data that contain 500 data points
# and fit a star tree with 3 arms. The generated data are a bit noisy but
# tree-like.
star100.tree_like <- treefit::generate_n_arms_star_data(100, 500, 3, 0.1)
# Reduce dimension to visualize.
star3.tree_like = prcomp(star100.tree_like, rank.=3)$x
plotly::plot_ly(data.frame(star3.tree_like),
                x=~PC1,
                y=~PC2,
                z=~PC3,
                type="scatter3d",
                mode="markers",
                marker=list(size=1))

}
