% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse_beast_trees.R
\name{parse_beast_trees}
\alias{parse_beast_trees}
\title{Parses a BEAST2 .trees output file}
\usage{
parse_beast_trees(filename)
}
\arguments{
\item{filename}{name of the BEAST2 .trees output file}
}
\value{
the phylogenies in the posterior
}
\description{
Parses a BEAST2 .trees output file
}
\examples{
  trees_filename <- get_tracerer_path("beast2_example_output.trees")
  posterior <- parse_beast_trees(trees_filename)
  testit::assert(is_trees_posterior(posterior))
}
\seealso{
Use \code{\link{save_beast_trees}} to save the phylogenies
  to a \code{.trees} file.
}
\author{
Richèl J.C. Bilderbeek
}
