% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen-namespace-docs.R,
%   R/gen-namespace-examples.R, R/gen-namespace.R
\name{torch_conv_transpose2d}
\alias{torch_conv_transpose2d}
\title{Conv_transpose2d}
\usage{
torch_conv_transpose2d(
  input,
  weight,
  bias = list(),
  stride = 1L,
  padding = 0L,
  output_padding = 0L,
  groups = 1L,
  dilation = 1L
)
}
\arguments{
\item{input}{input tensor of shape \eqn{(\mbox{minibatch} , \mbox{in\_channels} , iH , iW)}}

\item{weight}{filters of shape \eqn{(\mbox{in\_channels} , \frac{\mbox{out\_channels}}{\mbox{groups}} , kH , kW)}}

\item{bias}{optional bias of shape \eqn{(\mbox{out\_channels})}. Default: NULL}

\item{stride}{the stride of the convolving kernel. Can be a single number or a      tuple \verb{(sH, sW)}. Default: 1}

\item{padding}{\code{dilation * (kernel_size - 1) - padding} zero-padding will be added to both      sides of each dimension in the input. Can be a single number or a tuple      \verb{(padH, padW)}. Default: 0}

\item{output_padding}{additional size added to one side of each dimension in the      output shape. Can be a single number or a tuple \verb{(out_padH, out_padW)}.      Default: 0}

\item{groups}{split input into groups, \eqn{\mbox{in\_channels}} should be divisible by the      number of groups. Default: 1}

\item{dilation}{the spacing between kernel elements. Can be a single number or      a tuple \verb{(dH, dW)}. Default: 1}
}
\description{
Conv_transpose2d
}
\section{conv_transpose2d(input, weight, bias=NULL, stride=1, padding=0, output_padding=0, groups=1, dilation=1) -> Tensor }{


Applies a 2D transposed convolution operator over an input image
composed of several input planes, sometimes also called "deconvolution".

See \code{\link[=nn_conv_transpose2d]{nn_conv_transpose2d()}} for details and output shape.
}

\examples{
if (torch_is_installed()) {

# With square kernels and equal stride
inputs = torch_randn(c(1, 4, 5, 5))
weights = torch_randn(c(4, 8, 3, 3))
nnf_conv_transpose2d(inputs, weights, padding=1)
}
}
