% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nn-loss.R
\name{nn_kl_div_loss}
\alias{nn_kl_div_loss}
\title{Kullback-Leibler divergence loss}
\usage{
nn_kl_div_loss(reduction = "mean")
}
\arguments{
\item{reduction}{(string, optional): Specifies the reduction to apply to the output:
\code{'none'} | \code{'batchmean'} | \code{'sum'} | \code{'mean'}.
\code{'none'}: no reduction will be applied.
\code{'batchmean'}: the sum of the output will be divided by batchsize.
\code{'sum'}: the output will be summed.
\code{'mean'}: the output will be divided by the number of elements in the output.
Default: \code{'mean'}}
}
\description{
The Kullback-Leibler divergence loss measure
\href{https://en.wikipedia.org/wiki/Kullback-Leibler_divergence}{Kullback-Leibler divergence}
is a useful distance measure for continuous distributions and is often
useful when performing direct regression over the space of (discretely sampled)
continuous output distributions.
}
\details{
As with \code{\link[=nn_nll_loss]{nn_nll_loss()}}, the \code{input} given is expected to contain
\emph{log-probabilities} and is not restricted to a 2D Tensor.

The targets are interpreted as \emph{probabilities} by default, but could be considered
as \emph{log-probabilities} with \code{log_target} set to \code{TRUE}.

This criterion expects a \code{target} \code{Tensor} of the same size as the
\code{input} \code{Tensor}.

The unreduced (i.e. with \code{reduction} set to \code{'none'}) loss can be described
as:

\deqn{
  l(x,y) = L = \{ l_1,\dots,l_N \}, \quad
l_n = y_n \cdot \left( \log y_n - x_n \right)
}

where the index \eqn{N} spans all dimensions of \code{input} and \eqn{L} has the same
shape as \code{input}. If \code{reduction} is not \code{'none'} (default \code{'mean'}), then:

\deqn{
  \ell(x, y) = \begin{array}{ll}
\mbox{mean}(L), & \mbox{if reduction} = \mbox{'mean';} \\
\mbox{sum}(L),  & \mbox{if reduction} = \mbox{'sum'.}
\end{array}
}

In default \code{reduction} mode \code{'mean'}, the losses are averaged for each minibatch
over observations \strong{as well as} over dimensions. \code{'batchmean'} mode gives the
correct KL divergence where losses are averaged over batch dimension only.
\code{'mean'} mode's behavior will be changed to the same as \code{'batchmean'} in the next
major release.
}
\note{
\code{reduction} = \code{'mean'} doesn't return the true kl divergence value,
please use \code{reduction} = \code{'batchmean'} which aligns with KL math
definition.
In the next major release, \code{'mean'} will be changed to be the same as
\code{'batchmean'}.
}
\section{Shape}{

\itemize{
\item Input: \eqn{(N, *)} where \eqn{*} means, any number of additional
dimensions
\item Target: \eqn{(N, *)}, same shape as the input
\item Output: scalar by default. If \code{reduction} is \code{'none'}, then \eqn{(N, *)},
the same shape as the input
}
}

