% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linalg.R
\name{linalg_tensorinv}
\alias{linalg_tensorinv}
\title{Computes the multiplicative inverse of \code{\link[=torch_tensordot]{torch_tensordot()}}}
\usage{
linalg_tensorinv(A, ind = 3L)
}
\arguments{
\item{A}{(Tensor): tensor to invert.}

\item{ind}{(int): index at which to compute the inverse of \code{\link[=torch_tensordot]{torch_tensordot()}}. Default: \code{3}.}
}
\description{
If \code{m} is the product of the first \code{ind} dimensions of \code{A} and \code{n} is the product of
the rest of the dimensions, this function expects \code{m} and \code{n} to be equal.
If this is the case, it computes a tensor \code{X} such that
\code{tensordot(A, X, ind)} is the identity matrix in dimension \code{m}.
}
\details{
Supports input of float, double, cfloat and cdouble dtypes.
}
\note{
Consider using \code{\link[=linalg_tensorsolve]{linalg_tensorsolve()}} if possible for multiplying a tensor on the left
by the tensor inverse as \verb{linalg_tensorsolve(A, B) == torch_tensordot(linalg_tensorinv(A), B))}

It is always prefered to use \code{\link[=linalg_tensorsolve]{linalg_tensorsolve()}} when possible, as it is faster and more
numerically stable than computing the pseudoinverse explicitly.
}
\examples{
if (torch_is_installed()) {
A <- torch_eye(4 * 6)$reshape(c(4, 6, 8, 3))
Ainv <- linalg_tensorinv(A, ind = 3)
Ainv$shape
B <- torch_randn(4, 6)
torch_allclose(torch_tensordot(Ainv, B), linalg_tensorsolve(A, B))

A <- torch_randn(4, 4)
Atensorinv <- linalg_tensorinv(A, 2)
Ainv <- linalg_inv(A)
torch_allclose(Atensorinv, Ainv)
}
}
\seealso{
\itemize{
\item \code{\link[=linalg_tensorsolve]{linalg_tensorsolve()}} computes \verb{torch_tensordot(linalg_tensorinv(A), B))}.
}

Other linalg: 
\code{\link{linalg_cholesky_ex}()},
\code{\link{linalg_cholesky}()},
\code{\link{linalg_det}()},
\code{\link{linalg_eigh}()},
\code{\link{linalg_eigvalsh}()},
\code{\link{linalg_eigvals}()},
\code{\link{linalg_eig}()},
\code{\link{linalg_householder_product}()},
\code{\link{linalg_inv_ex}()},
\code{\link{linalg_inv}()},
\code{\link{linalg_lstsq}()},
\code{\link{linalg_matrix_norm}()},
\code{\link{linalg_matrix_power}()},
\code{\link{linalg_matrix_rank}()},
\code{\link{linalg_multi_dot}()},
\code{\link{linalg_norm}()},
\code{\link{linalg_pinv}()},
\code{\link{linalg_qr}()},
\code{\link{linalg_slogdet}()},
\code{\link{linalg_solve_triangular}()},
\code{\link{linalg_solve}()},
\code{\link{linalg_svdvals}()},
\code{\link{linalg_svd}()},
\code{\link{linalg_tensorsolve}()},
\code{\link{linalg_vector_norm}()}
}
\concept{linalg}
