% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linalg.R
\name{linalg_eigvals}
\alias{linalg_eigvals}
\title{Computes the eigenvalues of a square matrix.}
\usage{
linalg_eigvals(A)
}
\arguments{
\item{A}{(Tensor): tensor of shape \verb{(*, n, n)} where \code{*} is zero or more batch dimensions.}
}
\description{
Letting \teqn{\mathbb{K}} be \teqn{\mathbb{R}} or \teqn{\mathbb{C}},
the \strong{eigenvalues} of a square matrix \teqn{A \in \mathbb{K}^{n \times n}} are defined
as the roots (counted with multiplicity) of the polynomial \code{p} of degree \code{n} given by
}
\details{
\Sexpr[results=rd, stage=build]{torch:::math_to_rd("
p(\\\\lambda) = \\\\operatorname{det}(A - \\\\lambda \\\\mathrm{I}_n)\\\\mathrlap{\\\\qquad \\\\lambda \\\\in \\\\mathbb{C}}
")}

where \teqn{\mathrm{I}_n} is the \code{n}-dimensional identity matrix.
Supports input of float, double, cfloat and cdouble dtypes.
Also supports batches of matrices, and if \code{A} is a batch of matrices then
the output has the same batch dimensions.
}
\note{
The eigenvalues of a real matrix may be complex, as the roots of a real polynomial may be complex.
The eigenvalues of a matrix are always well-defined, even when the matrix is not diagonalizable.
}
\examples{
if (torch_is_installed()) {
a <- torch_randn(2, 2)
w <- linalg_eigvals(a)
}
}
\seealso{
\code{\link[=linalg_eig]{linalg_eig()}} computes the full eigenvalue decomposition.

Other linalg: 
\code{\link{linalg_cholesky_ex}()},
\code{\link{linalg_cholesky}()},
\code{\link{linalg_det}()},
\code{\link{linalg_eigh}()},
\code{\link{linalg_eigvalsh}()},
\code{\link{linalg_eig}()},
\code{\link{linalg_householder_product}()},
\code{\link{linalg_inv_ex}()},
\code{\link{linalg_inv}()},
\code{\link{linalg_lstsq}()},
\code{\link{linalg_matrix_norm}()},
\code{\link{linalg_matrix_power}()},
\code{\link{linalg_matrix_rank}()},
\code{\link{linalg_multi_dot}()},
\code{\link{linalg_norm}()},
\code{\link{linalg_pinv}()},
\code{\link{linalg_qr}()},
\code{\link{linalg_slogdet}()},
\code{\link{linalg_solve_triangular}()},
\code{\link{linalg_solve}()},
\code{\link{linalg_svdvals}()},
\code{\link{linalg_svd}()},
\code{\link{linalg_tensorinv}()},
\code{\link{linalg_tensorsolve}()},
\code{\link{linalg_vector_norm}()}
}
\concept{linalg}
