% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/other.R
\name{tind-other}
\alias{tind-other}
\alias{as.yearmon}
\alias{as.yearqtr}
\alias{as.timeDate}
\alias{as.chron}
\alias{as.dates}
\alias{as.times}
\alias{as.IDate}
\alias{as.ITime}
\alias{as.tind.yearmon}
\alias{as.yearmon.tind}
\alias{as.tind.yearqtr}
\alias{as.yearqtr.tind}
\alias{as.tind.timeDate}
\alias{as.timeDate.tind}
\alias{as.tind.chron}
\alias{as.chron.tind}
\alias{as.tind.dates}
\alias{as.dates.tind}
\alias{as.tind.times}
\alias{as.times.tind}
\alias{as.tind.IDate}
\alias{as.IDate.tind}
\alias{as.tind.ITime}
\alias{as.ITime.tind}
\title{Conversion between \code{tind} and Other Time Index Representations}
\usage{
\method{as.tind}{yearmon}(x, ...)

as.yearmon(x, ...)

\method{as.tind}{yearqtr}(x, ...)

as.yearqtr(x, ...)

\method{as.tind}{timeDate}(x, digits = 0L, ...)

as.timeDate(x, ...)

\method{as.tind}{chron}(x, digits = 0L, ...)

as.chron(x, ...)

\method{as.tind}{dates}(x, ...)

as.dates(x, ...)

\method{as.tind}{times}(x, digits = 0L, ...)

as.times(x)

\method{as.tind}{IDate}(x, ...)

as.IDate(x, ...)

\method{as.tind}{ITime}(x, ...)

as.ITime(x)
}
\arguments{
\item{x}{an R object to be converted.}

\item{...}{(ignored) further arguments passed to or from other methods.}

\item{digits}{an integer value (0--6) determining the number of decimal places
for seconds to be preserved during conversion (0 by default).}
}
\value{
\code{as.xxx} returns an object of \code{xxx} class of the same
length as the argument.
}
\description{
Besides \code{Date}, \code{POSIXct}, and \code{POSIXlt} classes from
package \pkg{base}, \pkg{tind} currently supports conversion between
\code{tind} and the following classes: \code{yearmon}, \code{yearqtr}
(both from package \pkg{zoo}), \code{timeDate} (from package \pkg{timeDate}),
\code{chron}, \code{dates}, \code{times} (from package \pkg{chron}),
and \code{IDate}, \code{ITime} (from package \pkg{data.table}).
}
\details{
Date-time indices resulting from conversion of \code{chron} objects
always have time zone set to UTC. Use \code{\link{tzone<-}}
or \code{\link{as.tzone}} methods when necessary.
}
\seealso{
\code{\link{as.tind}} and \link{tind-coercion} for conversions
to and from \code{tind}, \code{\link{date2num}} and \code{\link{num2date}}
for conversion between \code{tind} and integer representations of dates
(days since ...) found in different software packages.
}
