% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chemdose_chlordecay.R
\name{chemdose_chlordecay}
\alias{chemdose_chlordecay}
\title{Calculate chlorine decay}
\source{
U.S. EPA (2001)

See references list at: \url{https://github.com/BrownandCaldwell-Public/tidywater/wiki/References}
}
\usage{
chemdose_chlordecay(
  water,
  cl2_dose,
  time,
  treatment = "raw",
  cl_type = "chlorine"
)
}
\arguments{
\item{water}{Source water object of class "water" created by \code{\link{define_water}}}

\item{cl2_dose}{Applied chlorine or chloramine dose (mg/L as cl2). Model results are valid for doses between 0.995 and 41.7 mg/L for raw water,
and for doses between 1.11 and 24.7 mg/L for coagulated water.}

\item{time}{Reaction time (hours). Chlorine decay model results are valid for reaction times between 0.25 and 120 hours.Chloramine decay model
does not have specified boundary conditions.}

\item{treatment}{Type of treatment applied to the water. Options include "raw" for no treatment (default), "coag" for
water that has been coagulated or softened.}

\item{cl_type}{Type of chlorination applied, either "chlorine" (default) or "chloramine".}
}
\value{
An updated disinfectant residual in the free_chlorine or combined chlorine water slot in units of M.
Use \code{\link{convert_units}} to convert to mg/L.
}
\description{
calculates the decay of chlorine or chloramine based on the U.S. EPA's
Water Treatment Plant Model (U.S. EPA, 2001).
}
\details{
Required arguments include an object of class "water" created by \code{\link{define_water}},
applied chlorine/chloramine dose, type, reaction time, and treatment applied (options include "raw" for
no treatment, or "coag" for coagulated water). The function also requires additional water quality
parameters defined in \code{define_water} including TOC and UV254. The output is a new "water" class
with the calculated total chlorine value stored in the 'free_chlorine' or 'combined_chlorine' slot,
depending on what type of chlorine is dosed. When modeling residual concentrations
through a unit process, the U.S. EPA Water Treatment Plant Model applies a correction factor based on the
influent and effluent residual concentrations (see U.S. EPA (2001) equation 5-118) that may need to be
applied manually by the user based on the output.
}
\examples{
example_cl2 <- suppressWarnings(define_water(8, 20, 66, toc = 4, uv254 = 0.2)) \%>\%
  chemdose_chlordecay(cl2_dose = 2, time = 8)
}
