% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blend_waters.R
\name{blend_waters_once}
\alias{blend_waters_once}
\title{Apply `blend_waters` to a dataframe and output `water` slots as a dataframe}
\usage{
blend_waters_once(df, waters, ratios)
}
\arguments{
\item{df}{a data frame containing a water class column, which has already been computed using
\code{\link{define_water_chain}}}

\item{waters}{List of column names containing a water class to be blended}

\item{ratios}{List of column names or vector of blend ratios in the same order as waters. (Blend ratios must sum to 1)}
}
\value{
A data frame with blended water quality parameters.
}
\description{
This function allows \code{\link{blend_waters}} to be added to a piped data frame.
}
\details{
The data input comes from a `water` class column, initialized in \code{\link{define_water}} or \code{\link{balance_ions}}.
The `water` class columns to use in the function are specified as function arguments. Ratios may be input
as columns with varied ratios (in this case, input column names in the function arguments), OR input as numbers directly.

tidywater functions cannot be added after this function because they require a `water` class input.

 For large datasets, using `fn_once` or `fn_chain` may take many minutes to run. These types of functions use the furrr package
 for the option to use parallel processing and speed things up. To initialize parallel processing, use
 `plan(multisession)` or `plan(multicore)` (depending on your operating system) prior to your piped code with the
 `fn_once` or `fn_chain` functions. Note, parallel processing is best used when your code block takes more than a minute to run,
 shorter run times will not benefit from parallel processing.
}
\examples{

library(purrr)
library(furrr)
library(tidyr)
library(dplyr)

example_df <- water_df \%>\%
  define_water_chain() \%>\%
  balance_ions_chain() \%>\%
  chemdose_ph_chain(naoh = 22, output_water = "dosed") \%>\%
  mutate(
    ratios1 = .4,
    ratios2 = .6
  ) \%>\%
  blend_waters_once(waters = c("defined_water", "dosed"), ratios = c("ratios1", "ratios2"))

example_df <- water_df \%>\%
  define_water_chain() \%>\%
  balance_ions_chain() \%>\%
  chemdose_ph_chain(naoh = 22, output_water = "dosed") \%>\%
  blend_waters_once(waters = c("defined_water", "dosed", "balanced_water"), ratios = c(.2, .3, .5))

\donttest{
# Initialize parallel processing
plan(multisession, workers = 2) # Remove the workers argument to use all available compute
example_df <- water_df \%>\%
  define_water_chain() \%>\%
  balance_ions_chain() \%>\%
  chemdose_ph_chain(naoh = 22, output_water = "dosed") \%>\%
  blend_waters_once(waters = c("defined_water", "dosed", "balanced_water"), ratios = c(.2, .3, .5))

# Optional: explicitly close multisession processing
plan(sequential)
}

}
\seealso{
\code{\link{blend_waters}}
}
