% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{tidyplot}
\alias{tidyplot}
\title{Create a new tidyplot}
\usage{
tidyplot(data, ..., width = 50, height = 50, dodge_width = NULL)
}
\arguments{
\item{data}{A tidy \code{data.frame} to use for plotting.}

\item{...}{Mappings for the \code{x} axis, \code{y} axis and \code{color}, see examples. Additional argument are passed to \code{ggplot2::aes()}.}

\item{width}{Width of the plot area. Defaults to \code{50}.}

\item{height}{Height of the plot area. Defaults to \code{50}.}

\item{dodge_width}{For adjusting the distance between grouped objects. Defaults
to \code{0.8} for plots with at least one discrete axis and \code{0} for plots with two
continuous axes.}
}
\value{
A \code{tidyplot} object.
}
\description{
Create a new tidyplot
}
\examples{
study \%>\%
  tidyplot(x = treatment, y = score, color = treatment) \%>\%
  add_data_points_beeswarm()

study \%>\%
  tidyplot(x = group, y = score, color = dose) \%>\%
  add_mean_bar()

# Change plot area size
study \%>\%
  tidyplot(x = treatment, y = score, color = treatment,
    width = 35, height = 35) \%>\%
  add_data_points_beeswarm()

# Change dodge_width
study \%>\%
  tidyplot(x = group, y = score, color = dose, dodge_width = 0.3) \%>\%
  add_mean_bar()

}
