% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_summary_statistics.R
\name{create_summary_statistics}
\alias{create_summary_statistics}
\title{Create Summary Statistics for Specified Variables}
\usage{
create_summary_statistics(
  data,
  ...,
  by = NULL,
  detail = FALSE,
  drop_na = FALSE
)
}
\arguments{
\item{data}{A data frame containing the variables to be summarized.}

\item{...}{Comma-separated list of unquoted variable names in the data frame
to summarize. These variables must be either numeric, integer, or logical.}

\item{by}{An optional unquoted variable name to group the data before
summarizing. If NULL (the default), summary statistics are computed across
all observations.}

\item{detail}{A logical flag indicating whether to compute detailed summary
statistics including additional quantiles. Defaults to FALSE, which
computes basic statistics (n, mean, sd, min, median, max). When TRUE,
additional quantiles (1\%, 5\%, 10\%, 25\%, 75\%, 90\%, 95\%, 99\%) are computed.}

\item{drop_na}{A logical flag indicating whether to drop missing values for
each variabl (default is FALSE).}
}
\value{
A tibble with summary statistics for each selected variable. If \code{by}
is specified, the output includes the grouping variable as well. Each row
represents a variable (and a group if \code{by} is used), and columns include
the computed statistics.
}
\description{
Computes a set of summary statistics for numeric and integer variables in a
data frame. This function allows users to select specific variables for
summarization and can calculate statistics for the whole dataset or within
groups specified by the \code{by} argument. Additional detail levels for quantiles
can be included.
}
\details{
The function first checks that all specified variables are of type
numeric, integer, or logical. If any variables do not meet this criterion,
the function stops and returns an error message indicating the non-conforming
variables.

The basic set of summary statistics includes the count of non-NA values (n),
mean, standard deviation (sd), minimum (min), median (q50), and maximum
(max). If \code{detail} is TRUE, the function also computes the 1st, 5th, 10th,
25th, 75th, 90th, 95th, and 99th percentiles.

Summary statistics are computed for each variable specified in \code{...}. If a
\code{by} variable is provided, statistics are computed within each level of the
\code{by} variable.
}
