test_that("seg_cpt works", {
  x <- segment(DataCPSim)
  expect_s3_class(x, "tidycpt")
  expect_s3_class(x$segmenter, "seg_cpt")
  expect_s3_class(as.ts(x), "ts")
  expect_s3_class(augment(x), "grouped_ts")
  expect_s3_class(tidy(x), "tbl_df")
  expect_equal(nrow(tidy(x)), 1)
  suppressWarnings(expect_s3_class(glance(x), "tbl_df"))
  expect_type(changepoints(x), "integer")
  expect_equal(length(changepoints(x)), 0)  
  expect_true(is_segmenter(x$segmenter))
  expect_true(is_model(x$model))

  y <- segment(DataCPSim, method = "manual", tau = c(826))
  expect_s3_class(y, "tidycpt")
  expect_s3_class(y$segmenter, "seg_cpt")
  expect_s3_class(as.ts(y), "ts")
  expect_s3_class(augment(y), "grouped_ts")
  expect_s3_class(tidy(y), "tbl_df")
  expect_equal(nrow(tidy(y)), 2)
  expect_s3_class(glance(y), "tbl_df")
  expect_type(changepoints(y), "integer")
  expect_equal(length(changepoints(y)), 1)
  expect_type(fitness(y$segmenter), "double")

  z <- segment(DataCPSim, method = "manual", tau = c(365, 826))
  expect_s3_class(z, "tidycpt")
  expect_s3_class(z$segmenter, "seg_cpt")
  expect_s3_class(as.ts(z), "ts")
  expect_s3_class(augment(z), "grouped_ts")
  expect_s3_class(tidy(z), "tbl_df")
  expect_equal(nrow(tidy(z)), 3)
  expect_s3_class(glance(z), "tbl_df")
  expect_type(changepoints(z), "integer")
  expect_equal(length(changepoints(z)), 2)
})
