% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distributions.R
\name{tfd_independent}
\alias{tfd_independent}
\title{Independent distribution from batch of distributions}
\usage{
tfd_independent(
  distribution,
  reinterpreted_batch_ndims = NULL,
  validate_args = FALSE,
  name = paste0("Independent", distribution$name)
)
}
\arguments{
\item{distribution}{The base distribution instance to transform. Typically an  instance of Distribution}

\item{reinterpreted_batch_ndims}{Scalar, integer number of rightmost batch dims  which
will be regarded as event dims. When NULL all but the first batch axis (batch axis 0)
will be transferred to event dimensions (analogous to tf$layers$flatten).}

\item{validate_args}{Logical, default FALSE. When TRUE distribution parameters are checked
for validity despite possibly degrading runtime performance. When FALSE invalid inputs may
silently render incorrect outputs. Default value: FALSE.}

\item{name}{The name for ops managed by the distribution.  Default value: Independent + distribution.name.}
}
\value{
a distribution instance.
}
\description{
This distribution is useful for regarding a collection of independent,
non-identical distributions as a single random variable. For example, the
\code{Independent} distribution composed of a collection of \code{Bernoulli}
distributions might define a distribution over an image (where each
\code{Bernoulli} is a distribution over each pixel).
}
\details{
More precisely, a collection of \code{B} (independent) \code{E}-variate random variables
(rv) \verb{\{X_1, ..., X_B\}}, can be regarded as a \verb{[B, E]}-variate random variable
\verb{(X_1, ..., X_B)} with probability
\code{p(x_1, ..., x_B) = p_1(x_1) * ... * p_B(x_B)} where \code{p_b(X_b)} is the
probability of the \code{b}-th rv. More generally \verb{B, E} can be arbitrary shapes.
Similarly, the \code{Independent} distribution specifies a distribution over
\verb{[B, E]}-shaped events. It operates by reinterpreting the rightmost batch dims as
part of the event dimensions. The \code{reinterpreted_batch_ndims} parameter
controls the number of batch dims which are absorbed as event dims;
\code{reinterpreted_batch_ndims <= len(batch_shape)}.  For example, the \code{log_prob}
function entails a \code{reduce_sum} over the rightmost \code{reinterpreted_batch_ndims}
after calling the base distribution's \code{log_prob}.  In other words, since the
batch dimension(s) index independent distributions, the resultant multivariate
will have independent components.

Mathematical Details

The probability function is,

\if{html}{\out{<div class="sourceCode">}}\preformatted{prob(x; reinterpreted_batch_ndims) =
 tf.reduce_prod(dist.prob(x), axis=-1-range(reinterpreted_batch_ndims))
}\if{html}{\out{</div>}}
}
\seealso{
For usage examples see e.g. \code{\link[=tfd_sample]{tfd_sample()}}, \code{\link[=tfd_log_prob]{tfd_log_prob()}}, \code{\link[=tfd_mean]{tfd_mean()}}.

Other distributions: 
\code{\link{tfd_autoregressive}()},
\code{\link{tfd_batch_reshape}()},
\code{\link{tfd_bates}()},
\code{\link{tfd_bernoulli}()},
\code{\link{tfd_beta_binomial}()},
\code{\link{tfd_beta}()},
\code{\link{tfd_binomial}()},
\code{\link{tfd_categorical}()},
\code{\link{tfd_cauchy}()},
\code{\link{tfd_chi2}()},
\code{\link{tfd_chi}()},
\code{\link{tfd_cholesky_lkj}()},
\code{\link{tfd_continuous_bernoulli}()},
\code{\link{tfd_deterministic}()},
\code{\link{tfd_dirichlet_multinomial}()},
\code{\link{tfd_dirichlet}()},
\code{\link{tfd_empirical}()},
\code{\link{tfd_exp_gamma}()},
\code{\link{tfd_exp_inverse_gamma}()},
\code{\link{tfd_exponential}()},
\code{\link{tfd_gamma_gamma}()},
\code{\link{tfd_gamma}()},
\code{\link{tfd_gaussian_process_regression_model}()},
\code{\link{tfd_gaussian_process}()},
\code{\link{tfd_generalized_normal}()},
\code{\link{tfd_geometric}()},
\code{\link{tfd_gumbel}()},
\code{\link{tfd_half_cauchy}()},
\code{\link{tfd_half_normal}()},
\code{\link{tfd_hidden_markov_model}()},
\code{\link{tfd_horseshoe}()},
\code{\link{tfd_inverse_gamma}()},
\code{\link{tfd_inverse_gaussian}()},
\code{\link{tfd_johnson_s_u}()},
\code{\link{tfd_joint_distribution_named_auto_batched}()},
\code{\link{tfd_joint_distribution_named}()},
\code{\link{tfd_joint_distribution_sequential_auto_batched}()},
\code{\link{tfd_joint_distribution_sequential}()},
\code{\link{tfd_kumaraswamy}()},
\code{\link{tfd_laplace}()},
\code{\link{tfd_linear_gaussian_state_space_model}()},
\code{\link{tfd_lkj}()},
\code{\link{tfd_log_logistic}()},
\code{\link{tfd_log_normal}()},
\code{\link{tfd_logistic}()},
\code{\link{tfd_mixture_same_family}()},
\code{\link{tfd_mixture}()},
\code{\link{tfd_multinomial}()},
\code{\link{tfd_multivariate_normal_diag_plus_low_rank}()},
\code{\link{tfd_multivariate_normal_diag}()},
\code{\link{tfd_multivariate_normal_full_covariance}()},
\code{\link{tfd_multivariate_normal_linear_operator}()},
\code{\link{tfd_multivariate_normal_tri_l}()},
\code{\link{tfd_multivariate_student_t_linear_operator}()},
\code{\link{tfd_negative_binomial}()},
\code{\link{tfd_normal}()},
\code{\link{tfd_one_hot_categorical}()},
\code{\link{tfd_pareto}()},
\code{\link{tfd_pixel_cnn}()},
\code{\link{tfd_poisson_log_normal_quadrature_compound}()},
\code{\link{tfd_poisson}()},
\code{\link{tfd_power_spherical}()},
\code{\link{tfd_probit_bernoulli}()},
\code{\link{tfd_quantized}()},
\code{\link{tfd_relaxed_bernoulli}()},
\code{\link{tfd_relaxed_one_hot_categorical}()},
\code{\link{tfd_sample_distribution}()},
\code{\link{tfd_sinh_arcsinh}()},
\code{\link{tfd_skellam}()},
\code{\link{tfd_spherical_uniform}()},
\code{\link{tfd_student_t_process}()},
\code{\link{tfd_student_t}()},
\code{\link{tfd_transformed_distribution}()},
\code{\link{tfd_triangular}()},
\code{\link{tfd_truncated_cauchy}()},
\code{\link{tfd_truncated_normal}()},
\code{\link{tfd_uniform}()},
\code{\link{tfd_variational_gaussian_process}()},
\code{\link{tfd_vector_diffeomixture}()},
\code{\link{tfd_vector_exponential_diag}()},
\code{\link{tfd_vector_exponential_linear_operator}()},
\code{\link{tfd_vector_laplace_diag}()},
\code{\link{tfd_vector_laplace_linear_operator}()},
\code{\link{tfd_vector_sinh_arcsinh_diag}()},
\code{\link{tfd_von_mises_fisher}()},
\code{\link{tfd_von_mises}()},
\code{\link{tfd_weibull}()},
\code{\link{tfd_wishart_linear_operator}()},
\code{\link{tfd_wishart_tri_l}()},
\code{\link{tfd_wishart}()},
\code{\link{tfd_zipf}()}
}
\concept{distributions}
