% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statistics.R
\name{confidence_interval_fisher}
\alias{confidence_interval_fisher}
\title{Confidence Interval around the Mean Direction of Circular Data after Fisher (1993)}
\usage{
confidence_interval_fisher(
  x,
  conf.level = 0.95,
  w = NULL,
  axial = TRUE,
  na.rm = TRUE,
  boot = FALSE,
  R = 1000L,
  quiet = FALSE
)
}
\arguments{
\item{x}{numeric vector. Values in degrees.}

\item{conf.level}{Level of confidence: \eqn{(1 - \alpha \%)/100}.
(\code{0.95} by default).}

\item{w}{(optional) Weights. A vector of positive numbers and of the same
length as \code{x}.}

\item{axial}{logical. Whether the data are axial, i.e. pi-periodical
(\code{TRUE}, the default) or directional, i.e. \eqn{2 \pi}-periodical (\code{FALSE}).}

\item{na.rm}{logical value indicating whether \code{NA} values in \code{x}
should be stripped before the computation proceeds.}

\item{boot}{logical. Force bootstrap estimation}

\item{R}{integer. number of bootstrap replicates}

\item{quiet}{logical. Prints the used estimation (parametric or bootstrap).}
}
\value{
list
}
\description{
For large samples (\code{n >=25}) i performs are parametric estimate based on
\code{\link[=sample_circular_dispersion]{sample_circular_dispersion()}}. For smaller size samples, it returns a
bootstrap estimate.
}
\examples{
# Example data from Davis (1986), pp. 316
finland_stria <- c(
  23, 27, 53, 58, 64, 83, 85, 88, 93, 99, 100, 105, 113,
  113, 114, 117, 121, 123, 125, 126, 126, 126, 127, 127, 128, 128, 129, 132,
  132, 132, 134, 135, 137, 144, 145, 145, 146, 153, 155, 155, 155, 157, 163,
  165, 171, 172, 179, 181, 186, 190, 212
)
confidence_interval_fisher(finland_stria, axial = FALSE)
confidence_interval_fisher(finland_stria, axial = FALSE, boot = TRUE)

data(san_andreas)
data("nuvel1")
PoR <- subset(nuvel1, nuvel1$plate.rot == "na")
sa.por <- PoR_shmax(san_andreas, PoR, "right")
confidence_interval_fisher(sa.por$azi.PoR, w = 1 / san_andreas$unc)
confidence_interval_fisher(sa.por$azi.PoR, w = 1 / san_andreas$unc, boot = TRUE)
}
\references{
N.I. Fisher (1993) Statistical Analysis of Circular Data, Cambridge University Press.
}
