% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/choices_selected.R
\name{choices_selected}
\alias{choices_selected}
\alias{is.choices_selected}
\title{Choices selected}
\usage{
choices_selected(
  choices,
  selected = if (inherits(choices, "delayed_data")) NULL else choices[1],
  keep_order = FALSE,
  fixed = FALSE
)

is.choices_selected(x)
}
\arguments{
\item{choices}{(\code{character}) vector of possible choices or \code{delayed_data} object.

See \code{\link[=variable_choices]{variable_choices()}} and \code{\link[=value_choices]{value_choices()}}.}

\item{selected}{(\code{character}) vector of preselected options, (\code{delayed_choices}) object
or (\code{delayed_data}) object.

If \code{delayed_data} object then \code{choices} must also be \code{delayed_data} object.
If not supplied it will default to the first element of \code{choices} if
\code{choices} is a vector, or \code{NULL} if \code{choices} is a \code{delayed_data} object.}

\item{keep_order}{(\code{logical}) In case of \code{FALSE} the selected variables will
be on top of the drop-down field.}

\item{fixed}{(\code{logical}) optional, whether to block user to select choices.}

\item{x}{(\code{choices_selected}) object to check.}
}
\value{
\code{choices_selected} returns list of \code{choices_selected}, encapsulating the specified
\code{choices}, \code{selected}, \code{keep_order} and \code{fixed}.

\code{is.choices_selected} returns \code{TRUE} if \code{x} inherits from a \code{choices_selected} object, \code{FALSE} otherwise.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Construct a single list containing available choices, the default selected value, and
additional settings such as to order the choices with the selected elements appearing first
or whether to block the user from making selections.

Can be used in UI input elements such as \code{\link[teal.widgets:optionalSelectInput]{teal.widgets::optionalSelectInput()}}.
}
\details{
Please note that the order of selected will always follow the order of choices. The \code{keep_order}
argument is set to false which will run the following code inside:

\if{html}{\out{<div class="sourceCode">}}\preformatted{choices <- c(selected, setdiff(choices, selected))
}\if{html}{\out{</div>}}

In case you want to keep your specific order of choices, set \code{keep_order} to \code{TRUE}.
}
\section{Functions}{
\itemize{
\item \code{is.choices_selected()}: Check if an object is a choices_selected class

}}
\examples{
library(shiny)
library(teal.widgets)

ADSL <- teal.data::rADSL
choices_selected(variable_choices(ADSL), "SEX")

# How to select nothing
# use an empty character
choices_selected(
  choices = c("", "A", "B", "C"),
  selected = ""
)

# How to allow the user to select nothing
# use an empty character
choices_selected(
  choices = c("A", "", "B", "C"),
  selected = "A"
)


# How to make Nothing the Xth choice
# just use keep_order
choices_selected(
  choices = c("A", "", "B", "C"),
  selected = "A",
  keep_order = TRUE
)


# How to give labels to selections
# by adding names - choices will be replaced by "name" in UI, not in code
choices_selected(
  choices = c("name for A" = "A", "Name for nothing" = "", "name for b" = "B", "name for C" = "C"),
  selected = "A"
)

# by using choices_labeled
# labels will be shown behind the choice
choices_selected(
  choices = choices_labeled(
    c("A", "", "B", "C"),
    c("name for A", "nothing", "name for B", "name for C")
  ),
  selected = "A"
)

# Passing a `delayed_data` object to `selected`
choices_selected(
  choices = variable_choices("ADSL"),
  selected = variable_choices("ADSL", subset = c("STUDYID"))
)

# Passing `delayed_choices` object - semantically identical objects:
choices_selected(choices = letters, selected = letters)
choices_selected(choices = letters, selected = all_choices())

choices_selected(
  choices = setNames(LETTERS[1:5], paste("Letter", LETTERS[1:5])),
  selected = "E"
)
choices_selected(
  choices = setNames(LETTERS[1:5], paste("Letter", LETTERS[1:5])),
  selected = last_choice()
)

# functional form (subsetting for factor variables only) of choices_selected
# with delayed data loading
choices_selected(variable_choices("ADSL", subset = function(data) {
  idx <- vapply(data, is.factor, logical(1))
  names(data)[idx]
}))

cs <- choices_selected(
  choices = c("A", "B", "C"),
  selected = "A"
)

ui <- fluidPage(
  optionalSelectInput(
    inputId = "id",
    choices = cs$choices,
    selected = cs$selected
  )
)

server <- function(input, output, session) {}
if (interactive()) {
  shinyApp(ui, server)
}
}
