% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_branch_index.R
\name{tar_branch_index}
\alias{tar_branch_index}
\title{Integer branch indexes}
\usage{
tar_branch_index(names, store = targets::tar_config_get("store"))
}
\arguments{
\item{names}{Character vector of branch names.}

\item{store}{Character of length 1, path to the
\code{targets} data store. Defaults to \code{tar_config_get("store")},
which in turn defaults to \verb{_targets/}.
When you set this argument, the value of \code{tar_config_get("store")}
is temporarily changed for the current function call.
See \code{\link[=tar_config_get]{tar_config_get()}} and \code{\link[=tar_config_set]{tar_config_set()}} for details
about how to set the data store path persistently
for a project.}
}
\value{
A named integer vector of branch indexes.
}
\description{
Get the integer indexes of individual branch names
within their corresponding dynamic branching targets.
}
\examples{
if (identical(Sys.getenv("TAR_EXAMPLES"), "true")) { # for CRAN
tar_dir({ # tar_dir() runs code from a temp dir for CRAN.
tar_script({
  library(targets)
  library(tarchetypes)
  list(
    tar_target(x, seq_len(4)),
    tar_target(y, 2 * x, pattern = map(x)),
    tar_target(z, y, pattern = map(y))
  )
}, ask = FALSE)
tar_make()
names <- c(
  tar_meta(y, children)$children[[1]][c(2, 3)],
  tar_meta(z, children)$children[[1]][2]
)
names
tar_branch_index(names) # c(2, 3, 2)
})
}
}
\seealso{
Other branching: 
\code{\link{tar_branch_names}()},
\code{\link{tar_branches}()},
\code{\link{tar_pattern}()}
}
\concept{branching}
