% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hilbert_transform.R
\name{hilbert_transform}
\alias{hilbert_transform}
\title{Return the Hilbert transform of a signal}
\usage{
hilbert_transform(x)
}
\arguments{
\item{x}{The signal vector to be buffered}
}
\value{
The "analytic signal," in other words the Hilbert transform of the input signal x
}
\description{
This function is used to compute the Hilbert transform of a signal. It is based on function HilbertTransform() from (defunct) package hht, which was modified from the EMD package by Donghoh Kim and Hee-Seok Oh (http://dasan.sejong.ac.kr/~dhkim/software.emd.html)
}
\examples{
timez <- seq(from = 0, by = 1/1024, to = 1)
x <- sin(2*pi*60*timez)
y <- hilbert_transform(x)
}
