readData <- function( Y_input, X_input, RandomSeed=99 ){
  
	set.seed(RandomSeed)
	
	if (is.null(Y_input)) stop("Y_input is NULL") 
	NA_Y_mat = is.na( Y_input )
	Y_input <- data.frame(Y_input)

	if (is.null(X_input)) stop("X_input is NULL") 
	NA_X_mat = is.na( X_input )
	X_input <- data.frame(X_input)
	
	n_sample = dim(Y_input)[[1]] ; p_Y = dim(Y_input)[[2]]
	Y_mat_std = array(0,c(n_sample,p_Y))
	mean_Y_input = sd_Y_input = rep(0,p_Y)
	for (l in 1:p_Y){
		mean_Y_input[l] = mean(Y_input[,l], na.rm=TRUE)
		sd_Y_input[l] = sd(Y_input[,l], na.rm=TRUE)
		Y_mat_std[,l] = ( Y_input[,l] - mean_Y_input[l] ) / sd_Y_input[l]
	}
	
	p_X = dim(X_input)[[2]] ; D_l_vec = rep(0,p_X)
	X_mat_std = array(0,c(n_sample,p_X))
	levels_X_input = list()
	for (l in 1:p_X){
		# unique_l = sort(unique(X_input[,l]))
	  levels_X_input[[l]] = unique_l = levels(X_input[,l])
		D_l_vec[l] = length(unique_l)
		for (i in 1:n_sample){
			if (is.na(X_input[i,l])){ 
				X_mat_std[i,l] = X_input[i,l]
			} else {
				X_mat_std[i,l] = which( X_input[i,l] == unique_l ) - 1
			}
		}		
	} # for (l)
	
	var_names <- list(y=names(Y_input), x=names(X_input))
	names(levels_X_input) <- names(X_input)
	HCMM_input = list(n_sample=n_sample, p_Y=p_Y, Y_mat_std=Y_mat_std, mean_Y_input=mean_Y_input, sd_Y_input=sd_Y_input, NA_Y_mat = NA_Y_mat, p_X=p_X, D_l_vec=D_l_vec, X_mat_std=X_mat_std, levels_X_input=levels_X_input, NA_X_mat = NA_X_mat, var_names = var_names)
	
	class(HCMM_input) <- "readData_passed"
	return(HCMM_input)	
	
} # readData <- function

createModel <- function(data_obj, max_R_S_K=c(30,50,20)){ # , r_i_vec, s_i_vec, k_i_vec
  
  if ( !is(data_obj, "readData_passed") ) stop("data_obj should be generated by 'readData' function") ;
  
  model <- new(modelobject, max_R_S_K)
  
  Y_mat = data_obj$Y_mat_std ; X_mat = data_obj$X_mat_std ; 
  Y_NA_mat = is.na(Y_mat) ; X_NA_mat = is.na(X_mat) ; 
  Y_mat[is.na(Y_mat)] = 0.0 ; X_mat[is.na(X_mat)] = 0 ;
  # print(head(Y_in)) ; print(head(X_in)) ; 
  model$Y_mat = as.matrix(Y_mat) ; model$.Y_NA_mat = as.matrix(Y_NA_mat) ; 
  model$X_mat = as.matrix(X_mat) ; model$.X_NA_mat = as.matrix(X_NA_mat) 
  model$.D_l_vec = data_obj$D_l_vec
  
  model$msg_level = 2
  # 0: errors; 1: error and warnings; 2: errors, warnings and info
  
  model$.Initialization() 
  
  return(model)
  
} # Initialize <- function

### multipleSyn 
multipleSyn <- function(data_obj, model_obj, n_burnin, m, interval_btw_Syn, show_iter=TRUE){
  
  int_print = min(200,floor(interval_btw_Syn/2)) ; 
  
  if ( !is(model_obj, "Rcpp_modelobject") ) stop("model_obj needs to be prepared by 'createModel' function") ;
  n_sample = dim(model_obj$Y_mat)[[1]] ; p_y = dim(model_obj$Y_mat)[[2]] ; p_x = dim(model_obj$X_mat)[[2]]
  r_i_cube = array(0,c(m,n_sample)) ; s_i_cube = array(0,c(m,n_sample)) ; k_i_cube = array(0,c(m,n_sample)) ;
  
  Synt_Y_list <- replicate(m, array(0, c(n_sample, p_y)), simplify=FALSE)
  Synt_X_list <- replicate(m, array(0, c(n_sample, p_x)), simplify=FALSE)
  
  total_iter = n_burnin + m * interval_btw_Syn
  
  count_iter = 0
  
  if (show_iter==TRUE){
    start_time = current_time = Sys.time(); message(paste0("Current time, ",current_time)) ; prev_time = current_time # 1.3.4
  }
  message( paste0("Total iteration = ", (total_iter) ) )
  message("Burn-in ..................................")
  
  if ( n_burnin > int_print ){
    n_repeat_burnin = floor( n_burnin / int_print ) ; resid_n = n_burnin - n_repeat_burnin * int_print ;
    for (i_repeat in 1:n_repeat_burnin){
      for (i_run in 1:int_print){
        model_obj$.Iterate()
        count_iter = count_iter + 1
      }
      current_time = Sys.time()
      if (show_iter==TRUE){
        int_time = round( as.numeric(difftime(current_time, prev_time, units = "mins")), 1 )
        message(paste("Current time, ",current_time))
        message(paste0("Iter=",(i_repeat*int_print),", ",int_time," min for previous ", int_print, " iterations"))
        cat("table(r_i_vec)=\n") ; print(table(model_obj$r_i_vec+1))
        cat("\ntable(s_i_vec)=\n") ; print(table(model_obj$s_i_vec+1))
        cat("\ntable(k_i_vec)=\n") ; print(table(model_obj$k_i_vec+1)); cat("\n")
      }
      prev_time = current_time
    } # for (i_repeat)
    if (resid_n>0){
      for (i_run in 1:resid_n){
        model_obj$.Iterate()
        count_iter = count_iter + 1
      }
    } 
  } else {
    for (i_run in 1:n_burnin){
      model_obj$.Iterate()
      count_iter = count_iter + 1
    }
  } # if (n_burn_in)
  
  message("Drawing completed datasets ............")
  
  for ( i_imp in 1:m ){
    
    ## Run (interval_btw_Syn) iterations for parameter updates ## 
    for (i_run in 1:interval_btw_Syn){
      model_obj$.Iterate()
      count_iter = count_iter + 1
    }
    
    ## Draw an imputed dataset for every (interval_btw_Syn) iterations ## 
     r_i_cube[i_imp,] = model_obj$r_i_vec+1 ; s_i_cube[i_imp,] = model_obj$s_i_vec+1 ; k_i_cube[i_imp,] = model_obj$k_i_vec+1
    
    # Synthetic dataset #
    
    model_obj$.Synthesis()
    
    for (i_sample in 1:n_sample){
      Synt_Y_list[[i_imp]][i_sample,] = data_obj$mean_Y_input + data_obj$sd_Y_input * model_obj$Synt_Y_mat[i_sample,]
    }
    for(l in 1:p_x){
      Synt_X_list[[i_imp]][,l] <- data_obj$levels_X_input[[l]][model_obj$Synt_X_mat[,l] + 1]
    }
    Synt_Y_list[[i_imp]] <- data.frame(Synt_Y_list[[i_imp]]); names(Synt_Y_list[[i_imp]]) <- data_obj$var_names$y
    Synt_X_list[[i_imp]] <- data.frame(Synt_X_list[[i_imp]]); names(Synt_X_list[[i_imp]]) <- data_obj$var_names$x
    for(l in 1:p_x){
      Synt_X_list[[i_imp]][,l] <- factor(Synt_X_list[[i_imp]][,l], levels=data_obj$levels_X_input[[l]])
    }
  
  } # for ( i_imp )
  
  Synthetic_result = list(Synt_Y_list = Synt_Y_list, Synt_X_list = Synt_X_list, r_i_cube = r_i_cube , s_i_cube = s_i_cube , k_i_cube = k_i_cube) # The last two objects are newly added

  message("Finished...............................")
  if (show_iter==TRUE){
    current_time = Sys.time(); message(paste("Current time,",current_time))
    message( paste0("Total time for the ",total_iter," iterations = ", round(current_time-start_time, 3) ) )
  }
  
  return(Synthetic_result)
  
} # multipleImp <- function

.Beta_cube_fn = function(data_obj, model_obj){
  
  Beta_with_std_y = model_obj$.Beta_cube
  p_y = dim(model_obj$.Beta_cube)[[1]] ; p_x_star = dim(model_obj$.Beta_cube)[[2]] ; R = dim(model_obj$.Beta_cube)[[3]]
  mean_y = data_obj$mean_Y_input ; sd_y = data_obj$sd_Y_input
  
  Beta_orig = Beta_with_std_y
  for ( r in 1:R ){
    l = 1
    Beta_orig[,l,r] = mean_y + sd_y * Beta_with_std_y[,l,r] # mean_y should be included. it is tested
    for ( l in 2:p_x_star){
      Beta_orig[,l,r] = sd_y * Beta_with_std_y[,l,r] 	
    } # for (l)
  } # for (r)
  
  return(Beta_orig)
  
} # Beta_cube_orig_scale

