% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eavesdropper_2D.R
\name{eavesdropper_2D}
\alias{eavesdropper_2D}
\title{Eavesdrop two continuous variables on a bivariate plot.}
\arguments{
\item{eavesdrop}{A vector of two variables to track on a bivariate plot. For
example, \code{eavesdrop = c(A, B)} would result on A being plotted on X-axis
(independent variable) and B on Y-axis (dependent variable).}

\item{minimum}{A vector of the two minimum values of variables in \code{eavesdrop}. For
example, \code{eavesdrop = c(A, B)} then \code{minimum = c(C, D)} are the
minimum values of A and B, respectively. They define plot boundaries.}

\item{maximum}{A vector of the two maximum values of variables in \code{eavesdrop}. For
example, \code{eavesdrop = c(A, B)} then \code{maximum = c(C, D)} are the
maximum values of A and B, respectively. They define plot boundaries.}

\item{label}{A vector of two short strings designating labels/captions
for each variable used in \code{eavesdrop}.}

\item{size}{A number used to designate the size (magnification) of the
widget. The default is set to \code{1} which is 80 by 80 pixels. For
example, setting to \code{3} will results in a widget 3-times the default
size (240 by 240 pixels) and will occupy a grid area of 3 by 3.}

\item{placeOnGrid}{A row by column coordinate (e.g., \code{c(row-number, column-number)})
of a grid that designates the position to draw the widget on the
\code{switchboard}. Use \code{showGrid()} to help organize widget placement
on dashboard. The default places the first widget in pipe chain to
the \code{c(1, 1)} position, and all following on the same row stacked to
the right.}

\item{updates}{The number of times the widget is to be updated (e.g., when
it be modified/changed). The default updates the widget 100 times. Increase
number for smoother progress bar animation.}

\item{forget}{A time-delay in milliseconds for when displayed points on a
widget will be deleted.}

\item{delay}{Pause each update of the switchboard. Default has no delay,
values are in seconds (e.g., \code{delay = 0.01} results in 0.01 second
delay with each iteration).}

\item{plotRegression}{Display a switchboard-estimated regression line on a widget.}

\item{plotSampleSize}{Display the number items (N) displayed within a widget.}

\item{switch}{Display an on/off switch on a widget that controls widget updates.
When \code{TRUE} it will add the switch in the off-state on the switchboard.
The user must activate the switch to start the widget. The simulation proceeds
even if the switch in in the off-state.}
}
\value{
Nothing.
}
\description{
The \code{eavesdropper_2D} widget displays a bivariate window of data. The
plotted data have a half-life and are deleted once their timer (parameter
\code{forget}) expires. For the univariate version use \code{eavesdropper}.
The number of data points in the window can be throttled with \code{forget} or
\code{delay}. Options also include automatic regression (\code{plotRegression})
and an the sample size of the number of data points currently
displayed (\code{plotSampleSize}).
}
\section{Usage}{

   \preformatted{eavesdropper_2D(eavesdrop = c(NULL, NULL), minimum = c(1, 1),
   maximum = c(1, 1), label = c("", ""), size = 1, placeOnGrid = c(1, 1),
   updates = 100, forget = 400, delay = 0, plotRegression = FALSE,
   plotSampleSize = FALSE, switch = FALSE)}
}

\examples{
\dontrun{
     
     for (i in 1:10000) {
       x <- cos(i/400) 
       y <- sin(2 * i/400) / 2 
       switchboard(skip = 4) \%>\%
         eavesdropper_2D(c(x, y), minimum = c(-1, -1), maximum = c(1, 1), forget = 100)
     }
     switchboard_close()

}

}
\seealso{
Other moving windows: 
\code{\link{eavesdropper_X}()},
\code{\link{eavesdropper}()},
\code{\link{injector_2D}()},
\code{\link{injector_X}()},
\code{\link{injector}()}

Other eavesdroppers: 
\code{\link{benchmark}()},
\code{\link{counter_tally}()},
\code{\link{counter}()},
\code{\link{eavesdropper_X}()},
\code{\link{eavesdropper}()},
\code{\link{injector_2D}()},
\code{\link{injector_X}()},
\code{\link{injector}()},
\code{\link{number_pair}()},
\code{\link{number_quartet}()},
\code{\link{number_trio}()},
\code{\link{number}()},
\code{\link{progress_benchmark}()}
}
\concept{eavesdroppers}
\concept{moving windows}
