% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/control_switch.R
\name{control_switch}
\alias{control_switch}
\title{A switch to toggle on/off a simulation variable.}
\arguments{
\item{inject}{String of the variable name to be modified/injected by the
switch widget. For example, \code{inject = "i"}. The variable should be in
boolean form (e.g., 0 or 1, FALSE or TRUE).}

\item{label}{A small caption/label for the widget.}

\item{size}{A number used to designate the size (magnification) of the
widget. The default is set to \code{1} which is 80 by 80 pixels. For
example, setting to \code{3} will results in a widget 3-times the default
size (240 by 240 pixels) and will occupy a grid area of 3 by 3.}

\item{placeOnGrid}{A row by column coordinate (e.g., \code{c(row-number, column-number)})
of a grid that designates the position to draw the widget on the
\code{switchboard}. Use \code{showGrid()} to help organize widget placement
on dashboard. The default places the first widget in pipe chain to
the \code{c(1, 1)} position, and all following on the same row stacked to
the right.}
}
\value{
Nothing.
}
\description{
The \code{control_switch} widget displays a switch to toggle the state (e.g., on or
off, TRUE or FALSE) of a simulation variable. A switch is blue when "on",
and gray when "off".
}
\section{Usage}{

   \preformatted{control_switch(inject = "", label = "", size = 1, placeOnGrid = c(1, 1))}
}

\examples{
\dontrun{

     varToSwitch <- 0
     for (i in 1:500) {
       switchboard(delay = 0.01) \%>\%
         control_switch("varToSwitch", label = "0 to 1") \%>\%
         number(varToSwitch)
     }
     switchboard_close()

}

}
\seealso{
Other injectors: 
\code{\link{control_slider_Y_pair}()},
\code{\link{control_slider_Y}()},
\code{\link{control_slider_pair}()},
\code{\link{control_slider}()},
\code{\link{control_switch_pair}()},
\code{\link{control_switch_trio}()},
\code{\link{injector_2D}()},
\code{\link{injector_X}()},
\code{\link{injector}()}
}
\concept{injectors}
