% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcmc2list.R
\name{mcmc2list}
\alias{mcmc2list}
\title{Convert mcmc.list posterior to list}
\usage{
mcmc2list(x, pars, collapse.chains = TRUE)
}
\arguments{
\item{x}{object of class \link[coda]{mcmc.list}.}

\item{pars}{vector of parameter names to extract.}

\item{collapse.chains}{return array with dimension for each chain?}
}
\description{
Convert `mcmc.list` posterior to named list of vectors or arrays.
}
\note{
If \code{collapse.chains = TRUE}, the last dimension of arrays will always 
  be samples from the posterior. If \code{collapse.chains = FALSE}, the last 
  dimension of arrays will be individual chains, and the one prior to that 
  will be samples from the posterior for each chain.
}
\seealso{
\link[base]{aperm} to transpose the array if necessary.   
  \link[base]{as.data.frame.table} to convert arrays to data.frames.
}
