% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/start_http_server.R
\name{start_http_server}
\alias{start_http_server}
\alias{startHttpServer}
\title{(Re)start an HTTP server in R}
\usage{
start_http_server(port = http_server_port(), name = http_server_name())

startHttpServer(port = http_server_port(), name = http_server_name())
}
\arguments{
\item{port}{port on which the server should run (both help and SciViews). By
default, it is port 8888. Note that this server runs only locally and can
only serve requests from 127.0.0.1 (because communication is not crypted).}

\item{name}{the name given to the SciViews server. By default, it is \code{R}.}
}
\value{
An integer indicating the port used.
}
\description{
Turn the default R help HTTP server into a RJSONp SciViews
server (while still serving help pages, of course).
}
\examples{
\dontrun{
library(svHttp)
# Try to start the HTTP server on default port with default name
res <- try(start_http_server(), silent = TRUE)
if (!inherits(res, "try-error")) {
  # Get the port
  http_server_port()

  # Get the name
  http_server_name()

  # Get the list of clients... empty, unless you connect a client in between
  http_server_clients()

}
# Stop the server now
 stop_http_server()
}
}
\seealso{
\code{\link[svSocket:start_socket_server]{svSocket::start_socket_server()}}
}
\concept{Interprocess communication}
\keyword{IO}
