% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/probability_epidemic.R
\name{probability_extinct}
\alias{probability_extinct}
\title{Calculate the probability a branching process will go extinct based on
R, k and initial cases}
\usage{
probability_extinct(
  R,
  k,
  num_init_infect,
  ind_control = 0,
  pop_control = 0,
  ...,
  offspring_dist
)
}
\arguments{
\item{R}{A \code{number} specifying the R parameter (i.e. average secondary cases
per infectious individual).}

\item{k}{A \code{number} specifying the  k parameter (i.e. overdispersion in
offspring distribution from fitted negative binomial).}

\item{num_init_infect}{An \code{integer} (or at least
\href{https://rlang.r-lib.org/reference/is_integerish.html}{"integerish"} if
stored as double) specifying the number of initial infections.}

\item{ind_control}{A \code{numeric} specifying the strength of individual-level
control measures. These control measures assume that infected individuals
do not produce any secondary infections with probability \code{ind_control},
thus increasing the proportion of cases that do not create any subsequent
infections. The control measure is between \code{0} (default) and \code{1} (maximum).}

\item{pop_control}{A \code{numeric} specifying the strength of population-level
control measures that reduce the transmissibility of all cases by a
constant factor. Between \code{0} (default) and \code{1} (maximum).}

\item{...}{<\code{\link[rlang:dyn-dots]{dynamic-dots}}> Named elements to replace
default optimisation settings. Currently only \code{"fit_method"} is accepted
and can be either \code{"optim"} (default) or \code{"grid"} for numerical
optimisation routine or grid search, respectively.}

\item{offspring_dist}{An \verb{<epiparameter>} object. An S3 class for working
with epidemiological parameters/distributions, see
\code{\link[epiparameter:epiparameter]{epiparameter::epiparameter()}}.}
}
\value{
A value with the probability of going extinct.
}
\description{
Calculates the probability a branching process will not causes
an epidemic and will go extinct. This is the complement of the probability
of a disease causing an epidemic (\code{\link[=probability_epidemic]{probability_epidemic()}}).
}
\examples{
probability_extinct(R = 1.5, k = 0.1, num_init_infect = 10)
}
\references{
Lloyd-Smith, J. O., Schreiber, S. J., Kopp, P. E., & Getz, W. M. (2005).
Superspreading and the effect of individual variation on disease emergence.
Nature, 438(7066), 355-359. \doi{10.1038/nature04153}
}
\seealso{
\code{\link[=probability_epidemic]{probability_epidemic()}}
}
