% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functionsStatistical.R
\name{measuresWithMissingData}
\alias{measuresWithMissingData}
\alias{meanNArm}
\alias{meanNArm,}
\alias{SE.meanNArm}
\alias{CI.meanNArm}
\title{Measures with missing data}
\usage{
meanNArm(x)

SE.meanNArm(x)

CI.meanNArm(x, gamma)
}
\arguments{
\item{x}{a vector of numbers, the sample data (mandatory);}

\item{gamma}{a confidence level for CI (default 0.95).}
}
\value{
the means, a measure of precision (SE) or an interval of precision
(CI) in the presence of missing data.
}
\description{
The following three functions can be used with missing data.
They return the mean, the standard error of the mean and the confidence
interval of the mean.Note that we hesitated to provide these functions: you
should deal with missing data prior to making your plot.
Also note that for repeated-measure design, only CA adjustment is available.
}
\examples{
# the confidence interval of the mean for default 95\% and 90\% confidence level
meanNArm( c(1,2,3, NA) )
SE.meanNArm( c(1,2,3, NA) )
CI.meanNArm( c(1,2,3, NA) )
CI.meanNArm( c(1,2,3, NA), gamma = 0.90)

}
\references{
\insertAllCited{}
}
