% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_vc.R
\name{calculate_vcs}
\alias{calculate_vcs}
\title{Extracts varying coefficient estimates (for SVC, TVC and STVC models).}
\usage{
calculate_vcs(input_data, model, terms)
}
\arguments{
\item{input_data}{the data used to create the GAM model in \code{data.frame}, \code{tibble} or \code{sf} format}

\item{model}{a GAM model with smooths created using the \code{mgcv} package}

\item{terms}{a vector of names starting with "Intercept" plus the names of the covariates used in the GAM model (these are the names of the variables in \code{data} )}
}
\value{
A \code{data.frame} of the input data and the coefficient and standard error estimates for each covariate.
}
\description{
Extracts varying coefficient estimates (for SVC, TVC and STVC models).
}
\examples{
library(dplyr)
library(mgcv)
# SVC
data(productivity)
input_data = productivity |> dplyr::filter(year == "1970") |> mutate(Intercept = 1)
gam.svc.mod = gam(privC ~ 0 + Intercept +
                  s(X, Y, bs = 'gp', by = Intercept) +
                  unemp + s(X, Y, bs = "gp", by = unemp) +
                  pubC + s(X, Y, bs = "gp", by = pubC),
                  data = input_data)
terms = c("Intercept", "unemp", "pubC")
svcs = calculate_vcs(input_data, gam.svc.mod, terms)
head(svcs)
}
