#' Behavioral Risk Factor Surveillance System 2013 (Subset)
#'
#' This data set is a small subset of BRFSS results from the 2013 survey, each row represents an individual respondent.
#'
#' @format A tbl_df with with 5000 rows and 6 variables:
#' \describe{
#'   \item{weight}{Weight in pounds.}
#'   \item{height}{Height in inches.}
#'   \item{sex}{Sex}
#'   \item{exercise}{Any exercise in the last 30 days}
#'   \item{fruit_per_day}{Number of servings of fruit consumed per day.}
#'   \item{vege_per_day}{Number of servings of dark green vegetables consumed per day.}
#' }
#' @source Centers for Disease Control and Prevention (CDC). Behavioral Risk Factor Surveillance System
#' Survey Data. Atlanta, Georgia: U.S. Department of Health and Human Services, Centers for
#' Disease Control and Prevention, 2013.
"brfss"
