% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createMegaEnv.R
\name{predict.megaEnv}
\alias{predict.megaEnv}
\title{Compute BLUPS based on a set of mega environments}
\usage{
\method{predict}{megaEnv}(
  object,
  ...,
  trials = names(object$TD),
  useYear = FALSE,
  engine = c("lme4", "asreml")
)
}
\arguments{
\item{object}{An object of class megaEnv.}

\item{...}{Further parameters passed to either \code{asreml} or \code{lmer}.}

\item{trials}{A character string specifying the trials to be analyzed. If
not supplied, all trials are used in the analysis.}

\item{useYear}{Should year be used for modeling (as years within
trials). If \code{TRUE}, \code{TD} should contain a column "year".}

\item{engine}{A character string specifying the engine used for modeling.}
}
\value{
A list consisting of two data.frames, \code{predictedValue}
containing BLUPs per genotype per mega environment and \code{standardError}
containing standard errors for those BLUPs.
}
\description{
This function calculates Best Linear Unbiased Predictors (BLUPS) and
associated standard errors based on a set of mega environments.
}
\examples{
## Compute mega environments for TDMaize.
geMegaEnv <- gxeMegaEnv(TD = TDMaize, trait = "yld")

## Compute BLUPS and standard errors for those mega environments.
megaEnvPred <- predict(geMegaEnv)
head(megaEnvPred$predictedValue)
head(megaEnvPred$standardError)

}
\seealso{
Other mega environments: 
\code{\link{gxeMegaEnv}()},
\code{\link{plot.megaEnv}()}
}
\concept{mega environments}
